/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.gem;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileMoveEvent;
import com.intellij.psi.PsiElement;
import com.intellij.util.Alarm;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.psi.c;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.gem.GemDataContext;
import org.jetbrains.plugins.ruby.gem.GemDependency;
import org.jetbrains.plugins.ruby.gem.GemsDataKeys;
import org.jetbrains.plugins.ruby.ruby.RubyUtil;
import org.jetbrains.plugins.ruby.ruby.interpret.PsiCallable;
import org.jetbrains.plugins.ruby.ruby.interpret.RCallArguments;
import org.jetbrains.plugins.ruby.ruby.interpret.RubyPsiInterpreter;
import org.jetbrains.plugins.ruby.ruby.lang.TextUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RFile;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyElementFactory;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.stringLiterals.RStringLiteral;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.stringLiterals.RWords;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RArray;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RAssignmentExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RListOfExpressions;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.RNameUtilCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.expressions.RAssignmentExpressionNavigator;
import org.jetbrains.plugins.ruby.utils.NamingConventions;
import org.yaml.snakeyaml.error.YAMLException;

public class GemSpecParser
implements Disposable {
    private static final Logger d;
    static final String PARSER_VERSION = "16";
    @NonNls
    static final String NAME_ATTRIBUTE = "name";
    @NonNls
    static final String VERSION_ATTRIBUTE = "version";
    @NonNls
    static final String AUTHORS_ATTRIBUTE = "authors";
    @NonNls
    static final String EMAIL_ATTRIBUTE = "email";
    @NonNls
    static final String HOMEPAGE_ATTRIBUTE = "homepage";
    @NonNls
    static final String SUMMARY_ATTRIBUTE = "summary";
    @NonNls
    static final String DESCRIPTION_ATTRIBUTE = "description";
    @NonNls
    static final String DEPENDENCIES_ATTRIBUTE = "add_dependency";
    @NonNls
    static final String RUNTIME_DEPENDENCIES_ATTRIBUTE = "add_runtime_dependency";
    @NonNls
    static final String DEVELOPMENT_DEPENDENCIES_ATTRIBUTE = "add_development_dependency";
    @NonNls
    static final String REQUIRE_PATHS = "require_paths";
    @NonNls
    static final String GIT_ATTRIBUTE = "git";
    @NonNls
    static final String REF_ATTRIBUTE = "ref";
    @NonNls
    static final String DOT_FREEZE_SUFFIX = ".freeze";
    @NonNls
    static final String FREEZE_SUFFIX = "\".freeze";
    private final VirtualFileListener b;
    private final Map<String, GemDataContext> e = new HashMap<String, GemDataContext>();
    private final Map<String, LocalFileSystem.WatchRequest> f = new HashMap<String, LocalFileSystem.WatchRequest>();
    private final Alarm c;
    @NonNls
    private static final Pattern a;
    private static final long g;

    @NotNull
    protected static String unfreezeQuoted(String valueText) {
        long l2 = g ^ 0x1F0F33F2D142L;
        String string = valueText.substring(1, valueText.length() - FREEZE_SUFFIX.length());
        if (string == null) {
            GemSpecParser.a(0);
        }
        return string;
    }

    protected static boolean isFrozenQuoted(String valueText) {
        long l2 = g ^ 0x3A914EC9BEB1L;
        return valueText.startsWith("\"") && valueText.endsWith(FREEZE_SUFFIX);
    }

    @Nullable
    protected static String unfreeze(@Nullable String valueText) {
        long l2 = g ^ 0x3F154CDDBBD4L;
        return valueText == null ? null : valueText.substring(0, valueText.length() - FREEZE_SUFFIX.length() + 1);
    }

    public GemSpecParser() {
        this.b = new VirtualFileListener(){
            private static final long a = com.jetbrains.python.psi.c.a(28944173979107823L, 539007579611319142L, MethodHandles.lookup().lookupClass()).a(5408518405105L);

            public void fileDeleted(@NotNull VirtualFileEvent event) {
                if (event == null) {
                    1.a(0);
                }
                GemSpecParser.this.e.remove(event.getFile().getPath());
            }

            public void beforeFileMovement(@NotNull VirtualFileMoveEvent event) {
                if (event == null) {
                    1.a(1);
                }
                GemSpecParser.this.e.remove(event.getFile().getPath());
            }

            private static /* synthetic */ void a(int n2) {
                Object[] objectArray;
                long l2 = a ^ 0xA660D916CBAL;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "event";
                objectArray2[1] = "org/jetbrains/plugins/ruby/gem/GemSpecParser$1";
                switch (n2) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "fileDeleted";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "beforeFileMovement";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        VirtualFileManager.getInstance().addVirtualFileListener(this.b, (Disposable)this);
        this.c = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)this);
    }

    public static GemSpecParser getInstance() {
        return (GemSpecParser)ServiceManager.getService(GemSpecParser.class);
    }

    @Nullable
    public GemDataContext getGemSpec(@Nullable VirtualFile gemFile, @Nullable VirtualFile specFile) {
        return this.getGemSpec(gemFile, specFile, false);
    }

    @Nullable
    public GemDataContext getGemSpec(@Nullable VirtualFile gemFile, @Nullable VirtualFile specFile, boolean isProjectGemSpec) {
        if (specFile == null || gemFile == null) {
            return null;
        }
        String string = specFile.getPath();
        if (!this.e.containsKey(string) || isProjectGemSpec) {
            this.e.put(string, GemSpecParser.a(gemFile, specFile, isProjectGemSpec));
            this.a(specFile);
        }
        return this.e.get(string);
    }

    @Nullable
    private static GemDataContext a(@NotNull VirtualFile virtualFile, @NotNull VirtualFile virtualFile2, boolean bl2) {
        if (virtualFile == null) {
            GemSpecParser.a(1);
        }
        if (virtualFile2 == null) {
            GemSpecParser.a(2);
        }
        Ref ref = new Ref();
        ApplicationManager.getApplication().runReadAction(() -> {
            long l2 = g ^ 0x7C6236959836L;
            try {
                String string = VfsUtilCore.loadText((VirtualFile)virtualFile2);
                string = string.replace("\r", "");
                GemDataContext gemDataContext = new GemDataContext();
                gemDataContext.putData(GemsDataKeys.SPEC_NAME, virtualFile2.getNameWithoutExtension());
                GemSpecParser.a(virtualFile2, gemDataContext);
                GemSpecParser.parseSpec(string, gemDataContext);
                Set set = (Set)GemsDataKeys.DEVELOPMENT_DEPENDENCIES.getData((DataContext)gemDataContext);
                Set set2 = (Set)GemsDataKeys.DEPENDENCIES.getData((DataContext)gemDataContext);
                if (set != null) {
                    if (bl2) {
                        if (set2 != null) {
                            set2.addAll(set);
                        } else {
                            gemDataContext.putData(GemsDataKeys.DEPENDENCIES, set);
                        }
                    } else if (set2 != null) {
                        set2.removeAll(set);
                    }
                }
                GemSpecParser.b(virtualFile, gemDataContext);
                String string2 = (String)GemsDataKeys.VERSION.getData((DataContext)gemDataContext);
                if (string2 != null && !a.matcher(string2).matches()) {
                    gemDataContext.putData(GemsDataKeys.VERSION, null);
                }
                ref.set((Object)gemDataContext);
            }
            catch (IOException iOException) {
                d.warn("Failed to read description", (Throwable)iOException);
            }
        });
        return (GemDataContext)ref.get();
    }

    static void parseSpec(String contents, @NotNull GemDataContext result) {
        if (result == null) {
            GemSpecParser.a(3);
        }
        GemSpecParser.parseRubySpec(contents, result);
        if (GemSpecParser.a(result)) {
            GemSpecParser.a(contents, result);
        }
    }

    private static boolean a(@NotNull GemDataContext gemDataContext) {
        if (gemDataContext == null) {
            GemSpecParser.a(4);
        }
        return StringUtil.isEmpty((String)((String)GemsDataKeys.NAME.getData((DataContext)gemDataContext)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean a(String string3, GemDataContext gemDataContext) {
        Object object2;
        long l2 = g ^ 0x51C05510E1ACL;
        Map map2 = null;
        try (ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string3.getBytes(StandardCharsets.UTF_8));){
            map2 = RubyUtil.loadYaml(byteArrayInputStream);
            if (map2 == null) {
                boolean bl2 = false;
                return bl2;
            }
        }
        catch (IOException iOException) {
            d.error((Throwable)iOException);
            return false;
        }
        catch (YAMLException yAMLException) {
            d.debug((Throwable)yAMLException);
            return false;
        }
        catch (RuntimeException runtimeException) {
            d.debug((Throwable)runtimeException);
        }
        if (map2 == null) return true;
        Object v2 = map2.get(NAME_ATTRIBUTE);
        gemDataContext.putData(GemsDataKeys.NAME, v2 != null ? v2.toString() : null);
        Map map3 = (Map)map2.get(VERSION_ATTRIBUTE);
        Object v3 = map3.get(VERSION_ATTRIBUTE);
        gemDataContext.putData(GemsDataKeys.VERSION, v3 != null ? v3.toString() : null);
        Object v4 = map2.get(EMAIL_ATTRIBUTE);
        gemDataContext.putData(GemsDataKeys.EMAIL, v4 != null ? v4.toString() : null);
        Object v5 = map2.get(HOMEPAGE_ATTRIBUTE);
        gemDataContext.putData(GemsDataKeys.HOMEPAGE, v5 != null ? v5.toString() : null);
        Object v6 = map2.get(SUMMARY_ATTRIBUTE);
        gemDataContext.putData(GemsDataKeys.SUMMARY, v6 != null ? v6.toString() : null);
        Object v7 = map2.get(AUTHORS_ATTRIBUTE);
        if (v7 instanceof List) {
            object2 = ((List)v7).stream().map(object -> object.toString()).reduce((string, string2) -> {
                long l2 = g ^ 0x65DB18786186L;
                return string + ", " + string2;
            }).orElse("");
            gemDataContext.putData(GemsDataKeys.AUTHORS, object2);
        } else if (v7 != null) {
            gemDataContext.putData(GemsDataKeys.AUTHORS, v7.toString());
        }
        object2 = map2.get(REQUIRE_PATHS);
        if (object2 instanceof List) {
            List list2 = ContainerUtil.map((Collection)((List)object2), object -> object.toString());
            gemDataContext.putData(GemsDataKeys.REQUIRE_PATHS, list2);
        } else if (object2 != null) {
            gemDataContext.putData(GemsDataKeys.REQUIRE_PATHS, Collections.singletonList(object2.toString()));
        }
        GemSpecParser.a(gemDataContext, map2.get("dependencies"), false);
        GemSpecParser.a(gemDataContext, map2.get("runtime_dependencies"), false);
        GemSpecParser.a(gemDataContext, map2.get("development_dependencies"), true);
        return true;
    }

    private static void a(GemDataContext gemDataContext, Object object2, boolean bl2) {
        if (object2 instanceof Map) {
            Set<GemDependency> set = GemSpecParser.a(gemDataContext, bl2);
            Map map2 = (Map)object2;
            for (Map.Entry entry : map2.entrySet()) {
                List list2;
                String string2 = entry.getKey().toString();
                Object v2 = entry.getValue();
                if (v2 instanceof String) {
                    list2 = ContainerUtil.map((Object[])((String)v2).split(","), string -> string.trim());
                } else if (v2 instanceof List) {
                    list2 = ContainerUtil.map((Collection)((List)v2), object -> object.toString().trim());
                } else {
                    return;
                }
                set.add(GemDependency.create(string2, ArrayUtilRt.toStringArray((Collection)list2)));
            }
        }
    }

    private static Set<GemDependency> a(GemDataContext gemDataContext, boolean bl2) {
        LinkedHashSet linkedHashSet;
        Set set = linkedHashSet = bl2 ? (LinkedHashSet)GemsDataKeys.DEVELOPMENT_DEPENDENCIES.getData((DataContext)gemDataContext) : (Set)GemsDataKeys.DEPENDENCIES.getData((DataContext)gemDataContext);
        if (linkedHashSet == null) {
            linkedHashSet = new LinkedHashSet();
            gemDataContext.putData(bl2 ? GemsDataKeys.DEVELOPMENT_DEPENDENCIES : GemsDataKeys.DEPENDENCIES, linkedHashSet);
        }
        return linkedHashSet;
    }

    static void parseRubySpec(String contents, GemDataContext result) {
        long l2 = g ^ 0x62879A15871BL;
        RFile rFile = RubyElementFactory.createRubyFile(ProjectManager.getInstance().getDefaultProject(), contents);
        if (rFile == null) {
            return;
        }
        RubyPsiInterpreter rubyPsiInterpreter = new RubyPsiInterpreter(true);
        final GemSpecCallable gemSpecCallable = new GemSpecCallable(result);
        rubyPsiInterpreter.registerCallable(new PsiCallable(){

            @Override
            public void processCall(RCallArguments arguments) {
                arguments.interpretBlock(gemSpecCallable);
            }
        }, "Gem::Specification.new");
        rubyPsiInterpreter.interpret((PsiElement)rFile, null);
    }

    private static void b(VirtualFile virtualFile, GemDataContext gemDataContext) {
        long l2 = g ^ 0x31DDDBD57B6CL;
        String string = (String)GemsDataKeys.VERSION.getData((DataContext)gemDataContext);
        if (string == null || !string.contains(RNameUtilCore.SYMBOL_DELIMITER)) {
            return;
        }
        VirtualFile virtualFile2 = virtualFile.findChild("lib");
        if (virtualFile2 == null) {
            gemDataContext.putData(GemsDataKeys.VERSION, null);
            return;
        }
        int n2 = string.lastIndexOf(RNameUtilCore.SYMBOL_DELIMITER);
        String string2 = NamingConventions.toUnderscoreCase(string, false) + ".rb";
        String string3 = string.substring(n2 + 2);
        VirtualFile virtualFile3 = virtualFile2.findFileByRelativePath(string2);
        if (virtualFile3 == null) {
            string2 = NamingConventions.toUnderscoreCase(string.substring(0, n2), false) + ".rb";
            virtualFile3 = virtualFile2.findFileByRelativePath(string2);
        }
        if (virtualFile3 == null) {
            gemDataContext.putData(GemsDataKeys.VERSION, null);
            return;
        }
        try {
            String string4 = VfsUtilCore.loadText((VirtualFile)virtualFile3);
            Pattern pattern = Pattern.compile("^\\s*" + string3 + "\\s*=\\s*['\"](.*)['\"].*$", 8);
            Matcher matcher = pattern.matcher(string4);
            if (matcher.find() && matcher.groupCount() > 0) {
                gemDataContext.putData(GemsDataKeys.VERSION, TextUtil.removeQuoting(matcher.group(1)));
            } else {
                gemDataContext.putData(GemsDataKeys.VERSION, null);
            }
        }
        catch (IOException iOException) {
            gemDataContext.putData(GemsDataKeys.VERSION, null);
            d.warn("Failed to read version file", (Throwable)iOException);
        }
    }

    private static void a(VirtualFile virtualFile, GemDataContext gemDataContext) {
        VirtualFile virtualFile2;
        long l2 = g ^ 0x69981C3790BDL;
        for (virtualFile2 = virtualFile.getParent(); virtualFile2 != null && virtualFile2.findChild(".git") == null; virtualFile2 = virtualFile2.getParent()) {
        }
        if (virtualFile2 == null) {
            return;
        }
        String string = virtualFile2.getName();
        int n2 = string.lastIndexOf(45);
        if (n2 == -1) {
            return;
        }
        String string2 = string.substring(n2 + 1);
        if (!GemSpecParser.a(string2)) {
            return;
        }
        gemDataContext.putData(GemsDataKeys.GIT, true);
        gemDataContext.putData(GemsDataKeys.REF, string2);
    }

    private static boolean a(@Nullable String string) {
        if (string == null || string.length() < 6) {
            return false;
        }
        for (int i10 = string.length() - 1; i10 >= 0; --i10) {
            if (StringUtil.isHexDigit((char)string.charAt(i10))) continue;
            return false;
        }
        return true;
    }

    @NotNull
    private static List<String> a(@NotNull RArray rArray) {
        if (rArray == null) {
            GemSpecParser.a(5);
        }
        List list2 = StreamEx.of(rArray.getElements()).map(rPsiElement -> GemSpecParser.isFrozenQuoted(rPsiElement.getText()) ? GemSpecParser.unfreezeQuoted(rPsiElement.getText()) : rPsiElement.getText()).map(string -> TextUtil.removeQuoting(string)).toList();
        if (list2 == null) {
            GemSpecParser.a(6);
        }
        return list2;
    }

    private void a(VirtualFile virtualFile) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        this.c.addRequest(() -> ApplicationManager.getApplication().runReadAction(() -> {
            LocalFileSystem.WatchRequest watchRequest;
            String string;
            VirtualFile virtualFile2 = virtualFile.getParent();
            String string2 = string = virtualFile2 != null ? virtualFile2.getPath() : null;
            if (string != null && !this.f.containsKey(string) && (watchRequest = LocalFileSystem.getInstance().addRootToWatch(VfsUtilCore.urlToPath((String)string), true)) != null) {
                this.f.put(string, watchRequest);
            }
        }), -1);
    }

    public void dispose() {
        LocalFileSystem.getInstance().removeWatchedRoots(this.f.values());
    }

    static {
        g = com.jetbrains.python.psi.c.a(-1873243042137954269L, 9112939804899493273L, MethodHandles.lookup().lookupClass()).a(232265611345015L);
        long l2 = g ^ 0x76A1219F7E3L;
        d = Logger.getInstance(GemSpecParser.class);
        a = Pattern.compile("([0-9]+(\\.[0-9A-z]+)*)");
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = g ^ 0x6CFDCDB4EF1AL;
        switch (n2) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n3 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/gem/GemSpecParser";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gemFile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "array";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "unfreezeQuoted";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/gem/GemSpecParser";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "parseArrayOfStrings";
                break;
            }
        }
        switch (n2) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "parseGemSpec";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "parseSpec";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isIncomplete";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "parseArrayOfStrings";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class GemSpecCallable
    implements PsiCallable {
        private final GemDataContext a;
        private static final long b = com.jetbrains.python.psi.c.a(-7372683064448397205L, 4590537130831407005L, MethodHandles.lookup().lookupClass()).a(95975776426319L);

        GemSpecCallable(GemDataContext spec) {
            this.a = spec;
        }

        @Override
        public void processCall(RCallArguments args) {
            RPsiElement rPsiElement;
            long l2 = b ^ 0x3E276CEF76A5L;
            RAssignmentExpression rAssignmentExpression = RAssignmentExpressionNavigator.getAssignmentByLeftPart(args.getCallElement());
            String string = args.getCommand();
            RPsiElement rPsiElement2 = rPsiElement = rAssignmentExpression != null ? rAssignmentExpression.getValue() : null;
            if (rPsiElement == null) {
                if (GemSpecCallable.a(string)) {
                    this.a(args);
                }
                return;
            }
            String string2 = rPsiElement.getText();
            if (Comparing.strEqual((String)GemSpecParser.NAME_ATTRIBUTE, (String)string)) {
                String string3;
                if (rPsiElement instanceof RStringLiteral) {
                    string3 = TextUtil.removeQuoting(string2);
                } else {
                    int n2;
                    String string4;
                    string3 = string4 = (String)GemsDataKeys.SPEC_NAME.getData((DataContext)this.a);
                    if (string4 != null && (n2 = string4.lastIndexOf(45)) > 0) {
                        String string5 = string4.substring(n2 + 1);
                        if (string5.matches("([0-9]+(\\.[0-9A-z]+)*)")) {
                            string3 = string4.substring(0, n2);
                        } else if (GemSpecParser.isFrozenQuoted(string2)) {
                            string3 = GemSpecParser.unfreezeQuoted(string2);
                        }
                    }
                }
                this.a.putData(GemsDataKeys.NAME, string3);
            } else if (Comparing.strEqual((String)GemSpecParser.VERSION_ATTRIBUTE, (String)string)) {
                this.a.putData(GemsDataKeys.VERSION, TextUtil.removeQuoting(rPsiElement.getText()));
            } else if (Comparing.strEqual((String)GemSpecParser.EMAIL_ATTRIBUTE, (String)string)) {
                if (rPsiElement instanceof RArray) {
                    this.a.putData(GemsDataKeys.EMAIL, TextUtil.arrayToString((RArray)rPsiElement));
                } else {
                    this.a.putData(GemsDataKeys.EMAIL, TextUtil.removeQuoting(rPsiElement.getText()));
                }
            } else if (Comparing.strEqual((String)GemSpecParser.HOMEPAGE_ATTRIBUTE, (String)string)) {
                String string6 = rPsiElement.getText();
                string6 = GemSpecParser.isFrozenQuoted(string6) ? GemSpecParser.unfreezeQuoted(string6) : TextUtil.removeQuoting(string6);
                this.a.putData(GemsDataKeys.HOMEPAGE, string6);
            } else if (Comparing.strEqual((String)GemSpecParser.SUMMARY_ATTRIBUTE, (String)string)) {
                this.a.putData(GemsDataKeys.SUMMARY, TextUtil.removeQuoting(rPsiElement.getText()));
            } else if (Comparing.strEqual((String)GemSpecParser.AUTHORS_ATTRIBUTE, (String)string) && rPsiElement instanceof RArray) {
                this.a.putData(GemsDataKeys.AUTHORS, TextUtil.arrayToString((RArray)rPsiElement));
            } else if (Comparing.strEqual((String)GemSpecParser.REQUIRE_PATHS, (String)string)) {
                if (rPsiElement instanceof RArray) {
                    this.a.putData(GemsDataKeys.REQUIRE_PATHS, GemSpecParser.a((RArray)rPsiElement));
                } else if (rPsiElement instanceof RWords) {
                    ArrayList arrayList = new ArrayList();
                    TextUtil.flattern(rPsiElement, arrayList);
                    this.a.putData(GemsDataKeys.REQUIRE_PATHS, arrayList);
                } else {
                    this.a.putData(GemsDataKeys.REQUIRE_PATHS, Collections.singletonList("lib"));
                }
            }
        }

        private void a(RCallArguments rCallArguments) {
            long l2 = b ^ 0x1AD0C793C4E6L;
            boolean bl2 = GemSpecParser.DEVELOPMENT_DEPENDENCIES_ATTRIBUTE.equals(rCallArguments.getCommand());
            Set set = GemSpecParser.a(this.a, bl2);
            List<RPsiElement> list2 = rCallArguments.getArguments();
            if (list2.size() > 0) {
                String string = list2.get(0).getText();
                if (string != null) {
                    string = string.replace(GemSpecParser.DOT_FREEZE_SUFFIX, "");
                }
                GemSpecCallable.a(TextUtil.removeQuoting(string), list2, set);
            }
        }

        private static void a(String string, List<RPsiElement> list2, Set<GemDependency> set) {
            Object object;
            ArrayList<String> arrayList = new ArrayList<String>();
            if (list2.size() == 2 && list2.get(1) instanceof RArray) {
                object = (RArray)list2.get(1);
                PsiElement[] psiElementArray = object.getChildren();
                if (psiElementArray.length == 0 || !(psiElementArray[0] instanceof RListOfExpressions)) {
                    set.add(GemDependency.any(string));
                    return;
                }
                RListOfExpressions rListOfExpressions = (RListOfExpressions)psiElementArray[0];
                for (RPsiElement rPsiElement : rListOfExpressions.getElements()) {
                    arrayList.add(TextUtil.removeQuoting(rPsiElement.getText()));
                }
            } else {
                int n2 = list2.size();
                for (int i10 = 1; i10 < n2; ++i10) {
                    RPsiElement rPsiElement = list2.get(i10);
                    if (!(rPsiElement instanceof RStringLiteral)) continue;
                    arrayList.add(TextUtil.removeQuoting(rPsiElement.getText()));
                }
            }
            Object object2 = object = arrayList.size() == 0 ? GemDependency.any(string) : GemDependency.create(string, arrayList.toArray(new String[0]));
            if (object != null) {
                set.add((GemDependency)object);
            }
        }

        private static boolean a(String string) {
            long l2 = b ^ 0x5A2088587BF2L;
            return Comparing.strEqual((String)string, (String)GemSpecParser.DEPENDENCIES_ATTRIBUTE) || Comparing.strEqual((String)string, (String)GemSpecParser.RUNTIME_DEPENDENCIES_ATTRIBUTE) || Comparing.strEqual((String)string, (String)GemSpecParser.DEVELOPMENT_DEPENDENCIES_ATTRIBUTE);
        }
    }
}

