/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.gem;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.PersistentLibraryKind;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.VersionComparatorUtil;
import com.jetbrains.python.psi.c;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import one.util.streamex.StreamEx;
import org.jdom.CDATA;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.IllegalDataException;
import org.jdom.Namespace;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.gem.GemAdditionalInfo;
import org.jetbrains.plugins.ruby.gem.GemDataContext;
import org.jetbrains.plugins.ruby.gem.GemDependency;
import org.jetbrains.plugins.ruby.gem.GemSpecParser;
import org.jetbrains.plugins.ruby.gem.GemUtil;
import org.jetbrains.plugins.ruby.gem.GemsDataKeys;
import org.jetbrains.plugins.ruby.library.RubyLibraryKind;
import org.jetbrains.plugins.ruby.version.management.rbenv.gemsets.RbenvGemsetManager;

public class GemInfo {
    private static final Logger B;
    public static final GemInfo[] EMPTY_ARRAY;
    @NonNls
    public static final String GEM_LIBRARY_SUFFIX = "[gem]";
    @NonNls
    private static final String F = "[path]";
    @NonNls
    private static final String l = "[path][gem]";
    @NonNls
    private static final Pattern I;
    @NonNls
    private static final String j = "gem";
    @NonNls
    private static final String p = "url";
    @NonNls
    private static final String C = "version";
    @NonNls
    private static final String m = "name";
    @NonNls
    private static final String r = "timestamp";
    @NonNls
    private static final String u = "readme";
    @NonNls
    private static final String H = "parser_version";
    @NonNls
    private static final String E = "git";
    @NonNls
    private static final String b = "ref";
    @NonNls
    private static final String z = "require_path";
    @NonNls
    private static final String v = "value";
    @NonNls
    private static final String k = "space";
    @NonNls
    private static final String q = "preserve";
    private static final String[] c;
    private static final Pattern s;
    private static final GemDependency[] a;
    @NotNull
    private final String e;
    @Nullable
    private final String y;
    @NotNull
    private final String G;
    private String f;
    private boolean A;
    private final GemAdditionalInfo h;
    private final GemDependency[] t;
    @Nullable
    private final Sdk d;
    private final boolean o;
    private VirtualFile w;
    private final boolean x;
    private boolean D;
    @Nullable
    private final String n;
    private final boolean i;
    @NotNull
    private final List<String> g;
    private static final long L;

    protected GemInfo(@NotNull String name, @Nullable String version, @NotNull String url, String readme, Set<GemDependency> dependencies, @Nullable Sdk sdk, boolean remote, GemAdditionalInfo additionalInfo, boolean isGit, @Nullable String ref, boolean fromPath, @NotNull List<String> requirePaths) {
        if (name == null) {
            GemInfo.a(0);
        }
        if (url == null) {
            GemInfo.a(1);
        }
        if (requirePaths == null) {
            GemInfo.a(2);
        }
        this.D = false;
        this.e = name;
        this.y = version;
        this.G = url;
        this.f = readme;
        this.d = sdk;
        this.o = remote;
        this.x = isGit;
        this.n = ref;
        this.i = fromPath;
        this.t = dependencies != null ? dependencies.toArray(new GemDependency[0]) : a;
        this.h = additionalInfo;
        this.g = requirePaths;
        assert (this.o || this.i || this.d != null);
    }

    @NotNull
    public String getName() {
        String string = this.e;
        if (string == null) {
            GemInfo.a(3);
        }
        return string;
    }

    @NotNull
    public String getVersion() {
        long l2 = L ^ 0x4BBB71FC231DL;
        String string = this.y != null ? this.y : StringUtil.notNullize((String)this.a(), (String)F);
        if (string == null) {
            GemInfo.a(4);
        }
        return string;
    }

    public boolean isLocalGitRepo() {
        return this.D;
    }

    public void setLocalGitRepo(boolean localGitRepo) {
        this.D = localGitRepo;
    }

    @Nullable
    private String a() {
        return this.n != null ? this.n.substring(0, Math.min(6, this.n.length())) : null;
    }

    @Nullable
    public String getRealVersion() {
        return this.y;
    }

    @NotNull
    public String getUrl() {
        String string = this.G;
        if (string == null) {
            GemInfo.a(5);
        }
        return string;
    }

    @Nullable
    public String getReadme() {
        if (this.f == null && !this.isRemote() && !this.A) {
            VirtualFile virtualFile = this.getFile();
            this.f = virtualFile != null ? GemUtil.getGemReadme(virtualFile) : null;
            this.A = true;
        }
        return this.f;
    }

    @NotNull
    public List<String> getRequirePaths() {
        List<String> list2 = this.g;
        if (list2 == null) {
            GemInfo.a(6);
        }
        return list2;
    }

    @NotNull
    public static List<GemInfo> create(@Nullable Sdk sdk, @NotNull VirtualFile gemFile) {
        if (gemFile == null) {
            GemInfo.a(7);
        }
        List<GemInfo> list2 = GemInfo.create(sdk, gemFile, false);
        if (list2 == null) {
            GemInfo.a(8);
        }
        return list2;
    }

    @NotNull
    public static List<GemInfo> create(@Nullable Sdk sdk, @NotNull VirtualFile gemFile, boolean fromPath) {
        if (gemFile == null) {
            GemInfo.a(9);
        }
        ArrayList<GemInfo> arrayList = new ArrayList<GemInfo>();
        GemInfo.a(sdk, gemFile, fromPath, arrayList);
        for (VirtualFile virtualFile : gemFile.getChildren()) {
            if (!virtualFile.isDirectory() || FileTypeManager.getInstance().isFileIgnored(virtualFile)) continue;
            GemInfo.a(sdk, virtualFile, fromPath, arrayList);
        }
        ArrayList<GemInfo> arrayList2 = arrayList;
        if (arrayList2 == null) {
            GemInfo.a(10);
        }
        return arrayList2;
    }

    private static void a(Sdk sdk, VirtualFile virtualFile, boolean bl2, List<GemInfo> list2) {
        GemDataContext gemDataContext = GemInfo.a(virtualFile);
        if (gemDataContext != null) {
            gemDataContext.putData(GemsDataKeys.SDK, sdk);
            gemDataContext.putData(GemsDataKeys.FROM_PATH, bl2);
            GemInfo gemInfo = GemInfo.create(gemDataContext, virtualFile.getUrl(), null);
            ContainerUtil.addIfNotNull(list2, (Object)gemInfo);
        }
    }

    public boolean isValid() {
        return this.getFile() != null;
    }

    @Nullable
    public VirtualFile getFile() {
        if (this.w == null || !this.w.isValid()) {
            this.w = VirtualFileManager.getInstance().findFileByUrl(this.G);
        }
        return this.w;
    }

    @Nullable
    public VirtualFile getLibFolder() {
        return GemUtil.findGemLibDirectory(this.getFile());
    }

    @NotNull
    public GemDependency asDependency() {
        GemDependency gemDependency = GemDependency.exact(this);
        if (gemDependency == null) {
            GemInfo.a(11);
        }
        return gemDependency;
    }

    public void createLibrary(LibraryTable.ModifiableModel model) {
        long l2 = L ^ 0x482DF9A7945BL;
        this.removeLibrary(model);
        String string = this.getLibraryName();
        LibraryEx libraryEx = (LibraryEx)model.createLibrary(string, (PersistentLibraryKind)RubyLibraryKind.INSTANCE);
        LibraryEx.ModifiableModelEx modifiableModelEx = libraryEx.getModifiableModel();
        B.debug(this.toString(), new Object[]{": ", "created library, configuring: ", libraryEx});
        List<VirtualFile> list2 = this.getValidRequirePaths();
        VirtualFile virtualFile = this.getFile();
        if (virtualFile != null) {
            for (VirtualFile virtualFile2 : virtualFile.getChildren()) {
                if (virtualFile2.isDirectory()) {
                    B.debug(this.toString(), new Object[]{": ", "adding class and source roots: ", virtualFile2});
                    modifiableModelEx.addRoot(virtualFile2.getUrl(), OrderRootType.CLASSES);
                    modifiableModelEx.addRoot(virtualFile2.getUrl(), OrderRootType.SOURCES);
                }
                if (list2.contains(virtualFile2) || !virtualFile2.isDirectory()) continue;
                B.debug(this.toString(), new Object[]{": ", "adding excluded root: ", virtualFile2});
                modifiableModelEx.addExcludedRoot(virtualFile2.getUrl());
            }
        }
        modifiableModelEx.commit();
        B.debug(this.toString(), new Object[]{": ", "commited library: ", libraryEx});
    }

    @Nullable
    private static GemDataContext a(VirtualFile virtualFile) {
        VirtualFile virtualFile2 = GemUtil.getSpecFile(virtualFile);
        if (virtualFile2 == null) {
            return null;
        }
        return GemSpecParser.getInstance().getGemSpec(virtualFile, virtualFile2);
    }

    public Element getState() {
        long l2 = L ^ 0x352A92982148L;
        Element element = new Element(j);
        element.setAttribute(p, this.G);
        element.setAttribute(m, this.e);
        if (this.y != null) {
            element.setAttribute(C, this.y);
        }
        element.setAttribute(r, GemInfo.b(this.getFile()));
        element.setAttribute(H, "16");
        Element element3 = this.h.getState();
        if (element3 != null) {
            element.addContent(element3);
        }
        for (GemDependency gemDependency : this.t) {
            element.addContent(gemDependency.getState());
        }
        if (this.f != null) {
            try {
                Element element4 = new Element(u);
                element4.setAttribute(k, q, Namespace.XML_NAMESPACE);
                element4.addContent((Content)new CDATA(this.f));
                element.addContent(element4);
            }
            catch (IllegalDataException illegalDataException) {
                B.warn("probably corrupt readme for gem " + this.getLibraryName());
            }
        }
        element.setAttribute(E, String.valueOf(this.x));
        if (this.n != null) {
            element.setAttribute(b, this.n);
        }
        this.g.stream().map(string -> {
            long l2 = L ^ 0x79A708A41FA8L;
            Element element = new Element(z);
            element.setAttribute(v, string);
            return element;
        }).forEach(element2 -> element.addContent(element2));
        return element;
    }

    private static String b(VirtualFile virtualFile) {
        VirtualFile virtualFile2 = GemUtil.getSpecFile(virtualFile);
        return String.valueOf(virtualFile2 != null ? virtualFile2.getTimeStamp() : 0L);
    }

    @Nullable
    public static GemInfo create(Sdk sdk, Element element2) {
        long l2 = L ^ 0x5CA624C45E9FL;
        if (Comparing.strEqual((String)element2.getName(), (String)j)) {
            String string = element2.getAttributeValue(p);
            VirtualFile virtualFile = VirtualFileManager.getInstance().findFileByUrl(string);
            if (virtualFile != null) {
                VirtualFile virtualFile2 = GemUtil.getSpecFile(virtualFile);
                if (virtualFile2 == null) {
                    return null;
                }
                String string2 = element2.getAttributeValue(r);
                long l3 = string2 != null ? Long.valueOf(string2) : 0L;
                String string3 = element2.getAttributeValue(H);
                if (virtualFile2.getTimeStamp() != l3 || VersionComparatorUtil.compare((String)string3, (String)"16") < 0) {
                    return null;
                }
                String string4 = element2.getAttributeValue(m);
                String string5 = element2.getAttributeValue(C);
                Element element3 = element2.getChild(u);
                String string6 = element3 != null ? (q.equals(element3.getAttributeValue(k, Namespace.XML_NAMESPACE)) ? element3.getText() : GemUtil.getGemReadme(virtualFile)) : null;
                GemAdditionalInfo gemAdditionalInfo = GemAdditionalInfo.create(element2.getChild("additional_info"));
                HashSet<GemDependency> hashSet = new HashSet<GemDependency>();
                List list2 = element2.getChildren("dependency");
                for (Element element4 : list2) {
                    hashSet.add(GemDependency.create(element4));
                }
                String string7 = element2.getAttributeValue(E);
                boolean bl2 = string7 != null && string7.equals("true");
                String string8 = element2.getAttributeValue(b);
                List<String> list3 = element2.getChildren(z).stream().map(element -> {
                    long l2 = L ^ 0x72DC714881B0L;
                    return element.getAttributeValue(v);
                }).collect(Collectors.toList());
                return new GemInfo(string4, string5, string, string6, hashSet, sdk, false, gemAdditionalInfo, bl2, string8, false, list3);
            }
        }
        return null;
    }

    @NotNull
    @NonNls
    public String getLibraryName() {
        String string;
        long l2 = L ^ 0x25056FD95EBL;
        if (this.i) {
            string = this.e + " (v" + this.getVersion() + ") " + l;
        } else {
            String string2 = this.getVersion();
            String string3 = this.a();
            string2 = this.isGit() ? (StringUtil.equals((CharSequence)string2, (CharSequence)string3) ? "@" + string3 : string2 + "@" + string3) : string2;
            String string4 = RbenvGemsetManager.fetchGemGemset(this);
            string4 = string4 == null ? "" : ", " + string4;
            string = this.e + " (v" + string2 + ", " + (this.d != null ? this.d.getName() : "") + string4 + ") " + GEM_LIBRARY_SUFFIX;
        }
        String string5 = string;
        if (string5 == null) {
            GemInfo.a(12);
        }
        return string5;
    }

    private static String b(String string) {
        return s.matcher(string).replaceAll("");
    }

    @Nullable
    public static Pair<String, String> getNameAndVersion(String libraryName) {
        long l2 = L ^ 0x723624D66265L;
        if (!GemInfo.isGemLibrary(libraryName)) {
            return null;
        }
        Matcher matcher = I.matcher(libraryName);
        if (matcher.matches()) {
            String string = matcher.group(1);
            String string2 = matcher.group(2);
            String[] stringArray = string2.split("@");
            if (stringArray.length == 0) {
                B.warn("split.length == 0: " + libraryName);
                return Pair.create((Object)string, (Object)"");
            }
            String string3 = StringUtil.isEmpty((String)stringArray[0]) && stringArray.length > 1 ? stringArray[1] : stringArray[0];
            return Pair.create((Object)string, (Object)string3);
        }
        B.warn("error matching gem name: " + libraryName);
        return null;
    }

    @Nullable
    public static String getSdkName(String libraryName) {
        long l2 = L ^ 0x756B1DEED577L;
        if (!GemInfo.isGemLibrary(libraryName)) {
            return null;
        }
        Matcher matcher = I.matcher(libraryName);
        if (matcher.matches()) {
            return matcher.group(3);
        }
        B.warn("error matching gem name: " + libraryName);
        return null;
    }

    public static boolean isGemLibrary(@Nullable String libraryName) {
        long l2 = L ^ 0x282604C9F6E1L;
        return libraryName != null && libraryName.endsWith(GEM_LIBRARY_SUFFIX);
    }

    public static boolean isPathGemLibrary(@Nullable String libraryName) {
        long l2 = L ^ 0x1E7541944F67L;
        return libraryName != null && libraryName.endsWith(l);
    }

    @NotNull
    public List<VirtualFile> getValidRequirePaths() {
        VirtualFile virtualFile;
        long l2 = L ^ 0x6F5DA5C9C729L;
        VirtualFile virtualFile2 = this.getFile();
        if (virtualFile2 == null || !virtualFile2.isValid()) {
            List<VirtualFile> list2 = Collections.emptyList();
            if (list2 == null) {
                GemInfo.a(13);
            }
            return list2;
        }
        List list3 = StreamEx.of(this.g).map(string -> virtualFile2.findFileByRelativePath(string)).nonNull().toList();
        if (list3.isEmpty() && (virtualFile = virtualFile2.findFileByRelativePath("lib")) != null && virtualFile.isDirectory()) {
            list3.add(virtualFile);
        }
        for (VirtualFile virtualFile3 : c) {
            VirtualFile virtualFile4 = virtualFile2.findFileByRelativePath((String)virtualFile3);
            if (virtualFile4 == null || !virtualFile4.isDirectory() || list3.contains(virtualFile4)) continue;
            list3.add(virtualFile4);
        }
        List list4 = list3;
        if (list4 == null) {
            GemInfo.a(14);
        }
        return list4;
    }

    @NotNull
    public GemAdditionalInfo getAdditionalInfo() {
        GemAdditionalInfo gemAdditionalInfo = this.h;
        if (gemAdditionalInfo == null) {
            GemInfo.a(15);
        }
        return gemAdditionalInfo;
    }

    public GemDependency[] getDependencies() {
        return this.t;
    }

    public boolean isRemote() {
        return this.o;
    }

    public String toString() {
        return this.getName() + "(" + this.getVersion() + ")";
    }

    @Nullable
    public Library getLibrary(LibraryTable.ModifiableModel model) {
        return model.getLibraryByName(this.getLibraryName());
    }

    @Nullable
    public String getRef() {
        return this.n;
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (!(o2 instanceof GemInfo)) {
            return false;
        }
        GemInfo gemInfo = (GemInfo)o2;
        if (!this.e.equals(gemInfo.e)) {
            return false;
        }
        if (this.y != null ? !this.y.equals(gemInfo.y) : gemInfo.y != null) {
            return false;
        }
        if (this.o && ((GemInfo)o2).o) {
            return true;
        }
        if (!this.G.equals(gemInfo.G)) {
            return false;
        }
        if (this.x != gemInfo.x) {
            return false;
        }
        return !(this.n != null ? !this.n.equals(gemInfo.n) : gemInfo.n != null);
    }

    public int hashCode() {
        int n2 = this.e.hashCode();
        n2 = 31 * n2 + (this.y != null ? this.y.hashCode() : 0);
        if (this.o) {
            return n2;
        }
        n2 = 31 * n2 + this.G.hashCode();
        n2 = 31 * n2 + (this.x ? 1 : 0);
        n2 = 31 * n2 + (this.n != null ? this.n.hashCode() : 0);
        return n2;
    }

    public boolean isGit() {
        return this.x;
    }

    public boolean isFromPath() {
        return this.i;
    }

    public void removeLibrary(LibraryTable.ModifiableModel model) {
        long l2 = L ^ 0x3A86E9199547L;
        Library library = model.getLibraryByName(this.getLibraryName());
        if (library != null) {
            B.debug(this.toString(), new Object[]{": ", "removing library: ", library});
            model.removeLibrary(library);
        }
    }

    @Contract(value="null,_,_->null")
    @Nullable
    public static GemInfo create(@Nullable GemDataContext specs, @NotNull String url, @Nullable String readme) {
        boolean bl2;
        long l2 = L ^ 0x8770776D3CBL;
        if (url == null) {
            GemInfo.a(16);
        }
        if (specs == null) {
            return null;
        }
        String string = (String)GemsDataKeys.NAME.getData((DataContext)specs);
        String string2 = (String)GemsDataKeys.VERSION.getData((DataContext)specs);
        GemAdditionalInfo gemAdditionalInfo = GemAdditionalInfo.create(specs);
        Set set = (Set)GemsDataKeys.DEPENDENCIES.getData((DataContext)specs);
        Sdk sdk = (Sdk)GemsDataKeys.SDK.getData((DataContext)specs);
        Boolean bl3 = (Boolean)GemsDataKeys.REMOTE.getData((DataContext)specs);
        Boolean bl4 = (Boolean)GemsDataKeys.GIT.getData((DataContext)specs);
        Boolean bl5 = (Boolean)GemsDataKeys.FROM_PATH.getData((DataContext)specs);
        String string3 = (String)GemsDataKeys.REF.getData((DataContext)specs);
        List<String> list2 = (List<String>)GemsDataKeys.REQUIRE_PATHS.getData((DataContext)specs);
        boolean bl6 = bl2 = bl5 != null && bl5 != false;
        if (string == null || string2 == null && string3 == null && !bl2) {
            B.debug("Unable to build gemInfo from: name=", new Object[]{string, " gemVersion=", string2, " ref=", string3, " isFromPath=", bl2});
            return null;
        }
        return new GemInfo(GemInfo.b(string), string2, GemInfo.b(url), readme != null ? readme : (String)GemsDataKeys.DESCRIPTION.getData((DataContext)specs), set, sdk, bl3 != null && bl3 != false, gemAdditionalInfo, bl4 != null && bl4 != false, string3, bl2, list2 != null ? list2 : Collections.singletonList("lib"));
    }

    @Nullable
    public Sdk getSdk() {
        return this.d;
    }

    public boolean isDefaultGem() {
        long l2 = L ^ 0x6E4A4D61EAACL;
        return StringUtil.endsWith((CharSequence)this.getAdditionalInfo().getSummary(), (CharSequence)" is bundled with Ruby");
    }

    static {
        L = com.jetbrains.python.psi.c.a(-2130339197074670432L, 2387374525859767289L, MethodHandles.lookup().lookupClass()).a(36858121150392L);
        long l2 = L ^ 0x2206991614E9L;
        B = Logger.getInstance(GemInfo.class);
        EMPTY_ARRAY = new GemInfo[0];
        I = Pattern.compile("(.+) \\(v([^,]*)(?:, (.*))?\\) (?:\\[path\\])?\\[gem\\]");
        c = new String[]{"app", "vendor", "features", "node_modules", "frameworks"};
        s = Pattern.compile("\u0000");
        a = new GemDependency[0];
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = L ^ 0x40C33EA19D8EL;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = m;
                break;
            }
            case 1: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = p;
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requirePaths";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/gem/GemInfo";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gemFile";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/gem/GemInfo";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getVersion";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getUrl";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getRequirePaths";
                break;
            }
            case 8: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "asDependency";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibraryName";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getValidRequirePaths";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdditionalInfo";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                break;
            }
            case 7: 
            case 9: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

