/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.gem;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.text.VersionComparatorUtil;
import com.jetbrains.python.psi.c;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jdom.Element;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.gem.GemInfo;
import org.jetbrains.plugins.ruby.rails.gems.FrozenGemInfo;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.RubyLanguageLevelPusher;
import org.jetbrains.plugins.ruby.ruby.sdk.LanguageLevel;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkSystemAccessor;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkUtil;
import org.jetbrains.plugins.ruby.ruby.sdk.jruby.JRubySdkUtil;

public class GemDependency
implements Comparable {
    private static final String i;
    public static final Pair<Bound, String> BOUND_ANY;
    @NonNls
    public static final String DEPENDENCY = "dependency";
    @NonNls
    public static final String NAME = "name";
    @NonNls
    public static final String VERSION = "version";
    @NonNls
    public static final String URL = "url";
    @NonNls
    public static final String LIB = "lib";
    @NonNls
    public static final String PLATFORM = "platform";
    @NonNls
    public static final String GIT = "git";
    @NonNls
    public static final String FROM_PATH = "path";
    @NonNls
    public static final String REF = "ref";
    @NonNls
    public static final String BOUND = "bound";
    @NonNls
    public static final String DO_REQUIRE = "doRequire";
    public static final String VERSION_PATTERN = "([0-9]+(\\.[0-9A-z]+)*)";
    @NonNls
    private static final Pattern n;
    @NonNls
    private static final Pattern o;
    @NonNls
    private static final Pattern p;
    private static final List<String> a;
    private static final List<String> c;
    private static final List<String> l;
    private final String e;
    private final List<Pair<Bound, String>> d;
    private final String b;
    @Nullable
    private final String j;
    private final boolean g;
    private final boolean k;
    @Nullable
    private final String[] f;
    private final boolean h;
    private final String m;
    private static final long q;

    public Element getState() {
        long l2 = q ^ 0x7DD59E5E240CL;
        Element element = new Element(DEPENDENCY);
        element.setAttribute(NAME, this.e);
        for (Pair<Bound, String> pair : this.d) {
            Element element2 = new Element(BOUND);
            element2.setAttribute(VERSION, (String)pair.second);
            element2.setAttribute(BOUND, ((Bound)((Object)pair.first)).name());
            element.addContent(element2);
        }
        if (this.b != null) {
            element.setAttribute(URL, this.b);
        }
        if (this.j != null) {
            element.setAttribute(LIB, this.j);
        }
        element.setAttribute(GIT, Boolean.toString(this.g));
        element.setAttribute(FROM_PATH, Boolean.toString(this.k));
        if (this.m != null) {
            element.setAttribute(REF, this.m);
        }
        if (this.f != null) {
            element.setAttribute(PLATFORM, this.a());
        }
        element.setAttribute(DO_REQUIRE, Boolean.toString(this.h));
        return element;
    }

    private String a() {
        assert (this.f != null);
        return StringUtil.join((String[])this.f, (String)",");
    }

    public static GemDependency create(Element element) {
        Object object;
        Object object2;
        Object object32;
        long l2 = q ^ 0x7D5734209D70L;
        String string = element.getAttributeValue(NAME);
        ArrayList<Pair<Bound, String>> arrayList = new ArrayList<Pair<Bound, String>>();
        for (Object object32 : element.getChildren(BOUND)) {
            object2 = (Element)object32;
            String string2 = object2.getAttributeValue(VERSION);
            object = Bound.valueOf(object2.getAttributeValue(BOUND));
            assert (object != null);
            arrayList.add(Pair.create((Object)object, (Object)string2));
        }
        String string3 = element.getAttributeValue(URL);
        object32 = element.getAttributeValue(LIB);
        object2 = element.getAttributeValue(GIT);
        boolean bl2 = object2 != null && ((String)object2).equals("true");
        object = element.getAttributeValue(FROM_PATH);
        boolean bl3 = object != null && ((String)object).equals("true");
        String string4 = element.getAttributeValue(REF);
        String string5 = element.getAttributeValue(DO_REQUIRE);
        boolean bl4 = string5 == null || !string5.equals("false");
        String[] stringArray = GemDependency.a(element);
        return new GemDependency(string, (List<Pair<Bound, String>>)arrayList, string3, (String)object32, bl2, string4, bl4, bl3, stringArray);
    }

    @Nullable
    private static String[] a(Element element) {
        long l2 = q ^ 0x56EA149C363L;
        String string = element.getAttributeValue(PLATFORM);
        return string != null ? string.split(",") : null;
    }

    public String getDescription() {
        long l2 = q ^ 0x4B7D6EFF6D77L;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getName());
        if (!this.isAny()) {
            stringBuilder.append(" (");
            if (!this.isExact()) {
                for (Pair<Bound, String> pair : this.d) {
                    if (pair != this.d.get(0)) {
                        stringBuilder.append(", ");
                    }
                    stringBuilder.append(((Bound)((Object)pair.first)).getOperator()).append(" ").append((String)pair.second);
                }
            } else {
                stringBuilder.append((String)this.getBounds().get((int)0).second);
            }
            stringBuilder.append(")");
        }
        return stringBuilder.toString();
    }

    public boolean isExact() {
        return this.d.size() == 1 && this.d.get((int)0).first == Bound.EQUAL;
    }

    public int compareTo(@NotNull Object o2) {
        if (o2 == null) {
            GemDependency.a(0);
        }
        return this.getVersionString().compareTo(((GemDependency)o2).getVersionString());
    }

    private GemDependency(@NotNull String name, @NotNull List<Pair<Bound, String>> bounds, @Nullable String url, @Nullable String lib, boolean git, String ref, boolean doRequire, boolean fromPath, @Nullable String[] platforms) {
        if (name == null) {
            GemDependency.a(1);
        }
        if (bounds == null) {
            GemDependency.a(2);
        }
        this.e = name;
        if (bounds.size() > 1) {
            Collections.sort(bounds, (pair, pair2) -> {
                int n2 = ((String)pair.second).compareTo((String)pair2.second);
                return n2 != 0 ? n2 : ((Bound)((Object)((Object)pair.first))).compareTo((Enum)pair2.first);
            });
        }
        this.d = Collections.unmodifiableList(bounds);
        this.b = url;
        this.j = lib;
        this.g = git;
        this.m = ref;
        this.h = doRequire;
        this.k = fromPath;
        this.f = platforms;
    }

    @NotNull
    public static GemDependency exact(@NotNull GemInfo gem) {
        if (gem == null) {
            GemDependency.a(3);
        }
        GemDependency gemDependency = GemDependency.any(gem.getName(), gem.isRemote() ? gem.getUrl() : null, null, gem.isGit(), gem.getRef(), true, false, null, (Pair<Bound, String>)Pair.create((Object)((Object)Bound.EQUAL), (Object)gem.getVersion()));
        if (gemDependency == null) {
            GemDependency.a(4);
        }
        return gemDependency;
    }

    public static GemDependency any(@NotNull @NonNls String name) {
        if (name == null) {
            GemDependency.a(5);
        }
        return GemDependency.any(name, null, null, false, null, true, false, null);
    }

    public static GemDependency any(@NotNull @NonNls String name, @NotNull Pair<Bound, String> bound) {
        if (name == null) {
            GemDependency.a(6);
        }
        if (bound == null) {
            GemDependency.a(7);
        }
        return GemDependency.any(name, null, null, false, null, true, false, null, bound);
    }

    public static GemDependency any(@NotNull @NonNls String name, @Nullable String[] platforms) {
        if (name == null) {
            GemDependency.a(8);
        }
        return GemDependency.any(name, null, null, false, null, true, false, platforms);
    }

    public static GemDependency any(@NotNull @NonNls String name, @Nullable String url, @Nullable String lib, boolean isGit, @Nullable String ref, boolean doRequire, boolean fromPath, @Nullable String[] platforms) {
        if (name == null) {
            GemDependency.a(9);
        }
        return GemDependency.any(name, url, lib, isGit, ref, doRequire, fromPath, platforms, BOUND_ANY);
    }

    @NotNull
    protected static GemDependency any(@NonNls @NotNull String name, @Nullable String url, @Nullable String lib, boolean isGit, @Nullable String ref, boolean doRequire, boolean fromPath, @Nullable String[] platforms, @NotNull Pair<Bound, String> bound) {
        if (name == null) {
            GemDependency.a(10);
        }
        if (bound == null) {
            GemDependency.a(11);
        }
        GemDependency gemDependency = new GemDependency(name, Collections.singletonList(bound), url, lib, isGit, ref, doRequire, fromPath, platforms);
        if (gemDependency == null) {
            GemDependency.a(12);
        }
        return gemDependency;
    }

    public boolean isAny() {
        return this.d.size() == 0 || this.d.size() == 1 && GemDependency.b(this.d.get(0));
    }

    private static boolean b(Pair<Bound, String> pair) {
        return pair.first == Bound.GREATER_OR_EQUAL && "0".equals(pair.second);
    }

    public static GemDependency equal(@NotNull String name, @Nullable String version) {
        if (name == null) {
            GemDependency.a(13);
        }
        Pair pair = Pair.create((Object)((Object)Bound.EQUAL), (Object)(version == null ? "0" : version));
        return GemDependency.any(name, null, null, false, null, true, false, null, (Pair<Bound, String>)pair);
    }

    @Nullable
    public static GemDependency create(@NotNull String name, String ... deps) {
        if (name == null) {
            GemDependency.a(14);
        }
        if (deps == null) {
            GemDependency.a(15);
        }
        return GemDependency.create(name, deps, null, null, false, null, true, false, null);
    }

    @Nullable
    public static GemDependency create(@NotNull String name, @NotNull String[] deps, @Nullable String url, @Nullable String lib, boolean isGit, @Nullable String ref, boolean doRequire, boolean fromPath, @Nullable String[] platforms) {
        if (name == null) {
            GemDependency.a(16);
        }
        if (deps == null) {
            GemDependency.a(17);
        }
        ArrayList<Pair<Bound, String>> arrayList = new ArrayList<Pair<Bound, String>>();
        for (String string : deps) {
            Object object;
            Object object2;
            Matcher matcher = n.matcher(string);
            if (matcher.matches()) {
                object2 = matcher.group(1);
                object = Bound.getBound(object2);
                String string2 = matcher.group(2);
                if (object != null) {
                    arrayList.add((Pair<Bound, String>)Pair.create((Object)object, (Object)string2));
                }
            }
            if ((matcher = o.matcher(string)).matches()) {
                object2 = Bound.EQUAL;
                object = matcher.group(1);
                arrayList.add((Pair<Bound, String>)Pair.create((Object)object2, (Object)object));
            }
            if (!(matcher = p.matcher(string)).matches() || (object = Bound.getBound(object2 = matcher.group(1))) == null) continue;
            arrayList.add((Pair<Bound, String>)Pair.create((Object)object, (Object)"0"));
        }
        return arrayList.size() == deps.length ? new GemDependency(name, arrayList, url, lib, isGit, ref, doRequire, fromPath, platforms) : null;
    }

    public String getName() {
        return this.e;
    }

    public List<Pair<Bound, String>> getBounds() {
        return this.d;
    }

    public String getVersionString() {
        long l2 = q ^ 0xA2A11B405CAL;
        StringBuilder stringBuilder = new StringBuilder();
        for (Pair<Bound, String> pair : this.d) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(((Bound)((Object)pair.first)).getOperator()).append(" ").append((String)pair.second);
        }
        return stringBuilder.toString();
    }

    @Nullable
    public String[] getPlatforms() {
        return this.f;
    }

    public String getRef() {
        return this.m;
    }

    public boolean isSatisfied(GemInfo gem) {
        String string;
        if (!Comparing.strEqual((String)this.e, (String)gem.getName())) {
            return false;
        }
        if (this.g && this.m != null) {
            return gem.isLocalGitRepo() || this.m.equals(gem.getRef());
        }
        if (!this.g && gem.isGit()) {
            return false;
        }
        if (this.k && this.b != null) {
            return SystemInfo.isMac || SystemInfo.isWindows ? StringUtil.startsWithIgnoreCase((String)gem.getUrl(), (String)this.b) : StringUtil.startsWith((CharSequence)gem.getUrl(), (CharSequence)this.b);
        }
        boolean bl2 = gem instanceof FrozenGemInfo;
        if (!this.k && gem.isFromPath() && !bl2) {
            return false;
        }
        String string2 = string = bl2 ? ((FrozenGemInfo)gem).getUnfrozenVersion() : gem.getVersion();
        return !this.b(string);
    }

    public boolean isUnsatisfied(String version) {
        return this.b(version);
    }

    private boolean b(String string) {
        for (Pair<Bound, String> pair : this.d) {
            if (GemDependency.compareVersions(string, (String)pair.second, (Bound)((Object)pair.first))) continue;
            return true;
        }
        return false;
    }

    public boolean isGit() {
        return this.g;
    }

    public boolean isFromPath() {
        return this.k;
    }

    public boolean doRequire() {
        return this.h;
    }

    public String getUrl() {
        return this.b;
    }

    @Contract(value="null -> false")
    public boolean isLocalProjectDependency(@Nullable Module module2) {
        return module2 != null && this.isLocalProjectDependency(module2.getProject());
    }

    @Contract(value="null -> false")
    public boolean isLocalProjectDependency(@Nullable Project project) {
        if (project == null) {
            return false;
        }
        return (Boolean)ReadAction.compute(() -> {
            VirtualFile virtualFile = this.getGemRootDirectory();
            return virtualFile != null && ProjectRootManager.getInstance((Project)project).getFileIndex().isInContent(virtualFile);
        });
    }

    @Nullable
    public VirtualFile getGemRootDirectory() {
        String string = this.getUrl();
        if (string == null) {
            return null;
        }
        return VirtualFileManager.getInstance().findFileByUrl(string);
    }

    @Nullable
    public String getLibScript() {
        return this.j;
    }

    public static boolean compareVersions(String versionToCheck, String version, Bound bound) {
        switch (bound) {
            case EQUAL: {
                return VersionComparatorUtil.compare((String)versionToCheck, (String)version) == 0;
            }
            case GREATER: {
                return VersionComparatorUtil.compare((String)versionToCheck, (String)version) > 0;
            }
            case GREATER_OR_EQUAL: {
                return VersionComparatorUtil.compare((String)versionToCheck, (String)version) >= 0;
            }
            case LATEST_IN_BRANCH: {
                String string = GemDependency.bump(version);
                return VersionComparatorUtil.compare((String)versionToCheck, (String)version) >= 0 && VersionComparatorUtil.compare((String)versionToCheck, (String)string) < 0;
            }
            case LESS: {
                return VersionComparatorUtil.compare((String)versionToCheck, (String)version) < 0;
            }
            case LESS_OR_EQUAL: {
                return VersionComparatorUtil.compare((String)versionToCheck, (String)version) <= 0;
            }
            case NOT_EQUAL: {
                return VersionComparatorUtil.compare((String)versionToCheck, (String)version) != 0;
            }
        }
        return false;
    }

    static String bump(String version) {
        int n2;
        long l2 = q ^ 0x639CA8B6EDC8L;
        String[] stringArray = version.split("\\.");
        StringBuilder stringBuilder = new StringBuilder();
        for (n2 = stringArray.length - 1; n2 >= 0 && GemDependency.a(stringArray[n2]); --n2) {
        }
        String string = n2 > 1 ? stringArray[n2 - 1] : stringArray[0];
        String string2 = GemDependency.succ(string);
        for (int i10 = 0; i10 < n2 - 1; ++i10) {
            stringBuilder.append(stringArray[i10]).append(".");
        }
        stringBuilder.append(string2).append(".snap");
        return stringBuilder.toString();
    }

    static String succ(String number) {
        StringBuilder stringBuilder = new StringBuilder(number.length());
        int n2 = 1;
        int n3 = 49;
        for (int i10 = number.length() - 1; i10 >= 0; --i10) {
            n3 = number.charAt(i10);
            if (Character.isLetter(n3)) {
                n2 = (n3 += n2 - 97) / 26;
                n3 = n3 % 26 + 97;
            } else if (Character.isDigit(n3)) {
                n2 = (n3 += n2 - 48) / 10;
                n3 = n3 % 10 + 48;
            }
            stringBuilder.append((char)n3);
        }
        if (n2 != 0) {
            stringBuilder.append((char)(Character.isLetter(n3) ? 97 : n2 + 48));
        }
        return stringBuilder.reverse().toString();
    }

    private static boolean a(String string) {
        for (int i10 = 0; i10 < string.length(); ++i10) {
            if (!Character.isLetter(string.charAt(i10))) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        GemDependency gemDependency = (GemDependency)o2;
        if (this.h != gemDependency.h) {
            return false;
        }
        if (this.k != gemDependency.k) {
            return false;
        }
        if (this.g != gemDependency.g) {
            return false;
        }
        if (this.d != null ? !this.d.equals(gemDependency.d) : gemDependency.d != null) {
            return false;
        }
        if (this.j != null ? !this.j.equals(gemDependency.j) : gemDependency.j != null) {
            return false;
        }
        if (!this.e.equals(gemDependency.e)) {
            return false;
        }
        if (this.m != null ? !this.m.equals(gemDependency.m) : gemDependency.m != null) {
            return false;
        }
        return !(this.b != null ? !this.b.equals(gemDependency.b) : gemDependency.b != null);
    }

    public int hashCode() {
        int n2 = this.e.hashCode();
        n2 = 31 * n2 + (this.d != null ? this.d.hashCode() : 0);
        n2 = 31 * n2 + (this.b != null ? this.b.hashCode() : 0);
        n2 = 31 * n2 + (this.j != null ? this.j.hashCode() : 0);
        n2 = 31 * n2 + (this.g ? 1 : 0);
        n2 = 31 * n2 + (this.k ? 1 : 0);
        n2 = 31 * n2 + (this.h ? 1 : 0);
        n2 = 31 * n2 + (this.m != null ? this.m.hashCode() : 0);
        return n2;
    }

    public String toString() {
        long l2 = q ^ 0x400B898FBC9CL;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("GemDependency");
        stringBuilder.append("{myName='").append(this.e).append('\'');
        stringBuilder.append(", myBounds=").append(this.d);
        stringBuilder.append(", myUrl='").append(this.b).append('\'');
        stringBuilder.append(", myLib='").append(this.j).append('\'');
        stringBuilder.append(", myIsGit=").append(this.g);
        stringBuilder.append(", myFromPath=").append(this.k);
        stringBuilder.append(", myPlatforms=").append(this.f == null ? "null" : Arrays.asList(this.f).toString());
        stringBuilder.append(", myDoRequire=").append(this.h);
        stringBuilder.append(", myRef='").append(this.m).append('\'');
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    public boolean canBeSatisfied() {
        return this.a(Interval.UNIVERSUM, 0);
    }

    private boolean a(Interval interval, int n2) {
        for (int i10 = n2; i10 < this.d.size(); ++i10) {
            Pair<Bound, String> pair = this.d.get(i10);
            Interval[] intervalArray = GemDependency.a(pair);
            if (intervalArray.length != 1) {
                return this.a(interval.intersect(intervalArray[0]), i10 + 1) || this.a(interval.intersect(intervalArray[1]), i10 + 1);
            }
            interval = interval.intersect(intervalArray[0]);
        }
        return !interval.isEmpty();
    }

    public boolean canEat(@NotNull GemDependency dependency) {
        if (dependency == null) {
            GemDependency.a(18);
        }
        if (!this.getName().equals(dependency.getName())) {
            return false;
        }
        if (dependency.isAny()) {
            return true;
        }
        if (this.isAny()) {
            return false;
        }
        if (this.getBounds().size() > 1 || dependency.getBounds().size() > 1) {
            return false;
        }
        Pair<Bound, String> pair = this.getBounds().get(0);
        Pair<Bound, String> pair2 = dependency.getBounds().get(0);
        Interval[] intervalArray = GemDependency.a(pair);
        Interval[] intervalArray2 = GemDependency.a(pair2);
        if (intervalArray.length != 1 || intervalArray2.length != 1) {
            return false;
        }
        return intervalArray[0].a(intervalArray2[0]);
    }

    public int size() {
        return this.d.size();
    }

    public boolean isSupportedBySdk(@Nullable Sdk sdk) {
        long l2 = q ^ 0x10F1B37F4518L;
        if (this.f != null) {
            if (sdk == null || Arrays.asList(this.f).containsAll(Arrays.asList("java", "ruby"))) {
                return false;
            }
            for (String string : this.f) {
                boolean bl2;
                String[] stringArray = string.split("_(?=\\d+)");
                String string2 = StringUtil.notNullize((String)stringArray[0]);
                LanguageLevel languageLevel = stringArray.length > 1 ? LanguageLevel.fromString("ruby" + stringArray[1]) : null;
                boolean bl3 = JRubySdkUtil.isJRubySDK(sdk) && a.contains(string2) || RubySdkUtil.isRubySDK(sdk) && c.contains(string2) || RubySdkSystemAccessor.notNullFrom(sdk).isWindows() && l.contains(string2);
                boolean bl4 = bl2 = languageLevel == null || RubyLanguageLevelPusher.getEffectiveLanguageLevel(sdk) == languageLevel;
                if (!bl3 || !bl2) continue;
                return true;
            }
            return false;
        }
        return !this.e.endsWith("19") || RubySdkUtil.isRuby19(sdk);
    }

    private static Interval[] a(Pair<Bound, String> pair) {
        long l2 = q ^ 0x39D274011478L;
        String string = (String)pair.second;
        Bound bound = (Bound)((Object)pair.first);
        switch (bound) {
            case EQUAL: {
                return new Interval[]{new Interval(string, true, string, true)};
            }
            case GREATER: {
                return new Interval[]{new Interval(string, false, i, false)};
            }
            case GREATER_OR_EQUAL: {
                return new Interval[]{new Interval(string, true, i, false)};
            }
            case LATEST_IN_BRANCH: {
                return new Interval[]{new Interval(string, true, GemDependency.bump(string), false)};
            }
            case LESS: {
                return new Interval[]{new Interval("0", true, string, false)};
            }
            case LESS_OR_EQUAL: {
                return new Interval[]{new Interval("0", true, string, true)};
            }
            case NOT_EQUAL: {
                return new Interval[]{new Interval("0", true, string, false), new Interval(string, false, i, false)};
            }
        }
        throw new IllegalArgumentException("unknown bound");
    }

    static /* synthetic */ String access$100() {
        return i;
    }

    static {
        q = com.jetbrains.python.psi.c.a(-8138250017080351249L, -3631407796067655179L, MethodHandles.lookup().lookupClass()).a(263444773816524L);
        long l2 = q ^ 0x1988428C6392L;
        i = Integer.valueOf(Integer.MAX_VALUE).toString();
        BOUND_ANY = Pair.create((Object)((Object)Bound.GREATER_OR_EQUAL), (Object)"0");
        n = Pattern.compile("^\\s*([^0-9\\s]*)\\s*([0-9]+(\\.[0-9A-z]+)*)\\s*$");
        o = Pattern.compile("^\\s*([0-9]+(\\.[0-9A-z]+)*)\\s*$");
        p = Pattern.compile("^\\s*([^0-9\\s]*)\\s*$");
        a = Arrays.asList("jruby", "java");
        c = Collections.singletonList("ruby");
        l = Arrays.asList("mswin", "mingw");
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = q ^ 0x16A2B4DF5C9EL;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 4: 
            case 12: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = NAME;
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bounds";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gem";
                break;
            }
            case 4: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/gem/GemDependency";
                break;
            }
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = BOUND;
                break;
            }
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deps";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = DEPENDENCY;
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/gem/GemDependency";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "exact";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "any";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "compareTo";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "exact";
                break;
            }
            case 4: 
            case 12: {
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "any";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "equal";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "canEat";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Interval {
        public static final Interval UNIVERSUM = new Interval("0", true, GemDependency.access$100(), false);
        private final String a;
        private final boolean d;
        private final String b;
        private final boolean c;

        Interval(String low, boolean lowIncluded, String high, boolean highIncluded) {
            this.a = low;
            this.d = lowIncluded;
            this.b = high;
            this.c = highIncluded;
        }

        boolean isEmpty() {
            int n2 = VersionComparatorUtil.compare((String)this.a, (String)this.b);
            return n2 > 0 || n2 == 0 && (!this.d || !this.c);
        }

        Interval intersect(Interval other) {
            String string = VersionComparatorUtil.max((String)this.a, (String)other.a);
            String string2 = VersionComparatorUtil.min((String)this.b, (String)other.b);
            return new Interval(string, this.b(other, string), string2, this.a(other, string2));
        }

        private boolean a(Interval interval, String string) {
            if (!this.b.equals(interval.b)) {
                return this.b.equals(string) ? this.c : interval.c;
            }
            return this.c && interval.c;
        }

        private boolean b(Interval interval, String string) {
            if (!this.a.equals(interval.a)) {
                return this.a.equals(string) ? this.d : interval.d;
            }
            return this.d && interval.d;
        }

        private boolean a(Interval interval) {
            return (interval.d || !this.d ? VersionComparatorUtil.compare((String)this.a, (String)interval.a) >= 0 : VersionComparatorUtil.compare((String)this.a, (String)interval.a) > 0) && (interval.c || !this.c ? VersionComparatorUtil.compare((String)this.b, (String)interval.b) <= 0 : VersionComparatorUtil.compare((String)this.b, (String)interval.b) < 0);
        }
    }

    public static final class Bound
    extends Enum<Bound> {
        public static final /* enum */ Bound EQUAL;
        public static final /* enum */ Bound NOT_EQUAL;
        public static final /* enum */ Bound LESS;
        public static final /* enum */ Bound GREATER;
        public static final /* enum */ Bound LESS_OR_EQUAL;
        public static final /* enum */ Bound GREATER_OR_EQUAL;
        public static final /* enum */ Bound LATEST_IN_BRANCH;
        private final String a;
        private static final /* synthetic */ Bound[] b;

        public static Bound[] values() {
            return (Bound[])b.clone();
        }

        public static Bound valueOf(String name) {
            return Enum.valueOf(Bound.class, name);
        }

        private Bound(String op) {
            this.a = op;
        }

        @Nullable
        public static Bound getBound(String op) {
            for (Bound bound : Bound.values()) {
                if (!bound.a.equals(op)) continue;
                return bound;
            }
            return null;
        }

        public String getOperator() {
            return this.a;
        }

        static {
            long l2 = com.jetbrains.python.psi.c.a(-7456348463309102107L, -4198231972844186469L, MethodHandles.lookup().lookupClass()).a(199387700624371L) ^ 0x5AFFFC15E666L;
            EQUAL = new Bound("=");
            NOT_EQUAL = new Bound("!=");
            LESS = new Bound("<");
            GREATER = new Bound(">");
            LESS_OR_EQUAL = new Bound("<=");
            GREATER_OR_EQUAL = new Bound(">=");
            LATEST_IN_BRANCH = new Bound("~>");
            b = new Bound[]{EQUAL, NOT_EQUAL, LESS, GREATER, LESS_OR_EQUAL, GREATER_OR_EQUAL, LATEST_IN_BRANCH};
        }
    }
}

