/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.console.config;

import com.intellij.execution.console.BaseConsoleExecuteActionHandler;
import com.intellij.execution.console.ConsoleExecuteAction;
import com.intellij.execution.console.ConsoleHistoryController;
import com.intellij.execution.console.ConsoleRootType;
import com.intellij.execution.console.LanguageConsoleView;
import com.intellij.execution.console.ProcessBackedConsoleExecuteActionHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.util.PathMappingSettings;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import com.jetbrains.python.psi.c;
import java.awt.Component;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.invoke.MethodHandles;
import java.nio.charset.StandardCharsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.console.RubyCodeExecutor;
import org.jetbrains.plugins.ruby.console.RubyConsoleRootType;
import org.jetbrains.plugins.ruby.console.RubyLanguageConsole;
import org.jetbrains.plugins.ruby.console.config.IrbRunConfiguration;
import org.jetbrains.plugins.ruby.console.config.ReloadAction;
import org.jetbrains.plugins.ruby.ruby.run.RubyConsoleProcessHandlerEx;
import org.jetbrains.plugins.ruby.ruby.run.RunnerUtil;

final class IrbRubyLanguageConsoleView
extends RubyLanguageConsole
implements RubyCodeExecutor {
    private final ProcessBackedConsoleExecuteActionHandler c;
    private final String f;
    private final PathMappingSettings d;
    private ProcessHandler b;
    private final String e;
    @Nullable
    private final Module a;
    private static final long h = com.jetbrains.python.psi.c.a(3471500489692088901L, 6857004319642281961L, MethodHandles.lookup().lookupClass()).a(271777513814603L);

    IrbRubyLanguageConsoleView(Project project, @NotNull IrbRunConfiguration config) {
        if (config == null) {
            IrbRubyLanguageConsoleView.b(0);
        }
        super(project, config.getName());
        this.a = config.getModule();
        this.e = config.getScriptPath();
        this.f = config.getScriptArgs();
        this.c = this.a(config.isRailsConsole());
        ConsoleExecuteAction consoleExecuteAction = new ConsoleExecuteAction((LanguageConsoleView)this, (BaseConsoleExecuteActionHandler)this.c);
        this.addCustomConsoleAction((AnAction)consoleExecuteAction);
        consoleExecuteAction.registerCustomShortcutSet(consoleExecuteAction.getShortcutSet(), this.getConsoleEditor().getComponent());
        Sdk sdk = config.getSdk();
        assert (sdk != null);
        this.d = RunnerUtil.getRunner(sdk, this.a).addDefaultMappings(config.getMappingSettings());
        if (config.isRailsConsole()) {
            ReloadAction reloadAction = new ReloadAction(this.c);
            this.addCustomConsoleAction(reloadAction);
            reloadAction.registerAt(this.getConsoleEditor().getComponent());
        }
        new UiNotifyConnector.Once((Component)((Object)this), (Activatable)new Activatable.Adapter(){

            public void showNotify() {
                new ConsoleHistoryController((ConsoleRootType)RubyConsoleRootType.getInstance(), "", (LanguageConsoleView)IrbRubyLanguageConsoleView.this).install();
                IdeFocusManager.getInstance((Project)IrbRubyLanguageConsoleView.this.getProject()).requestFocus((Component)IrbRubyLanguageConsoleView.this.getCurrentEditor().getContentComponent(), true);
            }
        });
    }

    public boolean canPause() {
        return false;
    }

    public void attachToProcess(ProcessHandler processHandler) {
        super.attachToProcess(processHandler);
        processHandler.addProcessListener((ProcessListener)new ProcessAdapter(){
            private static final long a = com.jetbrains.python.psi.c.a(515284476981555514L, -5293746131172315822L, MethodHandles.lookup().lookupClass()).a(181951611383521L);

            public void processTerminated(@NotNull ProcessEvent event) {
                if (event == null) {
                    2.a(0);
                }
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (IrbRubyLanguageConsoleView.this.getProject().isDisposed()) {
                        return;
                    }
                    IrbRubyLanguageConsoleView.this.setConsoleEditorEnabled(false);
                });
            }

            private static /* synthetic */ void a(int n2) {
                long l2 = a ^ 0x4AB6145E7854L;
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/plugins/ruby/console/config/IrbRubyLanguageConsoleView$2", "processTerminated"));
            }
        });
        if (processHandler instanceof RubyConsoleProcessHandlerEx) {
            ((RubyConsoleProcessHandlerEx)processHandler).setConsole(this);
        }
        this.c.setProcessHandler(processHandler);
        this.b = processHandler;
    }

    private ProcessBackedConsoleExecuteActionHandler a(final boolean bl2) {
        return new ProcessBackedConsoleExecuteActionHandler(null, false){
            private static final long a = com.jetbrains.python.psi.c.a(-8816862457545907064L, 6720785681958030821L, MethodHandles.lookup().lookupClass()).a(274401437920399L);

            public void processLine(@NotNull String line2) {
                long l2 = a ^ 0x1C8372FF24C7L;
                if (line2 == null) {
                    3.a(0);
                }
                if (bl2 && "reload!\n".startsWith(line2)) {
                    FileDocumentManager.getInstance().saveAllDocuments();
                }
                super.processLine(line2);
                IrbRubyLanguageConsoleView.this.inputSent(line2 + "\n");
            }

            private static /* synthetic */ void a(int n2) {
                long l2 = a ^ 0x278700CDE498L;
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "org/jetbrains/plugins/ruby/console/config/IrbRubyLanguageConsoleView$3", "processLine"));
            }
        };
    }

    @Override
    public boolean isIrbConsole(@NotNull Module module2, @NotNull String irbExecutable) {
        long l2 = h ^ 0x57A43C85D109L;
        if (module2 == null) {
            IrbRubyLanguageConsoleView.b(1);
        }
        if (irbExecutable == null) {
            IrbRubyLanguageConsoleView.b(2);
        }
        if (!module2.equals(this.a)) {
            return false;
        }
        return this.e.equalsIgnoreCase(irbExecutable) && (this.f.contains("--irb") || this.f.contains("--prompt")) || this.e.endsWith("/rails") && this.f.contains("console");
    }

    @Override
    public void executeCode(@NotNull Module module2, @NotNull Editor editor2, @NotNull VirtualFile file) throws IOException {
        String string;
        SelectionModel selectionModel;
        String string2;
        long l2 = h ^ 0x6E56227187CBL;
        if (module2 == null) {
            IrbRubyLanguageConsoleView.b(3);
        }
        if (editor2 == null) {
            IrbRubyLanguageConsoleView.b(4);
        }
        if (file == null) {
            IrbRubyLanguageConsoleView.b(5);
        }
        if (StringUtil.isEmptyOrSpaces((String)(string2 = (selectionModel = editor2.getSelectionModel()).getSelectedText()))) {
            FileDocumentManager.getInstance().saveDocument(editor2.getDocument());
            string = "load \"" + this.d.convertToRemote(file.getPath()) + "\"";
        } else {
            string = string2;
        }
        ProcessHandler processHandler = this.b;
        assert (processHandler != null);
        OutputStream outputStream2 = processHandler.getProcessInput();
        if (outputStream2 != null) {
            outputStream2.write((string + "\n").getBytes(StandardCharsets.UTF_8));
            outputStream2.flush();
        }
    }

    private static /* synthetic */ void b(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        long l2 = h ^ 0x7F7569E6BD8CL;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "irbExecutable";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/console/config/IrbRubyLanguageConsoleView";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isIrbConsole";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "executeCode";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

