/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.console;

import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.PlatformUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.psi.c;
import icons.RubyIcons;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.console.IrbUtil;
import org.jetbrains.plugins.ruby.console.config.IrbRunConfiguration;
import org.jetbrains.plugins.ruby.console.config.IrbRunConfigurationFactory;
import org.jetbrains.plugins.ruby.console.config.IrbRunConfigurationType;
import org.jetbrains.plugins.ruby.rails.model.RailsApp;
import org.jetbrains.plugins.ruby.ruby.RModuleUtil;
import org.jetbrains.plugins.ruby.ruby.actions.RubyScriptAction;
import org.jetbrains.plugins.ruby.ruby.run.configuration.RunConfigurationUtil;

public class RunIRBConsoleAction
extends RubyScriptAction
implements DumbAware {
    public static final List<String> SIMPLE_PROMPT;
    private static final long a;

    public RunIRBConsoleAction() {
        this.getTemplatePresentation().setIcon(RubyIcons.Ruby.Configuration.Ruby_script);
    }

    @Override
    public void update(@NotNull AnActionEvent e10) {
        if (e10 == null) {
            RunIRBConsoleAction.b(0);
        }
        Module module2 = RModuleUtil.getInstance().getModule(e10.getDataContext());
        e10.getPresentation().setVisible(module2 != null);
        Sdk sdk = module2 != null ? RModuleUtil.getInstance().findRubySdkForModule(module2) : null;
        boolean bl2 = sdk != null && IrbUtil.getIRBExecutable(sdk) != null;
        e10.getPresentation().setEnabled(bl2);
        if (!PlatformUtils.isRubyMine()) {
            e10.getPresentation().setVisible(bl2);
        }
    }

    @Override
    protected void doActionPerformed(@NotNull AnActionEvent e10) {
        long l2 = a ^ 0x794CC9061558L;
        if (e10 == null) {
            RunIRBConsoleAction.b(1);
        }
        Module module2 = RModuleUtil.getInstance().getModule(e10.getDataContext());
        assert (module2 != null) : "Module cannot be null here";
        Sdk sdk = RModuleUtil.getInstance().findRubySdkForModule(module2);
        assert (sdk != null) : "sdk is null";
        String string = IrbUtil.getIRBExecutable(sdk);
        assert (string != null) : "irb executable not found";
        ArrayList<String> arrayList = new ArrayList<String>(SIMPLE_PROMPT);
        ApplicationManager.getApplication().runReadAction(() -> {
            IrbRunConfigurationFactory irbRunConfigurationFactory = IrbRunConfigurationType.getInstance().getFactory();
            RunnerAndConfigurationSettings runnerAndConfigurationSettings = irbRunConfigurationFactory.createConfigurationSettings(module2, RunIRBConsoleAction.a(module2), string, ArrayUtilRt.toStringArray((Collection)arrayList), false);
            IrbRunConfiguration irbRunConfiguration = (IrbRunConfiguration)runnerAndConfigurationSettings.getConfiguration();
            RunIRBConsoleAction.a(module2, irbRunConfiguration);
            RunManager runManager = RunManager.getInstance((Project)module2.getProject());
            runManager.setTemporaryConfiguration(runnerAndConfigurationSettings);
            RunConfigurationUtil.executeConfiguration(runManager, runnerAndConfigurationSettings, null);
        });
    }

    private static void a(@NotNull Module module2, @NotNull IrbRunConfiguration irbRunConfiguration) {
        if (module2 == null) {
            RunIRBConsoleAction.b(2);
        }
        if (irbRunConfiguration == null) {
            RunIRBConsoleAction.b(3);
        }
        if (!StringUtil.isEmptyOrSpaces((String)irbRunConfiguration.getWorkingDirectory())) {
            return;
        }
        VirtualFile virtualFile = RunIRBConsoleAction.b(module2);
        if (virtualFile != null) {
            irbRunConfiguration.setWorkingDirectory(FileUtil.toSystemDependentName((String)virtualFile.getPath()));
        }
    }

    @Nullable
    private static VirtualFile b(@Nullable Module module2) {
        if (module2 == null) {
            return null;
        }
        RailsApp railsApp = RailsApp.fromModule(module2);
        if (railsApp != null) {
            return railsApp.getRailsApplicationRoot();
        }
        return RModuleUtil.getInstance().getFirstContentRoot(module2);
    }

    private static String a(@NotNull Module module2) {
        long l2 = a ^ 0x6D017D8F48CBL;
        if (module2 == null) {
            RunIRBConsoleAction.b(4);
        }
        return RBundle.message("irb.console", module2.getName());
    }

    static {
        a = c.a(1575466906852079519L, 5609731632041044307L, MethodHandles.lookup().lookupClass()).a(188409085718497L);
        long l2 = a ^ 0x61684BEC1DF2L;
        SIMPLE_PROMPT = ContainerUtil.immutableList((Object[])new String[]{"--prompt", "simple"});
    }

    private static /* synthetic */ void b(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        long l2 = a ^ 0x2CA030D9C8A0L;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runConfiguration";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/console/RunIRBConsoleAction";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "doActionPerformed";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "determineAndSetWorkDirectory";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getDefaultIrbConfigurationName";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

