/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.validation;

import com.intellij.lang.ASTNode;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.highlighting.PyHighlighter;
import com.jetbrains.python.psi.PyAnnotation;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyKeywordArgument;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.PyParameter;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.c;
import com.jetbrains.python.psi.impl.PyBuiltinCache;
import com.jetbrains.python.validation.PyAnnotator;
import java.lang.invoke.MethodHandles;

public class HighlightingAnnotator
extends PyAnnotator {
    public static final HighlightSeverity LOW_PRIORITY_HIGHLIGHTING;

    @Override
    public void visitPyParameter(PyParameter node) {
        PyFunction pyFunction = (PyFunction)PsiTreeUtil.getParentOfType((PsiElement)node, PyFunction.class);
        if (pyFunction != null) {
            TextAttributesKey textAttributesKey;
            TextAttributesKey textAttributesKey2 = textAttributesKey = node.isSelf() ? PyHighlighter.PY_SELF_PARAMETER : PyHighlighter.PY_PARAMETER;
            if (HighlightingAnnotator.a(node)) {
                this.addHighlightingAnnotation((PsiElement)node, textAttributesKey);
            } else {
                this.addHighlightingAnnotation(node.getFirstChild(), textAttributesKey);
            }
        }
    }

    private static boolean a(PyParameter pyParameter) {
        if (pyParameter instanceof PyNamedParameter) {
            PyNamedParameter pyNamedParameter = (PyNamedParameter)pyParameter;
            return pyNamedParameter.isPositionalContainer() || pyNamedParameter.isKeywordContainer();
        }
        return false;
    }

    @Override
    public void visitPyReferenceExpression(PyReferenceExpression node) {
        PyNamedParameter pyNamedParameter;
        PyFunction pyFunction;
        String string = node.getReferencedName();
        if (!node.isQualified() && string != null && (pyFunction = (PyFunction)PsiTreeUtil.getParentOfType((PsiElement)node, PyFunction.class)) != null && (pyNamedParameter = pyFunction.getParameterList().findParameterByName(string)) != null) {
            TextAttributesKey textAttributesKey = pyNamedParameter.isSelf() ? PyHighlighter.PY_SELF_PARAMETER : PyHighlighter.PY_PARAMETER;
            this.addHighlightingAnnotation((PsiElement)node, textAttributesKey);
        }
    }

    @Override
    public void visitPyKeywordArgument(PyKeywordArgument node) {
        ASTNode aSTNode = node.getKeywordNode();
        if (aSTNode != null) {
            this.addHighlightingAnnotation(aSTNode, PyHighlighter.PY_KEYWORD_ARGUMENT);
        }
    }

    @Override
    public void visitPyCallExpression(PyCallExpression node) {
        PyReferenceExpression pyReferenceExpression = PyUtil.as(node.getCallee(), PyReferenceExpression.class);
        if (pyReferenceExpression != null) {
            if (!pyReferenceExpression.isQualified() && PyBuiltinCache.isInBuiltins(pyReferenceExpression)) {
                return;
            }
            ASTNode aSTNode = pyReferenceExpression.getNameElement();
            if (aSTNode != null) {
                TextAttributesKey textAttributesKey = pyReferenceExpression.isQualified() ? PyHighlighter.PY_METHOD_CALL : PyHighlighter.PY_FUNCTION_CALL;
                this.addHighlightingAnnotation(aSTNode, textAttributesKey);
            }
        }
    }

    @Override
    public void visitPyAnnotation(PyAnnotation node) {
        PyExpression pyExpression = node.getValue();
        if (pyExpression != null) {
            this.addHighlightingAnnotation((PsiElement)pyExpression, PyHighlighter.PY_ANNOTATION, LOW_PRIORITY_HIGHLIGHTING);
        }
    }

    public void visitElement(PsiElement element) {
        if (PyTokenTypes.EXPRESSION_KEYWORDS.contains(element.getNode().getElementType()) && PsiTreeUtil.getParentOfType((PsiElement)element, PyAnnotation.class) != null) {
            this.addHighlightingAnnotation(element, PyHighlighter.PY_KEYWORD);
        }
    }

    static {
        long l2 = c.a(3597854767874622483L, -1879845183954140281L, MethodHandles.lookup().lookupClass()).a(77447618009239L) ^ 0x70BEEDD7903DL;
        LOW_PRIORITY_HIGHLIGHTING = new HighlightSeverity("LOW_PRIORITY_HIGHLIGHTING", HighlightSeverity.INFORMATION.myVal - 3);
    }
}

