/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.validation;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.codeInsight.dataflow.scope.ScopeUtil;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyAnnotation;
import com.jetbrains.python.psi.PyAssignmentExpression;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyAugAssignmentStatement;
import com.jetbrains.python.psi.PyBinaryExpression;
import com.jetbrains.python.psi.PyBoolLiteralExpression;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyComprehensionElement;
import com.jetbrains.python.psi.PyDelStatement;
import com.jetbrains.python.psi.PyDictCompExpression;
import com.jetbrains.python.psi.PyDictLiteralExpression;
import com.jetbrains.python.psi.PyElementVisitor;
import com.jetbrains.python.psi.PyExceptPart;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyExpressionStatement;
import com.jetbrains.python.psi.PyForStatement;
import com.jetbrains.python.psi.PyGeneratorExpression;
import com.jetbrains.python.psi.PyKeywordArgument;
import com.jetbrains.python.psi.PyLambdaExpression;
import com.jetbrains.python.psi.PyListCompExpression;
import com.jetbrains.python.psi.PyListLiteralExpression;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.PyNoneLiteralExpression;
import com.jetbrains.python.psi.PyNumericLiteralExpression;
import com.jetbrains.python.psi.PyParenthesizedExpression;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PySequenceExpression;
import com.jetbrains.python.psi.PySetCompExpression;
import com.jetbrains.python.psi.PySetLiteralExpression;
import com.jetbrains.python.psi.PyStarExpression;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyTupleExpression;
import com.jetbrains.python.psi.PyWithItem;
import com.jetbrains.python.psi.c;
import com.jetbrains.python.validation.PyAnnotator;
import java.lang.invoke.MethodHandles;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AssignTargetAnnotator
extends PyAnnotator {
    private static final long c = com.jetbrains.python.psi.c.a(2602313203019808934L, 5877027232105920878L, MethodHandles.lookup().lookupClass()).a(268591282776642L);

    @Override
    public void visitPyAssignmentStatement(PyAssignmentStatement node) {
        long l2 = c ^ 0x39E55BFBC119L;
        for (PyExpression pyExpression : node.getRawTargets()) {
            pyExpression.accept(new ExprVisitor(this, Operation.Assign));
        }
        this.a(node.getAssignedValue(), "at the top level of the right hand side of an assignment statement");
    }

    @Override
    public void visitPyAugAssignmentStatement(PyAugAssignmentStatement node) {
        node.getTarget().accept(new ExprVisitor(this, Operation.AugAssign));
    }

    @Override
    public void visitPyDelStatement(PyDelStatement node) {
        ExprVisitor exprVisitor = new ExprVisitor(this, Operation.Delete);
        for (PyExpression pyExpression : node.getTargets()) {
            pyExpression.accept(exprVisitor);
        }
    }

    @Override
    public void visitPyExceptBlock(PyExceptPart node) {
        PyExpression pyExpression = node.getTarget();
        if (pyExpression != null) {
            pyExpression.accept(new ExprVisitor(this, Operation.Except));
        }
    }

    @Override
    public void visitPyForStatement(PyForStatement node) {
        PyExpression pyExpression = node.getForPart().getTarget();
        if (pyExpression != null) {
            pyExpression.accept(new ExprVisitor(this, Operation.For));
        }
    }

    @Override
    public void visitPyWithItem(PyWithItem node) {
        PyExpression pyExpression = node.getTarget();
        if (pyExpression != null) {
            pyExpression.accept(new ExprVisitor(this, Operation.With));
        }
    }

    @Override
    public void visitPyExpressionStatement(PyExpressionStatement node) {
        long l2 = c ^ 0x1572BB3F1361L;
        this.a(node.getExpression(), "at the top level of an expression statement");
    }

    @Override
    public void visitPyNamedParameter(PyNamedParameter node) {
        long l2 = c ^ 0x8030B81AED1L;
        this.a(node.getDefaultValue(), "at the top level of a function default value");
    }

    @Override
    public void visitPyKeywordArgument(PyKeywordArgument node) {
        long l2 = c ^ 0x71FF9BCE4742L;
        this.a(node.getValueExpression(), "for the value of a keyword argument in a call");
    }

    @Override
    public void visitPyLambdaExpression(PyLambdaExpression node) {
        long l2 = c ^ 0x2F004630090FL;
        this.a(node.getBody(), "at the top level of a lambda function");
    }

    @Override
    public void visitPyAnnotation(PyAnnotation node) {
        long l2 = c ^ 0x552EDB4B184EL;
        this.a(node.getValue(), "as annotations for arguments, return values and assignments");
    }

    @Override
    public void visitPyAssignmentExpression(PyAssignmentExpression node) {
        long l2 = c ^ 0x50CF6CACEC9FL;
        PyComprehensionElement pyComprehensionElement = (PyComprehensionElement)PsiTreeUtil.getParentOfType((PsiElement)node, PyComprehensionElement.class, (boolean)true, (Class[])new Class[]{ScopeOwner.class});
        if (ScopeUtil.getScopeOwner(pyComprehensionElement) instanceof PyClass) {
            this.getHolder().createErrorAnnotation((PsiElement)node, "Assignment expressions within a comprehension cannot be used in a class body");
        }
    }

    private void a(@Nullable PyExpression pyExpression, @NotNull String string) {
        long l2 = c ^ 0x767EDF7E3109L;
        if (string == null) {
            AssignTargetAnnotator.b(0);
        }
        if (pyExpression instanceof PyAssignmentExpression) {
            this.getHolder().createErrorAnnotation((PsiElement)pyExpression, "Unparenthesized assignment expressions are prohibited " + string);
        }
    }

    private static /* synthetic */ void b(int n2) {
        long l2 = c ^ 0x381B59F6D78CL;
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suffix", "com/jetbrains/python/validation/AssignTargetAnnotator", "errorOnUnparenthesizedAssignmentExpression"));
    }

    private class ExprVisitor
    extends PyElementVisitor {
        private final Operation a;
        private final String d;
        private final String c;
        private final String e;
        private final String b;
        final /* synthetic */ AssignTargetAnnotator this$0;
        private static final long f = com.jetbrains.python.psi.c.a(2297252575532994732L, 8582631031574235164L, MethodHandles.lookup().lookupClass()).a(174558140013921L);

        ExprVisitor(AssignTargetAnnotator assignTargetAnnotator, Operation op) {
            long l2 = f ^ 0xA4E122583CL;
            this.this$0 = assignTargetAnnotator;
            this.d = PyBundle.message("ANN.deleting.none", new Object[0]);
            this.c = PyBundle.message("ANN.assign.to.none", new Object[0]);
            this.e = PyBundle.message("ANN.cant.assign.to.call", new Object[0]);
            this.b = PyBundle.message("ANN.cant.delete.call", new Object[0]);
            this.a = op;
        }

        @Override
        public void visitPyReferenceExpression(PyReferenceExpression node) {
            long l2 = f ^ 0x1DD75A8211A5L;
            String string = node.getReferencedName();
            if ("None".equals(string)) {
                this.this$0.getHolder().createErrorAnnotation((PsiElement)node, this.a == Operation.Delete ? this.d : this.c);
            }
        }

        @Override
        public void visitPyTargetExpression(PyTargetExpression node) {
            VirtualFile virtualFile;
            long l2 = f ^ 0x58F7108872AEL;
            String string = node.getName();
            if ("None".equals(string) && (virtualFile = node.getContainingFile().getVirtualFile()) != null && !virtualFile.getUrl().contains("/python_stubs/")) {
                this.this$0.getHolder().createErrorAnnotation((PsiElement)node, this.a == Operation.Delete ? this.d : this.c);
            }
            if ("__debug__".equals(string)) {
                if (LanguageLevel.forElement(node).isPy3K()) {
                    this.this$0.getHolder().createErrorAnnotation((PsiElement)node, "assignment to keyword");
                } else {
                    this.this$0.getHolder().createErrorAnnotation((PsiElement)node, "cannot assign to __debug__");
                }
            }
        }

        @Override
        public void visitPyCallExpression(PyCallExpression node) {
            this.this$0.getHolder().createErrorAnnotation((PsiElement)node, this.a == Operation.Delete ? this.b : this.e);
        }

        @Override
        public void visitPyGeneratorExpression(PyGeneratorExpression node) {
            long l2 = f ^ 0x56627A306E0L;
            this.this$0.getHolder().createErrorAnnotation((PsiElement)node, PyBundle.message(this.a == Operation.AugAssign ? "ANN.cant.aug.assign.to.generator" : "ANN.cant.assign.to.generator", new Object[0]));
        }

        @Override
        public void visitPyBinaryExpression(PyBinaryExpression node) {
            long l2 = f ^ 0xF6E8DB1AA89L;
            this.this$0.getHolder().createErrorAnnotation((PsiElement)node, PyBundle.message("ANN.cant.assign.to.operator", new Object[0]));
        }

        @Override
        public void visitPyTupleExpression(PyTupleExpression node) {
            long l2 = f ^ 0x6427EBEECE96L;
            if (node.isEmpty() && LanguageLevel.forElement((PsiElement)node).isPython2()) {
                this.this$0.getHolder().createErrorAnnotation((PsiElement)node, PyBundle.message("ANN.cant.assign.to.parens", new Object[0]));
            } else if (this.a == Operation.AugAssign) {
                this.this$0.getHolder().createErrorAnnotation((PsiElement)node, PyBundle.message("ANN.cant.aug.assign.to.tuple.or.generator", new Object[0]));
            } else {
                node.acceptChildren(this);
            }
        }

        @Override
        public void visitPyParenthesizedExpression(PyParenthesizedExpression node) {
            long l2 = f ^ 0x11F16C761CAL;
            if (this.a == Operation.AugAssign) {
                this.this$0.getHolder().createErrorAnnotation((PsiElement)node, PyBundle.message("ANN.cant.aug.assign.to.tuple.or.generator", new Object[0]));
            } else {
                node.acceptChildren(this);
            }
        }

        @Override
        public void visitPyListLiteralExpression(PyListLiteralExpression node) {
            long l2 = f ^ 0x2A6FD6B93009L;
            if (this.a == Operation.AugAssign) {
                this.this$0.getHolder().createErrorAnnotation((PsiElement)node, PyBundle.message("ANN.cant.aug.assign.to.list.or.comprh", new Object[0]));
            } else {
                node.acceptChildren(this);
            }
        }

        @Override
        public void visitPyListCompExpression(PyListCompExpression node) {
            long l2 = f ^ 0x4E859CF794E9L;
            this.this$0.markError(node, PyBundle.message(this.a == Operation.AugAssign ? "ANN.cant.aug.assign.to.comprh" : "ANN.cant.assign.to.comprh", new Object[0]));
        }

        @Override
        public void visitPyDictCompExpression(PyDictCompExpression node) {
            long l2 = f ^ 0x1DFE099840AL;
            this.this$0.markError(node, PyBundle.message(this.a == Operation.AugAssign ? "ANN.cant.aug.assign.to.dict.comprh" : "ANN.cant.assign.to.dict.comprh", new Object[0]));
        }

        @Override
        public void visitPySetCompExpression(PySetCompExpression node) {
            long l2 = f ^ 0x53B1426F429BL;
            this.this$0.markError(node, PyBundle.message(this.a == Operation.AugAssign ? "ANN.cant.aug.assign.to.set.comprh" : "ANN.cant.assign.to.set.comprh", new Object[0]));
        }

        @Override
        public void visitPyStarExpression(PyStarExpression node) {
            long l2 = f ^ 0x2522F07CD41CL;
            super.visitPyStarExpression(node);
            if (!(node.getParent() instanceof PySequenceExpression)) {
                this.this$0.markError((PsiElement)node, "starred assignment target must be in a list or tuple");
            }
        }

        @Override
        public void visitPyDictLiteralExpression(PyDictLiteralExpression node) {
            this.a(node);
        }

        @Override
        public void visitPySetLiteralExpression(PySetLiteralExpression node) {
            this.a(node);
        }

        @Override
        public void visitPyNumericLiteralExpression(PyNumericLiteralExpression node) {
            this.a(node);
        }

        @Override
        public void visitPyStringLiteralExpression(PyStringLiteralExpression node) {
            this.a(node);
        }

        private void a(PyExpression pyExpression) {
            long l2 = f ^ 0x5F55D21ED48BL;
            this.this$0.getHolder().createErrorAnnotation((PsiElement)pyExpression, PyBundle.message(this.a == Operation.Delete ? "ANN.cant.delete.literal" : "ANN.cant.assign.to.literal", new Object[0]));
        }

        @Override
        public void visitPyLambdaExpression(PyLambdaExpression node) {
            long l2 = f ^ 0x49AAD0451769L;
            this.this$0.getHolder().createErrorAnnotation((PsiElement)node, PyBundle.message("ANN.cant.assign.to.lambda", new Object[0]));
        }

        @Override
        public void visitPyNoneLiteralExpression(PyNoneLiteralExpression node) {
            long l2 = f ^ 0x718398B34F2FL;
            this.this$0.getHolder().createErrorAnnotation((PsiElement)node, "assignment to keyword");
        }

        @Override
        public void visitPyBoolLiteralExpression(PyBoolLiteralExpression node) {
            long l2 = f ^ 0xB2A81B54AA2L;
            this.this$0.getHolder().createErrorAnnotation((PsiElement)node, "assignment to keyword");
        }
    }

    private static final class Operation
    extends Enum<Operation> {
        public static final /* enum */ Operation Assign;
        public static final /* enum */ Operation AugAssign;
        public static final /* enum */ Operation Delete;
        public static final /* enum */ Operation Except;
        public static final /* enum */ Operation For;
        public static final /* enum */ Operation With;
        private static final /* synthetic */ Operation[] a;

        public static Operation[] values() {
            return (Operation[])a.clone();
        }

        public static Operation valueOf(String name) {
            return Enum.valueOf(Operation.class, name);
        }

        static {
            long l2 = com.jetbrains.python.psi.c.a(1596834000485004739L, -5692136293392071649L, MethodHandles.lookup().lookupClass()).a(68503774092779L) ^ 0x55EAEE5E4072L;
            Assign = new Operation();
            AugAssign = new Operation();
            Delete = new Operation();
            Except = new Operation();
            For = new Operation();
            With = new Operation();
            a = new Operation[]{Assign, AugAssign, Delete, Except, For, With};
        }
    }
}

