/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk.skeletons;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.io.ZipUtil;
import com.jetbrains.python.psi.c;
import com.jetbrains.python.sdk.PySdkUtil;
import com.jetbrains.python.sdk.PythonSdkType;
import com.jetbrains.python.sdk.skeletons.PyPregeneratedSkeletons;
import com.jetbrains.python.sdk.skeletons.PyPregeneratedSkeletonsProvider;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.invoke.MethodHandles;
import java.util.regex.PatternSyntaxException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultPregeneratedSkeletonsProvider
implements PyPregeneratedSkeletonsProvider {
    private static final Logger a;
    private static final long b;

    @Nullable
    private static File a() {
        long l2 = b ^ 0x172B8F837A27L;
        String string = PathManager.getHomePath();
        a.info("Home path is " + string);
        File file = new File(string, "python/skeletons");
        if (file.exists()) {
            return file;
        }
        file = new File(string, "skeletons");
        if (file.exists()) {
            return file;
        }
        return null;
    }

    @VisibleForTesting
    public static boolean isApplicableZippedSkeletonsFileName(@NotNull String prebuiltSkeletonsName, @NotNull String fileName) {
        long l2 = b ^ 0x680719DF9E18L;
        if (prebuiltSkeletonsName == null) {
            DefaultPregeneratedSkeletonsProvider.a(0);
        }
        if (fileName == null) {
            DefaultPregeneratedSkeletonsProvider.a(1);
        }
        try {
            return fileName.matches(".*" + prebuiltSkeletonsName + "\\.?\\d*\\.zip");
        }
        catch (PatternSyntaxException patternSyntaxException) {
            return false;
        }
    }

    @Nullable
    public static String getPregeneratedSkeletonsName(@NotNull Sdk sdk, int generatorVersion, boolean withMinorVersion, boolean withExtension) {
        long l2 = b ^ 0x4F7E568ACB63L;
        if (sdk == null) {
            DefaultPregeneratedSkeletonsProvider.a(2);
        }
        if (PySdkUtil.isRemote(sdk)) {
            return null;
        }
        String string = sdk.getVersionString();
        if (string == null) {
            return null;
        }
        if (PythonSdkType.isConda(sdk)) {
            string = "Anaconda-" + string;
        }
        return DefaultPregeneratedSkeletonsProvider.getPrebuiltSkeletonsName(generatorVersion, string, withMinorVersion, withExtension);
    }

    @NotNull
    @VisibleForTesting
    public static String getPrebuiltSkeletonsName(int generatorVersion, @NotNull @NonNls String versionString, boolean withMinorVersion, boolean withExtension) {
        int n2;
        long l2 = b ^ 0x4FE0C4A5CDEBL;
        if (versionString == null) {
            DefaultPregeneratedSkeletonsProvider.a(3);
        }
        String string = StringUtil.toLowerCase((String)versionString).replace(" ", "-");
        if (!withMinorVersion && (n2 = string.lastIndexOf(".")) != -1) {
            string = string.substring(0, n2);
        }
        if (SystemInfo.isMac) {
            int n3;
            String string2 = SystemInfo.OS_VERSION;
            int n4 = string2.indexOf(46);
            if (n4 >= 0 && (n3 = string2.indexOf(46, n4 + 1)) >= 0) {
                string2 = string2.substring(0, n3);
            }
            String string3 = "skeletons-mac-" + generatorVersion + "-" + string2 + "-" + string + (withExtension ? ".zip" : "");
            if (string3 == null) {
                DefaultPregeneratedSkeletonsProvider.a(4);
            }
            return string3;
        }
        String string4 = SystemInfo.isWindows ? "win" : "nix";
        String string5 = "skeletons-" + string4 + "-" + generatorVersion + "-" + string + (withExtension ? ".zip" : "");
        if (string5 == null) {
            DefaultPregeneratedSkeletonsProvider.a(5);
        }
        return string5;
    }

    @Override
    public PyPregeneratedSkeletons getSkeletonsForSdk(Sdk sdk, int generatorVersion) {
        long l2 = b ^ 0x403A22966E98L;
        File file = DefaultPregeneratedSkeletonsProvider.a();
        if (file == null || !file.exists()) {
            return null;
        }
        a.info("Pregenerated skeletons root is " + file);
        String string = DefaultPregeneratedSkeletonsProvider.getPregeneratedSkeletonsName(sdk, generatorVersion, Registry.is((String)"python.prebuilt.skeletons.minor.version.aware"), false);
        if (string == null) {
            return null;
        }
        File file2 = null;
        VirtualFile virtualFile = file.listFiles();
        if (virtualFile != null) {
            for (File file3 : virtualFile) {
                if (!DefaultPregeneratedSkeletonsProvider.isApplicableZippedSkeletonsFileName(string, file3.getName())) continue;
                file2 = file3;
                break;
            }
        }
        if (file2 != null) {
            a.info("Found pre-generated skeletons at " + file2.getPath());
            VirtualFile virtualFile2 = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(file2);
            if (virtualFile2 == null) {
                a.info("Could not find pre-generated skeletons in VFS");
                return null;
            }
            return new ArchivedSkeletons(JarFileSystem.getInstance().getJarRootForLocalFile(virtualFile2));
        }
        a.info("Not found pre-generated skeletons at " + file);
        return null;
    }

    static {
        b = c.a(-242149565824017777L, -8101475031636149071L, MethodHandles.lookup().lookupClass()).a(130917657163053L);
        a = Logger.getInstance(DefaultPregeneratedSkeletonsProvider.class);
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = b ^ 0x40D237DD7061L;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 4: 
            case 5: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prebuiltSkeletonsName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "versionString";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/sdk/skeletons/DefaultPregeneratedSkeletonsProvider";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/sdk/skeletons/DefaultPregeneratedSkeletonsProvider";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPrebuiltSkeletonsName";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isApplicableZippedSkeletonsFileName";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getPregeneratedSkeletonsName";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getPrebuiltSkeletonsName";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ArchivedSkeletons
    implements PyPregeneratedSkeletons {
        private final VirtualFile a;
        private static final long b = c.a(-3784189841484175702L, 2904722844847582530L, MethodHandles.lookup().lookupClass()).a(33979814709831L);

        ArchivedSkeletons(VirtualFile archiveRoot) {
            this.a = archiveRoot;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean copyPregeneratedSkeleton(String moduleName, String skeletonDir) {
            Object object;
            File file;
            long l2 = b ^ 0xD6C0609B4B9L;
            String string = moduleName.replace('.', '/');
            File file2 = new File(skeletonDir);
            VirtualFile virtualFile = this.a.findFileByRelativePath(string + ".py");
            if (virtualFile == null) {
                virtualFile = this.a.findFileByRelativePath(string + "/" + "__init__.py");
                file = new File(file2, string);
            } else {
                int n2 = string.lastIndexOf(47);
                if (n2 < 0) {
                    file = file2;
                } else {
                    object = string.substring(0, n2);
                    file = new File(file2, (String)object);
                }
            }
            if (virtualFile != null && (file.exists() || file.mkdirs())) {
                a.info("Pre-generated skeleton for " + moduleName);
                File file3 = new File(file, virtualFile.getName());
                try {
                    object = new FileOutputStream(file3);
                    try {
                        FileUtil.copy((InputStream)virtualFile.getInputStream(), (OutputStream)object);
                    }
                    finally {
                        ((FileOutputStream)object).close();
                    }
                }
                catch (IOException iOException) {
                    a.info("Error copying pre-generated skeleton", (Throwable)iOException);
                    return false;
                }
                return true;
            }
            return false;
        }

        @Override
        public void unpackPreGeneratedSkeletons(String skeletonDir) {
            long l2 = b ^ 0x48BC2F8AE508L;
            ProgressManager.progress((String)"Unpacking pre-generated skeletons...");
            try {
                VirtualFile virtualFile = JarFileSystem.getInstance().getVirtualFileForJar(this.a);
                if (virtualFile != null) {
                    ZipUtil.extract((File)new File(virtualFile.getPath()), (File)new File(skeletonDir), null);
                }
            }
            catch (IOException iOException) {
                a.info("Error unpacking pre-generated skeletons", (Throwable)iOException);
            }
        }
    }
}

