/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.scientific;

import com.intellij.codeInsight.documentation.DocumentationComponent;
import com.intellij.codeInsight.documentation.DocumentationManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.python.psi.c;
import com.jetbrains.python.scientific.PySciProjectComponent;
import com.jetbrains.python.scientific.PyScientificViewKt;
import com.jetbrains.python.scientific.figures.PyPlotToolWindow;
import com.jetbrains.python.scientific.figures.image.ImageDockableContentFigureFactory;
import java.lang.invoke.MethodHandles;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@com.intellij.openapi.components.State(name="PySciProjectComponent", storages={@Storage(value="other.xml")})
public class PySciProjectComponentImpl
extends PySciProjectComponent
implements PersistentStateComponent<State>,
ProjectComponent {
    private final State a = new State();
    private final Project c;
    private volatile boolean b;
    private final List<PySciProjectComponent.SciViewListener> d = ContainerUtil.createLockFreeCopyOnWriteList();
    private static final long e = com.jetbrains.python.psi.c.a(5742607991829237765L, 3871706839554658348L, MethodHandles.lookup().lookupClass()).a(235949316237091L);

    protected PySciProjectComponentImpl(Project project) {
        this.c = project;
    }

    @Override
    public void addSciViewListener(PySciProjectComponent.SciViewListener listener2) {
        this.d.add(listener2);
    }

    @Override
    public void setUseSciView(boolean useSciView) {
        this.a.PY_SCI_VIEW = useSciView;
        for (PySciProjectComponent.SciViewListener sciViewListener : this.d) {
            sciViewListener.sciViewStatusChanged(useSciView);
        }
    }

    @Override
    public void setSciViewSuggested(boolean suggested) {
        this.a.PY_SCI_VIEW_SUGGESTED = suggested;
    }

    @Override
    public boolean isSciViewSuggested() {
        return this.a.PY_SCI_VIEW_SUGGESTED;
    }

    @Override
    public boolean shouldUseSciView() {
        return this.a.PY_SCI_VIEW;
    }

    @Override
    public void setMatplotlibInToolwindow(boolean inToolwindow) {
        this.a.PY_MATPLOTLIB_IN_TOOLWINDOW = inToolwindow;
        if (!this.shouldUseSciView()) {
            if (inToolwindow) {
                PyScientificViewKt.showDataViewAsToolwindow(this.c);
            } else {
                PyScientificViewKt.hideDataViewer(this.c);
            }
        }
    }

    @Override
    public boolean isMatplotlibInToolwindow() {
        return this.a.PY_MATPLOTLIB_IN_TOOLWINDOW;
    }

    public void projectOpened() {
        VirtualFile virtualFile = this.c.getBaseDir();
        if (virtualFile == null) {
            return;
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        if (this.a.PY_SCI_VIEW) {
            StartupManager.getInstance((Project)this.c).runWhenProjectIsInitialized(() -> {
                EditorColorsScheme editorColorsScheme = EditorColorsManager.getInstance().getGlobalScheme();
                editorColorsScheme.setColor(DocumentationComponent.COLOR_KEY, UIUtil.getEditorPaneBackground());
                PsiDirectory psiDirectory = PsiManager.getInstance((Project)this.c).findDirectory(virtualFile);
                if (psiDirectory != null) {
                    DocumentationManager.getInstance((Project)this.c).showJavaDocInfo((PsiElement)psiDirectory, (PsiElement)psiDirectory);
                }
            });
        }
        if (this.isMatplotlibInToolwindow() && !this.shouldUseSciView()) {
            StartupManager.getInstance((Project)this.c).runWhenProjectIsInitialized(() -> PyScientificViewKt.showDataViewAsToolwindow(this.c));
        }
        PyPlotToolWindow.getInstance(this.c).addDockableContentFigureFactory(new ImageDockableContentFigureFactory(this.c));
    }

    @Override
    public boolean isPortForwarded() {
        return this.b;
    }

    @Override
    public void enablePortForwarding() {
        this.b = true;
    }

    public void projectClosed() {
    }

    @Nullable
    public State getState() {
        return this.a;
    }

    public void loadState(@NotNull State state2) {
        if (state2 == null) {
            PySciProjectComponentImpl.a(0);
        }
        this.a.PY_SCI_VIEW = state2.PY_SCI_VIEW;
        this.a.PY_SCI_VIEW_SUGGESTED = state2.PY_SCI_VIEW_SUGGESTED;
        this.a.PY_MATPLOTLIB_IN_TOOLWINDOW = state2.PY_MATPLOTLIB_IN_TOOLWINDOW;
    }

    private static /* synthetic */ void a(int n2) {
        long l2 = e ^ 0xDAEF9E85B46L;
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/jetbrains/python/scientific/PySciProjectComponentImpl", "loadState"));
    }

    public static class State {
        public boolean PY_SCI_VIEW = false;
        public boolean PY_SCI_VIEW_SUGGESTED = false;
        public boolean PY_MATPLOTLIB_IN_TOOLWINDOW = true;
    }
}

