/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.run;

import com.google.common.collect.Lists;
import com.intellij.diagnostic.logging.LogConfigurationPanel;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.configuration.AbstractRunConfiguration;
import com.intellij.execution.configuration.EnvironmentVariablesComponent;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.ParamsGroup;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunProfileWithCompileBeforeLaunchOption;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.options.SettingsEditorGroup;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizerUtil;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathMappingSettings;
import com.intellij.util.PlatformUtils;
import com.intellij.util.xmlb.annotations.Transient;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.PythonModuleTypeBase;
import com.jetbrains.python.psi.c;
import com.jetbrains.python.run.AbstractPythonRunConfigurationParams;
import com.jetbrains.python.run.CommandLinePatcher;
import com.jetbrains.python.run.PyCommonOptionsFormData;
import com.jetbrains.python.run.PythonExtendedConfigurationEditor;
import com.jetbrains.python.run.PythonRunConfigurationExtensionsManager;
import com.jetbrains.python.sdk.PythonEnvUtil;
import com.jetbrains.python.sdk.PythonSdkType;
import java.io.File;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractPythonRunConfiguration<T extends AbstractPythonRunConfiguration<T>>
extends AbstractRunConfiguration
implements AbstractPythonRunConfigurationParams,
CommandLinePatcher,
RunProfileWithCompileBeforeLaunchOption {
    private String d;
    private String f;
    private String a;
    private boolean c;
    private boolean b;
    private boolean e;
    protected PathMappingSettings myMappingSettings;
    protected boolean mySkipModuleSerialization;
    private static final long z = com.jetbrains.python.psi.c.a(-2802769241220065890L, 2611902313593212545L, MethodHandles.lookup().lookupClass()).a(180972219560923L);

    public AbstractPythonRunConfiguration(@NotNull Project project, @NotNull ConfigurationFactory factory) {
        if (project == null) {
            AbstractPythonRunConfiguration.b(0);
        }
        if (factory == null) {
            AbstractPythonRunConfiguration.b(1);
        }
        super(project, factory);
        this.d = "";
        this.f = "";
        this.a = "";
        this.b = true;
        this.e = true;
        this.getConfigurationModule().setModuleToAnyFirstIfNotSpecified();
    }

    public List<Module> getValidModules() {
        return AbstractPythonRunConfiguration.getValidModules(this.getProject());
    }

    @Override
    public PathMappingSettings getMappingSettings() {
        return this.myMappingSettings;
    }

    @Override
    public void setMappingSettings(@Nullable PathMappingSettings mappingSettings) {
        this.myMappingSettings = mappingSettings;
    }

    public boolean isIdTestBased() {
        return false;
    }

    public static List<Module> getValidModules(Project project) {
        Module[] moduleArray = ModuleManager.getInstance((Project)project).getModules();
        ArrayList arrayList = Lists.newArrayList();
        for (Module module2 : moduleArray) {
            if (PythonSdkType.findPythonSdk(module2) == null) continue;
            arrayList.add(module2);
        }
        return arrayList;
    }

    public PyCommonOptionsFormData getCommonOptionsFormData() {
        return new PyCommonOptionsFormData(){

            @Override
            public Project getProject() {
                return AbstractPythonRunConfiguration.this.getProject();
            }

            @Override
            public List<Module> getValidModules() {
                return AbstractPythonRunConfiguration.this.getValidModules();
            }

            @Override
            public boolean showConfigureInterpretersLink() {
                return false;
            }
        };
    }

    @NotNull
    public final SettingsEditor<T> getConfigurationEditor() {
        long l2 = z ^ 0x4729C1AF7A30L;
        PythonExtendedConfigurationEditor<T> pythonExtendedConfigurationEditor = PythonExtendedConfigurationEditor.create(this.createConfigurationEditor());
        SettingsEditorGroup settingsEditorGroup = new SettingsEditorGroup();
        settingsEditorGroup.addEditor(ExecutionBundle.message((String)"run.configuration.configuration.tab.title", (Object[])new Object[0]), pythonExtendedConfigurationEditor);
        PythonRunConfigurationExtensionsManager.Companion.getInstance().appendEditors((RunConfigurationBase)this, settingsEditorGroup);
        settingsEditorGroup.addEditor(ExecutionBundle.message((String)"logs.tab.title", (Object[])new Object[0]), (SettingsEditor)new LogConfigurationPanel());
        SettingsEditorGroup settingsEditorGroup2 = settingsEditorGroup;
        if (settingsEditorGroup2 == null) {
            AbstractPythonRunConfiguration.b(2);
        }
        return settingsEditorGroup2;
    }

    protected abstract SettingsEditor<T> createConfigurationEditor();

    public void checkConfiguration() throws RuntimeConfigurationException {
        super.checkConfiguration();
        this.a();
        this.c();
    }

    private void c() throws RuntimeConfigurationException {
        try {
            PythonRunConfigurationExtensionsManager.Companion.getInstance().validateConfiguration((RunConfigurationBase)this, false);
        }
        catch (RuntimeConfigurationException runtimeConfigurationException) {
            throw runtimeConfigurationException;
        }
        catch (Exception exception) {
            throw new RuntimeConfigurationException(exception.getMessage());
        }
    }

    private void a() throws RuntimeConfigurationError {
        long l2 = z ^ 0x522891B396BFL;
        if (PlatformUtils.isPyCharm()) {
            String string = this.getInterpreterPath();
            if (StringUtil.isEmptyOrSpaces((String)string)) {
                throw new RuntimeConfigurationError("Please select a valid Python interpreter");
            }
        } else if (!this.c) {
            if (StringUtil.isEmptyOrSpaces((String)this.getSdkHome())) {
                Sdk sdk = ProjectRootManager.getInstance((Project)this.getProject()).getProjectSdk();
                if (sdk == null || !(sdk.getSdkType() instanceof PythonSdkType)) {
                    throw new RuntimeConfigurationError(PyBundle.message("runcfg.unittest.no_sdk", new Object[0]));
                }
            } else if (!PythonSdkType.getInstance().isValidSdkHome(this.getSdkHome())) {
                throw new RuntimeConfigurationError(PyBundle.message("runcfg.unittest.no_valid_sdk", new Object[0]));
            }
        } else {
            Sdk sdk = PythonSdkType.findPythonSdk(this.getModule());
            if (sdk == null) {
                throw new RuntimeConfigurationError(PyBundle.message("runcfg.unittest.no_module_sdk", new Object[0]));
            }
        }
    }

    @Override
    public String getSdkHome() {
        Sdk sdk;
        String string = this.a;
        if (StringUtil.isEmptyOrSpaces((String)this.a) && (sdk = PythonSdkType.findPythonSdk(this.getModule())) != null) {
            string = sdk.getHomePath();
        }
        return string;
    }

    @Nullable
    public String getInterpreterPath() {
        String string;
        if (this.c) {
            Sdk sdk = PythonSdkType.findPythonSdk(this.getModule());
            if (sdk == null) {
                return null;
            }
            string = sdk.getHomePath();
        } else {
            string = this.getSdkHome();
        }
        return string;
    }

    @Nullable
    public Sdk getSdk() {
        if (this.c) {
            return PythonSdkType.findPythonSdk(this.getModule());
        }
        return PythonSdkType.findSdkByPath(this.getSdkHome());
    }

    public void readExternal(@NotNull Element element) throws InvalidDataException {
        long l2 = z ^ 0x59ADF565D574L;
        if (element == null) {
            AbstractPythonRunConfiguration.b(3);
        }
        super.readExternal(element);
        this.d = JDOMExternalizerUtil.readField((Element)element, (String)"INTERPRETER_OPTIONS");
        this.readEnvs(element);
        this.a = JDOMExternalizerUtil.readField((Element)element, (String)"SDK_HOME");
        this.f = JDOMExternalizerUtil.readField((Element)element, (String)"WORKING_DIRECTORY");
        this.c = Boolean.parseBoolean(JDOMExternalizerUtil.readField((Element)element, (String)"IS_MODULE_SDK"));
        String string = JDOMExternalizerUtil.readField((Element)element, (String)"ADD_CONTENT_ROOTS");
        this.b = string == null || Boolean.parseBoolean(string);
        String string2 = JDOMExternalizerUtil.readField((Element)element, (String)"ADD_SOURCE_ROOTS");
        boolean bl2 = this.e = string2 == null || Boolean.parseBoolean(string2);
        if (!this.mySkipModuleSerialization) {
            this.getConfigurationModule().readExternal(element);
        }
        this.setMappingSettings(PathMappingSettings.readExternal((Element)element));
        PythonRunConfigurationExtensionsManager.Companion.getInstance().readExternal((RunConfigurationBase)this, element);
    }

    protected void readEnvs(Element element) {
        long l2 = z ^ 0x128B08DFCE9DL;
        String string = JDOMExternalizerUtil.readField((Element)element, (String)"PARENT_ENVS");
        if (string != null) {
            this.setPassParentEnvs(Boolean.parseBoolean(string));
        }
        EnvironmentVariablesComponent.readExternal((Element)element, (Map)this.getEnvs());
    }

    public void writeExternal(@NotNull Element element) throws WriteExternalException {
        long l2 = z ^ 0x21D574425DE4L;
        if (element == null) {
            AbstractPythonRunConfiguration.b(4);
        }
        super.writeExternal(element);
        JDOMExternalizerUtil.writeField((Element)element, (String)"INTERPRETER_OPTIONS", (String)this.d);
        this.writeEnvs(element);
        JDOMExternalizerUtil.writeField((Element)element, (String)"SDK_HOME", (String)this.a);
        JDOMExternalizerUtil.writeField((Element)element, (String)"WORKING_DIRECTORY", (String)this.f);
        JDOMExternalizerUtil.writeField((Element)element, (String)"IS_MODULE_SDK", (String)Boolean.toString(this.c));
        JDOMExternalizerUtil.writeField((Element)element, (String)"ADD_CONTENT_ROOTS", (String)Boolean.toString(this.b));
        JDOMExternalizerUtil.writeField((Element)element, (String)"ADD_SOURCE_ROOTS", (String)Boolean.toString(this.e));
        if (!this.mySkipModuleSerialization) {
            this.getConfigurationModule().writeExternal(element);
        }
        PythonRunConfigurationExtensionsManager.Companion.getInstance().writeExternal((RunConfigurationBase)this, element);
        PathMappingSettings.writeExternal((Element)element, (PathMappingSettings)this.getMappingSettings());
    }

    protected void writeEnvs(Element element) {
        long l2 = z ^ 0x73F564C30CE8L;
        JDOMExternalizerUtil.writeField((Element)element, (String)"PARENT_ENVS", (String)Boolean.toString(this.isPassParentEnvs()));
        EnvironmentVariablesComponent.writeExternal((Element)element, (Map)this.getEnvs());
    }

    @Override
    public String getInterpreterOptions() {
        return this.d;
    }

    @Override
    public void setInterpreterOptions(String interpreterOptions) {
        this.d = interpreterOptions;
    }

    @Override
    public String getWorkingDirectory() {
        return this.f;
    }

    @Override
    public void setWorkingDirectory(String workingDirectory) {
        this.f = workingDirectory;
    }

    @Override
    public void setSdkHome(String sdkHome) {
        this.a = sdkHome;
    }

    @Override
    @Transient
    @Nullable
    public Module getModule() {
        return this.getConfigurationModule().getModule();
    }

    @Override
    public boolean isUseModuleSdk() {
        return this.c;
    }

    @Override
    public void setUseModuleSdk(boolean useModuleSdk) {
        this.c = useModuleSdk;
    }

    @Override
    public boolean shouldAddContentRoots() {
        return this.b;
    }

    @Override
    public boolean shouldAddSourceRoots() {
        return this.e;
    }

    @Override
    public void setAddSourceRoots(boolean flag) {
        this.e = flag;
    }

    @Override
    public void setAddContentRoots(boolean flag) {
        this.b = flag;
    }

    public static void copyParams(AbstractPythonRunConfigurationParams source, AbstractPythonRunConfigurationParams target) {
        target.setEnvs(new LinkedHashMap<String, String>(source.getEnvs()));
        target.setInterpreterOptions(source.getInterpreterOptions());
        target.setPassParentEnvs(source.isPassParentEnvs());
        target.setSdkHome(source.getSdkHome());
        target.setWorkingDirectory(source.getWorkingDirectory());
        target.setModule(source.getModule());
        target.setUseModuleSdk(source.isUseModuleSdk());
        target.setMappingSettings(source.getMappingSettings());
        target.setAddContentRoots(source.shouldAddContentRoots());
        target.setAddSourceRoots(source.shouldAddSourceRoots());
    }

    @Override
    public void patchCommandLine(GeneralCommandLine commandLine) {
        String string = this.getInterpreterPath();
        Sdk sdk = this.getSdk();
        if (sdk != null && string != null) {
            this.patchCommandLineFirst(commandLine, string);
            this.patchCommandLineForVirtualenv(commandLine, string);
            this.patchCommandLineForBuildout(commandLine, string);
            this.patchCommandLineLast(commandLine, string);
        }
    }

    protected void patchCommandLineFirst(GeneralCommandLine commandLine, String sdkHome) {
    }

    protected void patchCommandLineLast(GeneralCommandLine commandLine, String sdkHome) {
    }

    protected void patchCommandLineForBuildout(GeneralCommandLine commandLine, String sdkHome) {
    }

    protected void patchCommandLineForVirtualenv(GeneralCommandLine commandLine, String sdkHome) {
        PythonSdkType.patchCommandLineForVirtualenv(commandLine, sdkHome, this.isPassParentEnvs());
    }

    protected void setUnbufferedEnv() {
        Map map2 = this.getEnvs();
        PythonEnvUtil.setPythonUnbuffered(map2);
    }

    public boolean isExcludeCompileBeforeLaunchOption() {
        Module module2 = this.getModule();
        return module2 == null || ModuleType.get((Module)module2) instanceof PythonModuleTypeBase;
    }

    public boolean canRunWithCoverage() {
        return true;
    }

    @NotNull
    public String getWorkingDirectorySafe() {
        String string;
        String string2 = string = StringUtil.isEmpty((String)this.f) ? this.getProject().getBasePath() : this.f;
        if (string != null) {
            String string3 = string;
            if (string3 == null) {
                AbstractPythonRunConfiguration.b(5);
            }
            return string3;
        }
        String string4 = this.b();
        if (string4 != null) {
            String string5 = string4;
            if (string5 == null) {
                AbstractPythonRunConfiguration.b(6);
            }
            return string5;
        }
        String string6 = new File(".").getAbsolutePath();
        if (string6 == null) {
            AbstractPythonRunConfiguration.b(7);
        }
        return string6;
    }

    @Nullable
    private String b() {
        Module module2 = this.getModule();
        if (module2 == null) {
            return null;
        }
        VirtualFile[] virtualFileArray = ModuleRootManager.getInstance((Module)module2).getContentRoots();
        return virtualFileArray.length > 0 ? virtualFileArray[0].getPath() : null;
    }

    @Override
    public String getModuleName() {
        Module module2 = this.getModule();
        return module2 != null ? module2.getName() : null;
    }

    public boolean isBuildBeforeLaunchAddedByDefault() {
        return false;
    }

    public void addTestSpecsAsParameters(@NotNull ParamsGroup paramsGroup, @NotNull List<String> testSpecs) {
        if (paramsGroup == null) {
            AbstractPythonRunConfiguration.b(8);
        }
        if (testSpecs == null) {
            AbstractPythonRunConfiguration.b(9);
        }
        paramsGroup.addParameters(testSpecs);
    }

    private static /* synthetic */ void b(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = z ^ 0x5FBB11EE61C3L;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/run/AbstractPythonRunConfiguration";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paramsGroup";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testSpecs";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/run/AbstractPythonRunConfiguration";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationEditor";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getWorkingDirectorySafe";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "readExternal";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "writeExternal";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addTestSpecsAsParameters";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

