/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.refactoring.rename;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.PsiElement;
import com.intellij.util.ObjectUtils;
import com.jetbrains.python.codeInsight.PyCodeInsightSettings;
import com.jetbrains.python.psi.Property;
import com.jetbrains.python.psi.PyCallable;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.c;
import com.jetbrains.python.psi.search.PyOverridingMethodsSearch;
import com.jetbrains.python.psi.search.PySuperMethodsSearch;
import com.jetbrains.python.psi.types.TypeEvalContext;
import com.jetbrains.python.pyi.PyiUtil;
import com.jetbrains.python.refactoring.rename.RenamePyElementProcessor;
import com.jetbrains.python.toolbox.Maybe;
import java.lang.invoke.MethodHandles;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RenamePyFunctionProcessor
extends RenamePyElementProcessor {
    private static final long a = c.a(7719685717416705482L, 8648281487817305693L, MethodHandles.lookup().lookupClass()).a(207379492664701L);

    public boolean canProcessElement(@NotNull PsiElement element) {
        if (element == null) {
            RenamePyFunctionProcessor.b(0);
        }
        return element instanceof PyFunction;
    }

    public boolean forcesShowPreview() {
        return true;
    }

    public boolean isToSearchInComments(@NotNull PsiElement element) {
        if (element == null) {
            RenamePyFunctionProcessor.b(1);
        }
        return PyCodeInsightSettings.getInstance().RENAME_SEARCH_IN_COMMENTS_FOR_FUNCTION;
    }

    public void setToSearchInComments(@NotNull PsiElement element, boolean enabled) {
        if (element == null) {
            RenamePyFunctionProcessor.b(2);
        }
        PyCodeInsightSettings.getInstance().RENAME_SEARCH_IN_COMMENTS_FOR_FUNCTION = enabled;
    }

    public boolean isToSearchForTextOccurrences(@NotNull PsiElement element) {
        if (element == null) {
            RenamePyFunctionProcessor.b(3);
        }
        return PyCodeInsightSettings.getInstance().RENAME_SEARCH_NON_CODE_FOR_FUNCTION;
    }

    public void setToSearchForTextOccurrences(@NotNull PsiElement element, boolean enabled) {
        if (element == null) {
            RenamePyFunctionProcessor.b(4);
        }
        PyCodeInsightSettings.getInstance().RENAME_SEARCH_NON_CODE_FOR_FUNCTION = enabled;
    }

    public PsiElement substituteElementToRename(@NotNull PsiElement element, @Nullable Editor editor2) {
        PyTargetExpression pyTargetExpression;
        TypeEvalContext typeEvalContext;
        PyFunction pyFunction;
        PyClass pyClass;
        long l2 = a ^ 0x5C36716B09B9L;
        if (element == null) {
            RenamePyFunctionProcessor.b(5);
        }
        if ((pyClass = (pyFunction = (PyFunction)ObjectUtils.notNull((Object)PyiUtil.getImplementation((PyFunction)element, typeEvalContext = TypeEvalContext.codeInsightFallback(element.getProject())), (Object)((PyFunction)element))).getContainingClass()) == null) {
            return pyFunction;
        }
        if ("__init__".equals(pyFunction.getName())) {
            return pyClass;
        }
        PyFunction pyFunction2 = PySuperMethodsSearch.findDeepestSuperMethod(pyFunction);
        if (!pyFunction2.equals(pyFunction)) {
            String string = "Method " + pyFunction.getName() + " of class " + pyClass.getQualifiedName() + "\noverrides method of class " + pyFunction2.getContainingClass().getQualifiedName() + ".\nDo you want to rename the base method?";
            int n2 = Messages.showYesNoCancelDialog((Project)element.getProject(), (String)string, (String)"Rename", (Icon)Messages.getQuestionIcon());
            switch (n2) {
                case 0: {
                    return pyFunction2;
                }
                case 1: {
                    return pyFunction;
                }
            }
            return null;
        }
        Property property = pyClass.findPropertyByCallable(pyFunction);
        if (property != null && (pyTargetExpression = property.getDefinitionSite()) != null) {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                return pyTargetExpression;
            }
            String string = String.format("Do you want to rename the property '%s' instead of its accessor function '%s'?", property.getName(), pyFunction.getName());
            int n3 = Messages.showYesNoCancelDialog((Project)element.getProject(), (String)string, (String)"Rename", (Icon)Messages.getQuestionIcon());
            switch (n3) {
                case 0: {
                    return pyTargetExpression;
                }
                case 1: {
                    return pyFunction;
                }
            }
            return null;
        }
        return pyFunction;
    }

    public void prepareRenaming(@NotNull PsiElement element, @NotNull String newName, @NotNull Map<PsiElement, String> allRenames) {
        Property property;
        if (element == null) {
            RenamePyFunctionProcessor.b(6);
        }
        if (newName == null) {
            RenamePyFunctionProcessor.b(7);
        }
        if (allRenames == null) {
            RenamePyFunctionProcessor.b(8);
        }
        PyFunction pyFunction2 = (PyFunction)element;
        PyOverridingMethodsSearch.search(pyFunction2, true).forEach(pyFunction -> {
            allRenames.put((PsiElement)pyFunction, newName);
            return true;
        });
        PyiUtil.getOverloads(pyFunction2, TypeEvalContext.codeInsightFallback(element.getProject())).forEach(pyFunction -> allRenames.put((PsiElement)pyFunction, newName));
        PyClass pyClass = pyFunction2.getContainingClass();
        if (pyClass != null && (property = pyClass.findPropertyByCallable(pyFunction2)) != null) {
            RenamePyFunctionProcessor.a(allRenames, newName, property.getGetter());
            RenamePyFunctionProcessor.a(allRenames, newName, property.getSetter());
            RenamePyFunctionProcessor.a(allRenames, newName, property.getDeleter());
        }
    }

    private static void a(@NotNull Map<PsiElement, String> map2, @NotNull String string, @NotNull Maybe<PyCallable> maybe) {
        PyCallable pyCallable;
        if (map2 == null) {
            RenamePyFunctionProcessor.b(9);
        }
        if (string == null) {
            RenamePyFunctionProcessor.b(10);
        }
        if (maybe == null) {
            RenamePyFunctionProcessor.b(11);
        }
        if ((pyCallable = maybe.valueOrNull()) instanceof PyFunction) {
            map2.put((PsiElement)pyCallable, string);
        }
    }

    private static /* synthetic */ void b(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        long l2 = a ^ 0x5A4EE0C78620L;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allRenames";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renames";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accessor";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/python/refactoring/rename/RenamePyFunctionProcessor";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "canProcessElement";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isToSearchInComments";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "setToSearchInComments";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isToSearchForTextOccurrences";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "setToSearchForTextOccurrences";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "substituteElementToRename";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "prepareRenaming";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "addRename";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

