/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.refactoring.introduce;

import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.codeInsight.template.impl.TemplateManagerImpl;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Pass;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.TokenType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.IntroduceTargetChooser;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.introduce.inplace.InplaceVariableIntroducer;
import com.intellij.refactoring.introduce.inplace.OccurrencesChooser;
import com.intellij.refactoring.listeners.RefactoringEventData;
import com.intellij.refactoring.listeners.RefactoringEventListener;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.ObjectUtils;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.PyNames;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.codeInsight.dataflow.scope.ScopeUtil;
import com.jetbrains.python.inspections.PyStringFormatParser;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyArgumentList;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyComprehensionElement;
import com.jetbrains.python.psi.PyDecorator;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyExpressionStatement;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyGeneratorExpression;
import com.jetbrains.python.psi.PyKeywordArgument;
import com.jetbrains.python.psi.PyParameterList;
import com.jetbrains.python.psi.PyParenthesizedExpression;
import com.jetbrains.python.psi.PyRecursiveElementVisitor;
import com.jetbrains.python.psi.PySequenceExpression;
import com.jetbrains.python.psi.PyStatement;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyStringLiteralUtil;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyTupleExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.c;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.types.PyCallableParameter;
import com.jetbrains.python.psi.types.PyNoneType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import com.jetbrains.python.refactoring.NameSuggesterUtil;
import com.jetbrains.python.refactoring.PyRefactoringUtil;
import com.jetbrains.python.refactoring.PyReplaceExpressionUtil;
import com.jetbrains.python.refactoring.introduce.IntroduceOperation;
import com.jetbrains.python.refactoring.introduce.IntroduceValidator;
import com.jetbrains.python.refactoring.introduce.PyIntroduceDialog;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class IntroduceHandler
implements RefactoringActionHandler {
    private final IntroduceValidator a;
    protected final String myDialogTitle;
    private static final long b = c.a(-8446837854967983793L, -7645729977258166337L, MethodHandles.lookup().lookupClass()).a(102296172189239L);

    protected static PsiElement findAnchor(List<? extends PsiElement> occurrences) {
        PyStatement pyStatement;
        Object object = occurrences.get(0);
        Pair pair = (Pair)object.getUserData(PyReplaceExpressionUtil.SELECTION_BREAKS_AST_NODE);
        if (pair != null && occurrences.size() == 1) {
            return PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)pair.getFirst()), PyStatement.class);
        }
        block0: while ((pyStatement = (PyStatement)PsiTreeUtil.getParentOfType((PsiElement)object, PyStatement.class)) != null) {
            PsiElement psiElement = pyStatement.getParent();
            for (PsiElement psiElement2 : occurrences) {
                if (PsiTreeUtil.isAncestor((PsiElement)psiElement, (PsiElement)psiElement2, (boolean)true)) continue;
                object = pyStatement;
                continue block0;
            }
        }
        return pyStatement;
    }

    protected static void ensureName(IntroduceOperation operation) {
        if (operation.getName() == null) {
            Collection<String> collection = operation.getSuggestedNames();
            if (collection.size() > 0) {
                operation.setName(collection.iterator().next());
            } else {
                operation.setName("x");
            }
        }
    }

    @Nullable
    protected static PsiElement findOccurrenceUnderCaret(List<? extends PsiElement> occurrences, Editor editor2) {
        if (occurrences.isEmpty()) {
            return null;
        }
        int n2 = editor2.getCaretModel().getOffset();
        for (PsiElement object2 : occurrences) {
            if (object2 == null || !object2.getTextRange().contains(n2)) continue;
            return object2;
        }
        int n3 = editor2.getDocument().getLineNumber(n2);
        for (PsiElement psiElement : occurrences) {
            PyPsiUtils.assertValid(psiElement);
            if (!psiElement.isValid() || editor2.getDocument().getLineNumber(psiElement.getTextRange().getStartOffset()) != n3) continue;
            return psiElement;
        }
        Iterator<? extends PsiElement> iterator = occurrences.iterator();
        if (iterator.hasNext()) {
            PsiElement psiElement = iterator.next();
            PyPsiUtils.assertValid(psiElement);
            return psiElement;
        }
        return null;
    }

    @Nullable
    protected PsiElement replaceExpression(PsiElement expression, PyExpression newExpression, IntroduceOperation operation) {
        PyExpressionStatement pyExpressionStatement = (PyExpressionStatement)PsiTreeUtil.getParentOfType((PsiElement)expression, PyExpressionStatement.class);
        if (pyExpressionStatement != null && pyExpressionStatement.getExpression() == expression && expression.getUserData(PyReplaceExpressionUtil.SELECTION_BREAKS_AST_NODE) == null) {
            pyExpressionStatement.delete();
            return null;
        }
        return PyReplaceExpressionUtil.replaceExpression(expression, (PsiElement)newExpression);
    }

    protected IntroduceHandler(@NotNull IntroduceValidator validator, @NotNull String dialogTitle) {
        if (validator == null) {
            IntroduceHandler.a(0);
        }
        if (dialogTitle == null) {
            IntroduceHandler.a(1);
        }
        this.a = validator;
        this.myDialogTitle = dialogTitle;
    }

    public void invoke(@NotNull Project project, Editor editor2, PsiFile file, DataContext dataContext) {
        if (project == null) {
            IntroduceHandler.a(2);
        }
        this.performAction(new IntroduceOperation(project, editor2, file, null));
    }

    public void invoke(@NotNull Project project, @NotNull PsiElement[] elements, DataContext dataContext) {
        if (project == null) {
            IntroduceHandler.a(3);
        }
        if (elements == null) {
            IntroduceHandler.a(4);
        }
    }

    public Collection<String> getSuggestedNames(@NotNull PyExpression expression) {
        if (expression == null) {
            IntroduceHandler.a(5);
        }
        Collection<String> collection = this.generateSuggestedNames(expression);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : collection) {
            if (!this.a.checkPossibleName(string, expression)) continue;
            arrayList.add(string);
        }
        if (arrayList.isEmpty()) {
            for (String string : collection) {
                int n2 = 1;
                while (!this.a.checkPossibleName(string + n2, expression)) {
                    ++n2;
                }
                arrayList.add(string + n2);
            }
        }
        return arrayList;
    }

    protected Collection<String> generateSuggestedNames(PyExpression expression) {
        Object object;
        PyType pyType;
        Object object2;
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>(){

            @Override
            public boolean add(String s2) {
                if (PyNames.isReserved(s2)) {
                    return false;
                }
                return super.add(s2);
            }
        };
        String string = expression.getText();
        Pair pair = (Pair)expression.getUserData(PyReplaceExpressionUtil.SELECTION_BREAKS_AST_NODE);
        if (pair != null) {
            string = ((TextRange)pair.getSecond()).substring(((PsiElement)pair.getFirst()).getText());
        }
        if (expression instanceof PyCallExpression && (object2 = ((PyCallExpression)expression).getCallee()) != null) {
            string = object2.getText();
        }
        if (string != null) {
            linkedHashSet.addAll(NameSuggesterUtil.generateNames(string));
        }
        if ((pyType = ((TypeEvalContext)(object2 = TypeEvalContext.userInitiated(expression.getProject(), expression.getContainingFile()))).getType(expression)) != null && pyType != PyNoneType.INSTANCE && (object = pyType.getName()) != null) {
            if (pyType.isBuiltin()) {
                object = ((String)object).substring(0, 1);
            }
            linkedHashSet.addAll(NameSuggesterUtil.generateNamesByType((String)object));
        }
        if ((object = (PyKeywordArgument)PsiTreeUtil.getParentOfType((PsiElement)expression, PyKeywordArgument.class)) != null && object.getValueExpression() == expression) {
            linkedHashSet.add(object.getKeyword());
        }
        Optional.ofNullable(PsiTreeUtil.getParentOfType((PsiElement)expression, PyArgumentList.class)).map(PyArgumentList::getCallExpression).ifPresent(arg_0 -> IntroduceHandler.a((TypeEvalContext)object2, expression, linkedHashSet, arg_0));
        return linkedHashSet;
    }

    public void performAction(IntroduceOperation operation) {
        Object object;
        Object object2;
        PsiFile psiFile = operation.getFile();
        if (!CommonRefactoringUtil.checkReadOnlyStatus((PsiElement)psiFile)) {
            return;
        }
        Editor editor2 = operation.getEditor();
        if (editor2.getSettings().isVariableInplaceRenameEnabled() && (object2 = TemplateManagerImpl.getTemplateState((Editor)operation.getEditor())) != null && !object2.isFinished()) {
            return;
        }
        object2 = null;
        PsiElement psiElement = null;
        SelectionModel selectionModel = editor2.getSelectionModel();
        boolean bl2 = false;
        if (selectionModel.hasSelection()) {
            int n2;
            object2 = psiFile.findElementAt(selectionModel.getSelectionStart());
            psiElement = psiFile.findElementAt(selectionModel.getSelectionEnd() - 1);
            if (object2 instanceof PsiWhiteSpace) {
                n2 = object2.getTextRange().getEndOffset();
                object2 = psiFile.findElementAt(n2);
            }
            if (psiElement instanceof PsiWhiteSpace) {
                n2 = psiElement.getTextRange().getStartOffset();
                psiElement = psiFile.findElementAt(n2 - 1);
            }
            if (object2 == psiElement) {
                bl2 = true;
            }
        } else {
            if (this.b(operation)) {
                return;
            }
            CaretModel caretModel = editor2.getCaretModel();
            object = editor2.getDocument();
            int n3 = object.getLineNumber(caretModel.getOffset());
            if (n3 >= 0 && n3 < object.getLineCount()) {
                object2 = psiFile.findElementAt(object.getLineStartOffset(n3));
                psiElement = psiFile.findElementAt(object.getLineEndOffset(n3) - 1);
            }
        }
        Project project = operation.getProject();
        if (object2 == null || psiElement == null) {
            this.a(project, editor2);
            return;
        }
        object2 = PyRefactoringUtil.getSelectedExpression(project, psiFile, (PsiElement)object2, psiElement);
        object = (PyComprehensionElement)PsiTreeUtil.getParentOfType((PsiElement)object2, PyComprehensionElement.class, (boolean)true);
        if (object2 == null || object != null) {
            this.a(project, editor2);
            return;
        }
        if (bl2 && object2 instanceof PyStringLiteralExpression) {
            PyStringLiteralExpression pyStringLiteralExpression = (PyStringLiteralExpression)object2;
            if (pyStringLiteralExpression.getStringNodes().size() > 1) {
                this.a(project, editor2);
                return;
            }
            int n4 = object2.getTextOffset();
            TextRange textRange = TextRange.create((int)selectionModel.getSelectionStart(), (int)selectionModel.getSelectionEnd());
            TextRange textRange2 = object2.getTextRange();
            if (!textRange2.equals((Object)textRange) && textRange2.contains(textRange)) {
                TextRange textRange3 = pyStringLiteralExpression.getStringValueTextRange();
                TextRange textRange4 = textRange.shiftRight(-n4).intersection(textRange3);
                TextRange textRange5 = textRange4 != null ? textRange4 : textRange;
                String string = pyStringLiteralExpression.getText();
                if (PyStringFormatParser.getFormatValueExpression(pyStringLiteralExpression) != null && IntroduceHandler.c(string, textRange5) || PyStringFormatParser.getNewStyleFormatValueExpression(pyStringLiteralExpression) != null && IntroduceHandler.a(string, textRange5) || IntroduceHandler.b(string, textRange5)) {
                    this.a(project, editor2);
                    return;
                }
                object2.putUserData(PyReplaceExpressionUtil.SELECTION_BREAKS_AST_NODE, (Object)Pair.create((Object)object2, (Object)textRange5));
            }
        }
        if (!this.checkIntroduceContext(psiFile, editor2, (PsiElement)object2)) {
            return;
        }
        operation.setElement((PsiElement)object2);
        this.a(operation);
    }

    private static boolean c(@NotNull String string, @NotNull TextRange textRange) {
        if (string == null) {
            IntroduceHandler.a(6);
        }
        if (textRange == null) {
            IntroduceHandler.a(7);
        }
        return IntroduceHandler.a(PyStringFormatParser.substitutionsToRanges(PyStringFormatParser.filterSubstitutions(PyStringFormatParser.parsePercentFormat(string))), textRange);
    }

    private static boolean a(@NotNull String string, @NotNull TextRange textRange) {
        if (string == null) {
            IntroduceHandler.a(8);
        }
        if (textRange == null) {
            IntroduceHandler.a(9);
        }
        return IntroduceHandler.a(PyStringFormatParser.substitutionsToRanges(PyStringFormatParser.filterSubstitutions(PyStringFormatParser.parseNewStyleFormat(string))), textRange);
    }

    private static boolean b(@NotNull String string, @NotNull TextRange textRange) {
        if (string == null) {
            IntroduceHandler.a(10);
        }
        if (textRange == null) {
            IntroduceHandler.a(11);
        }
        return IntroduceHandler.a(PyStringFormatParser.getEscapeRanges(string), textRange);
    }

    private static boolean a(@NotNull List<TextRange> list2, @NotNull TextRange textRange) {
        if (list2 == null) {
            IntroduceHandler.a(12);
        }
        if (textRange == null) {
            IntroduceHandler.a(13);
        }
        for (TextRange textRange2 : list2) {
            if (textRange.contains(textRange2) || !textRange.intersectsStrict(textRange2)) continue;
            return true;
        }
        return false;
    }

    private void a(Project project, Editor editor2) {
        long l2 = b ^ 0x6CEF2B4ECF68L;
        CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor2, (String)PyBundle.message("refactoring.introduce.selection.error", new Object[0]), (String)this.myDialogTitle, (String)"refactoring.extractMethod");
    }

    private boolean b(final IntroduceOperation introduceOperation) {
        int n2;
        Editor editor2 = introduceOperation.getEditor();
        PsiFile psiFile = introduceOperation.getFile();
        PsiElement psiElement = psiFile.findElementAt(n2 = editor2.getCaretModel().getOffset());
        if ((psiElement instanceof PsiWhiteSpace && n2 == psiElement.getTextOffset() || psiElement == null) && n2 > 0) {
            psiElement = psiFile.findElementAt(n2 - 1);
        }
        if (!this.checkIntroduceContext(psiFile, editor2, psiElement)) {
            return true;
        }
        ArrayList<PyExpression> arrayList = new ArrayList<PyExpression>();
        while (psiElement != null && !(psiElement instanceof PyStatement) && !(psiElement instanceof PyFile)) {
            if (psiElement instanceof PyExpression && IntroduceHandler.a(psiElement)) {
                arrayList.add((PyExpression)psiElement);
            }
            psiElement = psiElement.getParent();
        }
        if (arrayList.size() == 1 || ApplicationManager.getApplication().isUnitTestMode()) {
            introduceOperation.setElement((PsiElement)arrayList.get(0));
            this.a(introduceOperation);
            return true;
        }
        if (arrayList.size() > 1) {
            IntroduceTargetChooser.showChooser((Editor)editor2, arrayList, (Pass)new Pass<PyExpression>(){

                public void pass(PyExpression pyExpression) {
                    introduceOperation.setElement((PsiElement)pyExpression);
                    IntroduceHandler.this.a(introduceOperation);
                }
            }, pyExpression -> pyExpression.getText());
            return true;
        }
        return false;
    }

    protected boolean checkIntroduceContext(PsiFile file, Editor editor2, PsiElement element) {
        long l2 = b ^ 0x64BDEE2EF5C3L;
        if (!this.isValidIntroduceContext(element)) {
            CommonRefactoringUtil.showErrorHint((Project)file.getProject(), (Editor)editor2, (String)PyBundle.message("refactoring.introduce.selection.error", new Object[0]), (String)this.myDialogTitle, (String)"refactoring.extractMethod");
            return false;
        }
        return true;
    }

    protected boolean isValidIntroduceContext(PsiElement element) {
        PyDecorator pyDecorator = (PyDecorator)PsiTreeUtil.getParentOfType((PsiElement)element, PyDecorator.class);
        if (pyDecorator != null && PsiTreeUtil.isAncestor((PsiElement)pyDecorator.getCallee(), (PsiElement)element, (boolean)false)) {
            return false;
        }
        return PsiTreeUtil.getParentOfType((PsiElement)element, PyParameterList.class) == null;
    }

    private static boolean a(PsiElement psiElement) {
        PyCallExpression pyCallExpression = PyUtil.as(psiElement.getParent(), PyCallExpression.class);
        if (pyCallExpression != null && pyCallExpression.getCallee() == psiElement) {
            return false;
        }
        PyComprehensionElement pyComprehensionElement = (PyComprehensionElement)PsiTreeUtil.getParentOfType((PsiElement)psiElement, PyComprehensionElement.class, (boolean)true);
        return pyComprehensionElement == null;
    }

    private void a(IntroduceOperation introduceOperation) {
        if (!this.checkEnabled(introduceOperation)) {
            return;
        }
        PsiElement psiElement = introduceOperation.getElement();
        PsiElement psiElement2 = psiElement.getParent();
        PyExpression pyExpression = psiElement2 instanceof PyAssignmentStatement ? ((PyAssignmentStatement)psiElement2).getAssignedValue() : (PyExpression)psiElement;
        introduceOperation.setInitializer(pyExpression);
        if (pyExpression != null) {
            introduceOperation.setOccurrences(this.getOccurrences(psiElement, pyExpression));
            introduceOperation.setSuggestedNames(this.getSuggestedNames(pyExpression));
        }
        if (introduceOperation.getOccurrences().size() == 0) {
            introduceOperation.setReplaceAll(false);
        }
        this.performActionOnElementOccurrences(introduceOperation);
    }

    protected void performActionOnElementOccurrences(final IntroduceOperation operation) {
        Editor editor2 = operation.getEditor();
        if (editor2.getSettings().isVariableInplaceRenameEnabled()) {
            IntroduceHandler.ensureName(operation);
            if (operation.isReplaceAll() != null) {
                this.performInplaceIntroduce(operation);
            } else {
                OccurrencesChooser.simpleChooser((Editor)editor2).showChooser((Object)operation.getElement(), operation.getOccurrences(), (Pass)new Pass<OccurrencesChooser.ReplaceChoice>(){

                    public void pass(OccurrencesChooser.ReplaceChoice replaceChoice) {
                        operation.setReplaceAll(replaceChoice == OccurrencesChooser.ReplaceChoice.ALL);
                        IntroduceHandler.this.performInplaceIntroduce(operation);
                    }
                });
            }
        } else {
            this.performIntroduceWithDialog(operation);
        }
    }

    protected void performInplaceIntroduce(IntroduceOperation operation) {
        PsiElement psiElement = this.performRefactoring(operation);
        if (psiElement instanceof PyAssignmentStatement) {
            PyTargetExpression pyTargetExpression = (PyTargetExpression)((PyAssignmentStatement)psiElement).getTargets()[0];
            List<PsiElement> list2 = operation.getOccurrences();
            PsiElement psiElement2 = IntroduceHandler.findOccurrenceUnderCaret(list2, operation.getEditor());
            PsiElement psiElement3 = psiElement2 != null ? psiElement2 : pyTargetExpression;
            operation.getEditor().getCaretModel().moveToOffset(psiElement3.getTextRange().getStartOffset());
            PyInplaceVariableIntroducer pyInplaceVariableIntroducer = new PyInplaceVariableIntroducer(pyTargetExpression, operation, list2);
            pyInplaceVariableIntroducer.performInplaceRefactoring(new LinkedHashSet<String>(operation.getSuggestedNames()));
        }
    }

    protected void performIntroduceWithDialog(IntroduceOperation operation) {
        Object object;
        Project project = operation.getProject();
        if (operation.getName() == null) {
            object = new PyIntroduceDialog(project, this.myDialogTitle, this.a, this.getHelpId(), operation);
            if (!object.showAndGet()) {
                return;
            }
            operation.setName(object.getName());
            operation.setReplaceAll(object.doReplaceAllOccurrences());
            operation.setInitPlace(object.getInitPlace());
        }
        object = this.performRefactoring(operation);
        Editor editor2 = operation.getEditor();
        editor2.getCaretModel().moveToOffset(object.getTextRange().getEndOffset());
        editor2.getSelectionModel().removeSelection();
    }

    protected PsiElement performRefactoring(IntroduceOperation operation) {
        PyAssignmentStatement pyAssignmentStatement = this.createDeclaration(operation);
        pyAssignmentStatement = this.a(pyAssignmentStatement, operation);
        pyAssignmentStatement = CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement((PsiElement)pyAssignmentStatement);
        return pyAssignmentStatement;
    }

    public PyAssignmentStatement createDeclaration(IntroduceOperation operation) {
        long l2 = b ^ 0x7D7806527E40L;
        Project project = operation.getProject();
        PyExpression pyExpression = operation.getInitializer();
        String string = operation.getName() + " = " + new InitializerTextBuilder(pyExpression).result();
        PsiElement psiElement = operation.isReplaceAll() != false ? IntroduceHandler.findAnchor(operation.getOccurrences()) : PsiTreeUtil.getParentOfType((PsiElement)pyExpression, PyStatement.class);
        return this.createDeclaration(project, string, psiElement);
    }

    protected abstract String getHelpId();

    protected PyAssignmentStatement createDeclaration(Project project, String assignmentText, PsiElement anchor) {
        LanguageLevel languageLevel = ((PyFile)anchor.getContainingFile()).getLanguageLevel();
        return PyElementGenerator.getInstance(project).createFromText(languageLevel, PyAssignmentStatement.class, assignmentText);
    }

    protected boolean checkEnabled(IntroduceOperation operation) {
        return true;
    }

    protected List<PsiElement> getOccurrences(PsiElement element, @NotNull PyExpression expression) {
        if (expression == null) {
            IntroduceHandler.a(14);
        }
        return PyRefactoringUtil.getOccurrences((PsiElement)expression, (PsiElement)ScopeUtil.getScopeOwner((PsiElement)expression));
    }

    private PsiElement a(@NotNull PsiElement psiElement, IntroduceOperation introduceOperation) {
        if (psiElement == null) {
            IntroduceHandler.a(15);
        }
        PyExpression pyExpression = introduceOperation.getInitializer();
        Project project = introduceOperation.getProject();
        SmartPsiElementPointer smartPsiElementPointer = (SmartPsiElementPointer)WriteCommandAction.writeCommandAction((Project)project, (PsiFile[])new PsiFile[]{pyExpression.getContainingFile()}).compute(() -> {
            PsiElement psiElement2;
            RefactoringEventData refactoringEventData;
            try {
                refactoringEventData = new RefactoringEventData();
                refactoringEventData.addElement(psiElement);
                ((RefactoringEventListener)project.getMessageBus().syncPublisher(RefactoringEventListener.REFACTORING_EVENT_TOPIC)).refactoringStarted(this.getRefactoringId(), refactoringEventData);
                psiElement2 = this.addDeclaration(introduceOperation, psiElement);
                PyExpression pyExpression2 = this.createExpression(project, introduceOperation.getName(), psiElement);
                if (introduceOperation.isReplaceAll().booleanValue()) {
                    ArrayList<PsiElement> arrayList = new ArrayList<PsiElement>();
                    for (PsiElement psiElement3 : introduceOperation.getOccurrences()) {
                        PsiElement psiElement4 = this.replaceExpression(psiElement3, pyExpression2, introduceOperation);
                        if (psiElement4 == null) continue;
                        arrayList.add(psiElement4);
                    }
                    introduceOperation.setOccurrences(arrayList);
                } else {
                    PsiElement psiElement5 = this.replaceExpression((PsiElement)pyExpression, pyExpression2, introduceOperation);
                    introduceOperation.setOccurrences(Collections.singletonList(psiElement5));
                }
                this.postRefactoring(introduceOperation.getElement());
            }
            finally {
                refactoringEventData = new RefactoringEventData();
                refactoringEventData.addElement(psiElement);
                ((RefactoringEventListener)project.getMessageBus().syncPublisher(RefactoringEventListener.REFACTORING_EVENT_TOPIC)).refactoringDone(this.getRefactoringId(), refactoringEventData);
            }
            return (SmartPsiElementPointer)ObjectUtils.doIfNotNull((Object)psiElement2, SmartPointerManager::createPointer);
        });
        return (PsiElement)ObjectUtils.doIfNotNull((Object)smartPsiElementPointer, SmartPsiElementPointer::getElement);
    }

    protected abstract String getRefactoringId();

    @Nullable
    public PsiElement addDeclaration(IntroduceOperation operation, PsiElement declaration) {
        PyExpression pyExpression = operation.getInitializer();
        Pair pair = (Pair)pyExpression.getUserData(PyReplaceExpressionUtil.SELECTION_BREAKS_AST_NODE);
        if (pair == null) {
            return this.addDeclaration((PsiElement)pyExpression, declaration, operation);
        }
        return this.addDeclaration((PsiElement)pair.first, declaration, operation);
    }

    protected PyExpression createExpression(Project project, String name, PsiElement declaration) {
        return PyElementGenerator.getInstance(project).createExpressionFromText(LanguageLevel.forElement(declaration), name);
    }

    @Nullable
    protected abstract PsiElement addDeclaration(@NotNull PsiElement var1, @NotNull PsiElement var2, @NotNull IntroduceOperation var3);

    protected void postRefactoring(PsiElement element) {
    }

    private static /* synthetic */ void a(TypeEvalContext typeEvalContext, PyExpression pyExpression, Collection collection, PyCallExpression pyCallExpression) {
        StreamEx.of(pyCallExpression.multiMapArguments(PyResolveContext.noImplicits().withTypeEvalContext(typeEvalContext))).map(pyArgumentsMapping -> pyArgumentsMapping.getMappedParameters().get(pyExpression)).nonNull().map(PyCallableParameter::getName).forEach(collection::add);
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        long l2 = b ^ 0x6F964D591CFEL;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "validator";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialogTitle";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 5: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 6: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 7: 
            case 9: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ranges";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaration";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/python/refactoring/introduce/IntroduceHandler";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "invoke";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getSuggestedNames";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "breaksStringFormatting";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "breaksNewStyleStringFormatting";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "breaksStringEscaping";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "breaksRanges";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "getOccurrences";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "performReplace";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class PyInplaceVariableIntroducer
    extends InplaceVariableIntroducer<PsiElement> {
        private final PyTargetExpression a;
        private static final long b = c.a(-4994604268230297358L, 1811020770816056542L, MethodHandles.lookup().lookupClass()).a(46005602772911L);

        PyInplaceVariableIntroducer(PyTargetExpression target, IntroduceOperation operation, List<PsiElement> occurrences) {
            long l2 = b ^ 0x57A987BC85AEL;
            super((PsiNamedElement)target, operation.getEditor(), operation.getProject(), "Introduce Variable", occurrences.toArray(PsiElement.EMPTY_ARRAY), null);
            this.a = target;
        }

        protected PsiElement checkLocalScope() {
            return this.a.getContainingFile();
        }
    }

    private static class InitializerTextBuilder
    extends PyRecursiveElementVisitor {
        private final StringBuilder b;
        private final boolean a;
        private static final long c = com.jetbrains.python.psi.c.a(-5052279107181092293L, 5401628163985764235L, MethodHandles.lookup().lookupClass()).a(250552026730364L);

        InitializerTextBuilder(@NotNull PyExpression expression) {
            if (expression == null) {
                InitializerTextBuilder.a(0);
            }
            this.b = new StringBuilder();
            this.a = InitializerTextBuilder.a(expression);
            if (PsiTreeUtil.findChildOfType((PsiElement)expression, PsiComment.class) != null) {
                this.b.append(expression.getText());
            } else {
                expression.accept(this);
            }
            if (InitializerTextBuilder.b(expression)) {
                this.b.insert(0, "(").append(")");
            }
        }

        public void visitWhiteSpace(PsiWhiteSpace space) {
            String string = space.getText();
            this.b.append(this.a ? string : string.replace('\n', ' ').replace("\\", ""));
        }

        @Override
        public void visitPyStringLiteralExpression(PyStringLiteralExpression node) {
            Pair pair = (Pair)node.getUserData(PyReplaceExpressionUtil.SELECTION_BREAKS_AST_NODE);
            if (pair != null) {
                PsiElement psiElement = (PsiElement)pair.getFirst();
                String string = psiElement.getText();
                Pair pair2 = PyStringLiteralUtil.getQuotes(string);
                Pair pair3 = pair2 != null ? pair2 : Pair.create((Object)"'", (Object)"'");
                TextRange textRange = (TextRange)pair.getSecond();
                String string2 = textRange.substring(string);
                this.b.append((String)pair3.getFirst()).append(string2).append((String)pair3.getSecond());
            } else {
                for (ASTNode aSTNode = node.getNode().getFirstChildNode(); aSTNode != null; aSTNode = aSTNode.getTreeNext()) {
                    String string = aSTNode.getText();
                    if (aSTNode.getElementType() == TokenType.WHITE_SPACE) {
                        if (!string.contains("\n")) continue;
                        if (!string.contains("\\")) {
                            this.b.append("\\");
                        }
                        this.b.append(string);
                        continue;
                    }
                    this.b.append(string);
                }
            }
        }

        @Override
        public void visitElement(PsiElement element) {
            if (element.getChildren().length == 0) {
                this.b.append(element.getText());
            } else {
                super.visitElement(element);
            }
        }

        private static boolean a(@NotNull PyExpression pyExpression) {
            if (pyExpression == null) {
                InitializerTextBuilder.a(1);
            }
            if (pyExpression instanceof PyParenthesizedExpression) {
                return ((PyParenthesizedExpression)pyExpression).getContainedExpression() instanceof PyTupleExpression;
            }
            return pyExpression instanceof PySequenceExpression && !(pyExpression instanceof PyTupleExpression);
        }

        private static boolean b(@NotNull PyExpression pyExpression) {
            PsiElement psiElement;
            if (pyExpression == null) {
                InitializerTextBuilder.a(2);
            }
            return pyExpression instanceof PyGeneratorExpression && (psiElement = pyExpression.getFirstChild()) != null && psiElement.getNode().getElementType() != PyTokenTypes.LPAR;
        }

        public String result() {
            return this.b.toString();
        }

        private static /* synthetic */ void a(int n2) {
            Object[] objectArray;
            Object[] objectArray2;
            long l2 = c ^ 0x40AD179ECFB2L;
            Object[] objectArray3 = new Object[3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/python/refactoring/introduce/IntroduceHandler$InitializerTextBuilder";
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "shouldPreserveFormatting";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "needToWrapTopLevelExpressionInParenthesis";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static final class InitPlace
    extends Enum<InitPlace> {
        public static final /* enum */ InitPlace SAME_METHOD;
        public static final /* enum */ InitPlace CONSTRUCTOR;
        public static final /* enum */ InitPlace SET_UP;
        private static final /* synthetic */ InitPlace[] a;

        public static InitPlace[] values() {
            return (InitPlace[])a.clone();
        }

        public static InitPlace valueOf(String name) {
            return Enum.valueOf(InitPlace.class, name);
        }

        static {
            long l2 = c.a(-653017749446879812L, 2519733247304356961L, MethodHandles.lookup().lookupClass()).a(89693784432186L) ^ 0x6DC571E8CB44L;
            SAME_METHOD = new InitPlace();
            CONSTRUCTOR = new InitPlace();
            SET_UP = new InitPlace();
            a = new InitPlace[]{SAME_METHOD, CONSTRUCTOR, SET_UP};
        }
    }
}

