/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.refactoring.classes;

import com.google.common.collect.Collections2;
import com.intellij.lang.ASTNode;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.light.LightElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.psi.util.QualifiedName;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.NotNullPredicate;
import com.jetbrains.python.PyNames;
import com.jetbrains.python.codeInsight.PyCodeInsightSettings;
import com.jetbrains.python.codeInsight.imports.AddImportHelper;
import com.jetbrains.python.codeInsight.imports.PyImportOptimizer;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyArgumentList;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyExpressionStatement;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyImportElement;
import com.jetbrains.python.psi.PyImportStatementBase;
import com.jetbrains.python.psi.PyImportedNameDefiner;
import com.jetbrains.python.psi.PyRecursiveElementVisitor;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyStarImportElement;
import com.jetbrains.python.psi.PyStatementList;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.c;
import com.jetbrains.python.psi.impl.PyBuiltinCache;
import com.jetbrains.python.psi.impl.PyImportedModule;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.psi.resolve.QualifiedNameFinder;
import com.jetbrains.python.psi.types.PyClassLikeType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import com.jetbrains.python.refactoring.classes.PyDependenciesComparator;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PyClassRefactoringUtil {
    private static final Logger a;
    private static final Key<PsiNamedElement> d;
    private static final Key<Boolean> c;
    private static final Key<String> b;
    private static final long e;

    private PyClassRefactoringUtil() {
    }

    @NotNull
    public static List<PyAssignmentStatement> copyFieldDeclarationToStatement(@NotNull Collection<? extends PyAssignmentStatement> assignmentStatements, @NotNull PyStatementList superClassStatement, @Nullable PyClass dequalifyIfDeclaredInClass) {
        if (assignmentStatements == null) {
            PyClassRefactoringUtil.a(0);
        }
        if (superClassStatement == null) {
            PyClassRefactoringUtil.a(1);
        }
        ArrayList<PyAssignmentStatement> arrayList = new ArrayList<PyAssignmentStatement>(assignmentStatements.size());
        Collections.sort(arrayList, PyDependenciesComparator.INSTANCE);
        for (PyAssignmentStatement pyAssignmentStatement : assignmentStatements) {
            PyExpression pyExpression = pyAssignmentStatement.getAssignedValue();
            PyAssignmentStatement pyAssignmentStatement2 = (PyAssignmentStatement)pyAssignmentStatement.copy();
            if (pyExpression instanceof PyReferenceExpression && dequalifyIfDeclaredInClass != null) {
                String string = PyClassRefactoringUtil.a((PyReferenceExpression)pyExpression, dequalifyIfDeclaredInClass);
                PyClassRefactoringUtil.a(pyAssignmentStatement2, string);
            }
            arrayList.add(PyUtil.addElementToStatementList(pyAssignmentStatement2, superClassStatement));
            PyPsiUtils.removeRedundantPass(superClassStatement);
        }
        ArrayList<PyAssignmentStatement> arrayList2 = arrayList;
        if (arrayList2 == null) {
            PyClassRefactoringUtil.a(2);
        }
        return arrayList2;
    }

    private static void a(@NotNull PyAssignmentStatement pyAssignmentStatement, @NotNull String string) {
        if (pyAssignmentStatement == null) {
            PyClassRefactoringUtil.a(3);
        }
        if (string == null) {
            PyClassRefactoringUtil.a(4);
        }
        PyExpression pyExpression = pyAssignmentStatement.getAssignedValue();
        PyExpression pyExpression2 = PyElementGenerator.getInstance(pyAssignmentStatement.getProject()).createExpressionFromText(LanguageLevel.forElement(pyAssignmentStatement), string);
        if (pyExpression != null) {
            pyExpression.replace((PsiElement)pyExpression2);
        } else {
            pyAssignmentStatement.add((PsiElement)pyExpression2);
        }
    }

    @NotNull
    private static String a(@NotNull PyReferenceExpression pyReferenceExpression, @NotNull PyClass pyClass) {
        PyExpression pyExpression;
        if (pyReferenceExpression == null) {
            PyClassRefactoringUtil.a(5);
        }
        if (pyClass == null) {
            PyClassRefactoringUtil.a(6);
        }
        if ((pyExpression = pyReferenceExpression.getQualifier()) instanceof PyReferenceExpression && ((PyReferenceExpression)pyExpression).getReference().isReferenceTo((PsiElement)pyClass)) {
            String string = pyReferenceExpression.getName();
            String string2 = string != null ? string : pyReferenceExpression.getText();
            if (string2 == null) {
                PyClassRefactoringUtil.a(7);
            }
            return string2;
        }
        String string = pyReferenceExpression.getText();
        if (string == null) {
            PyClassRefactoringUtil.a(8);
        }
        return string;
    }

    @NotNull
    public static List<PyFunction> copyMethods(Collection<? extends PyFunction> methods, PyClass superClass, boolean skipIfExist) {
        if (methods.isEmpty()) {
            List<PyFunction> list2 = Collections.emptyList();
            if (list2 == null) {
                PyClassRefactoringUtil.a(9);
            }
            return list2;
        }
        for (PsiElement psiElement : methods) {
            PyClassRefactoringUtil.rememberNamedReferences(psiElement, new String[0]);
        }
        PyFunction[] pyFunctionArray = methods.toArray(PyFunction.EMPTY_ARRAY);
        List<PyFunction> list3 = PyClassRefactoringUtil.addMethods(superClass, skipIfExist, pyFunctionArray);
        if (list3 == null) {
            PyClassRefactoringUtil.a(10);
        }
        return list3;
    }

    @NotNull
    public static List<PyFunction> addMethods(@NotNull PyClass destination, boolean skipIfExist, PyFunction ... methods) {
        if (destination == null) {
            PyClassRefactoringUtil.a(11);
        }
        if (methods == null) {
            PyClassRefactoringUtil.a(12);
        }
        PyStatementList pyStatementList = destination.getStatementList();
        ArrayList<PyFunction> arrayList = new ArrayList<PyFunction>(methods.length);
        for (PyFunction pyFunction : methods) {
            PyFunction pyFunction2 = destination.findMethodByName(pyFunction.getName(), false, null);
            if (pyFunction2 != null && skipIfExist) {
                arrayList.add(pyFunction2);
                continue;
            }
            PyFunction pyFunction3 = PyClassRefactoringUtil.a(pyStatementList, pyFunction);
            arrayList.add(pyFunction3);
            PyClassRefactoringUtil.restoreNamedReferences(pyFunction3);
        }
        PyPsiUtils.removeRedundantPass(pyStatementList);
        ArrayList<PyFunction> arrayList2 = arrayList;
        if (arrayList2 == null) {
            PyClassRefactoringUtil.a(13);
        }
        return arrayList2;
    }

    @NotNull
    private static PyFunction a(@NotNull PyStatementList pyStatementList, @NotNull PyFunction pyFunction) {
        boolean bl2;
        if (pyStatementList == null) {
            PyClassRefactoringUtil.a(14);
        }
        if (pyFunction == null) {
            PyClassRefactoringUtil.a(15);
        }
        if (!(bl2 = PyUtil.isInit(pyFunction))) {
            PyFunction pyFunction2 = (PyFunction)pyStatementList.add(pyFunction);
            if (pyFunction2 == null) {
                PyClassRefactoringUtil.a(16);
            }
            return pyFunction2;
        }
        for (PsiElement psiElement : pyStatementList.getChildren()) {
            boolean bl3 = psiElement instanceof PyExpressionStatement;
            boolean bl4 = psiElement instanceof PyAssignmentStatement;
            if (bl3 || bl4) continue;
            PyFunction pyFunction3 = (PyFunction)pyStatementList.addBefore(pyFunction, psiElement);
            if (pyFunction3 == null) {
                PyClassRefactoringUtil.a(17);
            }
            return pyFunction3;
        }
        PyFunction pyFunction4 = (PyFunction)pyStatementList.add(pyFunction);
        if (pyFunction4 == null) {
            PyClassRefactoringUtil.a(18);
        }
        return pyFunction4;
    }

    public static void restoreNamedReferences(@NotNull PsiElement element) {
        if (element == null) {
            PyClassRefactoringUtil.a(19);
        }
        PyClassRefactoringUtil.restoreNamedReferences(element, null);
    }

    public static void restoreNamedReferences(@NotNull PsiElement newElement, @Nullable PsiElement oldElement) {
        if (newElement == null) {
            PyClassRefactoringUtil.a(20);
        }
        PyClassRefactoringUtil.restoreNamedReferences(newElement, oldElement, PsiElement.EMPTY_ARRAY);
    }

    public static void restoreNamedReferences(final @NotNull PsiElement newElement, final @Nullable PsiElement oldElement, final @NotNull PsiElement[] otherMovedElements) {
        if (newElement == null) {
            PyClassRefactoringUtil.a(21);
        }
        if (otherMovedElements == null) {
            PyClassRefactoringUtil.a(22);
        }
        newElement.acceptChildren((PsiElementVisitor)new PyRecursiveElementVisitor(){

            @Override
            public void visitPyReferenceExpression(PyReferenceExpression node) {
                super.visitPyReferenceExpression(node);
                PyClassRefactoringUtil.restoreReference(node, node, otherMovedElements);
            }

            @Override
            public void visitPyStringLiteralExpression(PyStringLiteralExpression node) {
                super.visitPyStringLiteralExpression(node);
                if (oldElement != null) {
                    for (PsiReference psiReference : node.getReferences()) {
                        if (!psiReference.isReferenceTo(oldElement)) continue;
                        psiReference.bindToElement(newElement);
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void restoreReference(@NotNull PyReferenceExpression sourceNode, @NotNull PyReferenceExpression targetNode, @NotNull PsiElement[] otherMovedElements) {
        if (sourceNode == null) {
            PyClassRefactoringUtil.a(23);
        }
        if (targetNode == null) {
            PyClassRefactoringUtil.a(24);
        }
        if (otherMovedElements == null) {
            PyClassRefactoringUtil.a(25);
        }
        try {
            PyFunction pyFunction;
            PyClass pyClass;
            Object object = (PsiNamedElement)sourceNode.getCopyableUserData(d);
            String string = (String)sourceNode.getCopyableUserData(b);
            Boolean bl2 = (Boolean)sourceNode.getCopyableUserData(c);
            if (object instanceof PsiDirectory) {
                object = (PsiNamedElement)PyUtil.getPackageElement((PsiDirectory)object, (PsiElement)sourceNode);
            }
            if (object instanceof PyFunction && (pyClass = (pyFunction = (PyFunction)object).getContainingClass()) != null && pyClass.multiFindInitOrNew(false, null).contains(pyFunction)) {
                object = pyClass;
            }
            if (object == null) {
                return;
            }
            if (PsiTreeUtil.isAncestor((PsiElement)targetNode.getContainingFile(), (PsiElement)object, (boolean)false)) {
                return;
            }
            if (ArrayUtil.contains((Object)object, (Object[])otherMovedElements)) {
                return;
            }
            if (object instanceof PyFile || object instanceof PsiDirectory) {
                PyClassRefactoringUtil.insertImport((PsiElement)targetNode, object, string, bl2 != null ? bl2 : true);
            } else {
                PyClassRefactoringUtil.insertImport((PsiElement)targetNode, object, string, true);
            }
        }
        finally {
            sourceNode.putCopyableUserData(d, null);
            sourceNode.putCopyableUserData(b, null);
            sourceNode.putCopyableUserData(c, null);
        }
    }

    public static void insertImport(PsiElement anchor, Collection<? extends PsiNamedElement> elements) {
        for (PsiNamedElement psiNamedElement : elements) {
            PyClassRefactoringUtil.insertImport(anchor, psiNamedElement);
        }
    }

    public static boolean isValidQualifiedName(QualifiedName name) {
        if (name == null) {
            return false;
        }
        List list2 = name.getComponents();
        if (list2.isEmpty()) {
            return false;
        }
        for (String string : list2) {
            if (PyNames.isIdentifier(string) && !PyNames.isReserved(string)) continue;
            return false;
        }
        return true;
    }

    public static boolean insertImport(@NotNull PsiElement anchor, @NotNull PsiNamedElement element) {
        if (anchor == null) {
            PyClassRefactoringUtil.a(26);
        }
        if (element == null) {
            PyClassRefactoringUtil.a(27);
        }
        return PyClassRefactoringUtil.insertImport(anchor, element, null);
    }

    public static boolean insertImport(@NotNull PsiElement anchor, @NotNull PsiNamedElement element, @Nullable String asName) {
        if (anchor == null) {
            PyClassRefactoringUtil.a(28);
        }
        if (element == null) {
            PyClassRefactoringUtil.a(29);
        }
        return PyClassRefactoringUtil.insertImport(anchor, element, asName, PyCodeInsightSettings.getInstance().PREFER_FROM_IMPORT);
    }

    public static boolean insertImport(@NotNull PsiElement anchor, @NotNull PsiNamedElement element, @Nullable String asName, boolean preferFromImport) {
        String string;
        QualifiedName qualifiedName;
        boolean bl2;
        PsiFile psiFile;
        if (anchor == null) {
            PyClassRefactoringUtil.a(30);
        }
        if (element == null) {
            PyClassRefactoringUtil.a(31);
        }
        if (PyBuiltinCache.getInstance((PsiElement)element).isBuiltin((PsiElement)element)) {
            return false;
        }
        Object object = element instanceof PsiDirectory ? (PsiFileSystemItem)element : element.getContainingFile();
        if (object == (psiFile = anchor.getContainingFile())) {
            return false;
        }
        QualifiedName qualifiedName2 = QualifiedNameFinder.findCanonicalImportPath((PsiElement)element, anchor);
        if (qualifiedName2 == null || !PyClassRefactoringUtil.isValidQualifiedName(qualifiedName2)) {
            return false;
        }
        boolean bl3 = bl2 = element instanceof PyFile || element instanceof PsiDirectory;
        if (bl2) {
            qualifiedName = qualifiedName2.removeLastComponent();
            string = qualifiedName2.getLastComponent();
        } else {
            qualifiedName = qualifiedName2;
            string = PyClassRefactoringUtil.getOriginalName(element);
        }
        AddImportHelper.ImportPriority importPriority = AddImportHelper.getImportPriority(anchor, object);
        if (preferFromImport && !qualifiedName.getComponents().isEmpty() || !bl2) {
            return AddImportHelper.addOrUpdateFromImportStatement(psiFile, qualifiedName.toString(), string, asName, importPriority, anchor);
        }
        return AddImportHelper.addImportStatement(psiFile, qualifiedName.append(string).toString(), asName, importPriority, anchor);
    }

    public static void rememberNamedReferences(final @NotNull PsiElement element, final String ... namesToSkip) {
        if (element == null) {
            PyClassRefactoringUtil.a(32);
        }
        if (namesToSkip == null) {
            PyClassRefactoringUtil.a(33);
        }
        element.accept((PsiElementVisitor)new PyRecursiveElementVisitor(){

            @Override
            public void visitPyReferenceExpression(PyReferenceExpression node) {
                super.visitPyReferenceExpression(node);
                if (PsiTreeUtil.getParentOfType((PsiElement)node, PyImportStatementBase.class) != null) {
                    return;
                }
                PyImportedNameDefiner pyImportedNameDefiner = PyClassRefactoringUtil.b(node);
                if (pyImportedNameDefiner != null && PsiTreeUtil.isAncestor((PsiElement)element, (PsiElement)pyImportedNameDefiner, (boolean)false)) {
                    return;
                }
                if (!ArrayUtil.contains((String)node.getText(), (String[])namesToSkip)) {
                    PyClassRefactoringUtil.a(node, element);
                }
            }
        });
    }

    private static void a(@NotNull PyReferenceExpression pyReferenceExpression, @NotNull PsiElement psiElement) {
        PyExpression pyExpression;
        long l2 = e ^ 0x43D5F8DBA498L;
        if (pyReferenceExpression == null) {
            PyClassRefactoringUtil.a(34);
        }
        if (psiElement == null) {
            PyClassRefactoringUtil.a(35);
        }
        if ((pyExpression = pyReferenceExpression.getQualifier()) != null && !(PyClassRefactoringUtil.a(pyExpression) instanceof PyImportedModule)) {
            return;
        }
        List<PsiElement> list2 = PyClassRefactoringUtil.a(pyReferenceExpression);
        Object object = (PsiElement)ContainerUtil.getFirstItem(list2);
        if (object instanceof PsiNamedElement && !PsiTreeUtil.isAncestor((PsiElement)psiElement, (PsiElement)object, (boolean)false)) {
            PyImportedNameDefiner pyImportedNameDefiner = PyClassRefactoringUtil.b(pyReferenceExpression);
            if (!PyUtil.inSameFile(psiElement, object) && pyImportedNameDefiner == null && !(object instanceof PsiFileSystemItem)) {
                return;
            }
            if (object instanceof PyTargetExpression && "__all__".equals(((PyTargetExpression)object).getName())) {
                for (PsiElement psiElement2 : list2) {
                    QualifiedName qualifiedName;
                    if (!(psiElement2 instanceof PyImportElement) || (qualifiedName = ((PyImportElement)psiElement2).getImportedQName()) == null) continue;
                    object = new DynamicNamedElement(object.getContainingFile(), qualifiedName.toString());
                    break;
                }
            }
            pyReferenceExpression.putCopyableUserData(d, (PsiNamedElement)object);
            if (pyImportedNameDefiner instanceof PyImportElement) {
                pyReferenceExpression.putCopyableUserData(b, ((PyImportElement)pyImportedNameDefiner).getAsName());
            }
            pyReferenceExpression.putCopyableUserData(c, pyExpression == null);
        }
    }

    @Nullable
    private static PyImportedNameDefiner b(PyReferenceExpression pyReferenceExpression) {
        for (ResolveResult resolveResult : pyReferenceExpression.getReference().multiResolve(false)) {
            PsiElement psiElement = resolveResult.getElement();
            if (psiElement instanceof PyImportElement) {
                return (PyImportElement)psiElement;
            }
            if (!(psiElement instanceof PyStarImportElement)) continue;
            return (PyStarImportElement)psiElement;
        }
        return null;
    }

    @Nullable
    private static PsiElement a(@NotNull PyExpression pyExpression) {
        if (pyExpression == null) {
            PyClassRefactoringUtil.a(36);
        }
        if (pyExpression instanceof PyReferenceExpression) {
            return ((PyReferenceExpression)pyExpression).getReference().resolve();
        }
        return null;
    }

    @NotNull
    private static List<PsiElement> a(@NotNull PyReferenceExpression pyReferenceExpression) {
        if (pyReferenceExpression == null) {
            PyClassRefactoringUtil.a(37);
        }
        List list2 = ContainerUtil.mapNotNull((Object[])pyReferenceExpression.getReference().multiResolve(false), resolveResult -> resolveResult.getElement());
        if (list2 == null) {
            PyClassRefactoringUtil.a(38);
        }
        return list2;
    }

    public static void forceAsName(@NotNull PyReferenceExpression node, @NotNull String asName) {
        long l2 = e ^ 0x4F5B73908EBCL;
        if (node == null) {
            PyClassRefactoringUtil.a(39);
        }
        if (asName == null) {
            PyClassRefactoringUtil.a(40);
        }
        if (node.getCopyableUserData(d) == null) {
            a.warn("As name is forced on the referenceExpression, that has no encoded import. Forcing it will likely be ignored.");
        }
        node.putCopyableUserData(b, asName);
    }

    public static void transferEncodedImports(@NotNull PyReferenceExpression source, @NotNull PyReferenceExpression target) {
        if (source == null) {
            PyClassRefactoringUtil.a(41);
        }
        if (target == null) {
            PyClassRefactoringUtil.a(42);
        }
        target.putCopyableUserData(d, source.getCopyableUserData(d));
        target.putCopyableUserData(b, source.getCopyableUserData(b));
        target.putCopyableUserData(c, source.getCopyableUserData(c));
        source.putCopyableUserData(d, null);
        source.putCopyableUserData(b, null);
        source.putCopyableUserData(c, null);
    }

    public static boolean hasEncodedTarget(@NotNull PyReferenceExpression node) {
        if (node == null) {
            PyClassRefactoringUtil.a(43);
        }
        return node.getCopyableUserData(d) != null;
    }

    public static boolean updateUnqualifiedImportOfElement(@NotNull PyImportStatementBase importStatement, @NotNull PsiNamedElement element) {
        String string;
        if (importStatement == null) {
            PyClassRefactoringUtil.a(44);
        }
        if (element == null) {
            PyClassRefactoringUtil.a(45);
        }
        if ((string = PyClassRefactoringUtil.getOriginalName(element)) != null) {
            PyImportElement pyImportElement = null;
            for (PyImportElement pyImportElement2 : importStatement.getImportElements()) {
                if (!string.equals(PyClassRefactoringUtil.a(pyImportElement2))) continue;
                pyImportElement = pyImportElement2;
            }
            if (pyImportElement != null) {
                PsiFile psiFile = importStatement.getContainingFile();
                PsiFile psiFile2 = element.getContainingFile();
                if (psiFile2 == psiFile || PyClassRefactoringUtil.insertImport((PsiElement)importStatement, element, pyImportElement.getAsName(), true)) {
                    if (importStatement.getImportElements().length == 1) {
                        int n2 = InjectedLanguageManager.getInstance((Project)pyImportElement.getProject()).isInjectedFragment(pyImportElement.getContainingFile()) ? 1 : 0;
                        if (n2 == 0) {
                            importStatement.delete();
                        } else {
                            PyClassRefactoringUtil.a(importStatement);
                        }
                    } else {
                        pyImportElement.delete();
                    }
                    return true;
                }
            }
        }
        return false;
    }

    private static void a(@NotNull PyImportStatementBase pyImportStatementBase) {
        if (pyImportStatementBase == null) {
            PyClassRefactoringUtil.a(46);
        }
        PsiElement psiElement = pyImportStatementBase.getPrevSibling();
        pyImportStatementBase.delete();
        if (psiElement instanceof PsiWhiteSpace) {
            psiElement.delete();
        }
    }

    @Nullable
    public static String getOriginalName(@NotNull PsiNamedElement element) {
        if (element == null) {
            PyClassRefactoringUtil.a(47);
        }
        if (element instanceof PyFile) {
            VirtualFile virtualFile = PsiUtilBase.asVirtualFile((PsiElement)PyUtil.turnInitIntoDir((PsiElement)element));
            if (virtualFile != null) {
                return virtualFile.getNameWithoutExtension();
            }
            return null;
        }
        return element.getName();
    }

    @Nullable
    private static String a(PyImportElement pyImportElement) {
        QualifiedName qualifiedName = pyImportElement.getImportedQName();
        if (qualifiedName != null && qualifiedName.getComponentCount() > 0) {
            return (String)qualifiedName.getComponents().get(0);
        }
        return null;
    }

    public static void addSuperclasses(@NotNull Project project, @NotNull PyClass clazz, PyClass ... superClasses) {
        if (project == null) {
            PyClassRefactoringUtil.a(48);
        }
        if (clazz == null) {
            PyClassRefactoringUtil.a(49);
        }
        if (superClasses == null) {
            PyClassRefactoringUtil.a(50);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (PyClass pyClass : Collections2.filter(Arrays.asList(superClasses), NotNullPredicate.INSTANCE)) {
            if (pyClass.getName() == null) continue;
            arrayList.add(pyClass.getName());
            PyClassRefactoringUtil.insertImport((PsiElement)clazz, (PsiNamedElement)pyClass);
        }
        PyClassRefactoringUtil.a(project, clazz, arrayList, null);
    }

    private static void a(@NotNull Project project, @NotNull PyClass pyClass, @Nullable Collection<String> collection, @Nullable Collection<Pair<String, String>> collection2) {
        long l2 = e ^ 0x7F9D7B102FF0L;
        if (project == null) {
            PyClassRefactoringUtil.a(51);
        }
        if (pyClass == null) {
            PyClassRefactoringUtil.a(52);
        }
        PyElementGenerator pyElementGenerator = PyElementGenerator.getInstance(project);
        LanguageLevel languageLevel = LanguageLevel.forElement((PsiElement)pyClass);
        PyArgumentList pyArgumentList = pyClass.getSuperClassExpressionList();
        boolean bl2 = false;
        if (pyArgumentList == null) {
            pyArgumentList = pyElementGenerator.createFromText(languageLevel, PyClass.class, "class foo():pass").getSuperClassExpressionList();
            assert (pyArgumentList != null) : "expression not created";
            bl2 = true;
        }
        pyElementGenerator.createFromText(LanguageLevel.PYTHON34, PyClass.class, "class foo(object, metaclass=Foo): pass").getSuperClassExpressionList();
        if (collection != null) {
            for (String string : collection) {
                pyArgumentList.addArgument(pyElementGenerator.createParameter(string));
            }
        }
        if (collection2 != null) {
            for (Pair pair : collection2) {
                pyArgumentList.addArgument(pyElementGenerator.createKeywordArgument(languageLevel, (String)pair.first, (String)pair.second));
            }
        }
        if (bl2) {
            ASTNode aSTNode = pyClass.getNameNode();
            PsiElement psiElement = aSTNode == null ? pyClass.getFirstChild() : aSTNode.getPsi();
            pyClass.addAfter((PsiElement)pyArgumentList, psiElement);
        }
    }

    public static void optimizeImports(@NotNull PsiFile file) {
        if (file == null) {
            PyClassRefactoringUtil.a(53);
        }
        PyImportOptimizer.onlyRemoveUnused().processFile(file).run();
    }

    @Nullable
    public static PsiElement addClassAttributeIfNotExist(@NotNull PyClass aClass, @NotNull String attributeName, @NotNull String value) {
        long l2 = e ^ 0x2CC9EFABAF82L;
        if (aClass == null) {
            PyClassRefactoringUtil.a(54);
        }
        if (attributeName == null) {
            PyClassRefactoringUtil.a(55);
        }
        if (value == null) {
            PyClassRefactoringUtil.a(56);
        }
        if (aClass.findClassAttribute(attributeName, false, null) != null) {
            return null;
        }
        PyElementGenerator pyElementGenerator = PyElementGenerator.getInstance(aClass.getProject());
        String string = String.format("%s = %s", attributeName, value);
        LanguageLevel languageLevel = LanguageLevel.forElement((PsiElement)aClass);
        PyAssignmentStatement pyAssignmentStatement = pyElementGenerator.createFromText(languageLevel, PyAssignmentStatement.class, string);
        return PyUtil.addElementToStatementList(pyAssignmentStatement, aClass.getStatementList(), true);
    }

    public static boolean addMetaClassIfNotExist(@NotNull PyClass cls, @NotNull PyClass metaClass, @NotNull TypeEvalContext context) {
        String string;
        long l2 = e ^ 0x48DAE3985396L;
        if (cls == null) {
            PyClassRefactoringUtil.a(57);
        }
        if (metaClass == null) {
            PyClassRefactoringUtil.a(58);
        }
        if (context == null) {
            PyClassRefactoringUtil.a(59);
        }
        if ((string = metaClass.getName()) == null) {
            return false;
        }
        PyClassLikeType pyClassLikeType = cls.getMetaClassType(false, context);
        if (pyClassLikeType != null) {
            return false;
        }
        PyClassRefactoringUtil.insertImport((PsiElement)cls, (PsiNamedElement)metaClass);
        LanguageLevel languageLevel = LanguageLevel.forElement((PsiElement)cls);
        if (languageLevel.isPython2()) {
            PyClassRefactoringUtil.addClassAttributeIfNotExist(cls, "__metaclass__", string);
        } else {
            List<Pair<String, String>> list2 = Collections.singletonList(Pair.create((Object)"metaclass", (Object)string));
            PyClassRefactoringUtil.a(cls.getProject(), cls, null, list2);
        }
        return true;
    }

    static {
        e = com.jetbrains.python.psi.c.a(-6815301024389566018L, -5784572577555134184L, MethodHandles.lookup().lookupClass()).a(45035856328537L);
        long l2 = e ^ 0x16D9B09F3EC4L;
        a = Logger.getInstance((String)PyClassRefactoringUtil.class.getName());
        d = Key.create((String)"PyEncodedImport");
        c = Key.create((String)"PyEncodedUseFromImport");
        b = Key.create((String)"PyEncodedImportAs");
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = e ^ 0x5E2724962C25L;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 16: 
            case 17: 
            case 18: 
            case 38: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 2: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 16: 
            case 17: 
            case 18: 
            case 38: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assignmentStatements";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superClassStatement";
                break;
            }
            case 2: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 16: 
            case 17: 
            case 18: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/refactoring/classes/PyClassRefactoringUtil";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assignmentStatement";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newValue";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentValue";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dequalifyIfDeclaredInClass";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "destination";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methods";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "destStatementList";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 19: 
            case 27: 
            case 29: 
            case 31: 
            case 32: 
            case 35: 
            case 45: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElement";
                break;
            }
            case 22: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "otherMovedElements";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceNode";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetNode";
                break;
            }
            case 26: 
            case 28: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namesToSkip";
                break;
            }
            case 34: 
            case 39: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 36: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "asName";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 44: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importStatement";
                break;
            }
            case 48: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 49: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superClasses";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributeName";
                break;
            }
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cls";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "metaClass";
                break;
            }
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/refactoring/classes/PyClassRefactoringUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "copyFieldDeclarationToStatement";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getNewValueToAssign";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "copyMethods";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "addMethods";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "insertMethodInProperPlace";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolveExpression";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "copyFieldDeclarationToStatement";
                break;
            }
            case 2: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 16: 
            case 17: 
            case 18: 
            case 38: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setNewAssigneeValue";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getNewValueToAssign";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addMethods";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "insertMethodInProperPlace";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "restoreNamedReferences";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "restoreReference";
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "insertImport";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "rememberNamedReferences";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "rememberReference";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "resolveExpression";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "multiResolveExpression";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "forceAsName";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "transferEncodedImports";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "hasEncodedTarget";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "updateUnqualifiedImportOfElement";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "deleteImportStatementFromInjected";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "getOriginalName";
                break;
            }
            case 48: 
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "addSuperclasses";
                break;
            }
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "addSuperClassExpressions";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "optimizeImports";
                break;
            }
            case 54: 
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "addClassAttributeIfNotExist";
                break;
            }
            case 57: 
            case 58: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "addMetaClassIfNotExist";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 16: 
            case 17: 
            case 18: 
            case 38: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class DynamicNamedElement
    extends LightElement
    implements PsiNamedElement {
        private final PsiFile a;
        private final String b;
        private static final long c = com.jetbrains.python.psi.c.a(-917516602811152896L, -8517497386404465788L, MethodHandles.lookup().lookupClass()).a(21279774888657L);

        private DynamicNamedElement(@NotNull PsiFile file, @NotNull String name) {
            if (file == null) {
                DynamicNamedElement.a(0);
            }
            if (name == null) {
                DynamicNamedElement.a(1);
            }
            super(file.getManager(), file.getLanguage());
            this.b = name;
            this.a = file;
        }

        public String toString() {
            long l2 = c ^ 0x26F2C7F9E1A2L;
            return "DynamicNamedElement(file='" + this.getContainingFile().getName() + "', name='" + this.getName() + "')";
        }

        public PsiFile getContainingFile() {
            return this.a;
        }

        public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
            if (name == null) {
                DynamicNamedElement.a(2);
            }
            return null;
        }

        public String getName() {
            return this.b;
        }

        private static /* synthetic */ void a(int n2) {
            Object[] objectArray;
            Object[] objectArray2;
            long l2 = c ^ 0x54ECCFAD49CL;
            Object[] objectArray3 = new Object[3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/python/refactoring/classes/PyClassRefactoringUtil$DynamicNamedElement";
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setName";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

