/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.impl;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Queues;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.PsiFileFactoryImpl;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.NotNullPredicate;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.PythonFileType;
import com.jetbrains.python.PythonLanguage;
import com.jetbrains.python.psi.AccessDirection;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyArgumentList;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyBinaryExpression;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyDecoratorList;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyExpressionStatement;
import com.jetbrains.python.psi.PyFromImportStatement;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyImportElement;
import com.jetbrains.python.psi.PyImportStatement;
import com.jetbrains.python.psi.PyKeywordArgument;
import com.jetbrains.python.psi.PyListLiteralExpression;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.PyNoneLiteralExpression;
import com.jetbrains.python.psi.PyParameterList;
import com.jetbrains.python.psi.PyParenthesizedExpression;
import com.jetbrains.python.psi.PyPassStatement;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PySingleStarParameter;
import com.jetbrains.python.psi.PyStatementList;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyStringLiteralUtil;
import com.jetbrains.python.psi.StringLiteralExpression;
import com.jetbrains.python.psi.c;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.psi.impl.b;
import java.lang.invoke.MethodHandles;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Formatter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyElementGeneratorImpl
extends PyElementGenerator {
    private static final CommasOnly b;
    private final Project a;
    static final int[] FROM_ROOT;
    static int[] PATH_PARAMETER;
    private static final long c;

    public PyElementGeneratorImpl(Project project) {
        this.a = project;
    }

    @Override
    public ASTNode createNameIdentifier(String name, LanguageLevel languageLevel) {
        PsiFile psiFile = this.createDummyFile(languageLevel, name);
        PyExpressionStatement pyExpressionStatement = (PyExpressionStatement)psiFile.getFirstChild();
        PyReferenceExpression pyReferenceExpression = (PyReferenceExpression)pyExpressionStatement.getFirstChild();
        return pyReferenceExpression.getNode().getFirstChildNode();
    }

    @Override
    public PsiFile createDummyFile(LanguageLevel langLevel, String contents) {
        return this.createDummyFile(langLevel, contents, false);
    }

    public PsiFile createDummyFile(LanguageLevel langLevel, String contents, boolean physical) {
        PsiFileFactory psiFileFactory = PsiFileFactory.getInstance((Project)this.a);
        String string = PyElementGeneratorImpl.getDummyFileName();
        LightVirtualFile lightVirtualFile = new LightVirtualFile(string, (FileType)PythonFileType.INSTANCE, (CharSequence)contents);
        lightVirtualFile.putUserData(LanguageLevel.KEY, (Object)langLevel);
        PsiFile psiFile = ((PsiFileFactoryImpl)psiFileFactory).trySetupPsiForFile(lightVirtualFile, (Language)PythonLanguage.getInstance(), physical, true);
        assert (psiFile != null);
        return psiFile;
    }

    @NotNull
    public static String getDummyFileName() {
        long l2 = c ^ 0x6D10680BB2A3L;
        String string = "dummy." + PythonFileType.INSTANCE.getDefaultExtension();
        if (string == null) {
            PyElementGeneratorImpl.a(0);
        }
        return string;
    }

    @Override
    public PyStringLiteralExpression createStringLiteralAlreadyEscaped(String str) {
        long l2 = c ^ 0x304A9E424C0FL;
        PsiFile psiFile = this.createDummyFile(LanguageLevel.getDefault(), "a=(" + str + ")");
        PyAssignmentStatement pyAssignmentStatement = (PyAssignmentStatement)psiFile.getFirstChild();
        PyExpression pyExpression = pyAssignmentStatement.getAssignedValue();
        if (pyExpression != null) {
            return (PyStringLiteralExpression)((PyParenthesizedExpression)pyExpression).getContainedExpression();
        }
        return this.createStringLiteralFromString(str);
    }

    @Override
    public PyStringLiteralExpression createStringLiteralFromString(@NotNull String unescaped) {
        if (unescaped == null) {
            PyElementGeneratorImpl.a(1);
        }
        return this.createStringLiteralFromString(null, unescaped, true);
    }

    @Override
    public PyStringLiteralExpression createStringLiteral(@NotNull StringLiteralExpression oldElement, @NotNull String unescaped) {
        Pair<String, String> pair;
        if (oldElement == null) {
            PyElementGeneratorImpl.a(2);
        }
        if (unescaped == null) {
            PyElementGeneratorImpl.a(3);
        }
        if ((pair = PyStringLiteralUtil.getQuotes(oldElement.getText())) != null) {
            return this.createStringLiteralAlreadyEscaped((String)pair.first + unescaped + (String)pair.second);
        }
        return this.createStringLiteralFromString(unescaped);
    }

    @Override
    public PyStringLiteralExpression createStringLiteralFromString(@Nullable PsiFile destination, @NotNull String unescaped, boolean preferUTF8) {
        VirtualFile virtualFile;
        long l2 = c ^ 0x21F2AB27569BL;
        if (unescaped == null) {
            PyElementGeneratorImpl.a(4);
        }
        boolean bl2 = !unescaped.contains("\"");
        boolean bl3 = unescaped.matches(".*(\r|\n).*");
        String string = bl3 ? (bl2 ? "\"\"\"" : "'''") : (bl2 ? "\"" : "'");
        StringBuilder stringBuilder = new StringBuilder(unescaped.length() * 2);
        stringBuilder.append(string);
        VirtualFile virtualFile2 = virtualFile = destination == null ? null : destination.getVirtualFile();
        Charset charset = virtualFile == null ? (preferUTF8 ? StandardCharsets.UTF_8 : Charset.forName("US-ASCII")) : virtualFile.getCharset();
        CharsetEncoder charsetEncoder = charset.newEncoder();
        Formatter formatter = new Formatter(stringBuilder);
        boolean bl4 = false;
        for (int i10 = 0; i10 < unescaped.length(); ++i10) {
            int n2 = unescaped.codePointAt(i10);
            if (n2 == 34 && bl2) {
                stringBuilder.append("\\\"");
                continue;
            }
            if (n2 == 39 && !bl2) {
                stringBuilder.append("\\'");
                continue;
            }
            if (!(n2 != 13 && n2 != 10 || bl3)) {
                if (n2 == 13) {
                    stringBuilder.append("\\r");
                    continue;
                }
                if (n2 != 10) continue;
                stringBuilder.append("\\n");
                continue;
            }
            if (!charsetEncoder.canEncode(new String(Character.toChars(n2)))) {
                if (n2 <= 255) {
                    formatter.format("\\x%02x", n2);
                    continue;
                }
                if (n2 < 65535) {
                    bl4 = true;
                    formatter.format("\\u%04x", n2);
                    continue;
                }
                bl4 = true;
                formatter.format("\\U%08x", n2);
                continue;
            }
            stringBuilder.appendCodePoint(n2);
        }
        stringBuilder.append(string);
        if (bl4) {
            stringBuilder.insert(0, "u");
        }
        return this.createStringLiteralAlreadyEscaped(stringBuilder.toString());
    }

    @Override
    public PyListLiteralExpression createListLiteral() {
        long l2 = c ^ 0x72D9F78483C8L;
        PsiFile psiFile = this.createDummyFile(LanguageLevel.getDefault(), "[]");
        PyExpressionStatement pyExpressionStatement = (PyExpressionStatement)psiFile.getFirstChild();
        return (PyListLiteralExpression)pyExpressionStatement.getFirstChild();
    }

    @Override
    public ASTNode createComma() {
        long l2 = c ^ 0x531A70247571L;
        PsiFile psiFile = this.createDummyFile(LanguageLevel.getDefault(), "[0,]");
        PyExpressionStatement pyExpressionStatement = (PyExpressionStatement)psiFile.getFirstChild();
        ASTNode aSTNode = pyExpressionStatement.getFirstChild().getNode().getFirstChildNode().getTreeNext();
        return aSTNode.getTreeNext().copyElement();
    }

    @Override
    public ASTNode createDot() {
        long l2 = c ^ 0x5C736ABBBCA6L;
        PsiFile psiFile = this.createDummyFile(LanguageLevel.getDefault(), "a.b");
        PyExpressionStatement pyExpressionStatement = (PyExpressionStatement)psiFile.getFirstChild();
        ASTNode aSTNode = pyExpressionStatement.getFirstChild().getNode().getFirstChildNode().getTreeNext();
        return aSTNode.copyElement();
    }

    @Override
    @NotNull
    public PsiElement insertItemIntoListRemoveRedundantCommas(@NotNull PyElement list2, @Nullable PyExpression afterThis, @NotNull PyExpression toInsert) {
        LeafPsiElement leafPsiElement;
        ArrayDeque arrayDeque;
        if (list2 == null) {
            PyElementGeneratorImpl.a(5);
        }
        if (toInsert == null) {
            PyElementGeneratorImpl.a(6);
        }
        PsiElement psiElement = this.insertItemIntoList(list2, afterThis, toInsert);
        LeafPsiElement[] leafPsiElementArray = (LeafPsiElement[])PsiTreeUtil.getChildrenOfType((PsiElement)list2, LeafPsiElement.class);
        if (leafPsiElementArray != null && !(arrayDeque = Queues.newArrayDeque((Iterable)Collections2.filter(Arrays.asList(leafPsiElementArray), (Predicate)b))).isEmpty() && PsiTreeUtil.getNextSiblingOfType((PsiElement)(leafPsiElement = (LeafPsiElement)arrayDeque.getLast()), PyExpression.class) == null) {
            leafPsiElement.delete();
        }
        PsiElement psiElement2 = psiElement;
        if (psiElement2 == null) {
            PyElementGeneratorImpl.a(7);
        }
        return psiElement2;
    }

    @Override
    public PsiElement insertItemIntoList(PyElement list2, @Nullable PyExpression afterThis, PyExpression toInsert) throws IncorrectOperationException {
        ASTNode aSTNode = toInsert.getNode().copyElement();
        if (afterThis == null) {
            ASTNode aSTNode2 = list2.getNode();
            ASTNode[] aSTNodeArray = aSTNode2.getChildren(TokenSet.create((IElementType[])new IElementType[]{PyTokenTypes.LBRACKET, PyTokenTypes.LPAR}));
            if (aSTNodeArray.length == 0) {
                aSTNode2.addChild(aSTNode);
            } else {
                ASTNode aSTNode3 = PyPsiUtils.getNextNonWhitespaceSibling(aSTNodeArray[aSTNodeArray.length - 1]);
                if (aSTNode3 != null) {
                    ASTNode aSTNode4 = this.createComma();
                    aSTNode2.addChild(aSTNode4, aSTNode3);
                    aSTNode2.addChild(aSTNode, aSTNode4);
                } else {
                    aSTNode2.addChild(aSTNode);
                }
            }
        } else {
            ASTNode aSTNode5 = afterThis.getNode();
            ASTNode aSTNode6 = this.createComma();
            ASTNode aSTNode7 = aSTNode5.getTreeParent();
            ASTNode aSTNode8 = aSTNode5.getTreeNext();
            if (aSTNode8 == null) {
                aSTNode7.addChild(aSTNode);
            } else {
                aSTNode7.addChild(aSTNode, aSTNode8);
            }
            aSTNode7.addChild(aSTNode6, aSTNode);
        }
        return aSTNode.getPsi();
    }

    @Override
    public PyBinaryExpression createBinaryExpression(String s2, PyExpression expr, PyExpression listLiteral) {
        long l2 = c ^ 0x4807A2A049A5L;
        PsiFile psiFile = this.createDummyFile(LanguageLevel.getDefault(), "a " + s2 + " b");
        PyExpressionStatement pyExpressionStatement = (PyExpressionStatement)psiFile.getFirstChild();
        PyBinaryExpression pyBinaryExpression = (PyBinaryExpression)pyExpressionStatement.getExpression();
        ASTNode aSTNode = pyBinaryExpression.getNode();
        aSTNode.replaceChild(pyBinaryExpression.getLeftExpression().getNode(), expr.getNode().copyElement());
        aSTNode.replaceChild(pyBinaryExpression.getRightExpression().getNode(), listLiteral.getNode().copyElement());
        return pyBinaryExpression;
    }

    @Override
    public PyExpression createExpressionFromText(String text2) {
        return this.createExpressionFromText(LanguageLevel.getDefault(), text2);
    }

    @Override
    @NotNull
    public PyExpression createExpressionFromText(LanguageLevel languageLevel, String text2) {
        long l2 = c ^ 0xC3B848CF773L;
        PsiFile psiFile = this.createDummyFile(languageLevel, text2);
        PsiElement psiElement = psiFile.getFirstChild();
        if (psiElement instanceof PyExpressionStatement) {
            PyExpression pyExpression = ((PyExpressionStatement)psiElement).getExpression();
            if (pyExpression == null) {
                PyElementGeneratorImpl.a(8);
            }
            return pyExpression;
        }
        throw new IncorrectOperationException("could not parse text as expression: " + text2);
    }

    @Override
    @NotNull
    public PyCallExpression createCallExpression(LanguageLevel langLevel, String functionName) {
        PsiElement psiElement;
        long l2 = c ^ 0x56CD9F21793DL;
        PsiFile psiFile = this.createDummyFile(langLevel, functionName + "()");
        PsiElement psiElement2 = psiFile.getFirstChild();
        if (psiElement2 != null && (psiElement = psiElement2.getFirstChild()) instanceof PyCallExpression) {
            PyCallExpression pyCallExpression = (PyCallExpression)psiElement;
            if (pyCallExpression == null) {
                PyElementGeneratorImpl.a(9);
            }
            return pyCallExpression;
        }
        throw new IllegalArgumentException("Invalid call expression text " + functionName);
    }

    @Override
    public PyImportElement createImportElement(@NotNull LanguageLevel languageLevel, @NotNull String name, @Nullable String alias) {
        long l2 = c ^ 0x7FC42D5D3BA6L;
        if (languageLevel == null) {
            PyElementGeneratorImpl.a(10);
        }
        if (name == null) {
            PyElementGeneratorImpl.a(11);
        }
        String string = "from foo import " + name + (alias != null ? " as " + alias : "");
        return this.createFromText(languageLevel, PyImportElement.class, string, new int[]{0, 6});
    }

    @Override
    public PyFunction createProperty(LanguageLevel languageLevel, String propertyName, String fieldName, AccessDirection accessDirection) {
        long l2 = c ^ 0x11059573B5CBL;
        String string = accessDirection == AccessDirection.DELETE ? "@" + propertyName + ".deleter\ndef " + propertyName + "(self):\n  del self." + fieldName : (accessDirection == AccessDirection.WRITE ? "@" + propertyName + ".setter\ndef " + propertyName + "(self, value):\n  self." + fieldName + " = value" : "@property\ndef " + propertyName + "(self):\n  return self." + fieldName);
        return this.createFromText(languageLevel, PyFunction.class, string);
    }

    @Override
    @NotNull
    public <T> T createFromText(LanguageLevel langLevel, Class<T> aClass, String text2) {
        T t2 = this.createFromText(langLevel, aClass, text2, FROM_ROOT);
        if (t2 == null) {
            PyElementGeneratorImpl.a(12);
        }
        return t2;
    }

    @Override
    @NotNull
    public <T> T createPhysicalFromText(LanguageLevel langLevel, Class<T> aClass, String text2) {
        T t2 = this.createFromText(langLevel, aClass, text2, FROM_ROOT, true);
        if (t2 == null) {
            PyElementGeneratorImpl.a(13);
        }
        return t2;
    }

    @Override
    public PyNamedParameter createParameter(@NotNull String name) {
        if (name == null) {
            PyElementGeneratorImpl.a(14);
        }
        return this.createParameter(name, null, null, LanguageLevel.getDefault());
    }

    @Override
    @NotNull
    public PyParameterList createParameterList(@NotNull LanguageLevel languageLevel, @NotNull String text2) {
        long l2 = c ^ 0x35AF29CCCB65L;
        if (languageLevel == null) {
            PyElementGeneratorImpl.a(15);
        }
        if (text2 == null) {
            PyElementGeneratorImpl.a(16);
        }
        PyParameterList pyParameterList = this.createFromText(languageLevel, PyParameterList.class, "def f" + text2 + ": pass", new int[]{0, 3});
        if (pyParameterList == null) {
            PyElementGeneratorImpl.a(17);
        }
        return pyParameterList;
    }

    @Override
    @NotNull
    public PyArgumentList createArgumentList(@NotNull LanguageLevel languageLevel, @NotNull String text2) {
        if (languageLevel == null) {
            PyElementGeneratorImpl.a(18);
        }
        if (text2 == null) {
            PyElementGeneratorImpl.a(19);
        }
        PyArgumentList pyArgumentList = this.createFromText(languageLevel, PyArgumentList.class, "f" + text2, new int[]{0, 0, 1});
        if (pyArgumentList == null) {
            PyElementGeneratorImpl.a(20);
        }
        return pyArgumentList;
    }

    @Override
    public PyNamedParameter createParameter(@NotNull String name, @Nullable String defaultValue, @Nullable String annotation, @NotNull LanguageLevel languageLevel) {
        long l2 = c ^ 0x3C523A9D1883L;
        if (name == null) {
            PyElementGeneratorImpl.a(21);
        }
        if (languageLevel == null) {
            PyElementGeneratorImpl.a(22);
        }
        String string = name;
        if (annotation != null) {
            string = string + ": " + annotation;
        }
        if (defaultValue != null) {
            string = string + " = " + defaultValue;
        }
        return this.createFromText(languageLevel, PyNamedParameter.class, "def f(" + string + "): pass", PATH_PARAMETER);
    }

    @Override
    public PyKeywordArgument createKeywordArgument(LanguageLevel languageLevel, String keyword, String value) {
        long l2 = c ^ 0x3195CE9001EFL;
        PyCallExpression pyCallExpression = (PyCallExpression)this.createExpressionFromText(languageLevel, "foo(" + keyword + "=" + value + ")");
        return (PyKeywordArgument)pyCallExpression.getArguments()[0];
    }

    @Override
    @NotNull
    public <T> T createFromText(LanguageLevel langLevel, Class<T> aClass, String text2, int[] path) {
        T t2 = this.createFromText(langLevel, aClass, text2, path, false);
        if (t2 == null) {
            PyElementGeneratorImpl.a(23);
        }
        return t2;
    }

    @NotNull
    public <T> T createFromText(LanguageLevel langLevel, Class<T> aClass, String text2, int[] path, boolean physical) {
        long l2 = c ^ 0x18AFD652A48L;
        PsiFile psiFile = this.createDummyFile(langLevel, text2, physical);
        block0: for (int n2 : path) {
            if (psiFile == null) break;
            psiFile = psiFile.getFirstChild();
            for (int i10 = 0; i10 < n2; ++i10) {
                if (psiFile == null) {
                    psiFile = null;
                    continue block0;
                }
                psiFile = psiFile.getNextSibling();
            }
        }
        if (psiFile == null) {
            throw new IllegalArgumentException("Can't find element matching path " + Arrays.toString(path) + " in text '" + text2 + "'");
        }
        if (aClass.isInstance(psiFile)) {
            PsiFile psiFile2 = psiFile;
            if (psiFile2 == null) {
                PyElementGeneratorImpl.a(24);
            }
            return (T)psiFile2;
        }
        throw new IllegalArgumentException("Can't create an element of type " + aClass + " from text '" + text2 + "', got " + psiFile.getClass() + " instead");
    }

    @Override
    public PyPassStatement createPassStatement() {
        PyStatementList pyStatementList = this.a();
        return (PyPassStatement)pyStatementList.getStatements()[0];
    }

    @Override
    @NotNull
    public PyDecoratorList createDecoratorList(String ... decoratorTexts) {
        long l2 = c ^ 0x3ED800456F33L;
        if (decoratorTexts == null) {
            PyElementGeneratorImpl.a(25);
        }
        assert (decoratorTexts.length > 0);
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : decoratorTexts) {
            stringBuilder.append(string).append("\n");
        }
        stringBuilder.append("def foo():\n\tpass");
        PyFunction pyFunction = this.createFromText(LanguageLevel.getDefault(), PyFunction.class, stringBuilder.toString());
        PyDecoratorList pyDecoratorList = pyFunction.getDecoratorList();
        assert (pyDecoratorList != null);
        PyDecoratorList pyDecoratorList2 = pyDecoratorList;
        if (pyDecoratorList2 == null) {
            PyElementGeneratorImpl.a(26);
        }
        return pyDecoratorList2;
    }

    private PyStatementList a() {
        long l2 = c ^ 0x1A4DA900D866L;
        PyFunction pyFunction = this.createFromText(LanguageLevel.getDefault(), PyFunction.class, "def foo():\n\tpass");
        return pyFunction.getStatementList();
    }

    @Override
    public PyExpressionStatement createDocstring(String content2) {
        return this.createFromText(LanguageLevel.getDefault(), PyExpressionStatement.class, content2 + "\n");
    }

    @Override
    @NotNull
    public PsiElement createNewLine() {
        long l2 = c ^ 0x26ADB4AF2AA8L;
        PsiElement psiElement = (PsiElement)this.createFromText(LanguageLevel.getDefault(), PsiWhiteSpace.class, " \n\n ");
        if (psiElement == null) {
            PyElementGeneratorImpl.a(27);
        }
        return psiElement;
    }

    @Override
    @NotNull
    public PyFromImportStatement createFromImportStatement(@NotNull LanguageLevel languageLevel, @NotNull String qualifier, @NotNull String name, @Nullable String alias) {
        long l2 = c ^ 0xCDBDB80F123L;
        if (languageLevel == null) {
            PyElementGeneratorImpl.a(28);
        }
        if (qualifier == null) {
            PyElementGeneratorImpl.a(29);
        }
        if (name == null) {
            PyElementGeneratorImpl.a(30);
        }
        String string = StringUtil.isNotEmpty((String)alias) ? " as " + alias : "";
        String string2 = "from " + qualifier + " import " + name + string;
        PyFromImportStatement pyFromImportStatement = this.createFromText(languageLevel, PyFromImportStatement.class, string2);
        if (pyFromImportStatement == null) {
            PyElementGeneratorImpl.a(31);
        }
        return pyFromImportStatement;
    }

    @Override
    @NotNull
    public PyImportStatement createImportStatement(@NotNull LanguageLevel languageLevel, @NotNull String name, @Nullable String alias) {
        long l2 = c ^ 0x6F68BEE5F665L;
        if (languageLevel == null) {
            PyElementGeneratorImpl.a(32);
        }
        if (name == null) {
            PyElementGeneratorImpl.a(33);
        }
        String string = StringUtil.isNotEmpty((String)alias) ? " as " + alias : "";
        String string2 = "import " + name + string;
        PyImportStatement pyImportStatement = this.createFromText(languageLevel, PyImportStatement.class, string2);
        if (pyImportStatement == null) {
            PyElementGeneratorImpl.a(34);
        }
        return pyImportStatement;
    }

    @Override
    @NotNull
    public PyNoneLiteralExpression createEllipsis() {
        long l2 = c ^ 0xD035616E73CL;
        PyNoneLiteralExpression pyNoneLiteralExpression = this.createFromText(LanguageLevel.PYTHON30, PyNoneLiteralExpression.class, "...", new int[]{0, 0});
        if (pyNoneLiteralExpression == null) {
            PyElementGeneratorImpl.a(35);
        }
        return pyNoneLiteralExpression;
    }

    @Override
    @NotNull
    public PySingleStarParameter createSingleStarParameter() {
        long l2 = c ^ 0x50ABE1ABB591L;
        PySingleStarParameter pySingleStarParameter = this.createFromText(LanguageLevel.PYTHON30, PySingleStarParameter.class, "def foo(*): pass", new int[]{0, 3, 1});
        if (pySingleStarParameter == null) {
            PyElementGeneratorImpl.a(36);
        }
        return pySingleStarParameter;
    }

    static {
        c = com.jetbrains.python.psi.c.a(-1159166479875886171L, -1154045055854189425L, MethodHandles.lookup().lookupClass()).a(271398513555256L);
        b = new CommasOnly(null);
        FROM_ROOT = new int[]{0};
        PATH_PARAMETER = new int[]{0, 3, 1};
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = c ^ 0x30AF65014567L;
        switch (n2) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 25: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 33: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 25: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 33: {
                n3 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/psi/impl/PyElementGeneratorImpl";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unescaped";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldElement";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toInsert";
                break;
            }
            case 10: 
            case 15: 
            case 18: 
            case 22: 
            case 28: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageLevel";
                break;
            }
            case 11: 
            case 14: 
            case 21: 
            case 30: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "decoratorTexts";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifier";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDummyFileName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 25: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/psi/impl/PyElementGeneratorImpl";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "insertItemIntoListRemoveRedundantCommas";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createExpressionFromText";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createCallExpression";
                break;
            }
            case 12: 
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "createFromText";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createPhysicalFromText";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "createParameterList";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "createArgumentList";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "createDecoratorList";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "createNewLine";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "createFromImportStatement";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "createImportStatement";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "createEllipsis";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "createSingleStarParameter";
                break;
            }
        }
        switch (n2) {
            default: {
                break;
            }
            case 1: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createStringLiteralFromString";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createStringLiteral";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "insertItemIntoListRemoveRedundantCommas";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createImportElement";
                break;
            }
            case 14: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "createParameter";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "createParameterList";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "createArgumentList";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "createDecoratorList";
                break;
            }
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "createFromImportStatement";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "createImportStatement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 25: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 33: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class CommasOnly
    extends NotNullPredicate<LeafPsiElement> {
        private static final long a = com.jetbrains.python.psi.c.a(-1060384916768897295L, 2875362767476284408L, MethodHandles.lookup().lookupClass()).a(253911528200687L);

        private CommasOnly() {
        }

        @Override
        protected boolean applyNotNull(@NotNull LeafPsiElement input) {
            if (input == null) {
                CommasOnly.b(0);
            }
            return input.getNode().getElementType().equals((Object)PyTokenTypes.COMMA);
        }

        /* synthetic */ CommasOnly(b x0) {
            this();
        }

        private static /* synthetic */ void b(int n2) {
            long l2 = a ^ 0x746BAF360DADL;
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "input", "com/jetbrains/python/psi/impl/PyElementGeneratorImpl$CommasOnly", "applyNotNull"));
        }
    }
}

