/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Maps;
import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.scratch.ScratchFileService;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.lang.ASTFactory;
import com.intellij.lang.ASTNode;
import com.intellij.notebook.editor.BackedVirtualFile;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighterFactory;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.impl.FilePropertyPusher;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.util.QualifiedName;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.NotNullFunction;
import com.intellij.util.NullableFunction;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.NotNullPredicate;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.PyElementTypes;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.codeInsight.completion.OverwriteEqualsInsertHandler;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.codeInsight.dataflow.scope.ScopeUtil;
import com.jetbrains.python.formatter.PyCodeStyleSettings;
import com.jetbrains.python.magicLiteral.PyMagicLiteralTools;
import com.jetbrains.python.psi.AccessDirection;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.Property;
import com.jetbrains.python.psi.PyBinaryExpression;
import com.jetbrains.python.psi.PyBreakStatement;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyCallable;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyComprehensionElement;
import com.jetbrains.python.psi.PyContinueStatement;
import com.jetbrains.python.psi.PyCustomPackageIdentifier;
import com.jetbrains.python.psi.PyDecorator;
import com.jetbrains.python.psi.PyDecoratorList;
import com.jetbrains.python.psi.PyDictLiteralExpression;
import com.jetbrains.python.psi.PyDocStringOwner;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyExpressionStatement;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyIfStatement;
import com.jetbrains.python.psi.PyIndentUtil;
import com.jetbrains.python.psi.PyKeyValueExpression;
import com.jetbrains.python.psi.PyKeywordArgument;
import com.jetbrains.python.psi.PyKnownDecoratorProvider;
import com.jetbrains.python.psi.PyListCompExpression;
import com.jetbrains.python.psi.PyListLiteralExpression;
import com.jetbrains.python.psi.PyLoopStatement;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.PyNoneLiteralExpression;
import com.jetbrains.python.psi.PyParameter;
import com.jetbrains.python.psi.PyParenthesizedExpression;
import com.jetbrains.python.psi.PyPassStatement;
import com.jetbrains.python.psi.PyQualifiedExpression;
import com.jetbrains.python.psi.PyRaiseStatement;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyReferenceOwner;
import com.jetbrains.python.psi.PyReturnStatement;
import com.jetbrains.python.psi.PySequenceExpression;
import com.jetbrains.python.psi.PyStarExpression;
import com.jetbrains.python.psi.PyStatement;
import com.jetbrains.python.psi.PyStatementList;
import com.jetbrains.python.psi.PyStatementListContainer;
import com.jetbrains.python.psi.PyStatementWithElse;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyStringLiteralUtil;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyTupleExpression;
import com.jetbrains.python.psi.PyTypedElement;
import com.jetbrains.python.psi.StringLiteralExpression;
import com.jetbrains.python.psi.c;
import com.jetbrains.python.psi.impl.PyBuiltinCache;
import com.jetbrains.python.psi.impl.PyExpressionCodeFragmentImpl;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.psi.impl.PyTypeProvider;
import com.jetbrains.python.psi.impl.PythonLanguageLevelPusher;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.resolve.QualifiedNameFinder;
import com.jetbrains.python.psi.resolve.RatedResolveResult;
import com.jetbrains.python.psi.stubs.PySetuptoolsNamespaceIndex;
import com.jetbrains.python.psi.types.PyCallableParameter;
import com.jetbrains.python.psi.types.PyCallableType;
import com.jetbrains.python.psi.types.PyClassLikeType;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyClassTypeImpl;
import com.jetbrains.python.psi.types.PyInstantiableType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.PyUnionType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import com.jetbrains.python.refactoring.classes.PyDependenciesComparator;
import com.jetbrains.python.refactoring.classes.extractSuperclass.PyExtractSuperclassHelper;
import com.jetbrains.python.refactoring.classes.membersManager.PyMemberInfo;
import com.jetbrains.python.sdk.PythonSdkType;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import javax.swing.JFrame;
import javax.swing.JRootPane;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyUtil {
    private static final boolean a;
    private static final long b;

    private PyUtil() {
    }

    protected static List<PyExpression> unfoldParentheses(PyExpression[] targets, List<PyExpression> receiver, boolean unfoldListLiterals, boolean unfoldStarExpressions) {
        for (PyExpression pyExpression : targets) {
            PyExpression pyExpression2;
            if (pyExpression instanceof PyParenthesizedExpression) {
                pyExpression2 = (PyParenthesizedExpression)pyExpression;
                PyUtil.unfoldParentheses(new PyExpression[]{pyExpression2.getContainedExpression()}, receiver, unfoldListLiterals, unfoldStarExpressions);
                continue;
            }
            if (pyExpression instanceof PyTupleExpression) {
                pyExpression2 = (PyTupleExpression)pyExpression;
                PyUtil.unfoldParentheses(pyExpression2.getElements(), receiver, unfoldListLiterals, unfoldStarExpressions);
                continue;
            }
            if (pyExpression instanceof PyListLiteralExpression && unfoldListLiterals) {
                pyExpression2 = (PyListLiteralExpression)pyExpression;
                PyUtil.unfoldParentheses(pyExpression2.getElements(), receiver, true, unfoldStarExpressions);
                continue;
            }
            if (pyExpression instanceof PyStarExpression && unfoldStarExpressions) {
                PyUtil.unfoldParentheses(new PyExpression[]{((PyStarExpression)pyExpression).getExpression()}, receiver, unfoldListLiterals, true);
                continue;
            }
            if (pyExpression == null) continue;
            receiver.add(pyExpression);
        }
        return receiver;
    }

    @NotNull
    public static List<PyExpression> flattenedParensAndTuples(PyExpression ... targets) {
        List<PyExpression> list2 = PyUtil.unfoldParentheses(targets, new ArrayList<PyExpression>(targets.length), false, false);
        if (list2 == null) {
            PyUtil.a(0);
        }
        return list2;
    }

    @NotNull
    public static List<PyExpression> flattenedParensAndLists(PyExpression ... targets) {
        List<PyExpression> list2 = PyUtil.unfoldParentheses(targets, new ArrayList<PyExpression>(targets.length), true, true);
        if (list2 == null) {
            PyUtil.a(1);
        }
        return list2;
    }

    @NotNull
    public static List<PyExpression> flattenedParensAndStars(PyExpression ... targets) {
        List<PyExpression> list2 = PyUtil.unfoldParentheses(targets, new ArrayList<PyExpression>(targets.length), false, true);
        if (list2 == null) {
            PyUtil.a(2);
        }
        return list2;
    }

    @NotNull
    @NonNls
    public static String getReadableRepr(PsiElement elt, boolean cutAtEOL) {
        long l2 = b ^ 0x5BA0449ADD28L;
        if (elt == null) {
            if ("null!" == null) {
                PyUtil.a(3);
            }
            return "null!";
        }
        ASTNode aSTNode = elt.getNode();
        if (aSTNode == null) {
            if ("null" == null) {
                PyUtil.a(4);
            }
            return "null";
        }
        String string = aSTNode.getText();
        int n2 = cutAtEOL ? string.indexOf(10) : -1;
        if (n2 < 0) {
            n2 = string.length();
        }
        String string2 = string.substring(0, Math.min(n2, string.length()));
        if (string2 == null) {
            PyUtil.a(5);
        }
        return string2;
    }

    @Nullable
    public static PyClass getContainingClassOrSelf(PsiElement element) {
        PsiElement psiElement;
        for (psiElement = element; psiElement != null && !(psiElement instanceof PyClass); psiElement = psiElement.getParent()) {
        }
        return (PyClass)psiElement;
    }

    @Nullable
    public static PyFile getContainingPyFile(PyElement element) {
        PsiFile psiFile = element.getContainingFile();
        return psiFile instanceof PyFile ? (PyFile)psiFile : null;
    }

    public static void showBalloon(Project project, String message, MessageType messageType) {
        JFrame jFrame = WindowManager.getInstance().getFrame(project.isDefault() ? null : project);
        if (jFrame == null) {
            return;
        }
        JRootPane jRootPane = jFrame.getRootPane();
        if (jRootPane == null) {
            return;
        }
        Rectangle rectangle = jRootPane.getVisibleRect();
        Point point = new Point(rectangle.x + rectangle.width - 10, rectangle.y + 10);
        RelativePoint relativePoint = new RelativePoint((Component)jRootPane, point);
        JBPopupFactory.getInstance().createHtmlTextBalloonBuilder(message, messageType.getDefaultIcon(), messageType.getPopupBackground(), null).setShowCallout(false).setCloseButtonEnabled(true).createBalloon().show(relativePoint, Balloon.Position.atLeft);
    }

    @NonNls
    public static String nvl(Object s2) {
        long l2 = b ^ 0x4659C8754B2CL;
        if (s2 != null) {
            return "'" + s2.toString() + "'";
        }
        return "null";
    }

    public static void addListNode(PsiElement parent, PsiElement newItem, ASTNode beforeThis, boolean isFirst, boolean isLast, boolean addWhitespace) {
        if (!FileModificationService.getInstance().preparePsiElementForWrite(parent)) {
            return;
        }
        ASTNode aSTNode = parent.getNode();
        assert (aSTNode != null);
        ASTNode aSTNode2 = newItem.getNode();
        assert (aSTNode2 != null);
        Project project = parent.getProject();
        PyElementGenerator pyElementGenerator = PyElementGenerator.getInstance(project);
        if (!isFirst) {
            aSTNode.addChild(pyElementGenerator.createComma(), beforeThis);
        }
        aSTNode.addChild(aSTNode2, beforeThis);
        if (!isLast) {
            aSTNode.addChild(pyElementGenerator.createComma(), beforeThis);
        }
        if (addWhitespace) {
            aSTNode.addChild((ASTNode)ASTFactory.whitespace((CharSequence)" "), beforeThis);
        }
    }

    @Nullable
    public static PyType getSpecialAttributeType(@Nullable PyReferenceExpression ref, TypeEvalContext context) {
        PyExpression pyExpression;
        long l2 = b ^ 0xEA3C5AF5FE8L;
        if (ref != null && (pyExpression = ref.getQualifier()) != null) {
            PyType pyType;
            String string = ref.getReferencedName();
            if ("__class__".equals(string)) {
                PyType pyType2 = context.getType(pyExpression);
                if (pyType2 instanceof PyClassType) {
                    return new PyClassTypeImpl(((PyClassType)pyType2).getPyClass(), true);
                }
            } else if ("__dict__".equals(string) && (pyType = context.getType(pyExpression)) instanceof PyClassType && ((PyClassType)pyType).isDefinition()) {
                return PyBuiltinCache.getInstance((PsiElement)ref).getDictType();
            }
        }
        return null;
    }

    @NotNull
    public static <T> T sure(T thing) {
        if (thing == null) {
            throw new IncorrectOperationException();
        }
        T t2 = thing;
        if (t2 == null) {
            PyUtil.a(6);
        }
        return t2;
    }

    public static void sure(boolean thing) {
        if (!thing) {
            throw new IncorrectOperationException();
        }
    }

    public static boolean isAttribute(PyTargetExpression ex2) {
        return PyUtil.isInstanceAttribute(ex2) || PyUtil.isClassAttribute(ex2);
    }

    public static boolean isInstanceAttribute(PyExpression target) {
        PyFunction pyFunction;
        if (!(target instanceof PyTargetExpression)) {
            return false;
        }
        ScopeOwner scopeOwner = ScopeUtil.getScopeOwner((PsiElement)target);
        if (scopeOwner instanceof PyFunction && (pyFunction = (PyFunction)scopeOwner).getContainingClass() != null) {
            if (pyFunction.getStub() != null) {
                return true;
            }
            PyParameter[] pyParameterArray = pyFunction.getParameterList().getParameters();
            if (pyParameterArray.length > 0) {
                PyTargetExpression pyTargetExpression = (PyTargetExpression)target;
                PyExpression pyExpression = pyTargetExpression.getQualifier();
                return pyExpression != null && pyExpression.getText().equals(pyParameterArray[0].getName());
            }
        }
        return false;
    }

    public static boolean isClassAttribute(PsiElement element) {
        return element instanceof PyTargetExpression && ScopeUtil.getScopeOwner(element) instanceof PyClass;
    }

    public static boolean isIfNameEqualsMain(PyIfStatement ifStatement) {
        PyExpression pyExpression = ifStatement.getIfPart().getCondition();
        return PyUtil.a(pyExpression);
    }

    private static boolean a(PyExpression pyExpression) {
        long l2 = b ^ 0x7DD9C0A14661L;
        if (pyExpression instanceof PyParenthesizedExpression) {
            return PyUtil.a(((PyParenthesizedExpression)pyExpression).getContainedExpression());
        }
        if (pyExpression instanceof PyBinaryExpression) {
            PyBinaryExpression pyBinaryExpression = (PyBinaryExpression)pyExpression;
            if (pyBinaryExpression.getOperator() == PyTokenTypes.OR_KEYWORD) {
                return PyUtil.a(pyBinaryExpression.getLeftExpression()) || PyUtil.a(pyBinaryExpression.getRightExpression());
            }
            if (pyBinaryExpression.getRightExpression() instanceof PyStringLiteralExpression) {
                PyStringLiteralExpression pyStringLiteralExpression = (PyStringLiteralExpression)pyBinaryExpression.getRightExpression();
                return pyBinaryExpression.getOperator() == PyTokenTypes.EQEQ && pyBinaryExpression.getLeftExpression().getText().equals("__name__") && pyStringLiteralExpression.getStringValue().equals("__main__");
            }
        }
        return false;
    }

    @Nullable
    public static List<PsiElement> searchForWrappingMethod(PsiElement start2, boolean deep) {
        PsiElement psiElement = start2;
        ArrayList<PsiElement> arrayList = new ArrayList<PsiElement>(2);
        while (psiElement != null) {
            PyFunction pyFunction = (PyFunction)PsiTreeUtil.getParentOfType((PsiElement)psiElement, PyFunction.class, (boolean)true, (Class[])new Class[]{PyClass.class});
            if (pyFunction != null) {
                PyClass pyClass = pyFunction.getContainingClass();
                if (pyClass != null) {
                    arrayList.add(pyFunction);
                    arrayList.add((PsiElement)pyClass);
                    return arrayList;
                }
                if (deep) {
                    arrayList.add(pyFunction);
                    psiElement = pyFunction;
                    continue;
                }
                return null;
            }
            return null;
        }
        return null;
    }

    public static boolean inSameFile(@NotNull PsiElement e12, @NotNull PsiElement e22) {
        if (e12 == null) {
            PyUtil.a(7);
        }
        if (e22 == null) {
            PyUtil.a(8);
        }
        PsiFile psiFile = e12.getContainingFile();
        PsiFile psiFile2 = e22.getContainingFile();
        if (psiFile == null || psiFile2 == null) {
            return false;
        }
        return psiFile == psiFile2;
    }

    public static boolean onSameLine(@NotNull PsiElement e12, @NotNull PsiElement e22) {
        PsiDocumentManager psiDocumentManager;
        Document document;
        if (e12 == null) {
            PyUtil.a(9);
        }
        if (e22 == null) {
            PyUtil.a(10);
        }
        if ((document = (psiDocumentManager = PsiDocumentManager.getInstance((Project)e12.getProject())).getDocument(e12.getContainingFile())) == null || document != psiDocumentManager.getDocument(e22.getContainingFile())) {
            return false;
        }
        return document.getLineNumber(e12.getTextOffset()) == document.getLineNumber(e22.getTextOffset());
    }

    public static boolean isTopLevel(@NotNull PsiElement element) {
        StubElement stubElement;
        StubElement stubElement2;
        if (element == null) {
            PyUtil.a(11);
        }
        if (element instanceof StubBasedPsiElement && (stubElement2 = ((StubBasedPsiElement)element).getStub()) != null && (stubElement = stubElement2.getParentStub()) != null) {
            return stubElement.getPsi() instanceof PsiFile;
        }
        return ScopeUtil.getScopeOwner(element) instanceof PsiFile;
    }

    public static void deletePycFiles(String pyFilePath) {
        long l2 = b ^ 0x604B0EB08E8CL;
        if (pyFilePath.endsWith(".py")) {
            File file2;
            File file3;
            File file4;
            ArrayList<File> arrayList = new ArrayList<File>();
            File file5 = new File(pyFilePath + "c");
            if (file5.exists()) {
                arrayList.add(file5);
            }
            if ((file4 = new File(pyFilePath + "o")).exists()) {
                arrayList.add(file4);
            }
            if ((file3 = new File((file2 = new File(pyFilePath)).getParentFile(), "__pycache__")).isDirectory()) {
                String string = FileUtilRt.getNameWithoutExtension((String)file2.getName());
                Collections.addAll(arrayList, file3.listFiles(file -> {
                    long l2 = b ^ 0x5E4C1326DD97L;
                    if (!FileUtilRt.extensionEquals((String)file.getName(), (String)"pyc")) {
                        return false;
                    }
                    String string2 = FileUtilRt.getNameWithoutExtension((String)file.getName());
                    return FileUtilRt.getNameWithoutExtension((String)string2).equals(string);
                }));
            }
            FileUtil.asyncDelete(arrayList);
        }
    }

    public static String getElementNameWithoutExtension(PsiNamedElement psiNamedElement) {
        return psiNamedElement instanceof PyFile ? FileUtilRt.getNameWithoutExtension((String)((PyFile)psiNamedElement).getName()) : psiNamedElement.getName();
    }

    public static boolean hasUnresolvedAncestors(@NotNull PyClass cls, @NotNull TypeEvalContext context) {
        if (cls == null) {
            PyUtil.a(12);
        }
        if (context == null) {
            PyUtil.a(13);
        }
        for (PyClassLikeType pyClassLikeType : cls.getAncestorTypes(context)) {
            if (pyClassLikeType != null) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static AccessDirection getPropertyAccessDirection(@NotNull PyFunction function) {
        Property property;
        if (function == null) {
            PyUtil.a(14);
        }
        if ((property = function.getProperty()) != null) {
            if (property.getGetter().valueOrNull() == function) {
                AccessDirection accessDirection = AccessDirection.READ;
                if (accessDirection == null) {
                    PyUtil.a(15);
                }
                return accessDirection;
            }
            if (property.getSetter().valueOrNull() == function) {
                AccessDirection accessDirection = AccessDirection.WRITE;
                if (accessDirection == null) {
                    PyUtil.a(16);
                }
                return accessDirection;
            }
            if (property.getDeleter().valueOrNull() == function) {
                AccessDirection accessDirection = AccessDirection.DELETE;
                if (accessDirection == null) {
                    PyUtil.a(17);
                }
                return accessDirection;
            }
        }
        AccessDirection accessDirection = AccessDirection.READ;
        if (accessDirection == null) {
            PyUtil.a(18);
        }
        return accessDirection;
    }

    public static void removeQualifier(@NotNull PyReferenceExpression element) {
        PyExpression pyExpression;
        Object object;
        PyExpression pyExpression2;
        if (element == null) {
            PyUtil.a(19);
        }
        if ((pyExpression2 = element.getQualifier()) == null) {
            return;
        }
        if (pyExpression2 instanceof PyCallExpression && (object = ((PyCallExpression)pyExpression2).getCallee()) instanceof PyReferenceExpression && (pyExpression = ((PyReferenceExpression)object).getQualifier()) != null) {
            pyExpression2.replace((PsiElement)pyExpression);
            return;
        }
        object = PyPsiUtils.getNextNonWhitespaceSibling((PsiElement)pyExpression2);
        if (object != null) {
            object.delete();
        }
        pyExpression2.delete();
    }

    @NotNull
    public static String computeElementNameForStringSearch(@NotNull PsiElement element) {
        String string;
        if (element == null) {
            PyUtil.a(20);
        }
        if (element instanceof PyFile) {
            String string2 = FileUtilRt.getNameWithoutExtension((String)((PyFile)element).getName());
            if (string2 == null) {
                PyUtil.a(21);
            }
            return string2;
        }
        if (element instanceof PsiDirectory) {
            String string3 = ((PsiDirectory)element).getName();
            if (string3 == null) {
                PyUtil.a(22);
            }
            return string3;
        }
        if (element instanceof PyStringLiteralExpression && PyMagicLiteralTools.couldBeMagicLiteral(element)) {
            String string4 = ((StringLiteralExpression)element).getStringValue();
            if (string4 == null) {
                PyUtil.a(23);
            }
            return string4;
        }
        if (element instanceof PyElement && (string = ((PyElement)element).getName()) != null) {
            String string5 = string;
            if (string5 == null) {
                PyUtil.a(24);
            }
            return string5;
        }
        String string6 = element.getNode() != null ? element.getNode().getText() : element.getText();
        if (string6 == null) {
            PyUtil.a(25);
        }
        return string6;
    }

    public static boolean isOwnScopeComprehension(@NotNull PyComprehensionElement comprehension) {
        if (comprehension == null) {
            PyUtil.a(26);
        }
        boolean bl2 = !LanguageLevel.forElement(comprehension).isPython2();
        boolean bl3 = comprehension instanceof PyListCompExpression;
        return !bl3 || bl2;
    }

    public static ASTNode createNewName(PyElement element, String name) {
        return PyElementGenerator.getInstance(element.getProject()).createNameIdentifier(name, LanguageLevel.forElement((PsiElement)element));
    }

    @NotNull
    public static PsiElement resolveToTheTop(@NotNull PsiElement elementToResolve) {
        PsiElement psiElement;
        PsiReference psiReference;
        if (elementToResolve == null) {
            PyUtil.a(27);
        }
        PsiElement psiElement2 = elementToResolve;
        HashSet<PsiElement> hashSet = new HashSet<PsiElement>();
        while ((psiReference = psiElement2.getReference()) != null && (psiElement = psiReference.resolve()) != null && !hashSet.contains(psiElement) && !psiElement.equals(psiElement2) && PyUtil.inSameFile(psiElement, psiElement2)) {
            psiElement2 = psiElement;
            hashSet.add(psiElement);
        }
        PsiElement psiElement3 = psiElement2;
        if (psiElement3 == null) {
            PyUtil.a(28);
        }
        return psiElement3;
    }

    @NotNull
    public static List<PsiElement> multiResolveTopPriority(@NotNull PsiElement element, @NotNull PyResolveContext resolveContext) {
        if (element == null) {
            PyUtil.a(29);
        }
        if (resolveContext == null) {
            PyUtil.a(30);
        }
        if (element instanceof PyReferenceOwner) {
            PsiPolyVariantReference psiPolyVariantReference = ((PyReferenceOwner)element).getReference(resolveContext);
            List<PsiElement> list2 = PyUtil.filterTopPriorityResults(psiPolyVariantReference.multiResolve(false));
            if (list2 == null) {
                PyUtil.a(31);
            }
            return list2;
        }
        PsiReference psiReference = element.getReference();
        List<PsiElement> list3 = psiReference != null ? Collections.singletonList(psiReference.resolve()) : Collections.emptyList();
        if (list3 == null) {
            PyUtil.a(32);
        }
        return list3;
    }

    @NotNull
    public static List<PsiElement> multiResolveTopPriority(@NotNull PsiPolyVariantReference reference) {
        if (reference == null) {
            PyUtil.a(33);
        }
        List<PsiElement> list2 = PyUtil.filterTopPriorityResults(reference.multiResolve(false));
        if (list2 == null) {
            PyUtil.a(34);
        }
        return list2;
    }

    @NotNull
    public static List<PsiElement> filterTopPriorityResults(@NotNull ResolveResult[] resolveResults) {
        if (resolveResults == null) {
            PyUtil.a(35);
        }
        if (resolveResults.length == 0) {
            List<PsiElement> list2 = Collections.emptyList();
            if (list2 == null) {
                PyUtil.a(36);
            }
            return list2;
        }
        int n2 = PyUtil.c(Arrays.asList(resolveResults));
        List list3 = ((StreamEx)StreamEx.of((Object[])resolveResults).filter(resolveResult -> PyUtil.a(resolveResult) >= n2)).map(ResolveResult::getElement).nonNull().toList();
        if (list3 == null) {
            PyUtil.a(37);
        }
        return list3;
    }

    @NotNull
    public static <E extends ResolveResult> List<E> filterTopPriorityResults(@NotNull List<? extends E> resolveResults) {
        if (resolveResults == null) {
            PyUtil.a(38);
        }
        if (resolveResults.isEmpty()) {
            List list2 = Collections.emptyList();
            if (list2 == null) {
                PyUtil.a(39);
            }
            return list2;
        }
        int n2 = PyUtil.c(resolveResults);
        List list3 = ContainerUtil.filter(resolveResults, resolveResult -> PyUtil.a(resolveResult) >= n2);
        if (list3 == null) {
            PyUtil.a(40);
        }
        return list3;
    }

    private static int c(@NotNull List<? extends ResolveResult> list2) {
        if (list2 == null) {
            PyUtil.a(41);
        }
        return list2.stream().mapToInt(PyUtil::a).max().orElse(Integer.MIN_VALUE);
    }

    private static int a(@NotNull ResolveResult resolveResult) {
        if (resolveResult == null) {
            PyUtil.a(42);
        }
        return resolveResult instanceof RatedResolveResult ? ((RatedResolveResult)resolveResult).getRate() : 0;
    }

    @Nullable
    public static PyFunction getInitMethod(@NotNull PyClass pyClass) {
        long l2 = b ^ 0x2F9DF00A870BL;
        if (pyClass == null) {
            PyUtil.a(43);
        }
        return pyClass.findMethodByName("__init__", false, null);
    }

    @NotNull
    public static LanguageLevel getLanguageLevelForVirtualFile(@NotNull Project project, @NotNull VirtualFile virtualFile) {
        VirtualFile virtualFile2;
        if (project == null) {
            PyUtil.a(44);
        }
        if (virtualFile == null) {
            PyUtil.a(45);
        }
        if (virtualFile instanceof VirtualFileWindow) {
            virtualFile = ((VirtualFileWindow)virtualFile).getDelegate();
        }
        if ((virtualFile2 = (virtualFile = BackedVirtualFile.getOriginFileIfBacked((VirtualFile)virtualFile)).getParent()) != null) {
            LanguageLevel languageLevel = (LanguageLevel)((Object)virtualFile2.getUserData(LanguageLevel.KEY));
            if (languageLevel != null) {
                LanguageLevel languageLevel2 = languageLevel;
                if (languageLevel2 == null) {
                    PyUtil.a(46);
                }
                return languageLevel2;
            }
            LanguageLevel languageLevel3 = PythonLanguageLevelPusher.getFileLanguageLevel(project, virtualFile);
            if (languageLevel3 != null) {
                LanguageLevel languageLevel4 = languageLevel3;
                if (languageLevel4 == null) {
                    PyUtil.a(47);
                }
                return languageLevel4;
            }
        } else {
            LanguageLevel languageLevel;
            LanguageLevel languageLevel5 = (LanguageLevel)((Object)virtualFile.getUserData(LanguageLevel.KEY));
            if (languageLevel5 != null) {
                LanguageLevel languageLevel6 = languageLevel5;
                if (languageLevel6 == null) {
                    PyUtil.a(48);
                }
                return languageLevel6;
            }
            if (ApplicationManager.getApplication().isUnitTestMode() && (languageLevel = LanguageLevel.FORCE_LANGUAGE_LEVEL) != null) {
                LanguageLevel languageLevel7 = languageLevel;
                if (languageLevel7 == null) {
                    PyUtil.a(49);
                }
                return languageLevel7;
            }
        }
        LanguageLevel languageLevel = PyUtil.guessLanguageLevelWithCaching(project);
        if (languageLevel == null) {
            PyUtil.a(50);
        }
        return languageLevel;
    }

    @NotNull
    public static LanguageLevel getLanguageLevelForModule(@NotNull Module module2) {
        if (module2 == null) {
            PyUtil.a(51);
        }
        LanguageLevel languageLevel = ((PythonLanguageLevelPusher)FilePropertyPusher.EP_NAME.findExtensionOrFail(PythonLanguageLevelPusher.class)).getImmediateValue(module2);
        if (languageLevel == null) {
            PyUtil.a(52);
        }
        return languageLevel;
    }

    public static void invalidateLanguageLevelCache(@NotNull Project project) {
        if (project == null) {
            PyUtil.a(53);
        }
        project.putUserData(PythonLanguageLevelPusher.PYTHON_LANGUAGE_LEVEL, null);
    }

    @NotNull
    public static LanguageLevel guessLanguageLevelWithCaching(@NotNull Project project) {
        LanguageLevel languageLevel;
        if (project == null) {
            PyUtil.a(54);
        }
        if ((languageLevel = (LanguageLevel)((Object)project.getUserData(PythonLanguageLevelPusher.PYTHON_LANGUAGE_LEVEL))) == null) {
            languageLevel = PyUtil.guessLanguageLevel(project);
            project.putUserData(PythonLanguageLevelPusher.PYTHON_LANGUAGE_LEVEL, (Object)languageLevel);
        }
        LanguageLevel languageLevel2 = languageLevel;
        if (languageLevel2 == null) {
            PyUtil.a(55);
        }
        return languageLevel2;
    }

    @NotNull
    public static LanguageLevel guessLanguageLevel(@NotNull Project project) {
        ModuleManager moduleManager;
        if (project == null) {
            PyUtil.a(56);
        }
        if ((moduleManager = ModuleManager.getInstance((Project)project)) != null) {
            LanguageLevel languageLevel = null;
            for (Module module2 : moduleManager.getModules()) {
                Sdk sdk = PythonSdkType.findPythonSdk(module2);
                if (sdk == null) continue;
                LanguageLevel languageLevel2 = PythonSdkType.getLanguageLevelForSdk(sdk);
                if (languageLevel != null && !languageLevel.isOlderThan(languageLevel2)) continue;
                languageLevel = languageLevel2;
            }
            if (languageLevel != null) {
                LanguageLevel languageLevel3 = languageLevel;
                if (languageLevel3 == null) {
                    PyUtil.a(57);
                }
                return languageLevel3;
            }
        }
        LanguageLevel languageLevel = LanguageLevel.getDefault();
        if (languageLevel == null) {
            PyUtil.a(58);
        }
        return languageLevel;
    }

    @Nullable
    public static <T> T as(@Nullable Object expression, @NotNull Class<T> clazz) {
        if (clazz == null) {
            PyUtil.a(59);
        }
        return (T)ObjectUtils.tryCast((Object)expression, clazz);
    }

    @Nullable
    public static <T extends PsiElement> T findReference(@NotNull PsiElement element, @NotNull Class<T> expectedClass) {
        if (element == null) {
            PyUtil.a(60);
        }
        if (expectedClass == null) {
            PyUtil.a(61);
        }
        for (PsiReference psiReference : element.getReferences()) {
            PsiElement psiElement = (PsiElement)PyUtil.as(psiReference.resolve(), expectedClass);
            if (psiElement == null) continue;
            return (T)psiElement;
        }
        return null;
    }

    @NotNull
    public static <T> List<T> asList(@Nullable Collection<?> expression, @NotNull Class<? extends T> elementClass) {
        if (elementClass == null) {
            PyUtil.a(62);
        }
        if (expression == null || expression.isEmpty()) {
            List list2 = Collections.emptyList();
            if (list2 == null) {
                PyUtil.a(63);
            }
            return list2;
        }
        ArrayList<T> arrayList = new ArrayList<T>();
        for (Object obj : expression) {
            T t2 = PyUtil.as(obj, elementClass);
            if (t2 == null) continue;
            arrayList.add(t2);
        }
        ArrayList<T> arrayList2 = arrayList;
        if (arrayList2 == null) {
            PyUtil.a(64);
        }
        return arrayList2;
    }

    public static void rehighlightOpenEditors(@NotNull Project project) {
        if (project == null) {
            PyUtil.a(65);
        }
        ApplicationManager.getApplication().runWriteAction(() -> {
            for (Editor editor2 : EditorFactory.getInstance().getAllEditors()) {
                VirtualFile virtualFile;
                if (!(editor2 instanceof EditorEx) || editor2.getProject() != project || (virtualFile = ((EditorEx)editor2).getVirtualFile()) == null) continue;
                EditorHighlighter editorHighlighter = EditorHighlighterFactory.getInstance().createEditorHighlighter(project, virtualFile);
                ((EditorEx)editor2).setHighlighter(editorHighlighter);
            }
        });
    }

    @NotNull
    public static <T, P> T getParameterizedCachedValue(@NotNull PsiElement element, @Nullable P param, @NotNull NotNullFunction<P, T> f10) {
        if (element == null) {
            PyUtil.a(66);
        }
        if (f10 == null) {
            PyUtil.a(67);
        }
        T t2 = PyUtil.getNullableParameterizedCachedValue(element, param, f10);
        assert (t2 != null);
        T t3 = t2;
        if (t3 == null) {
            PyUtil.a(68);
        }
        return t3;
    }

    @Nullable
    public static <T, P> T getNullableParameterizedCachedValue(@NotNull PsiElement element, @Nullable P param, @NotNull NullableFunction<P, T> f10) {
        Optional<P> optional;
        CachedValuesManager cachedValuesManager;
        Map map2;
        Optional<Object> optional2;
        if (element == null) {
            PyUtil.a(69);
        }
        if (f10 == null) {
            PyUtil.a(70);
        }
        if ((optional2 = (Optional<Object>)(map2 = (Map)CachedValuesManager.getCachedValue((PsiElement)element, (Key)(cachedValuesManager = CachedValuesManager.getManager((Project)element.getProject())).getKeyForClass(f10.getClass()), () -> CachedValueProvider.Result.create((Object)Maps.newConcurrentMap(), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}))).get(optional = Optional.ofNullable(param))) == null) {
            optional2 = Optional.ofNullable(f10.fun(param));
            map2.put(optional, optional2);
        }
        return optional2.orElse(null);
    }

    public static void runWithProgress(@Nullable Project project, @Nls(capitalization=Nls.Capitalization.Title) @NotNull String title, boolean modal, boolean canBeCancelled, final @NotNull Consumer<? super ProgressIndicator> function) {
        if (title == null) {
            PyUtil.a(71);
        }
        if (function == null) {
            PyUtil.a(72);
        }
        if (modal) {
            ProgressManager.getInstance().run((Task)new Task.Modal(project, title, canBeCancelled){
                private static final long a = c.a(-8472912060772182671L, -2523025176794504853L, MethodHandles.lookup().lookupClass()).a(198792459277651L);

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        1.a(0);
                    }
                    function.consume((Object)indicator);
                }

                private static /* synthetic */ void a(int n2) {
                    long l2 = a ^ 0x7A54472D02A1L;
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/jetbrains/python/psi/PyUtil$1", "run"));
                }
            });
        } else {
            ProgressManager.getInstance().run((Task)new Task.Backgroundable(project, title, canBeCancelled){
                private static final long a = c.a(7804211212183236134L, -1349341315094227968L, MethodHandles.lookup().lookupClass()).a(206742424259562L);

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        2.a(0);
                    }
                    function.consume((Object)indicator);
                }

                private static /* synthetic */ void a(int n2) {
                    long l2 = a ^ 0x1120EFFF6D75L;
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/jetbrains/python/psi/PyUtil$2", "run"));
                }
            });
        }
    }

    public static void verboseOnly(@NotNull Runnable runnable) {
        if (runnable == null) {
            PyUtil.a(73);
        }
        if (a) {
            runnable.run();
        }
    }

    @Nullable
    public static PsiComment getCommentOnHeaderLine(@NotNull PyStatementListContainer container) {
        if (container == null) {
            PyUtil.a(74);
        }
        return PyUtil.as(PyUtil.getHeaderEndAnchor(container), PsiComment.class);
    }

    @NotNull
    public static PsiElement getHeaderEndAnchor(@NotNull PyStatementListContainer container) {
        if (container == null) {
            PyUtil.a(75);
        }
        PyStatementList pyStatementList = container.getStatementList();
        PsiElement psiElement = (PsiElement)ObjectUtils.notNull((Object)PyPsiUtils.getPrevNonWhitespaceSibling((PsiElement)pyStatementList));
        if (psiElement == null) {
            PyUtil.a(76);
        }
        return psiElement;
    }

    public static boolean isPy2ReservedWord(@NotNull PyReferenceExpression node) {
        String string;
        long l2 = b ^ 0xA6CDC48A3DL;
        if (node == null) {
            PyUtil.a(77);
        }
        return LanguageLevel.forElement((PsiElement)node).isPython2() && !node.isQualified() && ("None".equals(string = node.getName()) || "False".equals(string) || "True".equals(string));
    }

    public static void updateDocumentUnblockedAndCommitted(@NotNull PsiElement anchor, @NotNull Consumer<? super Document> consumer) {
        if (anchor == null) {
            PyUtil.a(78);
        }
        if (consumer == null) {
            PyUtil.a(79);
        }
        PyUtil.updateDocumentUnblockedAndCommitted(anchor, document -> {
            consumer.consume(document);
            return null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static <T> T updateDocumentUnblockedAndCommitted(@NotNull PsiElement anchor, @NotNull Function<? super Document, ? extends T> func) {
        PsiDocumentManager psiDocumentManager;
        Document document;
        if (anchor == null) {
            PyUtil.a(80);
        }
        if (func == null) {
            PyUtil.a(81);
        }
        if ((document = (psiDocumentManager = PsiDocumentManager.getInstance((Project)anchor.getProject())).getDocument(anchor.getContainingFile())) != null) {
            psiDocumentManager.doPostponedOperationsAndUnblockDocument(document);
            try {
                Object object = func.fun((Object)document);
                return (T)object;
            }
            finally {
                psiDocumentManager.commitDocument(document);
            }
        }
        return null;
    }

    @Nullable
    public static PyType getReturnTypeToAnalyzeAsCallType(@NotNull PyFunction function, @NotNull TypeEvalContext context) {
        PyClass pyClass;
        if (function == null) {
            PyUtil.a(82);
        }
        if (context == null) {
            PyUtil.a(83);
        }
        if (PyUtil.isInit(function) && (pyClass = function.getContainingClass()) != null) {
            for (PyTypeProvider pyTypeProvider : PyTypeProvider.EP_NAME.getExtensionList()) {
                PyType pyType = pyTypeProvider.getGenericType(pyClass, context);
                if (pyType == null) continue;
                return pyType;
            }
            PyInstantiableType pyInstantiableType = PyUtil.as(context.getType(pyClass), PyInstantiableType.class);
            if (pyInstantiableType != null) {
                return pyInstantiableType.toInstance();
            }
        }
        return context.getReturnType(function);
    }

    @Nullable
    public static PyExpression createExpressionFromFragment(@NotNull String expressionText, @NotNull PsiElement context) {
        long l2 = b ^ 0x3F5B73AC383FL;
        if (expressionText == null) {
            PyUtil.a(84);
        }
        if (context == null) {
            PyUtil.a(85);
        }
        PyExpressionCodeFragmentImpl pyExpressionCodeFragmentImpl = new PyExpressionCodeFragmentImpl(context.getProject(), "dummy.py", expressionText, false);
        pyExpressionCodeFragmentImpl.setContext(context);
        PyExpressionStatement pyExpressionStatement = PyUtil.as(pyExpressionCodeFragmentImpl.getFirstChild(), PyExpressionStatement.class);
        return pyExpressionStatement != null ? pyExpressionStatement.getExpression() : null;
    }

    @Nullable
    public static PsiElement turnDirIntoInit(@Nullable PsiElement target) {
        long l2 = b ^ 0x4E3D522DCFC9L;
        if (target instanceof PsiDirectory) {
            PsiDirectory psiDirectory = (PsiDirectory)target;
            PsiFile psiFile = psiDirectory.findFile("__init__.pyi");
            if (psiFile != null) {
                return psiFile;
            }
            PsiFile psiFile2 = psiDirectory.findFile("__init__.py");
            if (psiFile2 != null) {
                return psiFile2;
            }
            return null;
        }
        return target;
    }

    @Nullable
    public static PsiElement getPackageElement(@NotNull PsiDirectory directory2, @Nullable PsiElement anchor) {
        if (directory2 == null) {
            PyUtil.a(86);
        }
        if (PyUtil.isPackage(directory2, anchor)) {
            PsiElement psiElement = PyUtil.turnDirIntoInit((PsiElement)directory2);
            if (psiElement != null) {
                return psiElement;
            }
            return directory2;
        }
        return null;
    }

    @Contract(value="null -> null")
    @Nullable
    public static PsiElement turnInitIntoDir(@Nullable PsiElement target) {
        if (target instanceof PyFile && PyUtil.isPackage((PsiFile)target)) {
            return ((PsiFile)target).getContainingDirectory();
        }
        return target;
    }

    public static boolean isPackage(@NotNull PsiDirectory directory2, @Nullable PsiElement anchor) {
        if (directory2 == null) {
            PyUtil.a(87);
        }
        return PyUtil.isPackage(directory2, true, anchor);
    }

    public static boolean isPackage(@NotNull PsiDirectory directory2, boolean checkSetupToolsPackages, @Nullable PsiElement anchor) {
        long l2 = b ^ 0x64AB05ADF8E3L;
        if (directory2 == null) {
            PyUtil.a(88);
        }
        Object object = (PyCustomPackageIdentifier[])PyCustomPackageIdentifier.EP_NAME.getExtensions();
        int n2 = ((PyCustomPackageIdentifier[])object).length;
        for (int i10 = 0; i10 < n2; ++i10) {
            PyCustomPackageIdentifier pyCustomPackageIdentifier = object[i10];
            if (!pyCustomPackageIdentifier.isPackage(directory2)) continue;
            return true;
        }
        if (directory2.findFile("__init__.py") != null) {
            return true;
        }
        Object object2 = object = anchor != null ? LanguageLevel.forElement(anchor) : PyUtil.getLanguageLevelForVirtualFile(directory2.getProject(), directory2.getVirtualFile());
        if (!((LanguageLevel)((Object)object)).isPython2()) {
            return true;
        }
        return checkSetupToolsPackages && PyUtil.b(directory2);
    }

    public static boolean isPackage(@NotNull PsiFile file) {
        long l2 = b ^ 0x3B5655638D98L;
        if (file == null) {
            PyUtil.a(89);
        }
        for (PyCustomPackageIdentifier pyCustomPackageIdentifier : (PyCustomPackageIdentifier[])PyCustomPackageIdentifier.EP_NAME.getExtensions()) {
            if (!pyCustomPackageIdentifier.isPackageFile(file)) continue;
            return true;
        }
        return "__init__.py".equals(file.getName());
    }

    public static boolean isPackage(@NotNull PsiFileSystemItem anchor, @Nullable PsiElement location) {
        if (anchor == null) {
            PyUtil.a(90);
        }
        return anchor instanceof PsiFile ? PyUtil.isPackage((PsiFile)anchor) : anchor instanceof PsiDirectory && PyUtil.isPackage((PsiDirectory)anchor, location);
    }

    private static boolean b(@NotNull PsiDirectory psiDirectory) {
        String string;
        if (psiDirectory == null) {
            PyUtil.a(91);
        }
        return (string = PyUtil.a(psiDirectory)) != null && !PySetuptoolsNamespaceIndex.find(string, psiDirectory.getProject()).isEmpty();
    }

    @Nullable
    private static String a(@NotNull PsiDirectory psiDirectory) {
        QualifiedName qualifiedName;
        if (psiDirectory == null) {
            PyUtil.a(92);
        }
        return (qualifiedName = QualifiedNameFinder.findShortestImportableQName((PsiFileSystemItem)psiDirectory)) != null ? qualifiedName.toString() : null;
    }

    public static int getInitialUnderscores(@Nullable String name) {
        long l2 = b ^ 0x32E2A02A8599L;
        return name == null ? 0 : (name.startsWith("__") ? 2 : (name.startsWith("_") ? 1 : 0));
    }

    public static boolean isClassPrivateName(@NotNull String name) {
        long l2 = b ^ 0x3D591C2E808AL;
        if (name == null) {
            PyUtil.a(93);
        }
        return name.startsWith("__") && !name.endsWith("__");
    }

    public static boolean isSpecialName(@NotNull String name) {
        long l2 = b ^ 0x2BBB55D21695L;
        if (name == null) {
            PyUtil.a(94);
        }
        return name.length() > 4 && name.startsWith("__") && name.endsWith("__");
    }

    @NotNull
    public static LookupElement createNamedParameterLookup(@NotNull String name, @NotNull PsiFile settingsAnchor) {
        long l2 = b ^ 0x595A60BCAA76L;
        if (name == null) {
            PyUtil.a(95);
        }
        if (settingsAnchor == null) {
            PyUtil.a(96);
        }
        String string = ((PyCodeStyleSettings)CodeStyle.getCustomSettings((PsiFile)settingsAnchor, PyCodeStyleSettings.class)).SPACE_AROUND_EQ_IN_KEYWORD_ARGUMENT ? " = " : "=";
        LookupElementBuilder lookupElementBuilder = LookupElementBuilder.create((String)(name + string)).withIcon(PlatformIcons.PARAMETER_ICON);
        lookupElementBuilder = lookupElementBuilder.withInsertHandler((InsertHandler)OverwriteEqualsInsertHandler.INSTANCE);
        LookupElement lookupElement = PrioritizedLookupElement.withGrouping((LookupElement)lookupElementBuilder, (int)1);
        if (lookupElement == null) {
            PyUtil.a(97);
        }
        return lookupElement;
    }

    @Nullable
    public static PyExpression peelArgument(PyExpression expr) {
        while (expr instanceof PyParenthesizedExpression) {
            expr = ((PyParenthesizedExpression)expr).getContainedExpression();
        }
        if (expr instanceof PyKeywordArgument) {
            expr = ((PyKeywordArgument)expr).getValueExpression();
        }
        return expr;
    }

    public static String getFirstParameterName(PyFunction container) {
        PyNamedParameter pyNamedParameter;
        PyParameter[] pyParameterArray;
        long l2 = b ^ 0x74A8C04E312DL;
        String string = "self";
        if (container != null && (pyParameterArray = container.getParameterList().getParameters()).length > 0 && (pyNamedParameter = pyParameterArray[0].getAsNamed()) != null) {
            string = pyNamedParameter.getName();
        }
        return string;
    }

    @NotNull
    public static Collection<VirtualFile> getSourceRoots(@NotNull PsiElement foothold) {
        Module module2;
        if (foothold == null) {
            PyUtil.a(98);
        }
        if ((module2 = ModuleUtilCore.findModuleForPsiElement((PsiElement)foothold)) != null) {
            Collection<VirtualFile> collection = PyUtil.getSourceRoots(module2);
            if (collection == null) {
                PyUtil.a(99);
            }
            return collection;
        }
        List<VirtualFile> list2 = Collections.emptyList();
        if (list2 == null) {
            PyUtil.a(100);
        }
        return list2;
    }

    @NotNull
    public static Collection<VirtualFile> getSourceRoots(@NotNull Module module2) {
        if (module2 == null) {
            PyUtil.a(101);
        }
        LinkedHashSet<VirtualFile> linkedHashSet = new LinkedHashSet<VirtualFile>();
        ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)module2);
        Collections.addAll(linkedHashSet, moduleRootManager.getSourceRoots());
        Collections.addAll(linkedHashSet, moduleRootManager.getContentRoots());
        LinkedHashSet<VirtualFile> linkedHashSet2 = linkedHashSet;
        if (linkedHashSet2 == null) {
            PyUtil.a(102);
        }
        return linkedHashSet2;
    }

    @Nullable
    public static VirtualFile findInRoots(Module module2, String path) {
        if (module2 != null) {
            for (VirtualFile virtualFile : PyUtil.getSourceRoots(module2)) {
                VirtualFile virtualFile2 = virtualFile.findFileByRelativePath(path);
                if (virtualFile2 == null) continue;
                return virtualFile2;
            }
        }
        return null;
    }

    @Nullable
    public static List<String> strListValue(PyExpression value) {
        while (value instanceof PyParenthesizedExpression) {
            value = ((PyParenthesizedExpression)value).getContainedExpression();
        }
        if (value instanceof PySequenceExpression) {
            PyExpression[] pyExpressionArray = ((PySequenceExpression)value).getElements();
            ArrayList<String> arrayList = new ArrayList<String>(pyExpressionArray.length);
            for (PyExpression pyExpression : pyExpressionArray) {
                if (!(pyExpression instanceof PyStringLiteralExpression)) {
                    return null;
                }
                arrayList.add(((PyStringLiteralExpression)pyExpression).getStringValue());
            }
            return arrayList;
        }
        return null;
    }

    @NotNull
    public static Map<String, PyExpression> dictValue(@NotNull PyDictLiteralExpression dict) {
        if (dict == null) {
            PyUtil.a(103);
        }
        LinkedHashMap linkedHashMap = Maps.newLinkedHashMap();
        for (PyKeyValueExpression pyKeyValueExpression : dict.getElements()) {
            PyExpression pyExpression = pyKeyValueExpression.getKey();
            PyExpression pyExpression2 = pyKeyValueExpression.getValue();
            if (!(pyExpression instanceof PyStringLiteralExpression)) continue;
            linkedHashMap.put(((PyStringLiteralExpression)pyExpression).getStringValue(), pyExpression2);
        }
        LinkedHashMap linkedHashMap2 = linkedHashMap;
        if (linkedHashMap2 == null) {
            PyUtil.a(104);
        }
        return linkedHashMap2;
    }

    public static <T> boolean among(@NotNull T what, T ... variants) {
        if (what == null) {
            PyUtil.a(105);
        }
        for (T t2 : variants) {
            if (!what.equals(t2)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static String getKeywordArgumentString(PyCallExpression expr, String keyword) {
        return PyPsiUtils.strValue(expr.getKeywordArgument(keyword));
    }

    public static boolean isExceptionClass(PyClass pyClass) {
        if (PyUtil.a(pyClass.getQualifiedName())) {
            return true;
        }
        for (PyClassLikeType pyClassLikeType : pyClass.getAncestorTypes(TypeEvalContext.codeInsightFallback(pyClass.getProject()))) {
            if (pyClassLikeType == null || !PyUtil.a(pyClassLikeType.getClassQName())) continue;
            return true;
        }
        return false;
    }

    private static boolean a(String string) {
        long l2 = b ^ 0xC539AB2FF8DL;
        return string != null && (string.contains("BaseException") || string.startsWith("exceptions."));
    }

    public static boolean isSuperCall(@NotNull PyCallExpression node) {
        PyClass pyClass;
        long l2 = b ^ 0x4434AF0710D6L;
        if (node == null) {
            PyUtil.a(106);
        }
        if ((pyClass = (PyClass)PsiTreeUtil.getParentOfType((PsiElement)node, PyClass.class)) == null) {
            return false;
        }
        PyExpression pyExpression = node.getCallee();
        if (pyExpression == null) {
            return false;
        }
        String string = pyExpression.getName();
        if ("super".equals(string)) {
            PsiReference psiReference = pyExpression.getReference();
            if (psiReference == null) {
                return false;
            }
            PsiElement psiElement = psiReference.resolve();
            PyBuiltinCache pyBuiltinCache = PyBuiltinCache.getInstance((PsiElement)node);
            if (psiElement != null && pyBuiltinCache.isBuiltin(psiElement)) {
                PyExpression[] pyExpressionArray = node.getArguments();
                if (pyExpressionArray.length > 0) {
                    String string2 = pyExpressionArray[0].getText();
                    if (string2.equals(pyClass.getName()) || string2.equals("self.__class__")) {
                        return true;
                    }
                    for (PyClass pyClass2 : pyClass.getAncestorClasses(null)) {
                        if (!string2.equals(pyClass2.getName())) continue;
                        return true;
                    }
                } else {
                    return true;
                }
            }
        }
        return false;
    }

    @NotNull
    public static PyFile getOrCreateFile(String path, Project project) {
        PsiFile psiFile;
        long l2 = b ^ 0x38FF15012C5FL;
        VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByIoFile(new File(path));
        if (virtualFile == null) {
            File file = new File(path);
            try {
                VirtualFile virtualFile2 = project.getBaseDir();
                FileTemplateManager fileTemplateManager = FileTemplateManager.getInstance((Project)project);
                FileTemplate fileTemplate = fileTemplateManager.getInternalTemplate("Python Script");
                Properties properties = fileTemplateManager.getDefaultProperties();
                properties.setProperty("NAME", FileUtilRt.getNameWithoutExtension((String)file.getName()));
                String string = fileTemplate != null ? fileTemplate.getText(properties) : null;
                psiFile = PyExtractSuperclassHelper.placeFile(project, StringUtil.notNullize((String)file.getParent(), (String)(virtualFile2 != null ? virtualFile2.getPath() : ".")), file.getName(), string);
            }
            catch (IOException iOException) {
                throw new IncorrectOperationException(String.format("Cannot create file '%s'", path), (Throwable)iOException);
            }
        } else {
            psiFile = PsiManager.getInstance((Project)project).findFile(virtualFile);
        }
        if (!(psiFile instanceof PyFile)) {
            throw new IncorrectOperationException(PyBundle.message("refactoring.move.module.members.error.cannot.place.elements.into.nonpython.file", new Object[0]));
        }
        PyFile pyFile = (PyFile)psiFile;
        if (pyFile == null) {
            PyUtil.a(107);
        }
        return pyFile;
    }

    @Nullable
    public static PsiElement findPrevAtOffset(PsiFile psiFile, int caretOffset, Class ... toSkip) {
        PsiElement psiElement;
        if (caretOffset < 0) {
            return null;
        }
        int n2 = 0;
        Document document = PsiDocumentManager.getInstance((Project)psiFile.getProject()).getDocument(psiFile);
        if (document != null) {
            int n3 = document.getLineNumber(caretOffset);
            n2 = document.getLineStartOffset(n3);
        }
        do {
            psiElement = psiFile.findElementAt(--caretOffset);
        } while (caretOffset >= n2 && PsiTreeUtil.instanceOf((Object)psiElement, (Class[])toSkip));
        return PsiTreeUtil.instanceOf((Object)psiElement, (Class[])toSkip) ? null : psiElement;
    }

    @Nullable
    public static PsiElement findNonWhitespaceAtOffset(PsiFile psiFile, int caretOffset) {
        PsiElement psiElement = PyUtil.findNextAtOffset(psiFile, caretOffset, PsiWhiteSpace.class);
        if (psiElement == null) {
            psiElement = PyUtil.findPrevAtOffset(psiFile, caretOffset - 1, PsiWhiteSpace.class);
        }
        return psiElement;
    }

    @Nullable
    public static PsiElement findElementAtOffset(PsiFile psiFile, int caretOffset) {
        PsiElement psiElement = PyUtil.findPrevAtOffset(psiFile, caretOffset, new Class[0]);
        if (psiElement == null) {
            psiElement = PyUtil.findNextAtOffset(psiFile, caretOffset, new Class[0]);
        }
        return psiElement;
    }

    @Nullable
    public static PsiElement findNextAtOffset(@NotNull PsiFile psiFile, int caretOffset, Class ... toSkip) {
        PsiElement psiElement;
        if (psiFile == null) {
            PyUtil.a(108);
        }
        if ((psiElement = psiFile.findElementAt(caretOffset)) == null) {
            return null;
        }
        Document document = PsiDocumentManager.getInstance((Project)psiFile.getProject()).getDocument(psiFile);
        int n2 = 0;
        if (document != null) {
            int n3 = document.getLineNumber(caretOffset);
            n2 = document.getLineEndOffset(n3);
        }
        while (caretOffset < n2 && PsiTreeUtil.instanceOf((Object)psiElement, (Class[])toSkip)) {
            psiElement = psiFile.findElementAt(++caretOffset);
        }
        return PsiTreeUtil.instanceOf((Object)psiElement, (Class[])toSkip) ? null : psiElement;
    }

    public static <T extends PyElement> T addElementToStatementList(@NotNull T element, @NotNull PyStatementList statementList) {
        if (element == null) {
            PyUtil.a(109);
        }
        if (statementList == null) {
            PyUtil.a(110);
        }
        PyStatement pyStatement = null;
        PyStatement pyStatement2 = null;
        for (PyStatement pyStatement3 : statementList.getStatements()) {
            if (PyDependenciesComparator.depends(element, pyStatement3)) {
                pyStatement2 = pyStatement3;
                continue;
            }
            if (!PyDependenciesComparator.depends(pyStatement3, element)) continue;
            pyStatement = pyStatement3;
        }
        PsiElement psiElement = pyStatement2 != null ? statementList.addAfter((PsiElement)element, (PsiElement)pyStatement2) : (pyStatement != null ? statementList.addBefore((PsiElement)element, (PsiElement)pyStatement) : PyUtil.addElementToStatementList(element, statementList, true));
        PyElement pyElement = (PyElement)psiElement;
        return (T)pyElement;
    }

    @NotNull
    public static PsiElement addElementToStatementList(@NotNull PsiElement element, @NotNull PyStatementList statementList, boolean toTheBeginning) {
        PyElement pyElement;
        Object object;
        PyElement pyElement2;
        PsiElement psiElement;
        Document document;
        PsiElement psiElement2;
        long l2 = b ^ 0x2F4C0B6F349CL;
        if (element == null) {
            PyUtil.a(111);
        }
        if (statementList == null) {
            PyUtil.a(112);
        }
        if ((psiElement2 = PyPsiUtils.getPrevNonWhitespaceSibling((PsiElement)statementList)) != null && PyUtil.onSameLine((PsiElement)statementList, psiElement2) && (document = (psiElement = PsiDocumentManager.getInstance((Project)statementList.getProject())).getDocument(statementList.getContainingFile())) != null) {
            pyElement2 = (PyStatementListContainer)statementList.getParent();
            psiElement.doPostponedOperationsAndUnblockDocument(document);
            object = "\n" + PyIndentUtil.getElementIndent((PsiElement)statementList);
            pyElement = statementList.getStatements().length == 0 ? (String)object + "pass" : object;
            document.insertString(statementList.getTextRange().getStartOffset(), (CharSequence)((Object)pyElement));
            psiElement.commitDocument(document);
            statementList = pyElement2.getStatementList();
        }
        if ((psiElement = statementList.getFirstChild()) == statementList.getLastChild() && psiElement instanceof PyPassStatement) {
            element = psiElement.replace(element);
        } else {
            document = statementList.getStatements();
            if (toTheBeginning && ((Document)document).length > 0) {
                pyElement2 = (PyDocStringOwner)PsiTreeUtil.getParentOfType((PsiElement)statementList, PyDocStringOwner.class);
                object = document[0];
                if (pyElement2 != null && object instanceof PyExpressionStatement && ((PyExpressionStatement)object).getExpression() == pyElement2.getDocStringExpression()) {
                    pyElement = (PyStatement)PsiTreeUtil.getNextSiblingOfType((PsiElement)object, PyStatement.class);
                    if (pyElement == null) {
                        PsiElement psiElement3 = statementList.addAfter(element, (PsiElement)object);
                        if (psiElement3 == null) {
                            PyUtil.a(113);
                        }
                        return psiElement3;
                    }
                    object = pyElement;
                }
                while (object instanceof PyExpressionStatement && (pyElement = ((PyExpressionStatement)object).getExpression()) instanceof PyCallExpression) {
                    PyExpression pyExpression = ((PyCallExpression)pyElement).getCallee();
                    if (!PyUtil.isSuperCall((PyCallExpression)pyElement) && (pyExpression == null || !"__init__".equals(pyExpression.getName()))) break;
                    PyStatement pyStatement = (PyStatement)PsiTreeUtil.getNextSiblingOfType((PsiElement)object, PyStatement.class);
                    if (pyStatement == null) {
                        PsiElement psiElement4 = statementList.addAfter(element, (PsiElement)object);
                        if (psiElement4 == null) {
                            PyUtil.a(114);
                        }
                        return psiElement4;
                    }
                    object = pyStatement;
                }
                element = statementList.addBefore(element, (PsiElement)object);
            } else {
                element = statementList.add(element);
            }
        }
        PsiElement psiElement5 = element;
        if (psiElement5 == null) {
            PyUtil.a(115);
        }
        return psiElement5;
    }

    public static boolean isSignatureCompatibleTo(@NotNull PyCallable callable, @NotNull PyCallable otherCallable, @NotNull TypeEvalContext context) {
        if (callable == null) {
            PyUtil.a(116);
        }
        if (otherCallable == null) {
            PyUtil.a(117);
        }
        if (context == null) {
            PyUtil.a(118);
        }
        List<PyCallableParameter> list2 = callable.getParameters(context);
        List<PyCallableParameter> list3 = otherCallable.getParameters(context);
        int n2 = PyUtil.d(list2);
        int n3 = PyUtil.d(list3);
        int n4 = PyUtil.a(callable, list2);
        int n5 = PyUtil.a(otherCallable, list3);
        if ((PyUtil.e(list3) || PyUtil.a(list3)) && list3.size() == PyUtil.b(otherCallable, list3)) {
            return true;
        }
        if (PyUtil.e(list2) || PyUtil.a(list2)) {
            return n4 <= n5;
        }
        return n4 <= n5 && n2 >= n3 && PyUtil.b(list2) >= PyUtil.b(list3);
    }

    private static int d(@NotNull List<PyCallableParameter> list2) {
        if (list2 == null) {
            PyUtil.a(119);
        }
        int n2 = 0;
        for (PyCallableParameter pyCallableParameter : list2) {
            if (!pyCallableParameter.hasDefaultValue()) continue;
            ++n2;
        }
        return n2;
    }

    private static int a(@NotNull PyCallable pyCallable, @NotNull List<PyCallableParameter> list2) {
        if (pyCallable == null) {
            PyUtil.a(120);
        }
        if (list2 == null) {
            PyUtil.a(121);
        }
        return PyUtil.b(list2) - PyUtil.d(list2) - PyUtil.b(pyCallable, list2);
    }

    private static int b(@NotNull PyCallable pyCallable, @NotNull List<PyCallableParameter> list2) {
        if (pyCallable == null) {
            PyUtil.a(122);
        }
        if (list2 == null) {
            PyUtil.a(123);
        }
        int n2 = 0;
        if (PyUtil.e(list2)) {
            ++n2;
        }
        if (PyUtil.a(list2)) {
            ++n2;
        }
        if (PyUtil.c(pyCallable, list2)) {
            ++n2;
        }
        return n2;
    }

    private static boolean e(@NotNull List<PyCallableParameter> list2) {
        if (list2 == null) {
            PyUtil.a(124);
        }
        for (PyCallableParameter pyCallableParameter : list2) {
            if (!pyCallableParameter.isPositionalContainer()) continue;
            return true;
        }
        return false;
    }

    private static boolean a(@NotNull List<PyCallableParameter> list2) {
        if (list2 == null) {
            PyUtil.a(125);
        }
        for (PyCallableParameter pyCallableParameter : list2) {
            if (!pyCallableParameter.isKeywordContainer()) continue;
            return true;
        }
        return false;
    }

    private static int b(@NotNull List<PyCallableParameter> list2) {
        if (list2 == null) {
            PyUtil.a(126);
        }
        return ContainerUtil.count(list2, pyCallableParameter -> pyCallableParameter.getParameter() instanceof PyNamedParameter);
    }

    private static boolean c(@NotNull PyCallable pyCallable, @NotNull List<PyCallableParameter> list2) {
        PyFunction pyFunction;
        long l2 = b ^ 0x5D81C1378CF9L;
        if (pyCallable == null) {
            PyUtil.a(127);
        }
        if (list2 == null) {
            PyUtil.a(128);
        }
        if ((pyFunction = pyCallable.asMethod()) != null) {
            return "__new__".equals(pyFunction.getName()) || pyFunction.getModifier() != PyFunction.Modifier.STATICMETHOD;
        }
        PyCallableParameter pyCallableParameter = (PyCallableParameter)ContainerUtil.getFirstItem(list2);
        return pyCallableParameter != null && "self".equals(pyCallableParameter.getName());
    }

    public static boolean isInit(@NotNull PyFunction function) {
        long l2 = b ^ 0x1BF5D4B2BC88L;
        if (function == null) {
            PyUtil.a(129);
        }
        return "__init__".equals(function.getName());
    }

    @NotNull
    public static Collection<PyMemberInfo<PyElement>> filterOutObject(@NotNull Collection<PyMemberInfo<PyElement>> pyMemberInfos) {
        if (pyMemberInfos == null) {
            PyUtil.a(130);
        }
        Collection collection = Collections2.filter(pyMemberInfos, (Predicate)new ObjectPredicate(false));
        if (collection == null) {
            PyUtil.a(131);
        }
        return collection;
    }

    public static boolean isStarImportableFrom(@NotNull String name, @NotNull PyFile file) {
        List<String> list2;
        if (name == null) {
            PyUtil.a(132);
        }
        if (file == null) {
            PyUtil.a(133);
        }
        return (list2 = file.getDunderAll()) != null ? list2.contains(name) : !name.startsWith("_");
    }

    public static boolean isObjectClass(@NotNull PyClass cls) {
        long l2 = b ^ 0x4B13D260E2A7L;
        if (cls == null) {
            PyUtil.a(134);
        }
        return "object".equals(cls.getQualifiedName());
    }

    public static boolean isInScratchFile(@NotNull PsiElement element) {
        if (element == null) {
            PyUtil.a(135);
        }
        return ScratchFileService.isInScratchRoot((VirtualFile)PsiUtilCore.getVirtualFile((PsiElement)element));
    }

    @Nullable
    public static PyType getReturnTypeOfMember(@NotNull PyType type, @NotNull String memberName, @Nullable PyExpression location, @NotNull TypeEvalContext context) {
        PyResolveContext pyResolveContext;
        List<? extends RatedResolveResult> list2;
        if (type == null) {
            PyUtil.a(136);
        }
        if (memberName == null) {
            PyUtil.a(137);
        }
        if (context == null) {
            PyUtil.a(138);
        }
        if ((list2 = type.resolveMember(memberName, location, AccessDirection.READ, pyResolveContext = PyResolveContext.noImplicits().withTypeEvalContext(context))) != null) {
            ArrayList<PyType> arrayList = new ArrayList<PyType>();
            for (RatedResolveResult ratedResolveResult : list2) {
                PyType pyType = PyUtil.a(ratedResolveResult.getElement(), context);
                if (pyType == null) continue;
                arrayList.add(pyType);
            }
            return PyUnionType.union(arrayList);
        }
        return null;
    }

    @Nullable
    private static PyType a(@Nullable PsiElement psiElement, @NotNull TypeEvalContext typeEvalContext) {
        if (typeEvalContext == null) {
            PyUtil.a(139);
        }
        if (psiElement instanceof PyTypedElement) {
            PyType pyType = typeEvalContext.getType((PyTypedElement)psiElement);
            return PyUtil.a(pyType, typeEvalContext);
        }
        return null;
    }

    @Nullable
    private static PyType a(@Nullable PyType pyType, @NotNull TypeEvalContext typeEvalContext) {
        if (typeEvalContext == null) {
            PyUtil.a(140);
        }
        if (pyType instanceof PyCallableType) {
            return ((PyCallableType)pyType).getReturnType(typeEvalContext);
        }
        if (pyType instanceof PyUnionType) {
            ArrayList<PyType> arrayList = new ArrayList<PyType>();
            for (PyType pyType2 : ((PyUnionType)pyType).getMembers()) {
                PyType pyType3 = PyUtil.a(pyType2, typeEvalContext);
                if (pyType3 == null) continue;
                arrayList.add(pyType3);
            }
            return PyUnionType.union(arrayList);
        }
        return null;
    }

    public static boolean isEmptyFunction(@NotNull PyFunction function) {
        PyStatementList pyStatementList;
        PyStatement[] pyStatementArray;
        if (function == null) {
            PyUtil.a(141);
        }
        if ((pyStatementArray = (pyStatementList = function.getStatementList()).getStatements()).length == 0) {
            return true;
        }
        return pyStatementArray.length == 1 ? PyUtil.isStringLiteral(pyStatementArray[0]) || PyUtil.a(pyStatementArray[0]) : pyStatementArray.length == 2 && PyUtil.isStringLiteral(pyStatementArray[0]) && PyUtil.a(pyStatementArray[1]);
    }

    private static boolean a(PyStatement pyStatement) {
        PyExpression pyExpression;
        if (pyStatement instanceof PyPassStatement || pyStatement instanceof PyRaiseStatement) {
            return true;
        }
        if (pyStatement instanceof PyReturnStatement && ((PyReturnStatement)pyStatement).getExpression() == null) {
            return true;
        }
        return pyStatement instanceof PyExpressionStatement && (pyExpression = ((PyExpressionStatement)pyStatement).getExpression()) instanceof PyNoneLiteralExpression && ((PyNoneLiteralExpression)pyExpression).isEllipsis();
    }

    public static boolean isStringLiteral(@Nullable PyStatement stmt) {
        PyExpression pyExpression;
        return stmt instanceof PyExpressionStatement && (pyExpression = ((PyExpressionStatement)stmt).getExpression()) instanceof PyStringLiteralExpression;
    }

    @Nullable
    public static PyLoopStatement getCorrespondingLoop(@NotNull PsiElement breakOrContinue) {
        if (breakOrContinue == null) {
            PyUtil.a(142);
        }
        return breakOrContinue instanceof PyContinueStatement || breakOrContinue instanceof PyBreakStatement ? PyUtil.a(breakOrContinue) : null;
    }

    @Nullable
    private static PyLoopStatement a(@NotNull PsiElement psiElement) {
        PyLoopStatement pyLoopStatement;
        if (psiElement == null) {
            PyUtil.a(143);
        }
        if ((pyLoopStatement = (PyLoopStatement)PsiTreeUtil.getParentOfType((PsiElement)psiElement, PyLoopStatement.class, (boolean)true, (Class[])new Class[]{ScopeOwner.class})) instanceof PyStatementWithElse && PsiTreeUtil.isAncestor((PsiElement)((PyStatementWithElse)((Object)pyLoopStatement)).getElsePart(), (PsiElement)psiElement, (boolean)true)) {
            return PyUtil.a((PsiElement)pyLoopStatement);
        }
        return pyLoopStatement;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isForbiddenMutableDefault(@Nullable PyTypedElement value, @NotNull TypeEvalContext context) {
        PyClass pyClass;
        if (context == null) {
            PyUtil.a(144);
        }
        if (value == null) {
            return false;
        }
        PyClassType pyClassType = PyUtil.as(context.getType(value), PyClassType.class);
        if (pyClassType == null) return false;
        if (pyClassType.isDefinition()) return false;
        PyBuiltinCache pyBuiltinCache = PyBuiltinCache.getInstance((PsiElement)value);
        Set set = StreamEx.of((Object[])new PyClassType[]{pyBuiltinCache.getListType(), pyBuiltinCache.getSetType(), pyBuiltinCache.getDictType()}).nonNull().map(PyClassType::getPyClass).toSet();
        if (set.contains(pyClass = pyClassType.getPyClass())) return true;
        if (!ContainerUtil.exists(pyClass.getAncestorClasses(context), set::contains)) return false;
        return true;
    }

    public static void addDecorator(@NotNull PyFunction function, @NotNull String decorator) {
        if (function == null) {
            PyUtil.a(145);
        }
        if (decorator == null) {
            PyUtil.a(146);
        }
        PyDecoratorList pyDecoratorList = function.getDecoratorList();
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(decorator);
        if (pyDecoratorList != null) {
            for (PyDecorator pyDecorator : pyDecoratorList.getDecorators()) {
                arrayList.add(pyDecorator.getText());
            }
        }
        PyElementGenerator pyElementGenerator = PyElementGenerator.getInstance(function.getProject());
        PyDecoratorList pyDecoratorList2 = pyElementGenerator.createDecoratorList(ArrayUtilRt.toStringArray(arrayList));
        if (pyDecoratorList != null) {
            pyDecoratorList.replace((PsiElement)pyDecoratorList2);
        } else {
            function.addBefore((PsiElement)pyDecoratorList2, function.getFirstChild());
        }
    }

    static {
        b = c.a(6554871552230636876L, 8584780637835209765L, MethodHandles.lookup().lookupClass()).a(105925993904110L);
        long l2 = b ^ 0x208BF5AE0217L;
        a = System.getenv().get("_PYCHARM_VERBOSE_MODE") != null;
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = b ^ 0x51BEF379DA6FL;
        switch (n2) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 19: 
            case 20: 
            case 26: 
            case 27: 
            case 29: 
            case 30: 
            case 33: 
            case 35: 
            case 38: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 51: 
            case 53: 
            case 54: 
            case 56: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 65: 
            case 66: 
            case 67: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 98: 
            case 101: 
            case 103: 
            case 105: 
            case 106: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 125: 
            case 126: 
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 142: 
            case 143: 
            case 144: 
            case 145: 
            case 146: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 2;
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 19: 
            case 20: 
            case 26: 
            case 27: 
            case 29: 
            case 30: 
            case 33: 
            case 35: 
            case 38: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 51: 
            case 53: 
            case 54: 
            case 56: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 65: 
            case 66: 
            case 67: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 98: 
            case 101: 
            case 103: 
            case 105: 
            case 106: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 125: 
            case 126: 
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 142: 
            case 143: 
            case 144: 
            case 145: 
            case 146: {
                n3 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/psi/PyUtil";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e1";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e2";
                break;
            }
            case 11: 
            case 19: 
            case 20: 
            case 29: 
            case 60: 
            case 66: 
            case 69: 
            case 109: 
            case 111: 
            case 135: 
            case 143: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 12: 
            case 134: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cls";
                break;
            }
            case 13: 
            case 83: 
            case 85: 
            case 118: 
            case 138: 
            case 139: 
            case 140: 
            case 144: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 14: 
            case 72: 
            case 82: 
            case 129: 
            case 141: 
            case 145: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comprehension";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementToResolve";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveContext";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 35: 
            case 38: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveResults";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveResult";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pyClass";
                break;
            }
            case 44: 
            case 53: 
            case 54: 
            case 56: 
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 51: 
            case 101: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedClass";
                break;
            }
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementClass";
                break;
            }
            case 67: 
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "f";
                break;
            }
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 74: 
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
            case 77: 
            case 106: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 78: 
            case 80: 
            case 90: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 81: {
                objectArray2 = objectArray3;
                objectArray3[0] = "func";
                break;
            }
            case 84: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressionText";
                break;
            }
            case 86: 
            case 87: 
            case 88: 
            case 91: 
            case 92: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 89: 
            case 133: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 93: 
            case 94: 
            case 95: 
            case 132: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 96: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settingsAnchor";
                break;
            }
            case 98: {
                objectArray2 = objectArray3;
                objectArray3[0] = "foothold";
                break;
            }
            case 103: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dict";
                break;
            }
            case 105: {
                objectArray2 = objectArray3;
                objectArray3[0] = "what";
                break;
            }
            case 108: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 110: 
            case 112: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statementList";
                break;
            }
            case 116: 
            case 120: 
            case 122: 
            case 127: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callable";
                break;
            }
            case 117: {
                objectArray2 = objectArray3;
                objectArray3[0] = "otherCallable";
                break;
            }
            case 119: 
            case 121: 
            case 123: 
            case 124: 
            case 125: 
            case 126: 
            case 128: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 130: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pyMemberInfos";
                break;
            }
            case 136: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 137: {
                objectArray2 = objectArray3;
                objectArray3[0] = "memberName";
                break;
            }
            case 142: {
                objectArray2 = objectArray3;
                objectArray3[0] = "breakOrContinue";
                break;
            }
            case 146: {
                objectArray2 = objectArray3;
                objectArray3[0] = "decorator";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "flattenedParensAndTuples";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "flattenedParensAndLists";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "flattenedParensAndStars";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getReadableRepr";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "sure";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 19: 
            case 20: 
            case 26: 
            case 27: 
            case 29: 
            case 30: 
            case 33: 
            case 35: 
            case 38: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 51: 
            case 53: 
            case 54: 
            case 56: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 65: 
            case 66: 
            case 67: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 98: 
            case 101: 
            case 103: 
            case 105: 
            case 106: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 125: 
            case 126: 
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 142: 
            case 143: 
            case 144: 
            case 145: 
            case 146: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/psi/PyUtil";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getPropertyAccessDirection";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "computeElementNameForStringSearch";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveToTheTop";
                break;
            }
            case 31: 
            case 32: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolveTopPriority";
                break;
            }
            case 36: 
            case 37: 
            case 39: 
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "filterTopPriorityResults";
                break;
            }
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguageLevelForVirtualFile";
                break;
            }
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguageLevelForModule";
                break;
            }
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "guessLanguageLevelWithCaching";
                break;
            }
            case 57: 
            case 58: {
                objectArray = objectArray2;
                objectArray2[1] = "guessLanguageLevel";
                break;
            }
            case 63: 
            case 64: {
                objectArray = objectArray2;
                objectArray2[1] = "asList";
                break;
            }
            case 68: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameterizedCachedValue";
                break;
            }
            case 76: {
                objectArray = objectArray2;
                objectArray2[1] = "getHeaderEndAnchor";
                break;
            }
            case 97: {
                objectArray = objectArray2;
                objectArray2[1] = "createNamedParameterLookup";
                break;
            }
            case 99: 
            case 100: 
            case 102: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceRoots";
                break;
            }
            case 104: {
                objectArray = objectArray2;
                objectArray2[1] = "dictValue";
                break;
            }
            case 107: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateFile";
                break;
            }
            case 113: 
            case 114: 
            case 115: {
                objectArray = objectArray2;
                objectArray2[1] = "addElementToStatementList";
                break;
            }
            case 131: {
                objectArray = objectArray2;
                objectArray2[1] = "filterOutObject";
                break;
            }
        }
        switch (n2) {
            default: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "inSameFile";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "onSameLine";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isTopLevel";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "hasUnresolvedAncestors";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getPropertyAccessDirection";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "removeQualifier";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "computeElementNameForStringSearch";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "isOwnScopeComprehension";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "resolveToTheTop";
                break;
            }
            case 29: 
            case 30: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "multiResolveTopPriority";
                break;
            }
            case 35: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "filterTopPriorityResults";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getMaxRate";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "getRate";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "getInitMethod";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "getLanguageLevelForVirtualFile";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "getLanguageLevelForModule";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "invalidateLanguageLevelCache";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "guessLanguageLevelWithCaching";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "guessLanguageLevel";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "as";
                break;
            }
            case 60: 
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "findReference";
                break;
            }
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "asList";
                break;
            }
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "rehighlightOpenEditors";
                break;
            }
            case 66: 
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "getParameterizedCachedValue";
                break;
            }
            case 69: 
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "getNullableParameterizedCachedValue";
                break;
            }
            case 71: 
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "runWithProgress";
                break;
            }
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "verboseOnly";
                break;
            }
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "getCommentOnHeaderLine";
                break;
            }
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "getHeaderEndAnchor";
                break;
            }
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "isPy2ReservedWord";
                break;
            }
            case 78: 
            case 79: 
            case 80: 
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "updateDocumentUnblockedAndCommitted";
                break;
            }
            case 82: 
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "getReturnTypeToAnalyzeAsCallType";
                break;
            }
            case 84: 
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "createExpressionFromFragment";
                break;
            }
            case 86: {
                objectArray = objectArray;
                objectArray[2] = "getPackageElement";
                break;
            }
            case 87: 
            case 88: 
            case 89: 
            case 90: {
                objectArray = objectArray;
                objectArray[2] = "isPackage";
                break;
            }
            case 91: {
                objectArray = objectArray;
                objectArray[2] = "isSetuptoolsNamespacePackage";
                break;
            }
            case 92: {
                objectArray = objectArray;
                objectArray[2] = "getPackagePath";
                break;
            }
            case 93: {
                objectArray = objectArray;
                objectArray[2] = "isClassPrivateName";
                break;
            }
            case 94: {
                objectArray = objectArray;
                objectArray[2] = "isSpecialName";
                break;
            }
            case 95: 
            case 96: {
                objectArray = objectArray;
                objectArray[2] = "createNamedParameterLookup";
                break;
            }
            case 98: 
            case 101: {
                objectArray = objectArray;
                objectArray[2] = "getSourceRoots";
                break;
            }
            case 103: {
                objectArray = objectArray;
                objectArray[2] = "dictValue";
                break;
            }
            case 105: {
                objectArray = objectArray;
                objectArray[2] = "among";
                break;
            }
            case 106: {
                objectArray = objectArray;
                objectArray[2] = "isSuperCall";
                break;
            }
            case 108: {
                objectArray = objectArray;
                objectArray[2] = "findNextAtOffset";
                break;
            }
            case 109: 
            case 110: 
            case 111: 
            case 112: {
                objectArray = objectArray;
                objectArray[2] = "addElementToStatementList";
                break;
            }
            case 116: 
            case 117: 
            case 118: {
                objectArray = objectArray;
                objectArray[2] = "isSignatureCompatibleTo";
                break;
            }
            case 119: {
                objectArray = objectArray;
                objectArray[2] = "optionalParametersCount";
                break;
            }
            case 120: 
            case 121: {
                objectArray = objectArray;
                objectArray[2] = "requiredParametersCount";
                break;
            }
            case 122: 
            case 123: {
                objectArray = objectArray;
                objectArray[2] = "specialParametersCount";
                break;
            }
            case 124: {
                objectArray = objectArray;
                objectArray[2] = "hasPositionalContainer";
                break;
            }
            case 125: {
                objectArray = objectArray;
                objectArray[2] = "hasKeywordContainer";
                break;
            }
            case 126: {
                objectArray = objectArray;
                objectArray[2] = "namedParametersCount";
                break;
            }
            case 127: 
            case 128: {
                objectArray = objectArray;
                objectArray[2] = "isFirstParameterSpecial";
                break;
            }
            case 129: {
                objectArray = objectArray;
                objectArray[2] = "isInit";
                break;
            }
            case 130: {
                objectArray = objectArray;
                objectArray[2] = "filterOutObject";
                break;
            }
            case 132: 
            case 133: {
                objectArray = objectArray;
                objectArray[2] = "isStarImportableFrom";
                break;
            }
            case 134: {
                objectArray = objectArray;
                objectArray[2] = "isObjectClass";
                break;
            }
            case 135: {
                objectArray = objectArray;
                objectArray[2] = "isInScratchFile";
                break;
            }
            case 136: 
            case 137: 
            case 138: {
                objectArray = objectArray;
                objectArray[2] = "getReturnTypeOfMember";
                break;
            }
            case 139: 
            case 140: {
                objectArray = objectArray;
                objectArray[2] = "getReturnType";
                break;
            }
            case 141: {
                objectArray = objectArray;
                objectArray[2] = "isEmptyFunction";
                break;
            }
            case 142: {
                objectArray = objectArray;
                objectArray[2] = "getCorrespondingLoop";
                break;
            }
            case 143: {
                objectArray = objectArray;
                objectArray[2] = "getCorrespondingLoopImpl";
                break;
            }
            case 144: {
                objectArray = objectArray;
                objectArray[2] = "isForbiddenMutableDefault";
                break;
            }
            case 145: 
            case 146: {
                objectArray = objectArray;
                objectArray[2] = "addDecorator";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 19: 
            case 20: 
            case 26: 
            case 27: 
            case 29: 
            case 30: 
            case 33: 
            case 35: 
            case 38: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 51: 
            case 53: 
            case 54: 
            case 56: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 65: 
            case 66: 
            case 67: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 98: 
            case 101: 
            case 103: 
            case 105: 
            case 106: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 125: 
            case 126: 
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 142: 
            case 143: 
            case 144: 
            case 145: 
            case 146: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class IterHelper {
        private IterHelper() {
        }

        @Nullable
        public static PsiNamedElement findName(Iterable<? extends PsiNamedElement> it2, String name) {
            PsiNamedElement psiNamedElement = null;
            for (PsiNamedElement psiNamedElement2 : it2) {
                if (psiNamedElement2 == null || psiNamedElement2 instanceof PyQualifiedExpression && ((PyQualifiedExpression)psiNamedElement2).isQualified() || !name.equals(psiNamedElement2.getName())) continue;
                psiNamedElement = psiNamedElement2;
                break;
            }
            return psiNamedElement;
        }
    }

    public static final class StringNodeInfo {
        private final ASTNode b;
        private final String c;
        private final String d;
        private final TextRange a;
        private static final long e = com.jetbrains.python.psi.c.a(2575128367477420621L, 7543607889672175523L, MethodHandles.lookup().lookupClass()).a(243559219040059L);

        public StringNodeInfo(@NotNull ASTNode node) {
            long l2 = e ^ 0x2C5613931753L;
            if (node == null) {
                StringNodeInfo.a(0);
            }
            IElementType iElementType = node.getElementType();
            if (!PyTokenTypes.STRING_NODES.contains(iElementType) && iElementType != PyElementTypes.FSTRING_NODE) {
                throw new IllegalArgumentException("Node must be valid Python string literal token, but " + iElementType + " was given");
            }
            this.b = node;
            String string = node.getText();
            int n2 = PyStringLiteralUtil.getPrefixLength(string);
            this.c = string.substring(0, n2);
            this.a = PyStringLiteralUtil.getContentRange(string);
            this.d = string.substring(n2, this.a.getStartOffset());
        }

        public StringNodeInfo(@NotNull PsiElement element) {
            if (element == null) {
                StringNodeInfo.a(1);
            }
            this(element.getNode());
        }

        @NotNull
        public ASTNode getNode() {
            ASTNode aSTNode = this.b;
            if (aSTNode == null) {
                StringNodeInfo.a(2);
            }
            return aSTNode;
        }

        @NotNull
        public String getPrefix() {
            String string = this.c;
            if (string == null) {
                StringNodeInfo.a(3);
            }
            return string;
        }

        @NotNull
        public String getContent() {
            String string = this.a.substring(this.b.getText());
            if (string == null) {
                StringNodeInfo.a(4);
            }
            return string;
        }

        @NotNull
        public TextRange getContentRange() {
            TextRange textRange = this.a;
            if (textRange == null) {
                StringNodeInfo.a(5);
            }
            return textRange;
        }

        @NotNull
        public TextRange getAbsoluteContentRange() {
            TextRange textRange = this.getContentRange().shiftRight(this.b.getStartOffset());
            if (textRange == null) {
                StringNodeInfo.a(6);
            }
            return textRange;
        }

        public char getSingleQuote() {
            return this.d.charAt(0);
        }

        @NotNull
        public String getQuote() {
            String string = this.d;
            if (string == null) {
                StringNodeInfo.a(7);
            }
            return string;
        }

        public boolean isTripleQuoted() {
            return this.d.length() == 3;
        }

        public boolean isTerminated() {
            String string = this.b.getText();
            return string.length() - this.c.length() >= this.d.length() * 2 && string.endsWith(this.d);
        }

        public boolean isUnicode() {
            return PyStringLiteralUtil.isUnicodePrefix(this.c);
        }

        public boolean isRaw() {
            return PyStringLiteralUtil.isRawPrefix(this.c);
        }

        public boolean isBytes() {
            return PyStringLiteralUtil.isBytesPrefix(this.c);
        }

        public boolean isFormatted() {
            return PyStringLiteralUtil.isFormattedPrefix(this.c);
        }

        public boolean equals(Object o2) {
            if (this == o2) {
                return true;
            }
            if (o2 == null || this.getClass() != o2.getClass()) {
                return false;
            }
            StringNodeInfo stringNodeInfo = (StringNodeInfo)o2;
            return this.getQuote().equals(stringNodeInfo.getQuote()) && this.isRaw() == stringNodeInfo.isRaw() && this.isUnicode() == stringNodeInfo.isUnicode() && this.isBytes() == stringNodeInfo.isBytes();
        }

        private static /* synthetic */ void a(int n2) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n3;
            String string;
            long l2 = e ^ 0xDFC2BB6F599L;
            switch (n2) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n2) {
                default: {
                    n3 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    n3 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/psi/PyUtil$StringNodeInfo";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/psi/PyUtil$StringNodeInfo";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNode";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPrefix";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getContent";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getContentRange";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAbsoluteContentRange";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getQuote";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n2) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class ObjectPredicate
    extends NotNullPredicate<PyMemberInfo<PyElement>> {
        private final boolean a;
        private static final long c = com.jetbrains.python.psi.c.a(8068287297485051031L, 1290638915229552049L, MethodHandles.lookup().lookupClass()).a(80323778723353L);

        public ObjectPredicate(boolean allowObjects) {
            this.a = allowObjects;
        }

        @Override
        public boolean applyNotNull(@NotNull PyMemberInfo<PyElement> input) {
            if (input == null) {
                ObjectPredicate.b(0);
            }
            return this.a == ObjectPredicate.a(input);
        }

        private static boolean a(@NotNull PyMemberInfo<PyElement> pyMemberInfo) {
            PyElement pyElement;
            long l2 = c ^ 0x47AE9DF3C643L;
            if (pyMemberInfo == null) {
                ObjectPredicate.b(1);
            }
            return (pyElement = (PyElement)pyMemberInfo.getMember()) instanceof PyClass && "object".equals(pyElement.getName());
        }

        private static /* synthetic */ void b(int n2) {
            Object[] objectArray;
            Object[] objectArray2;
            long l2 = c ^ 0x3648CB5FBC15L;
            Object[] objectArray3 = new Object[3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "input";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "classMemberInfo";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/python/psi/PyUtil$ObjectPredicate";
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "applyNotNull";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isObject";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class MethodFlags {
        private final boolean d;
        private final boolean b;
        private final boolean c;
        private final boolean a;
        private static final long e = com.jetbrains.python.psi.c.a(-336968253394085019L, -6891745163286355495L, MethodHandles.lookup().lookupClass()).a(193601485290126L);

        public boolean isMetaclassMethod() {
            return this.b;
        }

        public boolean isSpecialMetaclassMethod() {
            return this.c;
        }

        public boolean isStaticMethod() {
            return this.d;
        }

        public boolean isClassMethod() {
            return this.a;
        }

        private MethodFlags(boolean isClassMethod, boolean isStaticMethod, boolean isMetaclassMethod, boolean isSpecialMetaclassMethod) {
            this.a = isClassMethod;
            this.d = isStaticMethod;
            this.b = isMetaclassMethod;
            this.c = isSpecialMetaclassMethod;
        }

        @Nullable
        public static MethodFlags of(@NotNull PyFunction node) {
            PyClass pyClass;
            long l2 = e ^ 0x7544C1A170EBL;
            if (node == null) {
                MethodFlags.a(0);
            }
            if ((pyClass = node.getContainingClass()) != null) {
                PyFunction.Modifier modifier = node.getModifier();
                boolean bl2 = false;
                PyClass pyClass2 = PyBuiltinCache.getInstance(node).getClass("type");
                for (PyClass pyClass3 : pyClass.getAncestorClasses(null)) {
                    if (pyClass3 != pyClass2) continue;
                    bl2 = true;
                    break;
                }
                String string = node.getName();
                boolean bl3 = bl2 && string != null && PyUtil.among(string, "__init__", "__call__");
                return new MethodFlags(modifier == PyFunction.Modifier.CLASSMETHOD, modifier == PyFunction.Modifier.STATICMETHOD, bl2, bl3);
            }
            return null;
        }

        public boolean isInstanceMethod() {
            return !this.a && !this.d;
        }

        private static /* synthetic */ void a(int n2) {
            long l2 = e ^ 0x2112B7E8EDF5L;
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/jetbrains/python/psi/PyUtil$MethodFlags", "of"));
        }
    }

    public static class KnownDecoratorProviderHolder {
        public static final List<PyKnownDecoratorProvider> KNOWN_DECORATOR_PROVIDERS = PyKnownDecoratorProvider.EP_NAME.getExtensionList();

        private KnownDecoratorProviderHolder() {
        }
    }
}

