/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.parsing;

import com.intellij.lang.PsiBuilder;
import com.intellij.lang.WhitespacesAndCommentsBinder;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.PyElementTypes;
import com.jetbrains.python.PyStubElementTypes;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.parsing.Parsing;
import com.jetbrains.python.parsing.ParsingContext;
import com.jetbrains.python.psi.c;
import java.lang.invoke.MethodHandles;
import org.jetbrains.annotations.Nullable;

public class ExpressionParsing
extends Parsing {
    private static final Logger b;
    public static final WhitespacesAndCommentsBinder CONSUME_COMMENTS_AND_SPACES_TO_LEFT;
    private static final TokenSet d;
    private static final TokenSet c;
    private static final long f;

    public ExpressionParsing(ParsingContext context) {
        super(context);
    }

    public boolean parsePrimaryExpression(boolean isTargetExpression) {
        IElementType iElementType = this.myBuilder.getTokenType();
        if (ExpressionParsing.isIdentifier(this.myBuilder)) {
            if (isTargetExpression) {
                ExpressionParsing.buildTokenElement(PyStubElementTypes.TARGET_EXPRESSION, this.myBuilder);
            } else {
                ExpressionParsing.buildTokenElement(this.getReferenceType(), this.myBuilder);
            }
            return true;
        }
        if (iElementType == PyTokenTypes.INTEGER_LITERAL) {
            ExpressionParsing.buildTokenElement(PyElementTypes.INTEGER_LITERAL_EXPRESSION, this.myBuilder);
            return true;
        }
        if (iElementType == PyTokenTypes.FLOAT_LITERAL) {
            ExpressionParsing.buildTokenElement(PyElementTypes.FLOAT_LITERAL_EXPRESSION, this.myBuilder);
            return true;
        }
        if (iElementType == PyTokenTypes.IMAGINARY_LITERAL) {
            ExpressionParsing.buildTokenElement(PyElementTypes.IMAGINARY_LITERAL_EXPRESSION, this.myBuilder);
            return true;
        }
        if (iElementType == PyTokenTypes.NONE_KEYWORD) {
            ExpressionParsing.buildTokenElement(PyElementTypes.NONE_LITERAL_EXPRESSION, this.myBuilder);
            return true;
        }
        if (iElementType == PyTokenTypes.TRUE_KEYWORD || iElementType == PyTokenTypes.FALSE_KEYWORD || iElementType == PyTokenTypes.DEBUG_KEYWORD) {
            ExpressionParsing.buildTokenElement(PyElementTypes.BOOL_LITERAL_EXPRESSION, this.myBuilder);
            return true;
        }
        if (PyTokenTypes.STRING_NODES.contains(iElementType) || iElementType == PyTokenTypes.FSTRING_START) {
            return this.parseStringLiteralExpression();
        }
        if (iElementType == PyTokenTypes.LPAR) {
            this.h(isTargetExpression);
            return true;
        }
        if (iElementType == PyTokenTypes.LBRACKET) {
            this.b(this.myBuilder, isTargetExpression);
            return true;
        }
        if (iElementType == PyTokenTypes.LBRACE) {
            this.c();
            return true;
        }
        if (iElementType == PyTokenTypes.TICK) {
            this.a(this.myBuilder);
            return true;
        }
        return this.f();
    }

    public boolean parseStringLiteralExpression() {
        PsiBuilder psiBuilder = this.myContext.getBuilder();
        IElementType iElementType = psiBuilder.getTokenType();
        if (PyTokenTypes.STRING_NODES.contains(iElementType) || iElementType == PyTokenTypes.FSTRING_START) {
            PsiBuilder.Marker marker = psiBuilder.mark();
            while (true) {
                if (PyTokenTypes.STRING_NODES.contains(iElementType = psiBuilder.getTokenType())) {
                    this.nextToken();
                    continue;
                }
                if (iElementType != PyTokenTypes.FSTRING_START) break;
                this.a();
            }
            marker.done((IElementType)PyElementTypes.STRING_LITERAL_EXPRESSION);
            return true;
        }
        return false;
    }

    private void a() {
        long l2 = f ^ 0x6A93464651C3L;
        PsiBuilder psiBuilder = this.myContext.getBuilder();
        if (this.atToken(PyTokenTypes.FSTRING_START)) {
            String string = psiBuilder.getTokenText();
            assert (string != null);
            String string2 = string.replaceFirst("^[UuBbCcRrFf]*", "");
            PsiBuilder.Marker marker = psiBuilder.mark();
            this.nextToken();
            while (true) {
                if (this.atToken(PyTokenTypes.FSTRING_TEXT)) {
                    this.nextToken();
                    continue;
                }
                if (!this.atToken(PyTokenTypes.FSTRING_FRAGMENT_START)) break;
                this.d();
            }
            if (this.atToken(PyTokenTypes.FSTRING_END)) {
                if (psiBuilder.getTokenText().equals(string2)) {
                    this.nextToken();
                } else {
                    psiBuilder.mark().error(string2 + " expected");
                }
            } else if (this.atToken(PyTokenTypes.STATEMENT_BREAK)) {
                psiBuilder.mark().error(string2 + " expected");
            } else {
                psiBuilder.error("unexpected f-string token");
            }
            marker.done((IElementType)PyElementTypes.FSTRING_NODE);
        }
    }

    private void d() {
        long l2 = f ^ 0x2B662CC1EEEBL;
        PsiBuilder psiBuilder = this.myContext.getBuilder();
        if (this.atToken(PyTokenTypes.FSTRING_FRAGMENT_START)) {
            boolean bl2;
            PsiBuilder.Marker marker = psiBuilder.mark();
            this.nextToken();
            PsiBuilder.Marker marker2 = psiBuilder.mark();
            boolean bl3 = this.myContext.getExpressionParser().parseExpressionOptional();
            if (bl3) {
                marker2.drop();
                marker2 = psiBuilder.mark();
            }
            boolean bl4 = bl2 = !bl3;
            while (!psiBuilder.eof() && !this.atAnyOfTokens(PyTokenTypes.FSTRING_FRAGMENT_TYPE_CONVERSION, PyTokenTypes.FSTRING_FRAGMENT_FORMAT_START, PyTokenTypes.FSTRING_FRAGMENT_END, PyTokenTypes.FSTRING_END, PyTokenTypes.STATEMENT_BREAK, PyTokenTypes.EQ)) {
                this.nextToken();
                bl2 = true;
            }
            if (bl2) {
                marker2.error(bl3 ? "unexpected expression part" : "expression expected");
                marker2.setCustomEdgeTokenBinders(null, CONSUME_COMMENTS_AND_SPACES_TO_LEFT);
            } else {
                marker2.drop();
            }
            this.matchToken(PyTokenTypes.EQ);
            boolean bl5 = this.matchToken(PyTokenTypes.FSTRING_FRAGMENT_TYPE_CONVERSION);
            boolean bl6 = this.atToken(PyTokenTypes.FSTRING_FRAGMENT_FORMAT_START);
            if (bl6) {
                this.b();
            }
            String string = "} expected";
            if (!bl6 && !this.atToken(PyTokenTypes.FSTRING_END)) {
                string = ": or " + string;
                if (!bl5) {
                    string = "type conversion, " + string;
                }
            }
            this.checkMatches(PyTokenTypes.FSTRING_FRAGMENT_END, string);
            marker.setCustomEdgeTokenBinders(null, CONSUME_COMMENTS_AND_SPACES_TO_LEFT);
            marker.done((IElementType)PyElementTypes.FSTRING_FRAGMENT);
        }
    }

    private void b() {
        if (this.atToken(PyTokenTypes.FSTRING_FRAGMENT_FORMAT_START)) {
            PsiBuilder.Marker marker = this.myContext.getBuilder().mark();
            this.nextToken();
            while (true) {
                if (this.atToken(PyTokenTypes.FSTRING_TEXT)) {
                    this.nextToken();
                    continue;
                }
                if (!this.atToken(PyTokenTypes.FSTRING_FRAGMENT_START)) break;
                this.d();
            }
            marker.done((IElementType)PyElementTypes.FSTRING_FRAGMENT_FORMAT_PART);
        }
    }

    private void b(PsiBuilder psiBuilder, boolean bl2) {
        long l2 = f ^ 0x10AC7C3E11D7L;
        b.assertTrue(psiBuilder.getTokenType() == PyTokenTypes.LBRACKET);
        PsiBuilder.Marker marker = psiBuilder.mark();
        psiBuilder.advanceLexer();
        if (psiBuilder.getTokenType() == PyTokenTypes.RBRACKET) {
            psiBuilder.advanceLexer();
            marker.done((IElementType)PyElementTypes.LIST_LITERAL_EXPRESSION);
            return;
        }
        if (!this.parseSingleExpression(bl2)) {
            psiBuilder.error(PyBundle.message("PARSE.expected.expression", new Object[0]));
        }
        if (this.g()) {
            this.a(marker, PyTokenTypes.RBRACKET, PyElementTypes.LIST_COMP_EXPRESSION);
        } else {
            while (psiBuilder.getTokenType() != PyTokenTypes.RBRACKET) {
                if (!this.matchToken(PyTokenTypes.COMMA)) {
                    psiBuilder.error("expected ',' or ']'");
                }
                if (this.atToken(PyTokenTypes.RBRACKET)) break;
                if (this.parseSingleExpression(bl2)) continue;
                psiBuilder.error(PyBundle.message("PARSE.expected.expr.or.comma.or.bracket", new Object[0]));
                break;
            }
            this.checkMatches(PyTokenTypes.RBRACKET, PyBundle.message("PARSE.expected.rbracket", new Object[0]));
            marker.done((IElementType)PyElementTypes.LIST_LITERAL_EXPRESSION);
        }
    }

    private void a(PsiBuilder.Marker marker, @Nullable IElementType iElementType, IElementType iElementType2) {
        long l2 = f ^ 0x7FE04A6FA30BL;
        this.assertCurrentToken(PyTokenTypes.FOR_KEYWORD);
        do {
            this.myBuilder.advanceLexer();
            this.parseExpression(true, true);
            this.parseComprehensionRange(iElementType2 == PyElementTypes.GENERATOR_EXPRESSION);
            while (this.myBuilder.getTokenType() == PyTokenTypes.IF_KEYWORD) {
                this.myBuilder.advanceLexer();
                if (this.parseOldExpression()) continue;
                this.myBuilder.error(PyBundle.message("PARSE.expected.expression", new Object[0]));
            }
        } while (this.g());
        if (iElementType != null && !this.matchToken(iElementType)) {
            this.myBuilder.error(PyBundle.message("PARSE.expected.for.or.bracket", new Object[0]));
        }
        marker.done(iElementType2);
    }

    protected void parseComprehensionRange(boolean generatorExpression) {
        long l2 = f ^ 0x2AA3B6EDD77EL;
        this.checkMatches(PyTokenTypes.IN_KEYWORD, "'in' expected");
        boolean bl2 = generatorExpression ? this.parseORTestExpression(false, false) : this.parseTupleExpression(false, false, true);
        if (!bl2) {
            this.myBuilder.error("expression expected");
        }
    }

    private void c() {
        long l2 = f ^ 0x97586ED7BC6L;
        b.assertTrue(this.myBuilder.getTokenType() == PyTokenTypes.LBRACE);
        PsiBuilder.Marker marker = this.myBuilder.mark();
        this.myBuilder.advanceLexer();
        if (this.matchToken(PyTokenTypes.RBRACE)) {
            marker.done((IElementType)PyElementTypes.DICT_LITERAL_EXPRESSION);
            return;
        }
        if (this.atToken(PyTokenTypes.EXP)) {
            if (!this.g(false)) {
                this.myBuilder.error("expression expected");
                marker.done((IElementType)PyElementTypes.DICT_LITERAL_EXPRESSION);
                return;
            }
            this.a(marker);
            return;
        }
        PsiBuilder.Marker marker2 = this.myBuilder.mark();
        if (!this.parseSingleExpression(false)) {
            this.myBuilder.error("expression expected");
            marker2.drop();
            marker.done((IElementType)PyElementTypes.DICT_LITERAL_EXPRESSION);
            return;
        }
        if (this.matchToken(PyTokenTypes.COLON)) {
            this.a(marker, marker2);
        } else if (this.atToken(PyTokenTypes.COMMA) || this.atToken(PyTokenTypes.RBRACE)) {
            marker2.drop();
            this.b(marker);
        } else if (this.g()) {
            marker2.drop();
            this.a(marker, PyTokenTypes.RBRACE, PyElementTypes.SET_COMP_EXPRESSION);
        } else {
            this.myBuilder.error("expression expected");
            marker2.drop();
            marker.done((IElementType)PyElementTypes.DICT_LITERAL_EXPRESSION);
        }
    }

    private void a(PsiBuilder.Marker marker, PsiBuilder.Marker marker2) {
        long l2 = f ^ 0x6A3FDD0912AAL;
        if (!this.parseSingleExpression(false)) {
            this.myBuilder.error("expression expected");
            marker2.done((IElementType)PyElementTypes.KEY_VALUE_EXPRESSION);
            if (this.atToken(PyTokenTypes.RBRACE)) {
                this.myBuilder.advanceLexer();
            }
            marker.done((IElementType)PyElementTypes.DICT_LITERAL_EXPRESSION);
            return;
        }
        marker2.done((IElementType)PyElementTypes.KEY_VALUE_EXPRESSION);
        if (this.g()) {
            this.a(marker, PyTokenTypes.RBRACE, PyElementTypes.DICT_COMP_EXPRESSION);
        } else {
            this.a(marker);
        }
    }

    private void a(PsiBuilder.Marker marker) {
        long l2 = f ^ 0x1B7750B55D10L;
        while (this.myBuilder.getTokenType() != PyTokenTypes.RBRACE) {
            this.checkMatches(PyTokenTypes.COMMA, PyBundle.message("PARSE.expected.comma", new Object[0]));
            if (!(this.atToken(PyTokenTypes.EXP) ? !this.g(false) : !this.h())) continue;
        }
        this.checkMatches(PyTokenTypes.RBRACE, PyBundle.message("PARSE.expected.rbrace", new Object[0]));
        marker.done((IElementType)PyElementTypes.DICT_LITERAL_EXPRESSION);
    }

    private boolean h() {
        long l2 = f ^ 0x5FE98C4F566CL;
        PsiBuilder.Marker marker = this.myBuilder.mark();
        if (!this.parseSingleExpression(false)) {
            marker.drop();
            return false;
        }
        this.checkMatches(PyTokenTypes.COLON, PyBundle.message("PARSE.expected.colon", new Object[0]));
        if (!this.parseSingleExpression(false)) {
            this.myBuilder.error("value expression expected");
            marker.drop();
            return false;
        }
        marker.done((IElementType)PyElementTypes.KEY_VALUE_EXPRESSION);
        return true;
    }

    private void b(PsiBuilder.Marker marker) {
        long l2 = f ^ 0x74DB338BF1F1L;
        while (this.myBuilder.getTokenType() != PyTokenTypes.RBRACE) {
            this.checkMatches(PyTokenTypes.COMMA, PyBundle.message("PARSE.expected.comma", new Object[0]));
            if (this.parseSingleExpression(false)) continue;
        }
        this.checkMatches(PyTokenTypes.RBRACE, PyBundle.message("PARSE.expected.rbrace", new Object[0]));
        marker.done((IElementType)PyElementTypes.SET_LITERAL_EXPRESSION);
    }

    private void h(boolean bl2) {
        long l2 = f ^ 0x5E62971FA952L;
        b.assertTrue(this.myBuilder.getTokenType() == PyTokenTypes.LPAR);
        PsiBuilder.Marker marker = this.myBuilder.mark();
        this.myBuilder.advanceLexer();
        if (this.myBuilder.getTokenType() == PyTokenTypes.RPAR) {
            this.myBuilder.advanceLexer();
            marker.done((IElementType)PyElementTypes.TUPLE_EXPRESSION);
        } else {
            this.parseYieldOrTupleExpression(bl2);
            if (this.g()) {
                this.a(marker, PyTokenTypes.RPAR, PyElementTypes.GENERATOR_EXPRESSION);
            } else {
                PsiBuilder.Marker marker2 = this.myBuilder.mark();
                boolean bl3 = true;
                while (!this.myBuilder.eof() && this.myBuilder.getTokenType() != PyTokenTypes.RPAR && this.myBuilder.getTokenType() != PyTokenTypes.LINE_BREAK && this.myBuilder.getTokenType() != PyTokenTypes.STATEMENT_BREAK && this.myBuilder.getTokenType() != PyTokenTypes.FSTRING_END) {
                    this.myBuilder.advanceLexer();
                    bl3 = false;
                }
                if (!bl3) {
                    marker2.error("Unexpected expression syntax");
                } else {
                    marker2.drop();
                }
                this.checkMatches(PyTokenTypes.RPAR, PyBundle.message("PARSE.expected.rpar", new Object[0]));
                marker.done((IElementType)PyElementTypes.PARENTHESIZED_EXPRESSION);
            }
        }
    }

    private void a(PsiBuilder psiBuilder) {
        long l2 = f ^ 0x10E0188C203L;
        b.assertTrue(psiBuilder.getTokenType() == PyTokenTypes.TICK);
        PsiBuilder.Marker marker = psiBuilder.mark();
        psiBuilder.advanceLexer();
        this.parseExpression();
        this.checkMatches(PyTokenTypes.TICK, PyBundle.message("PARSE.expected.tick", new Object[0]));
        marker.done((IElementType)PyElementTypes.REPR_EXPRESSION);
    }

    public boolean parseMemberExpression(boolean isTargetExpression) {
        long l2 = f ^ 0x2F2F4A563F6BL;
        boolean bl2 = false;
        boolean bl3 = false;
        block0: do {
            boolean bl4 = isTargetExpression && !bl2;
            PsiBuilder.Marker marker = this.myBuilder.mark();
            if (!this.parsePrimaryExpression(bl4)) {
                marker.drop();
                return false;
            }
            while (true) {
                IElementType iElementType;
                if ((iElementType = this.myBuilder.getTokenType()) == PyTokenTypes.DOT) {
                    if (bl4) {
                        bl2 = true;
                        marker.rollbackTo();
                        continue block0;
                    }
                    this.myBuilder.advanceLexer();
                    this.checkMatches(PyTokenTypes.IDENTIFIER, PyBundle.message("PARSE.expected.name", new Object[0]));
                    if (isTargetExpression && !bl3 && !this.atAnyOfTokens(PyTokenTypes.DOT, PyTokenTypes.LPAR, PyTokenTypes.LBRACKET)) {
                        marker.done(PyStubElementTypes.TARGET_EXPRESSION);
                    } else {
                        marker.done(this.getReferenceType());
                    }
                    marker = marker.precede();
                } else if (iElementType == PyTokenTypes.LPAR) {
                    this.parseArgumentList();
                    marker.done((IElementType)PyElementTypes.CALL_EXPRESSION);
                    marker = marker.precede();
                } else if (iElementType == PyTokenTypes.LBRACKET) {
                    this.myBuilder.advanceLexer();
                    PsiBuilder.Marker marker2 = this.myBuilder.mark();
                    PsiBuilder.Marker marker3 = this.myBuilder.mark();
                    if (this.atToken(PyTokenTypes.COLON)) {
                        marker2.drop();
                        PsiBuilder.Marker marker4 = this.myBuilder.mark();
                        marker4.done((IElementType)PyElementTypes.EMPTY_EXPRESSION);
                        this.parseSliceEnd(marker, marker3);
                    } else {
                        boolean bl5 = this.parseSingleExpression(false);
                        if (this.atToken(PyTokenTypes.COLON)) {
                            marker2.drop();
                            this.parseSliceEnd(marker, marker3);
                        } else if (this.atToken(PyTokenTypes.COMMA)) {
                            marker3.done((IElementType)PyElementTypes.SLICE_ITEM);
                            if (!this.b(marker, marker2)) {
                                marker2.rollbackTo();
                                if (!this.parseTupleExpression(false, false, false)) {
                                    this.myBuilder.error("tuple expression expected");
                                }
                                this.checkMatches(PyTokenTypes.RBRACKET, PyBundle.message("PARSE.expected.rbracket", new Object[0]));
                                marker.done((IElementType)PyElementTypes.SUBSCRIPTION_EXPRESSION);
                            }
                        } else {
                            if (!bl5) {
                                this.myBuilder.error("expression expected");
                            }
                            marker2.drop();
                            marker3.drop();
                            this.checkMatches(PyTokenTypes.RBRACKET, PyBundle.message("PARSE.expected.rbracket", new Object[0]));
                            marker.done((IElementType)PyElementTypes.SUBSCRIPTION_EXPRESSION);
                        }
                    }
                    if (isTargetExpression && !bl3) {
                        bl2 = true;
                        bl3 = true;
                        marker.rollbackTo();
                        continue block0;
                    }
                    marker = marker.precede();
                } else {
                    marker.drop();
                    continue block0;
                }
                bl2 = false;
            }
        } while (bl2);
        return true;
    }

    private boolean f() {
        if (this.atToken(PyTokenTypes.DOT)) {
            PsiBuilder.Marker marker = this.myBuilder.mark();
            this.myBuilder.advanceLexer();
            if (this.matchToken(PyTokenTypes.DOT) && this.matchToken(PyTokenTypes.DOT)) {
                marker.done((IElementType)PyElementTypes.NONE_LITERAL_EXPRESSION);
                return true;
            }
            marker.rollbackTo();
        }
        return false;
    }

    public void parseSliceEnd(PsiBuilder.Marker exprStart, PsiBuilder.Marker sliceItemStart) {
        long l2 = f ^ 0x19950E77B318L;
        this.myBuilder.advanceLexer();
        if (this.atToken(PyTokenTypes.RBRACKET)) {
            PsiBuilder.Marker marker = this.myBuilder.mark();
            marker.done((IElementType)PyElementTypes.EMPTY_EXPRESSION);
            sliceItemStart.done((IElementType)PyElementTypes.SLICE_ITEM);
            this.nextToken();
            exprStart.done((IElementType)PyElementTypes.SLICE_EXPRESSION);
            return;
        }
        if (this.atToken(PyTokenTypes.COLON)) {
            PsiBuilder.Marker marker = this.myBuilder.mark();
            marker.done((IElementType)PyElementTypes.EMPTY_EXPRESSION);
        } else {
            this.parseSingleExpression(false);
        }
        if (!c.contains(this.myBuilder.getTokenType())) {
            this.myBuilder.error(PyBundle.message("PARSE.expected.colon.or.rbracket", new Object[0]));
        }
        if (this.matchToken(PyTokenTypes.COLON)) {
            this.parseSingleExpression(false);
        }
        sliceItemStart.done((IElementType)PyElementTypes.SLICE_ITEM);
        if (!d.contains(this.myBuilder.getTokenType())) {
            this.myBuilder.error("']' or ',' expected");
        }
        this.b(exprStart, null);
    }

    private boolean b(PsiBuilder.Marker marker, @Nullable PsiBuilder.Marker marker2) {
        boolean bl2;
        long l2 = f ^ 0x77FDD7E38758L;
        boolean bl3 = bl2 = marker2 == null;
        while (this.atToken(PyTokenTypes.COMMA)) {
            this.nextToken();
            PsiBuilder.Marker marker3 = this.myBuilder.mark();
            this.e(false, false);
            if (this.matchToken(PyTokenTypes.COLON)) {
                bl2 = true;
                this.e(false, false);
                if (this.matchToken(PyTokenTypes.COLON)) {
                    this.e(false, false);
                }
            }
            marker3.done((IElementType)PyElementTypes.SLICE_ITEM);
            if (d.contains(this.myBuilder.getTokenType())) continue;
            this.myBuilder.error("']' or ',' expected");
            break;
        }
        this.checkMatches(PyTokenTypes.RBRACKET, PyBundle.message("PARSE.expected.rbracket", new Object[0]));
        if (bl2) {
            if (marker2 != null) {
                marker2.drop();
            }
            marker.done((IElementType)PyElementTypes.SLICE_EXPRESSION);
        }
        return bl2;
    }

    public void parseArgumentList() {
        long l2 = f ^ 0x56E1B0CA93CCL;
        b.assertTrue(this.myBuilder.getTokenType() == PyTokenTypes.LPAR);
        PsiBuilder.Marker marker = this.myBuilder.mark();
        this.myBuilder.advanceLexer();
        PsiBuilder.Marker marker2 = this.myBuilder.mark();
        int n2 = 0;
        while (this.myBuilder.getTokenType() != PyTokenTypes.RPAR) {
            PsiBuilder.Marker marker3;
            if (++n2 > 1) {
                if (n2 == 2 && this.g() && marker2 != null) {
                    this.a(marker2, null, PyElementTypes.GENERATOR_EXPRESSION);
                    marker2 = null;
                    continue;
                }
                if (this.matchToken(PyTokenTypes.COMMA)) {
                    if (this.atToken(PyTokenTypes.RPAR)) {
                        break;
                    }
                } else {
                    this.myBuilder.error(PyBundle.message("PARSE.expected.comma.or.rpar", new Object[0]));
                    break;
                }
            }
            if (this.myBuilder.getTokenType() == PyTokenTypes.MULT || this.myBuilder.getTokenType() == PyTokenTypes.EXP) {
                marker3 = this.myBuilder.mark();
                this.myBuilder.advanceLexer();
                if (!this.parseSingleExpression(false)) {
                    this.myBuilder.error(PyBundle.message("PARSE.expected.expression", new Object[0]));
                }
                marker3.done((IElementType)PyElementTypes.STAR_ARGUMENT_EXPRESSION);
                continue;
            }
            if (ExpressionParsing.isIdentifier(this.myBuilder)) {
                marker3 = this.myBuilder.mark();
                ExpressionParsing.advanceIdentifierLike(this.myBuilder);
                if (this.myBuilder.getTokenType() == PyTokenTypes.EQ) {
                    this.myBuilder.advanceLexer();
                    if (!this.parseSingleExpression(false)) {
                        this.myBuilder.error(PyBundle.message("PARSE.expected.expression", new Object[0]));
                    }
                    marker3.done((IElementType)PyElementTypes.KEYWORD_ARGUMENT_EXPRESSION);
                    continue;
                }
                marker3.rollbackTo();
            }
            if (this.parseSingleExpression(false)) continue;
            this.myBuilder.error(PyBundle.message("PARSE.expected.expression", new Object[0]));
            break;
        }
        if (marker2 != null) {
            marker2.drop();
        }
        this.checkMatches(PyTokenTypes.RPAR, PyBundle.message("PARSE.expected.rpar", new Object[0]));
        marker.done((IElementType)PyElementTypes.ARGUMENT_LIST);
    }

    public boolean parseExpressionOptional() {
        return this.parseTupleExpression(false, false, false);
    }

    public boolean parseExpressionOptional(boolean isTargetExpression) {
        return this.parseTupleExpression(false, isTargetExpression, false);
    }

    public void parseExpression() {
        long l2 = f ^ 0x59154E05F8FEL;
        if (!this.parseExpressionOptional()) {
            this.myBuilder.error(PyBundle.message("PARSE.expected.expression", new Object[0]));
        }
    }

    public void parseExpression(boolean stopOnIn, boolean isTargetExpression) {
        long l2 = f ^ 0x7075B3CF120AL;
        if (!this.parseTupleExpression(stopOnIn, isTargetExpression, false)) {
            this.myBuilder.error(PyBundle.message("PARSE.expected.expression", new Object[0]));
        }
    }

    public boolean parseYieldOrTupleExpression(boolean isTargetExpression) {
        long l2 = f ^ 0x225C5DDE1D1BL;
        if (this.myBuilder.getTokenType() == PyTokenTypes.YIELD_KEYWORD) {
            PsiBuilder.Marker marker = this.myBuilder.mark();
            this.myBuilder.advanceLexer();
            if (this.myBuilder.getTokenType() == PyTokenTypes.FROM_KEYWORD) {
                this.myBuilder.advanceLexer();
                boolean bl2 = this.parseTupleExpression(false, isTargetExpression, false);
                if (!bl2) {
                    this.myBuilder.error(PyBundle.message("PARSE.expected.expression", new Object[0]));
                }
                marker.done((IElementType)PyElementTypes.YIELD_EXPRESSION);
                return bl2;
            }
            this.parseTupleExpression(false, isTargetExpression, false);
            marker.done((IElementType)PyElementTypes.YIELD_EXPRESSION);
            return true;
        }
        return this.parseTupleExpression(false, isTargetExpression, false);
    }

    protected boolean parseTupleExpression(boolean stopOnIn, boolean isTargetExpression, boolean oldTest) {
        boolean bl2;
        PsiBuilder.Marker marker = this.myBuilder.mark();
        boolean bl3 = bl2 = oldTest ? this.e() : this.e(stopOnIn, isTargetExpression);
        if (!bl2) {
            marker.drop();
            return false;
        }
        if (this.myBuilder.getTokenType() == PyTokenTypes.COMMA) {
            while (this.myBuilder.getTokenType() == PyTokenTypes.COMMA) {
                this.myBuilder.advanceLexer();
                PsiBuilder.Marker marker2 = this.myBuilder.mark();
                boolean bl4 = bl2 = oldTest ? this.e() : this.e(stopOnIn, isTargetExpression);
                if (!bl2) {
                    marker2.rollbackTo();
                    break;
                }
                marker2.drop();
            }
            marker.done((IElementType)PyElementTypes.TUPLE_EXPRESSION);
        } else {
            marker.drop();
        }
        return true;
    }

    public boolean parseSingleExpression(boolean isTargetExpression) {
        return this.e(false, isTargetExpression);
    }

    public boolean parseOldExpression() {
        if (this.myBuilder.getTokenType() == PyTokenTypes.LAMBDA_KEYWORD) {
            return this.c(false);
        }
        return this.parseORTestExpression(false, false);
    }

    private boolean e(boolean bl2, boolean bl3) {
        long l2 = f ^ 0x2F7F014F02D4L;
        PsiBuilder.Marker marker = this.myBuilder.mark();
        if (ExpressionParsing.isIdentifier(this.myBuilder) && this.myBuilder.lookAhead(1) == PyTokenTypes.COLONEQ) {
            ExpressionParsing.buildTokenElement(PyStubElementTypes.TARGET_EXPRESSION, this.myBuilder);
            this.myBuilder.advanceLexer();
            if (this.a(bl2, bl3)) {
                marker.done((IElementType)PyElementTypes.ASSIGNMENT_EXPRESSION);
                return true;
            }
            marker.drop();
            this.myBuilder.error(PyBundle.message("PARSE.expected.expression", new Object[0]));
            return false;
        }
        if (this.a(bl2, bl3)) {
            if (!this.atToken(PyTokenTypes.COLONEQ)) {
                marker.drop();
                return true;
            }
            marker.error(PyBundle.message("PARSE.expected.identifier", new Object[0]));
            return false;
        }
        marker.drop();
        return false;
    }

    private boolean a(boolean bl2, boolean bl3) {
        long l2 = f ^ 0x77704C01F066L;
        if (this.myBuilder.getTokenType() == PyTokenTypes.LAMBDA_KEYWORD) {
            return this.c(false);
        }
        PsiBuilder.Marker marker = this.myBuilder.mark();
        if (!this.parseORTestExpression(bl2, bl3)) {
            marker.drop();
            return false;
        }
        if (this.myBuilder.getTokenType() == PyTokenTypes.IF_KEYWORD) {
            PsiBuilder.Marker marker2 = this.myBuilder.mark();
            this.myBuilder.advanceLexer();
            if (!this.parseORTestExpression(bl2, bl3)) {
                this.myBuilder.error(PyBundle.message("PARSE.expected.expression", new Object[0]));
            } else if (this.myBuilder.getTokenType() != PyTokenTypes.ELSE_KEYWORD) {
                if (this.atToken(PyTokenTypes.COLON)) {
                    marker2.rollbackTo();
                    marker.drop();
                    return true;
                }
                this.myBuilder.error(PyBundle.message("PARSE.expected.else", new Object[0]));
            } else {
                this.myBuilder.advanceLexer();
                if (!this.e(bl2, bl3)) {
                    this.myBuilder.error(PyBundle.message("PARSE.expected.expression", new Object[0]));
                }
            }
            marker2.drop();
            marker.done((IElementType)PyElementTypes.CONDITIONAL_EXPRESSION);
        } else {
            marker.drop();
        }
        return true;
    }

    private boolean e() {
        if (this.myBuilder.getTokenType() == PyTokenTypes.LAMBDA_KEYWORD) {
            return this.c(true);
        }
        return this.parseORTestExpression(false, false);
    }

    private boolean c(boolean bl2) {
        boolean bl3;
        long l2 = f ^ 0x3073AFD83A07L;
        PsiBuilder.Marker marker = this.myBuilder.mark();
        this.myBuilder.advanceLexer();
        this.getFunctionParser().parseParameterListContents(PyTokenTypes.COLON, false, true);
        boolean bl4 = bl3 = bl2 ? this.e() : this.parseSingleExpression(false);
        if (!bl3) {
            this.myBuilder.error(PyBundle.message("PARSE.expected.expression", new Object[0]));
        }
        marker.done((IElementType)PyElementTypes.LAMBDA_EXPRESSION);
        return true;
    }

    protected boolean parseORTestExpression(boolean stopOnIn, boolean isTargetExpression) {
        long l2 = f ^ 0x353C71648C46L;
        PsiBuilder.Marker marker = this.myBuilder.mark();
        if (!this.c(stopOnIn, isTargetExpression)) {
            marker.drop();
            return false;
        }
        while (this.myBuilder.getTokenType() == PyTokenTypes.OR_KEYWORD) {
            this.myBuilder.advanceLexer();
            if (!this.c(stopOnIn, isTargetExpression)) {
                this.myBuilder.error(PyBundle.message("PARSE.expected.expression", new Object[0]));
            }
            marker.done((IElementType)PyElementTypes.BINARY_EXPRESSION);
            marker = marker.precede();
        }
        marker.drop();
        return true;
    }

    private boolean c(boolean bl2, boolean bl3) {
        long l2 = f ^ 0x39375FC039DCL;
        PsiBuilder.Marker marker = this.myBuilder.mark();
        if (!this.b(bl2, bl3)) {
            marker.drop();
            return false;
        }
        while (this.myBuilder.getTokenType() == PyTokenTypes.AND_KEYWORD) {
            this.myBuilder.advanceLexer();
            if (!this.b(bl2, bl3)) {
                this.myBuilder.error(PyBundle.message("PARSE.expected.expression", new Object[0]));
            }
            marker.done((IElementType)PyElementTypes.BINARY_EXPRESSION);
            marker = marker.precede();
        }
        marker.drop();
        return true;
    }

    private boolean b(boolean bl2, boolean bl3) {
        long l2 = f ^ 0x3B78D4153072L;
        if (this.myBuilder.getTokenType() == PyTokenTypes.NOT_KEYWORD) {
            PsiBuilder.Marker marker = this.myBuilder.mark();
            this.myBuilder.advanceLexer();
            if (!this.b(bl2, bl3)) {
                this.myBuilder.error(PyBundle.message("PARSE.expected.expression", new Object[0]));
            }
            marker.done((IElementType)PyElementTypes.PREFIX_EXPRESSION);
            return true;
        }
        return this.d(bl2, bl3);
    }

    private boolean d(boolean bl2, boolean bl3) {
        long l2 = f ^ 0x3F7094A3E8A4L;
        PsiBuilder.Marker marker = this.myBuilder.mark();
        if (!this.e(bl3)) {
            marker.drop();
            return false;
        }
        if (bl2 && this.atToken(PyTokenTypes.IN_KEYWORD)) {
            marker.drop();
            return true;
        }
        while (PyTokenTypes.COMPARISON_OPERATIONS.contains(this.myBuilder.getTokenType())) {
            if (this.atToken(PyTokenTypes.NOT_KEYWORD)) {
                PsiBuilder.Marker marker2 = this.myBuilder.mark();
                this.myBuilder.advanceLexer();
                if (!this.atToken(PyTokenTypes.IN_KEYWORD)) {
                    marker2.rollbackTo();
                    break;
                }
                marker2.drop();
                this.myBuilder.advanceLexer();
            } else if (this.atToken(PyTokenTypes.IS_KEYWORD)) {
                this.myBuilder.advanceLexer();
                if (this.myBuilder.getTokenType() == PyTokenTypes.NOT_KEYWORD) {
                    this.myBuilder.advanceLexer();
                }
            } else {
                this.myBuilder.advanceLexer();
            }
            if (!this.d(bl3)) {
                this.myBuilder.error(PyBundle.message("PARSE.expected.expression", new Object[0]));
            }
            marker.done((IElementType)PyElementTypes.BINARY_EXPRESSION);
            marker = marker.precede();
        }
        marker.drop();
        return true;
    }

    private boolean e(boolean bl2) {
        long l2 = f ^ 0x25EE226F0CE7L;
        if (this.atToken(PyTokenTypes.MULT)) {
            PsiBuilder.Marker marker = this.myBuilder.mark();
            this.nextToken();
            if (!this.d(bl2)) {
                this.myBuilder.error(PyBundle.message("PARSE.expected.expression", new Object[0]));
                marker.drop();
                return false;
            }
            marker.done((IElementType)PyElementTypes.STAR_EXPRESSION);
            return true;
        }
        return this.d(bl2);
    }

    private boolean g(boolean bl2) {
        long l2 = f ^ 0x5666B3A3C57EL;
        if (this.atToken(PyTokenTypes.EXP)) {
            PsiBuilder.Marker marker = this.myBuilder.mark();
            this.nextToken();
            if (!this.d(bl2)) {
                this.myBuilder.error(PyBundle.message("PARSE.expected.expression", new Object[0]));
                marker.drop();
                return false;
            }
            marker.done((IElementType)PyElementTypes.DOUBLE_STAR_EXPRESSION);
            return true;
        }
        return this.d(bl2);
    }

    private boolean d(boolean bl2) {
        long l2 = f ^ 0x7D4C5D093E10L;
        PsiBuilder.Marker marker = this.myBuilder.mark();
        if (!this.f(bl2)) {
            marker.drop();
            return false;
        }
        while (this.atToken(PyTokenTypes.OR)) {
            this.myBuilder.advanceLexer();
            if (!this.f(bl2)) {
                this.myBuilder.error(PyBundle.message("PARSE.expected.expression", new Object[0]));
            }
            marker.done((IElementType)PyElementTypes.BINARY_EXPRESSION);
            marker = marker.precede();
        }
        marker.drop();
        return true;
    }

    private boolean f(boolean bl2) {
        long l2 = f ^ 0x795B4AAF54DFL;
        PsiBuilder.Marker marker = this.myBuilder.mark();
        if (!this.a(bl2)) {
            marker.drop();
            return false;
        }
        while (this.atToken(PyTokenTypes.XOR)) {
            this.myBuilder.advanceLexer();
            if (!this.a(bl2)) {
                this.myBuilder.error(PyBundle.message("PARSE.expected.expression", new Object[0]));
            }
            marker.done((IElementType)PyElementTypes.BINARY_EXPRESSION);
            marker = marker.precede();
        }
        marker.drop();
        return true;
    }

    private boolean a(boolean bl2) {
        long l2 = f ^ 0x25516780400AL;
        PsiBuilder.Marker marker = this.myBuilder.mark();
        if (!this.b(bl2)) {
            marker.drop();
            return false;
        }
        while (this.atToken(PyTokenTypes.AND)) {
            this.myBuilder.advanceLexer();
            if (!this.b(bl2)) {
                this.myBuilder.error(PyBundle.message("PARSE.expected.expression", new Object[0]));
            }
            marker.done((IElementType)PyElementTypes.BINARY_EXPRESSION);
            marker = marker.precede();
        }
        marker.drop();
        return true;
    }

    private boolean b(boolean bl2) {
        long l2 = f ^ 0x74721334BD4AL;
        PsiBuilder.Marker marker = this.myBuilder.mark();
        if (!this.a(this.myBuilder, bl2)) {
            marker.drop();
            return false;
        }
        while (PyTokenTypes.SHIFT_OPERATIONS.contains(this.myBuilder.getTokenType())) {
            this.myBuilder.advanceLexer();
            if (!this.a(this.myBuilder, bl2)) {
                this.myBuilder.error(PyBundle.message("PARSE.expected.expression", new Object[0]));
            }
            marker.done((IElementType)PyElementTypes.BINARY_EXPRESSION);
            marker = marker.precede();
        }
        marker.drop();
        return true;
    }

    private boolean a(PsiBuilder psiBuilder, boolean bl2) {
        long l2 = f ^ 0x65FFB938E0EFL;
        PsiBuilder.Marker marker = psiBuilder.mark();
        if (!this.k(bl2)) {
            marker.drop();
            return false;
        }
        while (PyTokenTypes.ADDITIVE_OPERATIONS.contains(psiBuilder.getTokenType())) {
            psiBuilder.advanceLexer();
            if (!this.k(bl2)) {
                psiBuilder.error(PyBundle.message("PARSE.expected.expression", new Object[0]));
            }
            marker.done((IElementType)PyElementTypes.BINARY_EXPRESSION);
            marker = marker.precede();
        }
        marker.drop();
        return true;
    }

    private boolean k(boolean bl2) {
        long l2 = f ^ 0x724D0590A922L;
        PsiBuilder.Marker marker = this.myBuilder.mark();
        if (!this.parseUnaryExpression(bl2)) {
            marker.drop();
            return false;
        }
        while (PyTokenTypes.MULTIPLICATIVE_OPERATIONS.contains(this.myBuilder.getTokenType())) {
            this.myBuilder.advanceLexer();
            if (!this.parseUnaryExpression(bl2)) {
                this.myBuilder.error(PyBundle.message("PARSE.expected.expression", new Object[0]));
            }
            marker.done((IElementType)PyElementTypes.BINARY_EXPRESSION);
            marker = marker.precede();
        }
        marker.drop();
        return true;
    }

    protected boolean parseUnaryExpression(boolean isTargetExpression) {
        long l2 = f ^ 0x374E1267B0ACL;
        IElementType iElementType = this.myBuilder.getTokenType();
        if (PyTokenTypes.UNARY_OPERATIONS.contains(iElementType)) {
            PsiBuilder.Marker marker = this.myBuilder.mark();
            this.myBuilder.advanceLexer();
            if (!this.parseUnaryExpression(isTargetExpression)) {
                this.myBuilder.error(PyBundle.message("PARSE.expected.expression", new Object[0]));
            }
            marker.done((IElementType)PyElementTypes.PREFIX_EXPRESSION);
            return true;
        }
        return this.j(isTargetExpression);
    }

    private boolean j(boolean bl2) {
        long l2 = f ^ 0x419A72FA8DF8L;
        PsiBuilder.Marker marker = this.myBuilder.mark();
        if (!this.i(bl2)) {
            marker.drop();
            return false;
        }
        if (this.myBuilder.getTokenType() == PyTokenTypes.EXP) {
            this.myBuilder.advanceLexer();
            if (!this.parseUnaryExpression(bl2)) {
                this.myBuilder.error(PyBundle.message("PARSE.expected.expression", new Object[0]));
            }
            marker.done((IElementType)PyElementTypes.BINARY_EXPRESSION);
        } else {
            marker.drop();
        }
        return true;
    }

    private boolean i(boolean bl2) {
        long l2 = f ^ 0x39BA8CBCD42AL;
        if (this.atToken(PyTokenTypes.AWAIT_KEYWORD)) {
            PsiBuilder.Marker marker = this.myBuilder.mark();
            this.myBuilder.advanceLexer();
            if (!this.parseMemberExpression(bl2)) {
                this.myBuilder.error(PyBundle.message("PARSE.expected.expression", new Object[0]));
                marker.done((IElementType)PyElementTypes.PREFIX_EXPRESSION);
            } else if (bl2) {
                marker.error("can't assign to await expression");
            } else {
                marker.done((IElementType)PyElementTypes.PREFIX_EXPRESSION);
            }
            return true;
        }
        return this.parseMemberExpression(bl2);
    }

    private boolean g() {
        long l2 = f ^ 0x625E83884687L;
        if (this.atToken(PyTokenTypes.FOR_KEYWORD)) {
            return true;
        }
        if (this.matchToken(PyTokenTypes.ASYNC_KEYWORD)) {
            if (this.atToken(PyTokenTypes.FOR_KEYWORD)) {
                return true;
            }
            this.myBuilder.error("'for' expected");
            return false;
        }
        return false;
    }

    static {
        f = com.jetbrains.python.psi.c.a(6474816003932079100L, -1360042550057578238L, MethodHandles.lookup().lookupClass()).a(5840091050434L);
        long l2 = f ^ 0x5B7EE261AE1CL;
        b = Logger.getInstance((String)"#ru.yole.pythonlanguage.parsing.ExpressionParsing");
        CONSUME_COMMENTS_AND_SPACES_TO_LEFT = (list2, bl2, tokenTextGetter) -> list2.size();
        d = TokenSet.create((IElementType[])new IElementType[]{PyTokenTypes.RBRACKET, PyTokenTypes.COMMA});
        c = TokenSet.create((IElementType[])new IElementType[]{PyTokenTypes.RBRACKET, PyTokenTypes.COLON, PyTokenTypes.COMMA});
    }
}

