/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.packaging.ui;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.intellij.execution.ExecutionException;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.ui.ToggleActionButton;
import com.intellij.webcore.packaging.InstalledPackage;
import com.intellij.webcore.packaging.InstalledPackagesPanel;
import com.intellij.webcore.packaging.PackageManagementService;
import com.intellij.webcore.packaging.PackagesNotificationPanel;
import com.jetbrains.python.packaging.PyCondaPackageManagerImpl;
import com.jetbrains.python.packaging.PyExecutionException;
import com.jetbrains.python.packaging.PyExecutionFix;
import com.jetbrains.python.packaging.PyPackage;
import com.jetbrains.python.packaging.PyPackageManager;
import com.jetbrains.python.packaging.PyPackageManagerUI;
import com.jetbrains.python.packaging.PyPackageManagers;
import com.jetbrains.python.packaging.PyPackageUtil;
import com.jetbrains.python.packaging.PyPackagingSettings;
import com.jetbrains.python.packaging.ui.PyPackageManagementService;
import com.jetbrains.python.psi.c;
import com.jetbrains.python.sdk.PySdkUtil;
import com.jetbrains.python.sdk.PythonSdkType;
import icons.PythonIcons;
import java.lang.invoke.MethodHandles;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyInstalledPackagesPanel
extends InstalledPackagesPanel {
    private volatile boolean a;
    private static final long b = c.a(-6722602199597523120L, -982848616758328398L, MethodHandles.lookup().lookupClass()).a(89302666898313L);

    public PyInstalledPackagesPanel(@NotNull Project project, @NotNull PackagesNotificationPanel area) {
        if (project == null) {
            PyInstalledPackagesPanel.a(0);
        }
        if (area == null) {
            PyInstalledPackagesPanel.a(1);
        }
        super(project, area);
        this.a = false;
    }

    private Sdk b() {
        PyPackageManagementService pyPackageManagementService = (PyPackageManagementService)this.myPackageManagementService;
        return pyPackageManagementService != null ? pyPackageManagementService.getSdk() : null;
    }

    public void updateNotifications(@Nullable Sdk selectedSdk) {
        if (selectedSdk == null) {
            this.myNotificationArea.hide();
            return;
        }
        Application application = ApplicationManager.getApplication();
        application.executeOnPooledThread(() -> {
            long l2 = b ^ 0x143F9F035A82L;
            PyExecutionException pyExecutionException = null;
            try {
                this.a = PyPackageManager.getInstance(selectedSdk).hasManagement();
                application.invokeLater(() -> this.updateUninstallUpgrade(), ModalityState.any());
                if (!this.a) {
                    throw new PyExecutionException("Python packaging tools not found", "pip", Collections.emptyList(), "", "", 0, (List<? extends PyExecutionFix>)ImmutableList.of((Object)new PyInstallPackageManagementFix()));
                }
            }
            catch (PyExecutionException pyExecutionException2) {
                pyExecutionException = pyExecutionException2;
            }
            catch (ExecutionException executionException) {
                return;
            }
            PyExecutionException pyExecutionException3 = pyExecutionException;
            application.invokeLater(() -> {
                long l2 = b ^ 0xDE27F35A390L;
                if (selectedSdk == this.b()) {
                    this.myNotificationArea.hide();
                    if (pyExecutionException3 != null) {
                        boolean bl2 = PythonSdkType.isInvalid(selectedSdk);
                        if (!bl2) {
                            StringBuilder stringBuilder = new StringBuilder(pyExecutionException3.getMessage());
                            stringBuilder.append(". ");
                            for (PyExecutionFix pyExecutionFix : pyExecutionException3.getFixes()) {
                                String string = "id" + pyExecutionFix.hashCode();
                                String string2 = "<a href=\"" + string + "\">" + pyExecutionFix.getName() + "</a>";
                                stringBuilder.append(string2);
                                stringBuilder.append(" ");
                                this.myNotificationArea.addLinkHandler(string, () -> {
                                    Sdk sdk = this.b();
                                    if (sdk != null) {
                                        pyExecutionFix.run(sdk);
                                        this.myNotificationArea.removeLinkHandler(string);
                                        this.updatePackages(PyPackageManagers.getInstance().getManagementService(this.myProject, sdk));
                                        this.updateNotifications(sdk);
                                    }
                                });
                            }
                            this.myNotificationArea.showWarning(stringBuilder.toString());
                        }
                        this.myInstallButton.setEnabled(!bl2 && this.installEnabled());
                    }
                }
            }, ModalityState.any());
        });
    }

    protected Set<String> getPackagesToPostpone() {
        long l2 = b ^ 0x536C1597E4DCL;
        return Sets.newHashSet((Object[])new String[]{"pip", "distutils", "setuptools"});
    }

    protected boolean canUninstallPackage(InstalledPackage pkg) {
        String string;
        long l2 = b ^ 0x615494F956E5L;
        if (!this.a) {
            return false;
        }
        Sdk sdk = this.b();
        if (sdk == null) {
            return false;
        }
        if (!PyPackageUtil.packageManagementEnabled(sdk)) {
            return false;
        }
        if (PythonSdkType.isVirtualEnv(sdk) && pkg instanceof PyPackage && (string = ((PyPackage)pkg).getLocation()) != null && string.startsWith(PySdkUtil.getUserSite())) {
            return false;
        }
        string = pkg.getName();
        return !"pip".equals(string) && !"setuptools".equals(string) && !"distribute".equals(string) && !"python".equals(string);
    }

    protected boolean canInstallPackage(@NotNull InstalledPackage pyPackage) {
        if (pyPackage == null) {
            PyInstalledPackagesPanel.a(2);
        }
        return this.installEnabled();
    }

    protected boolean installEnabled() {
        if (!PyPackageUtil.packageManagementEnabled(this.b())) {
            return false;
        }
        return this.a;
    }

    protected boolean canUpgradePackage(InstalledPackage pyPackage) {
        long l2 = b ^ 0x5D77AA88CB62L;
        if (!PyPackageUtil.packageManagementEnabled(this.b())) {
            return false;
        }
        return this.a && !"python".equals(pyPackage.getName());
    }

    @NotNull
    protected ToggleActionButton[] getExtraActions() {
        long l2 = b ^ 0x2E5D96435160L;
        DumbAwareToggleActionButton dumbAwareToggleActionButton = new DumbAwareToggleActionButton("Use Conda Package Manager", PythonIcons.Python.Anaconda){

            public boolean isSelected(AnActionEvent e10) {
                Sdk sdk = PyInstalledPackagesPanel.this.b();
                return sdk != null && PyPackageManager.getInstance(sdk) instanceof PyCondaPackageManagerImpl && ((PyCondaPackageManagerImpl)PyPackageManager.getInstance(sdk)).useConda();
            }

            public void setSelected(AnActionEvent e10, boolean state2) {
                Sdk sdk = PyInstalledPackagesPanel.this.b();
                if (sdk == null) {
                    return;
                }
                PyPackageManager pyPackageManager = PyPackageManager.getInstance(sdk);
                if (pyPackageManager instanceof PyCondaPackageManagerImpl) {
                    ((PyCondaPackageManagerImpl)pyPackageManager).useConda(state2);
                }
                PyInstalledPackagesPanel.this.updatePackages(PyInstalledPackagesPanel.this.myPackageManagementService);
            }

            public boolean isVisible() {
                Sdk sdk = PyInstalledPackagesPanel.this.b();
                return sdk != null && PythonSdkType.isConda(sdk);
            }
        };
        DumbAwareToggleActionButton dumbAwareToggleActionButton2 = new DumbAwareToggleActionButton("Show Early Releases", AllIcons.Actions.Show){

            public boolean isSelected(AnActionEvent e10) {
                return PyPackagingSettings.getInstance((Project)((PyInstalledPackagesPanel)PyInstalledPackagesPanel.this).myProject).earlyReleasesAsUpgrades;
            }

            public void setSelected(AnActionEvent e10, boolean state2) {
                PyPackagingSettings.getInstance((Project)((PyInstalledPackagesPanel)PyInstalledPackagesPanel.this).myProject).earlyReleasesAsUpgrades = state2;
                PyInstalledPackagesPanel.this.updatePackages(PyInstalledPackagesPanel.this.myPackageManagementService);
            }
        };
        ToggleActionButton[] toggleActionButtonArray = new ToggleActionButton[]{dumbAwareToggleActionButton, dumbAwareToggleActionButton2};
        if (toggleActionButtonArray == null) {
            PyInstalledPackagesPanel.a(3);
        }
        return toggleActionButtonArray;
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = b ^ 0x44C1392D245EL;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 3: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "area";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pyPackage";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/packaging/ui/PyInstalledPackagesPanel";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/packaging/ui/PyInstalledPackagesPanel";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtraActions";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "canInstallPackage";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static abstract class DumbAwareToggleActionButton
    extends ToggleActionButton
    implements DumbAware {
        private DumbAwareToggleActionButton(@Nls(capitalization=Nls.Capitalization.Title) String text2, Icon icon) {
            super(text2, icon);
        }
    }

    class PyInstallPackageManagementFix
    implements PyExecutionFix {
        private static final long a = c.a(-2619975603521756047L, -4255418641722822883L, MethodHandles.lookup().lookupClass()).a(152125329685049L);

        PyInstallPackageManagementFix() {
        }

        @Override
        @NotNull
        public String getName() {
            long l2 = a ^ 0xB35E0BACC75L;
            if ("Install packaging tools" == null) {
                PyInstallPackageManagementFix.a(0);
            }
            return "Install packaging tools";
        }

        @Override
        public void run(final @NotNull Sdk sdk) {
            if (sdk == null) {
                PyInstallPackageManagementFix.a(1);
            }
            PyPackageManagerUI pyPackageManagerUI = new PyPackageManagerUI(PyInstalledPackagesPanel.this.myProject, sdk, new PyPackageManagerUI.Listener(){
                private static final long a = c.a(-1287597463121825361L, -7472087539468743013L, MethodHandles.lookup().lookupClass()).a(59685702743023L);

                @Override
                public void started() {
                    PyInstalledPackagesPanel.this.myPackagesTable.setPaintBusy(true);
                }

                @Override
                public void finished(List<ExecutionException> exceptions) {
                    long l2 = a ^ 0x7B99CCC73D37L;
                    PyInstalledPackagesPanel.this.myPackagesTable.setPaintBusy(false);
                    PyPackageManager pyPackageManager = PyPackageManager.getInstance(sdk);
                    PackageManagementService.ErrorDescription errorDescription = PyPackageManagementService.toErrorDescription(exceptions, sdk);
                    if (errorDescription != null) {
                        PackagesNotificationPanel.showError((String)"Failed to install Python packaging tools", (PackageManagementService.ErrorDescription)errorDescription);
                    }
                    pyPackageManager.refresh();
                    PyInstalledPackagesPanel.this.updatePackages(PyPackageManagers.getInstance().getManagementService(PyInstalledPackagesPanel.this.myProject, sdk));
                    PyInstalledPackagesPanel.this.updateNotifications(sdk);
                }
            });
            pyPackageManagerUI.installManagement();
        }

        private static /* synthetic */ void a(int n2) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n3;
            String string;
            long l2 = a ^ 0x7A5489844FB4L;
            switch (n2) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n2) {
                default: {
                    n3 = 2;
                    break;
                }
                case 1: {
                    n3 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/packaging/ui/PyInstalledPackagesPanel$PyInstallPackageManagementFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sdk";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/packaging/ui/PyInstalledPackagesPanel$PyInstallPackageManagementFix";
                    break;
                }
            }
            switch (n2) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "run";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n2) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

