/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.packaging;

import com.google.common.collect.Lists;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.RunCanceledByUserException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessNotCreatedException;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.util.ExecUtil;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.projectRoots.impl.ProjectJdkImpl;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.net.HttpConfigurable;
import com.jetbrains.python.PythonHelpersLocator;
import com.jetbrains.python.packaging.PyExecutionException;
import com.jetbrains.python.packaging.PyPackage;
import com.jetbrains.python.packaging.PyPackageManager;
import com.jetbrains.python.packaging.PyPackageUtil;
import com.jetbrains.python.packaging.PyRequirement;
import com.jetbrains.python.packaging.PyRequirementParser;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.c;
import com.jetbrains.python.sdk.PyDetectedSdk;
import com.jetbrains.python.sdk.PyLazySdk;
import com.jetbrains.python.sdk.PySdkExtKt;
import com.jetbrains.python.sdk.PythonEnvUtil;
import com.jetbrains.python.sdk.PythonSdkType;
import com.jetbrains.python.sdk.flavors.PythonSdkFlavor;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyPackageManagerImpl
extends PyPackageManager {
    private static final String f = "40.8.0";
    private static final String i = "19.0.3";
    private static final String l = "16.4.3";
    private static final int a = 3;
    private static final Logger d;
    private static final String g = "packaging_tool.py";
    private static final int j = 600000;
    private static final String e = "--build-dir";
    private static final String k = "install";
    private static final String h = "uninstall";
    private static final String b = "untar";
    protected String mySeparator;
    @Nullable
    private volatile List<PyPackage> m;
    private final AtomicBoolean n;
    @NotNull
    private final Sdk c;
    private static final long r;

    @Override
    public void refresh() {
        long l2 = r ^ 0xD4D45A97FBDL;
        d.debug("Refreshing SDK roots and packages cache");
        Application application = ApplicationManager.getApplication();
        application.invokeLater(() -> {
            Sdk sdk = this.getSdk();
            application.runWriteAction(() -> {
                VirtualFile[] virtualFileArray = sdk.getRootProvider().getFiles(OrderRootType.CLASSES);
                VfsUtil.markDirtyAndRefresh((boolean)true, (boolean)true, (boolean)true, (VirtualFile[])virtualFileArray);
            });
            PythonSdkType.getInstance().setupSdkPaths(sdk);
        });
    }

    @Override
    public void installManagement() throws ExecutionException {
        long l2 = r ^ 0x491219EB72CAL;
        LanguageLevel languageLevel = PythonSdkType.getLanguageLevelForSdk(this.getSdk());
        if (languageLevel.isOlderThan(LanguageLevel.PYTHON27)) {
            throw new ExecutionException("Package management for Python " + (Object)((Object)languageLevel) + " is not supported. Upgrade your project interpreter to Python " + (Object)((Object)LanguageLevel.PYTHON27) + " or newer");
        }
        if (!this.c()) {
            this.installManagement("setuptools-40.8.0");
        }
        if (PyPackageUtil.findPackage(this.refreshAndGetPackages(false), "pip") == null) {
            this.installManagement("pip-19.0.3");
        }
    }

    @Override
    public boolean hasManagement() throws ExecutionException {
        long l2 = r ^ 0x45AC591521F6L;
        return this.c() && PyPackageUtil.findPackage(this.refreshAndGetPackages(false), "pip") != null;
    }

    private boolean c() throws ExecutionException {
        long l2 = r ^ 0x1B3B1E533E55L;
        try {
            List<PyPackage> list2 = this.refreshAndGetPackages(false);
            return PyPackageUtil.findPackage(list2, "setuptools") != null || PyPackageUtil.findPackage(list2, "distribute") != null;
        }
        catch (PyExecutionException pyExecutionException) {
            if (pyExecutionException.getExitCode() == 3) {
                return false;
            }
            throw pyExecutionException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void installManagement(@NotNull String name) throws ExecutionException {
        long l2 = r ^ 0x49CFB5373DA2L;
        if (name == null) {
            PyPackageManagerImpl.b(0);
        }
        String string = this.a(name + ".tar.gz");
        try {
            String string2 = string + name + this.mySeparator + "setup.py";
            this.a(string2, Collections.singletonList(k), true, true, string + name);
        }
        finally {
            FileUtil.delete((File)new File(string));
        }
    }

    @NotNull
    private String a(@NotNull String string) throws ExecutionException {
        long l2 = r ^ 0x200532A5EA59L;
        if (string == null) {
            PyPackageManagerImpl.b(1);
        }
        String string2 = this.getHelperPath(string);
        ArrayList arrayList = Lists.newArrayList((Object[])new String[]{b, string2});
        String string3 = this.b(g, arrayList, false, false, null);
        String string4 = this.toSystemDependentName(string3.trim());
        if (!string4.endsWith(this.mySeparator)) {
            string4 = string4 + this.mySeparator;
        }
        String string5 = string4;
        if (string5 == null) {
            PyPackageManagerImpl.b(2);
        }
        return string5;
    }

    @NotNull
    protected String toSystemDependentName(@NotNull String dirName) {
        if (dirName == null) {
            PyPackageManagerImpl.b(3);
        }
        String string = FileUtil.toSystemDependentName((String)dirName);
        if (string == null) {
            PyPackageManagerImpl.b(4);
        }
        return string;
    }

    protected PyPackageManagerImpl(@NotNull Sdk sdk) {
        if (sdk == null) {
            PyPackageManagerImpl.b(5);
        }
        this.mySeparator = File.separator;
        this.m = null;
        this.n = new AtomicBoolean(false);
        this.c = sdk;
        this.subscribeToLocalChanges();
    }

    protected void subscribeToLocalChanges() {
        PyPackageUtil.runOnChangeUnderInterpreterPaths(this.getSdk(), this::b);
    }

    @NotNull
    public Sdk getSdk() {
        Sdk sdk = this.c;
        if (sdk == null) {
            PyPackageManagerImpl.b(6);
        }
        return sdk;
    }

    @Override
    public void install(@NotNull String requirementString) throws ExecutionException {
        if (requirementString == null) {
            PyPackageManagerImpl.b(7);
        }
        this.install(Collections.singletonList(this.parseRequirement(requirementString)), Collections.emptyList());
    }

    @Override
    public void install(@Nullable List<PyRequirement> requirements, @NotNull List<String> extraArgs) throws ExecutionException {
        File file;
        long l2 = r ^ 0x74F47BE70467L;
        if (extraArgs == null) {
            PyPackageManagerImpl.b(8);
        }
        if (requirements == null) {
            return;
        }
        this.installManagement();
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(k);
        try {
            file = FileUtil.createTempDirectory((String)"pycharm-packaging", null);
        }
        catch (IOException iOException) {
            throw new ExecutionException("Cannot create temporary build directory");
        }
        if (!extraArgs.contains(e)) {
            arrayList.addAll(Arrays.asList(e, file.getAbsolutePath()));
        }
        boolean bl2 = extraArgs.contains("--user");
        String string = PyPackageManagerImpl.a();
        if (string != null) {
            arrayList.add("--proxy");
            arrayList.add(string);
        }
        arrayList.addAll(extraArgs);
        for (PyRequirement object : requirements) {
            arrayList.addAll(object.getInstallOptions());
        }
        try {
            this.b(g, arrayList, !bl2, true, null);
        }
        catch (PyExecutionException pyExecutionException) {
            ArrayList<String> arrayList2 = new ArrayList<String>();
            arrayList2.add(k);
            if (string != null) {
                arrayList2.add("--proxy");
                arrayList2.add(string);
            }
            arrayList2.addAll(extraArgs);
            for (PyRequirement pyRequirement : requirements) {
                arrayList2.addAll(pyRequirement.getInstallOptions());
            }
            throw new PyExecutionException(pyExecutionException.getMessage(), "pip", PyPackageManagerImpl.a(arrayList2), pyExecutionException.getStdout(), pyExecutionException.getStderr(), pyExecutionException.getExitCode(), pyExecutionException.getFixes());
        }
        finally {
            d.debug("Packages cache is about to be refreshed because these requirements were installed: " + requirements);
            this.b();
            FileUtil.delete((File)file);
        }
    }

    @Override
    public void uninstall(@NotNull List<PyPackage> packages) throws ExecutionException {
        long l2 = r ^ 0x1BDE16CFEFBEL;
        if (packages == null) {
            PyPackageManagerImpl.b(9);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            arrayList.add(h);
            boolean bl2 = true;
            for (PyPackage pyPackage : packages) {
                String string;
                if (bl2 && (string = pyPackage.getLocation()) != null) {
                    bl2 = Files.isWritable(Paths.get(string, new String[0]));
                }
                arrayList.add(pyPackage.getName());
            }
            this.b(g, arrayList, !bl2, true, null);
        }
        catch (PyExecutionException pyExecutionException) {
            throw new PyExecutionException(pyExecutionException.getMessage(), "pip", arrayList, pyExecutionException.getStdout(), pyExecutionException.getStderr(), pyExecutionException.getExitCode(), pyExecutionException.getFixes());
        }
        finally {
            d.debug("Packages cache is about to be refreshed because these packages were uninstalled: " + packages);
            this.b();
        }
    }

    @Override
    @Nullable
    public List<PyPackage> getPackages() {
        List<PyPackage> list2 = this.m;
        return list2 != null ? Collections.unmodifiableList(list2) : null;
    }

    @NotNull
    protected List<PyPackage> collectPackages() throws ExecutionException {
        String string;
        long l2 = r ^ 0x7388F2B34638L;
        if (this.c instanceof PyLazySdk) {
            List<PyPackage> list2 = Collections.emptyList();
            if (list2 == null) {
                PyPackageManagerImpl.b(10);
            }
            return list2;
        }
        try {
            d.debug("Collecting installed packages for the SDK " + this.c.getName(), new Throwable());
            string = this.b(g, Collections.singletonList("list"), false, false, null);
        }
        catch (ProcessNotCreatedException processNotCreatedException) {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                d.info("Not-env unit test mode, will return mock packages");
                ArrayList arrayList = Lists.newArrayList((Object[])new PyPackage[]{new PyPackage("pip", i, null, Collections.emptyList()), new PyPackage("setuptools", f, null, Collections.emptyList())});
                if (arrayList == null) {
                    PyPackageManagerImpl.b(11);
                }
                return arrayList;
            }
            throw processNotCreatedException;
        }
        List<PyPackage> list3 = this.c(string);
        if (list3 == null) {
            PyPackageManagerImpl.b(12);
        }
        return list3;
    }

    @Override
    @NotNull
    public Set<PyPackage> getDependents(@NotNull PyPackage pkg) throws ExecutionException {
        if (pkg == null) {
            PyPackageManagerImpl.b(13);
        }
        List<PyPackage> list2 = this.refreshAndGetPackages(false);
        HashSet<PyPackage> hashSet = new HashSet<PyPackage>();
        for (PyPackage pyPackage : list2) {
            List<PyRequirement> list3 = pyPackage.getRequirements();
            for (PyRequirement pyRequirement : list3) {
                if (!pyRequirement.getName().equals(pkg.getName())) continue;
                hashSet.add(pyPackage);
            }
        }
        HashSet<PyPackage> hashSet2 = hashSet;
        if (hashSet2 == null) {
            PyPackageManagerImpl.b(14);
        }
        return hashSet2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public String createVirtualEnv(@NotNull String destinationDir, boolean useGlobalSite) throws ExecutionException {
        VirtualFile virtualFile;
        String string;
        String string2;
        String string3;
        long l2 = r ^ 0x5A03288F32AFL;
        if (destinationDir == null) {
            PyPackageManagerImpl.b(15);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        Sdk sdk = this.getSdk();
        LanguageLevel languageLevel = PyPackageManagerImpl.a(sdk);
        if (languageLevel.isOlderThan(LanguageLevel.PYTHON27)) {
            throw new ExecutionException("Creating virtual environment for Python " + (Object)((Object)languageLevel) + " is not supported. Upgrade your project interpreter to Python " + (Object)((Object)LanguageLevel.PYTHON27) + " or newer");
        }
        boolean bl2 = languageLevel.isAtLeast(LanguageLevel.PYTHON33);
        if (bl2) {
            arrayList.add("pyvenv");
            if (useGlobalSite) {
                arrayList.add("--system-site-packages");
            }
            arrayList.add(destinationDir);
            this.b(g, arrayList, false, true, null);
        } else {
            if (useGlobalSite) {
                arrayList.add("--system-site-packages");
            }
            arrayList.add(destinationDir);
            string3 = "virtualenv-16.4.3";
            string2 = this.a("virtualenv-16.4.3.tar.gz");
            try {
                string = string2 + "virtualenv-16.4.3" + this.mySeparator + "virtualenv.py";
                this.a(string, arrayList, false, true, string2 + "virtualenv-16.4.3");
            }
            finally {
                FileUtil.delete((File)new File(string2));
            }
        }
        string3 = PythonSdkType.getPythonExecutable(destinationDir);
        string2 = destinationDir + this.mySeparator + "bin" + this.mySeparator + "python";
        String string4 = string = string3 != null ? string3 : string2;
        if (bl2 && (virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByPath(string)) != null) {
            ProjectJdkImpl projectJdkImpl = new ProjectJdkImpl("", (SdkTypeId)PythonSdkType.getInstance());
            projectJdkImpl.setHomePath(string);
            PyPackageManagerImpl pyPackageManagerImpl = new PyPackageManagerImpl((Sdk)projectJdkImpl);
            ((PyPackageManager)pyPackageManagerImpl).installManagement();
        }
        String string5 = string;
        if (string5 == null) {
            PyPackageManagerImpl.b(16);
        }
        return string5;
    }

    @NotNull
    private static LanguageLevel a(@NotNull Sdk sdk) throws ExecutionException {
        long l2 = r ^ 0x6782A71A4938L;
        if (sdk == null) {
            PyPackageManagerImpl.b(17);
        }
        if (sdk instanceof PyDetectedSdk) {
            PythonSdkFlavor pythonSdkFlavor = PythonSdkFlavor.getFlavor(sdk);
            if (pythonSdkFlavor != null && sdk.getHomePath() != null) {
                LanguageLevel languageLevel = pythonSdkFlavor.getLanguageLevel(sdk.getHomePath());
                if (languageLevel == null) {
                    PyPackageManagerImpl.b(18);
                }
                return languageLevel;
            }
            throw new ExecutionException("Cannot retrieve the version of the detected SDK: " + sdk.getHomePath());
        }
        LanguageLevel languageLevel = PythonSdkType.getLanguageLevelForSdk(sdk);
        if (languageLevel == null) {
            PyPackageManagerImpl.b(19);
        }
        return languageLevel;
    }

    @Override
    @Nullable
    public List<PyRequirement> getRequirements(@NotNull Module module2) {
        if (module2 == null) {
            PyPackageManagerImpl.b(20);
        }
        return Optional.ofNullable(PyPackageUtil.getRequirementsFromTxt(module2)).orElseGet(() -> PyPackageUtil.findSetupPyRequires(module2));
    }

    @Override
    @Nullable
    public PyRequirement parseRequirement(@NotNull String line2) {
        if (line2 == null) {
            PyPackageManagerImpl.b(21);
        }
        return PyRequirementParser.fromLine(line2);
    }

    @Override
    @NotNull
    public List<PyRequirement> parseRequirements(@NotNull String text2) {
        if (text2 == null) {
            PyPackageManagerImpl.b(22);
        }
        List<PyRequirement> list2 = PyRequirementParser.fromText(text2);
        if (list2 == null) {
            PyPackageManagerImpl.b(23);
        }
        return list2;
    }

    @Override
    @NotNull
    public List<PyRequirement> parseRequirements(@NotNull VirtualFile file) {
        if (file == null) {
            PyPackageManagerImpl.b(24);
        }
        List<PyRequirement> list2 = PyRequirementParser.fromFile(file);
        if (list2 == null) {
            PyPackageManagerImpl.b(25);
        }
        return list2;
    }

    @Override
    @NotNull
    public List<PyPackage> refreshAndGetPackages(boolean alwaysRefresh) throws ExecutionException {
        long l2 = r ^ 0x33F6378573F6L;
        List<PyPackage> list2 = this.m;
        if (alwaysRefresh || list2 == null) {
            List<PyPackage> list3;
            this.m = null;
            try {
                List<PyPackage> list4 = this.collectPackages();
                d.debug("Packages installed in " + this.c.getName() + ": " + list4);
                this.m = list4;
                ((PyPackageManager.Listener)ApplicationManager.getApplication().getMessageBus().syncPublisher(PACKAGE_MANAGER_TOPIC)).packagesRefreshed(this.c);
                list3 = Collections.unmodifiableList(list4);
            }
            catch (ExecutionException executionException) {
                this.m = Collections.emptyList();
                throw executionException;
            }
            if (list3 == null) {
                PyPackageManagerImpl.b(26);
            }
            return list3;
        }
        List<PyPackage> list5 = Collections.unmodifiableList(list2);
        if (list5 == null) {
            PyPackageManagerImpl.b(27);
        }
        return list5;
    }

    private void b() {
        PyPackageUtil.updatePackagesSynchronouslyWithGuard(this, this.n);
    }

    @Nullable
    private static String a() {
        long l2 = r ^ 0x44D7EB05AA64L;
        HttpConfigurable httpConfigurable = HttpConfigurable.getInstance();
        if (httpConfigurable != null && httpConfigurable.USE_HTTP_PROXY) {
            String string = httpConfigurable.PROXY_AUTHENTICATION ? String.format("%s:%s@", httpConfigurable.getProxyLogin(), httpConfigurable.getPlainProxyPassword()) : "";
            return "http://" + string + String.format("%s:%d", httpConfigurable.PROXY_HOST, httpConfigurable.PROXY_PORT);
        }
        return null;
    }

    @NotNull
    private String b(@NotNull String string, @NotNull List<String> list2, boolean bl2, boolean bl3, @Nullable String string2) throws ExecutionException {
        String string3;
        long l2 = r ^ 0x6737CCEEFE57L;
        if (string == null) {
            PyPackageManagerImpl.b(28);
        }
        if (list2 == null) {
            PyPackageManagerImpl.b(29);
        }
        if ((string3 = this.getHelperPath(string)) == null) {
            throw new ExecutionException("Cannot find external tool: " + string);
        }
        String string4 = this.a(string3, list2, bl2, bl3, string2);
        if (string4 == null) {
            PyPackageManagerImpl.b(30);
        }
        return string4;
    }

    @Nullable
    protected String getHelperPath(@NotNull String helper) throws ExecutionException {
        if (helper == null) {
            PyPackageManagerImpl.b(31);
        }
        return PythonHelpersLocator.getHelperPath(helper);
    }

    @NotNull
    private String a(@NotNull String string, @NotNull List<String> list2, boolean bl2, boolean bl3, @Nullable String string2) throws ExecutionException {
        long l2 = r ^ 0x60574BA51885L;
        if (string == null) {
            PyPackageManagerImpl.b(32);
        }
        if (list2 == null) {
            PyPackageManagerImpl.b(33);
        }
        ProcessOutput processOutput = this.getPythonProcessOutput(string, list2, bl2, bl3, string2);
        int n2 = processOutput.getExitCode();
        if (processOutput.isTimeout()) {
            throw new PyExecutionException("Timed out", string, list2, processOutput);
        }
        if (n2 != 0) {
            throw new PyExecutionException("Non-zero exit code (" + n2 + ")", string, list2, processOutput);
        }
        String string3 = processOutput.getStdout();
        if (string3 == null) {
            PyPackageManagerImpl.b(34);
        }
        return string3;
    }

    @NotNull
    protected ProcessOutput getPythonProcessOutput(@NotNull String helperPath, @NotNull List<String> args, boolean askForSudo, boolean showProgress, @Nullable String workingDir) throws ExecutionException {
        ProcessOutput processOutput;
        String string;
        long l2 = r ^ 0x68619E634E97L;
        if (helperPath == null) {
            PyPackageManagerImpl.b(35);
        }
        if (args == null) {
            PyPackageManagerImpl.b(36);
        }
        if ((string = this.getSdk().getHomePath()) == null) {
            throw new ExecutionException("Cannot find Python interpreter for SDK " + this.c.getName());
        }
        if (workingDir == null) {
            workingDir = new File(string).getParent();
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string);
        arrayList.add(helperPath);
        arrayList.addAll(args);
        d.info("Running packaging tool: " + StringUtil.join(PyPackageManagerImpl.a(arrayList), (String)" "));
        try {
            ProcessOutput processOutput2;
            GeneralCommandLine generalCommandLine = new GeneralCommandLine(arrayList).withWorkDirectory(workingDir).withEnvironment(PythonSdkType.activateVirtualEnv(this.getSdk()));
            Map map2 = generalCommandLine.getEnvironment();
            PythonEnvUtil.setPythonUnbuffered(map2);
            PythonEnvUtil.setPythonDontWriteBytecode(map2);
            PythonEnvUtil.resetHomePathChanges(string, map2);
            PythonSdkFlavor pythonSdkFlavor = PythonSdkFlavor.getFlavor(this.c);
            if (pythonSdkFlavor != null && pythonSdkFlavor.commandLinePatcher() != null) {
                pythonSdkFlavor.commandLinePatcher().patchCommandLine(generalCommandLine);
            }
            boolean bl2 = askForSudo && PySdkExtKt.adminPermissionsNeeded(this.c);
            Process process2 = bl2 ? ExecUtil.sudo((GeneralCommandLine)generalCommandLine, (String)"Please enter your password to make changes in system packages: ") : generalCommandLine.createProcess();
            CapturingProcessHandler capturingProcessHandler = new CapturingProcessHandler(process2, generalCommandLine.getCharset(), generalCommandLine.getCommandLineString());
            ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
            if (showProgress && progressIndicator != null) {
                capturingProcessHandler.addProcessListener((ProcessListener)new IndicatedProcessOutputListener(progressIndicator));
                processOutput2 = capturingProcessHandler.runProcessWithProgressIndicator(progressIndicator);
            } else {
                processOutput2 = capturingProcessHandler.runProcess(600000);
            }
            if (processOutput2.isCancelled()) {
                throw new RunCanceledByUserException();
            }
            processOutput2.checkSuccess(d);
            int n2 = processOutput2.getExitCode();
            if (n2 != 0) {
                String string2 = StringUtil.isEmptyOrSpaces((String)processOutput2.getStdout()) && StringUtil.isEmptyOrSpaces((String)processOutput2.getStderr()) ? "Permission denied" : "Non-zero exit code (" + n2 + ")";
                throw new PyExecutionException(string2, helperPath, args, processOutput2);
            }
            processOutput = processOutput2;
        }
        catch (IOException iOException) {
            throw new PyExecutionException(iOException.getMessage(), helperPath, args);
        }
        if (processOutput == null) {
            PyPackageManagerImpl.b(37);
        }
        return processOutput;
    }

    @NotNull
    private static List<String> a(@NotNull List<String> list2) {
        long l2 = r ^ 0x533089C61519L;
        if (list2 == null) {
            PyPackageManagerImpl.b(38);
        }
        ArrayList<String> arrayList = new ArrayList<String>(list2);
        for (int i10 = 0; i10 < arrayList.size(); ++i10) {
            if (!list2.get(i10).equals("--proxy") || i10 + 1 >= list2.size()) continue;
            arrayList.set(i10 + 1, PyPackageManagerImpl.b(list2.get(i10 + 1)));
        }
        ArrayList<String> arrayList2 = arrayList;
        if (arrayList2 == null) {
            PyPackageManagerImpl.b(39);
        }
        return arrayList2;
    }

    @NotNull
    private static String b(@NotNull String string) {
        block5: {
            String string2;
            if (string == null) {
                PyPackageManagerImpl.b(40);
            }
            try {
                int n2;
                URI uRI = new URI(string);
                String string3 = uRI.getUserInfo();
                if (string3 == null || (n2 = string3.indexOf(":")) < 0) break block5;
                String string4 = string3.substring(0, n2);
                String string5 = string3.substring(n2 + 1);
                String string6 = StringUtil.repeatSymbol((char)'*', (int)string5.length());
                String string7 = string4 + ":" + string6;
                string2 = string.replaceFirst(Pattern.quote(string3), string7);
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
            if (string2 == null) {
                PyPackageManagerImpl.b(41);
            }
            return string2;
        }
        String string8 = string;
        if (string8 == null) {
            PyPackageManagerImpl.b(42);
        }
        return string8;
    }

    @NotNull
    private List<PyPackage> c(@NotNull String string) throws ExecutionException {
        long l2 = r ^ 0x594EB85F899L;
        if (string == null) {
            PyPackageManagerImpl.b(43);
        }
        String[] stringArray = StringUtil.splitByLines((String)string);
        ArrayList<PyPackage> arrayList = new ArrayList<PyPackage>();
        for (String string2 : stringArray) {
            List list2 = StringUtil.split((String)string2, (String)"\t");
            if (list2.size() < 3) {
                throw new PyExecutionException("Invalid output format", g, Collections.emptyList());
            }
            String string3 = (String)list2.get(0);
            String string4 = (String)list2.get(1);
            String string5 = (String)list2.get(2);
            ArrayList<PyRequirement> arrayList2 = new ArrayList<PyRequirement>();
            if (list2.size() >= 4) {
                String string6 = (String)list2.get(3);
                String string7 = StringUtil.join((Collection)StringUtil.split((String)string6, (String)":"), (String)"\n");
                arrayList2.addAll(this.parseRequirements(string7));
            }
            if ("Python".equals(string3)) continue;
            arrayList.add(new PyPackage(string3, string4, string5, arrayList2));
        }
        ArrayList<PyPackage> arrayList3 = arrayList;
        if (arrayList3 == null) {
            PyPackageManagerImpl.b(44);
        }
        return arrayList3;
    }

    static {
        r = com.jetbrains.python.psi.c.a(3669884559818528568L, -3944538808927271741L, MethodHandles.lookup().lookupClass()).a(109051905074562L);
        d = Logger.getInstance(PyPackageManagerImpl.class);
    }

    private static /* synthetic */ void b(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = r ^ 0x4FF4E946E061L;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 16: 
            case 18: 
            case 19: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 30: 
            case 34: 
            case 37: 
            case 39: 
            case 41: 
            case 42: 
            case 44: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 16: 
            case 18: 
            case 19: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 30: 
            case 34: 
            case 37: 
            case 39: 
            case 41: 
            case 42: 
            case 44: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 16: 
            case 18: 
            case 19: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 30: 
            case 34: 
            case 37: 
            case 39: 
            case 41: 
            case 42: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/packaging/PyPackageManagerImpl";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dirName";
                break;
            }
            case 5: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requirementString";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extraArgs";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packages";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pkg";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "destinationDir";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 28: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helper";
                break;
            }
            case 29: 
            case 33: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helperPath";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cmdline";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "proxyArgument";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/packaging/PyPackageManagerImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "extractHelper";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "toSystemDependentName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getSdk";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "collectPackages";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependents";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "createVirtualEnv";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrRequestLanguageLevelForSdk";
                break;
            }
            case 23: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "parseRequirements";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "refreshAndGetPackages";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getHelperResult";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getPythonProcessResult";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getPythonProcessOutput";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "makeSafeToDisplayCommand";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "makeSafeProxyArgument";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "parsePackagingToolOutput";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "installManagement";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "extractHelper";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 16: 
            case 18: 
            case 19: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 30: 
            case 34: 
            case 37: 
            case 39: 
            case 41: 
            case 42: 
            case 44: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "toSystemDependentName";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = k;
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = h;
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getDependents";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createVirtualEnv";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getOrRequestLanguageLevelForSdk";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getRequirements";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "parseRequirement";
                break;
            }
            case 22: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "parseRequirements";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getHelperResult";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getHelperPath";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getPythonProcessResult";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getPythonProcessOutput";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "makeSafeToDisplayCommand";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "makeSafeProxyArgument";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "parsePackagingToolOutput";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 16: 
            case 18: 
            case 19: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 30: 
            case 34: 
            case 37: 
            case 39: 
            case 41: 
            case 42: 
            case 44: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class IndicatedProcessOutputListener
    extends ProcessAdapter {
        @NotNull
        private final ProgressIndicator a;
        private static final long b = com.jetbrains.python.psi.c.a(-9204790725881727997L, -3715751158904838387L, MethodHandles.lookup().lookupClass()).a(113608251650274L);

        public IndicatedProcessOutputListener(@NotNull ProgressIndicator indicator) {
            if (indicator == null) {
                IndicatedProcessOutputListener.a(0);
            }
            this.a = indicator;
        }

        public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
            if (event == null) {
                IndicatedProcessOutputListener.a(1);
            }
            if (outputType == null) {
                IndicatedProcessOutputListener.a(2);
            }
            if (outputType == ProcessOutputTypes.STDOUT || outputType == ProcessOutputTypes.STDERR) {
                for (String string : StringUtil.splitByLines((String)event.getText())) {
                    String string2 = string.trim();
                    if (!IndicatedProcessOutputListener.a(string2)) continue;
                    this.a.setText2(string2);
                }
            }
        }

        private static boolean a(@NotNull String string) {
            if (string == null) {
                IndicatedProcessOutputListener.a(3);
            }
            return string.length() > 3;
        }

        private static /* synthetic */ void a(int n2) {
            Object[] objectArray;
            Object[] objectArray2;
            long l2 = b ^ 0x25B49F9F681BL;
            Object[] objectArray3 = new Object[3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "outputType";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "trimmed";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/python/packaging/PyPackageManagerImpl$IndicatedProcessOutputListener";
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onTextAvailable";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isMeaningfulOutput";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

