/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections.quickfix;

import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.template.TemplateBuilder;
import com.intellij.codeInsight.template.TemplateBuilderFactory;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.inspections.PyInspectionExtension;
import com.jetbrains.python.psi.PyArgumentList;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyKeywordArgument;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.PyQualifiedExpression;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.c;
import com.jetbrains.python.psi.impl.ParamHelper;
import com.jetbrains.python.psi.impl.PyFunctionBuilder;
import com.jetbrains.python.psi.types.PyModuleType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.lang.invoke.MethodHandles;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class AddFunctionQuickFix
implements LocalQuickFix {
    private final String b;
    private final String a;
    private static final long c = com.jetbrains.python.psi.c.a(-8390404392145013741L, -7397607432737352540L, MethodHandles.lookup().lookupClass()).a(71570065773017L);

    public AddFunctionQuickFix(@NotNull String identifier, String moduleName) {
        if (identifier == null) {
            AddFunctionQuickFix.a(0);
        }
        this.b = identifier;
        this.a = moduleName;
    }

    @NotNull
    public String getName() {
        long l2 = c ^ 0x5A844F051AF1L;
        String string = PyBundle.message("QFIX.NAME.add.function.$0.to.module.$1", this.b, this.a);
        if (string == null) {
            AddFunctionQuickFix.a(1);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        long l2 = c ^ 0x60379FB6457BL;
        if ("Create function in module" == null) {
            AddFunctionQuickFix.a(2);
        }
        return "Create function in module";
    }

    public boolean startInWriteAction() {
        return false;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
        long l2 = c ^ 0x513C364EEEFAL;
        if (project == null) {
            AddFunctionQuickFix.a(3);
        }
        if (descriptor2 == null) {
            AddFunctionQuickFix.a(4);
        }
        try {
            PsiElement psiElement = descriptor2.getPsiElement();
            if (!(psiElement instanceof PyQualifiedExpression)) {
                return;
            }
            PyExpression pyExpression = ((PyQualifiedExpression)psiElement).getQualifier();
            if (pyExpression == null) {
                return;
            }
            PyType pyType = TypeEvalContext.userInitiated(psiElement.getProject(), psiElement.getContainingFile()).getType(pyExpression);
            if (!(pyType instanceof PyModuleType)) {
                return;
            }
            PyFile pyFile = ((PyModuleType)pyType).getModule();
            PyUtil.sure(pyFile);
            PyUtil.sure(FileModificationService.getInstance().preparePsiElementForWrite((PsiElement)pyFile));
            PyFunctionBuilder pyFunctionBuilder = new PyFunctionBuilder(this.b, psiElement);
            PsiElement psiElement2 = psiElement.getParent();
            if (psiElement2 instanceof PyCallExpression) {
                PyExpression[] pyExpressionArray;
                PyArgumentList pyArgumentList = ((PyCallExpression)psiElement2).getArgumentList();
                if (pyArgumentList == null) {
                    return;
                }
                for (PyExpression pyExpression2 : pyExpressionArray = pyArgumentList.getArguments()) {
                    if (pyExpression2 instanceof PyKeywordArgument) {
                        pyFunctionBuilder.parameter(((PyKeywordArgument)pyExpression2).getKeyword());
                        continue;
                    }
                    if (pyExpression2 instanceof PyReferenceExpression) {
                        PyReferenceExpression pyReferenceExpression = (PyReferenceExpression)pyExpression2;
                        pyFunctionBuilder.parameter(pyReferenceExpression.getReferencedName());
                        continue;
                    }
                    pyFunctionBuilder.parameter("param");
                }
            } else if (psiElement2 != null) {
                for (PyInspectionExtension pyInspectionExtension : PyInspectionExtension.EP_NAME.getExtensionList()) {
                    List<String> list2 = pyInspectionExtension.getFunctionParametersFromUsage(psiElement);
                    if (list2 == null) continue;
                    for (String string : list2) {
                        pyFunctionBuilder.parameter(string);
                    }
                    break;
                }
            }
            WriteAction.run(() -> {
                PyFunction pyFunction = pyFunctionBuilder.buildFunction();
                pyFunction = (PyFunction)pyFile.add(pyFunction);
                AddFunctionQuickFix.a(pyFunction, (PsiFile)pyFile);
            });
        }
        catch (IncorrectOperationException incorrectOperationException) {
            PyUtil.showBalloon(project, PyBundle.message("QFIX.failed.to.add.function", new Object[0]), MessageType.ERROR);
        }
    }

    private static void a(PyFunction pyFunction, @NotNull PsiFile psiFile) {
        long l2 = c ^ 0x250BB72E8C27L;
        if (psiFile == null) {
            AddFunctionQuickFix.a(5);
        }
        pyFunction = (PyFunction)CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement((PsiElement)pyFunction);
        final TemplateBuilder templateBuilder = TemplateBuilderFactory.getInstance().createTemplateBuilder((PsiElement)pyFunction);
        ParamHelper.walkDownParamArray(pyFunction.getParameterList().getParameters(), new ParamHelper.ParamVisitor(){

            @Override
            public void visitNamedParameter(PyNamedParameter param, boolean first, boolean last) {
                templateBuilder.replaceElement((PsiElement)param, param.getName());
            }
        });
        templateBuilder.replaceElement((PsiElement)pyFunction.getStatementList(), "return None");
        VirtualFile virtualFile = psiFile.getVirtualFile();
        if (virtualFile == null) {
            return;
        }
        Editor editor2 = FileEditorManager.getInstance((Project)psiFile.getProject()).openTextEditor(new OpenFileDescriptor(psiFile.getProject(), virtualFile), true);
        if (editor2 == null) {
            return;
        }
        templateBuilder.run(editor2, false);
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = c ^ 0x5756DAF22793L;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 1: 
            case 2: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifier";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/inspections/quickfix/AddFunctionQuickFix";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/inspections/quickfix/AddFunctionQuickFix";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "showTemplateBuilder";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

