/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.ex.InspectionProfileModifiableModelKt;
import com.intellij.codeInspection.ui.ListEditForm;
import com.intellij.ide.DataManager;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.QualifiedName;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.util.ui.CheckBox;
import com.jetbrains.python.codeInsight.controlflow.ControlFlowCache;
import com.jetbrains.python.codeInsight.dataflow.scope.Scope;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.inspections.quickfix.PyRenameElementQuickFix;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyImportElement;
import com.jetbrains.python.psi.PyParameter;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.c;
import com.jetbrains.python.psi.search.PySuperMethodsSearch;
import com.jetbrains.python.psi.types.PyClassLikeType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.awt.BorderLayout;
import java.awt.Component;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyPep8NamingInspection
extends PyInspection {
    private static final Pattern a;
    private static final Pattern c;
    private static final Pattern d;
    private static final String e = "PyPep8NamingInspection";
    private static final Map<String, String> b;
    public final List<String> ignoredErrors;
    public boolean ignoreOverriddenFunctions;
    public final List<String> ignoredBaseClasses;
    private static final long f;

    public PyPep8NamingInspection() {
        long l2 = f ^ 0x4A8AE1C0B37AL;
        this.ignoredErrors = new ArrayList<String>();
        this.ignoreOverriddenFunctions = true;
        this.ignoredBaseClasses = Lists.newArrayList((Object[])new String[]{"unittest.TestCase", "unittest.case.TestCase"});
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            PyPep8NamingInspection.b(0);
        }
        if (session == null) {
            PyPep8NamingInspection.b(1);
        }
        Visitor visitor2 = new Visitor(holder, session);
        if (visitor2 == null) {
            PyPep8NamingInspection.b(2);
        }
        return visitor2;
    }

    @Nullable
    public JComponent createOptionsPanel() {
        long l2 = f ^ 0x196D4D54EE6DL;
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)new CheckBox("Ignore overridden functions", (InspectionProfileEntry)this, "ignoreOverriddenFunctions"), "North");
        OnePixelSplitter onePixelSplitter = new OnePixelSplitter(false);
        onePixelSplitter.setFirstComponent(new ListEditForm("Excluded base classes", this.ignoredBaseClasses).getContentPanel());
        onePixelSplitter.setSecondComponent(new ListEditForm("Ignored errors", this.ignoredErrors).getContentPanel());
        jPanel.add((Component)onePixelSplitter, "Center");
        return jPanel;
    }

    static {
        f = com.jetbrains.python.psi.c.a(-2119950804101060090L, 41484313159546504L, MethodHandles.lookup().lookupClass()).a(175476951808294L);
        long l2 = f ^ 0x2DDF918FAA26L;
        a = Pattern.compile("[_\\p{javaLowerCase}][_\\p{javaLowerCase}0-9]*");
        c = Pattern.compile("[_\\p{javaUpperCase}][_\\p{javaUpperCase}0-9]*");
        d = Pattern.compile("_?_?[\\p{javaUpperCase}][\\p{javaLowerCase}\\p{javaUpperCase}0-9]*");
        b = ImmutableMap.builder().put((Object)"N801", (Object)"Class names should use CamelCase convention").put((Object)"N802", (Object)"Function name should be lowercase").put((Object)"N803", (Object)"Argument name should be lowercase").put((Object)"N806", (Object)"Variable in function should be lowercase").put((Object)"N811", (Object)"Constant variable imported as non constant").put((Object)"N812", (Object)"Lowercase variable imported as non lowercase").put((Object)"N813", (Object)"CamelCase variable imported as lowercase").put((Object)"N814", (Object)"CamelCase variable imported as constant").build();
    }

    private static /* synthetic */ void b(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = f ^ 0x68758FBCB928L;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 2: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/inspections/PyPep8NamingInspection";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/inspections/PyPep8NamingInspection";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class IgnoreErrorFix
    implements LocalQuickFix {
        private final String a;
        private static final String b = "Ignore errors like this";
        private static final long c = com.jetbrains.python.psi.c.a(3500006488223189296L, 1767908257653597871L, MethodHandles.lookup().lookupClass()).a(48539947326866L);

        IgnoreErrorFix(String code) {
            this.a = code;
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            long l2 = c ^ 0xA4E15250257L;
            if (b == null) {
                IgnoreErrorFix.a(0);
            }
            return b;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            if (project == null) {
                IgnoreErrorFix.a(1);
            }
            if (descriptor2 == null) {
                IgnoreErrorFix.a(2);
            }
            PsiFile psiFile = descriptor2.getStartElement().getContainingFile();
            InspectionProfileModifiableModelKt.modifyAndCommitProjectProfile((Project)project, inspectionProfileModifiableModel -> {
                long l2 = c ^ 0x38DC27838754L;
                PyPep8NamingInspection pyPep8NamingInspection = (PyPep8NamingInspection)inspectionProfileModifiableModel.getUnwrappedTool(PyPep8NamingInspection.e, (PsiElement)psiFile);
                if (!pyPep8NamingInspection.ignoredErrors.contains(this.a)) {
                    pyPep8NamingInspection.ignoredErrors.add(this.a);
                }
            });
        }

        private static /* synthetic */ void a(int n2) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n3;
            String string;
            long l2 = c ^ 0x2E6AC1E6FEB0L;
            switch (n2) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n2) {
                default: {
                    n3 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n3 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/inspections/PyPep8NamingInspection$IgnoreErrorFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/inspections/PyPep8NamingInspection$IgnoreErrorFix";
                    break;
                }
            }
            switch (n2) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n2) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class IgnoreBaseClassQuickFix
    implements LocalQuickFix {
        private final List<String> a;
        private static final long b = com.jetbrains.python.psi.c.a(7569361832299495968L, -5560664019268372076L, MethodHandles.lookup().lookupClass()).a(277004478178792L);

        IgnoreBaseClassQuickFix(@NotNull PyClass baseClass, @NotNull TypeEvalContext context) {
            if (baseClass == null) {
                IgnoreBaseClassQuickFix.a(0);
            }
            if (context == null) {
                IgnoreBaseClassQuickFix.a(1);
            }
            this.a = new ArrayList<String>();
            ContainerUtil.addIfNotNull(this.getBaseClassNames(), (Object)baseClass.getQualifiedName());
            for (PyClass pyClass : baseClass.getAncestorClasses(context)) {
                ContainerUtil.addIfNotNull(this.getBaseClassNames(), (Object)pyClass.getQualifiedName());
            }
        }

        @NotNull
        public String getFamilyName() {
            long l2 = b ^ 0x121B6716C54DL;
            if ("Ignore method names for descendants of class" == null) {
                IgnoreBaseClassQuickFix.a(2);
            }
            return "Ignore method names for descendants of class";
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            if (project == null) {
                IgnoreBaseClassQuickFix.a(3);
            }
            if (descriptor2 == null) {
                IgnoreBaseClassQuickFix.a(4);
            }
            DataManager.getInstance().getDataContextFromFocus().doWhenDone(dataContext -> {
                long l2 = b ^ 0x5177AD01DBFFL;
                JBPopupFactory.getInstance().createPopupChooserBuilder(this.getBaseClassNames()).setTitle("Ignore base class").setItemChosenCallback(string -> InspectionProfileModifiableModelKt.modifyAndCommitProjectProfile((Project)project, inspectionProfileModifiableModel -> {
                    PyPep8NamingInspection pyPep8NamingInspection = (PyPep8NamingInspection)inspectionProfileModifiableModel.getUnwrappedTool(PyPep8NamingInspection.class.getSimpleName(), descriptor2.getPsiElement());
                    ContainerUtilRt.addIfNotNull(pyPep8NamingInspection.ignoredBaseClasses, (Object)string);
                })).setNamerForFiltering(string -> string).createPopup().showInBestPositionFor(dataContext);
            });
        }

        public List<String> getBaseClassNames() {
            return this.a;
        }

        private static /* synthetic */ void a(int n2) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n3;
            String string;
            long l2 = b ^ 0x7C60C72ADD72L;
            switch (n2) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n2) {
                default: {
                    n3 = 3;
                    break;
                }
                case 2: {
                    n3 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "baseClass";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/inspections/PyPep8NamingInspection$IgnoreBaseClassQuickFix";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/inspections/PyPep8NamingInspection$IgnoreBaseClassQuickFix";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n2) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public class Visitor
    extends PyInspectionVisitor {
        private static final long c = com.jetbrains.python.psi.c.a(-1565415601822398291L, -5026170046321495820L, MethodHandles.lookup().lookupClass()).a(168615867530253L);

        public Visitor(ProblemsHolder holder, LocalInspectionToolSession session) {
            super(holder, session);
        }

        @Override
        public void visitPyAssignmentStatement(PyAssignmentStatement node) {
            long l2 = c ^ 0x1E77AE19C6AAL;
            PyFunction pyFunction = (PyFunction)PsiTreeUtil.getParentOfType((PsiElement)node, PyFunction.class, (boolean)true, (Class[])new Class[]{PyClass.class});
            if (pyFunction == null) {
                return;
            }
            Scope scope = ControlFlowCache.getScope(pyFunction);
            for (Pair<PyExpression, PyExpression> pair : node.getTargetsToValuesMapping()) {
                PyExpression pyExpression;
                String string;
                PyExpression pyExpression2 = (PyExpression)pair.getFirst();
                if (pyExpression2 == null || (string = pyExpression2.getName()) == null || scope.isGlobal(string)) continue;
                if (pyExpression2 instanceof PyTargetExpression && (pyExpression = ((PyTargetExpression)pyExpression2).getQualifier()) != null) {
                    return;
                }
                pyExpression = PyUtil.as(pair.getSecond(), PyCallExpression.class);
                if (pyExpression != null && pyExpression.getCallee() != null && "namedtuple".equals(pyExpression.getCallee().getName())) {
                    return;
                }
                String string2 = "N806";
                if (a.matcher(string).matches() || string.startsWith("_") || PyPep8NamingInspection.this.ignoredErrors.contains("N806")) continue;
                this.a((PsiElement)pyExpression2, "N806");
            }
        }

        @Override
        public void visitPyParameter(PyParameter node) {
            long l2 = c ^ 0x1500410FEC52L;
            String string = node.getName();
            if (string == null) {
                return;
            }
            String string2 = "N803";
            if (!a.matcher(string).matches() && !PyPep8NamingInspection.this.ignoredErrors.contains("N803")) {
                this.a((PsiElement)node, "N803");
            }
        }

        private void a(@Nullable PsiElement psiElement, @NotNull String string) {
            if (string == null) {
                Visitor.b(0);
            }
            if (this.getHolder() != null && this.getHolder().isOnTheFly()) {
                this.registerProblem(psiElement, (String)b.get(string), new LocalQuickFix[]{new PyRenameElementQuickFix(psiElement), new IgnoreErrorFix(string)});
            } else {
                this.registerProblem(psiElement, (String)b.get(string), new IgnoreErrorFix(string));
            }
        }

        @Override
        public void visitPyFunction(PyFunction function) {
            ASTNode aSTNode;
            long l2 = c ^ 0x6E73D0480E28L;
            PyClass pyClass = function.getContainingClass();
            if (PyPep8NamingInspection.this.ignoreOverriddenFunctions && this.a(function)) {
                return;
            }
            String string = function.getName();
            if (string == null) {
                return;
            }
            if (pyClass != null && (PyUtil.isSpecialName(string) || this.a(pyClass))) {
                return;
            }
            if (!a.matcher(string).matches() && (aSTNode = function.getNameNode()) != null) {
                ArrayList arrayList = Lists.newArrayList();
                if (this.getHolder() != null && this.getHolder().isOnTheFly()) {
                    arrayList.add(new PyRenameElementQuickFix(aSTNode.getPsi()));
                }
                if (pyClass != null) {
                    arrayList.add(new IgnoreBaseClassQuickFix(pyClass, this.myTypeEvalContext));
                }
                String string2 = "N802";
                if (!PyPep8NamingInspection.this.ignoredErrors.contains("N802")) {
                    arrayList.add(new IgnoreErrorFix("N802"));
                    this.registerProblem(aSTNode.getPsi(), (String)b.get("N802"), arrayList.toArray(LocalQuickFix.EMPTY_ARRAY));
                }
            }
        }

        private boolean a(@NotNull PyFunction pyFunction) {
            if (pyFunction == null) {
                Visitor.b(1);
            }
            return PySuperMethodsSearch.search(pyFunction, this.myTypeEvalContext).findFirst() != null;
        }

        private boolean a(@NotNull PyClass pyClass) {
            HashSet hashSet;
            if (pyClass == null) {
                Visitor.b(2);
            }
            if ((hashSet = Sets.newHashSet(PyPep8NamingInspection.this.ignoredBaseClasses)).contains(pyClass.getQualifiedName())) {
                return true;
            }
            for (PyClassLikeType pyClassLikeType : pyClass.getAncestorTypes(this.myTypeEvalContext)) {
                if (pyClassLikeType == null || !hashSet.contains(pyClassLikeType.getClassQName())) continue;
                return true;
            }
            return false;
        }

        @Override
        public void visitPyClass(PyClass node) {
            long l2 = c ^ 0x3193850E0BA6L;
            String string = node.getName();
            if (string == null) {
                return;
            }
            String string2 = "N801";
            if (!PyPep8NamingInspection.this.ignoredErrors.contains("N801")) {
                ASTNode aSTNode;
                boolean bl2;
                boolean bl3 = bl2 = this.b(node) && a.matcher(string).matches();
                if (!bl2 && !d.matcher(string).matches() && (aSTNode = node.getNameNode()) != null) {
                    this.a(aSTNode.getPsi(), "N801");
                }
            }
        }

        private boolean b(PyClass pyClass) {
            String[] stringArray;
            long l2 = c ^ 0x748C7E6DE1A7L;
            for (String string : stringArray = new String[]{"__enter__", "__exit__"}) {
                if (pyClass.findMethodByName(string, false, this.myTypeEvalContext) != null) continue;
                return false;
            }
            return true;
        }

        @Override
        public void visitPyImportElement(PyImportElement node) {
            long l2 = c ^ 0x48EACE79B5DCL;
            String string = node.getAsName();
            QualifiedName qualifiedName = node.getImportedQName();
            if (qualifiedName == null) {
                return;
            }
            String string2 = qualifiedName.getLastComponent();
            if (string == null || string2 == null) {
                return;
            }
            if (c.matcher(string2).matches()) {
                String string3 = "N811";
                if (!c.matcher(string).matches() && !PyPep8NamingInspection.this.ignoredErrors.contains("N811")) {
                    this.a(node.getAsNameElement(), "N811");
                }
            } else if (a.matcher(string2).matches()) {
                String string4 = "N812";
                if (!a.matcher(string).matches() && !PyPep8NamingInspection.this.ignoredErrors.contains("N812")) {
                    this.a(node.getAsNameElement(), "N812");
                }
            } else if (a.matcher(string).matches()) {
                String string5 = "N813";
                if (!PyPep8NamingInspection.this.ignoredErrors.contains("N813")) {
                    this.a(node.getAsNameElement(), "N813");
                }
            } else if (c.matcher(string).matches()) {
                String string6 = "N814";
                if (!PyPep8NamingInspection.this.ignoredErrors.contains("N814")) {
                    this.a(node.getAsNameElement(), "N814");
                }
            }
        }

        private static /* synthetic */ void b(int n2) {
            Object[] objectArray;
            Object[] objectArray2;
            long l2 = c ^ 0xE9B924164A6L;
            Object[] objectArray3 = new Object[3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "errorCode";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "function";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pyClass";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/python/inspections/PyPep8NamingInspection$Visitor";
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "registerAndAddRenameAndIgnoreErrorQuickFixes";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isOverriddenMethod";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isIgnoredOrHasIgnoredAncestor";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

