/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.google.common.collect.ImmutableSet;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.ex.EditInspectionToolsSettingsAction;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ui.ListEditForm;
import com.intellij.execution.ExecutionException;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.JDOMExternalizableStringList;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.profile.codeInspection.ProjectInspectionProfileManager;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiPlainTextFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.codeInsight.imports.AddImportHelper;
import com.jetbrains.python.codeInsight.stdlib.PyStdlibUtil;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionExtension;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.inspections.PyInterpreterInspection;
import com.jetbrains.python.inspections.g;
import com.jetbrains.python.packaging.PyPIPackageUtil;
import com.jetbrains.python.packaging.PyPackage;
import com.jetbrains.python.packaging.PyPackageManager;
import com.jetbrains.python.packaging.PyPackageManagerUI;
import com.jetbrains.python.packaging.PyPackageUtil;
import com.jetbrains.python.packaging.PyRequirement;
import com.jetbrains.python.packaging.PyRequirementsKt;
import com.jetbrains.python.packaging.ui.PyChooseRequirementsDialog;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFromImportStatement;
import com.jetbrains.python.psi.PyImportElement;
import com.jetbrains.python.psi.PyImportStatement;
import com.jetbrains.python.psi.PyQualifiedExpression;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.c;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.sdk.PySdkExtKt;
import com.jetbrains.python.sdk.PythonSdkType;
import com.jetbrains.python.sdk.pipenv.PipEnvInstallQuickFix;
import com.jetbrains.python.sdk.pipenv.PipenvKt;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.event.HyperlinkEvent;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyPackageRequirementsInspection
extends PyInspection {
    public JDOMExternalizableStringList ignoredPackages = new JDOMExternalizableStringList();
    @NotNull
    private static final NotificationGroup a;
    private static final long b;

    @NotNull
    public String getDisplayName() {
        long l2 = b ^ 0x267E6A25377L;
        if ("Package requirements" == null) {
            PyPackageRequirementsInspection.b(0);
        }
        return "Package requirements";
    }

    public JComponent createOptionsPanel() {
        long l2 = b ^ 0x43BE86074422L;
        ListEditForm listEditForm = new ListEditForm("Ignore packages", (List)this.ignoredPackages);
        return listEditForm.getContentPanel();
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            PyPackageRequirementsInspection.b(1);
        }
        if (session == null) {
            PyPackageRequirementsInspection.b(2);
        }
        if (!(holder.getFile() instanceof PyFile) && !(holder.getFile() instanceof PsiPlainTextFile)) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                PyPackageRequirementsInspection.b(3);
            }
            return psiElementVisitor;
        }
        Visitor visitor2 = new Visitor(holder, session, (Collection<String>)this.ignoredPackages);
        if (visitor2 == null) {
            PyPackageRequirementsInspection.b(4);
        }
        return visitor2;
    }

    @Nullable
    public static PyPackageRequirementsInspection getInstance(@NotNull PsiElement element) {
        if (element == null) {
            PyPackageRequirementsInspection.b(5);
        }
        InspectionProfileImpl inspectionProfileImpl = InspectionProjectProfileManager.getInstance((Project)element.getProject()).getCurrentProfile();
        String string = PyPackageRequirementsInspection.class.getSimpleName();
        return (PyPackageRequirementsInspection)inspectionProfileImpl.getUnwrappedTool(string, element);
    }

    @Nullable
    private static Set<PyRequirement> a(@NotNull PyPackageManager pyPackageManager, @NotNull Module module2) {
        List<PyRequirement> list2;
        if (pyPackageManager == null) {
            PyPackageRequirementsInspection.b(6);
        }
        if (module2 == null) {
            PyPackageRequirementsInspection.b(7);
        }
        if ((list2 = PyPackageRequirementsInspection.b(pyPackageManager, module2)) == null) {
            return null;
        }
        if (list2.isEmpty()) {
            return Collections.emptySet();
        }
        List<PyPackage> list3 = pyPackageManager.getPackages();
        if (list3 == null) {
            return null;
        }
        HashSet<PyRequirement> hashSet = new HashSet<PyRequirement>(list2);
        hashSet.addAll(PyPackageRequirementsInspection.a(list3, list2, new HashSet<PyPackage>()));
        return hashSet;
    }

    @Nullable
    private static List<PyRequirement> b(@NotNull PyPackageManager pyPackageManager, @NotNull Module module2) {
        if (pyPackageManager == null) {
            PyPackageRequirementsInspection.b(8);
        }
        if (module2 == null) {
            PyPackageRequirementsInspection.b(9);
        }
        List<PyRequirement> list2 = pyPackageManager.getRequirements(module2);
        List<PyRequirement> list3 = PyPackageRequirementsInspection.b(module2);
        if (list2 == null) {
            return list3;
        }
        if (list3 == null) {
            return list2;
        }
        return ContainerUtil.concat(list2, list3);
    }

    @Nullable
    private static List<PyRequirement> b(@NotNull Module module2) {
        Map<String, List<PyRequirement>> map2;
        if (module2 == null) {
            PyPackageRequirementsInspection.b(10);
        }
        return (map2 = PyPackageUtil.findSetupPyExtrasRequire(module2)) == null ? null : ContainerUtil.flatten(map2.values());
    }

    @NotNull
    private static Set<PyRequirement> a(@NotNull List<PyPackage> list2, @NotNull Collection<PyRequirement> collection, @NotNull Set<PyPackage> set) {
        if (list2 == null) {
            PyPackageRequirementsInspection.b(11);
        }
        if (collection == null) {
            PyPackageRequirementsInspection.b(12);
        }
        if (set == null) {
            PyPackageRequirementsInspection.b(13);
        }
        HashSet<PyRequirement> hashSet = new HashSet<PyRequirement>();
        for (PyRequirement pyRequirement : collection) {
            PyPackage pyPackage = pyRequirement.match(list2);
            if (pyPackage == null || !set.add(pyPackage)) continue;
            hashSet.addAll(PyPackageRequirementsInspection.a(list2, pyPackage.getRequirements(), set));
        }
        HashSet<PyRequirement> hashSet2 = hashSet;
        if (hashSet2 == null) {
            PyPackageRequirementsInspection.b(14);
        }
        return hashSet2;
    }

    @Nullable
    private static List<PyRequirement> a(@NotNull Module module2, @NotNull Sdk sdk, @NotNull Set<String> set) {
        PyPackageManager pyPackageManager;
        List<PyRequirement> list2;
        if (module2 == null) {
            PyPackageRequirementsInspection.b(15);
        }
        if (sdk == null) {
            PyPackageRequirementsInspection.b(16);
        }
        if (set == null) {
            PyPackageRequirementsInspection.b(17);
        }
        if ((list2 = (pyPackageManager = PyPackageManager.getInstance(sdk)).getRequirements(module2)) != null) {
            List<PyPackage> list3 = pyPackageManager.getPackages();
            if (list3 == null) {
                return null;
            }
            List<PyPackage> list4 = PyPackageRequirementsInspection.c(module2);
            ArrayList<PyRequirement> arrayList = new ArrayList<PyRequirement>();
            for (PyRequirement pyRequirement : list2) {
                if (set.contains(pyRequirement.getName()) || pyRequirement.match(list3) != null || pyRequirement.match(list4) != null) continue;
                arrayList.add(pyRequirement);
            }
            return arrayList;
        }
        return null;
    }

    @NotNull
    private static List<PyPackage> c(@NotNull Module module2) {
        long l2 = b ^ 0x3B7BBA1CAC8L;
        if (module2 == null) {
            PyPackageRequirementsInspection.b(18);
        }
        String[] stringArray = new String[]{"egg-info", "dist-info"};
        SmartList smartList = new SmartList();
        for (VirtualFile virtualFile2 : PyUtil.getSourceRoots(module2)) {
            for (VirtualFile virtualFile3 : VfsUtil.getChildren((VirtualFile)virtualFile2, virtualFile -> ArrayUtil.contains((String)virtualFile.getExtension(), (String[])stringArray))) {
                String[] stringArray2 = virtualFile3.getNameWithoutExtension().split("-", 3);
                if (stringArray2.length < 2) continue;
                smartList.add(new PyPackage(stringArray2[0], stringArray2[1], null, Collections.emptyList()));
            }
        }
        SmartList smartList2 = smartList;
        if (smartList2 == null) {
            PyPackageRequirementsInspection.b(19);
        }
        return smartList2;
    }

    private static void a(@NotNull Module module2, boolean bl2) {
        if (module2 == null) {
            PyPackageRequirementsInspection.b(20);
        }
        module2.putUserData(PyPackageManager.RUNNING_PACKAGING_TASKS, (Object)bl2);
    }

    private static boolean a(@NotNull Module module2) {
        Boolean bl2;
        if (module2 == null) {
            PyPackageRequirementsInspection.b(21);
        }
        return (bl2 = (Boolean)module2.getUserData(PyPackageManager.RUNNING_PACKAGING_TASKS)) != null && bl2 != false;
    }

    private static boolean a(@NotNull Project project, @NotNull ProblemDescriptor problemDescriptor, @NotNull Sdk sdk) {
        if (project == null) {
            PyPackageRequirementsInspection.b(22);
        }
        if (problemDescriptor == null) {
            PyPackageRequirementsInspection.b(23);
        }
        if (sdk == null) {
            PyPackageRequirementsInspection.b(24);
        }
        if (!PythonSdkType.isRemote(sdk) && PySdkExtKt.adminPermissionsNeeded(sdk)) {
            int n2 = PyPackageRequirementsInspection.a(project, sdk);
            switch (n2) {
                case 0: {
                    new PyInterpreterInspection.ConfigureInterpreterFix().applyFix(project, problemDescriptor);
                    return true;
                }
                case -1: 
                case 2: {
                    return true;
                }
            }
        }
        return false;
    }

    private static int a(@NotNull Project project, @NotNull Sdk sdk) {
        long l2 = b ^ 0x5F8715ADFE0L;
        if (project == null) {
            PyPackageRequirementsInspection.b(25);
        }
        if (sdk == null) {
            PyPackageRequirementsInspection.b(26);
        }
        String string = StringUtil.shortenTextWithEllipsis((String)sdk.getName(), (int)25, (int)0);
        String string2 = "Installing packages into '" + string + "' requires administrator privileges.\n\nConfigure a per-project virtual environment as your project interpreter\nto avoid installing packages to a protected area of the file system.";
        String[] stringArray = new String[]{"Configure", "Install Anyway", "Cancel"};
        return Messages.showIdeaMessageDialog((Project)project, (String)string2, (String)"Administrator Privileges Required", (String[])stringArray, (int)0, (Icon)Messages.getWarningIcon(), null);
    }

    static {
        b = c.a(-763109079772814994L, 6373522677474723961L, MethodHandles.lookup().lookupClass()).a(224663552500440L);
        long l2 = b ^ 0x5611FC448126L;
        a = new NotificationGroup("Package requirements", NotificationDisplayType.BALLOON, false);
    }

    private static /* synthetic */ void b(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = b ^ 0x3020889DEA8AL;
        switch (n2) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                n3 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/inspections/PyPackageRequirementsInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageManager";
                break;
            }
            case 7: 
            case 9: 
            case 10: 
            case 15: 
            case 18: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packages";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requirements";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visited";
                break;
            }
            case 16: 
            case 24: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ignoredPackages";
                break;
            }
            case 22: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/inspections/PyPackageRequirementsInspection";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getTransitiveRequirements";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "collectPackagesInModule";
                break;
            }
        }
        switch (n2) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getRequirementsInclTransitive";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getListedRequirements";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getExtrasRequirements";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getTransitiveRequirements";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "findUnsatisfiedRequirements";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "collectPackagesInModule";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "setRunningPackagingTasks";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isRunningPackagingTasks";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "checkAdminPermissionsAndConfigureInterpreter";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "askToConfigureInterpreter";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class AddToRequirementsFix
    implements LocalQuickFix {
        @NotNull
        private final PyPackageManager b;
        @NotNull
        private final Module d;
        @NotNull
        private final String c;
        @NotNull
        private final LanguageLevel a;
        private static final long e = com.jetbrains.python.psi.c.a(-4358745730022102133L, 6714526787758767776L, MethodHandles.lookup().lookupClass()).a(82827957877734L);

        private AddToRequirementsFix(@NotNull PyPackageManager packageManager, @NotNull Module module2, @NotNull String packageName, @NotNull LanguageLevel languageLevel) {
            if (packageManager == null) {
                AddToRequirementsFix.a(0);
            }
            if (module2 == null) {
                AddToRequirementsFix.a(1);
            }
            if (packageName == null) {
                AddToRequirementsFix.a(2);
            }
            if (languageLevel == null) {
                AddToRequirementsFix.a(3);
            }
            this.b = packageManager;
            this.d = module2;
            this.c = packageName;
            this.a = languageLevel;
        }

        public boolean startInWriteAction() {
            return false;
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            long l2 = e ^ 0x286589344573L;
            if ("Add requirement" == null) {
                AddToRequirementsFix.a(4);
            }
            return "Add requirement";
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getName() {
            long l2 = e ^ 0x16CFAE3FBF23L;
            String string = String.format("Add requirement '%s' to %s", this.c, this.c());
            if (string == null) {
                AddToRequirementsFix.a(5);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            List<PyRequirement> list2;
            if (project == null) {
                AddToRequirementsFix.a(6);
            }
            if (descriptor2 == null) {
                AddToRequirementsFix.a(7);
            }
            if ((list2 = this.b.getRequirements(this.d)) != null && ContainerUtil.exists(list2, pyRequirement -> pyRequirement.getName().equals(this.c))) {
                return;
            }
            CommandProcessor.getInstance().executeCommand(project, () -> ApplicationManager.getApplication().runWriteAction(() -> PyPackageUtil.addRequirementToTxtOrSetupPy(this.d, this.c, this.a)), this.getName(), null);
        }

        @NotNull
        private String c() {
            long l2 = e ^ 0x24BDC323337DL;
            VirtualFile virtualFile = PyPackageUtil.findRequirementsTxt(this.d);
            if (virtualFile != null) {
                String string = virtualFile.getName();
                if (string == null) {
                    AddToRequirementsFix.a(8);
                }
                return string;
            }
            if (PyPackageUtil.findSetupCall(this.d) != null) {
                if ("setup.py" == null) {
                    AddToRequirementsFix.a(9);
                }
                return "setup.py";
            }
            if ("project requirements" == null) {
                AddToRequirementsFix.a(10);
            }
            return "project requirements";
        }

        /* synthetic */ AddToRequirementsFix(PyPackageManager x0, Module x1, String x2, LanguageLevel x3, g x4) {
            this(x0, x1, x2, x3);
        }

        private static /* synthetic */ void a(int n2) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n3;
            String string;
            long l2 = e ^ 0x1CE2110FD9C4L;
            switch (n2) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 5: 
                case 8: 
                case 9: 
                case 10: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n2) {
                default: {
                    n3 = 3;
                    break;
                }
                case 4: 
                case 5: 
                case 8: 
                case 9: 
                case 10: {
                    n3 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "packageManager";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "module";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "packageName";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "languageLevel";
                    break;
                }
                case 4: 
                case 5: 
                case 8: 
                case 9: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/inspections/PyPackageRequirementsInspection$AddToRequirementsFix";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/inspections/PyPackageRequirementsInspection$AddToRequirementsFix";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 8: 
                case 9: 
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "calculateTarget";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: 
                case 5: 
                case 8: 
                case 9: 
                case 10: {
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n2) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: 
                case 5: 
                case 8: 
                case 9: 
                case 10: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class IgnoreRequirementFix
    implements LocalQuickFix {
        @NotNull
        private final Set<String> a;
        private static final long b = c.a(3979791197572746206L, -1445445541372375237L, MethodHandles.lookup().lookupClass()).a(212273776707586L);

        private IgnoreRequirementFix(@NotNull Set<String> packageNames) {
            if (packageNames == null) {
                IgnoreRequirementFix.a(0);
            }
            this.a = packageNames;
        }

        @NotNull
        public String getFamilyName() {
            long l2 = b ^ 0x6004976E5BE1L;
            boolean bl2 = this.a.size() > 1;
            String string = String.format("Ignore requirement%s", bl2 ? "s" : "");
            if (string == null) {
                IgnoreRequirementFix.a(1);
            }
            return string;
        }

        public boolean startInWriteAction() {
            return false;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            PyPackageRequirementsInspection pyPackageRequirementsInspection;
            PsiElement psiElement;
            long l2 = b ^ 0x5AD928860DF5L;
            if (project == null) {
                IgnoreRequirementFix.a(2);
            }
            if (descriptor2 == null) {
                IgnoreRequirementFix.a(3);
            }
            if ((psiElement = descriptor2.getPsiElement()) != null && (pyPackageRequirementsInspection = PyPackageRequirementsInspection.getInstance(psiElement)) != null) {
                HashSet<String> hashSet = new HashSet<String>(this.a);
                for (String string : pyPackageRequirementsInspection.ignoredPackages) {
                    hashSet.remove(string);
                }
                if (!hashSet.isEmpty()) {
                    pyPackageRequirementsInspection.ignoredPackages.addAll(hashSet);
                    Iterator iterator = ProjectInspectionProfileManager.getInstance((Project)project);
                    iterator.fireProfileChanged();
                    a.createNotification(hashSet.size() == 1 ? "'" + (String)hashSet.iterator().next() + "' has been ignored" : "Requirements have been ignored", "<a href=\"#undo\">Undo</a>&nbsp;&nbsp;&nbsp;&nbsp;<a href=\"#settings\">Settings</a>", NotificationType.INFORMATION, (arg_0, arg_1) -> IgnoreRequirementFix.a(pyPackageRequirementsInspection, hashSet, (ProjectInspectionProfileManager)iterator, project, arg_0, arg_1)).notify(project);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private static /* synthetic */ void a(PyPackageRequirementsInspection pyPackageRequirementsInspection, Set set, ProjectInspectionProfileManager projectInspectionProfileManager, Project project, Notification notification2, HyperlinkEvent hyperlinkEvent) {
            long l2 = b ^ 0x3DEF3C41CCDFL;
            try {
                switch (hyperlinkEvent.getDescription()) {
                    case "#undo": {
                        pyPackageRequirementsInspection.ignoredPackages.removeAll((Collection)set);
                        projectInspectionProfileManager.fireProfileChanged();
                        return;
                    }
                    case "#settings": {
                        InspectionProfileImpl inspectionProfileImpl = projectInspectionProfileManager.getCurrentProfile();
                        String string = PyPackageRequirementsInspection.class.getSimpleName();
                        EditInspectionToolsSettingsAction.editToolSettings((Project)project, (InspectionProfileImpl)inspectionProfileImpl, (String)string);
                        return;
                    }
                }
                return;
            }
            finally {
                notification2.expire();
            }
        }

        /* synthetic */ IgnoreRequirementFix(Set x0, g x1) {
            this(x0);
        }

        private static /* synthetic */ void a(int n2) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n3;
            String string;
            long l2 = b ^ 0x72F5BE2F56EFL;
            switch (n2) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n2) {
                default: {
                    n3 = 3;
                    break;
                }
                case 1: {
                    n3 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "packageNames";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/inspections/PyPackageRequirementsInspection$IgnoreRequirementFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/inspections/PyPackageRequirementsInspection$IgnoreRequirementFix";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n2) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class RunningPackagingTasksListener
    implements PyPackageManagerUI.Listener {
        @NotNull
        private final Module a;
        private static final long c = com.jetbrains.python.psi.c.a(1966969796670208557L, -4712250429384362285L, MethodHandles.lookup().lookupClass()).a(269930589481916L);

        public RunningPackagingTasksListener(@NotNull Module module2) {
            if (module2 == null) {
                RunningPackagingTasksListener.a(0);
            }
            this.a = module2;
        }

        @Override
        public void started() {
            PyPackageRequirementsInspection.a(this.a, true);
        }

        @Override
        public void finished(List<ExecutionException> exceptions) {
            PyPackageRequirementsInspection.a(this.a, false);
        }

        private static /* synthetic */ void a(int n2) {
            long l2 = c ^ 0x156877E75C4CL;
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/jetbrains/python/inspections/PyPackageRequirementsInspection$RunningPackagingTasksListener", "<init>"));
        }
    }

    public static class InstallAndImportQuickFix
    implements LocalQuickFix {
        @Nullable
        private final Sdk d;
        @Nullable
        private final Module e;
        @NotNull
        private final String a;
        @Nullable
        private final String b;
        @NotNull
        private final SmartPsiElementPointer<PyElement> c;
        private static final long f = com.jetbrains.python.psi.c.a(-7900712143582384176L, 4922064492848352379L, MethodHandles.lookup().lookupClass()).a(153723535787542L);

        public InstallAndImportQuickFix(@NotNull String packageName, @Nullable String asName, @NotNull PyElement node) {
            if (packageName == null) {
                InstallAndImportQuickFix.a(0);
            }
            if (node == null) {
                InstallAndImportQuickFix.a(1);
            }
            this.a = packageName;
            this.b = asName;
            this.c = SmartPointerManager.getInstance((Project)node.getProject()).createSmartPsiElementPointer((PsiElement)node, node.getContainingFile());
            this.e = ModuleUtilCore.findModuleForPsiElement((PsiElement)node);
            this.d = PythonSdkType.findPythonSdk(this.e);
        }

        @Nls
        @NotNull
        public String getName() {
            long l2 = f ^ 0x15CB0DAED3EAL;
            String string = PyBundle.message("QFIX.NAME.install.and.import.package", this.a);
            if (string == null) {
                InstallAndImportQuickFix.a(2);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            long l2 = f ^ 0x624999B01F48L;
            String string = PyBundle.message("QFIX.install.and.import.package", new Object[0]);
            if (string == null) {
                InstallAndImportQuickFix.a(3);
            }
            return string;
        }

        public boolean startInWriteAction() {
            return false;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            if (project == null) {
                InstallAndImportQuickFix.a(4);
            }
            if (descriptor2 == null) {
                InstallAndImportQuickFix.a(5);
            }
            if (this.d == null || !PyPackageRequirementsInspection.a(project, descriptor2, this.d)) {
                this.a(project);
            }
        }

        private void a(final @NotNull Project project) {
            if (project == null) {
                InstallAndImportQuickFix.a(6);
            }
            if (this.d == null) {
                return;
            }
            PyPackageManagerUI pyPackageManagerUI = new PyPackageManagerUI(project, this.d, new RunningPackagingTasksListener(this.e){
                private static final long b = com.jetbrains.python.psi.c.a(1881288586231852940L, -2932354785100792635L, MethodHandles.lookup().lookupClass()).a(99597282373705L);

                @Override
                public void finished(List<ExecutionException> exceptions) {
                    long l2 = b ^ 0x2C039135DACFL;
                    super.finished(exceptions);
                    if (exceptions.isEmpty()) {
                        PyElement pyElement = (PyElement)c.getElement();
                        if (pyElement == null) {
                            return;
                        }
                        CommandProcessor.getInstance().executeCommand(project, () -> ApplicationManager.getApplication().runWriteAction(() -> AddImportHelper.addImportStatement(pyElement.getContainingFile(), a, b, AddImportHelper.ImportPriority.THIRD_PARTY, (PsiElement)pyElement)), "Add import", (Object)"Add import");
                    }
                }
            });
            pyPackageManagerUI.install(Collections.singletonList(PyRequirementsKt.pyRequirement(this.a)), Collections.emptyList());
        }

        private static /* synthetic */ void a(int n2) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n3;
            String string;
            long l2 = f ^ 0x3663A5A62F9CL;
            switch (n2) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n2) {
                default: {
                    n3 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n3 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "packageName";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/inspections/PyPackageRequirementsInspection$InstallAndImportQuickFix";
                    break;
                }
                case 4: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/inspections/PyPackageRequirementsInspection$InstallAndImportQuickFix";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "installAndImportPackage";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n2) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class PyInstallRequirementsFix
    implements LocalQuickFix {
        @NotNull
        private final String e;
        @NotNull
        private final Module f;
        @NotNull
        private final Sdk a;
        @NotNull
        private final List<PyRequirement> b;
        @NotNull
        private final List<String> c;
        @Nullable
        private final PyPackageManagerUI.Listener d;
        private static final long g = com.jetbrains.python.psi.c.a(4628908735194384560L, 564249070897599488L, MethodHandles.lookup().lookupClass()).a(121592282459366L);

        public PyInstallRequirementsFix(@Nullable String name, @NotNull Module module2, @NotNull Sdk sdk, @NotNull List<PyRequirement> unsatisfied) {
            if (module2 == null) {
                PyInstallRequirementsFix.a(0);
            }
            if (sdk == null) {
                PyInstallRequirementsFix.a(1);
            }
            if (unsatisfied == null) {
                PyInstallRequirementsFix.a(2);
            }
            this(name, module2, sdk, unsatisfied, Collections.emptyList(), null);
        }

        public PyInstallRequirementsFix(@Nullable String name, @NotNull Module module2, @NotNull Sdk sdk, @NotNull List<PyRequirement> unsatisfied, @NotNull List<String> extraArgs, @Nullable PyPackageManagerUI.Listener listener2) {
            boolean bl2;
            long l2 = g ^ 0x319A7B82A638L;
            if (module2 == null) {
                PyInstallRequirementsFix.a(3);
            }
            if (sdk == null) {
                PyInstallRequirementsFix.a(4);
            }
            if (unsatisfied == null) {
                PyInstallRequirementsFix.a(5);
            }
            if (extraArgs == null) {
                PyInstallRequirementsFix.a(6);
            }
            boolean bl3 = bl2 = unsatisfied.size() > 1;
            this.e = name != null ? name : String.format("Install requirement%s", bl2 ? "s" : "");
            this.f = module2;
            this.a = sdk;
            this.b = unsatisfied;
            this.c = extraArgs;
            this.d = listener2;
        }

        @NotNull
        public String getFamilyName() {
            String string = this.e;
            if (string == null) {
                PyInstallRequirementsFix.a(7);
            }
            return string;
        }

        public boolean startInWriteAction() {
            return false;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            if (project == null) {
                PyInstallRequirementsFix.a(8);
            }
            if (descriptor2 == null) {
                PyInstallRequirementsFix.a(9);
            }
            if (!PyPackageRequirementsInspection.a(project, descriptor2, this.a)) {
                this.a(project);
            }
        }

        private void a(final @NotNull Project project) {
            boolean bl2;
            PyChooseRequirementsDialog pyChooseRequirementsDialog;
            PyPackageManager pyPackageManager;
            List<PyPackage> list2;
            if (project == null) {
                PyInstallRequirementsFix.a(10);
            }
            if ((list2 = (pyPackageManager = PyPackageManager.getInstance(this.a)).getPackages()) == null) {
                return;
            }
            final List<PyRequirement> list3 = this.b.size() > 1 ? ((pyChooseRequirementsDialog = new PyChooseRequirementsDialog(project, this.b)).showAndGet() ? pyChooseRequirementsDialog.getMarkedElements() : Collections.emptyList()) : this.b;
            if (list3.isEmpty()) {
                return;
            }
            try {
                bl2 = pyPackageManager.hasManagement();
            }
            catch (ExecutionException executionException) {
                bl2 = false;
            }
            if (!bl2) {
                PyPackageManagerUI pyPackageManagerUI = new PyPackageManagerUI(project, this.a, new RunningPackagingTasksListener(this.f){

                    @Override
                    public void finished(List<ExecutionException> exceptions) {
                        super.finished(exceptions);
                        if (exceptions.isEmpty()) {
                            this.a(project, list3);
                        }
                    }
                });
                pyPackageManagerUI.installManagement();
            } else {
                this.a(project, list3);
            }
        }

        private void a(Project project, List<PyRequirement> list2) {
            RunningPackagingTasksListener runningPackagingTasksListener = this.d == null ? new RunningPackagingTasksListener(this.f) : new RunningPackagingTasksListener(this.f){

                @Override
                public void started() {
                    super.started();
                    d.started();
                }

                @Override
                public void finished(List<ExecutionException> exceptions) {
                    super.finished(exceptions);
                    d.finished(exceptions);
                }
            };
            new PyPackageManagerUI(project, this.a, runningPackagingTasksListener).install(list2, this.c);
        }

        private static /* synthetic */ void a(int n2) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n3;
            String string;
            long l2 = g ^ 0x62750E6BFB4BL;
            switch (n2) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 7: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n2) {
                default: {
                    n3 = 3;
                    break;
                }
                case 7: {
                    n3 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "module";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sdk";
                    break;
                }
                case 2: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "unsatisfied";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "extraArgs";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/inspections/PyPackageRequirementsInspection$PyInstallRequirementsFix";
                    break;
                }
                case 8: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/inspections/PyPackageRequirementsInspection$PyInstallRequirementsFix";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 7: {
                    break;
                }
                case 8: 
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "installPackages";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n2) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 7: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class Visitor
    extends PyInspectionVisitor {
        private final Set<String> c;
        private static final long d = com.jetbrains.python.psi.c.a(-8689149549138774056L, -5435889173572080957L, MethodHandles.lookup().lookupClass()).a(231854552481564L);

        Visitor(@Nullable ProblemsHolder holder, @NotNull LocalInspectionToolSession session, Collection<String> ignoredPackages) {
            if (session == null) {
                Visitor.b(0);
            }
            super(holder, session);
            this.c = ImmutableSet.copyOf(ignoredPackages);
        }

        @Override
        public void visitPyFile(PyFile node) {
            this.a((PsiElement)node, ModuleUtilCore.findModuleForPsiElement((PsiElement)node));
        }

        public void visitPlainTextFile(PsiPlainTextFile file) {
            Module module2 = ModuleUtilCore.findModuleForPsiElement((PsiElement)file);
            if (module2 != null && file.getVirtualFile().equals(PyPackageUtil.findRequirementsTxt(module2))) {
                this.a((PsiElement)file, module2);
            }
        }

        private void a(@NotNull PsiElement psiElement, @Nullable Module module2) {
            List list2;
            Sdk sdk;
            long l2 = d ^ 0x4E7EBDDDEECFL;
            if (psiElement == null) {
                Visitor.b(1);
            }
            if (module2 != null && !PyPackageRequirementsInspection.a(module2) && (sdk = PythonSdkType.findPythonSdk(module2)) != null && (list2 = PyPackageRequirementsInspection.a(module2, sdk, this.c)) != null && !list2.isEmpty()) {
                boolean bl2 = list2.size() > 1;
                String string = String.format("Package requirement%s %s %s not satisfied", bl2 ? "s" : "", PyPackageUtil.requirementsToString(list2), bl2 ? "are" : "is");
                HashSet<String> hashSet = new HashSet<String>();
                for (PyRequirement pyRequirement : list2) {
                    hashSet.add(pyRequirement.getName() + pyRequirement.getExtras());
                }
                ArrayList arrayList = new ArrayList();
                if (PipenvKt.isPipEnv(sdk)) {
                    arrayList.add(new PipEnvInstallQuickFix());
                } else {
                    arrayList.add(new PyInstallRequirementsFix(null, module2, sdk, list2));
                }
                arrayList.add(new IgnoreRequirementFix(hashSet, null));
                this.registerProblem(psiElement, string, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, null, arrayList.toArray(LocalQuickFix.EMPTY_ARRAY));
            }
        }

        @Override
        public void visitPyFromImportStatement(PyFromImportStatement node) {
            PyReferenceExpression pyReferenceExpression = node.getImportSource();
            if (pyReferenceExpression != null) {
                this.a(pyReferenceExpression);
            }
        }

        @Override
        public void visitPyImportStatement(PyImportStatement node) {
            for (PyImportElement pyImportElement : node.getImportElements()) {
                PyReferenceExpression pyReferenceExpression = pyImportElement.getImportReferenceExpression();
                if (pyReferenceExpression == null) continue;
                this.a(pyReferenceExpression);
            }
        }

        private void a(@NotNull PyQualifiedExpression pyQualifiedExpression) {
            block18: {
                String string2;
                String string3;
                PyRequirement pyRequirement;
                Object object2;
                long l2 = d ^ 0x31CD5BA1CE10L;
                if (pyQualifiedExpression == null) {
                    Visitor.b(2);
                }
                for (Object object2 : PyInspectionExtension.EP_NAME.getExtensionList()) {
                    if (!((PyInspectionExtension)object2).ignorePackageNameInRequirements(pyQualifiedExpression)) continue;
                    return;
                }
                PyExpression pyExpression = PyPsiUtils.getFirstQualifier(pyQualifiedExpression);
                object2 = pyExpression.getName();
                if (object2 == null || this.c.contains(object2)) break block18;
                List list2 = (List)PyPIPackageUtil.PACKAGES_TOPLEVEL.getOrDefault(object2, Collections.emptyList());
                if (!ApplicationManager.getApplication().isUnitTestMode() && !PyPIPackageUtil.INSTANCE.isInPyPI((String)object2)) {
                    if (!ContainerUtil.exists((Iterable)list2, PyPIPackageUtil.INSTANCE::isInPyPI)) {
                        return;
                    }
                }
                if ("setuptools".equals(object2)) {
                    return;
                }
                Collection<String> collection = PyStdlibUtil.getPackages();
                if (collection != null && collection.contains(object2)) {
                    return;
                }
                Module module2 = ModuleUtilCore.findModuleForPsiElement((PsiElement)pyExpression);
                if (module2 == null) {
                    return;
                }
                Sdk sdk = PythonSdkType.findPythonSdk(module2);
                if (sdk == null) {
                    return;
                }
                PyPackageManager pyPackageManager = PyPackageManager.getInstance(sdk);
                Set set = PyPackageRequirementsInspection.a(pyPackageManager, module2);
                if (set == null) {
                    return;
                }
                Object object3 = set.iterator();
                while (object3.hasNext()) {
                    block20: {
                        block19: {
                            pyRequirement = (PyRequirement)object3.next();
                            string3 = pyRequirement.getName();
                            if (string3.equalsIgnoreCase((String)object2)) break block19;
                            if (!ContainerUtil.exists((Iterable)list2, string3::equalsIgnoreCase)) break block20;
                        }
                        return;
                    }
                    string2 = string3.replaceAll("_", "-");
                    if (ContainerUtil.exists((Iterable)list2, string2::equalsIgnoreCase)) {
                        return;
                    }
                    String string4 = string3.replaceAll("-", "_");
                    if (!string4.equalsIgnoreCase((String)object2)) {
                        if (!ContainerUtil.exists((Iterable)list2, string4::equalsIgnoreCase)) continue;
                    }
                    return;
                }
                if (!ApplicationManager.getApplication().isUnitTestMode() && (object3 = pyExpression.getReference()) != null) {
                    pyRequirement = object3.resolve();
                    if (pyRequirement instanceof PsiDirectory && ModuleUtilCore.moduleContainsFile((Module)module2, (VirtualFile)((PsiDirectory)pyRequirement).getVirtualFile(), (boolean)false)) {
                        return;
                    }
                    if (pyRequirement != null && (string3 = pyRequirement.getContainingFile()) != null && ModuleUtilCore.moduleContainsFile((Module)module2, (VirtualFile)(string2 = string3.getVirtualFile()), (boolean)false)) {
                        return;
                    }
                }
                object3 = new ArrayList();
                ((StreamEx)StreamEx.of((Object)object2).append((Collection)list2).filter(PyPIPackageUtil.INSTANCE::isInPyPI)).map(string -> new AddToRequirementsFix(pyPackageManager, module2, (String)string, LanguageLevel.forElement((PsiElement)pyQualifiedExpression), null)).forEach(((List)object3)::add);
                object3.add(new IgnoreRequirementFix(Collections.singleton(object2), null));
                this.registerProblem((PsiElement)pyExpression, String.format("Package containing module '%s' is not listed in project requirements", object2), ProblemHighlightType.WEAK_WARNING, null, object3.toArray(LocalQuickFix.EMPTY_ARRAY));
            }
        }

        private static /* synthetic */ void b(int n2) {
            Object[] objectArray;
            Object[] objectArray2;
            long l2 = d ^ 0x2C5DCDA98770L;
            Object[] objectArray3 = new Object[3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "session";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "importedExpression";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/python/inspections/PyPackageRequirementsInspection$Visitor";
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "checkPackagesHaveBeenInstalled";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "checkPackageNameInRequirements";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

