/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.ui.CheckBox;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.PythonFileType;
import com.jetbrains.python.inspections.PyEncodingUtil;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.inspections.quickfix.AddEncodingQuickFix;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.c;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.invoke.MethodHandles;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class PyMandatoryEncodingInspection
extends PyInspection {
    public String myDefaultEncoding = "utf-8";
    public int myEncodingFormatIndex = 0;
    public boolean myAllPythons = false;
    private static final long a = c.a(250290443845595056L, 5815780481421151065L, MethodHandles.lookup().lookupClass()).a(233420432735909L);

    @Nls
    @NotNull
    public String getDisplayName() {
        long l2 = a ^ 0x218BAB9421EEL;
        String string = PyBundle.message("INSP.NAME.mandatory.encoding", new Object[0]);
        if (string == null) {
            PyMandatoryEncodingInspection.b(0);
        }
        return string;
    }

    @Override
    public boolean isEnabledByDefault() {
        return true;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            PyMandatoryEncodingInspection.b(1);
        }
        if (session == null) {
            PyMandatoryEncodingInspection.b(2);
        }
        Visitor visitor2 = new Visitor(holder, session);
        if (visitor2 == null) {
            PyMandatoryEncodingInspection.b(3);
        }
        return visitor2;
    }

    public JComponent createOptionsPanel() {
        long l2 = a ^ 0x173633E50E32L;
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.add((Component)this.e(), PyMandatoryEncodingInspection.d(0));
        jPanel.add((Component)PyMandatoryEncodingInspection.d(), PyMandatoryEncodingInspection.d(1));
        jPanel.add(this.b(), PyMandatoryEncodingInspection.c(1));
        jPanel.add((Component)PyMandatoryEncodingInspection.c(), PyMandatoryEncodingInspection.d(2));
        jPanel.add(this.a(), PyMandatoryEncodingInspection.c(2));
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)jPanel, "North");
        return jPanel2;
    }

    @NotNull
    private static GridBagConstraints d(int n2) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n2;
        GridBagConstraints gridBagConstraints2 = gridBagConstraints;
        if (gridBagConstraints2 == null) {
            PyMandatoryEncodingInspection.b(4);
        }
        return gridBagConstraints2;
    }

    @NotNull
    private static GridBagConstraints c(int n2) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = n2;
        GridBagConstraints gridBagConstraints2 = gridBagConstraints;
        if (gridBagConstraints2 == null) {
            PyMandatoryEncodingInspection.b(5);
        }
        return gridBagConstraints2;
    }

    @NotNull
    private JPanel e() {
        long l2 = a ^ 0x782E684CA829L;
        JPanel jPanel = new JPanel(new FlowLayout(0));
        jPanel.add((Component)new CheckBox("Enable in Python 3+", (InspectionProfileEntry)this, "myAllPythons"));
        JPanel jPanel2 = jPanel;
        if (jPanel2 == null) {
            PyMandatoryEncodingInspection.b(6);
        }
        return jPanel2;
    }

    @NotNull
    private static JPanel d() {
        long l2 = a ^ 0x58C6EA8C92AFL;
        JPanel jPanel = new JPanel(new FlowLayout(0));
        jPanel.add(new JLabel("Select default encoding: "));
        JPanel jPanel2 = jPanel;
        if (jPanel2 == null) {
            PyMandatoryEncodingInspection.b(7);
        }
        return jPanel2;
    }

    @NotNull
    private JComboBox<String> b() {
        ComboBox comboBox = new ComboBox((Object[])PyEncodingUtil.POSSIBLE_ENCODINGS);
        comboBox.setSelectedItem(this.myDefaultEncoding);
        comboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e10) {
                JComboBox jComboBox = (JComboBox)e10.getSource();
                PyMandatoryEncodingInspection.this.myDefaultEncoding = (String)jComboBox.getSelectedItem();
            }
        });
        ComboBox comboBox2 = comboBox;
        if (comboBox2 == null) {
            PyMandatoryEncodingInspection.b(8);
        }
        return comboBox2;
    }

    @NotNull
    private static JPanel c() {
        long l2 = a ^ 0x1A0C8E330EEL;
        JPanel jPanel = new JPanel(new FlowLayout(0));
        jPanel.add(new JLabel("Encoding comment format:"));
        JPanel jPanel2 = jPanel;
        if (jPanel2 == null) {
            PyMandatoryEncodingInspection.b(9);
        }
        return jPanel2;
    }

    @NotNull
    private JComboBox<String> a() {
        ComboBox comboBox = new ComboBox((Object[])PyEncodingUtil.ENCODING_FORMAT, 250);
        comboBox.setSelectedIndex(this.myEncodingFormatIndex);
        comboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e10) {
                JComboBox jComboBox = (JComboBox)e10.getSource();
                PyMandatoryEncodingInspection.this.myEncodingFormatIndex = jComboBox.getSelectedIndex();
            }
        });
        ComboBox comboBox2 = comboBox;
        if (comboBox2 == null) {
            PyMandatoryEncodingInspection.b(10);
        }
        return comboBox2;
    }

    private static /* synthetic */ void b(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = a ^ 0x5F05D4971529L;
        switch (n2) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 2;
                break;
            }
            case 1: 
            case 2: {
                n3 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/inspections/PyMandatoryEncodingInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/inspections/PyMandatoryEncodingInspection";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "fixedIn";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "resizableIn";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "onlyPython2Box";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "defaultEncodingLabel";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "defaultEncodingBox";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "encodingFormatLabel";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "encodingFormatBox";
                break;
            }
        }
        switch (n2) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class Visitor
    extends PyInspectionVisitor {
        private static final long c = com.jetbrains.python.psi.c.a(4282493284149484675L, -6080183465777176624L, MethodHandles.lookup().lookupClass()).a(226483517107439L);

        Visitor(@NotNull ProblemsHolder holder, LocalInspectionToolSession session) {
            if (session == null) {
                Visitor.b(0);
            }
            super(holder, session);
        }

        @Override
        public void visitPyFile(PyFile node) {
            long l2 = c ^ 0x2E1995910ABBL;
            if (!PyMandatoryEncodingInspection.this.myAllPythons && !LanguageLevel.forElement((PsiElement)node).isPython2()) {
                return;
            }
            String string = PythonFileType.getCharsetFromEncodingDeclaration(node);
            if (string == null) {
                TextRange textRange = new TextRange(0, 0);
                ProblemsHolder problemsHolder = this.getHolder();
                if (problemsHolder != null) {
                    problemsHolder.registerProblem((PsiElement)node, textRange, "No encoding specified for file", new LocalQuickFix[]{new AddEncodingQuickFix(PyMandatoryEncodingInspection.this.myDefaultEncoding, PyMandatoryEncodingInspection.this.myEncodingFormatIndex)});
                }
            }
        }

        private static /* synthetic */ void b(int n2) {
            long l2 = c ^ 0x194FBB579486L;
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/jetbrains/python/inspections/PyMandatoryEncodingInspection$Visitor", "<init>"));
        }
    }
}

