/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.SmartList;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.codeInsight.override.PyOverrideImplementUtil;
import com.jetbrains.python.codeInsight.typing.PyProtocolsKt;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.inspections.c;
import com.jetbrains.python.inspections.quickfix.PyImplementMethodsQuickFix;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyKnownDecoratorUtil;
import com.jetbrains.python.psi.PyPsiFacade;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.types.PyClassLikeType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import com.jetbrains.python.refactoring.classes.PyClassRefactoringUtil;
import java.lang.invoke.MethodHandles;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class PyAbstractClassInspection
extends PyInspection {
    private static final long a = com.jetbrains.python.psi.c.a(-1586320457821717404L, 9217960348528972668L, MethodHandles.lookup().lookupClass()).a(118823631098641L);

    @Nls
    @NotNull
    public String getDisplayName() {
        long l2 = a ^ 0x36AE9CB000DAL;
        String string = PyBundle.message("INSP.NAME.abstract.class", new Object[0]);
        if (string == null) {
            PyAbstractClassInspection.b(0);
        }
        return string;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            PyAbstractClassInspection.b(1);
        }
        if (session == null) {
            PyAbstractClassInspection.b(2);
        }
        Visitor visitor2 = new Visitor(holder, session, null);
        if (visitor2 == null) {
            PyAbstractClassInspection.b(3);
        }
        return visitor2;
    }

    private static /* synthetic */ void b(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = a ^ 0x16679A8CEFB9L;
        switch (n2) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 2;
                break;
            }
            case 1: 
            case 2: {
                n3 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/inspections/PyAbstractClassInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/inspections/PyAbstractClassInspection";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n2) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Visitor
    extends PyInspectionVisitor {
        private static final long c = com.jetbrains.python.psi.c.a(-7314054622127811254L, 806389218426805881L, MethodHandles.lookup().lookupClass()).a(201579310315257L);

        private Visitor(@NotNull ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
            if (holder == null) {
                Visitor.b(0);
            }
            if (session == null) {
                Visitor.b(1);
            }
            super(holder, session);
        }

        @Override
        public void visitPyClass(PyClass pyClass) {
            long l2 = c ^ 0x4DEA2DF8BA38L;
            if (this.a(pyClass) || PyProtocolsKt.isProtocol(pyClass, this.myTypeEvalContext)) {
                return;
            }
            List<PyFunction> list2 = PyOverrideImplementUtil.getAllSuperAbstractMethods(pyClass, this.myTypeEvalContext);
            ASTNode aSTNode = pyClass.getNameNode();
            if (!list2.isEmpty() && aSTNode != null) {
                SmartList smartList = new SmartList((Object[])new LocalQuickFix[]{new PyImplementMethodsQuickFix(pyClass, list2), new SetABCMetaAsMetaclassQuickFix(null)});
                if (LanguageLevel.forElement((PsiElement)pyClass).isPy3K()) {
                    smartList.add((Object)new AddABCToSuperclassesQuickFix(null));
                }
                this.registerProblem(aSTNode.getPsi(), PyBundle.message("INSP.NAME.abstract.class.$0.must.implement", pyClass.getName()), (LocalQuickFix[])smartList.toArray((Object[])LocalQuickFix.EMPTY_ARRAY));
            }
        }

        private boolean a(@NotNull PyClass pyClass) {
            PyClassLikeType pyClassLikeType;
            long l2 = c ^ 0x57D32F45F097L;
            if (pyClass == null) {
                Visitor.b(2);
            }
            if ((pyClassLikeType = pyClass.getMetaClassType(false, this.myTypeEvalContext)) != null && "ABCMeta".equals(pyClassLikeType.getName())) {
                return true;
            }
            for (PyClassLikeType pyClassLikeType2 : pyClass.getSuperClassTypes(this.myTypeEvalContext)) {
                if (pyClassLikeType2 == null || !"abc.ABC".equals(pyClassLikeType2.getClassQName())) continue;
                return true;
            }
            for (PyFunction pyFunction : pyClass.getMethods()) {
                if (!PyKnownDecoratorUtil.hasAbstractDecorator(pyFunction, this.myTypeEvalContext)) continue;
                return true;
            }
            return false;
        }

        /* synthetic */ Visitor(ProblemsHolder x0, LocalInspectionToolSession x1, c x2) {
            this(x0, x1);
        }

        private static /* synthetic */ void b(int n2) {
            Object[] objectArray;
            Object[] objectArray2;
            long l2 = c ^ 0x72E8E96B7F5CL;
            Object[] objectArray3 = new Object[3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "holder";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "session";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pyClass";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/python/inspections/PyAbstractClassInspection$Visitor";
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isAbstract";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        private static class SetABCMetaAsMetaclassQuickFix
        implements LocalQuickFix {
            private static final long a = com.jetbrains.python.psi.c.a(-523870143074733829L, -7514444642703404875L, MethodHandles.lookup().lookupClass()).a(118395198924857L);

            private SetABCMetaAsMetaclassQuickFix() {
            }

            @Nls(capitalization=Nls.Capitalization.Sentence)
            @NotNull
            public String getFamilyName() {
                long l2 = a ^ 0x13D8303BA7EFL;
                if ("Set 'abc.ABCMeta' as metaclass" == null) {
                    SetABCMetaAsMetaclassQuickFix.a(0);
                }
                return "Set 'abc.ABCMeta' as metaclass";
            }

            public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
                PyClass pyClass;
                long l2 = a ^ 0x229493B512A0L;
                if (project == null) {
                    SetABCMetaAsMetaclassQuickFix.a(1);
                }
                if (descriptor2 == null) {
                    SetABCMetaAsMetaclassQuickFix.a(2);
                }
                if ((pyClass = PyUtil.as(descriptor2.getPsiElement().getParent(), PyClass.class)) == null) {
                    return;
                }
                PyClass pyClass2 = PyPsiFacade.getInstance(project).createClassByQName("abc.ABCMeta", (PsiElement)pyClass);
                if (pyClass2 == null) {
                    return;
                }
                TypeEvalContext typeEvalContext = TypeEvalContext.userInitiated(pyClass.getProject(), pyClass.getContainingFile());
                PyClassRefactoringUtil.addMetaClassIfNotExist(pyClass, pyClass2, typeEvalContext);
            }

            /* synthetic */ SetABCMetaAsMetaclassQuickFix(c x0) {
                this();
            }

            private static /* synthetic */ void a(int n2) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n3;
                String string;
                long l2 = a ^ 0x47D5F741D412L;
                switch (n2) {
                    default: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 1: 
                    case 2: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n2) {
                    default: {
                        n3 = 2;
                        break;
                    }
                    case 1: 
                    case 2: {
                        n3 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n3];
                switch (n2) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/python/inspections/PyAbstractClassInspection$Visitor$SetABCMetaAsMetaclassQuickFix";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "descriptor";
                        break;
                    }
                }
                switch (n2) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getFamilyName";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/python/inspections/PyAbstractClassInspection$Visitor$SetABCMetaAsMetaclassQuickFix";
                        break;
                    }
                }
                switch (n2) {
                    default: {
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "applyFix";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n2) {
                    default: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                    case 1: 
                    case 2: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }

        private static class AddABCToSuperclassesQuickFix
        implements LocalQuickFix {
            private static final long a = com.jetbrains.python.psi.c.a(-4849649324997495848L, 5845200147783462977L, MethodHandles.lookup().lookupClass()).a(63676995778736L);

            private AddABCToSuperclassesQuickFix() {
            }

            @Nls(capitalization=Nls.Capitalization.Sentence)
            @NotNull
            public String getFamilyName() {
                long l2 = a ^ 0x7744523B1EEEL;
                if ("Add 'abc.ABC' to superclasses" == null) {
                    AddABCToSuperclassesQuickFix.a(0);
                }
                return "Add 'abc.ABC' to superclasses";
            }

            public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
                PyClass pyClass;
                long l2 = a ^ 0x666CC1313C03L;
                if (project == null) {
                    AddABCToSuperclassesQuickFix.a(1);
                }
                if (descriptor2 == null) {
                    AddABCToSuperclassesQuickFix.a(2);
                }
                if ((pyClass = PyUtil.as(descriptor2.getPsiElement().getParent(), PyClass.class)) == null) {
                    return;
                }
                PyClass pyClass2 = PyPsiFacade.getInstance(project).createClassByQName("abc.ABC", (PsiElement)pyClass);
                if (pyClass2 == null) {
                    return;
                }
                PyClassRefactoringUtil.addSuperclasses(project, pyClass, pyClass2);
            }

            /* synthetic */ AddABCToSuperclassesQuickFix(c x0) {
                this();
            }

            private static /* synthetic */ void a(int n2) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n3;
                String string;
                long l2 = a ^ 0xE2650737B97L;
                switch (n2) {
                    default: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 1: 
                    case 2: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n2) {
                    default: {
                        n3 = 2;
                        break;
                    }
                    case 1: 
                    case 2: {
                        n3 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n3];
                switch (n2) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/python/inspections/PyAbstractClassInspection$Visitor$AddABCToSuperclassesQuickFix";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "descriptor";
                        break;
                    }
                }
                switch (n2) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getFamilyName";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/python/inspections/PyAbstractClassInspection$Visitor$AddABCToSuperclassesQuickFix";
                        break;
                    }
                }
                switch (n2) {
                    default: {
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "applyFix";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n2) {
                    default: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                    case 1: 
                    case 2: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }
    }
}

