/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.editor;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.editorActions.AutoHardWrapHandler;
import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegate;
import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegateAdapter;
import com.intellij.ide.DataManager;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.lang.ASTNode;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actions.SplitLineAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.LineTokenizer;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.TokenType;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.codeInsight.PyCodeInsightSettings;
import com.jetbrains.python.documentation.docstrings.DocStringFormat;
import com.jetbrains.python.documentation.docstrings.DocStringUtil;
import com.jetbrains.python.documentation.docstrings.GoogleCodeStyleDocString;
import com.jetbrains.python.documentation.docstrings.GoogleCodeStyleDocStringBuilder;
import com.jetbrains.python.documentation.docstrings.PyDocstringGenerator;
import com.jetbrains.python.documentation.docstrings.SectionBasedDocString;
import com.jetbrains.python.psi.PyArgumentList;
import com.jetbrains.python.psi.PyDecoratorList;
import com.jetbrains.python.psi.PyDictCompExpression;
import com.jetbrains.python.psi.PyDictLiteralExpression;
import com.jetbrains.python.psi.PyDocStringOwner;
import com.jetbrains.python.psi.PyFStringFragment;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFromImportStatement;
import com.jetbrains.python.psi.PyGeneratorExpression;
import com.jetbrains.python.psi.PyIndentUtil;
import com.jetbrains.python.psi.PyListCompExpression;
import com.jetbrains.python.psi.PyListLiteralExpression;
import com.jetbrains.python.psi.PyParameterList;
import com.jetbrains.python.psi.PyParenthesizedExpression;
import com.jetbrains.python.psi.PySetCompExpression;
import com.jetbrains.python.psi.PySetLiteralExpression;
import com.jetbrains.python.psi.PySliceExpression;
import com.jetbrains.python.psi.PyStatement;
import com.jetbrains.python.psi.PyStatementList;
import com.jetbrains.python.psi.PyStringElement;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyStringLiteralUtil;
import com.jetbrains.python.psi.PySubscriptionExpression;
import com.jetbrains.python.psi.PyTupleExpression;
import com.jetbrains.python.psi.c;
import java.lang.invoke.MethodHandles;
import java.util.regex.Matcher;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PythonEnterHandler
extends EnterHandlerDelegateAdapter {
    private int a = 0;
    public static final Class[] IMPLICIT_WRAP_CLASSES;
    private static final Class[] b;
    private static final long c;

    public EnterHandlerDelegate.Result preprocessEnter(@NotNull PsiFile file, @NotNull Editor editor2, @NotNull Ref<Integer> caretOffset, @NotNull Ref<Integer> caretAdvance, @NotNull DataContext dataContext, EditorActionHandler originalHandler) {
        Object object;
        PsiElement psiElement;
        long l2 = c ^ 0x1E7E1C6E4883L;
        if (file == null) {
            PythonEnterHandler.a(0);
        }
        if (editor2 == null) {
            PythonEnterHandler.a(1);
        }
        if (caretOffset == null) {
            PythonEnterHandler.a(2);
        }
        if (caretAdvance == null) {
            PythonEnterHandler.a(3);
        }
        if (dataContext == null) {
            PythonEnterHandler.a(4);
        }
        int n2 = (Integer)caretOffset.get();
        if (editor2 instanceof EditorWindow) {
            file = InjectedLanguageManager.getInstance((Project)file.getProject()).getTopLevelFile((PsiElement)file);
            editor2 = InjectedLanguageUtil.getTopLevelEditor((Editor)editor2);
            n2 = editor2.getCaretModel().getOffset();
        }
        if (!(file instanceof PyFile)) {
            return EnterHandlerDelegate.Result.Continue;
        }
        Boolean bl2 = (Boolean)DataManager.getInstance().loadFromDataContext(dataContext, SplitLineAction.SPLIT_LINE_KEY);
        if (bl2 != null) {
            return EnterHandlerDelegate.Result.Continue;
        }
        Document document = editor2.getDocument();
        PsiDocumentManager.getInstance((Project)file.getProject()).commitDocument(document);
        PsiElement psiElement2 = file.findElementAt(n2);
        PsiElement psiElement3 = n2 > 0 ? file.findElementAt(n2 - 1) : null;
        CodeInsightSettings codeInsightSettings = CodeInsightSettings.getInstance();
        if (codeInsightSettings.JAVADOC_STUB_ON_ENTER) {
            psiElement = psiElement2;
            if (psiElement == null && n2 != 0) {
                psiElement = psiElement3;
            }
            int n3 = editor2.getCaretModel().getOffset() - 3;
            if (psiElement != null && (object = PythonEnterHandler.canGenerateDocstring(psiElement, n3, document)) != DocstringState.NONE) {
                PythonEnterHandler.a(editor2, psiElement, (DocstringState)((Object)object));
                return EnterHandlerDelegate.Result.Continue;
            }
        }
        if (psiElement2 == null) {
            return EnterHandlerDelegate.Result.Continue;
        }
        psiElement = psiElement2.getNode();
        PsiElement psiElement4 = psiElement2.getParent();
        object = psiElement.getElementType();
        if (object == PyTokenTypes.LPAR) {
            psiElement4 = psiElement4.getParent();
        }
        if (psiElement4 instanceof PyParenthesizedExpression || psiElement4 instanceof PyGeneratorExpression) {
            return EnterHandlerDelegate.Result.Continue;
        }
        PyStringElement pyStringElement = (PyStringElement)PsiTreeUtil.getParentOfType((PsiElement)psiElement2, PyStringElement.class, (boolean)false);
        if (pyStringElement == null && psiElement3 == psiElement2) {
            return EnterHandlerDelegate.Result.Continue;
        }
        if (!(pyStringElement == null || pyStringElement.isFormatted() && object != PyTokenTypes.FSTRING_TEXT && object != PyTokenTypes.FSTRING_FRAGMENT_START && object != PyTokenTypes.FSTRING_END)) {
            if (pyStringElement.isTripleQuoted() || object == PyTokenTypes.DOCSTRING) {
                return EnterHandlerDelegate.Result.Continue;
            }
            if (psiElement3 != null && PsiTreeUtil.isAncestor((PsiElement)pyStringElement, (PsiElement)psiElement3, (boolean)false)) {
                boolean bl3;
                if (pyStringElement.getTextOffset() + pyStringElement.getPrefixLength() >= n2) {
                    return EnterHandlerDelegate.Result.Continue;
                }
                String string = pyStringElement.getPrefix();
                String string2 = pyStringElement.getQuote();
                boolean bl4 = "\\".equals(document.getText(TextRange.from((int)(n2 - 1), (int)1)));
                boolean bl5 = string2.equals(document.getText(TextRange.from((int)n2, (int)1))) && bl4;
                boolean bl6 = bl3 = "\\".equals(document.getText(TextRange.from((int)(n2 - 2), (int)1))) && bl4;
                if (bl4 && !bl5 && !bl3) {
                    return EnterHandlerDelegate.Result.Continue;
                }
                this.a = string.length() + string2.length();
                if (PsiTreeUtil.getParentOfType((PsiElement)pyStringElement, (Class[])IMPLICIT_WRAP_CLASSES) != null) {
                    document.insertString(n2, (CharSequence)(string2 + string + string2));
                    caretOffset.set((Object)((Integer)caretOffset.get() + 1));
                } else {
                    int n4 = n2;
                    if (bl5) {
                        caretOffset.set((Object)((Integer)caretOffset.get() + 1));
                        ++n4;
                    }
                    document.insertString(n4, (CharSequence)(string2 + " \\" + string + string2));
                    caretOffset.set((Object)((Integer)caretOffset.get() + 3));
                }
                return EnterHandlerDelegate.Result.Continue;
            }
        }
        if (!PyCodeInsightSettings.getInstance().INSERT_BACKSLASH_ON_WRAP) {
            return EnterHandlerDelegate.Result.Continue;
        }
        return PythonEnterHandler.a(file, caretOffset, dataContext, n2, document);
    }

    private static EnterHandlerDelegate.Result a(PsiFile psiFile, Ref<Integer> ref, DataContext dataContext, int n2, Document document) {
        boolean bl2;
        boolean bl3 = bl2 = DataManager.getInstance().loadFromDataContext(dataContext, AutoHardWrapHandler.AUTO_WRAP_LINE_IN_PROGRESS_KEY) != null;
        if (PythonEnterHandler.needInsertBackslash(psiFile, n2, bl2)) {
            document.insertString(n2, (CharSequence)"\\");
            ref.set((Object)((Integer)ref.get() + 1));
        }
        return EnterHandlerDelegate.Result.Continue;
    }

    public static boolean needInsertBackslash(PsiFile file, int offset, boolean autoWrapInProgress) {
        PsiElement psiElement;
        if (offset > 0 && (psiElement = file.findElementAt(offset - 1)) instanceof PsiWhiteSpace && psiElement.getText().indexOf(92) >= 0) {
            return false;
        }
        psiElement = file.findElementAt(offset);
        if (psiElement == null) {
            return false;
        }
        ASTNode aSTNode = psiElement.getNode();
        return PythonEnterHandler.needInsertBackslash(aSTNode, autoWrapInProgress);
    }

    public static boolean needInsertBackslash(ASTNode nodeAtCaret, boolean autoWrapInProgress) {
        PsiElement psiElement;
        PsiElement psiElement2;
        if (PsiTreeUtil.getParentOfType((PsiElement)nodeAtCaret.getPsi(), PyFStringFragment.class) != null) {
            return false;
        }
        PsiElement psiElement3 = PythonEnterHandler.b(nodeAtCaret);
        if (psiElement3 != (psiElement2 = PythonEnterHandler.a(nodeAtCaret))) {
            return false;
        }
        if (psiElement3 == null) {
            return false;
        }
        if (PsiTreeUtil.hasErrorElements((PsiElement)psiElement3) && !autoWrapInProgress) {
            return false;
        }
        if (PythonEnterHandler.a(psiElement3, nodeAtCaret.getTextRange().getStartOffset())) {
            return false;
        }
        PsiElement psiElement4 = PythonEnterHandler.a(nodeAtCaret, true);
        PsiElement psiElement5 = PythonEnterHandler.a(nodeAtCaret, false);
        if (!(psiElement4 instanceof PsiComment)) {
            while (psiElement4 != null && (psiElement = PsiTreeUtil.getParentOfType((PsiElement)psiElement4, (Class[])b)) != null) {
                psiElement4 = psiElement;
            }
        }
        if (!(psiElement5 instanceof PsiComment)) {
            while (psiElement5 != null && (psiElement = PsiTreeUtil.getParentOfType((PsiElement)psiElement5, (Class[])b)) != null) {
                psiElement5 = psiElement;
            }
        }
        if (psiElement4 instanceof PsiComment || psiElement5 instanceof PsiComment) {
            return false;
        }
        if (psiElement5 == null) {
            return !(psiElement4 instanceof PyDecoratorList);
        }
        return psiElement4 != psiElement5;
    }

    private static void a(Editor editor2, PsiElement psiElement, DocstringState docstringState) {
        PyDocStringOwner pyDocStringOwner = (PyDocStringOwner)PsiTreeUtil.getParentOfType((PsiElement)psiElement, PyDocStringOwner.class);
        if (pyDocStringOwner != null) {
            int n2 = editor2.getCaretModel().getOffset();
            Document document = editor2.getDocument();
            String string = document.getText(TextRange.from((int)(n2 - 3), (int)3));
            String string2 = PyDocstringGenerator.forDocStringOwner(pyDocStringOwner).withInferredParameters(true).withQuotes(string).forceNewMode().buildDocString();
            if (docstringState == DocstringState.INCOMPLETE) {
                document.insertString(n2, (CharSequence)string2.substring(3));
            } else if (docstringState == DocstringState.EMPTY) {
                document.replaceString(n2, n2 + 3, (CharSequence)string2.substring(3));
            }
        }
    }

    @Nullable
    private static PsiElement a(ASTNode aSTNode, boolean bl2) {
        PsiElement psiElement;
        PsiElement psiElement2 = psiElement = bl2 ? PythonEnterHandler.b(aSTNode, b) : PythonEnterHandler.a(aSTNode, b);
        if (psiElement == null) {
            PsiElement psiElement3;
            PsiElement psiElement4 = psiElement3 = bl2 ? PythonEnterHandler.b(aSTNode, PyTupleExpression.class) : PythonEnterHandler.a(aSTNode, PyTupleExpression.class);
            if (psiElement3 != null && psiElement3.getNode().getFirstChildNode().getElementType() == PyTokenTypes.LPAR) {
                psiElement = psiElement3;
            }
        }
        return psiElement;
    }

    @Nullable
    private static PsiElement b(ASTNode aSTNode) {
        return PythonEnterHandler.b(aSTNode, PyStatement.class);
    }

    @Nullable
    private static PsiElement a(ASTNode aSTNode) {
        return PythonEnterHandler.a(aSTNode, PyStatement.class);
    }

    private static PsiElement b(ASTNode aSTNode, Class<? extends PsiElement> ... classArray) {
        while (aSTNode != null) {
            if ((aSTNode = TreeUtil.prevLeaf((ASTNode)aSTNode)) == null || aSTNode.getElementType() == TokenType.WHITE_SPACE) continue;
            return PythonEnterHandler.a(aSTNode.getPsi(), classArray);
        }
        return null;
    }

    private static PsiElement a(ASTNode aSTNode, Class<? extends PsiElement> ... classArray) {
        while (aSTNode != null) {
            if (aSTNode.getElementType() != TokenType.WHITE_SPACE) {
                return PythonEnterHandler.a(aSTNode.getPsi(), classArray);
            }
            aSTNode = TreeUtil.nextLeaf((ASTNode)aSTNode);
        }
        return null;
    }

    @Nullable
    private static <T extends PsiElement> T a(@NotNull PsiElement psiElement, Class<? extends T> ... classArray) {
        if (psiElement == null) {
            PythonEnterHandler.a(5);
        }
        if (classArray == null) {
            PythonEnterHandler.a(6);
        }
        for (PsiElement psiElement2 = psiElement; psiElement2 != null; psiElement2 = psiElement2.getParent()) {
            for (Class<T> clazz : classArray) {
                if (!clazz.isInstance(psiElement2)) continue;
                return (T)psiElement2;
            }
            if (psiElement2 instanceof PsiFile || psiElement2 instanceof PyStatementList) break;
        }
        return null;
    }

    private static boolean a(PsiElement psiElement, int n2) {
        if (!(psiElement instanceof PyFromImportStatement)) {
            return false;
        }
        PyFromImportStatement pyFromImportStatement = (PyFromImportStatement)psiElement;
        PsiElement psiElement2 = pyFromImportStatement.getLeftParen();
        return psiElement2 != null && n2 >= psiElement2.getTextRange().getEndOffset();
    }

    public EnterHandlerDelegate.Result postProcessEnter(@NotNull PsiFile file, @NotNull Editor editor2, @NotNull DataContext dataContext) {
        if (file == null) {
            PythonEnterHandler.a(7);
        }
        if (editor2 == null) {
            PythonEnterHandler.a(8);
        }
        if (dataContext == null) {
            PythonEnterHandler.a(9);
        }
        if (!(file instanceof PyFile)) {
            return EnterHandlerDelegate.Result.Continue;
        }
        if (this.a > 0) {
            editor2.getCaretModel().moveCaretRelatively(this.a, 0, false, false, false);
            this.a = 0;
            return EnterHandlerDelegate.Result.Continue;
        }
        PythonEnterHandler.a(file, editor2, editor2.getCaretModel().getOffset());
        return super.postProcessEnter(file, editor2, dataContext);
    }

    private static void a(@NotNull PsiFile psiFile, @NotNull Editor editor2, int n2) {
        int n3;
        TextRange textRange;
        Matcher matcher;
        String string;
        DocStringFormat docStringFormat;
        PyStringLiteralExpression pyStringLiteralExpression;
        if (psiFile == null) {
            PythonEnterHandler.a(10);
        }
        if (editor2 == null) {
            PythonEnterHandler.a(11);
        }
        Document document = editor2.getDocument();
        PsiDocumentManager.getInstance((Project)psiFile.getProject()).commitDocument(document);
        PsiElement psiElement = psiFile.findElementAt(n2);
        if (psiElement != null && (pyStringLiteralExpression = DocStringUtil.getParentDefinitionDocString(psiElement)) != null && (docStringFormat = DocStringUtil.guessDocStringFormat(string = pyStringLiteralExpression.getText(), pyStringLiteralExpression)) == DocStringFormat.GOOGLE && n2 + 1 < document.getTextLength() && (matcher = GoogleCodeStyleDocString.SECTION_HEADER.matcher(document.getText(textRange = TextRange.create((int)document.getLineStartOffset((n3 = document.getLineNumber(n2)) - 1), (int)document.getLineEndOffset(n3 - 1))))).matches() && SectionBasedDocString.isValidSectionTitle(matcher.group(1))) {
            document.insertString(n2, (CharSequence)GoogleCodeStyleDocStringBuilder.getDefaultSectionIndent(psiFile));
            editor2.getCaretModel().moveCaretRelatively(2, 0, false, false, false);
        }
    }

    @NotNull
    public static DocstringState canGenerateDocstring(@NotNull PsiElement element, int firstQuoteOffset, @NotNull Document document) {
        long l2 = c ^ 0x3C05DDA0817EL;
        if (element == null) {
            PythonEnterHandler.a(12);
        }
        if (document == null) {
            PythonEnterHandler.a(13);
        }
        if (firstQuoteOffset < 0 || firstQuoteOffset > document.getTextLength() - 3) {
            DocstringState docstringState = DocstringState.NONE;
            if (docstringState == null) {
                PythonEnterHandler.a(14);
            }
            return docstringState;
        }
        String string = document.getText(TextRange.from((int)firstQuoteOffset, (int)3));
        if (!string.equals("\"\"\"") && !string.equals("'''")) {
            DocstringState docstringState = DocstringState.NONE;
            if (docstringState == null) {
                PythonEnterHandler.a(15);
            }
            return docstringState;
        }
        PyStringLiteralExpression pyStringLiteralExpression = DocStringUtil.getParentDefinitionDocString(element);
        if (pyStringLiteralExpression != null) {
            String string2 = element.getText();
            int n2 = PyStringLiteralUtil.getPrefixLength(string2);
            string2 = string2.substring(n2);
            String string3 = pyStringLiteralExpression.getText();
            if (string3.endsWith(string2) && string2.startsWith(string) && firstQuoteOffset == pyStringLiteralExpression.getTextOffset() + n2) {
                PsiErrorElement psiErrorElement = (PsiErrorElement)PsiTreeUtil.getNextSiblingOfType((PsiElement)pyStringLiteralExpression, PsiErrorElement.class);
                if (psiErrorElement == null) {
                    psiErrorElement = (PsiErrorElement)PsiTreeUtil.getNextSiblingOfType((PsiElement)pyStringLiteralExpression.getParent(), PsiErrorElement.class);
                }
                if (psiErrorElement != null) {
                    DocstringState docstringState = DocstringState.INCOMPLETE;
                    if (docstringState == null) {
                        PythonEnterHandler.a(16);
                    }
                    return docstringState;
                }
                if (string2.equals(string + string)) {
                    DocstringState docstringState = DocstringState.EMPTY;
                    if (docstringState == null) {
                        PythonEnterHandler.a(17);
                    }
                    return docstringState;
                }
                if (string2.length() < 6 || !string2.endsWith(string)) {
                    DocstringState docstringState = DocstringState.INCOMPLETE;
                    if (docstringState == null) {
                        PythonEnterHandler.a(18);
                    }
                    return docstringState;
                }
                String string4 = PyIndentUtil.getLineIndent(document, document.getLineNumber(firstQuoteOffset));
                for (String string5 : LineTokenizer.tokenizeIntoList((CharSequence)string2, (boolean)false)) {
                    String string6;
                    String string7 = string5.substring((string6 = PyIndentUtil.getLineIndent(string5)).length());
                    if (!string7.startsWith("def ") && !string7.startsWith("class ") || string4.length() <= string6.length() || !string4.startsWith(string6)) continue;
                    DocstringState docstringState = DocstringState.INCOMPLETE;
                    if (docstringState == null) {
                        PythonEnterHandler.a(19);
                    }
                    return docstringState;
                }
            }
        }
        DocstringState docstringState = DocstringState.NONE;
        if (docstringState == null) {
            PythonEnterHandler.a(20);
        }
        return docstringState;
    }

    static {
        c = com.jetbrains.python.psi.c.a(4281963585809388608L, -5063738670698124453L, MethodHandles.lookup().lookupClass()).a(86962567541750L);
        IMPLICIT_WRAP_CLASSES = new Class[]{PyListLiteralExpression.class, PySetLiteralExpression.class, PyDictLiteralExpression.class, PyDictLiteralExpression.class, PyParenthesizedExpression.class, PyArgumentList.class, PyParameterList.class};
        b = new Class[]{PsiComment.class, PyParenthesizedExpression.class, PyListCompExpression.class, PyDictCompExpression.class, PySetCompExpression.class, PyDictLiteralExpression.class, PySetLiteralExpression.class, PyListLiteralExpression.class, PyArgumentList.class, PyParameterList.class, PyDecoratorList.class, PySliceExpression.class, PySubscriptionExpression.class, PyGeneratorExpression.class};
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = c ^ 0x23B7C3B7289CL;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caretOffset";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caretAdvance";
                break;
            }
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 5: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classes";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/editor/PythonEnterHandler";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/editor/PythonEnterHandler";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "canGenerateDocstring";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "preprocessEnter";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getNonStrictParentOfType";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "postProcessEnter";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addGoogleDocStringSectionIndent";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "canGenerateDocstring";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static final class DocstringState
    extends Enum<DocstringState> {
        public static final /* enum */ DocstringState NONE;
        public static final /* enum */ DocstringState INCOMPLETE;
        public static final /* enum */ DocstringState EMPTY;
        private static final /* synthetic */ DocstringState[] a;

        public static DocstringState[] values() {
            return (DocstringState[])a.clone();
        }

        public static DocstringState valueOf(String name) {
            return Enum.valueOf(DocstringState.class, name);
        }

        static {
            long l2 = com.jetbrains.python.psi.c.a(8904254574612251488L, 4194586505089742609L, MethodHandles.lookup().lookupClass()).a(124082329601897L) ^ 0x1C2AB2150AB3L;
            NONE = new DocstringState();
            INCOMPLETE = new DocstringState();
            EMPTY = new DocstringState();
            a = new DocstringState[]{NONE, INCOMPLETE, EMPTY};
        }
    }
}

