/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.documentation.docstrings;

import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.python.psi.PyIndentUtil;
import com.jetbrains.python.psi.c;
import com.jetbrains.python.toolbox.Substring;
import java.lang.invoke.MethodHandles;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DocStringLineParser {
    protected final List<Substring> myLines;
    protected final Substring myDocStringContent;
    private static final long j = c.a(-1699093517357863402L, 6623718259146763529L, MethodHandles.lookup().lookupClass()).a(165494995434396L);

    protected DocStringLineParser(@NotNull Substring content2) {
        if (content2 == null) {
            DocStringLineParser.a(0);
        }
        this.myDocStringContent = content2;
        this.myLines = Collections.unmodifiableList(content2.splitLines());
    }

    public int getLineIndentSize(int lineNum) {
        return PyIndentUtil.getLineIndentSize(this.getLine(lineNum));
    }

    @NotNull
    public String getLineIndent(int lineNum) {
        String string = PyIndentUtil.getLineIndent(this.getLine(lineNum)).toString();
        if (string == null) {
            DocStringLineParser.a(1);
        }
        return string;
    }

    public boolean isEmptyOrDoesNotExist(int lineNum) {
        return lineNum < 0 || lineNum >= this.myLines.size() || this.isEmpty(lineNum);
    }

    public boolean isEmpty(int lineNum) {
        return StringUtil.isEmptyOrSpaces((CharSequence)this.getLine(lineNum));
    }

    @NotNull
    public Substring getLine(int lineNum) {
        Substring substring = this.myLines.get(lineNum);
        if (substring == null) {
            DocStringLineParser.a(2);
        }
        return substring;
    }

    @Nullable
    public Substring getLineOrNull(int lineNum) {
        return lineNum >= 0 && lineNum < this.myLines.size() ? this.myLines.get(lineNum) : null;
    }

    public int getLineCount() {
        return this.myLines.size();
    }

    @NotNull
    public List<Substring> getLines() {
        List<Substring> list2 = this.myLines;
        if (list2 == null) {
            DocStringLineParser.a(3);
        }
        return list2;
    }

    @NotNull
    public Substring getDocStringContent() {
        Substring substring = this.myDocStringContent;
        if (substring == null) {
            DocStringLineParser.a(4);
        }
        return substring;
    }

    public int consumeIndentedBlock(int startLine, int indentThreshold) {
        int n2 = startLine - 1;
        for (int i10 = startLine; i10 < this.getLineCount() && !this.isBlockEnd(i10); ++i10) {
            if (this.isEmpty(i10)) continue;
            if (this.getLineIndentSize(i10) <= indentThreshold) break;
            n2 = i10;
        }
        return n2 + 1;
    }

    public int consumeEmptyLines(int lineNum) {
        while (lineNum < this.getLineCount() && this.isEmpty(lineNum)) {
            ++lineNum;
        }
        return lineNum;
    }

    protected abstract boolean isBlockEnd(int var1);

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = j ^ 0x2CB4A3BD495L;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/documentation/docstrings/DocStringLineParser";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/documentation/docstrings/DocStringLineParser";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getLineIndent";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getLine";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getLines";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDocStringContent";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

