/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.documentation;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.intellij.ide.actions.ShowSettingsUtilImpl;
import com.intellij.lang.documentation.AbstractDocumentationProvider;
import com.intellij.lang.documentation.ExternalDocumentationProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.QualifiedName;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.PythonDialectsTokenSetProvider;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.codeInsight.dataflow.scope.ScopeUtil;
import com.jetbrains.python.codeInsight.typing.PyTypingTypeProvider;
import com.jetbrains.python.console.PydevConsoleRunner;
import com.jetbrains.python.console.PydevDocumentationProvider;
import com.jetbrains.python.documentation.DocumentationBuilderKit;
import com.jetbrains.python.documentation.PyDocumentationBuilder;
import com.jetbrains.python.documentation.PyDocumentationLink;
import com.jetbrains.python.documentation.PyDocumentationSettings;
import com.jetbrains.python.documentation.PyTypeModelBuilder;
import com.jetbrains.python.documentation.PythonDocumentationLinkProvider;
import com.jetbrains.python.documentation.PythonDocumentationMap;
import com.jetbrains.python.documentation.PythonDocumentationQuickInfoProvider;
import com.jetbrains.python.documentation.docstrings.DocStringUtil;
import com.jetbrains.python.psi.PyArgumentList;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyDecoratable;
import com.jetbrains.python.psi.PyDecorator;
import com.jetbrains.python.psi.PyDecoratorList;
import com.jetbrains.python.psi.PyDocStringOwner;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyKeywordArgument;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.PyParameterList;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PySingleStarParameter;
import com.jetbrains.python.psi.PySlashParameter;
import com.jetbrains.python.psi.PyStatementList;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PySubscriptionExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyTypedElement;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.StructuredDocString;
import com.jetbrains.python.psi.c;
import com.jetbrains.python.psi.impl.PyBuiltinCache;
import com.jetbrains.python.psi.impl.PyClassImpl;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.resolve.QualifiedNameFinder;
import com.jetbrains.python.psi.types.PyCallableParameter;
import com.jetbrains.python.psi.types.PyCollectionType;
import com.jetbrains.python.psi.types.PyTupleType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import com.jetbrains.python.pyi.PyiFile;
import com.jetbrains.python.pyi.PyiUtil;
import com.jetbrains.python.toolbox.ChainIterable;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import javax.swing.Icon;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;

public class PythonDocumentationProvider
extends AbstractDocumentationProvider
implements ExternalDocumentationProvider {
    private static final Logger c;
    private static final int b = 80;
    private static final String a = "\u2022";
    private static final long d;

    @Nullable
    public String getQuickNavigateInfo(PsiElement element, @NotNull PsiElement originalElement) {
        String string2;
        long l2 = d ^ 0x1675F38BE4D1L;
        if (originalElement == null) {
            PythonDocumentationProvider.a(0);
        }
        for (PythonDocumentationQuickInfoProvider pythonDocumentationQuickInfoProvider : (PythonDocumentationQuickInfoProvider[])PythonDocumentationQuickInfoProvider.EP_NAME.getExtensions()) {
            string2 = pythonDocumentationQuickInfoProvider.getQuickInfo(originalElement);
            if (string2 == null) continue;
            return string2;
        }
        TypeEvalContext typeEvalContext = TypeEvalContext.userInitiated(originalElement.getProject(), originalElement.getContainingFile());
        if (element instanceof PyFunction) {
            PyFunction pyClass = (PyFunction)element;
            ChainIterable<String> chainIterable = new ChainIterable<String>();
            PyClass pyClass2 = pyClass.getContainingClass();
            if (pyClass2 != null && (string2 = pyClass2.getName()) != null) {
                chainIterable.addItem("class ").addItem(string2).addItem("\n");
            }
            chainIterable.add(PythonDocumentationProvider.describeDecorators(pyClass, Function.identity(), DocumentationBuilderKit.TO_ONE_LINE_AND_ESCAPE, ", ", "\n")).add(PythonDocumentationProvider.describeFunction(pyClass, originalElement, typeEvalContext, true));
            string2 = PythonDocumentationProvider.a(pyClass);
            if (string2 != null) {
                chainIterable.addItem("\n").addItem(PythonDocumentationProvider.a(string2));
            }
            return chainIterable.toString();
        }
        if (element instanceof PyClass) {
            PyClass pyClass = (PyClass)element;
            ChainIterable<String> chainIterable = new ChainIterable<String>();
            chainIterable.add(PythonDocumentationProvider.describeDecorators(pyClass, Function.identity(), DocumentationBuilderKit.TO_ONE_LINE_AND_ESCAPE, ", ", "\n")).add(PythonDocumentationProvider.describeClass(pyClass, Function.identity(), DocumentationBuilderKit.TO_ONE_LINE_AND_ESCAPE, false, false, typeEvalContext));
            String string3 = PythonDocumentationProvider.a(pyClass);
            if (string3 != null) {
                chainIterable.addItem("\n").addItem(PythonDocumentationProvider.a(string3));
            } else {
                Optional.ofNullable(pyClass.findInitOrNew(false, typeEvalContext)).map(PythonDocumentationProvider::a).ifPresent(string -> chainIterable.addItem("\n").addItem(PythonDocumentationProvider.a(string)));
            }
            return chainIterable.toString();
        }
        if (element instanceof PyExpression) {
            return PythonDocumentationProvider.a((PyExpression)element, originalElement, DocumentationBuilderKit.ESCAPE_ONLY, typeEvalContext);
        }
        return null;
    }

    @Nullable
    private static String a(@NotNull PyDocStringOwner pyDocStringOwner) {
        PyStringLiteralExpression pyStringLiteralExpression;
        if (pyDocStringOwner == null) {
            PythonDocumentationProvider.a(1);
        }
        if ((pyStringLiteralExpression = PyDocumentationBuilder.getEffectiveDocStringExpression(pyDocStringOwner)) != null) {
            StructuredDocString structuredDocString = DocStringUtil.parse(pyStringLiteralExpression.getStringValue(), pyStringLiteralExpression);
            return structuredDocString.getSummary();
        }
        return null;
    }

    @NotNull
    static ChainIterable<String> describeFunction(@NotNull PyFunction function, @Nullable PsiElement original, @NotNull TypeEvalContext context, boolean forTooltip) {
        List<PyFunction> list2;
        long l2 = d ^ 0x55410A5333CEL;
        if (function == null) {
            PythonDocumentationProvider.a(2);
        }
        if (context == null) {
            PythonDocumentationProvider.a(3);
        }
        ChainIterable<String> chainIterable = new ChainIterable<String>(PythonDocumentationProvider.a(function, context, forTooltip));
        if (PythonDocumentationProvider.a(function, original, context) && !(list2 = PyiUtil.getOverloads(function, context)).isEmpty()) {
            chainIterable.addItem("\nPossible types:\n");
            boolean bl2 = true;
            for (PyFunction pyFunction : list2) {
                if (!bl2) {
                    chainIterable.addItem("\n");
                }
                chainIterable.addItem(a).addItem(" ");
                PythonDocumentationProvider.describeTypeWithLinks(context.getType(pyFunction), context, function, chainIterable);
                bl2 = false;
            }
        }
        ChainIterable<String> chainIterable2 = chainIterable;
        if (chainIterable2 == null) {
            PythonDocumentationProvider.a(4);
        }
        return chainIterable2;
    }

    private static boolean a(@NotNull PyFunction pyFunction, @Nullable PsiElement psiElement, @NotNull TypeEvalContext typeEvalContext) {
        if (pyFunction == null) {
            PythonDocumentationProvider.a(5);
        }
        if (typeEvalContext == null) {
            PythonDocumentationProvider.a(6);
        }
        if (!PyiUtil.isOverload(pyFunction, typeEvalContext)) {
            return true;
        }
        PyFunction pyFunction2 = (PyFunction)PsiTreeUtil.getParentOfType((PsiElement)psiElement, PyFunction.class, (boolean)false, (Class[])new Class[]{PyStatementList.class, PyParameterList.class});
        return pyFunction2 == null || pyFunction2 != psiElement && pyFunction2.getNameIdentifier() != psiElement;
    }

    @NotNull
    static ChainIterable<String> describeTarget(@NotNull PyTargetExpression target, @NotNull TypeEvalContext context) {
        long l2 = d ^ 0x21BFD1252526L;
        if (target == null) {
            PythonDocumentationProvider.a(7);
        }
        if (context == null) {
            PythonDocumentationProvider.a(8);
        }
        ChainIterable<String> chainIterable = new ChainIterable<String>();
        chainIterable.addItem(StringUtil.escapeXmlEntities((String)StringUtil.notNullize((String)target.getName())));
        chainIterable.addItem(": ");
        PythonDocumentationProvider.describeTypeWithLinks(context.getType(target), context, target, chainIterable);
        PyExpression pyExpression = target.findAssignedValue();
        if (pyExpression != null) {
            chainIterable.addItem(" = ");
            String string = pyExpression.getText();
            int n2 = string.indexOf("\n");
            if (n2 < 0) {
                chainIterable.addItem(StringUtil.escapeXmlEntities((String)string));
            } else {
                chainIterable.addItem(StringUtil.escapeXmlEntities((String)string.substring(0, n2))).addItem("...");
            }
        }
        ChainIterable<String> chainIterable2 = chainIterable;
        if (chainIterable2 == null) {
            PythonDocumentationProvider.a(9);
        }
        return chainIterable2;
    }

    @NotNull
    static ChainIterable<String> describeParameter(@NotNull PyNamedParameter parameter, @NotNull TypeEvalContext context) {
        long l2 = d ^ 0x702BFB79411BL;
        if (parameter == null) {
            PythonDocumentationProvider.a(10);
        }
        if (context == null) {
            PythonDocumentationProvider.a(11);
        }
        ChainIterable<String> chainIterable = new ChainIterable<String>();
        chainIterable.addItem(StringUtil.escapeXmlEntities((String)StringUtil.notNullize((String)parameter.getName())));
        chainIterable.addItem(": ");
        PythonDocumentationProvider.describeTypeWithLinks(context.getType(parameter), context, parameter, chainIterable);
        ChainIterable<String> chainIterable2 = chainIterable;
        if (chainIterable2 == null) {
            PythonDocumentationProvider.a(12);
        }
        return chainIterable2;
    }

    @NotNull
    private static String a(@NotNull PyFunction pyFunction, @NotNull TypeEvalContext typeEvalContext, boolean bl2) {
        long l2 = d ^ 0x251A26935F30L;
        if (pyFunction == null) {
            PythonDocumentationProvider.a(13);
        }
        if (typeEvalContext == null) {
            PythonDocumentationProvider.a(14);
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (pyFunction.isAsync()) {
            stringBuilder.append("async ");
        }
        stringBuilder.append("def ");
        String string = StringUtil.notNullize((String)pyFunction.getName(), (String)"<unnamed>");
        int n2 = stringBuilder.length() + string.length();
        int n3 = 0;
        if (bl2) {
            stringBuilder.append(PythonDocumentationProvider.a(string));
        } else {
            PythonDocumentationProvider.a(stringBuilder, PythonDocumentationProvider.a(string), "b");
        }
        stringBuilder.append("(");
        ++n2;
        boolean bl3 = true;
        boolean bl4 = false;
        List list2 = pyFunction.getParameters(typeEvalContext);
        for (PyCallableParameter pyCallableParameter : list2) {
            Object object;
            if (!bl3) {
                stringBuilder.append(",");
                if (bl2 || bl4 && list2.size() == 2) {
                    stringBuilder.append(" ");
                } else {
                    stringBuilder.append("\n");
                    n3 = stringBuilder.length();
                    StringUtil.repeatSymbol((Appendable)stringBuilder, (char)' ', (int)n2);
                }
            } else {
                bl4 = pyCallableParameter.isSelf();
            }
            String string2 = pyCallableParameter.getName();
            PyType pyType = pyCallableParameter.getType(typeEvalContext);
            boolean bl5 = true;
            if (pyCallableParameter.isPositionalContainer()) {
                string2 = "*" + StringUtil.notNullize((String)string2, (String)"args");
                object = PyUtil.as(pyType, PyTupleType.class);
                if (object != null) {
                    pyType = ((PyTupleType)object).getIteratedItemType();
                }
            } else if (pyCallableParameter.isKeywordContainer()) {
                string2 = "**" + StringUtil.notNullize((String)string2, (String)"kwargs");
                object = PyUtil.as(pyType, PyCollectionType.class);
                if (object != null && object.getPyClass() == PyBuiltinCache.getInstance(pyFunction).getClass("dict")) {
                    List<PyType> list3 = object.getElementTypes();
                    pyType = list3.size() == 2 ? list3.get(1) : null;
                }
            } else if (pyCallableParameter.getParameter() instanceof PySlashParameter) {
                string2 = "/";
                bl5 = false;
            } else if (pyCallableParameter.getParameter() instanceof PySingleStarParameter) {
                string2 = "*";
                bl5 = false;
            } else {
                string2 = StringUtil.notNullize((String)string2, (String)"<unnamed>");
                object = PyUtil.as(pyCallableParameter.getParameter(), PyNamedParameter.class);
                bl5 = !pyCallableParameter.isSelf() || object != null && new PyTypingTypeProvider().getParameterType((PyNamedParameter)object, pyFunction, typeEvalContext) != null;
            }
            stringBuilder.append(PythonDocumentationProvider.a(string2));
            if (bl5) {
                stringBuilder.append(": ");
                stringBuilder.append(PythonDocumentationProvider.a(pyType, (PsiElement)pyFunction, typeEvalContext));
            }
            if ((object = pyCallableParameter.getDefaultValueText()) != null) {
                stringBuilder.append(bl5 ? " = " : "=");
                stringBuilder.append(PythonDocumentationProvider.a((String)object));
            }
            bl3 = false;
        }
        stringBuilder.append(")");
        if (!bl2 && StringUtil.stripHtml((String)stringBuilder.substring(n3), (boolean)false).length() > 80) {
            stringBuilder.append("\n ");
        }
        stringBuilder.append(PythonDocumentationProvider.a(" -> ")).append(PythonDocumentationProvider.a(typeEvalContext.getReturnType(pyFunction), (PsiElement)pyFunction, typeEvalContext));
        String string3 = stringBuilder.toString();
        if (string3 == null) {
            PythonDocumentationProvider.a(15);
        }
        return string3;
    }

    @Nullable
    private static String a(@NotNull PyExpression pyExpression, @NotNull PsiElement psiElement, @NotNull Function<String, String> function, @NotNull TypeEvalContext typeEvalContext) {
        String string;
        long l2 = d ^ 0x5332A3BC6895L;
        if (pyExpression == null) {
            PythonDocumentationProvider.a(16);
        }
        if (psiElement == null) {
            PythonDocumentationProvider.a(17);
        }
        if (function == null) {
            PythonDocumentationProvider.a(18);
        }
        if (typeEvalContext == null) {
            PythonDocumentationProvider.a(19);
        }
        if ((string = pyExpression.getName()) != null) {
            Object object;
            StringBuilder stringBuilder = new StringBuilder(pyExpression instanceof PyNamedParameter ? "parameter" : "variable");
            stringBuilder.append(String.format(" \"%s\"", string));
            if (pyExpression instanceof PyNamedParameter && (object = (PyFunction)PsiTreeUtil.getParentOfType((PsiElement)pyExpression, PyFunction.class)) != null) {
                stringBuilder.append(" of ").append(object.getContainingClass() == null ? "function" : "method").append(String.format(" \"%s\"", object.getName()));
            }
            if (psiElement instanceof PyTypedElement) {
                object = PythonDocumentationProvider.getTypeName(typeEvalContext.getType((PyTypedElement)psiElement), typeEvalContext);
                stringBuilder.append("\n").append(String.format("Inferred type: %s", object));
            }
            return function.apply(stringBuilder.toString());
        }
        return null;
    }

    @NotNull
    public static String getTypeName(@Nullable PyType type, @NotNull TypeEvalContext context) {
        if (context == null) {
            PythonDocumentationProvider.a(20);
        }
        String string = PythonDocumentationProvider.a(type, context).asString();
        if (string == null) {
            PythonDocumentationProvider.a(21);
        }
        return string;
    }

    @NotNull
    public static String getTypeHint(@Nullable PyType type, @NotNull TypeEvalContext context) {
        if (context == null) {
            PythonDocumentationProvider.a(22);
        }
        String string = PythonDocumentationProvider.a(type, context).asPep484TypeHint();
        if (string == null) {
            PythonDocumentationProvider.a(23);
        }
        return string;
    }

    public static void describeTypeWithLinks(@Nullable PyType type, @NotNull TypeEvalContext context, @NotNull PsiElement anchor, @NotNull ChainIterable<String> body) {
        if (context == null) {
            PythonDocumentationProvider.a(24);
        }
        if (anchor == null) {
            PythonDocumentationProvider.a(25);
        }
        if (body == null) {
            PythonDocumentationProvider.a(26);
        }
        PythonDocumentationProvider.a(type, context).toBodyWithLinks(body, anchor);
    }

    @NotNull
    public static String getTypeDescription(@Nullable PyType type, @NotNull TypeEvalContext context) {
        if (context == null) {
            PythonDocumentationProvider.a(27);
        }
        String string = PythonDocumentationProvider.a(type, context).asDescription();
        if (string == null) {
            PythonDocumentationProvider.a(28);
        }
        return string;
    }

    @NotNull
    private static PyTypeModelBuilder.TypeModel a(@Nullable PyType pyType, @NotNull TypeEvalContext typeEvalContext) {
        if (typeEvalContext == null) {
            PythonDocumentationProvider.a(29);
        }
        PyTypeModelBuilder.TypeModel typeModel = new PyTypeModelBuilder(typeEvalContext).build(pyType, true);
        if (typeModel == null) {
            PythonDocumentationProvider.a(30);
        }
        return typeModel;
    }

    @NotNull
    static ChainIterable<String> describeDecorators(@NotNull PyDecoratable decoratable, @NotNull Function<String, String> escapedCalleeMapper, @NotNull Function<String, String> escaper, @NotNull String separator, @NotNull String suffix) {
        if (decoratable == null) {
            PythonDocumentationProvider.a(31);
        }
        if (escapedCalleeMapper == null) {
            PythonDocumentationProvider.a(32);
        }
        if (escaper == null) {
            PythonDocumentationProvider.a(33);
        }
        if (separator == null) {
            PythonDocumentationProvider.a(34);
        }
        if (suffix == null) {
            PythonDocumentationProvider.a(35);
        }
        ChainIterable<String> chainIterable = new ChainIterable<String>();
        PyDecoratorList pyDecoratorList = decoratable.getDecoratorList();
        if (pyDecoratorList != null) {
            boolean bl2 = true;
            for (PyDecorator pyDecorator : pyDecoratorList.getDecorators()) {
                if (!bl2) {
                    chainIterable.addItem(separator);
                }
                chainIterable.add(PythonDocumentationProvider.a(pyDecorator, escapedCalleeMapper, escaper));
                bl2 = false;
            }
        }
        if (!chainIterable.isEmpty()) {
            chainIterable.addItem(suffix);
        }
        ChainIterable<String> chainIterable2 = chainIterable;
        if (chainIterable2 == null) {
            PythonDocumentationProvider.a(36);
        }
        return chainIterable2;
    }

    @NotNull
    static ChainIterable<String> describeClass(@NotNull PyClass cls, @NotNull Function<? super String, String> escapedNameMapper, @NotNull Function<? super String, String> escaper, boolean link, boolean linkAncestors, @NotNull TypeEvalContext context) {
        long l2 = d ^ 0x53296A8D73CL;
        if (cls == null) {
            PythonDocumentationProvider.a(37);
        }
        if (escapedNameMapper == null) {
            PythonDocumentationProvider.a(38);
        }
        if (escaper == null) {
            PythonDocumentationProvider.a(39);
        }
        if (context == null) {
            PythonDocumentationProvider.a(40);
        }
        ChainIterable<String> chainIterable = new ChainIterable<String>();
        String string = escapedNameMapper.apply(escaper.apply(cls.getName()));
        chainIterable.addItem(escaper.apply("class "));
        chainIterable.addItem(link ? PyDocumentationLink.toContainingClass(string) : string);
        PyExpression[] pyExpressionArray = cls.getSuperClassExpressions();
        if (pyExpressionArray.length > 0) {
            chainIterable.addItem(escaper.apply("("));
            boolean bl2 = false;
            for (PyExpression pyExpression : pyExpressionArray) {
                if (bl2) {
                    chainIterable.addItem(escaper.apply(", "));
                } else {
                    bl2 = true;
                }
                chainIterable.addItem(PythonDocumentationProvider.a(pyExpression, escaper, linkAncestors, context));
            }
            chainIterable.addItem(escaper.apply(")"));
        }
        ChainIterable<String> chainIterable2 = chainIterable;
        if (chainIterable2 == null) {
            PythonDocumentationProvider.a(41);
        }
        return chainIterable2;
    }

    @NotNull
    private static String a(@NotNull PyExpression pyExpression2, @NotNull Function<? super String, String> function, boolean bl2, @NotNull TypeEvalContext typeEvalContext) {
        long l2 = d ^ 0x1479CADAC6D6L;
        if (pyExpression2 == null) {
            PythonDocumentationProvider.a(42);
        }
        if (function == null) {
            PythonDocumentationProvider.a(43);
        }
        if (typeEvalContext == null) {
            PythonDocumentationProvider.a(44);
        }
        if (bl2) {
            PyCallExpression pyCallExpression;
            PyExpression pyExpression3;
            if (pyExpression2 instanceof PyReferenceExpression) {
                PyReferenceExpression pyReferenceExpression = (PyReferenceExpression)pyExpression2;
                if (!pyReferenceExpression.isQualified()) {
                    PyResolveContext pyResolveContext = PyResolveContext.noImplicits().withTypeEvalContext(typeEvalContext);
                    for (ResolveResult resolveResult : pyReferenceExpression.getReference(pyResolveContext).multiResolve(false)) {
                        String string;
                        PsiElement psiElement = resolveResult.getElement();
                        if (!(psiElement instanceof PyClass) || (string = ((PyClass)psiElement).getQualifiedName()) == null) continue;
                        String string2 = PyDocumentationLink.toPossibleClass(function.apply(pyExpression2.getText()), string, psiElement, typeEvalContext);
                        if (string2 == null) {
                            PythonDocumentationProvider.a(45);
                        }
                        return string2;
                    }
                }
            } else if (pyExpression2 instanceof PySubscriptionExpression) {
                PyExpression pyExpression4 = ((PySubscriptionExpression)pyExpression2).getOperand();
                PyExpression pyExpression5 = ((PySubscriptionExpression)pyExpression2).getIndexExpression();
                if (pyExpression5 != null) {
                    String string = PythonDocumentationProvider.a(pyExpression4, function, true, typeEvalContext) + function.apply("[") + PythonDocumentationProvider.a(pyExpression5, function, true, typeEvalContext) + function.apply("]");
                    if (string == null) {
                        PythonDocumentationProvider.a(46);
                    }
                    return string;
                }
            } else if (pyExpression2 instanceof PyKeywordArgument) {
                String string = ((PyKeywordArgument)pyExpression2).getKeyword();
                PyExpression pyExpression6 = ((PyKeywordArgument)pyExpression2).getValueExpression();
                if ("metaclass".equals(string) && pyExpression6 != null) {
                    String string3 = function.apply("metaclass=") + PythonDocumentationProvider.a(pyExpression6, function, true, typeEvalContext);
                    if (string3 == null) {
                        PythonDocumentationProvider.a(47);
                    }
                    return string3;
                }
            } else if (PyClassImpl.isSixWithMetaclassCall(pyExpression2) && (pyExpression3 = (pyCallExpression = (PyCallExpression)pyExpression2).getCallee()) != null) {
                String string = StreamEx.of((Object[])pyCallExpression.getArguments()).map(pyExpression -> PythonDocumentationProvider.a(pyExpression, function, true, typeEvalContext)).joining((CharSequence)function.apply(", "), (CharSequence)function.apply(pyExpression3.getText() + "("), (CharSequence)function.apply(")"));
                if (string == null) {
                    PythonDocumentationProvider.a(48);
                }
                return string;
            }
        }
        String string = function.apply(pyExpression2.getText());
        if (string == null) {
            PythonDocumentationProvider.a(49);
        }
        return string;
    }

    @NotNull
    private static Iterable<String> a(@NotNull PyDecorator pyDecorator, @NotNull Function<String, String> function, @NotNull Function<String, String> function2) {
        if (pyDecorator == null) {
            PythonDocumentationProvider.a(50);
        }
        if (function == null) {
            PythonDocumentationProvider.a(51);
        }
        if (function2 == null) {
            PythonDocumentationProvider.a(52);
        }
        ChainIterable<String> chainIterable = new ChainIterable<String>();
        chainIterable.addItem(function2.apply("@")).addItem(function.apply(function2.apply(PyUtil.getReadableRepr((PsiElement)pyDecorator.getCallee(), false))));
        PyArgumentList pyArgumentList = pyDecorator.getArgumentList();
        if (pyArgumentList != null) {
            chainIterable.addItem(function2.apply(PyUtil.getReadableRepr((PsiElement)pyArgumentList, false)));
        }
        ChainIterable<String> chainIterable2 = chainIterable;
        if (chainIterable2 == null) {
            PythonDocumentationProvider.a(53);
        }
        return chainIterable2;
    }

    public String generateDoc(@NotNull PsiElement element, @Nullable PsiElement originalElement) {
        if (element == null) {
            PythonDocumentationProvider.a(54);
        }
        if (PydevConsoleRunner.isInPydevConsole(element) || originalElement != null && PydevConsoleRunner.isInPydevConsole(originalElement)) {
            return PydevDocumentationProvider.createDoc(element, originalElement);
        }
        return new PyDocumentationBuilder(element, originalElement).build();
    }

    public PsiElement getDocumentationElementForLink(PsiManager psiManager, @NotNull String link, @NotNull PsiElement context) {
        if (link == null) {
            PythonDocumentationProvider.a(55);
        }
        if (context == null) {
            PythonDocumentationProvider.a(56);
        }
        return PyDocumentationLink.elementForLink(link, context, TypeEvalContext.userInitiated(context.getProject(), context.getContainingFile()));
    }

    public List<String> getUrlFor(PsiElement element, PsiElement originalElement) {
        String string = PythonDocumentationProvider.getOnlyUrlFor(element, originalElement);
        return string == null ? null : Collections.singletonList(string);
    }

    @Nullable
    public static String getOnlyUrlFor(PsiElement element, PsiElement originalElement) {
        PsiFileSystemItem psiFileSystemItem = PythonDocumentationProvider.b(element);
        if (psiFileSystemItem == null) {
            return null;
        }
        Sdk sdk = PyBuiltinCache.findSdkForFile(psiFileSystemItem);
        if (sdk == null) {
            return null;
        }
        QualifiedName qualifiedName = QualifiedNameFinder.findCanonicalImportPath(element, originalElement);
        if (qualifiedName == null) {
            return null;
        }
        PythonDocumentationMap pythonDocumentationMap = PythonDocumentationMap.getInstance();
        String string = PythonDocumentationProvider.pyVersion(sdk.getVersionString());
        PsiNamedElement psiNamedElement = PythonDocumentationProvider.getNamedElement(element);
        String string2 = pythonDocumentationMap.urlFor(qualifiedName, psiNamedElement, string);
        if (string2 != null) {
            return string2;
        }
        for (PythonDocumentationLinkProvider pythonDocumentationLinkProvider : PythonDocumentationLinkProvider.EP_NAME.getExtensionList()) {
            String string3 = pythonDocumentationLinkProvider.getExternalDocumentationUrl(element, originalElement);
            if (string3 == null) continue;
            return string3;
        }
        return null;
    }

    @Nullable
    private static PsiFileSystemItem b(PsiElement psiElement) {
        PsiFileSystemItem psiFileSystemItem = psiElement instanceof PsiFileSystemItem ? (PsiFileSystemItem)psiElement : psiElement.getContainingFile();
        return (PsiFileSystemItem)PyUtil.turnInitIntoDir((PsiElement)psiFileSystemItem);
    }

    @Nullable
    public static String pyVersion(@Nullable String versionString) {
        String string;
        int n2;
        long l2 = d ^ 0xFFE65378EFAL;
        String string2 = "Python ";
        if (versionString != null && versionString.startsWith("Python ") && (n2 = (string = versionString.substring("Python ".length())).indexOf(46)) > 0) {
            if ((n2 = string.indexOf(46, n2 + 1)) > 0) {
                return string.substring(0, n2);
            }
            return string;
        }
        return null;
    }

    public String fetchExternalDocumentation(Project project, PsiElement element, List<String> docUrls) {
        PsiNamedElement psiNamedElement = (PsiNamedElement)ApplicationManager.getApplication().runReadAction(() -> {
            Module module2 = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
            if (module2 != null && !PyDocumentationSettings.getInstance(module2).isRenderExternalDocumentation()) {
                return null;
            }
            PsiFileSystemItem psiFileSystemItem = PythonDocumentationProvider.b(element);
            if (psiFileSystemItem == null) {
                return null;
            }
            if (psiFileSystemItem instanceof PyiFile) {
                return null;
            }
            return PythonDocumentationProvider.getNamedElement(element);
        });
        if (psiNamedElement != null) {
            for (String string : docUrls) {
                Supplier supplier = Suppliers.memoize(() -> {
                    long l2 = d ^ 0x404F4A4126D3L;
                    try {
                        return Jsoup.parse((URL)new URL(string), (int)1000);
                    }
                    catch (IOException iOException) {
                        c.error("Can't read external doc URL: " + string, (Throwable)iOException);
                        return null;
                    }
                });
                for (PythonDocumentationLinkProvider pythonDocumentationLinkProvider : PythonDocumentationLinkProvider.EP_NAME.getExtensionList()) {
                    String string2;
                    Document document;
                    Function<Document, String> function = pythonDocumentationLinkProvider.quickDocExtractor(psiNamedElement);
                    if (function == null || (document = (Document)supplier.get()) == null || !StringUtil.isNotEmpty((String)(string2 = (String)ReadAction.compute(() -> (String)function.apply(document))))) continue;
                    return string2;
                }
            }
        }
        return null;
    }

    @Nullable
    public static PsiNamedElement getNamedElement(@Nullable PsiElement element) {
        Object object;
        long l2 = d ^ 0x5DED8EC0B9C8L;
        PsiNamedElement psiNamedElement = object = element instanceof PsiNamedElement ? (PsiNamedElement)element : null;
        if (object instanceof PyFunction && "__init__".equals(object.getName())) {
            PyClass pyClass = ((PyFunction)object).getContainingClass();
            if (pyClass != null) {
                object = pyClass;
            }
        } else {
            object = (PsiNamedElement)PyUtil.turnInitIntoDir((PsiElement)object);
        }
        return object;
    }

    public boolean hasDocumentationFor(PsiElement element, PsiElement originalElement) {
        return PythonDocumentationProvider.getOnlyUrlFor(element, originalElement) != null;
    }

    public boolean canPromptToConfigureDocumentation(@NotNull PsiElement element) {
        PsiFile psiFile;
        if (element == null) {
            PythonDocumentationProvider.a(57);
        }
        if ((psiFile = element.getContainingFile()) instanceof PyFile) {
            QualifiedName qualifiedName;
            Project project = element.getProject();
            VirtualFile virtualFile = psiFile.getVirtualFile();
            if (virtualFile != null && ProjectRootManager.getInstance((Project)project).getFileIndex().isInLibraryClasses(virtualFile) && (qualifiedName = QualifiedNameFinder.findCanonicalImportPath(element, element)) != null && qualifiedName.getComponentCount() > 0) {
                return true;
            }
        }
        return false;
    }

    public void promptToConfigureDocumentation(@NotNull PsiElement element) {
        if (element == null) {
            PythonDocumentationProvider.a(58);
        }
        Project project = element.getProject();
        QualifiedName qualifiedName = QualifiedNameFinder.findCanonicalImportPath(element, element);
        if (qualifiedName != null && qualifiedName.getComponentCount() > 0) {
            ApplicationManager.getApplication().invokeLater(() -> {
                long l2 = d ^ 0xEE737252A4AL;
                int n2 = Messages.showOkCancelDialog((Project)project, (String)("No external documentation URL configured for module " + (String)qualifiedName.getComponents().get(0) + ".\nWould you like to configure it now?"), (String)"Python External Documentation", (Icon)Messages.getQuestionIcon());
                if (n2 == 0) {
                    ShowSettingsUtilImpl.showSettingsDialog((Project)project, (String)"com.jetbrains.python.documentation.PythonDocumentationConfigurable", (String)"");
                }
            }, ModalityState.NON_MODAL);
        }
    }

    @Nullable
    public PsiElement getCustomDocumentationElement(@NotNull Editor editor2, @NotNull PsiFile file, @Nullable PsiElement contextElement) {
        if (editor2 == null) {
            PythonDocumentationProvider.a(59);
        }
        if (file == null) {
            PythonDocumentationProvider.a(60);
        }
        if (contextElement != null) {
            PsiReference psiReference;
            PyElement pyElement;
            PyExpression pyExpression;
            IElementType iElementType = contextElement.getNode().getElementType();
            if (PythonDialectsTokenSetProvider.INSTANCE.getKeywordTokens().contains(iElementType)) {
                return contextElement;
            }
            PsiElement psiElement = contextElement.getParent();
            if (psiElement instanceof PyArgumentList && (PyTokenTypes.LPAR == iElementType || PyTokenTypes.RPAR == iElementType) && (pyExpression = (PyCallExpression)PsiTreeUtil.getParentOfType((PsiElement)contextElement, PyCallExpression.class)) != null && (pyElement = pyExpression.getCallee()) != null && (psiReference = pyElement.getReference()) != null) {
                return psiReference.resolve();
            }
            pyExpression = (PyExpression)PsiTreeUtil.getParentOfType((PsiElement)contextElement, PyExpression.class);
            if (pyExpression != null && DocStringUtil.isDocStringExpression(pyExpression) && (pyElement = (PyDocStringOwner)PsiTreeUtil.getParentOfType((PsiElement)contextElement, PyDocStringOwner.class)) != null) {
                return pyElement;
            }
        }
        return super.getCustomDocumentationElement(editor2, file, contextElement);
    }

    private static void a(@NotNull StringBuilder stringBuilder, @NotNull String string, String ... stringArray) {
        long l2 = d ^ 0x133B255EA68CL;
        if (stringBuilder == null) {
            PythonDocumentationProvider.a(61);
        }
        if (string == null) {
            PythonDocumentationProvider.a(62);
        }
        if (stringArray == null) {
            PythonDocumentationProvider.a(63);
        }
        for (String string2 : stringArray) {
            stringBuilder.append("<").append(string2).append(">");
        }
        stringBuilder.append(string);
        for (int i10 = stringArray.length - 1; i10 >= 0; --i10) {
            stringBuilder.append("</").append(stringArray[i10]).append(">");
        }
    }

    @NotNull
    private static String a(@NotNull String string) {
        if (string == null) {
            PythonDocumentationProvider.a(64);
        }
        String string2 = StringUtil.escapeXmlEntities((String)string);
        if (string2 == null) {
            PythonDocumentationProvider.a(65);
        }
        return string2;
    }

    @NotNull
    private static String a(@Nullable PyType pyType, @NotNull PsiElement psiElement, @NotNull TypeEvalContext typeEvalContext) {
        if (psiElement == null) {
            PythonDocumentationProvider.a(66);
        }
        if (typeEvalContext == null) {
            PythonDocumentationProvider.a(67);
        }
        ChainIterable<String> chainIterable = new ChainIterable<String>();
        PythonDocumentationProvider.describeTypeWithLinks(pyType, typeEvalContext, psiElement, chainIterable);
        String string = chainIterable.toString();
        if (string == null) {
            PythonDocumentationProvider.a(68);
        }
        return string;
    }

    @Nullable
    public static QualifiedName getFullQualifiedName(@Nullable PsiElement element) {
        String string;
        long l2 = d ^ 0x351C3505D329L;
        String string2 = element instanceof PsiNamedElement ? ((PsiNamedElement)element).getName() : (string = element != null ? element.getText() : null);
        if (string != null) {
            ScopeOwner scopeOwner = ScopeUtil.getScopeOwner(element);
            PyBuiltinCache pyBuiltinCache = PyBuiltinCache.getInstance(element);
            if (scopeOwner instanceof PyClass) {
                QualifiedName qualifiedName = QualifiedNameFinder.findCanonicalImportPath(element, element);
                if (qualifiedName != null) {
                    return QualifiedName.fromDottedString((String)(qualifiedName.toString() + "." + scopeOwner.getName() + "." + string));
                }
            } else if (scopeOwner instanceof PyFunction && "__init__".equals(scopeOwner.getName()) && ((PyFunction)scopeOwner).getContainingClass() != null) {
                QualifiedName qualifiedName = QualifiedNameFinder.findCanonicalImportPath((PsiElement)scopeOwner, element);
                if (qualifiedName != null) {
                    return QualifiedName.fromDottedString((String)(qualifiedName.toString() + "." + ((PyFunction)scopeOwner).getContainingClass().getName() + "." + string));
                }
            } else if (scopeOwner instanceof PyFile) {
                QualifiedName qualifiedName;
                if (pyBuiltinCache.isBuiltin(element)) {
                    return QualifiedName.fromDottedString((String)string);
                }
                VirtualFile virtualFile = ((PyFile)scopeOwner).getVirtualFile();
                if (virtualFile != null && (qualifiedName = QualifiedNameFinder.findCanonicalImportPath(element, element)) != null) {
                    return QualifiedName.fromDottedString((String)(qualifiedName.toString() + "." + string));
                }
            } else if (element instanceof PyFile) {
                return QualifiedNameFinder.findCanonicalImportPath(element, element);
            }
        }
        return null;
    }

    static {
        d = com.jetbrains.python.psi.c.a(5982451132446418253L, 1605542383987590128L, MethodHandles.lookup().lookupClass()).a(59244377520701L);
        c = Logger.getInstance(PythonDocumentationProvider.class);
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = d ^ 0x2388B6F12A73L;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 9: 
            case 12: 
            case 15: 
            case 21: 
            case 23: 
            case 28: 
            case 30: 
            case 36: 
            case 41: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 53: 
            case 65: 
            case 68: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 4: 
            case 9: 
            case 12: 
            case 15: 
            case 21: 
            case 23: 
            case 28: 
            case 30: 
            case 36: 
            case 41: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 53: 
            case 65: 
            case 68: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalElement";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 2: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 3: 
            case 6: 
            case 8: 
            case 11: 
            case 14: 
            case 19: 
            case 20: 
            case 22: 
            case 24: 
            case 27: 
            case 29: 
            case 40: 
            case 44: 
            case 56: 
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: 
            case 9: 
            case 12: 
            case 15: 
            case 21: 
            case 23: 
            case 28: 
            case 30: 
            case 36: 
            case 41: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 53: 
            case 65: 
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/documentation/PythonDocumentationProvider";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "definition";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 16: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 18: 
            case 33: 
            case 39: 
            case 43: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "escaper";
                break;
            }
            case 25: 
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "body";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "decoratable";
                break;
            }
            case 32: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "escapedCalleeMapper";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "separator";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suffix";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cls";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "escapedNameMapper";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "decorator";
                break;
            }
            case 54: 
            case 57: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "link";
                break;
            }
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "escapedContent";
                break;
            }
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tags";
                break;
            }
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unescaped";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/documentation/PythonDocumentationProvider";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "describeFunction";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "describeTarget";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "describeParameter";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "describeFunctionWithTypes";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeName";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeHint";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeDescription";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "buildTypeModel";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "describeDecorators";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "describeClass";
                break;
            }
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "describeSuperClass";
                break;
            }
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "describeDecorator";
                break;
            }
            case 65: {
                objectArray = objectArray2;
                objectArray2[1] = "escaped";
                break;
            }
            case 68: {
                objectArray = objectArray2;
                objectArray2[1] = "formatTypeWithLinks";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getQuickNavigateInfo";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getDocStringSummary";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "describeFunction";
                break;
            }
            case 4: 
            case 9: 
            case 12: 
            case 15: 
            case 21: 
            case 23: 
            case 28: 
            case 30: 
            case 36: 
            case 41: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 53: 
            case 65: 
            case 68: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "showOverloads";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "describeTarget";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "describeParameter";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "describeFunctionWithTypes";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "describeExpression";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getTypeName";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getTypeHint";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "describeTypeWithLinks";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getTypeDescription";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "buildTypeModel";
                break;
            }
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "describeDecorators";
                break;
            }
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "describeClass";
                break;
            }
            case 42: 
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "describeSuperClass";
                break;
            }
            case 50: 
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "describeDecorator";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "generateDoc";
                break;
            }
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "getDocumentationElementForLink";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "canPromptToConfigureDocumentation";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "promptToConfigureDocumentation";
                break;
            }
            case 59: 
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "getCustomDocumentationElement";
                break;
            }
            case 61: 
            case 62: 
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "appendWithTags";
                break;
            }
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "escaped";
                break;
            }
            case 66: 
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "formatTypeWithLinks";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 9: 
            case 12: 
            case 15: 
            case 21: 
            case 23: 
            case 28: 
            case 30: 
            case 36: 
            case 41: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 53: 
            case 65: 
            case 68: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

