/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger.array;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListenableFutureTask;
import com.intellij.openapi.util.Pair;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import com.jetbrains.python.debugger.ArrayChunk;
import com.jetbrains.python.debugger.ArrayChunkBuilder;
import com.jetbrains.python.debugger.PyDebugValue;
import com.jetbrains.python.debugger.containerview.DataViewStrategy;
import com.jetbrains.python.debugger.containerview.PyDataViewerPanel;
import com.jetbrains.python.psi.c;
import java.lang.invoke.MethodHandles;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NotNull;

public class AsyncArrayTableModel
extends AbstractTableModel {
    private static final int h = 30;
    private static final int g = 30;
    public static final String EMPTY_CELL_VALUE = "";
    private final int d;
    private final int a;
    private final PyDataViewerPanel c;
    private final ExecutorService e;
    private final MergingUpdateQueue f;
    private PyDebugValue b;
    private final DataViewStrategy j;
    private final LoadingCache<Pair<Integer, Integer>, ListenableFuture<ArrayChunk>> i;
    private static final long m = com.jetbrains.python.psi.c.a(1086875091753597571L, 3728144462849882547L, MethodHandles.lookup().lookupClass()).a(138417182562137L);

    public AsyncArrayTableModel(int rows, int columns, PyDataViewerPanel provider, PyDebugValue debugValue, DataViewStrategy strategy) {
        long l2 = m ^ 0x76B9026A0D05L;
        this.e = ConcurrencyUtil.newSingleThreadExecutor((String)"Python async table");
        this.f = new MergingUpdateQueue("Python async table queue", 100, true, null);
        this.i = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<Pair<Integer, Integer>, ListenableFuture<ArrayChunk>>(){
            private static final long a = com.jetbrains.python.psi.c.a(5524764012647966940L, 2136892156149247531L, MethodHandles.lookup().lookupClass()).a(110980682166581L);

            public ListenableFuture<ArrayChunk> load(@NotNull Pair<Integer, Integer> key) throws Exception {
                if (key == null) {
                    1.a(0);
                }
                return ListenableFutureTask.create(() -> {
                    ArrayChunk arrayChunk = AsyncArrayTableModel.this.b.getFrameAccessor().getArrayItems(AsyncArrayTableModel.this.b, ((Integer)pair.first).intValue(), ((Integer)pair.second).intValue(), Math.min(30, AsyncArrayTableModel.this.getRowCount() - (Integer)pair.first), Math.min(30, AsyncArrayTableModel.this.getColumnCount() - (Integer)pair.second), AsyncArrayTableModel.this.c.getFormat());
                    AsyncArrayTableModel.this.handleChunkAdded((Integer)pair.first, (Integer)pair.second, arrayChunk);
                    return arrayChunk;
                });
            }

            private static /* synthetic */ void a(int n2) {
                long l2 = a ^ 0x331A53F336B7L;
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/jetbrains/python/debugger/array/AsyncArrayTableModel$1", "load"));
            }
        });
        this.d = rows;
        this.a = columns;
        this.c = provider;
        this.b = debugValue;
        this.j = strategy;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return false;
    }

    @Override
    public Object getValueAt(int row, int col) {
        long l2 = m ^ 0x3B906A26FD0L;
        Pair<Integer, Integer> pair = AsyncArrayTableModel.a(row, col);
        try {
            final ListenableFuture listenableFuture = (ListenableFuture)this.i.get(pair);
            if (listenableFuture.isDone()) {
                Object[][] objectArray = ((ArrayChunk)listenableFuture.get()).getData();
                int n2 = row % 30;
                int n3 = col % 30;
                if (n2 < objectArray.length && n3 < objectArray[n2].length) {
                    return this.correctStringValue(objectArray[n2][n3]);
                }
            } else {
                this.f.queue(new Update("get chunk from debugger"){

                    public void run() {
                        listenableFuture.addListener(() -> UIUtil.invokeLaterIfNeeded(() -> AsyncArrayTableModel.this.fireTableDataChanged()), (Executor)AsyncArrayTableModel.this.e);
                        AsyncArrayTableModel.this.e.execute((Runnable)((ListenableFutureTask)listenableFuture));
                    }
                });
            }
            return EMPTY_CELL_VALUE;
        }
        catch (Exception exception) {
            return EMPTY_CELL_VALUE;
        }
    }

    public String correctStringValue(@NotNull Object value) {
        if (value == null) {
            AsyncArrayTableModel.b(0);
        }
        if (value instanceof String) {
            String string = (String)value;
            if (this.j.isNumeric(this.b.getType()) && (string.startsWith("'") || string.startsWith("\""))) {
                string = string.substring(1, string.length() - 1);
            }
            return string;
        }
        if (value instanceof Integer) {
            return Integer.toString((Integer)value);
        }
        return value.toString();
    }

    private static Pair<Integer, Integer> a(int n2, int n3) {
        return Pair.create((Object)AsyncArrayTableModel.c(n2), (Object)AsyncArrayTableModel.a(n3));
    }

    private static int c(int n2) {
        return n2 - n2 % 30;
    }

    private static int a(int n2) {
        return n2 - n2 % 30;
    }

    @Override
    public int getColumnCount() {
        return this.a;
    }

    @Override
    public String getColumnName(int col) {
        return String.valueOf(col);
    }

    @Override
    public int getRowCount() {
        return this.d;
    }

    public void changeValue(int row, int col, Object value) {
        long l2 = m ^ 0x368EA29B5413L;
        Future future2 = (Future)this.i.getIfPresent(AsyncArrayTableModel.a(row, col));
        if (future2 != null && future2.isDone()) {
            try {
                ((ArrayChunk)future2.get()).getData()[row - AsyncArrayTableModel.c((int)row)][col - AsyncArrayTableModel.a((int)col)] = value;
            }
            catch (Exception exception) {
                throw new IllegalStateException(exception);
            }
        } else {
            throw new IllegalArgumentException("Forced to change empty cell in " + row + " row and " + col + " column.");
        }
    }

    public void addToCache(final ArrayChunk chunk) {
        Object[][] objectArray = chunk.getData();
        int n2 = objectArray.length;
        int n3 = objectArray[0].length;
        for (int i10 = 0; i10 < n2 / 30; ++i10) {
            for (int i11 = 0; i11 < n3 / 30; ++i11) {
                Pair<Integer, Integer> pair = AsyncArrayTableModel.a(i10 * 30, i11 * 30);
                final Object[][] objectArray2 = new Object[30][30];
                for (int i12 = 0; i12 < 30; ++i12) {
                    System.arraycopy(objectArray[i10 * 30 + i12], i11 * 30, objectArray2[i12], 0, 30);
                }
                this.i.put(pair, (Object)new ListenableFuture<ArrayChunk>(){
                    private static final long a = com.jetbrains.python.psi.c.a(126957419014697263L, 297069556464126978L, MethodHandles.lookup().lookupClass()).a(56241058273009L);

                    public void addListener(@NotNull Runnable listener2, @NotNull Executor executor) {
                        if (listener2 == null) {
                            3.a(0);
                        }
                        if (executor == null) {
                            3.a(1);
                        }
                    }

                    public boolean cancel(boolean mayInterruptIfRunning) {
                        return false;
                    }

                    public boolean isCancelled() {
                        return false;
                    }

                    public boolean isDone() {
                        return true;
                    }

                    public ArrayChunk get() throws InterruptedException, ExecutionException {
                        return new ArrayChunkBuilder().setValue(chunk.getValue()).setSlicePresentation(null).setRows(0).setColumns(0).setMax(null).setMin(null).setFormat(null).setType(null).setData(objectArray2).createArrayChunk();
                    }

                    public ArrayChunk get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                        return new ArrayChunkBuilder().setValue(chunk.getValue()).setSlicePresentation(null).setRows(0).setColumns(0).setMax(null).setMin(null).setFormat(null).setType(null).setData(objectArray2).createArrayChunk();
                    }

                    private static /* synthetic */ void a(int n2) {
                        Object[] objectArray;
                        long l2 = a ^ 0x1C62DB545973L;
                        Object[] objectArray22 = new Object[3];
                        switch (n2) {
                            default: {
                                objectArray = objectArray22;
                                objectArray22[0] = "listener";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray22;
                                objectArray22[0] = "executor";
                                break;
                            }
                        }
                        objectArray[1] = "com/jetbrains/python/debugger/array/AsyncArrayTableModel$3";
                        objectArray[2] = "addListener";
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                });
            }
        }
        this.handleChunkAdded(0, 0, chunk);
    }

    protected void handleChunkAdded(Integer rowOffset, Integer colOffset, ArrayChunk chunk) {
    }

    public TableModel getRowHeaderModel() {
        return new RowNumberHeaderModel();
    }

    public void invalidateCache() {
        this.i.invalidateAll();
    }

    public PyDebugValue getDebugValue() {
        return this.b;
    }

    public void setDebugValue(PyDebugValue debugValue) {
        this.b = debugValue;
    }

    private static /* synthetic */ void b(int n2) {
        long l2 = m ^ 0x5E55BBC5DB32L;
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/jetbrains/python/debugger/array/AsyncArrayTableModel", "correctStringValue"));
    }

    private class RowNumberHeaderModel
    extends AbstractTableModel {
        private static final long a = com.jetbrains.python.psi.c.a(-1114044862420553849L, -3405529000417460715L, MethodHandles.lookup().lookupClass()).a(172456978818620L);

        private RowNumberHeaderModel() {
        }

        @Override
        public int getRowCount() {
            return AsyncArrayTableModel.this.getRowCount();
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public String getColumnName(int column) {
            long l2 = a ^ 0x277123F16A3FL;
            if (column == 0) {
                return "   ";
            }
            throw new IllegalArgumentException("Table only has one column");
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            return Integer.toString(rowIndex);
        }
    }
}

