/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.debugger.PyDebugProcess;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyBinaryExpression;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyExpressionStatement;
import com.jetbrains.python.psi.PyLiteralExpression;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.PyPrefixExpression;
import com.jetbrains.python.psi.PyQualifiedExpression;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PySliceExpression;
import com.jetbrains.python.psi.c;
import java.lang.invoke.MethodHandles;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyDebugSupportUtils {
    public static final String DEBUGGER_WARNING_MESSAGE = "This option may slow down the debugger";
    private static final long a = c.a(-3586037380686784909L, 7926239244796643496L, MethodHandles.lookup().lookupClass()).a(6171370935935L);

    private PyDebugSupportUtils() {
    }

    public static boolean isExpression(Project project, String expression) {
        return (Boolean)ReadAction.compute(() -> {
            PsiFile psiFile = PyElementGenerator.getInstance(project).createDummyFile(LanguageLevel.getDefault(), expression);
            return psiFile.getFirstChild() instanceof PyExpressionStatement && psiFile.getFirstChild() == psiFile.getLastChild();
        });
    }

    @Nullable
    public static TextRange getExpressionRangeAtOffset(Project project, Document document, int offset) {
        return (TextRange)ReadAction.compute(() -> {
            PsiFile psiFile = PsiDocumentManager.getInstance((Project)project).getPsiFile(document);
            if (psiFile != null) {
                PsiElement psiElement = psiFile.findElementAt(offset);
                if (!(psiElement instanceof PyExpression) || psiElement instanceof PyLiteralExpression) {
                    psiElement = PsiTreeUtil.getParentOfType((PsiElement)psiElement, PyExpression.class);
                }
                if (psiElement instanceof PyLiteralExpression) {
                    return null;
                }
                if (psiElement != null && PyDebugSupportUtils.a(psiElement) && PyDebugSupportUtils.isExpression(project, document.getText(psiElement.getTextRange()))) {
                    return psiElement.getTextRange();
                }
            }
            return null;
        });
    }

    private static boolean a(PsiElement psiElement) {
        return psiElement instanceof PyLiteralExpression || psiElement instanceof PyQualifiedExpression || psiElement instanceof PyBinaryExpression || psiElement instanceof PyPrefixExpression || psiElement instanceof PySliceExpression || psiElement instanceof PyNamedParameter;
    }

    public static boolean canSaveToTemp(Project project, String expression) {
        return (Boolean)ReadAction.compute(() -> {
            PsiFile psiFile = PyElementGenerator.getInstance(project).createDummyFile(LanguageLevel.getDefault(), expression);
            PsiElement psiElement = psiFile.getFirstChild();
            return PyDebugSupportUtils.b(psiElement) == false && psiElement instanceof PyExpressionStatement;
        });
    }

    private static Boolean b(PsiElement psiElement) {
        return psiElement instanceof PyExpressionStatement && psiElement.getFirstChild() instanceof PyReferenceExpression && psiElement.getFirstChild() == psiElement.getLastChild() && psiElement.getFirstChild().getFirstChild() != null && psiElement.getFirstChild().getFirstChild().getNode().getElementType() == PyTokenTypes.IDENTIFIER && psiElement.getFirstChild().getFirstChild() == psiElement.getFirstChild().getLastChild() && psiElement.getFirstChild().getFirstChild().getFirstChild() == null;
    }

    @Nullable
    private static String a(@NotNull Document document, int n2) {
        if (document == null) {
            PyDebugSupportUtils.a(0);
        }
        if (n2 > 0 && n2 < document.getLineCount()) {
            return document.getText(TextRange.create((int)document.getLineStartOffset(n2), (int)document.getLineEndOffset(n2)));
        }
        return null;
    }

    public static boolean isContinuationLine(@NotNull Document document, int line2) {
        String string;
        if (document == null) {
            PyDebugSupportUtils.a(1);
        }
        return (string = PyDebugSupportUtils.a(document, line2)) != null && string.trim().endsWith("\\");
    }

    public static boolean isCurrentPythonDebugProcess(@NotNull Project project) {
        XDebugSession xDebugSession;
        if (project == null) {
            PyDebugSupportUtils.a(2);
        }
        return (xDebugSession = XDebuggerManager.getInstance((Project)project).getCurrentSession()) != null && xDebugSession.getDebugProcess() instanceof PyDebugProcess;
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        long l2 = a ^ 0x2E0015A141A4L;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/python/debugger/PyDebugSupportUtils";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getLineText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isContinuationLine";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isCurrentPythonDebugProcess";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

