/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.remote.RemoteProcessControl;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebugSessionListener;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.SuspendPolicy;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointHandler;
import com.intellij.xdebugger.breakpoints.XBreakpointType;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XExecutionStack;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.frame.XSuspendContext;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.intellij.xdebugger.frame.XValueNode;
import com.intellij.xdebugger.stepping.XSmartStepIntoHandler;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.PythonFileType;
import com.jetbrains.python.console.PythonConsoleView;
import com.jetbrains.python.console.PythonDebugLanguageConsoleView;
import com.jetbrains.python.console.pydev.PydevCompletionVariant;
import com.jetbrains.python.debugger.ArrayChunk;
import com.jetbrains.python.debugger.ExceptionBreakpointProperties;
import com.jetbrains.python.debugger.IPyDebugProcess;
import com.jetbrains.python.debugger.PositionConverterProvider;
import com.jetbrains.python.debugger.PyBreakpointHandlerFactory;
import com.jetbrains.python.debugger.PyBreakpointType;
import com.jetbrains.python.debugger.PyConcurrencyEvent;
import com.jetbrains.python.debugger.PyConcurrencyService;
import com.jetbrains.python.debugger.PyCythonExtensionWarning;
import com.jetbrains.python.debugger.PyDebugSupportUtils;
import com.jetbrains.python.debugger.PyDebugValue;
import com.jetbrains.python.debugger.PyDebugValueExecutionService;
import com.jetbrains.python.debugger.PyDebuggerEditorsProvider;
import com.jetbrains.python.debugger.PyDebuggerException;
import com.jetbrains.python.debugger.PyExceptionBreakpointHandler;
import com.jetbrains.python.debugger.PyExecutionStack;
import com.jetbrains.python.debugger.PyFrameAccessor;
import com.jetbrains.python.debugger.PyFrameListener;
import com.jetbrains.python.debugger.PyLineBreakpointHandler;
import com.jetbrains.python.debugger.PyLocalPositionConverter;
import com.jetbrains.python.debugger.PyPositionConverter;
import com.jetbrains.python.debugger.PyReferrersLoader;
import com.jetbrains.python.debugger.PyReferringObjectsValue;
import com.jetbrains.python.debugger.PySignature;
import com.jetbrains.python.debugger.PySignatureCacheManager;
import com.jetbrains.python.debugger.PySmartStepIntoHandler;
import com.jetbrains.python.debugger.PySourcePosition;
import com.jetbrains.python.debugger.PyStackFrame;
import com.jetbrains.python.debugger.PyStackFrameInfo;
import com.jetbrains.python.debugger.PySuspendContext;
import com.jetbrains.python.debugger.PyThreadInfo;
import com.jetbrains.python.debugger.PyVariableViewSettings;
import com.jetbrains.python.debugger.containerview.PyViewNumericContainerAction;
import com.jetbrains.python.debugger.pydev.ClientModeMultiProcessDebugger;
import com.jetbrains.python.debugger.pydev.ExceptionBreakpointCommandFactory;
import com.jetbrains.python.debugger.pydev.MultiProcessDebugger;
import com.jetbrains.python.debugger.pydev.ProcessDebugger;
import com.jetbrains.python.debugger.pydev.PyDebugCallback;
import com.jetbrains.python.debugger.pydev.RemoteDebugger;
import com.jetbrains.python.debugger.pydev.RemoteDebuggerCloseListener;
import com.jetbrains.python.debugger.pydev.ResumeOrStepCommand;
import com.jetbrains.python.debugger.settings.PyDebuggerSettings;
import com.jetbrains.python.psi.AccessDirection;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyImportElement;
import com.jetbrains.python.psi.PyPsiFacade;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.c;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.resolve.PyResolveUtil;
import com.jetbrains.python.psi.resolve.RatedResolveResult;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyModuleType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.PyTypeParser;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.net.ServerSocket;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyDebugProcess
extends XDebugProcess
implements IPyDebugProcess,
ProcessListener {
    private static final Logger i;
    private static final int v = 60000;
    public static final NotificationGroup NOTIFICATION_GROUP;
    private final ProcessDebugger l;
    private final XBreakpointHandler[] a;
    private final PyDebuggerEditorsProvider f;
    private final ProcessHandler c;
    private final ExecutionConsole p;
    private final Map<PySourcePosition, XLineBreakpoint> m;
    private final Map<String, XBreakpoint<? extends ExceptionBreakpointProperties>> d;
    private final List<PyThreadInfo> r;
    private final Map<String, XValueChildrenList> n;
    private final Object t;
    private final Map<String, PyDebugValue> q;
    private boolean s;
    private boolean o;
    protected PyPositionConverter myPositionConverter;
    private final XSmartStepIntoHandler<?> j;
    private boolean h;
    private PyStackFrame k;
    private PyReferrersLoader b;
    private final List<PyFrameListener> u;
    private boolean e;
    @Nullable
    private XCompositeNode g;
    private static final long z;

    public PyDebugProcess(@NotNull XDebugSession session, @NotNull ServerSocket serverSocket, @NotNull ExecutionConsole executionConsole, @Nullable ProcessHandler processHandler, boolean multiProcess) {
        if (session == null) {
            PyDebugProcess.a(0);
        }
        if (serverSocket == null) {
            PyDebugProcess.a(1);
        }
        if (executionConsole == null) {
            PyDebugProcess.a(2);
        }
        this(session, multiProcess ? pyDebugProcess -> pyDebugProcess.a(serverSocket) : pyDebugProcess -> new RemoteDebugger((IPyDebugProcess)pyDebugProcess, serverSocket, pyDebugProcess.getConnectTimeout()), executionConsole, processHandler);
    }

    public PyDebugProcess(@NotNull XDebugSession session, @NotNull ExecutionConsole executionConsole, @Nullable ProcessHandler processHandler, @NotNull String serverHost, int serverPort) {
        if (session == null) {
            PyDebugProcess.a(3);
        }
        if (executionConsole == null) {
            PyDebugProcess.a(4);
        }
        if (serverHost == null) {
            PyDebugProcess.a(5);
        }
        this(session, pyDebugProcess -> new ClientModeMultiProcessDebugger((IPyDebugProcess)pyDebugProcess, serverHost, serverPort), executionConsole, processHandler);
    }

    private PyDebugProcess(final @NotNull XDebugSession session, @NotNull DebuggerFactory debuggerFactory, @NotNull ExecutionConsole executionConsole, @Nullable ProcessHandler processHandler) {
        if (session == null) {
            PyDebugProcess.a(6);
        }
        if (debuggerFactory == null) {
            PyDebugProcess.a(7);
        }
        if (executionConsole == null) {
            PyDebugProcess.a(8);
        }
        super(session);
        this.m = new ConcurrentHashMap<PySourcePosition, XLineBreakpoint>();
        this.d = new ConcurrentHashMap<String, XBreakpoint<? extends ExceptionBreakpointProperties>>();
        this.r = Collections.synchronizedList(Lists.newArrayList());
        this.n = Maps.newConcurrentMap();
        this.t = new Object();
        this.q = Maps.newHashMap();
        this.s = false;
        this.o = false;
        this.h = false;
        this.k = null;
        this.u = ContainerUtil.createLockFreeCopyOnWriteList();
        this.e = false;
        session.setPauseActionSupported(true);
        this.l = debuggerFactory.createDebugger(this);
        ArrayList<XBreakpointHandler> arrayList = new ArrayList<XBreakpointHandler>();
        arrayList.add(new PyLineBreakpointHandler(this));
        arrayList.add(new PyExceptionBreakpointHandler(this));
        for (PyBreakpointHandlerFactory pyBreakpointHandlerFactory : PyBreakpointHandlerFactory.EP_NAME.getExtensionList()) {
            arrayList.add(pyBreakpointHandlerFactory.createBreakpointHandler(this));
        }
        this.a = arrayList.toArray(XBreakpointHandler.EMPTY_ARRAY);
        this.f = new PyDebuggerEditorsProvider();
        this.j = new PySmartStepIntoHandler(this);
        this.c = processHandler;
        this.p = executionConsole;
        if (this.c != null) {
            this.c.addProcessListener((ProcessListener)this);
        }
        this.myPositionConverter = processHandler instanceof PositionConverterProvider ? ((PositionConverterProvider)processHandler).createPositionConverter(this) : new PyLocalPositionConverter();
        final PyDebugValueExecutionService pyDebugValueExecutionService = PyDebugValueExecutionService.getInstance((Project)this.getProject());
        pyDebugValueExecutionService.sessionStarted((PyFrameAccessor)this);
        session.addSessionListener(new XDebugSessionListener(){

            public void sessionStopped() {
                pyDebugValueExecutionService.sessionStopped((PyFrameAccessor)PyDebugProcess.this);
            }
        });
        this.l.addCloseListener(new RemoteDebuggerCloseListener(){

            public void closed() {
                PyDebugProcess.this.handleStop();
            }

            public void communicationError() {
                PyDebugProcess.this.detachDebuggedProcess();
            }

            public void detached() {
                PyDebugProcess.this.detachDebuggedProcess();
            }
        });
        session.addSessionListener(new XDebugSessionListener(){

            public void stackFrameChanged() {
                XExecutionStack xExecutionStack;
                String string = null;
                XStackFrame xStackFrame = session.getCurrentStackFrame();
                if (xStackFrame instanceof PyStackFrame) {
                    string = ((PyStackFrame)xStackFrame).getThreadId();
                }
                if ((xExecutionStack = session.getSuspendContext().getActiveExecutionStack()) == null || string == null) {
                    return;
                }
                XStackFrame xStackFrame2 = xExecutionStack.getTopFrame();
                String string2 = null;
                if (xStackFrame2 instanceof PyStackFrame) {
                    string2 = ((PyStackFrame)xStackFrame2).getThreadId();
                }
                if (!string.equals(string2)) {
                    PyThreadInfo pyThreadInfo = null;
                    for (PyThreadInfo pyThreadInfo2 : PyDebugProcess.this.r) {
                        if (!pyThreadInfo2.getId().equals(string)) continue;
                        pyThreadInfo = pyThreadInfo2;
                        break;
                    }
                    if (pyThreadInfo != null) {
                        PyDebugProcess.this.getSession().positionReached((XSuspendContext)PyDebugProcess.this.createSuspendContext(pyThreadInfo));
                    }
                }
                for (PyFrameListener pyFrameListener : PyDebugProcess.this.u) {
                    pyFrameListener.frameChanged();
                }
            }
        });
    }

    private MultiProcessDebugger a(ServerSocket serverSocket) {
        MultiProcessDebugger multiProcessDebugger = new MultiProcessDebugger((IPyDebugProcess)this, serverSocket, this.getConnectTimeout());
        multiProcessDebugger.addOtherDebuggerCloseListener(new MultiProcessDebugger.DebuggerProcessListener(){

            public void threadsClosed(Set<String> threadIds) {
                for (PyThreadInfo pyThreadInfo : PyDebugProcess.this.r) {
                    if (!threadIds.contains(pyThreadInfo.getId()) || !PyDebugProcess.this.getSession().isSuspended()) continue;
                    PyDebugProcess.this.getSession().resume();
                    break;
                }
            }
        });
        return multiProcessDebugger;
    }

    protected void detachDebuggedProcess() {
        this.handleStop();
    }

    protected void handleStop() {
        this.getSession().stop();
    }

    public void setPositionConverter(PyPositionConverter positionConverter) {
        this.myPositionConverter = positionConverter;
    }

    public PyPositionConverter getPositionConverter() {
        return this.myPositionConverter;
    }

    @NotNull
    public XBreakpointHandler<?>[] getBreakpointHandlers() {
        if (this.a == null) {
            PyDebugProcess.a(9);
        }
        return this.a;
    }

    @NotNull
    public XDebuggerEditorsProvider getEditorsProvider() {
        PyDebuggerEditorsProvider pyDebuggerEditorsProvider = this.f;
        if (pyDebuggerEditorsProvider == null) {
            PyDebugProcess.a(10);
        }
        return pyDebuggerEditorsProvider;
    }

    @Nullable
    protected ProcessHandler doGetProcessHandler() {
        return this.c;
    }

    @NotNull
    public ExecutionConsole createConsole() {
        ExecutionConsole executionConsole = this.p;
        if (executionConsole == null) {
            PyDebugProcess.a(11);
        }
        return executionConsole;
    }

    public XSmartStepIntoHandler<?> getSmartStepIntoHandler() {
        return this.j;
    }

    public void sessionInitialized() {
        this.waitForConnection(this.getConnectionMessage(), this.getConnectionTitle());
    }

    protected void waitForConnection(final String connectionMessage, String connectionTitle) {
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(this.getSession().getProject(), connectionTitle, false){
            private static final long a = com.jetbrains.python.psi.c.a(-4421589456829857664L, 4801145048804453219L, MethodHandles.lookup().lookupClass()).a(151275632061625L);

            public void run(@NotNull ProgressIndicator indicator) {
                block4: {
                    long l2 = a ^ 0x8880FAAE25DL;
                    if (indicator == null) {
                        5.a(0);
                    }
                    indicator.setText(connectionMessage);
                    try {
                        PyDebugProcess.this.beforeConnect();
                        PyDebugProcess.this.h = true;
                        PyDebugProcess.this.l.waitForConnect();
                        PyDebugProcess.this.h = false;
                        PyDebugProcess.this.afterConnect();
                        PyDebugProcess.this.c();
                        PyDebugProcess.this.init();
                        PyDebugProcess.this.l.run();
                    }
                    catch (Exception exception) {
                        PyDebugProcess.this.h = false;
                        if (PyDebugProcess.this.c != null) {
                            PyDebugProcess.this.c.destroyProcess();
                        }
                        if (!PyDebugProcess.this.shouldLogConnectionException(exception)) break block4;
                        NOTIFICATION_GROUP.createNotification(PyBundle.message("debug.notification.title.connection.failed", new Object[0]), exception.getMessage(), NotificationType.ERROR, null).notify(this.myProject);
                    }
                }
            }

            private static /* synthetic */ void a(int n2) {
                long l2 = a ^ 0x5CFEE21E3F25L;
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/jetbrains/python/debugger/PyDebugProcess$5", "run"));
            }
        });
    }

    protected boolean shouldLogConnectionException(Exception e10) {
        return true;
    }

    public void init() {
        this.getSession().rebuildViews();
        this.a();
        this.setShowReturnValues(PyDebuggerSettings.getInstance().isWatchReturnValues());
    }

    public int handleDebugPort(int localPort) throws IOException {
        if (this.c instanceof RemoteProcessControl) {
            return (Integer)PyDebugProcess.getRemoteHostPortForDebuggerConnection(localPort, (RemoteProcessControl)this.c).getSecond();
        }
        return localPort;
    }

    protected static Pair<String, Integer> getRemoteHostPortForDebuggerConnection(int localPort, @NotNull RemoteProcessControl handler) throws IOException {
        if (handler == null) {
            PyDebugProcess.a(12);
        }
        try {
            return handler.getRemoteSocket(localPort);
        }
        catch (Exception exception) {
            throw new IOException(exception);
        }
    }

    public void recordSignature(PySignature signature) {
        PySignatureCacheManager.getInstance(this.getSession().getProject()).recordSignature(this.myPositionConverter.convertSignature(signature));
    }

    public void recordLogEvent(PyConcurrencyEvent event) {
        PyConcurrencyService.getInstance(this.getSession().getProject()).recordEvent(this.getSession(), event, event.isAsyncio());
    }

    public void showConsole(PyThreadInfo thread2) {
        this.k = new PyExecutionStack(this, thread2).getTopFrame();
        if (this.p instanceof PythonDebugLanguageConsoleView) {
            PythonDebugLanguageConsoleView pythonDebugLanguageConsoleView = (PythonDebugLanguageConsoleView)this.p;
            UIUtil.invokeLaterIfNeeded(() -> {
                pythonDebugLanguageConsoleView.enableConsole(false);
                pythonDebugLanguageConsoleView.getPydevConsoleView().setConsoleEnabled(true);
            });
        }
    }

    public void consoleInputRequested(boolean isStarted) {
        if (this.p instanceof PythonDebugLanguageConsoleView) {
            PythonConsoleView pythonConsoleView = ((PythonDebugLanguageConsoleView)this.p).getPydevConsoleView();
            if (isStarted) {
                pythonConsoleView.inputRequested();
            } else {
                pythonConsoleView.inputReceived();
            }
        }
    }

    public void showCythonWarning() {
    }

    public void showWarning(String warningId) {
        long l2 = z ^ 0x7671FD5D0B9DL;
        if (warningId.equals("cython") && !this.e) {
            PyCythonExtensionWarning.showCythonExtensionWarning(this.getSession().getProject());
            this.e = true;
        }
    }

    protected void afterConnect() {
    }

    protected void beforeConnect() {
    }

    protected String getConnectionMessage() {
        long l2 = z ^ 0x552DA4987C9BL;
        return "Waiting for connection...";
    }

    protected String getConnectionTitle() {
        long l2 = z ^ 0xED94B2C96DAL;
        return "Connecting To Debugger";
    }

    private void c() throws PyDebuggerException {
        long l2 = z ^ 0x7AB8E31293A3L;
        String string = this.l.handshake();
        String string2 = ApplicationInfo.getInstance().getBuild().asStringWithoutProductCode();
        string = "@@BUILD_NUMBER@@".equals(string) ? string2 : StringUtil.trimStart((String)string, (String)"PY-");
        this.printToConsole("Connected to pydev debugger (build " + string + ")\n", ConsoleViewContentType.SYSTEM_OUTPUT);
        if (string != null && !string.equals(string2) && !string.startsWith(string2)) {
            i.warn(String.format("Wrong debugger version. Remote version: %s Current build: %s", string, string2));
            this.printToConsole(String.format("Warning: wrong debugger version. Use pycharm-debugger.egg from PyCharm installation folder\nOr execute: 'pip install pydevd-pycharm~=%s'\n", string2), ConsoleViewContentType.ERROR_OUTPUT);
        }
    }

    public void printToConsole(String text2, ConsoleViewContentType contentType) {
        ((ConsoleView)this.p).print(text2, contentType);
    }

    private void a() {
        this.registerLineBreakpoints();
        this.b();
    }

    private void b() {
        for (XBreakpoint<? extends ExceptionBreakpointProperties> xBreakpoint : this.d.values()) {
            this.addExceptionBreakpoint(xBreakpoint);
        }
    }

    public void registerLineBreakpoints() {
        for (Map.Entry<PySourcePosition, XLineBreakpoint> entry : this.m.entrySet()) {
            this.addBreakpoint(entry.getKey(), entry.getValue());
        }
    }

    public void registerAdditionalActions(@NotNull DefaultActionGroup leftToolbar, @NotNull DefaultActionGroup topToolbar, @NotNull DefaultActionGroup settings) {
        if (leftToolbar == null) {
            PyDebugProcess.a(13);
        }
        if (topToolbar == null) {
            PyDebugProcess.a(14);
        }
        if (settings == null) {
            PyDebugProcess.a(15);
        }
        super.registerAdditionalActions(leftToolbar, topToolbar, settings);
        settings.add((AnAction)new WatchReturnValuesAction(this));
        settings.add((AnAction)new PyVariableViewSettings.SimplifiedView(this));
        settings.add((AnAction)new PyVariableViewSettings.VariablesPolicyGroup());
    }

    public void setShowReturnValues(boolean showReturnValues) {
        this.l.setShowReturnValues(showReturnValues);
    }

    public void startStepOver(@Nullable XSuspendContext context) {
        this.a(context, ResumeOrStepCommand.Mode.STEP_OVER);
    }

    public void startStepInto(@Nullable XSuspendContext context) {
        this.a(context, ResumeOrStepCommand.Mode.STEP_INTO);
    }

    public void startStepIntoMyCode(@Nullable XSuspendContext context) {
        if (!this.checkCanPerformCommands()) {
            return;
        }
        this.getSession().sessionResumed();
        this.a(context, ResumeOrStepCommand.Mode.STEP_INTO_MY_CODE);
    }

    public void startSetNextStatement(@Nullable XSuspendContext context, @NotNull XSourcePosition sourcePosition, @NotNull PyDebugCallback<Pair<Boolean, String>> callback) {
        if (sourcePosition == null) {
            PyDebugProcess.a(16);
        }
        if (callback == null) {
            PyDebugProcess.a(17);
        }
        if (!this.checkCanPerformCommands()) {
            return;
        }
        this.d();
        if (this.isConnected()) {
            String string = PyDebugProcess.a(context);
            for (PyThreadInfo pyThreadInfo : this.r) {
                if (string == null || !string.equals(pyThreadInfo.getId())) continue;
                this.l.setNextStatement(string, sourcePosition, this.b(sourcePosition), callback);
                break;
            }
        }
    }

    public void startStepOut(@Nullable XSuspendContext context) {
        this.a(context, ResumeOrStepCommand.Mode.STEP_OUT);
    }

    public void startSmartStepInto(String functionName) {
        this.d();
        if (this.isConnected()) {
            for (PyThreadInfo pyThreadInfo : this.r) {
                this.l.smartStepInto(pyThreadInfo.getId(), functionName);
            }
        }
    }

    public void stop() {
        this.l.close();
    }

    public void resume(@Nullable XSuspendContext context) {
        this.a(ResumeOrStepCommand.Mode.RESUME);
    }

    public void startPausing() {
        if (this.isConnected()) {
            this.l.suspendAllThreads();
        }
    }

    public void suspendAllOtherThreads(PyThreadInfo thread2) {
        this.l.suspendOtherThreads(thread2);
    }

    public boolean isSuspendedOnAllThreadsPolicy() {
        if (this.getSession().isSuspended()) {
            for (PyThreadInfo pyThreadInfo : this.getThreads()) {
                Object object;
                List list2 = pyThreadInfo.getFrames();
                if (pyThreadInfo.getState() != PyThreadInfo.State.SUSPENDED || list2 == null) continue;
                XBreakpoint<? extends ExceptionBreakpointProperties> xBreakpoint = null;
                if (pyThreadInfo.isStopOnBreakpoint()) {
                    object = ((PyStackFrameInfo)list2.get(0)).getPosition();
                    xBreakpoint = (XBreakpoint<? extends ExceptionBreakpointProperties>)this.m.get(object);
                } else if (pyThreadInfo.isExceptionBreak() && (object = pyThreadInfo.getMessage()) != null) {
                    xBreakpoint = this.d.get(object);
                }
                if (xBreakpoint == null || !xBreakpoint.getType().isSuspendThreadSupported() || xBreakpoint.getSuspendPolicy() != SuspendPolicy.ALL) continue;
                return true;
            }
        }
        return false;
    }

    private void a(ResumeOrStepCommand.Mode mode) {
        this.d();
        if (this.isConnected()) {
            for (PyThreadInfo pyThreadInfo : this.l.getThreads()) {
                this.l.resumeOrStep(pyThreadInfo.getId(), mode);
            }
        }
    }

    private void a(@Nullable XSuspendContext xSuspendContext, ResumeOrStepCommand.Mode mode) {
        this.d();
        if (this.isConnected()) {
            String string = PyDebugProcess.a(xSuspendContext);
            for (PyThreadInfo pyThreadInfo : this.r) {
                if (string != null && !string.equals(pyThreadInfo.getId())) continue;
                this.l.resumeOrStep(pyThreadInfo.getId(), mode);
                break;
            }
        }
    }

    @Nullable
    private static String a(@Nullable XSuspendContext xSuspendContext) {
        if (xSuspendContext instanceof PySuspendContext) {
            return ((PySuspendContext)xSuspendContext).getActiveExecutionStack().getThreadId();
        }
        return null;
    }

    public boolean isConnected() {
        return this.l.isConnected();
    }

    protected void disconnect() {
        this.l.disconnect();
        this.cleanUp();
    }

    public boolean isDownloadSources() {
        return this.s;
    }

    public void setDownloadSources(boolean downloadSources) {
        this.s = downloadSources;
    }

    protected void cleanUp() {
        this.r.clear();
        this.s = false;
    }

    public void runToPosition(@NotNull XSourcePosition position, @Nullable XSuspendContext context) {
        if (position == null) {
            PyDebugProcess.a(18);
        }
        this.d();
        if (this.isConnected() && !this.r.isEmpty()) {
            PySourcePosition pySourcePosition = this.myPositionConverter.convertToPython(position);
            String string = (String)ReadAction.compute(() -> {
                long l2 = z ^ 0x16429C3FAD11L;
                String string = "python-line";
                Document document = FileDocumentManager.getInstance().getDocument(position.getFile());
                if (document != null) {
                    for (XBreakpointType xBreakpointType : XBreakpointType.EXTENSION_POINT_NAME.getExtensionList()) {
                        if (!(xBreakpointType instanceof PyBreakpointType) || !((PyBreakpointType)xBreakpointType).canPutInDocument(this.getSession().getProject(), document)) continue;
                        string = xBreakpointType.getId();
                        break;
                    }
                }
                return string;
            });
            this.l.setTempBreakpoint(string, pySourcePosition.getFile(), pySourcePosition.getLine());
            this.a(context, ResumeOrStepCommand.Mode.RESUME);
        }
    }

    public PyDebugValue evaluate(String expression, boolean execute, boolean doTrunc) throws PyDebuggerException {
        this.d();
        PyStackFrame pyStackFrame = this.e();
        return this.a(expression, execute, pyStackFrame, doTrunc);
    }

    private PyDebugValue a(String string, boolean bl2, PyStackFrame pyStackFrame, boolean bl3) throws PyDebuggerException {
        return this.l.evaluate(pyStackFrame.getThreadId(), pyStackFrame.getFrameId(), string, bl2, bl3);
    }

    public void consoleExec(String command, PyDebugCallback<String> callback) {
        this.d();
        try {
            PyStackFrame pyStackFrame = this.e();
            this.l.consoleExec(pyStackFrame.getThreadId(), pyStackFrame.getFrameId(), command, callback);
        }
        catch (PyDebuggerException pyDebuggerException) {
            callback.error(pyDebuggerException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCurrentFrameCached() {
        try {
            Object object = this.t;
            synchronized (object) {
                PyStackFrame pyStackFrame = this.e();
                return this.n.containsKey(pyStackFrame.getThreadFrameId());
            }
        }
        catch (PyDebuggerException pyDebuggerException) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public XValueChildrenList loadFrame() throws PyDebuggerException {
        PyStackFrame pyStackFrame = this.e();
        Object object = this.t;
        synchronized (object) {
            if (!this.n.containsKey(pyStackFrame.getThreadFrameId())) {
                XValueChildrenList xValueChildrenList = this.l.loadFrame(pyStackFrame.getThreadId(), pyStackFrame.getFrameId());
                this.n.put(pyStackFrame.getThreadFrameId(), xValueChildrenList);
            }
        }
        return this.a(this.n.get(pyStackFrame.getThreadFrameId()), pyStackFrame.getThreadFrameId());
    }

    public void loadAsyncVariablesValues(@NotNull List<PyFrameAccessor.PyAsyncValue<String>> pyAsyncValues) {
        if (pyAsyncValues == null) {
            PyDebugProcess.a(19);
        }
        PyDebugValueExecutionService.getInstance((Project)this.getProject()).submitTask((PyFrameAccessor)this, () -> {
            block6: {
                long l2 = z ^ 0x6741A354393L;
                try {
                    if (!this.isConnected()) break block6;
                    PyStackFrame pyStackFrame = this.e();
                    XSuspendContext xSuspendContext = this.getSession().getSuspendContext();
                    String string = PyDebugProcess.a(xSuspendContext);
                    for (PyThreadInfo pyThreadInfo : this.r) {
                        if (string != null && !string.equals(pyThreadInfo.getId())) continue;
                        this.l.loadFullVariableValues(pyStackFrame.getThreadId(), pyStackFrame.getFrameId(), pyAsyncValues);
                        break;
                    }
                }
                catch (PyDebuggerException pyDebuggerException) {
                    if (!this.isConnected()) {
                        return;
                    }
                    for (PyFrameAccessor.PyAsyncValue pyAsyncValue : pyAsyncValues) {
                        PyDebugValue pyDebugValue = pyAsyncValue.getDebugValue();
                        XValueNode xValueNode = pyDebugValue.getLastNode();
                        if (xValueNode == null || xValueNode.isObsolete()) continue;
                        if (pyDebuggerException.getMessage().startsWith("Timeout")) {
                            pyDebugValue.updateNodeValueAfterLoading(xValueNode, " ", "", "Loading timed out");
                            PyVariableViewSettings.showWarningMessage(this.getCurrentRootNode());
                            continue;
                        }
                        i.error((Throwable)pyDebuggerException);
                    }
                }
            }
        });
    }

    private XValueChildrenList a(XValueChildrenList xValueChildrenList, String string) {
        if (this.q.containsKey(string)) {
            PyDebugValue pyDebugValue = this.q.get(string);
            XValueChildrenList xValueChildrenList2 = new XValueChildrenList();
            for (int i10 = 0; i10 < xValueChildrenList.size(); ++i10) {
                String string2 = xValueChildrenList.getName(i10);
                if (string2.equals(pyDebugValue.getName())) {
                    xValueChildrenList2.add(string2, (XValue)pyDebugValue);
                    continue;
                }
                xValueChildrenList2.add(string2, xValueChildrenList.getValue(i10));
            }
            return xValueChildrenList2;
        }
        return xValueChildrenList;
    }

    public XValueChildrenList loadVariable(PyDebugValue var) throws PyDebuggerException {
        PyStackFrame pyStackFrame = this.e();
        PyDebugValue pyDebugValue = new PyDebugValue(var, var.getFullName());
        return this.l.loadVariable(pyStackFrame.getThreadId(), pyStackFrame.getFrameId(), pyDebugValue);
    }

    public void loadReferrers(PyReferringObjectsValue var, PyDebugCallback<XValueChildrenList> callback) {
        try {
            PyStackFrame pyStackFrame = this.e();
            this.l.loadReferrers(pyStackFrame.getThreadId(), pyStackFrame.getFrameId(), var, callback);
        }
        catch (PyDebuggerException pyDebuggerException) {
            callback.error(pyDebuggerException);
        }
    }

    public void changeVariable(PyDebugValue var, String value) throws PyDebuggerException {
        PyStackFrame pyStackFrame = this.e();
        PyDebugValue pyDebugValue = this.l.changeVariable(pyStackFrame.getThreadId(), pyStackFrame.getFrameId(), var, value);
        this.q.put(pyStackFrame.getThreadFrameId(), pyDebugValue);
    }

    @Nullable
    public PyReferrersLoader getReferrersLoader() {
        if (this.b == null) {
            this.b = new PyReferrersLoader((IPyDebugProcess)this);
        }
        return this.b;
    }

    public ArrayChunk getArrayItems(PyDebugValue var, int rowOffset, int colOffset, int rows, int cols, String format) throws PyDebuggerException {
        PyStackFrame pyStackFrame = this.e();
        return this.l.loadArrayItems(pyStackFrame.getThreadId(), pyStackFrame.getFrameId(), var, rowOffset, colOffset, rows, cols, format);
    }

    @Nullable
    public String loadSource(String path) {
        return this.l.loadSource(path);
    }

    public boolean canSaveToTemp(String name) {
        Project project = this.getSession().getProject();
        return PyDebugSupportUtils.canSaveToTemp(project, name);
    }

    public void setCurrentRootNode(@Nullable XCompositeNode currentRootNode) {
        this.g = currentRootNode;
    }

    @Nullable
    public XCompositeNode getCurrentRootNode() {
        return this.g;
    }

    @NotNull
    private PyStackFrame e() throws PyDebuggerException {
        long l2 = z ^ 0x5A11B9D25644L;
        if (!this.isConnected()) {
            throw new PyDebuggerException("Disconnected");
        }
        PyStackFrame pyStackFrame = (PyStackFrame)this.getSession().getCurrentStackFrame();
        if (pyStackFrame == null && this.k != null) {
            PyStackFrame pyStackFrame2 = this.k;
            if (pyStackFrame2 == null) {
                PyDebugProcess.a(20);
            }
            return pyStackFrame2;
        }
        if (pyStackFrame == null) {
            throw new PyDebuggerException("Process is running");
        }
        PyStackFrame pyStackFrame3 = pyStackFrame;
        if (pyStackFrame3 == null) {
            PyDebugProcess.a(21);
        }
        return pyStackFrame3;
    }

    private String a(XLineBreakpoint xLineBreakpoint) {
        XSourcePosition xSourcePosition = xLineBreakpoint.getSourcePosition();
        return xSourcePosition == null ? null : this.b(xSourcePosition);
    }

    @Nullable
    private String b(@NotNull XSourcePosition xSourcePosition) {
        if (xSourcePosition == null) {
            PyDebugProcess.a(22);
        }
        VirtualFile virtualFile = xSourcePosition.getFile();
        return (String)ReadAction.compute(() -> {
            PsiElement psiElement;
            PyFunction pyFunction;
            int n2;
            Document document = FileDocumentManager.getInstance().getDocument(virtualFile);
            Project project = this.getSession().getProject();
            if (document != null && virtualFile.getFileType() == PythonFileType.INSTANCE && (n2 = xSourcePosition.getLine()) < document.getLineCount() && (pyFunction = (PyFunction)PsiTreeUtil.getParentOfType((PsiElement)(psiElement = XDebuggerUtil.getInstance().findContextElement(virtualFile, document.getLineStartOffset(n2), project, false)), PyFunction.class)) != null) {
                return pyFunction.getName();
            }
            return null;
        });
    }

    public void addBreakpoint(PySourcePosition position, XLineBreakpoint breakpoint) {
        this.m.put(position, breakpoint);
        if (this.isConnected()) {
            String string = breakpoint.getConditionExpression() == null ? null : breakpoint.getConditionExpression().getExpression();
            String string2 = breakpoint.getLogExpressionObject() == null ? null : breakpoint.getLogExpressionObject().getExpression();
            SuspendPolicy suspendPolicy = breakpoint.getType().isSuspendThreadSupported() ? breakpoint.getSuspendPolicy() : SuspendPolicy.NONE;
            this.l.setBreakpoint(breakpoint.getType().getId(), position.getFile(), position.getLine(), string, string2, this.a(breakpoint), suspendPolicy);
        }
    }

    public void addTemporaryBreakpoint(String typeId, String file, int line2) {
        if (this.isConnected()) {
            this.l.setTempBreakpoint(typeId, file, line2);
        }
    }

    public void removeBreakpoint(PySourcePosition position) {
        XLineBreakpoint xLineBreakpoint = this.m.get(position);
        if (xLineBreakpoint != null) {
            this.m.remove(position);
            if (this.isConnected()) {
                this.l.removeBreakpoint(xLineBreakpoint.getType().getId(), position.getFile(), position.getLine());
            }
        }
    }

    public void addExceptionBreakpoint(XBreakpoint<? extends ExceptionBreakpointProperties> breakpoint) {
        this.d.put(((ExceptionBreakpointProperties)breakpoint.getProperties()).getExceptionBreakpointId(), breakpoint);
        if (this.isConnected()) {
            String string = breakpoint.getConditionExpression() == null ? null : breakpoint.getConditionExpression().getExpression();
            ((ExceptionBreakpointProperties)breakpoint.getProperties()).setCondition(string);
            String string2 = breakpoint.getLogExpressionObject() == null ? null : breakpoint.getLogExpressionObject().getExpression();
            ((ExceptionBreakpointProperties)breakpoint.getProperties()).setLogExpression(string2);
            this.l.addExceptionBreakpoint((ExceptionBreakpointCommandFactory)breakpoint.getProperties());
        }
    }

    public void removeExceptionBreakpoint(XBreakpoint<? extends ExceptionBreakpointProperties> breakpoint) {
        this.d.remove(((ExceptionBreakpointProperties)breakpoint.getProperties()).getExceptionBreakpointId());
        if (this.isConnected()) {
            this.l.removeExceptionBreakpoint((ExceptionBreakpointCommandFactory)breakpoint.getProperties());
        }
    }

    public Collection<PyThreadInfo> getThreads() {
        return this.l.getThreads();
    }

    public void threadSuspended(PyThreadInfo threadInfo, boolean updateSourcePosition) {
        if (!this.r.contains(threadInfo)) {
            this.r.add(threadInfo);
            List list2 = threadInfo.getFrames();
            if (list2 != null) {
                PySuspendContext pySuspendContext = this.createSuspendContext(threadInfo);
                XBreakpoint<? extends ExceptionBreakpointProperties> xBreakpoint = null;
                if (threadInfo.isStopOnBreakpoint()) {
                    PySourcePosition pySourcePosition = ((PyStackFrameInfo)list2.get(0)).getPosition();
                    PySourcePosition pySourcePosition2 = this.myPositionConverter.convertFrameToPython(pySourcePosition);
                    xBreakpoint = (XBreakpoint<? extends ExceptionBreakpointProperties>)this.m.get(pySourcePosition2);
                    if (xBreakpoint == null) {
                        this.l.removeTempBreakpoint(pySourcePosition2.getFile(), pySourcePosition2.getLine());
                    }
                } else if (threadInfo.isExceptionBreak()) {
                    String string = threadInfo.getMessage();
                    threadInfo.setMessage(null);
                    if (string != null) {
                        xBreakpoint = this.d.get(string);
                    }
                }
                if (xBreakpoint != null && xBreakpoint.getType().isSuspendThreadSupported() && xBreakpoint.getSuspendPolicy() == SuspendPolicy.ALL) {
                    this.suspendAllOtherThreads(threadInfo);
                }
                if (updateSourcePosition) {
                    if (xBreakpoint != null) {
                        if (!this.getSession().breakpointReached(xBreakpoint, threadInfo.getMessage(), (XSuspendContext)pySuspendContext)) {
                            this.resume(pySuspendContext);
                        }
                    } else {
                        this.getSession().positionReached((XSuspendContext)pySuspendContext);
                    }
                }
            }
        }
    }

    @NotNull
    protected PySuspendContext createSuspendContext(PyThreadInfo threadInfo) {
        PySuspendContext pySuspendContext = new PySuspendContext(this, threadInfo);
        if (pySuspendContext == null) {
            PyDebugProcess.a(23);
        }
        return pySuspendContext;
    }

    public void threadResumed(PyThreadInfo threadInfo) {
        this.r.remove(threadInfo);
    }

    private void d() {
        this.n.clear();
        this.q.clear();
        PyDebugValueExecutionService.getInstance((Project)this.getProject()).cancelSubmittedTasks((PyFrameAccessor)this);
    }

    @NotNull
    public List<PydevCompletionVariant> getCompletions(String prefix) throws Exception {
        if (this.isConnected()) {
            PyStackFrame pyStackFrame = this.e();
            List list2 = this.l.getCompletions(pyStackFrame.getThreadId(), pyStackFrame.getFrameId(), prefix);
            if (list2 == null) {
                PyDebugProcess.a(24);
            }
            return list2;
        }
        ArrayList arrayList = Lists.newArrayList();
        if (arrayList == null) {
            PyDebugProcess.a(25);
        }
        return arrayList;
    }

    @NotNull
    public String getDescription(String prefix) throws Exception {
        if (this.isConnected()) {
            PyStackFrame pyStackFrame = this.e();
            String string = this.l.getDescription(pyStackFrame.getThreadId(), pyStackFrame.getFrameId(), prefix);
            if (string == null) {
                PyDebugProcess.a(26);
            }
            return string;
        }
        if ("" == null) {
            PyDebugProcess.a(27);
        }
        return "";
    }

    public void startNotified(@NotNull ProcessEvent event) {
        if (event == null) {
            PyDebugProcess.a(28);
        }
    }

    public void processTerminated(@NotNull ProcessEvent event) {
        if (event == null) {
            PyDebugProcess.a(29);
        }
        this.l.close();
    }

    public void processWillTerminate(@NotNull ProcessEvent event, boolean willBeDestroyed) {
        if (event == null) {
            PyDebugProcess.a(30);
        }
        this.o = true;
    }

    public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
        if (event == null) {
            PyDebugProcess.a(31);
        }
        if (outputType == null) {
            PyDebugProcess.a(32);
        }
    }

    public PyStackFrame createStackFrame(PyStackFrameInfo frameInfo) {
        return new PyStackFrame(this.getSession().getProject(), (PyFrameAccessor)this, frameInfo, this.getPositionConverter().convertFromPython(frameInfo.getPosition(), frameInfo.getName()));
    }

    public String getCurrentStateMessage() {
        long l2 = z ^ 0x4C8FEFF0F8EL;
        if (this.getSession().isStopped()) {
            return XDebuggerBundle.message((String)"debugger.state.message.disconnected", (Object[])new Object[0]);
        }
        if (this.isConnected()) {
            return XDebuggerBundle.message((String)"debugger.state.message.connected", (Object[])new Object[0]);
        }
        return this.getConnectionMessage();
    }

    public void addProcessListener(ProcessListener listener2) {
        ProcessHandler processHandler = this.doGetProcessHandler();
        if (processHandler != null) {
            processHandler.addProcessListener(listener2);
        }
    }

    public boolean isWaitingForConnection() {
        return this.h;
    }

    public void setWaitingForConnection(boolean waitingForConnection) {
        this.h = waitingForConnection;
    }

    public int getConnectTimeout() {
        return 60000;
    }

    @Nullable
    protected XSourcePosition getCurrentFrameSourcePosition() {
        try {
            PyStackFrame pyStackFrame = this.e();
            return pyStackFrame.getSourcePosition();
        }
        catch (PyDebuggerException pyDebuggerException) {
            return null;
        }
    }

    public Project getProject() {
        return this.getSession().getProject();
    }

    @Nullable
    public XSourcePosition getSourcePositionForName(String name, String parentType) {
        if (name == null) {
            return null;
        }
        XSourcePosition xSourcePosition = this.getCurrentFrameSourcePosition();
        PsiFile psiFile = this.c(xSourcePosition);
        if (psiFile == null) {
            return null;
        }
        if (Strings.isNullOrEmpty((String)parentType)) {
            Ref<PsiElement> ref = PyDebugProcess.a(name, xSourcePosition, psiFile);
            return ref.isNull() ? null : XDebuggerUtil.getInstance().createPositionByElement((PsiElement)ref.get());
        }
        PyType pyType = this.a(parentType, psiFile);
        if (pyType == null) {
            return null;
        }
        List<? extends RatedResolveResult> list2 = pyType.resolveMember(name, null, AccessDirection.READ, PyResolveContext.noImplicits());
        if (list2 != null && !list2.isEmpty()) {
            return XDebuggerUtil.getInstance().createPositionByElement(list2.get(0).getElement());
        }
        return PyDebugProcess.a(pyType);
    }

    @NotNull
    private static Ref<PsiElement> a(final String string, XSourcePosition xSourcePosition, PsiFile psiFile) {
        final Ref ref = Ref.create();
        PsiElement psiElement = psiFile.findElementAt(xSourcePosition.getOffset());
        if (psiElement == null) {
            Ref ref2 = ref;
            if (ref2 == null) {
                PyDebugProcess.a(33);
            }
            return ref2;
        }
        PyResolveUtil.scopeCrawlUp(new PsiScopeProcessor(){
            private static final long a = com.jetbrains.python.psi.c.a(7104038733962300844L, -3575229898049571409L, MethodHandles.lookup().lookupClass()).a(151153354098293L);

            public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state2) {
                if (element == null) {
                    6.a(0);
                }
                if (state2 == null) {
                    6.a(1);
                }
                if (element instanceof PyImportElement) {
                    PyImportElement pyImportElement = (PyImportElement)element;
                    if (string.equals(pyImportElement.getVisibleName())) {
                        if (ref.isNull()) {
                            ref.set((Object)element);
                        }
                        return false;
                    }
                    return true;
                }
                if (ref.isNull()) {
                    ref.set((Object)element);
                }
                return false;
            }

            private static /* synthetic */ void a(int n2) {
                Object[] objectArray;
                long l2 = a ^ 0x66948C477726L;
                Object[] objectArray2 = new Object[3];
                switch (n2) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "state";
                        break;
                    }
                }
                objectArray[1] = "com/jetbrains/python/debugger/PyDebugProcess$6";
                objectArray[2] = "execute";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, psiElement, string, null);
        Ref ref3 = ref;
        if (ref3 == null) {
            PyDebugProcess.a(34);
        }
        return ref3;
    }

    @Nullable
    private PsiFile c(XSourcePosition xSourcePosition) {
        if (xSourcePosition == null) {
            return null;
        }
        return PsiManager.getInstance((Project)this.getProject()).findFile(xSourcePosition.getFile());
    }

    @Nullable
    public XSourcePosition getSourcePositionForType(String typeName) {
        XSourcePosition xSourcePosition = this.getCurrentFrameSourcePosition();
        PsiFile psiFile = this.c(xSourcePosition);
        if (typeName == null || !(psiFile instanceof PyFile)) {
            return null;
        }
        PyType pyType = this.a(typeName, psiFile);
        return pyType == null ? null : PyDebugProcess.a(pyType);
    }

    public void showNumericContainer(@NotNull PyDebugValue value) {
        if (value == null) {
            PyDebugProcess.a(35);
        }
        PyViewNumericContainerAction.showNumericViewer(this.getProject(), value);
    }

    public void addFrameListener(@NotNull PyFrameListener listener2) {
        if (listener2 == null) {
            PyDebugProcess.a(36);
        }
        this.u.add(listener2);
    }

    @Nullable
    private static XSourcePosition a(PyType pyType) {
        PyClassType pyClassType = PyUtil.as(pyType, PyClassType.class);
        if (pyClassType != null) {
            return XDebuggerUtil.getInstance().createPositionByElement((PsiElement)pyClassType.getPyClass());
        }
        PyModuleType pyModuleType = PyUtil.as(pyType, PyModuleType.class);
        if (pyModuleType != null) {
            return XDebuggerUtil.getInstance().createPositionByElement((PsiElement)pyModuleType.getModule());
        }
        return null;
    }

    private PyType a(String string, PsiFile psiFile) {
        long l2 = z ^ 0x59C531772057L;
        string = string.replace("__builtin__.", "");
        PyType pyType = null;
        if (!string.contains(".")) {
            pyType = PyTypeParser.getTypeByName((PsiElement)psiFile, string);
        }
        if (pyType == null) {
            PyElementGenerator pyElementGenerator = PyElementGenerator.getInstance(this.getProject());
            PyPsiFacade pyPsiFacade = PyPsiFacade.getInstance(this.getProject());
            PsiFile psiFile2 = pyElementGenerator.createDummyFile(((PyFile)psiFile).getLanguageLevel(), "");
            Module module2 = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiFile);
            psiFile2.putUserData(ModuleUtilCore.KEY_MODULE, (Object)module2);
            pyType = pyPsiFacade.parseTypeAnnotation(string, (PsiElement)psiFile2);
        }
        return pyType;
    }

    static {
        z = com.jetbrains.python.psi.c.a(160548050928863019L, 3051004549554008018L, MethodHandles.lookup().lookupClass()).a(241166367981233L);
        long l2 = z ^ 0x38A5C684207EL;
        i = Logger.getInstance((String)"#com.jetbrains.python.debugger.PyDebugProcess");
        NOTIFICATION_GROUP = NotificationGroup.toolWindowGroup((String)PyBundle.message("debug.notification.group", new Object[0]), (String)ToolWindowId.DEBUG);
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = z ^ 0x6A5E96736695L;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 33: 
            case 34: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 33: 
            case 34: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serverSocket";
                break;
            }
            case 2: 
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executionConsole";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serverHost";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debuggerFactory";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 33: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/debugger/PyDebugProcess";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "leftToolbar";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "topToolbar";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourcePosition";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 18: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pyAsyncValues";
                break;
            }
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputType";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/debugger/PyDebugProcess";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getBreakpointHandlers";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditorsProvider";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createConsole";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "currentFrame";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "createSuspendContext";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompletions";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveInCurrentFrame";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 33: 
            case 34: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getRemoteHostPortForDebuggerConnection";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "registerAdditionalActions";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "startSetNextStatement";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "runToPosition";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "loadAsyncVariablesValues";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getFunctionName";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "startNotified";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "processTerminated";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "processWillTerminate";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "onTextAvailable";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "showNumericContainer";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "addFrameListener";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 33: 
            case 34: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static interface DebuggerFactory {
        @NotNull
        public ProcessDebugger createDebugger(@NotNull PyDebugProcess var1);
    }

    private static class WatchReturnValuesAction
    extends ToggleAction {
        private volatile boolean b;
        private final PyDebugProcess a;
        private final String c;
        private static final long d = com.jetbrains.python.psi.c.a(-382739852222792204L, 5791703857659274944L, MethodHandles.lookup().lookupClass()).a(113512257379797L);

        WatchReturnValuesAction(@NotNull PyDebugProcess debugProcess) {
            long l2 = d ^ 0x5E722880EE28L;
            if (debugProcess == null) {
                WatchReturnValuesAction.a(0);
            }
            super("", "Enables watching executed functions return values", null);
            this.b = PyDebuggerSettings.getInstance().isWatchReturnValues();
            this.a = debugProcess;
            this.c = "Show Return Values";
        }

        public void update(@NotNull AnActionEvent e10) {
            if (e10 == null) {
                WatchReturnValuesAction.a(1);
            }
            super.update(e10);
            Presentation presentation = e10.getPresentation();
            presentation.setEnabled(true);
            presentation.setText(this.c);
        }

        public boolean isSelected(@NotNull AnActionEvent e10) {
            if (e10 == null) {
                WatchReturnValuesAction.a(2);
            }
            return this.b;
        }

        public void setSelected(@NotNull AnActionEvent e10, boolean watch) {
            if (e10 == null) {
                WatchReturnValuesAction.a(3);
            }
            this.b = watch;
            PyDebuggerSettings.getInstance().setWatchReturnValues(watch);
            Project project = e10.getProject();
            if (project != null) {
                this.a.setShowReturnValues(this.b);
                this.a.getSession().rebuildViews();
            }
        }

        private static /* synthetic */ void a(int n2) {
            Object[] objectArray;
            Object[] objectArray2;
            long l2 = d ^ 0x5DFA8F470C81L;
            Object[] objectArray3 = new Object[3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "debugProcess";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/python/debugger/PyDebugProcess$WatchReturnValuesAction";
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSelected";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setSelected";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

