/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.console;

import com.google.common.base.CharMatcher;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.execution.console.LanguageConsoleView;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actions.ScrollToTheEndToolbarAction;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.IJSwingUtilities;
import com.jetbrains.python.console.PythonConsoleView;
import com.jetbrains.python.console.parsing.PythonConsoleData;
import com.jetbrains.python.console.pydev.ConsoleCommunication;
import com.jetbrains.python.psi.c;
import java.awt.Component;
import java.lang.invoke.MethodHandles;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyConsoleUtil {
    public static final String ORDINARY_PROMPT = ">>>";
    public static final String INPUT_PROMPT = ">?";
    public static final String INDENT_PROMPT = "...";
    public static final String IPYTHON_INDENT_PROMPT = "...:";
    public static final String HELP_PROMPT = "help>";
    public static final String EXECUTING_PROMPT = "";
    private static final String b = "---Return to continue, q to quit---";
    private static final String[] a;
    static final Key<PythonConsoleData> PYTHON_CONSOLE_DATA;
    private static final long c;

    private PyConsoleUtil() {
    }

    public static boolean isPagingPrompt(@Nullable String prompt) {
        long l2 = c ^ 0x6D3E76492F24L;
        return prompt != null && b.equals(prompt.trim());
    }

    static String processPrompts(LanguageConsoleView languageConsole, String string) {
        long l2 = c ^ 0x2647E63D6273L;
        for (String string2 : a) {
            String string3;
            CharSequence charSequence;
            if (!string.startsWith(string2)) continue;
            if (string2 != HELP_PROMPT) {
                charSequence = new StringBuilder();
                ((StringBuilder)charSequence).append(string2).append(string2);
                while (string.startsWith(((StringBuilder)charSequence).toString())) {
                    ((StringBuilder)charSequence).append(string2);
                }
                string3 = ((StringBuilder)charSequence).toString().substring(string2.length());
                if (string2 == INDENT_PROMPT) {
                    string2 = string3;
                }
                string = string.substring(string3.length());
            } else {
                string = string.substring(string2.length());
            }
            charSequence = languageConsole.getPrompt();
            string3 = string2.trim();
            if (charSequence == null || ((String)charSequence).equals(string3)) break;
            languageConsole.setPrompt(string3);
            PyConsoleUtil.scrollDown((Editor)languageConsole.getConsoleEditor());
            break;
        }
        return string;
    }

    public static void scrollDown(Editor currentEditor) {
        ApplicationManager.getApplication().invokeLater(() -> {
            if (!currentEditor.isDisposed()) {
                currentEditor.getCaretModel().moveToOffset(currentEditor.getDocument().getTextLength());
            }
        });
    }

    public static boolean detectIPythonImported(@NotNull String text2, ConsoleViewContentType outputType) {
        long l2 = c ^ 0x6CBC046A664L;
        if (text2 == null) {
            PyConsoleUtil.a(0);
        }
        return text2.contains("PyDev console: using IPython ");
    }

    public static boolean detectSourcePrinting(@NotNull String text2) {
        long l2 = c ^ 0x65E6CAACC230L;
        if (text2 == null) {
            PyConsoleUtil.a(1);
        }
        return text2.contains("Source:");
    }

    public static boolean detectIPythonStart(@NotNull String text2) {
        long l2 = c ^ 0x1F541ACD2F92L;
        if (text2 == null) {
            PyConsoleUtil.a(2);
        }
        return text2.contains("IPython-->");
    }

    public static boolean detectIPythonEnd(@NotNull String text2) {
        long l2 = c ^ 0x5BD2A5DB7223L;
        if (text2 == null) {
            PyConsoleUtil.a(3);
        }
        return text2.contains("<--IPython");
    }

    public static boolean detectIPythonAutomagicOn(@NotNull String text2) {
        long l2 = c ^ 0x738BAD9F56BAL;
        if (text2 == null) {
            PyConsoleUtil.a(4);
        }
        return text2.contains("Automagic is ON, % prefix NOT needed for magic functions.");
    }

    public static boolean detectIPythonAutomagicOff(@NotNull String text2) {
        long l2 = c ^ 0x41F93398AD5EL;
        if (text2 == null) {
            PyConsoleUtil.a(5);
        }
        return text2.contains("Automagic is OFF, % prefix IS needed for magic functions.");
    }

    public static void markIPython(@NotNull VirtualFile file) {
        if (file == null) {
            PyConsoleUtil.a(6);
        }
        PythonConsoleData pythonConsoleData = PyConsoleUtil.getOrCreateIPythonData(file);
        pythonConsoleData.setIPythonEnabled(true);
    }

    @NotNull
    public static PythonConsoleData getOrCreateIPythonData(@NotNull VirtualFile file) {
        PythonConsoleData pythonConsoleData;
        if (file == null) {
            PyConsoleUtil.a(7);
        }
        if ((pythonConsoleData = (PythonConsoleData)file.getUserData(PYTHON_CONSOLE_DATA)) == null) {
            pythonConsoleData = new PythonConsoleData();
            file.putUserData(PYTHON_CONSOLE_DATA, (Object)pythonConsoleData);
        }
        PythonConsoleData pythonConsoleData2 = pythonConsoleData;
        if (pythonConsoleData2 == null) {
            PyConsoleUtil.a(8);
        }
        return pythonConsoleData2;
    }

    public static void setIPythonAutomagic(@NotNull VirtualFile file, boolean detected) {
        if (file == null) {
            PyConsoleUtil.a(9);
        }
        PythonConsoleData pythonConsoleData = PyConsoleUtil.getOrCreateIPythonData(file);
        pythonConsoleData.setIPythonAutomagic(detected);
    }

    public static void setCurrentIndentSize(@NotNull VirtualFile file, int indentSize) {
        if (file == null) {
            PyConsoleUtil.a(10);
        }
        PythonConsoleData pythonConsoleData = PyConsoleUtil.getOrCreateIPythonData(file);
        pythonConsoleData.setIndentSize(indentSize);
    }

    public static AnAction createTabCompletionAction(final PythonConsoleView consoleView) {
        AnAction anAction = new AnAction(){
            private static final long a = com.jetbrains.python.psi.c.a(1545179103217354924L, -3681025218927859658L, MethodHandles.lookup().lookupClass()).a(196911954232478L);

            public void actionPerformed(@NotNull AnActionEvent e10) {
                EditorEx editorEx;
                long l2 = a ^ 0x230C77972B7L;
                if (e10 == null) {
                    1.a(0);
                }
                if (LookupManager.getActiveLookup((Editor)(editorEx = consoleView.getConsoleEditor())) != null) {
                    AnAction anAction = ActionManager.getInstance().getAction("EditorChooseLookupItemReplace");
                    ActionUtil.performActionDumbAware((AnAction)anAction, (AnActionEvent)e10);
                    return;
                }
                AnAction anAction = ActionManager.getInstance().getAction("CodeCompletion");
                if (anAction != null) {
                    ActionUtil.performActionDumbAware((AnAction)anAction, (AnActionEvent)e10);
                }
            }

            public void update(@NotNull AnActionEvent e10) {
                EditorEx editorEx;
                if (e10 == null) {
                    1.a(1);
                }
                if (LookupManager.getActiveLookup((Editor)(editorEx = consoleView.getConsoleEditor())) != null) {
                    e10.getPresentation().setEnabled(false);
                }
                int n2 = editorEx.getCaretModel().getOffset();
                Document document = editorEx.getDocument();
                int n3 = document.getLineStartOffset(document.getLineNumber(n2));
                String string = document.getText(new TextRange(n3, n2));
                e10.getPresentation().setEnabled(!CharMatcher.whitespace().matchesAllOf((CharSequence)string));
            }

            private static /* synthetic */ void a(int n2) {
                Object[] objectArray;
                long l2 = a ^ 0x71A185302AF2L;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/jetbrains/python/console/PyConsoleUtil$1";
                switch (n2) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "actionPerformed";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "update";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        anAction.registerCustomShortcutSet(9, 0, consoleView.getConsoleEditor().getComponent());
        anAction.getTemplatePresentation().setVisible(false);
        return anAction;
    }

    public static AnAction createInterruptAction(final PythonConsoleView consoleView) {
        AnAction anAction = new AnAction(){
            private static final long a = com.jetbrains.python.psi.c.a(-181242612449841068L, 876004423728158129L, MethodHandles.lookup().lookupClass()).a(241325828092915L);

            public void actionPerformed(@NotNull AnActionEvent e10) {
                ConsoleCommunication consoleCommunication;
                long l2 = a ^ 0xFF966B63FE1L;
                if (e10 == null) {
                    2.a(0);
                }
                if ((consoleCommunication = consoleView.getExecuteActionHandler().getConsoleCommunication()).isExecuting() || consoleCommunication.isWaitingForInput()) {
                    consoleView.print("^C", ProcessOutputTypes.SYSTEM);
                    consoleCommunication.interrupt();
                } else {
                    DocumentEx documentEx = consoleView.getConsoleEditor().getDocument();
                    if (documentEx.getTextLength() != 0) {
                        ApplicationManager.getApplication().runWriteAction(() -> CommandProcessor.getInstance().runUndoTransparentAction(() -> documentEx.deleteString(0, documentEx.getLineEndOffset(documentEx.getLineCount() - 1))));
                    }
                }
            }

            public void update(@NotNull AnActionEvent e10) {
                EditorEx editorEx;
                if (e10 == null) {
                    2.a(1);
                }
                boolean bl2 = IJSwingUtilities.hasFocus((Component)(editorEx = consoleView.getConsoleEditor()).getComponent()) && !editorEx.getSelectionModel().hasSelection();
                e10.getPresentation().setEnabled(bl2);
            }

            private static /* synthetic */ void a(int n2) {
                Object[] objectArray;
                long l2 = a ^ 0x7B3059DCCC6EL;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/jetbrains/python/console/PyConsoleUtil$2";
                switch (n2) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "actionPerformed";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "update";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        anAction.registerCustomShortcutSet(67, 2, consoleView.getConsoleEditor().getComponent());
        anAction.getTemplatePresentation().setVisible(false);
        return anAction;
    }

    public static AnAction createScrollToEndAction(@NotNull Editor editor2) {
        if (editor2 == null) {
            PyConsoleUtil.a(11);
        }
        return new ScrollToTheEndToolbarAction(editor2);
    }

    private static AnActionEvent a(@NotNull AnActionEvent anActionEvent, PythonConsoleView pythonConsoleView) {
        if (anActionEvent == null) {
            PyConsoleUtil.a(12);
        }
        ConsoleDataContext consoleDataContext = new ConsoleDataContext(anActionEvent.getDataContext(), pythonConsoleView);
        return new AnActionEvent(anActionEvent.getInputEvent(), (DataContext)consoleDataContext, anActionEvent.getPlace(), anActionEvent.getPresentation(), anActionEvent.getActionManager(), anActionEvent.getModifiers());
    }

    public static AnAction createPrintAction(PythonConsoleView consoleView) {
        long l2 = c ^ 0x1FBA3A7E85C9L;
        AnAction anAction = ActionManager.getInstance().getAction("Print");
        return new DumbAwareAction(anAction, consoleView){
            final /* synthetic */ AnAction val$printAction;
            final /* synthetic */ PythonConsoleView val$consoleView;
            private static final long a = com.jetbrains.python.psi.c.a(-5168362920577413559L, -8208317494696366499L, MethodHandles.lookup().lookupClass()).a(251436417128041L);
            {
                long l2 = a ^ 0x3633CD76F55EL;
                this.val$printAction = anAction;
                this.val$consoleView = pythonConsoleView;
                ActionUtil.copyFrom((AnAction)this, (String)"Print");
            }

            public void update(@NotNull AnActionEvent e10) {
                if (e10 == null) {
                    3.a(0);
                }
                this.val$printAction.update(PyConsoleUtil.a(e10, this.val$consoleView));
            }

            public void actionPerformed(@NotNull AnActionEvent e10) {
                if (e10 == null) {
                    3.a(1);
                }
                this.val$printAction.actionPerformed(PyConsoleUtil.a(e10, this.val$consoleView));
            }

            private static /* synthetic */ void a(int n2) {
                Object[] objectArray;
                long l2 = a ^ 0x49C47DC7BE96L;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/jetbrains/python/console/PyConsoleUtil$3";
                switch (n2) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "update";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "actionPerformed";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    static {
        c = com.jetbrains.python.psi.c.a(-1946299090095093988L, 5309222082897394030L, MethodHandles.lookup().lookupClass()).a(167038215395827L);
        long l2 = c ^ 0x76C1BA59D1A0L;
        a = new String[]{ORDINARY_PROMPT, INDENT_PROMPT, HELP_PROMPT, b};
        PYTHON_CONSOLE_DATA = Key.create((String)"python-console-data");
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = c ^ 0x2F3B3D678E72L;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 8: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/console/PyConsoleUtil";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/console/PyConsoleUtil";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateIPythonData";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "detectIPythonImported";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "detectSourcePrinting";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "detectIPythonStart";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "detectIPythonEnd";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "detectIPythonAutomagicOn";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "detectIPythonAutomagicOff";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "markIPython";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateIPythonData";
                break;
            }
            case 8: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setIPythonAutomagic";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setCurrentIndentSize";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createScrollToEndAction";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createActionEvent";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ConsoleDataContext
    implements DataContext {
        private final DataContext b;
        private final PythonConsoleView a;
        private static final long c = com.jetbrains.python.psi.c.a(-5521954889550553475L, 7147309588853449717L, MethodHandles.lookup().lookupClass()).a(238434758993643L);

        ConsoleDataContext(DataContext dataContext, PythonConsoleView consoleView) {
            this.b = dataContext;
            this.a = consoleView;
        }

        @Nullable
        public Object getData(@NotNull String dataId) {
            if (dataId == null) {
                ConsoleDataContext.a(0);
            }
            if (CommonDataKeys.EDITOR.is(dataId)) {
                return this.a.getEditor();
            }
            return this.b.getData(dataId);
        }

        private static /* synthetic */ void a(int n2) {
            long l2 = c ^ 0x68320A93EBD2L;
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataId", "com/jetbrains/python/console/PyConsoleUtil$ConsoleDataContext", "getData"));
        }
    }
}

