/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.configuration;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.projectRoots.SdkModel;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.projectRoots.impl.SdkConfigurationUtil;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ProjectSdksModel;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.remote.RemoteSdkAdditionalData;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.ListSpeedSearch;
import com.intellij.ui.ToggleActionButton;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBList;
import com.intellij.util.NullableConsumer;
import com.intellij.util.NullableFunction;
import com.intellij.util.PathMappingSettings;
import com.intellij.util.containers.FactoryMap;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.configuration.AddVEnvOptionsDialog;
import com.jetbrains.python.configuration.EditSdkDialog;
import com.jetbrains.python.configuration.PyConfigurableInterpreterList;
import com.jetbrains.python.configuration.PythonPathDialog;
import com.jetbrains.python.configuration.PythonPathEditor;
import com.jetbrains.python.packaging.PyPackageManagers;
import com.jetbrains.python.psi.c;
import com.jetbrains.python.remote.PyRemoteSdkAdditionalDataBase;
import com.jetbrains.python.remote.PyRemoteSourceItem;
import com.jetbrains.python.remote.PythonRemoteInterpreterManager;
import com.jetbrains.python.sdk.PySdkExtKt;
import com.jetbrains.python.sdk.PySdkListCellRenderer;
import com.jetbrains.python.sdk.PySdkUtil;
import com.jetbrains.python.sdk.PythonSdkAdditionalData;
import com.jetbrains.python.sdk.PythonSdkType;
import com.jetbrains.python.sdk.PythonSdkUpdater;
import com.jetbrains.python.sdk.add.PyAddSdkDialog;
import com.jetbrains.python.sdk.flavors.PythonSdkFlavor;
import java.awt.Component;
import java.awt.Dimension;
import java.io.File;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PythonSdkDetailsDialog
extends DialogWrapper {
    private static final Logger c;
    private JPanel b;
    private JList<Object> h;
    private boolean n;
    private final PyConfigurableInterpreterList f;
    private final ProjectSdksModel e;
    private final Map<Sdk, SdkModificator> a;
    private final Set<SdkModificator> k;
    private final Project i;
    private boolean m;
    private final Module d;
    private final Runnable j;
    private final NullableConsumer<? super Sdk> l;
    private SdkModel.Listener g;
    private static final long o;

    public PythonSdkDetailsDialog(Project project, NullableConsumer<? super Sdk> showMoreCallback, Runnable sdkSettingsWereModified) {
        long l2 = o ^ 0x7EF68BB090DEL;
        super(project, true);
        this.n = false;
        this.a = FactoryMap.create(sdk -> sdk.getSdkModificator());
        this.k = new HashSet<SdkModificator>();
        this.m = false;
        this.d = null;
        this.j = sdkSettingsWereModified;
        this.setTitle(PyBundle.message("sdk.details.dialog.title", new Object[0]));
        this.l = showMoreCallback;
        this.i = project;
        this.f = PyConfigurableInterpreterList.getInstance(this.i);
        this.e = this.f.getModel();
        this.init();
        this.updateOkButton();
    }

    protected void dispose() {
        this.e.removeListener(this.g);
        super.dispose();
    }

    public PythonSdkDetailsDialog(Module module2, NullableConsumer<? super Sdk> showMoreCallback, Runnable sdkSettingsWereModified) {
        long l2 = o ^ 0x55593F6FF437L;
        super(module2.getProject());
        this.n = false;
        this.a = FactoryMap.create(sdk -> sdk.getSdkModificator());
        this.k = new HashSet<SdkModificator>();
        this.m = false;
        this.d = module2;
        this.j = sdkSettingsWereModified;
        this.setTitle(PyBundle.message("sdk.details.dialog.title", new Object[0]));
        this.l = showMoreCallback;
        this.i = module2.getProject();
        this.f = PyConfigurableInterpreterList.getInstance(this.i);
        this.e = this.f.getModel();
        this.init();
        this.updateOkButton();
    }

    @Nullable
    protected JComponent createCenterPanel() {
        this.h = new JBList();
        this.h.setCellRenderer((ListCellRenderer<Object>)((Object)new PySdkListCellRenderer(this.a)));
        this.h.setSelectionMode(0);
        new ListSpeedSearch(this.h);
        ToolbarDecorator toolbarDecorator = ToolbarDecorator.createDecorator(this.h).disableUpDownActions().setAddAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                PythonSdkDetailsDialog.this.d();
                PythonSdkDetailsDialog.this.updateOkButton();
            }
        }).setEditAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                PythonSdkDetailsDialog.this.e();
                PythonSdkDetailsDialog.this.updateOkButton();
            }
        }).setRemoveAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                PythonSdkDetailsDialog.this.g();
                PythonSdkDetailsDialog.this.updateOkButton();
            }
        }).addExtraAction((AnActionButton)new ToggleVirtualEnvFilterButton(this)).addExtraAction((AnActionButton)new ShowPathButton(this));
        toolbarDecorator.setPreferredSize(new Dimension(600, 500));
        this.b = toolbarDecorator.createPanel();
        this.c();
        this.b();
        return this.b;
    }

    private void b() {
        this.g = new SdkModel.Listener(){
            private static final long a = com.jetbrains.python.psi.c.a(1620318863645914656L, 5870077090793908274L, MethodHandles.lookup().lookupClass()).a(51807246244251L);

            public void sdkChanged(@NotNull Sdk sdk, String previousName) {
                if (sdk == null) {
                    4.a(0);
                }
                PythonSdkDetailsDialog.this.c();
            }

            private static /* synthetic */ void a(int n2) {
                long l2 = a ^ 0x313E3998A6A4L;
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdk", "com/jetbrains/python/configuration/PythonSdkDetailsDialog$4", "sdkChanged"));
            }
        };
        this.e.addListener(this.g);
        this.h.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent event) {
                PythonSdkDetailsDialog.this.updateOkButton();
            }
        });
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.h;
    }

    public boolean isModified() {
        Sdk sdk = this.a();
        if (sdk != null) {
            sdk = this.e.findSdk(sdk.getName());
        }
        return this.getSelectedSdk() != sdk || this.n || this.e.isModified() || !this.k.isEmpty();
    }

    protected void updateOkButton() {
        super.setOKActionEnabled(this.isModified());
    }

    protected void doOKAction() {
        this.apply();
        super.doOKAction();
    }

    public void apply() {
        if (!this.k.isEmpty()) {
            this.j.run();
        }
        for (SdkModificator sdkModificator : this.k) {
            if (!sdkModificator.isWritable()) continue;
            sdkModificator.commitChanges();
        }
        this.a.clear();
        this.k.clear();
        this.n = false;
        Sdk sdk = this.getSelectedSdk();
        this.l.consume((Object)sdk);
        if (sdk != null) {
            PyPackageManagers.getInstance().clearCache(sdk);
        }
        Disposer.dispose((Disposable)this.getDisposable());
    }

    @Nullable
    public Sdk getSelectedSdk() {
        return (Sdk)this.h.getSelectedValue();
    }

    private void c() {
        List<Sdk> list2 = this.f.getAllPythonSdks(this.i);
        Sdk sdk2 = this.a();
        List<Sdk> list3 = ((StreamEx)StreamEx.of(list2).filter(sdk -> !PySdkExtKt.isAssociatedWithAnotherModule(sdk, this.d))).toList();
        List<Sdk> list4 = this.m ? list3 : list2;
        this.h.setModel((ListModel<Object>)new CollectionListModel(list4));
        this.n = false;
        if (sdk2 != null) {
            sdk2 = this.e.findSdk(sdk2.getName());
            this.h.clearSelection();
            this.h.setSelectedValue(sdk2, true);
            this.h.updateUI();
        }
    }

    @Nullable
    private Sdk a() {
        if (this.d == null) {
            return ProjectRootManager.getInstance((Project)this.i).getProjectSdk();
        }
        ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)this.d);
        return moduleRootManager.getSdk();
    }

    private void d() {
        PyAddSdkDialog.show(this.i, this.d, Arrays.asList(this.e.getSdks()), sdk -> this.a((Sdk)sdk, true));
    }

    private void a(@Nullable Sdk sdk, boolean bl2) {
        if (sdk != null) {
            Object object;
            boolean bl3 = PythonSdkType.isVirtualEnv(sdk);
            if (bl3 && !bl2) {
                object = new AddVEnvOptionsDialog(this.b);
                object.show();
                if (object.getExitCode() != 0) {
                    return;
                }
                SdkModificator sdkModificator = this.a.get(sdk);
                this.a(sdkModificator, !((AddVEnvOptionsDialog)((Object)object)).makeAvailableToAll());
                this.k.add(sdkModificator);
            }
            if ((object = this.e.findSdk(sdk)) == null) {
                this.e.addSdk(sdk);
            }
            this.c();
            this.h.setSelectedValue(this.e.findSdk(sdk.getName()), true);
            this.n = true;
        }
    }

    private void e() {
        Sdk sdk = this.getSelectedSdk();
        if (sdk != null) {
            if (sdk.getSdkAdditionalData() instanceof RemoteSdkAdditionalData) {
                this.a(sdk);
            } else {
                this.f(sdk);
            }
        }
    }

    private void a(Sdk sdk) {
        PythonRemoteInterpreterManager pythonRemoteInterpreterManager = PythonRemoteInterpreterManager.getInstance();
        if (pythonRemoteInterpreterManager != null) {
            SdkModificator sdkModificator = this.a.get(sdk);
            HashSet hashSet = Sets.newHashSet((Object[])this.e.getSdks());
            hashSet.remove(sdk);
            if (pythonRemoteInterpreterManager.editSdk(this.i, sdkModificator, hashSet)) {
                this.k.add(sdkModificator);
            }
        }
    }

    private void f(Sdk sdk) {
        SdkModificator sdkModificator = this.a.get(sdk);
        EditSdkDialog editSdkDialog = new EditSdkDialog(this.i, sdkModificator, (NullableFunction<String, String>)((NullableFunction)string -> {
            long l2 = o ^ 0x227F9BCCA924L;
            if (this.a((String)string, sdk)) {
                return PyBundle.message("sdk.details.dialog.error.duplicate.name", new Object[0]);
            }
            return null;
        }));
        if (editSdkDialog.showAndGet()) {
            boolean bl2;
            this.h.repaint();
            boolean bl3 = bl2 = !Comparing.equal((String)sdk.getHomePath(), (String)editSdkDialog.getHomePath());
            if (!sdkModificator.getName().equals(editSdkDialog.getName()) || bl2 || editSdkDialog.isAssociateChanged()) {
                this.k.add(sdkModificator);
                sdkModificator.setName(editSdkDialog.getName());
                sdkModificator.setHomePath(editSdkDialog.getHomePath());
                if (editSdkDialog.isAssociateChanged()) {
                    this.a(sdkModificator, editSdkDialog.associateWithProject());
                }
                if (bl2) {
                    this.b(sdk);
                }
            }
        }
    }

    private void a(SdkModificator sdkModificator, boolean bl2) {
        PythonSdkAdditionalData pythonSdkAdditionalData = (PythonSdkAdditionalData)sdkModificator.getSdkAdditionalData();
        if (pythonSdkAdditionalData == null) {
            pythonSdkAdditionalData = new PythonSdkAdditionalData(PythonSdkFlavor.getFlavor(sdkModificator.getHomePath()));
            sdkModificator.setSdkAdditionalData((SdkAdditionalData)pythonSdkAdditionalData);
        }
        if (bl2 && this.d != null) {
            pythonSdkAdditionalData.associateWithModule(this.d);
        } else if (bl2 && this.i != null) {
            pythonSdkAdditionalData.setAssociatedModulePath(this.i.getBasePath());
        } else {
            pythonSdkAdditionalData.resetAssociatedModulePath();
        }
    }

    private boolean a(String string, Sdk sdk) {
        for (Sdk sdk2 : this.e.getSdks()) {
            String string2;
            if (sdk2 == sdk || !(string2 = this.a.containsKey(sdk2) ? this.a.get(sdk2).getName() : sdk2.getName()).equals(string)) continue;
            return true;
        }
        return false;
    }

    private void g() {
        Sdk sdk = this.getSelectedSdk();
        if (sdk != null) {
            SdkModificator sdkModificator;
            Sdk sdk2 = this.e.findSdk(sdk);
            SdkConfigurationUtil.removeSdk((Sdk)sdk2);
            this.e.removeSdk(sdk2);
            this.e.removeSdk(sdk);
            if (this.a.containsKey(sdk)) {
                sdkModificator = this.a.get(sdk);
                this.k.remove(sdkModificator);
                this.a.remove(sdk);
            }
            this.c();
            this.n = true;
            sdkModificator = this.a();
            if (sdkModificator != null) {
                this.h.setSelectedValue(sdkModificator, true);
            }
        }
    }

    private void f() {
        Sdk sdk = this.getSelectedSdk();
        if (sdk != null) {
            this.k.add(this.a.get(sdk));
            this.b(sdk);
        }
    }

    private void b(@NotNull Sdk sdk) {
        if (sdk == null) {
            PythonSdkDetailsDialog.a(0);
        }
        if (PythonSdkUpdater.update(sdk, this.a.get(sdk), this.i, null)) {
            this.k.remove(this.a.get(sdk));
            this.a.put(sdk, sdk.getSdkModificator());
        }
    }

    private PythonPathEditor c(Sdk sdk) {
        long l2 = o ^ 0x56F41E1CB4F2L;
        if (PySdkUtil.isRemote(sdk)) {
            return new PyRemotePathEditor(this, sdk);
        }
        return new PythonPathEditor("Classes", OrderRootType.CLASSES, FileChooserDescriptorFactory.createAllButJarContentsDescriptor()){

            @Override
            protected void onReloadButtonClicked() {
                PythonSdkDetailsDialog.this.f();
            }
        };
    }

    static {
        o = com.jetbrains.python.psi.c.a(-1724598310949679373L, -6847666910204217840L, MethodHandles.lookup().lookupClass()).a(193292106079670L);
        long l2 = o ^ 0x26805AF44434L;
        c = Logger.getInstance((String)"#com.jetbrains.python.configuration.PythonSdkDetailsDialog");
    }

    private static /* synthetic */ void a(int n2) {
        long l2 = o ^ 0x3DE4DFFD9ACFL;
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentSdk", "com/jetbrains/python/configuration/PythonSdkDetailsDialog", "reloadSdk"));
    }

    private class PyRemotePathEditor
    extends PythonPathEditor {
        private final PyRemoteSdkAdditionalDataBase c;
        private final Sdk b;
        private final List<PathMappingSettings.PathMapping> d;
        final /* synthetic */ PythonSdkDetailsDialog this$0;
        private static final long f = com.jetbrains.python.psi.c.a(-2598719535024820088L, 4614903642294230708L, MethodHandles.lookup().lookupClass()).a(65366069414083L);

        PyRemotePathEditor(PythonSdkDetailsDialog pythonSdkDetailsDialog, Sdk sdk) {
            long l2 = f ^ 0x76AEE9492AE6L;
            this.this$0 = pythonSdkDetailsDialog;
            super("Classes", OrderRootType.CLASSES, FileChooserDescriptorFactory.createAllButJarContentsDescriptor());
            this.d = Lists.newArrayList();
            this.b = sdk;
            this.c = (PyRemoteSdkAdditionalDataBase)this.b.getSdkAdditionalData();
        }

        @Override
        protected void onReloadButtonClicked() {
            this.this$0.f();
        }

        @Override
        protected String getPresentablePath(VirtualFile value) {
            String string = value.getPath();
            return this.c.getPathMappings().convertToRemote(string);
        }

        @Override
        protected void addToolbarButtons(ToolbarDecorator toolbarDecorator) {
            toolbarDecorator.setAddAction(new AnActionButtonRunnable(){

                public void run(AnActionButton button) {
                    Object[] objectArray = PyRemotePathEditor.this.doAddItems();
                    if (objectArray.length > 0) {
                        PyRemotePathEditor.this.setModified(true);
                    }
                    PyRemotePathEditor.this.requestDefaultFocus();
                    PyRemotePathEditor.this.setSelectedRoots(objectArray);
                }
            });
            super.addToolbarButtons(toolbarDecorator);
        }

        protected VirtualFile[] doAddItems() {
            Project project = (Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext((Component)this.myPanel));
            try {
                String[] stringArray = PythonRemoteInterpreterManager.getInstance().chooseRemoteFiles(project, (PyRemoteSdkAdditionalDataBase)this.b.getSdkAdditionalData(), false);
                String string = PySdkUtil.getRemoteSourcesLocalPath(this.b.getHomePath());
                VirtualFile[] virtualFileArray = new VirtualFile[stringArray.length];
                int n2 = 0;
                for (String string2 : stringArray) {
                    String string3 = PyRemoteSourceItem.localPathForRemoteRoot(string, string2);
                    this.d.add(new PathMappingSettings.PathMapping(string3, string2));
                    this.c.getPathMappings().addMappingCheckUnique(string3, string2);
                    if (!new File(string3).exists()) {
                        new File(string3).mkdirs();
                    }
                    virtualFileArray[n2++] = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(new File(string3));
                }
                virtualFileArray = this.adjustAddedFileSet(this.myPanel, virtualFileArray);
                ArrayList arrayList = new ArrayList(virtualFileArray.length);
                for (VirtualFile virtualFile : virtualFileArray) {
                    if (!this.addElement(virtualFile)) continue;
                    arrayList.add(virtualFile);
                }
                return VfsUtilCore.toVirtualFileArray((Collection)arrayList);
            }
            catch (Exception exception) {
                c.error((Throwable)exception);
                return VirtualFile.EMPTY_ARRAY;
            }
        }

        @Override
        public void apply(SdkModificator sdkModificator) {
            if (sdkModificator.getSdkAdditionalData() instanceof PyRemoteSdkAdditionalDataBase) {
                for (PathMappingSettings.PathMapping pathMapping : this.d) {
                    ((PyRemoteSdkAdditionalDataBase)sdkModificator.getSdkAdditionalData()).getPathMappings().addMappingCheckUnique(pathMapping.getLocalRoot(), pathMapping.getRemoteRoot());
                }
            }
            super.apply(sdkModificator);
        }
    }

    private class ShowPathButton
    extends AnActionButton
    implements DumbAware {
        final /* synthetic */ PythonSdkDetailsDialog this$0;
        private static final long a = com.jetbrains.python.psi.c.a(8626203613678855632L, 6575021542189354092L, MethodHandles.lookup().lookupClass()).a(79375561793745L);

        ShowPathButton(PythonSdkDetailsDialog pythonSdkDetailsDialog) {
            long l2 = a ^ 0x40FFDDCDB438L;
            this.this$0 = pythonSdkDetailsDialog;
            super(PyBundle.message("sdk.details.dialog.show.interpreter.paths", new Object[0]), AllIcons.Actions.ShowAsTree);
        }

        public boolean isEnabled() {
            return this.this$0.getSelectedSdk() != null;
        }

        public void actionPerformed(@NotNull AnActionEvent e10) {
            if (e10 == null) {
                ShowPathButton.a(0);
            }
            Sdk sdk = this.this$0.getSelectedSdk();
            PythonPathEditor pythonPathEditor = this.this$0.c(sdk);
            SdkModificator sdkModificator = (SdkModificator)this.this$0.a.get(sdk);
            PythonPathDialog pythonPathDialog = new PythonPathDialog(this.this$0.i, pythonPathEditor);
            pythonPathEditor.reset((SdkModificator)(sdk != null ? sdkModificator : null));
            if (pythonPathDialog.showAndGet() && pythonPathEditor.isModified()) {
                pythonPathEditor.apply(sdkModificator);
                this.this$0.k.add(sdkModificator);
            }
            this.this$0.updateOkButton();
        }

        private static /* synthetic */ void a(int n2) {
            long l2 = a ^ 0x12907327D3F7L;
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/python/configuration/PythonSdkDetailsDialog$ShowPathButton", "actionPerformed"));
        }
    }

    private class ToggleVirtualEnvFilterButton
    extends ToggleActionButton
    implements DumbAware {
        final /* synthetic */ PythonSdkDetailsDialog this$0;
        private static final long a = com.jetbrains.python.psi.c.a(-9163137584591545874L, 7409354945872699158L, MethodHandles.lookup().lookupClass()).a(201146631238405L);

        ToggleVirtualEnvFilterButton(PythonSdkDetailsDialog pythonSdkDetailsDialog) {
            long l2 = a ^ 0xB1D9E3A8C3L;
            this.this$0 = pythonSdkDetailsDialog;
            super(PyBundle.message("sdk.details.dialog.hide.all.virtual.envs", new Object[0]), AllIcons.General.Filter);
        }

        public boolean isSelected(AnActionEvent e10) {
            return this.this$0.m;
        }

        public void setSelected(AnActionEvent e10, boolean state2) {
            this.this$0.m = state2;
            this.this$0.c();
            this.this$0.updateOkButton();
        }
    }
}

