/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.configuration;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.icons.AllIcons;
import com.intellij.ide.highlighter.ArchiveFileType;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.projectRoots.ui.SdkPathEditor;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.ListUtil;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBList;
import com.intellij.util.ArrayUtil;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.codeInsight.typing.PyTypeShed;
import com.jetbrains.python.codeInsight.userSkeletons.PyUserSkeletonsUtil;
import com.jetbrains.python.psi.c;
import com.jetbrains.python.sdk.PythonSdkAdditionalData;
import com.jetbrains.python.sdk.PythonSdkType;
import java.awt.Component;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PythonPathEditor
extends SdkPathEditor {
    private final PathListModel a;
    private static final long e = c.a(-4219872635204483394L, -7032113564534374001L, MethodHandles.lookup().lookupClass()).a(93413990988424L);

    public PythonPathEditor(String displayName, @NotNull OrderRootType orderRootType, FileChooserDescriptor descriptor2) {
        if (orderRootType == null) {
            PythonPathEditor.a(0);
        }
        super(displayName, orderRootType, descriptor2);
        this.a = new PathListModel(orderRootType, this.getListModel());
    }

    public void reset(@Nullable SdkModificator modificator) {
        if (modificator != null) {
            ArrayList arrayList = Lists.newArrayList((Object[])modificator.getRoots(this.getOrderRootType()));
            this.resetPath(this.a.reset(arrayList, modificator));
        } else {
            this.setEnabled(false);
        }
    }

    public void reload(@Nullable SdkModificator sdkModificator) {
        if (sdkModificator != null) {
            ArrayList arrayList = Lists.newArrayList((Object[])sdkModificator.getRoots(this.getOrderRootType()));
            this.resetPath(this.a.reload(arrayList));
            this.setModified(true);
        } else {
            this.setEnabled(false);
        }
    }

    public void apply(SdkModificator sdkModificator) {
        sdkModificator.removeRoots(this.getOrderRootType());
        for (int i10 = 0; i10 < this.a.a(); ++i10) {
            VirtualFile virtualFile = this.a.a(i10);
            if (this.a.isExcluded(virtualFile)) continue;
            sdkModificator.addRoot(virtualFile, this.getOrderRootType());
        }
        this.setModified(false);
        this.a.apply(sdkModificator);
    }

    protected VirtualFile[] adjustAddedFileSet(Component component, VirtualFile[] files2) {
        int n2 = files2.length;
        for (int i10 = 0; i10 < n2; ++i10) {
            if (files2[i10].isDirectory() || files2[i10].getFileType() != ArchiveFileType.INSTANCE) continue;
            files2[i10] = JarFileSystem.getInstance().getJarRootForLocalFile(files2[i10]);
        }
        if (this.a.add(Lists.newArrayList((Object[])files2))) {
            this.setModified(true);
        }
        return files2;
    }

    protected void doRemoveItems(int[] idxs, JList list2) {
        ArrayList arrayList = Lists.newArrayList();
        for (int n2 : idxs) {
            arrayList.add(Pair.create(this.getListModel().get(n2), (Object)n2));
        }
        ListUtil.removeIndices((JList)list2, (int[])this.a.remove(arrayList));
        list2.updateUI();
        this.setModified(true);
    }

    protected ListCellRenderer<VirtualFile> createListCellRenderer(JBList list2) {
        return SimpleListCellRenderer.create((String)"", virtualFile -> {
            long l2 = e ^ 0x7EC47F153940L;
            String string = this.a.getPresentationSuffix((VirtualFile)virtualFile);
            if (string.length() > 0) {
                string = "  " + string;
            }
            return this.getPresentablePath((VirtualFile)virtualFile) + string;
        });
    }

    protected void addToolbarButtons(ToolbarDecorator toolbarDecorator) {
        long l2 = e ^ 0x273D1F53C954L;
        AnActionButton anActionButton = new AnActionButton(PyBundle.message("sdk.paths.dialog.reload.paths", new Object[0]), AllIcons.Actions.Refresh){
            private static final long a = c.a(-1199095589198210229L, 4535790863249837981L, MethodHandles.lookup().lookupClass()).a(248051478818595L);

            public void actionPerformed(@NotNull AnActionEvent e10) {
                if (e10 == null) {
                    1.a(0);
                }
                PythonPathEditor.this.onReloadButtonClicked();
            }

            private static /* synthetic */ void a(int n2) {
                long l2 = a ^ 0x73538BAE73E0L;
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/python/configuration/PythonPathEditor$1", "actionPerformed"));
            }
        };
        toolbarDecorator.addExtraAction(anActionButton);
    }

    protected void onReloadButtonClicked() {
    }

    protected String getPresentablePath(VirtualFile value) {
        return value.getPresentableUrl();
    }

    private static /* synthetic */ void a(int n2) {
        long l2 = e ^ 0xEBFDCE32317L;
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "orderRootType", "com/jetbrains/python/configuration/PythonPathEditor", "<init>"));
    }

    private static class PathListModel {
        private Set<VirtualFile> c = Sets.newHashSet();
        private Set<VirtualFile> e = Sets.newHashSet();
        private final Set<VirtualFile> f = Sets.newHashSet();
        private final List<VirtualFile> a = Lists.newArrayList();
        private final DefaultListModel b;
        private final OrderRootType g;
        private final Set<VirtualFile> d = Sets.newHashSet();
        private static final long h = com.jetbrains.python.psi.c.a(4453017425947699665L, -5509789410438945658L, MethodHandles.lookup().lookupClass()).a(177782735915962L);

        PathListModel(OrderRootType orderRootType, DefaultListModel listModel) {
            this.g = orderRootType;
            this.b = listModel;
        }

        private int a() {
            return this.b.getSize();
        }

        private VirtualFile a(int n2) {
            return (VirtualFile)this.b.get(n2);
        }

        public boolean add(List<VirtualFile> files2) {
            for (VirtualFile virtualFile : files2) {
                if (!this.f.contains(virtualFile)) {
                    if (!this.e.remove(virtualFile)) {
                        this.c.add(virtualFile);
                        this.d.remove(virtualFile);
                        continue;
                    }
                    this.f.add(virtualFile);
                    return true;
                }
                this.e.remove(virtualFile);
            }
            return false;
        }

        public int[] remove(List<Pair<VirtualFile, Integer>> files2) {
            ArrayList arrayList = Lists.newArrayList();
            for (Pair<VirtualFile, Integer> pair : files2) {
                if (this.c.contains(pair.first)) {
                    arrayList.add(pair.second);
                    this.c.remove(pair.first);
                    this.d.add((VirtualFile)pair.first);
                    continue;
                }
                if (this.e.contains(pair.first)) {
                    this.e.remove(pair.first);
                    continue;
                }
                this.e.add((VirtualFile)pair.first);
            }
            return ArrayUtil.toIntArray((Collection)arrayList);
        }

        public void apply(SdkModificator sdkModificator) {
            sdkModificator.setSdkAdditionalData(this.a(sdkModificator));
            this.b(sdkModificator);
        }

        private void b(SdkModificator sdkModificator) {
            for (VirtualFile virtualFile : this.a) {
                sdkModificator.addRoot(virtualFile, this.g);
            }
        }

        private SdkAdditionalData a(SdkModificator sdkModificator) {
            PythonSdkAdditionalData pythonSdkAdditionalData = (PythonSdkAdditionalData)sdkModificator.getSdkAdditionalData();
            if (pythonSdkAdditionalData == null) {
                pythonSdkAdditionalData = new PythonSdkAdditionalData(null);
            }
            pythonSdkAdditionalData.setAddedPathsFromVirtualFiles(this.c);
            pythonSdkAdditionalData.setExcludedPathsFromVirtualFiles(this.e);
            return pythonSdkAdditionalData;
        }

        public void setAdded(Set<VirtualFile> added) {
            this.c = Sets.newHashSet(added);
        }

        public void setExcluded(Set<VirtualFile> excluded) {
            this.e = Sets.newHashSet(excluded);
        }

        public String getPresentationSuffix(VirtualFile file) {
            long l2 = h ^ 0x61DB93073BDDL;
            if (this.c.contains(file)) {
                return PyBundle.message("sdk.paths.dialog.added.by.user.suffix", new Object[0]);
            }
            if (this.e.contains(file)) {
                return PyBundle.message("sdk.paths.dialog.removed.by.user.suffix", new Object[0]);
            }
            return "";
        }

        public List<VirtualFile> reload(List<VirtualFile> list2) {
            this.f.clear();
            this.f.addAll(list2);
            List<VirtualFile> list3 = PathListModel.a(list2, this.a);
            list3.removeAll(this.d);
            list3.addAll(this.c);
            return list3;
        }

        public List<VirtualFile> reset(List<VirtualFile> list2, SdkModificator modificator) {
            this.a.clear();
            List<VirtualFile> list3 = PathListModel.a(list2, this.a);
            this.f.clear();
            this.f.addAll(list2);
            this.d.clear();
            if (modificator.getSdkAdditionalData() instanceof PythonSdkAdditionalData) {
                PythonSdkAdditionalData pythonSdkAdditionalData = (PythonSdkAdditionalData)modificator.getSdkAdditionalData();
                this.setAdded(pythonSdkAdditionalData.getAddedPathFiles());
                this.setExcluded(pythonSdkAdditionalData.getExcludedPathFiles());
                list3.addAll(this.e);
                list3.addAll(this.c);
            } else if (modificator.getSdkAdditionalData() == null) {
                this.c.clear();
                this.e.clear();
            }
            return list3;
        }

        private static List<VirtualFile> a(List<VirtualFile> list2, List<VirtualFile> list3) {
            ArrayList arrayList = Lists.newArrayList();
            list3.clear();
            for (VirtualFile virtualFile : list2) {
                if (!PathListModel.a(virtualFile)) {
                    arrayList.add(virtualFile);
                    continue;
                }
                list3.add(virtualFile);
            }
            return arrayList;
        }

        private static boolean a(@NotNull VirtualFile virtualFile) {
            if (virtualFile == null) {
                PathListModel.b(0);
            }
            String string = PythonSdkType.getSkeletonsRootPath(PathManager.getSystemPath());
            VirtualFile virtualFile2 = LocalFileSystem.getInstance().findFileByPath(string);
            if (virtualFile2 != null && virtualFile.getPath().startsWith(virtualFile2.getPath())) {
                return true;
            }
            if (virtualFile.equals(PyUserSkeletonsUtil.getUserSkeletonsDirectory())) {
                return true;
            }
            return PyTypeShed.INSTANCE.isInside(virtualFile);
        }

        public boolean isExcluded(VirtualFile path) {
            return this.e.contains(path);
        }

        private static /* synthetic */ void b(int n2) {
            long l2 = h ^ 0xD06DD750869L;
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/python/configuration/PythonPathEditor$PathListModel", "isStubPath"));
        }
    }
}

