/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.testIntegration;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.ex.IdeDocumentHistory;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.testIntegration.TestCreator;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.python.PythonFileType;
import com.jetbrains.python.codeInsight.imports.AddImportHelper;
import com.jetbrains.python.codeInsight.testIntegration.CreateTestAction;
import com.jetbrains.python.codeInsight.testIntegration.CreateTestDialog;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.c;
import java.lang.invoke.MethodHandles;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PyTestCreator
implements TestCreator {
    private static final Logger a;
    private static final long b;

    public boolean isAvailable(Project project, Editor editor2, PsiFile file) {
        CreateTestAction createTestAction = new CreateTestAction();
        PsiElement psiElement = file.findElementAt(editor2.getCaretModel().getOffset());
        if (psiElement != null) {
            return createTestAction.isAvailable(project, editor2, psiElement);
        }
        return false;
    }

    public void createTest(Project project, Editor editor2, PsiFile file) {
        try {
            CreateTestAction createTestAction = new CreateTestAction();
            PsiElement psiElement = file.findElementAt(editor2.getCaretModel().getOffset());
            if (createTestAction.isAvailable(project, editor2, psiElement)) {
                createTestAction.invoke(project, editor2, file.getContainingFile());
            }
        }
        catch (IncorrectOperationException incorrectOperationException) {
            a.warn((Throwable)incorrectOperationException);
        }
    }

    static PsiFile generateTestAndNavigate(@NotNull Project project, @NotNull CreateTestDialog dialog) {
        if (project == null) {
            PyTestCreator.a(0);
        }
        if (dialog == null) {
            PyTestCreator.a(1);
        }
        return (PsiFile)PostprocessReformattingAspect.getInstance((Project)project).postponeFormattingInside(() -> (PsiFile)ApplicationManager.getApplication().runWriteAction(() -> {
            try {
                PyElement pyElement = PyTestCreator.generateTest(project, dialog);
                pyElement.navigate(false);
                return pyElement.getContainingFile();
            }
            catch (IncorrectOperationException incorrectOperationException) {
                a.warn((Throwable)incorrectOperationException);
                return null;
            }
        }));
    }

    @NotNull
    static PyElement generateTest(@NotNull Project project, @NotNull CreateTestDialog dialog) {
        long l2 = b ^ 0x2E549E9059E5L;
        if (project == null) {
            PyTestCreator.a(2);
        }
        if (dialog == null) {
            PyTestCreator.a(3);
        }
        IdeDocumentHistory.getInstance((Project)project).includeCurrentPlaceAsChangePlace();
        String string = dialog.getFileName();
        if (!string.endsWith(".py")) {
            string = string + "." + PythonFileType.INSTANCE.getDefaultExtension();
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("class ").append(dialog.getClassName()).append("(TestCase):\n\t");
        List<String> list2 = dialog.getMethods();
        if (list2.size() == 0) {
            stringBuilder.append("pass\n");
        }
        for (String object2 : list2) {
            stringBuilder.append("def ").append(object2).append("(self):\n\tself.fail()\n\n\t");
        }
        PyFile pyFile = PyUtil.getOrCreateFile(dialog.getTargetDir() + "/" + string, project);
        AddImportHelper.addOrUpdateFromImportStatement(pyFile, "unittest", "TestCase", null, AddImportHelper.ImportPriority.BUILTIN, null);
        PyElement pyElement2 = PyElementGenerator.getInstance(project).createFromText(LanguageLevel.forElement((PsiElement)pyFile), PyClass.class, stringBuilder.toString());
        pyElement2 = (PyElement)pyFile.addAfter((PsiElement)pyElement2, pyFile.getLastChild());
        PostprocessReformattingAspect.getInstance((Project)project).doPostponedFormatting(pyFile.getViewProvider());
        CodeStyleManager.getInstance((Project)project).reformat((PsiElement)pyFile);
        PyElement pyElement3 = pyElement2;
        if (pyElement3 == null) {
            PyTestCreator.a(4);
        }
        return pyElement3;
    }

    static {
        b = c.a(-6859771497055686489L, -6515204557081154002L, MethodHandles.lookup().lookupClass()).a(263631671262074L);
        long l2 = b ^ 0x45A1D41248D4L;
        a = Logger.getInstance((String)"#com.jetbrains.python.codeInsight.testIntegration.PyTestCreator");
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = b ^ 0x7019FB629F31L;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 4: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialog";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/codeInsight/testIntegration/PyTestCreator";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/codeInsight/testIntegration/PyTestCreator";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "generateTest";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "generateTestAndNavigate";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "generateTest";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

