/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.imports;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.QualifiedName;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyFromImportStatement;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyImportElement;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.c;
import java.lang.invoke.MethodHandles;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImportCandidateHolder
implements Comparable<ImportCandidateHolder> {
    @NotNull
    private final SmartPsiElementPointer<PsiElement> e;
    @Nullable
    private final SmartPsiElementPointer<PyImportElement> d;
    @NotNull
    private final SmartPsiElementPointer<PsiFileSystemItem> a;
    @Nullable
    private final QualifiedName b;
    @Nullable
    private final String c;
    private static final long f = com.jetbrains.python.psi.c.a(6879036817280071132L, 3573044668497602334L, MethodHandles.lookup().lookupClass()).a(18558667748534L);

    public ImportCandidateHolder(@NotNull PsiElement importable, @NotNull PsiFileSystemItem file, @Nullable PyImportElement importElement, @Nullable QualifiedName path, @Nullable String asName) {
        if (importable == null) {
            ImportCandidateHolder.a(0);
        }
        if (file == null) {
            ImportCandidateHolder.a(1);
        }
        SmartPointerManager smartPointerManager = SmartPointerManager.getInstance((Project)importable.getProject());
        this.a = smartPointerManager.createSmartPsiElementPointer((PsiElement)file);
        this.e = smartPointerManager.createSmartPsiElementPointer(importable);
        this.d = importElement != null ? smartPointerManager.createSmartPsiElementPointer((PsiElement)importElement) : null;
        this.b = path;
        this.c = asName;
        assert (importElement != null || path != null);
    }

    public ImportCandidateHolder(@NotNull PsiElement importable, @NotNull PsiFileSystemItem file, @Nullable PyImportElement importElement, @Nullable QualifiedName path) {
        if (importable == null) {
            ImportCandidateHolder.a(2);
        }
        if (file == null) {
            ImportCandidateHolder.a(3);
        }
        this(importable, file, importElement, path, null);
    }

    @Nullable
    public PsiElement getImportable() {
        return this.e.getElement();
    }

    @Nullable
    public PyImportElement getImportElement() {
        return this.d != null ? (PyImportElement)this.d.getElement() : null;
    }

    @Nullable
    public PsiFileSystemItem getFile() {
        return (PsiFileSystemItem)this.a.getElement();
    }

    @Nullable
    public QualifiedName getPath() {
        return this.b;
    }

    @NotNull
    public static String getQualifiedName(@NotNull String name, @Nullable QualifiedName importPath, @Nullable PyImportElement source) {
        if (name == null) {
            ImportCandidateHolder.a(4);
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (source != null) {
            PsiElement psiElement = source.getParent();
            if (psiElement instanceof PyFromImportStatement) {
                stringBuilder.append(name);
            } else {
                stringBuilder.append(source.getVisibleName()).append(".").append(name);
            }
        } else {
            if (importPath != null && importPath.getComponentCount() > 0) {
                stringBuilder.append(importPath).append(".");
            }
            stringBuilder.append(name);
        }
        String string = stringBuilder.toString();
        if (string == null) {
            ImportCandidateHolder.a(5);
        }
        return string;
    }

    @NotNull
    public String getPresentableText(@NotNull String myName) {
        Object object;
        long l2 = f ^ 0x4A05E80D61F6L;
        if (myName == null) {
            ImportCandidateHolder.a(6);
        }
        PyImportElement pyImportElement = this.getImportElement();
        PsiElement psiElement = this.getImportable();
        StringBuilder stringBuilder = new StringBuilder(ImportCandidateHolder.getQualifiedName(myName, this.b, pyImportElement));
        PsiElement psiElement2 = null;
        if (pyImportElement != null) {
            psiElement2 = pyImportElement.getParent();
        }
        if (psiElement instanceof PyFunction) {
            stringBuilder.append("()");
        } else if (psiElement instanceof PyClass && !(object = ContainerUtil.mapNotNull((Object[])((PyClass)psiElement).getSuperClasses(null), pyClass -> PyUtil.isObjectClass(pyClass) ? null : pyClass.getName())).isEmpty()) {
            stringBuilder.append("(");
            StringUtil.join((Collection)object, (String)", ", (StringBuilder)stringBuilder);
            stringBuilder.append(")");
        }
        if (psiElement2 instanceof PyFromImportStatement) {
            stringBuilder.append(" from ");
            object = (PyFromImportStatement)psiElement2;
            stringBuilder.append(StringUtil.repeat((String)".", (int)object.getRelativeLevel()));
            PyReferenceExpression pyReferenceExpression = object.getImportSource();
            if (pyReferenceExpression != null) {
                stringBuilder.append(pyReferenceExpression.asQualifiedName());
            }
        }
        String string = stringBuilder.toString();
        if (string == null) {
            ImportCandidateHolder.a(7);
        }
        return string;
    }

    @Override
    public int compareTo(@NotNull ImportCandidateHolder other) {
        int n2;
        if (other == null) {
            ImportCandidateHolder.a(8);
        }
        int n3 = this.getRelevance();
        int n4 = other.getRelevance();
        if (n4 != n3) {
            return n4 - n3;
        }
        if (this.b != null && other.b != null && (n2 = this.b.getComponentCount() - other.b.getComponentCount()) != 0) {
            return n2;
        }
        return Comparing.compare((Comparable)this.b, (Comparable)other.b);
    }

    int getRelevance() {
        VirtualFile virtualFile;
        long l2 = f ^ 0x26DDC7CE9026L;
        if (this.d != null) {
            return 4;
        }
        Project project = this.e.getProject();
        PsiFile psiFile = this.e.getContainingFile();
        VirtualFile virtualFile2 = virtualFile = psiFile == null ? null : psiFile.getVirtualFile();
        if (virtualFile == null) {
            return 0;
        }
        ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        Module module2 = projectFileIndex.getModuleForFile(virtualFile);
        if (module2 != null) {
            return 3;
        }
        if (virtualFile.getParent().getName().equals("Lib")) {
            return 2;
        }
        if (virtualFile.getParent().getName().equals("test")) {
            return 0;
        }
        return 1;
    }

    @Nullable
    public String getAsName() {
        return this.c;
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = f ^ 0x378ECF31585DL;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 5: 
            case 7: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importable";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/codeInsight/imports/ImportCandidateHolder";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "myName";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "other";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/codeInsight/imports/ImportCandidateHolder";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifiedName";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableText";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getQualifiedName";
                break;
            }
            case 5: 
            case 7: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getPresentableText";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "compareTo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

