/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.highlighting;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.controlflow.ControlFlow;
import com.intellij.codeInsight.controlflow.Instruction;
import com.intellij.codeInsight.highlighting.HighlightUsagesHandler;
import com.intellij.codeInsight.highlighting.HighlightUsagesHandlerBase;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Consumer;
import com.jetbrains.python.codeInsight.controlflow.ControlFlowCache;
import com.jetbrains.python.psi.PyBreakStatement;
import com.jetbrains.python.psi.PyContinueStatement;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyRaiseStatement;
import com.jetbrains.python.psi.PyReturnStatement;
import com.jetbrains.python.psi.c;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class PyHighlightExitPointsHandler
extends HighlightUsagesHandlerBase<PsiElement> {
    private final PsiElement a;
    private static final long b = c.a(5589420116027365319L, 3364152541763065282L, MethodHandles.lookup().lookupClass()).a(170422844301139L);

    public PyHighlightExitPointsHandler(Editor editor2, PsiFile file, PsiElement target) {
        super(editor2, file);
        this.a = target;
    }

    public List<PsiElement> getTargets() {
        return Collections.singletonList(this.a);
    }

    protected void selectTargets(List<PsiElement> targets, Consumer<List<PsiElement>> selectionConsumer) {
        selectionConsumer.consume(targets);
    }

    public void computeUsages(List<PsiElement> targets) {
        PsiElement psiElement = this.a.getParent();
        if (!(psiElement instanceof PyReturnStatement)) {
            return;
        }
        PyFunction pyFunction = (PyFunction)PsiTreeUtil.getParentOfType((PsiElement)this.a, PyFunction.class);
        if (pyFunction == null) {
            return;
        }
        this.a((PyReturnStatement)psiElement, pyFunction);
    }

    @Nullable
    private static PsiElement a(PsiElement psiElement) {
        if (psiElement instanceof PyReturnStatement) {
            return PsiTreeUtil.getParentOfType((PsiElement)psiElement, PyFunction.class);
        }
        if (psiElement instanceof PyBreakStatement) {
            return ((PyBreakStatement)psiElement).getLoopStatement();
        }
        if (psiElement instanceof PyContinueStatement) {
            return ((PyContinueStatement)psiElement).getLoopStatement();
        }
        if (psiElement instanceof PyRaiseStatement) {
            return null;
        }
        return null;
    }

    private void a(PyReturnStatement pyReturnStatement, PyFunction pyFunction) {
        long l2 = b ^ 0x41E7BBC78344L;
        ControlFlow controlFlow = ControlFlowCache.getControlFlow(pyFunction);
        Collection<PsiElement> collection = PyHighlightExitPointsHandler.a(controlFlow);
        if (!collection.contains(pyReturnStatement)) {
            return;
        }
        PsiElement psiElement = PyHighlightExitPointsHandler.a((PsiElement)pyReturnStatement);
        for (PsiElement psiElement2 : collection) {
            if (PyHighlightExitPointsHandler.a(psiElement2) != psiElement) continue;
            this.addOccurrence(psiElement2);
        }
        this.myStatusText = CodeInsightBundle.message((String)"status.bar.exit.points.highlighted.message", (Object[])new Object[]{collection.size(), HighlightUsagesHandler.getShortcutText()});
    }

    private static Collection<PsiElement> a(ControlFlow controlFlow) {
        ArrayList<PsiElement> arrayList = new ArrayList<PsiElement>();
        Instruction[] instructionArray = controlFlow.getInstructions();
        for (Instruction instruction : instructionArray[instructionArray.length - 1].allPred()) {
            PsiElement psiElement;
            PsiElement psiElement2 = instruction.getElement();
            if (psiElement2 == null || (psiElement = PyPsiUtils.getStatement(psiElement2)) == null) continue;
            arrayList.add(psiElement);
        }
        return arrayList;
    }

    @Nullable
    public String getFeatureId() {
        return super.getFeatureId();
    }
}

