/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight;

import com.intellij.codeInsight.editorActions.CodeBlockProvider;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.python.psi.PyStatement;
import com.jetbrains.python.psi.PyStatementList;
import org.jetbrains.annotations.Nullable;

public class PyCodeBlockProvider
implements CodeBlockProvider {
    @Nullable
    public TextRange getCodeBlockRange(Editor editor2, PsiFile psiFile) {
        int n2 = editor2.getCaretModel().getOffset();
        PsiElement psiElement = psiFile.findElementAt(n2);
        if (psiElement == null) {
            return null;
        }
        while (n2 > 0 && psiElement instanceof PsiWhiteSpace) {
            psiElement = psiFile.findElementAt(--n2);
        }
        PyStatement pyStatement = (PyStatement)PsiTreeUtil.getParentOfType((PsiElement)psiElement, PyStatement.class);
        if (pyStatement != null) {
            PyStatementList pyStatementList = (PyStatementList)PsiTreeUtil.findChildOfType((PsiElement)pyStatement, PyStatementList.class);
            if (pyStatementList == null && (pyStatementList = (PyStatementList)PsiTreeUtil.getParentOfType((PsiElement)pyStatement, PyStatementList.class)) != null) {
                pyStatement = (PyStatement)PsiTreeUtil.getParentOfType((PsiElement)pyStatementList, PyStatement.class);
            }
            if (pyStatement != null) {
                PyStatement pyStatement2;
                int n3;
                int n4 = pyStatement.getTextRange().getStartOffset();
                for (n3 = pyStatement.getTextRange().getEndOffset(); n3 > n4 && psiFile.findElementAt(n3) instanceof PsiWhiteSpace; --n3) {
                }
                if ((n2 == n4 || n2 == n3) && (pyStatement2 = (PyStatement)PsiTreeUtil.getParentOfType((PsiElement)pyStatement, PyStatement.class)) != null) {
                    if (n2 == n4) {
                        return new TextRange(pyStatement2.getTextRange().getStartOffset(), n3);
                    }
                    return new TextRange(n4, pyStatement2.getTextRange().getEndOffset());
                }
                return pyStatement.getTextRange();
            }
        }
        return null;
    }
}

