/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.c;
import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@NonNls
public class PyNames {
    public static final String SITE_PACKAGES = "site-packages";
    public static final String TYPE_INT = "int";
    public static final String TYPE_LONG = "long";
    public static final String TYPE_UNICODE = "unicode";
    public static final String TYPE_STR = "str";
    public static final List<String> TYPE_STRING_TYPES;
    public static final String TYPE_DATE = "datetime.date";
    public static final String TYPE_DATE_TIME = "datetime.datetime";
    public static final String TYPE_TIME = "datetime.time";
    public static final String TYPE_BYTES = "bytes";
    public static final String TYPE_BYTEARRAY = "bytearray";
    public static final String TYPE_ENUM = "enum.Enum";
    public static final String INIT = "__init__";
    public static final String DUNDER_DICT = "__dict__";
    public static final String DOT_PY = ".py";
    public static final String DOT_PYI = ".pyi";
    public static final String INIT_DOT_PY = "__init__.py";
    public static final String INIT_DOT_PYI = "__init__.pyi";
    public static final String SETUP_DOT_PY = "setup.py";
    public static final String NEW = "__new__";
    public static final String GETATTR = "__getattr__";
    public static final String GETATTRIBUTE = "__getattribute__";
    public static final String GET = "__get__";
    public static final String __CLASS__ = "__class__";
    public static final String DUNDER_METACLASS = "__metaclass__";
    public static final String METACLASS = "metaclass";
    public static final String TYPE = "type";
    public static final String SUPER = "super";
    public static final String OBJECT = "object";
    public static final String NONE = "None";
    public static final String TRUE = "True";
    public static final String FALSE = "False";
    public static final String ELLIPSIS = "...";
    public static final String FUNCTION = "function";
    public static final String TYPES_FUNCTION_TYPE = "types.FunctionType";
    public static final String TYPES_METHOD_TYPE = "types.UnboundMethodType";
    public static final String FUTURE_MODULE = "__future__";
    public static final String UNICODE_LITERALS = "unicode_literals";
    public static final String CLASSMETHOD = "classmethod";
    public static final String STATICMETHOD = "staticmethod";
    public static final String OVERLOAD = "overload";
    public static final String PROPERTY = "property";
    public static final String SETTER = "setter";
    public static final String DELETER = "deleter";
    public static final String GETTER = "getter";
    public static final String ALL = "__all__";
    public static final String SLOTS = "__slots__";
    public static final String DEBUG = "__debug__";
    public static final String ISINSTANCE = "isinstance";
    public static final String ASSERT_IS_INSTANCE = "assertIsInstance";
    public static final String HAS_ATTR = "hasattr";
    public static final String ISSUBCLASS = "issubclass";
    public static final String DOC = "__doc__";
    public static final String DOCFORMAT = "__docformat__";
    public static final String DIRNAME = "dirname";
    public static final String ABSPATH = "abspath";
    public static final String NORMPATH = "normpath";
    public static final String REALPATH = "realpath";
    public static final String JOIN = "join";
    public static final String REPLACE = "replace";
    public static final String FILE = "__file__";
    public static final String PARDIR = "pardir";
    public static final String CURDIR = "curdir";
    public static final String WARN = "warn";
    public static final String DEPRECATION_WARNING = "DeprecationWarning";
    public static final String PENDING_DEPRECATION_WARNING = "PendingDeprecationWarning";
    public static final String CONTAINER = "Container";
    public static final String HASHABLE = "Hashable";
    public static final String ITERABLE = "Iterable";
    public static final String ITERATOR = "Iterator";
    public static final String SIZED = "Sized";
    public static final String CALLABLE = "Callable";
    public static final String SEQUENCE = "Sequence";
    public static final String MAPPING = "Mapping";
    public static final String MUTABLE_MAPPING = "MutableMapping";
    public static final String ABC_SET = "Set";
    public static final String ABC_MUTABLE_SET = "MutableSet";
    public static final String PATH_LIKE = "PathLike";
    public static final String AWAITABLE = "Awaitable";
    public static final String ASYNC_ITERABLE = "AsyncIterable";
    public static final String ABC_NUMBER = "Number";
    public static final String ABC_COMPLEX = "Complex";
    public static final String ABC_REAL = "Real";
    public static final String ABC_RATIONAL = "Rational";
    public static final String ABC_INTEGRAL = "Integral";
    public static final String CONTAINS = "__contains__";
    public static final String HASH = "__hash__";
    public static final String ITER = "__iter__";
    public static final String NEXT = "next";
    public static final String DUNDER_NEXT = "__next__";
    public static final String LEN = "__len__";
    public static final String CALL = "__call__";
    public static final String GETITEM = "__getitem__";
    public static final String SETITEM = "__setitem__";
    public static final String DELITEM = "__delitem__";
    public static final String POS = "__pos__";
    public static final String NEG = "__neg__";
    public static final String DIV = "__div__";
    public static final String TRUEDIV = "__truediv__";
    public static final String AITER = "__aiter__";
    public static final String ANEXT = "__anext__";
    public static final String AENTER = "__aenter__";
    public static final String AEXIT = "__aexit__";
    public static final String DUNDER_AWAIT = "__await__";
    public static final String SIZEOF = "__sizeof__";
    public static final String INIT_SUBCLASS = "__init_subclass__";
    public static final String FSPATH = "__fspath__";
    public static final String COMPLEX = "__complex__";
    public static final String FLOAT = "__float__";
    public static final String INT = "__int__";
    public static final String BYTES = "__bytes__";
    public static final String ABS = "__abs__";
    public static final String ROUND = "__round__";
    public static final String CLASS_GETITEM = "__class_getitem__";
    public static final String PREPARE = "__prepare__";
    public static final String NAME = "__name__";
    public static final String ENTER = "__enter__";
    public static final String EXIT = "__exit__";
    public static final String CALLABLE_BUILTIN = "callable";
    public static final String NAMEDTUPLE = "namedtuple";
    public static final String COLLECTIONS = "collections";
    public static final String COLLECTIONS_NAMEDTUPLE_PY2 = "collections.namedtuple";
    public static final String COLLECTIONS_NAMEDTUPLE_PY3 = "collections.__init__.namedtuple";
    public static final String FORMAT = "format";
    public static final String ABSTRACTMETHOD = "abstractmethod";
    public static final String ABSTRACTPROPERTY = "abstractproperty";
    public static final String ABC_META_CLASS = "ABCMeta";
    public static final String ABC = "abc.ABC";
    public static final String ABC_META = "abc.ABCMeta";
    public static final String TUPLE = "tuple";
    public static final String SET = "set";
    public static final String SLICE = "slice";
    public static final String DICT = "dict";
    public static final String KEYS = "keys";
    public static final String APPEND = "append";
    public static final String EXTEND = "extend";
    public static final String UPDATE = "update";
    public static final String CLEAR = "clear";
    public static final String POP = "pop";
    public static final String POPITEM = "popitem";
    public static final String SETDEFAULT = "setdefault";
    public static final String PASS = "pass";
    public static final String NOSE_TEST = "nose";
    public static final String PY_TEST = "pytest";
    public static final String TRIAL_TEST = "Twisted";
    public static final String TEST_CASE = "TestCase";
    public static final String PYCACHE = "__pycache__";
    public static final String NOT_IMPLEMENTED_ERROR = "NotImplementedError";
    public static final String UNKNOWN_TYPE = "Any";
    public static final String UNNAMED_ELEMENT = "<unnamed>";
    public static final String UNDERSCORE = "_";
    public static final ImmutableSet<String> UNDERSCORED_ATTRIBUTES;
    public static final ImmutableSet<String> COMPARISON_OPERATORS;
    public static final ImmutableSet<String> SUBSCRIPTION_OPERATORS;
    private static final BuiltinDescription h;
    private static final BuiltinDescription a;
    private static final BuiltinDescription b;
    private static final BuiltinDescription f;
    private static final BuiltinDescription c;
    private static final ImmutableMap<String, BuiltinDescription> g;
    public static final ImmutableMap<String, BuiltinDescription> PY2_BUILTIN_METHODS;
    public static final ImmutableMap<String, BuiltinDescription> PY3_BUILTIN_METHODS;
    public static final ImmutableMap<String, BuiltinDescription> PY35_BUILTIN_METHODS;
    public static final ImmutableMap<String, BuiltinDescription> PY36_BUILTIN_METHODS;
    public static final ImmutableMap<String, BuiltinDescription> PY37_BUILTIN_METHODS;
    @NotNull
    private static final ImmutableMap<String, BuiltinDescription> d;
    public static final String CANONICAL_SELF = "self";
    public static final String CANONICAL_CLS = "cls";
    public static final String BASESTRING = "basestring";
    public static final String CLASS = "class";
    public static final String DEF = "def";
    public static final String IF = "if";
    public static final String ELSE = "else";
    public static final String ELIF = "elif";
    public static final String TRY = "try";
    public static final String EXCEPT = "except";
    public static final String FINALLY = "finally";
    public static final String WHILE = "while";
    public static final String FOR = "for";
    public static final String WITH = "with";
    public static final String AS = "as";
    public static final String ASSERT = "assert";
    public static final String DEL = "del";
    public static final String EXEC = "exec";
    public static final String FROM = "from";
    public static final String IMPORT = "import";
    public static final String RAISE = "raise";
    public static final String PRINT = "print";
    public static final String BREAK = "break";
    public static final String CONTINUE = "continue";
    public static final String GLOBAL = "global";
    public static final String RETURN = "return";
    public static final String YIELD = "yield";
    public static final String NONLOCAL = "nonlocal";
    public static final String AND = "and";
    public static final String OR = "or";
    public static final String IS = "is";
    public static final String IN = "in";
    public static final String NOT = "not";
    public static final String LAMBDA = "lambda";
    public static final String ASYNC = "async";
    public static final String AWAIT = "await";
    public static final ImmutableSet<String> KEYWORDS;
    public static final Set<String> BUILTIN_INTERFACES;
    public static final String IDENTIFIER_RE = "\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*";
    private static final Pattern e;
    public static final ImmutableSet<String> FUNCTION_SPECIAL_ATTRIBUTES;
    public static final ImmutableSet<String> LEGACY_FUNCTION_SPECIAL_ATTRIBUTES;
    public static final ImmutableSet<String> PY3_ONLY_FUNCTION_SPECIAL_ATTRIBUTES;
    public static final ImmutableSet<String> METHOD_SPECIAL_ATTRIBUTES;
    public static final ImmutableSet<String> LEGACY_METHOD_SPECIAL_ATTRIBUTES;
    public static final String MRO = "mro";
    private static final long i;

    private PyNames() {
    }

    public static ImmutableMap<String, BuiltinDescription> getBuiltinMethods(LanguageLevel level) {
        if (level.isAtLeast(LanguageLevel.PYTHON37)) {
            return PY37_BUILTIN_METHODS;
        }
        if (level.isAtLeast(LanguageLevel.PYTHON36)) {
            return PY36_BUILTIN_METHODS;
        }
        if (level.isAtLeast(LanguageLevel.PYTHON35)) {
            return PY35_BUILTIN_METHODS;
        }
        if (!level.isPython2()) {
            return PY3_BUILTIN_METHODS;
        }
        return PY2_BUILTIN_METHODS;
    }

    @NotNull
    public static ImmutableMap<String, BuiltinDescription> getModuleBuiltinMethods(@NotNull LanguageLevel level) {
        if (level == null) {
            PyNames.a(0);
        }
        if (level.isAtLeast(LanguageLevel.PYTHON37)) {
            ImmutableMap<String, BuiltinDescription> immutableMap = d;
            if (immutableMap == null) {
                PyNames.a(1);
            }
            return immutableMap;
        }
        ImmutableMap immutableMap = ImmutableMap.of();
        if (immutableMap == null) {
            PyNames.a(2);
        }
        return immutableMap;
    }

    public static boolean isReserved(@NonNls String name) {
        long l2 = i ^ 0x7BDA1DEA091AL;
        return KEYWORDS.contains((Object)name) || NONE.equals(name);
    }

    public static boolean isIdentifier(@NotNull @NonNls String name) {
        if (name == null) {
            PyNames.a(3);
        }
        return !PyNames.isReserved(name) && PyNames.isIdentifierString(name);
    }

    public static boolean isIdentifierString(@NotNull @NonNls String name) {
        if (name == null) {
            PyNames.a(4);
        }
        return e.matcher(name).matches();
    }

    public static boolean isRightOperatorName(@Nullable String name) {
        long l2 = i ^ 0x62C6C3AED06EL;
        if ("__rshift__".equals(name)) {
            return false;
        }
        return name != null && (name.matches("__r[a-z]+__") || CONTAINS.equals(name));
    }

    public static boolean isRightOperatorName(@Nullable String referencedName, @Nullable String calleeName) {
        if (PyNames.isRightOperatorName(calleeName)) {
            return true;
        }
        return referencedName != null && calleeName != null && calleeName.equals(PyNames.a(referencedName));
    }

    @Nullable
    public static String leftToRightOperatorName(@Nullable String name) {
        long l2 = i ^ 0x4CCAB7C33AB6L;
        if (name == null) {
            return null;
        }
        String string = PyNames.a(name);
        if (string != null) {
            return string;
        }
        return name.replaceFirst("__([a-z]+)__", "__r$1__");
    }

    @Nullable
    private static String a(@NotNull String string) {
        long l2 = i ^ 0x3A46FFB09660L;
        if (string == null) {
            PyNames.a(5);
        }
        switch (string) {
            case "__lt__": {
                return "__gt__";
            }
            case "__gt__": {
                return "__lt__";
            }
            case "__ge__": {
                return "__le__";
            }
            case "__le__": {
                return "__ge__";
            }
            case "__eq__": 
            case "__ne__": {
                return string;
            }
        }
        return null;
    }

    static {
        i = com.jetbrains.python.psi.c.a(-4286299180295955556L, 1686092906280204262L, MethodHandles.lookup().lookupClass()).a(177121901415086L);
        long l2 = i ^ 0x5F0CE8AFCB3FL;
        TYPE_STRING_TYPES = ContainerUtil.immutableList((Object[])new String[]{TYPE_UNICODE, TYPE_STR});
        UNDERSCORED_ATTRIBUTES = ImmutableSet.of((Object)ALL, (Object)"__annotations__", (Object)"__author__", (Object)"__bases__", (Object)"__closure__", (Object)"__code__", (Object[])new String[]{"__defaults__", DUNDER_DICT, "__dir__", DOC, DOCFORMAT, FILE, "__func__", "__globals__", "__kwdefaults__", "__members__", DUNDER_METACLASS, "__mod__", "__module__", "__mro__", NAME, "__path__", "__qualname__", "__self__", SLOTS, "__version__"});
        COMPARISON_OPERATORS = ImmutableSet.of((Object)"__eq__", (Object)"__ne__", (Object)"__lt__", (Object)"__le__", (Object)"__gt__", (Object)"__ge__", (Object[])new String[]{"__cmp__", CONTAINS});
        SUBSCRIPTION_OPERATORS = ImmutableSet.of((Object)GETITEM, (Object)SETITEM, (Object)DELITEM);
        h = new BuiltinDescription("(self)");
        a = new BuiltinDescription("(self, other)");
        b = new BuiltinDescription("(self, item)");
        f = new BuiltinDescription("(self, key)");
        c = new BuiltinDescription("(self, exc_type, exc_val, exc_tb)");
        g = ImmutableMap.builder().put((Object)ABS, (Object)h).put((Object)"__add__", (Object)a).put((Object)"__and__", (Object)a).put((Object)CALL, (Object)new BuiltinDescription("(self, *args, **kwargs)")).put((Object)"__ceil__", (Object)h).put((Object)"__cmp__", (Object)a).put((Object)"__coerce__", (Object)a).put((Object)COMPLEX, (Object)h).put((Object)CONTAINS, (Object)b).put((Object)"__copy__", (Object)h).put((Object)"__deepcopy__", (Object)new BuiltinDescription("(self, memodict={})")).put((Object)"__del__", (Object)h).put((Object)"__delete__", (Object)new BuiltinDescription("(self, instance)")).put((Object)"__delattr__", (Object)b).put((Object)DELITEM, (Object)f).put((Object)"__delslice__", (Object)new BuiltinDescription("(self, i, j)")).put((Object)"__divmod__", (Object)a).put((Object)ENTER, (Object)h).put((Object)EXIT, (Object)c).put((Object)"__eq__", (Object)a).put((Object)FLOAT, (Object)h).put((Object)"__floor__", (Object)h).put((Object)"__floordiv__", (Object)a).put((Object)"__ge__", (Object)a).put((Object)GET, (Object)new BuiltinDescription("(self, instance, owner)")).put((Object)GETATTR, (Object)b).put((Object)GETATTRIBUTE, (Object)b).put((Object)"__getinitargs__", (Object)h).put((Object)GETITEM, (Object)b).put((Object)"__getnewargs__", (Object)h).put((Object)"__getstate__", (Object)h).put((Object)"__gt__", (Object)a).put((Object)HASH, (Object)h).put((Object)"__hex__", (Object)h).put((Object)"__iadd__", (Object)a).put((Object)"__iand__", (Object)a).put((Object)"__idiv__", (Object)a).put((Object)"__ifloordiv__", (Object)a).put((Object)"__ilshift__", (Object)a).put((Object)"__imod__", (Object)a).put((Object)"__imul__", (Object)a).put((Object)"__index__", (Object)h).put((Object)INIT, (Object)h).put((Object)INT, (Object)h).put((Object)"__invert__", (Object)h).put((Object)"__ior__", (Object)a).put((Object)"__ipow__", (Object)a).put((Object)"__irshift__", (Object)a).put((Object)"__isub__", (Object)a).put((Object)ITER, (Object)h).put((Object)"__itruediv__", (Object)a).put((Object)"__ixor__", (Object)a).put((Object)"__le__", (Object)a).put((Object)LEN, (Object)h).put((Object)"__long__", (Object)h).put((Object)"__lshift__", (Object)a).put((Object)"__lt__", (Object)a).put((Object)"__missing__", (Object)f).put((Object)"__mod__", (Object)a).put((Object)"__mul__", (Object)a).put((Object)"__ne__", (Object)a).put((Object)NEG, (Object)h).put((Object)NEW, (Object)new BuiltinDescription("(cls, *args, **kwargs)")).put((Object)"__oct__", (Object)h).put((Object)"__or__", (Object)a).put((Object)POS, (Object)h).put((Object)"__pow__", (Object)new BuiltinDescription("(self, power, modulo=None)")).put((Object)"__radd__", (Object)a).put((Object)"__rand__", (Object)a).put((Object)"__rdiv__", (Object)a).put((Object)"__rdivmod__", (Object)a).put((Object)"__reduce__", (Object)h).put((Object)"__reduce_ex__", (Object)new BuiltinDescription("(self, protocol)")).put((Object)"__repr__", (Object)h).put((Object)"__reversed__", (Object)h).put((Object)"__rfloordiv__", (Object)a).put((Object)"__rlshift__", (Object)a).put((Object)"__rmod__", (Object)a).put((Object)"__rmul__", (Object)a).put((Object)"__ror__", (Object)a).put((Object)"__rpow__", (Object)a).put((Object)"__rrshift__", (Object)a).put((Object)"__rshift__", (Object)a).put((Object)"__rsub__", (Object)a).put((Object)"__rtruediv__", (Object)a).put((Object)"__rxor__", (Object)a).put((Object)"__set__", (Object)new BuiltinDescription("(self, instance, value)")).put((Object)"__setattr__", (Object)new BuiltinDescription("(self, key, value)")).put((Object)SETITEM, (Object)new BuiltinDescription("(self, key, value)")).put((Object)"__setslice__", (Object)new BuiltinDescription("(self, i, j, sequence)")).put((Object)"__setstate__", (Object)new BuiltinDescription("(self, state)")).put((Object)SIZEOF, (Object)h).put((Object)"__str__", (Object)h).put((Object)"__sub__", (Object)a).put((Object)TRUEDIV, (Object)a).put((Object)"__trunc__", (Object)h).put((Object)"__unicode__", (Object)h).put((Object)"__xor__", (Object)a).build();
        PY2_BUILTIN_METHODS = ImmutableMap.builder().putAll(g).put((Object)"__nonzero__", (Object)h).put((Object)DIV, (Object)a).put((Object)NEXT, (Object)h).build();
        PY3_BUILTIN_METHODS = ImmutableMap.builder().putAll(g).put((Object)"__bool__", (Object)h).put((Object)BYTES, (Object)h).put((Object)"__format__", (Object)new BuiltinDescription("(self, format_spec)")).put((Object)"__instancecheck__", (Object)new BuiltinDescription("(self, instance)")).put((Object)PREPARE, (Object)new BuiltinDescription("(metacls, name, bases)")).put((Object)ROUND, (Object)new BuiltinDescription("(self, n=None)")).put((Object)"__subclasscheck__", (Object)new BuiltinDescription("(self, subclass)")).put((Object)DUNDER_NEXT, (Object)h).build();
        PY35_BUILTIN_METHODS = ImmutableMap.builder().putAll(PY3_BUILTIN_METHODS).put((Object)"__imatmul__", (Object)a).put((Object)"__matmul__", (Object)a).put((Object)"__rmatmul__", (Object)a).put((Object)DUNDER_AWAIT, (Object)h).put((Object)AENTER, (Object)h).put((Object)AEXIT, (Object)c).put((Object)AITER, (Object)h).put((Object)ANEXT, (Object)h).build();
        PY36_BUILTIN_METHODS = ImmutableMap.builder().putAll(PY35_BUILTIN_METHODS).put((Object)INIT_SUBCLASS, (Object)new BuiltinDescription("(cls, **kwargs)")).put((Object)"__set_name__", (Object)new BuiltinDescription("(self, owner, name)")).put((Object)FSPATH, (Object)h).build();
        PY37_BUILTIN_METHODS = ImmutableMap.builder().putAll(PY36_BUILTIN_METHODS).put((Object)CLASS_GETITEM, (Object)new BuiltinDescription("(cls, item)")).put((Object)"__mro_entries__", (Object)new BuiltinDescription("(self, bases)")).build();
        d = ImmutableMap.builder().put((Object)GETATTR, (Object)new BuiltinDescription("(name)")).put((Object)"__dir__", (Object)new BuiltinDescription("()")).build();
        KEYWORDS = ImmutableSet.of((Object)AND, (Object)DEL, (Object)FROM, (Object)NOT, (Object)WHILE, (Object)AS, (Object[])new String[]{ELIF, GLOBAL, OR, WITH, ASSERT, ELSE, IF, PASS, YIELD, BREAK, EXCEPT, IMPORT, PRINT, CLASS, EXEC, IN, RAISE, CONTINUE, FINALLY, IS, RETURN, DEF, FOR, LAMBDA, TRY});
        BUILTIN_INTERFACES = ImmutableSet.of((Object)CALLABLE, (Object)HASHABLE, (Object)ITERABLE, (Object)ITERATOR, (Object)SIZED, (Object)CONTAINER, (Object[])new String[]{SEQUENCE, MAPPING, ABC_COMPLEX, ABC_REAL, ABC_RATIONAL, ABC_INTEGRAL, ABC_NUMBER});
        e = Pattern.compile(IDENTIFIER_RE);
        FUNCTION_SPECIAL_ATTRIBUTES = ImmutableSet.of((Object)"__defaults__", (Object)"__globals__", (Object)"__closure__", (Object)"__code__", (Object)NAME);
        LEGACY_FUNCTION_SPECIAL_ATTRIBUTES = ImmutableSet.of((Object)"func_defaults", (Object)"func_globals", (Object)"func_closure", (Object)"func_code", (Object)"func_name", (Object)"func_doc", (Object[])new String[]{"func_dict"});
        PY3_ONLY_FUNCTION_SPECIAL_ATTRIBUTES = ImmutableSet.of((Object)"__annotations__", (Object)"__kwdefaults__");
        METHOD_SPECIAL_ATTRIBUTES = ImmutableSet.of((Object)"__func__", (Object)"__self__", (Object)NAME);
        LEGACY_METHOD_SPECIAL_ATTRIBUTES = ImmutableSet.of((Object)"im_func", (Object)"im_self", (Object)"im_class");
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = i ^ 0x65CE9BA35F84L;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 1: 
            case 2: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/PyNames";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/PyNames";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleBuiltinMethods";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getModuleBuiltinMethods";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isIdentifier";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isIdentifierString";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "leftToRightComparisonOperatorName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class BuiltinDescription {
        private final String a;

        public BuiltinDescription(String signature) {
            this.a = signature;
        }

        public String getSignature() {
            return this.a;
        }
    }
}

