/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.django.ui;

import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.util.PathUtil;
import com.jetbrains.django.lang.template.DjangoTemplateFileType;
import com.jetbrains.django.ui.a;
import com.jetbrains.python.PythonStringUtil;
import com.jetbrains.python.psi.c;
import java.lang.invoke.MethodHandles;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DjangoTemplateFileFactory {
    private static final String a;
    private static final long b;

    public abstract boolean isValid(@Nullable String var1);

    public abstract PsiFile doCreateTemplate(@NotNull PsiDirectory var1, @NotNull String var2);

    abstract boolean exists(@NotNull PsiDirectory var1, @NotNull String var2);

    @Nullable
    public PsiFile createTemplate(@NotNull PsiDirectory rootFolder, @NotNull String name) {
        if (rootFolder == null) {
            DjangoTemplateFileFactory.a(0);
        }
        if (name == null) {
            DjangoTemplateFileFactory.a(1);
        }
        return this.doCreateTemplate(rootFolder, name);
    }

    public static DjangoTemplateFileFactory fileNameOnly() {
        return new DjangoTemplateFileNameOnly(null);
    }

    public static DjangoTemplateFileFactory acceptsRelativePath() {
        return new DjangoTemplateFileAcceptsRelativePath(null);
    }

    private static PsiFile a(PsiDirectory psiDirectory, String string) {
        PsiFile psiFile = psiDirectory.findFile(string);
        if (psiFile != null) {
            return psiFile;
        }
        return (PsiFile)WriteAction.compute(() -> psiDirectory.createFile(string));
    }

    static {
        b = c.a(-6639296297335673361L, 7274024624013767947L, MethodHandles.lookup().lookupClass()).a(220240463036369L);
        a = "." + DjangoTemplateFileType.INSTANCE.getDefaultExtension();
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        long l2 = b ^ 0x72D4A9E29B38L;
        Object[] objectArray2 = new Object[3];
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "rootFolder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "name";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/django/ui/DjangoTemplateFileFactory";
        objectArray[2] = "createTemplate";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class DjangoTemplateFileAcceptsRelativePath
    extends DjangoTemplateFileFactory {
        private static final long c = com.jetbrains.python.psi.c.a(456737955427808454L, 7152934022874386624L, MethodHandles.lookup().lookupClass()).a(266263122968999L);

        private DjangoTemplateFileAcceptsRelativePath() {
        }

        @Override
        public boolean isValid(@Nullable String name) {
            if (name == null) {
                return false;
            }
            name = FileUtil.toSystemIndependentName((String)name);
            return PythonStringUtil.isPath(name);
        }

        @Override
        boolean exists(@NotNull PsiDirectory rootFolder, @NotNull String name) {
            VirtualFile virtualFile;
            if (rootFolder == null) {
                DjangoTemplateFileAcceptsRelativePath.b(0);
            }
            if (name == null) {
                DjangoTemplateFileAcceptsRelativePath.b(1);
            }
            return (virtualFile = rootFolder.getVirtualFile()).findFileByRelativePath(name) != null;
        }

        @Override
        public PsiFile doCreateTemplate(@NotNull PsiDirectory rootFolder, @NotNull String name) {
            long l2 = c ^ 0x59971A62CEA3L;
            if (rootFolder == null) {
                DjangoTemplateFileAcceptsRelativePath.b(2);
            }
            if (name == null) {
                DjangoTemplateFileAcceptsRelativePath.b(3);
            }
            name = FileUtil.toSystemIndependentName((String)name);
            List list2 = StringUtil.split((String)name, (String)"/");
            int n2 = 0;
            String string = null;
            boolean bl2 = false;
            for (String string2 : list2) {
                if (n2 < list2.size() - 1) {
                    PsiDirectory psiDirectory = rootFolder.findSubdirectory(string2);
                    if (psiDirectory == null) {
                        if (bl2 || Messages.showOkCancelDialog((String)("Directory '" + string2 + "' doesn't exist in '" + FileUtil.toSystemDependentName((String)rootFolder.getVirtualFile().getPath()) + "'. Would you like to create it?"), (String)("Directory " + string2 + " doesn't exist"), (Icon)Messages.getQuestionIcon()) == 0) {
                            psiDirectory = DjangoTemplateFileAcceptsRelativePath.a(rootFolder, string2);
                            bl2 = true;
                        } else {
                            rootFolder = null;
                            break;
                        }
                    }
                    rootFolder = psiDirectory;
                } else {
                    string = string2;
                }
                ++n2;
            }
            if (rootFolder != null) {
                return DjangoTemplateFileFactory.a(rootFolder, string);
            }
            return null;
        }

        private static PsiDirectory a(@NotNull PsiDirectory psiDirectory, String string) {
            if (psiDirectory == null) {
                DjangoTemplateFileAcceptsRelativePath.b(4);
            }
            return (PsiDirectory)WriteAction.compute(() -> psiDirectory.createSubdirectory(string));
        }

        /* synthetic */ DjangoTemplateFileAcceptsRelativePath(a x0) {
            this();
        }

        private static /* synthetic */ void b(int n2) {
            Object[] objectArray;
            Object[] objectArray2;
            long l2 = c ^ 0x7D047BC4EB5CL;
            Object[] objectArray3 = new Object[3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rootFolder";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/django/ui/DjangoTemplateFileFactory$DjangoTemplateFileAcceptsRelativePath";
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "exists";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "doCreateTemplate";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createSubdirectory";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class DjangoTemplateFileNameOnly
    extends DjangoTemplateFileFactory {
        private static final long c = com.jetbrains.python.psi.c.a(7112255051543317544L, 5731892320949818390L, MethodHandles.lookup().lookupClass()).a(241582550700237L);

        private DjangoTemplateFileNameOnly() {
        }

        @Override
        public boolean isValid(@Nullable String name) {
            return name != null && PathUtil.isValidFileName((String)name);
        }

        @Override
        public PsiFile doCreateTemplate(@NotNull PsiDirectory rootFolder, @NotNull String name) {
            if (rootFolder == null) {
                DjangoTemplateFileNameOnly.b(0);
            }
            if (name == null) {
                DjangoTemplateFileNameOnly.b(1);
            }
            return DjangoTemplateFileFactory.a(rootFolder, name);
        }

        @Override
        boolean exists(@NotNull PsiDirectory rootFolder, @NotNull String name) {
            VirtualFile virtualFile;
            if (rootFolder == null) {
                DjangoTemplateFileNameOnly.b(2);
            }
            if (name == null) {
                DjangoTemplateFileNameOnly.b(3);
            }
            return (virtualFile = rootFolder.getVirtualFile()).findChild(name) != null;
        }

        /* synthetic */ DjangoTemplateFileNameOnly(a x0) {
            this();
        }

        private static /* synthetic */ void b(int n2) {
            Object[] objectArray;
            Object[] objectArray2;
            long l2 = c ^ 0x1A4655B0C1F5L;
            Object[] objectArray3 = new Object[3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rootFolder";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/django/ui/DjangoTemplateFileFactory$DjangoTemplateFileNameOnly";
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "doCreateTemplate";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "exists";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

