/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.django.ref;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceWrapper;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.util.Consumer;
import com.jetbrains.django.lang.template.ref.DjangoTemplateFileReferenceSet;
import com.jetbrains.django.ref.CreateViewQuickFix;
import com.jetbrains.django.ref.DjangoViewItemReference;
import com.jetbrains.django.ref.ViewParameters;
import com.jetbrains.django.ref.c;
import com.jetbrains.django.ui.CreateTemplateDialog;
import com.jetbrains.django.ui.DjangoBundle;
import com.jetbrains.django.ui.DjangoTemplateFileFactory;
import com.jetbrains.django.util.DjangoStringUtil;
import com.jetbrains.python.inspections.PyUnresolvedReferenceQuickFixProvider;
import com.jetbrains.python.templateLanguages.ConfigureTemplateDirectoriesAction;
import com.jetbrains.python.templateLanguages.PyTemplateFileReferenceSet;
import java.lang.invoke.MethodHandles;
import org.jetbrains.annotations.NotNull;

public class DjangoReferenceQuickFixProvider
implements PyUnresolvedReferenceQuickFixProvider {
    @Override
    public void registerQuickFixes(PsiReference reference, Consumer<LocalQuickFix> fixConsumer) {
        FileReferenceSet fileReferenceSet;
        int n2;
        if (reference instanceof DjangoViewItemReference) {
            DjangoReferenceQuickFixProvider.a(ViewParameters.fromElement(reference.getElement()), fixConsumer);
        }
        PsiElement psiElement = reference.getElement();
        FileReference fileReference = null;
        if (reference instanceof FileReference) {
            fileReference = (FileReference)reference;
        } else if (reference instanceof PsiReferenceWrapper && ((PsiReferenceWrapper)reference).isInstance(FileReference.class)) {
            fileReference = (FileReference)((PsiReferenceWrapper)reference).cast(FileReference.class);
        }
        if (fileReference != null && (fileReference.getFileReferenceSet() instanceof DjangoTemplateFileReferenceSet || fileReference.getFileReferenceSet() instanceof PyTemplateFileReferenceSet) && (n2 = (fileReferenceSet = fileReference.getFileReferenceSet()).getAllReferences().length) != 0 && fileReference.getIndex() == n2 - 1) {
            fixConsumer.consume((Object)new CreateTemplateIntentionAction(DjangoStringUtil.getStringValue(psiElement), null));
            fixConsumer.consume((Object)new ConfigureTemplateDirectoriesAction());
        }
    }

    private static void a(ViewParameters viewParameters, Consumer<LocalQuickFix> consumer) {
        if (viewParameters.getViewsFile() != null) {
            consumer.consume((Object)new CreateViewQuickFix(viewParameters));
        }
    }

    public static class CreateTemplateIntentionAction
    implements LocalQuickFix {
        private final String a;
        private static final long b = com.jetbrains.python.psi.c.a(-1511809195794574789L, 3723670921937527064L, MethodHandles.lookup().lookupClass()).a(91410396335924L);

        private CreateTemplateIntentionAction(String templateName) {
            this.a = templateName;
        }

        @NotNull
        public String getName() {
            long l2 = b ^ 0x4582E7347BDL;
            String string = "Create template " + this.a;
            if (string == null) {
                CreateTemplateIntentionAction.a(0);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            long l2 = b ^ 0x54157737C9A8L;
            if ("Create template" == null) {
                CreateTemplateIntentionAction.a(1);
            }
            return "Create template";
        }

        public boolean startInWriteAction() {
            return false;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            long l2 = b ^ 0x4C783425AEC8L;
            if (project == null) {
                CreateTemplateIntentionAction.a(2);
            }
            if (descriptor2 == null) {
                CreateTemplateIntentionAction.a(3);
            }
            CreateTemplateDialog createTemplateDialog = new CreateTemplateDialog(project, descriptor2.getPsiElement());
            createTemplateDialog.setShowCreateTemplateCheckBox(false);
            createTemplateDialog.setTemplateName(this.a);
            createTemplateDialog.setTemplateNameEditable(false);
            createTemplateDialog.show();
            if (createTemplateDialog.getExitCode() != 0) {
                return;
            }
            DjangoTemplateFileFactory djangoTemplateFileFactory = createTemplateDialog.getTemplateFileFactory();
            if (createTemplateDialog.isCreateTemplate() && !djangoTemplateFileFactory.isValid(createTemplateDialog.getTemplateName())) {
                Messages.showErrorDialog((String)DjangoBundle.message("template-name-error", new Object[0]), (String)"");
                return;
            }
            try {
                CreateTemplateIntentionAction.create(project, djangoTemplateFileFactory, PsiManager.getInstance((Project)project).findDirectory(createTemplateDialog.getSelectedTemplateRoot()), createTemplateDialog.getTemplateName());
            }
            catch (Exception exception) {
                CreateTemplateIntentionAction.a(exception.getMessage());
            }
        }

        private static void a(String string) {
            Messages.showErrorDialog((String)string, (String)"");
        }

        public static void create(Project project, DjangoTemplateFileFactory templateFileFactory, PsiDirectory templateFolder, String templateName) {
            long l2 = b ^ 0x4BE33995A29L;
            CommandProcessor.getInstance().executeCommand(project, () -> {
                PsiFile psiFile = templateFileFactory.createTemplate(templateFolder, templateName);
                if (psiFile != null) {
                    psiFile.navigate(true);
                }
            }, "Create template", (Object)templateName, UndoConfirmationPolicy.REQUEST_CONFIRMATION);
        }

        /* synthetic */ CreateTemplateIntentionAction(String x0, c x1) {
            this(x0);
        }

        private static /* synthetic */ void a(int n2) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n3;
            String string;
            long l2 = b ^ 0x276FB771EB17L;
            switch (n2) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n2) {
                default: {
                    n3 = 2;
                    break;
                }
                case 2: 
                case 3: {
                    n3 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/django/ref/DjangoReferenceQuickFixProvider$CreateTemplateIntentionAction";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/django/ref/DjangoReferenceQuickFixProvider$CreateTemplateIntentionAction";
                    break;
                }
            }
            switch (n2) {
                default: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n2) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

