/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.django.lang.template.psi.impl;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiRecursiveVisitor;
import com.intellij.psi.PsiReference;
import com.jetbrains.django.lang.template.DjangoTemplateLanguage;
import com.jetbrains.django.lang.template.DjangoTemplateVisitor;
import com.jetbrains.django.lang.template.psi.impl.DjangoStringLiteralImpl;
import com.jetbrains.django.lang.template.tags.DjangoIncludeExtendsTag;
import java.util.HashSet;
import java.util.Set;

public abstract class DjangoTemplateHierarchyVisitor
extends DjangoTemplateVisitor
implements PsiRecursiveVisitor {
    protected Set<PsiFile> myVisitedFiles = new HashSet<PsiFile>();

    public void visitElement(PsiElement element) {
        element.acceptChildren((PsiElementVisitor)this);
    }

    public void visitFile(PsiFile file) {
        PsiFile psiFile = DjangoTemplateLanguage.getDjangoTemplateFile(file);
        if (psiFile != null) {
            psiFile.acceptChildren((PsiElementVisitor)this);
        }
    }

    @Override
    public void visitIncludeExtendsTag(DjangoIncludeExtendsTag extendsTag) {
        super.visitIncludeExtendsTag(extendsTag);
        if (this.done()) {
            return;
        }
        if (extendsTag.isExtendsTag()) {
            PsiElement psiElement;
            DjangoStringLiteralImpl djangoStringLiteralImpl = extendsTag.getFileReferenceLiteral();
            if (djangoStringLiteralImpl == null) {
                return;
            }
            PsiReference[] psiReferenceArray = djangoStringLiteralImpl.getReferences();
            if (psiReferenceArray.length > 0 && (psiElement = psiReferenceArray[psiReferenceArray.length - 1].resolve()) instanceof PsiFile && !this.myVisitedFiles.contains(psiElement)) {
                PsiFile psiFile = (PsiFile)psiElement;
                this.myVisitedFiles.add(psiFile);
                psiFile.accept((PsiElementVisitor)this);
            }
        }
    }

    protected boolean done() {
        return false;
    }
}

