/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.django.lang.template;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.Processor;
import com.intellij.util.QueryExecutor;
import com.intellij.util.indexing.FileBasedIndex;
import com.jetbrains.django.lang.template.DjangoBlockInheritanceIndex;
import com.jetbrains.django.lang.template.b;
import com.jetbrains.django.lang.template.psi.impl.DjangoBlockNameImpl;
import com.jetbrains.django.lang.template.psi.impl.DjangoTemplateFileImpl;
import com.jetbrains.django.lang.template.psi.impl.DjangoTemplateHierarchyVisitor;
import com.jetbrains.django.lang.template.tags.DjangoBlockTag;
import com.jetbrains.python.psi.c;
import java.lang.invoke.MethodHandles;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class DjangoBlockInheritorsSearchExecutor
implements QueryExecutor<PsiElement, PsiElement> {
    private static final long a = c.a(8577467510931035904L, 8506793798942173713L, MethodHandles.lookup().lookupClass()).a(222279637066955L);

    public boolean execute(@NotNull PsiElement queryParameters, @NotNull Processor<? super PsiElement> consumer) {
        if (queryParameters == null) {
            DjangoBlockInheritorsSearchExecutor.a(0);
        }
        if (consumer == null) {
            DjangoBlockInheritorsSearchExecutor.a(1);
        }
        if (queryParameters instanceof DjangoBlockNameImpl) {
            return DjangoBlockInheritorsSearchExecutor.a((DjangoBlockNameImpl)queryParameters, consumer);
        }
        return true;
    }

    private static boolean a(DjangoBlockNameImpl djangoBlockNameImpl, Processor<? super PsiElement> processor2) {
        ApplicationManager.getApplication().runReadAction(() -> {
            String string = djangoBlockNameImpl.getName();
            Project project = djangoBlockNameImpl.getProject();
            DjangoTemplateFileImpl djangoTemplateFileImpl = (DjangoTemplateFileImpl)djangoBlockNameImpl.getContainingFile();
            if (djangoTemplateFileImpl == null || djangoTemplateFileImpl.getVirtualFile() == null) {
                return;
            }
            HashSet hashSet = Sets.newHashSet((Object[])new VirtualFile[]{djangoTemplateFileImpl.getVirtualFile()});
            HashSet hashSet2 = Sets.newHashSet();
            FileBasedIndex.getInstance().getFilesWithKey(DjangoBlockInheritanceIndex.DJANGO_BLOCK_INHERITANCE_INDEX, (Set)Sets.newHashSet((Object[])new String[]{string}), virtualFile -> {
                PsiFile psiFile;
                Document document;
                if (!virtualFile.equals(djangoTemplateFileImpl.getVirtualFile()) && (document = FileDocumentManager.getInstance().getDocument(virtualFile)) != null && (psiFile = PsiDocumentManager.getInstance((Project)project).getPsiFile(document)) != null) {
                    Visitor visitor2 = new Visitor(string, hashSet, hashSet2, null);
                    psiFile.accept((PsiElementVisitor)visitor2);
                    if (visitor2.isInheritsBase()) {
                        for (DjangoBlockNameImpl djangoBlockNameImpl : visitor2.getBlockNames()) {
                            processor2.process((Object)djangoBlockNameImpl);
                        }
                        hashSet.addAll(visitor2.getVisited());
                    } else {
                        hashSet2.addAll(visitor2.getVisited());
                    }
                }
                return true;
            }, GlobalSearchScope.allScope((Project)project));
        });
        return true;
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        long l2 = a ^ 0x9F88F6AB426L;
        Object[] objectArray2 = new Object[3];
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "queryParameters";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "consumer";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/django/lang/template/DjangoBlockInheritorsSearchExecutor";
        objectArray[2] = "execute";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class Visitor
    extends DjangoTemplateHierarchyVisitor {
        private final List<DjangoBlockNameImpl> c = Lists.newArrayList();
        private final Set<VirtualFile> b = Sets.newHashSet();
        private final Set<VirtualFile> d;
        private final Set<VirtualFile> e;
        private final String f;
        private boolean a = false;

        private Visitor(String name, Set<VirtualFile> inheritBaseFiles, Set<VirtualFile> othersFiles) {
            this.f = name;
            this.d = inheritBaseFiles;
            this.e = othersFiles;
        }

        @Override
        public void visitFile(PsiFile file) {
            VirtualFile virtualFile = file.getVirtualFile();
            if (this.d.contains(virtualFile)) {
                this.a = true;
                return;
            }
            if (this.e.contains(virtualFile)) {
                return;
            }
            this.b.add(virtualFile);
            super.visitFile(file);
        }

        @Override
        public void visitBlockTag(DjangoBlockTag blockTag) {
            DjangoBlockNameImpl djangoBlockNameImpl = blockTag.getBlockNameElement();
            if (djangoBlockNameImpl != null && this.f.equals(djangoBlockNameImpl.getName())) {
                this.c.add(djangoBlockNameImpl);
            }
        }

        public List<DjangoBlockNameImpl> getBlockNames() {
            return this.c;
        }

        public boolean isInheritsBase() {
            return this.a;
        }

        public Set<VirtualFile> getVisited() {
            return this.b;
        }

        /* synthetic */ Visitor(String x0, Set x1, Set x2, b x3) {
            this(x0, x1, x2);
        }
    }
}

