/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cython;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.QualifiedName;
import com.jetbrains.cython.CythonNames;
import com.jetbrains.cython.psi.CythonFile;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.c;
import com.jetbrains.python.psi.resolve.PyQualifiedNameResolveContext;
import com.jetbrains.python.psi.resolve.PyResolveImportUtil;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CythonResolveUtil {
    private static final long a = c.a(-586012927757995400L, -5158464924931387371L, MethodHandles.lookup().lookupClass()).a(177784498096706L);

    private CythonResolveUtil() {
    }

    @Nullable
    public static PsiElement getImportedElement(@Nullable QualifiedName containingQName, @NotNull QualifiedName importedQName, @NotNull PsiElement foothold, EnumSet<CythonFileType> fileTypes, boolean withRoots) {
        boolean bl2;
        long l2 = a ^ 0x4CEC3944CC4CL;
        if (importedQName == null) {
            CythonResolveUtil.a(0);
        }
        if (foothold == null) {
            CythonResolveUtil.a(1);
        }
        boolean bl3 = bl2 = containingQName == null;
        if (bl2) {
            containingQName = importedQName.getComponentCount() > 0 ? QualifiedName.fromComponents((String[])new String[]{(String)importedQName.getComponents().get(0)}) : importedQName;
        }
        if (containingQName.matchesPrefix(QualifiedName.fromComponents((String[])new String[]{"cython"}))) {
            return CythonResolveUtil.a(containingQName, importedQName, foothold, bl2);
        }
        VirtualFile virtualFile = CythonResolveUtil.findCythonFile(CythonResolveUtil.getIncludePath(foothold, withRoots), containingQName, fileTypes);
        if (virtualFile != null) {
            VirtualFile virtualFile2;
            VirtualFile virtualFile3;
            if (CythonResolveUtil.isPackageInit(virtualFile) && (virtualFile3 = CythonResolveUtil.findCythonFile(Collections.singletonList(virtualFile2 = virtualFile.getParent()), importedQName, fileTypes)) != null) {
                if (CythonResolveUtil.a(virtualFile3)) {
                    return null;
                }
                return foothold.getManager().findFile(virtualFile3);
            }
            if (CythonResolveUtil.a(virtualFile)) {
                return null;
            }
            virtualFile2 = foothold.getManager().findFile(virtualFile);
            if (bl2) {
                return virtualFile2;
            }
            if (virtualFile2 instanceof PyFile) {
                return ((PyFile)virtualFile2).getElementNamed(importedQName.toString());
            }
        }
        return null;
    }

    @Nullable
    public static VirtualFile findFile(List<? extends VirtualFile> path, String filename) {
        for (VirtualFile virtualFile : path) {
            VirtualFile virtualFile2 = virtualFile.findFileByRelativePath(filename);
            if (virtualFile2 == null) continue;
            return virtualFile2;
        }
        return null;
    }

    public static List<VirtualFile> getIncludePath(@NotNull PsiElement foothold, boolean withRoots) {
        if (foothold == null) {
            CythonResolveUtil.a(2);
        }
        ArrayList<VirtualFile> arrayList = new ArrayList<VirtualFile>();
        PsiDirectory psiDirectory = foothold.getContainingFile().getParent();
        if (psiDirectory != null) {
            arrayList.add(psiDirectory.getVirtualFile());
        }
        if (withRoots) {
            arrayList.addAll(PyUtil.getSourceRoots(foothold));
            VirtualFile virtualFile = CythonResolveUtil.c(foothold);
            if (virtualFile != null) {
                arrayList.add(virtualFile);
            }
        }
        return arrayList;
    }

    @Nullable
    public static VirtualFile findCythonFile(List<? extends VirtualFile> path, QualifiedName qname, EnumSet<CythonFileType> fileTypes) {
        long l2 = a ^ 0x44B1216DB7ABL;
        String string = StringUtil.join((Collection)qname.getComponents(), (String)"/");
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(String.format("%s/%s", string, CythonNames.DEFINITION_PACKAGE_INIT));
        arrayList.add(String.format("%s/%s", string, "__init__.py"));
        if (fileTypes.contains((Object)CythonFileType.REGULAR)) {
            arrayList.add(String.format("%s.pyx", string));
        }
        if (fileTypes.contains((Object)CythonFileType.DEFINITION)) {
            arrayList.add(String.format("%s.pxd", string));
        }
        if (fileTypes.contains((Object)CythonFileType.INCLUDE)) {
            arrayList.add(String.format("%s.pxi", string));
        }
        for (String string2 : arrayList) {
            VirtualFile virtualFile = CythonResolveUtil.findFile(path, string2);
            if (virtualFile == null) continue;
            return virtualFile;
        }
        return null;
    }

    @Nullable
    public static CythonFile findImplicitDefinitionFile(PsiElement foothold) {
        String string;
        long l2 = a ^ 0x52C81C0EB559L;
        PsiFile psiFile = foothold.getContainingFile();
        VirtualFile virtualFile = psiFile.getVirtualFile();
        if (virtualFile != null && "pyx".equals(string = virtualFile.getExtension())) {
            VirtualFile virtualFile2;
            QualifiedName qualifiedName = QualifiedName.fromComponents((String[])new String[]{virtualFile.getNameWithoutExtension()});
            VirtualFile virtualFile3 = virtualFile.getParent();
            if (virtualFile3 != null && (virtualFile2 = CythonResolveUtil.findCythonFile(Collections.singletonList(virtualFile3), qualifiedName, EnumSet.of(CythonFileType.DEFINITION))) != null) {
                return CythonResolveUtil.toCythonFile(foothold.getProject(), virtualFile2);
            }
        }
        return null;
    }

    public static boolean isPackageInit(VirtualFile file) {
        return file.getName().equals(CythonNames.DEFINITION_PACKAGE_INIT) || CythonResolveUtil.a(file);
    }

    private static boolean a(@NotNull VirtualFile virtualFile) {
        long l2 = a ^ 0x40F45E730E38L;
        if (virtualFile == null) {
            CythonResolveUtil.a(3);
        }
        return virtualFile.getName().equals("__init__.py");
    }

    @Nullable
    public static CythonFile toCythonFile(Project project, VirtualFile file) {
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
        if (psiFile instanceof CythonFile) {
            return (CythonFile)psiFile;
        }
        return null;
    }

    @Nullable
    private static VirtualFile c(@NotNull PsiElement psiElement) {
        VirtualFile virtualFile;
        VirtualFile virtualFile2;
        long l2 = a ^ 0x501DAA8B49E6L;
        if (psiElement == null) {
            CythonResolveUtil.a(4);
        }
        if ((virtualFile2 = CythonResolveUtil.a(psiElement)) != null && (virtualFile = virtualFile2.findChild("Includes")) != null) {
            return virtualFile;
        }
        return null;
    }

    @Nullable
    private static VirtualFile a(@NotNull PsiElement psiElement) {
        PsiElement psiElement2;
        if (psiElement == null) {
            CythonResolveUtil.a(5);
        }
        if ((psiElement2 = CythonResolveUtil.b(psiElement)) instanceof PsiDirectory) {
            return ((PsiDirectory)psiElement2).getVirtualFile();
        }
        return null;
    }

    @Nullable
    private static PsiElement b(@NotNull PsiElement psiElement) {
        long l2 = a ^ 0x1181C0A1EB26L;
        if (psiElement == null) {
            CythonResolveUtil.a(6);
        }
        PyQualifiedNameResolveContext pyQualifiedNameResolveContext = PyResolveImportUtil.fromFoothold(psiElement).copyWithoutForeign();
        List<PsiElement> list2 = PyResolveImportUtil.resolveQualifiedName(QualifiedName.fromDottedString((String)"Cython"), pyQualifiedNameResolveContext);
        return !list2.isEmpty() ? list2.get(0) : null;
    }

    private static PsiElement a(@Nullable QualifiedName qualifiedName, @NotNull QualifiedName qualifiedName2, @NotNull PsiElement psiElement, boolean bl2) {
        PsiElement psiElement2;
        long l2 = a ^ 0x3E396D5AFDE1L;
        if (qualifiedName2 == null) {
            CythonResolveUtil.a(7);
        }
        if (psiElement == null) {
            CythonResolveUtil.a(8);
        }
        if ((psiElement2 = CythonResolveUtil.b(psiElement)) instanceof PsiDirectory) {
            psiElement2 = PyUtil.getPackageElement((PsiDirectory)psiElement2, psiElement);
        }
        if (psiElement2 instanceof PyFile) {
            PyFile pyFile = (PyFile)psiElement2;
            PsiElement psiElement3 = pyFile.getElementNamed("CythonDotParallel");
            if ("view".equals(qualifiedName2.toString())) {
                return psiElement2;
            }
            if (qualifiedName != null && qualifiedName.matches(new String[]{"cython", "parallel"})) {
                if (psiElement3 instanceof PyClass) {
                    return ((PyClass)psiElement3).findMethodByName(qualifiedName2.toString(), true, null);
                }
                return null;
            }
            if ("parallel".equals(qualifiedName2.toString())) {
                return psiElement3;
            }
            if (bl2) {
                return psiElement2;
            }
            return pyFile.getElementNamed(qualifiedName2.toString());
        }
        return null;
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        long l2 = a ^ 0x46CEE2E7A497L;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importedQName";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "foothold";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cython/CythonResolveUtil";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getImportedElement";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getIncludePath";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isPythonPackageInit";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getStandardIncludePath";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getCythonPackageDirectory";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "resolveCythonPackageWithoutForeign";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "getCythonPackageElement";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static final class CythonFileType
    extends Enum<CythonFileType> {
        public static final /* enum */ CythonFileType REGULAR;
        public static final /* enum */ CythonFileType DEFINITION;
        public static final /* enum */ CythonFileType INCLUDE;
        private static final /* synthetic */ CythonFileType[] a;

        public static CythonFileType[] values() {
            return (CythonFileType[])a.clone();
        }

        public static CythonFileType valueOf(String name) {
            return Enum.valueOf(CythonFileType.class, name);
        }

        static {
            long l2 = c.a(1849839700944463495L, -7963617201469305142L, MethodHandles.lookup().lookupClass()).a(161465448294392L) ^ 0x68684DF907E5L;
            REGULAR = new CythonFileType();
            DEFINITION = new CythonFileType();
            INCLUDE = new CythonFileType();
            a = new CythonFileType[]{REGULAR, DEFINITION, INCLUDE};
        }
    }
}

