/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.appengine;

import com.google.common.collect.Lists;
import com.intellij.execution.ExecutionException;
import com.intellij.facet.ui.FacetEditorValidator;
import com.intellij.facet.ui.FacetValidatorsManager;
import com.intellij.facet.ui.ValidationResult;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.impl.SdkConfigurationUtil;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.appengine.facet.AppEngineFacet;
import com.jetbrains.appengine.facet.AppEngineFacetConfiguration;
import com.jetbrains.appengine.facet.AppEngineFacetType;
import com.jetbrains.appengine.facet.AppEngineNewProjectPanel;
import com.jetbrains.appengine.facet.AppEngineWizardSettingsHolder;
import com.jetbrains.appengine.run.AppEngineServerRunConfigurationType;
import com.jetbrains.appengine.util.AppEngineProjectCreator;
import com.jetbrains.appengine.util.AppEngineUtil;
import com.jetbrains.django.DjangoProjectGenerator;
import com.jetbrains.django.model.DjangoProjectCreatorAndConfigurator;
import com.jetbrains.python.newProject.PyFrameworkProjectGenerator;
import com.jetbrains.python.newProject.PythonProjectGenerator;
import com.jetbrains.python.packaging.PyCondaPackageManagerImpl;
import com.jetbrains.python.packaging.PyPackageManager;
import com.jetbrains.python.packaging.PyRequirementsKt;
import com.jetbrains.python.psi.c;
import com.jetbrains.python.remote.PyProjectSynchronizer;
import com.jetbrains.python.run.PyRunConfigurationFactory;
import com.jetbrains.python.sdk.PythonSdkType;
import com.jetbrains.python.templateLanguages.PyTemplatesUtil;
import com.jetbrains.python.templateLanguages.TemplateLanguagePanel;
import com.jetbrains.python.templateLanguages.TemplatesService;
import icons.PythonUltimateIcons;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.Collections;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AppEngineProjectGenerator
extends PythonProjectGenerator<AppEngineWizardSettingsHolder>
implements PyFrameworkProjectGenerator {
    private AppEngineNewProjectPanel e;
    private static final long f = c.a(350768475581018367L, -4729223664033306309L, MethodHandles.lookup().lookupClass()).a(48658686125678L);

    @NotNull
    @Nls
    public String getName() {
        long l2 = f ^ 0x42C5A5F0D611L;
        if ("Google App Engine" == null) {
            AppEngineProjectGenerator.b(0);
        }
        return "Google App Engine";
    }

    @Override
    public JComponent getSettingsPanel(File baseDir) throws ProcessCanceledException {
        this.e = new AppEngineNewProjectPanel(baseDir.getName());
        this.e.registerValidators(new FacetValidatorsManager(){

            public void registerValidator(FacetEditorValidator validator, JComponent ... componentsToWatch) {
                throw new UnsupportedOperationException();
            }

            public void validate() {
                AppEngineProjectGenerator.this.fireStateChanged();
            }
        });
        return this.e;
    }

    @Override
    public ValidationResult warningValidation(@Nullable Sdk sdk) {
        long l2 = f ^ 0x53B35EADACD2L;
        if (this.e == null) {
            return ValidationResult.OK;
        }
        TemplateLanguagePanel templateLanguagePanel = this.e.getTemplatesPanel();
        if (templateLanguagePanel == null) {
            return super.warningValidation(sdk);
        }
        ValidationResult validationResult = PyTemplatesUtil.checkInstalled(sdk, templateLanguagePanel, "pyramid_");
        return validationResult == null ? super.warningValidation(sdk) : validationResult;
    }

    @Override
    public AppEngineWizardSettingsHolder getProjectSettings() {
        AppEngineWizardSettingsHolder appEngineWizardSettingsHolder = new AppEngineWizardSettingsHolder();
        this.e.saveSettings(appEngineWizardSettingsHolder);
        return appEngineWizardSettingsHolder;
    }

    @Override
    public void configureProject(@NotNull Project project, @NotNull VirtualFile baseDir, @NotNull AppEngineWizardSettingsHolder settings, @NotNull Module module2, @Nullable PyProjectSynchronizer synchronizer) {
        if (project == null) {
            AppEngineProjectGenerator.b(1);
        }
        if (baseDir == null) {
            AppEngineProjectGenerator.b(2);
        }
        if (settings == null) {
            AppEngineProjectGenerator.b(3);
        }
        if (module2 == null) {
            AppEngineProjectGenerator.b(4);
        }
        ApplicationManager.getApplication().runWriteAction(() -> {
            long l2 = f ^ 0x77FFE7301564L;
            try {
                SdkConfigurationUtil.setDirectoryProjectSdk((Project)project, (Sdk)settings.getSdk());
                AppEngineProjectCreator.createProject(baseDir, settings);
            }
            catch (IOException iOException) {
                Messages.showErrorDialog((Project)project, (String)("Error creating Google App Engine application: " + iOException.getMessage()), (String)"Create App Engine Application");
            }
        });
        AppEngineProjectGenerator.a(project, baseDir, settings, module2);
        StartupManager.getInstance((Project)project).runWhenProjectIsInitialized(() -> {
            long l2 = f ^ 0x3DB456308839L;
            AppEngineProjectGenerator.a(module2, settings, baseDir.getPath());
            AppEngineUtil.initAppEngineModuleLibrary(module2, null, settings.getAppEngineSdkFolder(), baseDir.getPath());
            ApplicationManager.getApplication().runWriteAction(() -> {
                String string;
                if (settings.getProjectName() == null && (string = settings.getTemplatesFolder()) != null) {
                    TemplatesService.getInstance(module2).generateTemplates(settings, baseDir);
                }
            });
            baseDir.getFileSystem().refresh(false);
            DjangoProjectGenerator.openFilesInEditor(project, baseDir, "app.yaml", "main.py");
        });
    }

    private static void a(Project project, VirtualFile virtualFile, final AppEngineWizardSettingsHolder appEngineWizardSettingsHolder, Module module2) {
        long l2 = f ^ 0x7DEE5C277A79L;
        if ("Django".equals(appEngineWizardSettingsHolder.getThirdPartyLib())) {
            ApplicationManager.getApplication().runWriteAction(() -> {
                long l2 = f ^ 0x75D8EEA63413L;
                VirtualFile virtualFile2 = AppEngineUtil.getDjangoBinFolder(appEngineWizardSettingsHolder.getAppEngineSdkFolder());
                if (virtualFile2 == null) {
                    Messages.showErrorDialog((Project)project, (String)"Incorrect or corrupted App Engine SDK: cannot find Django installation", (String)"Create App Engine Application");
                } else {
                    try {
                        DjangoProjectCreatorAndConfigurator.createProject(virtualFile, appEngineWizardSettingsHolder.getSdk(), appEngineWizardSettingsHolder, module2, null);
                    }
                    catch (ExecutionException executionException) {
                        Messages.showErrorDialog((Project)project, (String)("Error creating Django application: " + executionException.getMessage()), (String)"Create App Engine Application");
                    }
                }
            });
        }
        if ("Flask".equals(appEngineWizardSettingsHolder.getThirdPartyLib())) {
            ApplicationManager.getApplication().runWriteAction(() -> {
                long l2 = f ^ 0x3189F81EFAA9L;
                try {
                    VfsUtil.createDirectoryIfMissing((VirtualFile)virtualFile, (String)"lib");
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            });
            final VirtualFile virtualFile2 = virtualFile.findChild("lib");
            if (virtualFile2 == null) {
                return;
            }
            ProgressManager.getInstance().run((Task)new Task.Modal(project, "Installing Flask", false){
                private static final long a = c.a(-1573719618123675315L, -8841740512987267264L, MethodHandles.lookup().lookupClass()).a(125638371959719L);

                public void run(@NotNull ProgressIndicator indicator) {
                    long l2 = a ^ 0x782479451C20L;
                    if (indicator == null) {
                        2.a(0);
                    }
                    indicator.setText("Installing Flask...");
                    Sdk sdk = appEngineWizardSettingsHolder.getSdk();
                    if (sdk == null) {
                        AppEngineProjectGenerator.reportPackageInstallationFailure("Flask", (Pair<Sdk, ExecutionException>)null);
                        return;
                    }
                    PyPackageManager pyPackageManager = PyPackageManager.getInstance(sdk);
                    if (pyPackageManager instanceof PyCondaPackageManagerImpl) {
                        ((PyCondaPackageManagerImpl)pyPackageManager).useConda(false);
                    }
                    try {
                        pyPackageManager.install(Collections.singletonList(PyRequirementsKt.pyRequirement("Flask")), Lists.newArrayList((Object[])new String[]{"-t", virtualFile2.getPath()}));
                        pyPackageManager.refresh();
                        if (pyPackageManager instanceof PyCondaPackageManagerImpl) {
                            ((PyCondaPackageManagerImpl)pyPackageManager).useConda(true);
                        }
                    }
                    catch (ExecutionException executionException) {
                        AppEngineProjectGenerator.reportPackageInstallationFailure("Flask", (Pair<Sdk, ExecutionException>)Pair.create((Object)sdk, (Object)((Object)executionException)));
                    }
                }

                private static /* synthetic */ void a(int n2) {
                    long l2 = a ^ 0x143548DBC3DFL;
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/jetbrains/appengine/AppEngineProjectGenerator$2", "run"));
                }
            });
            AppEngineProjectGenerator.a(project, virtualFile, virtualFile2);
        }
    }

    private static void a(Project project, VirtualFile virtualFile, @NotNull VirtualFile virtualFile2) {
        Module[] moduleArray;
        if (virtualFile2 == null) {
            AppEngineProjectGenerator.b(5);
        }
        if ((moduleArray = ModuleManager.getInstance((Project)project).getModules()).length > 0) {
            ApplicationManager.getApplication().runWriteAction(() -> {
                ContentEntry[] contentEntryArray;
                ModifiableRootModel modifiableRootModel = ModuleRootManager.getInstance((Module)moduleArray[0]).getModifiableModel();
                for (ContentEntry contentEntry : contentEntryArray = modifiableRootModel.getContentEntries()) {
                    if (!Comparing.equal((Object)contentEntry.getFile(), (Object)virtualFile)) continue;
                    contentEntry.addSourceFolder(virtualFile2, false);
                }
                modifiableRootModel.commit();
            });
        }
    }

    @NotNull
    public ValidationResult validate(@NotNull String baseDirPath) {
        if (baseDirPath == null) {
            AppEngineProjectGenerator.b(6);
        }
        ValidationResult validationResult = this.e != null ? this.e.getAppEngineWizardSettingsPanel().getValidationResult() : ValidationResult.OK;
        if (validationResult == null) {
            AppEngineProjectGenerator.b(7);
        }
        return validationResult;
    }

    private static void a(Module module2, AppEngineWizardSettingsHolder appEngineWizardSettingsHolder, String string) {
        AppEngineFacet appEngineFacet = AppEngineFacet.getInstance(module2);
        if (appEngineFacet == null) {
            AppEngineFacetConfiguration appEngineFacetConfiguration = AppEngineFacetType.getDefaultConfiguration(module2.getProject());
            appEngineFacetConfiguration.setSdkFolder(appEngineWizardSettingsHolder.getAppEngineSdkFolder());
            appEngineFacetConfiguration.setProjectRoot(string);
            AppEngineFacetType.createAppEngineFacet(module2, appEngineFacetConfiguration);
        }
        PyRunConfigurationFactory.getInstance().createRunConfiguration(module2, AppEngineServerRunConfigurationType.getInstance().getConfigurationFactory());
    }

    @Override
    @NotNull
    public String getFrameworkTitle() {
        long l2 = f ^ 0x7567D6BF5E4L;
        if ("App Engine" == null) {
            AppEngineProjectGenerator.b(8);
        }
        return "App Engine";
    }

    @Override
    public boolean isFrameworkInstalled(@NotNull Sdk sdk) {
        if (sdk == null) {
            AppEngineProjectGenerator.b(9);
        }
        return PythonSdkType.getLanguageLevelForSdk(sdk).isPython2();
    }

    @Override
    public boolean supportsPython3() {
        return false;
    }

    @Nullable
    public Icon getLogo() {
        return PythonUltimateIcons.Appengine.AppEngine;
    }

    @Override
    public void locationChanged(@NotNull String newLocation) {
        if (newLocation == null) {
            AppEngineProjectGenerator.b(10);
        }
        this.e.getAppEngineWizardSettingsPanel().setApplicationId(newLocation);
    }

    private static /* synthetic */ void b(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = f ^ 0x4952DAA6367L;
        switch (n2) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: {
                n3 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/appengine/AppEngineProjectGenerator";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseDir";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lib";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseDirPath";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newLocation";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/appengine/AppEngineProjectGenerator";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "validate";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getFrameworkTitle";
                break;
            }
        }
        switch (n2) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "configureProject";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "markSourceRoot";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "validate";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isFrameworkInstalled";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "locationChanged";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

