/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.plugin.ui;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.template.TemplateContextType;
import com.intellij.codeInsight.template.impl.TemplateEditorUtil;
import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeTooltip;
import com.intellij.ide.IdeTooltipManager;
import com.intellij.lang.Language;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.structuralsearch.MatchOptions;
import com.intellij.structuralsearch.MatchVariableConstraint;
import com.intellij.structuralsearch.PatternContext;
import com.intellij.structuralsearch.SSRBundle;
import com.intellij.structuralsearch.StructuralSearchProfile;
import com.intellij.structuralsearch.StructuralSearchUtil;
import com.intellij.structuralsearch.plugin.StructuralReplaceAction;
import com.intellij.structuralsearch.plugin.StructuralSearchAction;
import com.intellij.structuralsearch.plugin.ui.Configuration;
import com.intellij.structuralsearch.plugin.ui.SearchConfiguration;
import com.intellij.structuralsearch.plugin.ui.SearchContext;
import com.intellij.structuralsearch.plugin.ui.SubstitutionShortInfoHandler;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.TooltipWithClickableLinks;
import com.intellij.util.LocalTimeCounter;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.psi.c;
import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.lang.invoke.MethodHandles;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UIUtil {
    private static final String b;
    @NonNls
    private static final String a = "structuralsearchgroup";
    public static final NotificationGroup SSR_NOTIFICATION_GROUP;
    @NonNls
    public static final String TEXT = "TEXT";
    @NonNls
    public static final String TEXT_HIERARCHY = "TEXT HIERARCHY";
    @NonNls
    public static final String REFERENCE = "REFERENCE";
    @NonNls
    public static final String TYPE = "TYPE";
    @NonNls
    public static final String EXPECTED_TYPE = "EXPECTED TYPE";
    @NonNls
    public static final String MINIMUM_ZERO = "MINIMUM ZERO";
    @NonNls
    public static final String MAXIMUM_UNLIMITED = "MAXIMUM UNLIMITED";
    private static final long c;

    private UIUtil() {
    }

    @NotNull
    public static Editor createEditor(Document doc, Project project, boolean editable, @Nullable TemplateContextType contextType) {
        Editor editor2 = UIUtil.createEditor(doc, project, editable, false, contextType);
        if (editor2 == null) {
            UIUtil.a(0);
        }
        return editor2;
    }

    @NotNull
    public static Editor createEditor(@NotNull Document doc, Project project, boolean editable, boolean addToolTipForVariableHandler, @Nullable TemplateContextType contextType) {
        if (doc == null) {
            UIUtil.a(1);
        }
        Editor editor2 = editable ? EditorFactory.getInstance().createEditor(doc, project) : EditorFactory.getInstance().createViewer(doc, project);
        EditorSettings editorSettings = editor2.getSettings();
        editorSettings.setVirtualSpace(false);
        editorSettings.setLineMarkerAreaShown(false);
        editorSettings.setIndentGuidesShown(false);
        editorSettings.setLineNumbersShown(false);
        editorSettings.setFoldingOutlineShown(false);
        editorSettings.setCaretRowShown(false);
        if (!editable) {
            EditorColorsScheme editorColorsScheme = EditorColorsManager.getInstance().getGlobalScheme();
            Color color = editorColorsScheme.getColor(EditorColors.READONLY_BACKGROUND_COLOR);
            if (color == null) {
                color = editorColorsScheme.getDefaultBackground();
            }
            ((EditorEx)editor2).setBackgroundColor(color);
        } else {
            ((EditorEx)editor2).setEmbeddedIntoDialogWrapper(true);
        }
        TemplateEditorUtil.setHighlighter((Editor)editor2, (TemplateContextType)contextType);
        if (addToolTipForVariableHandler) {
            SubstitutionShortInfoHandler.install(editor2, null);
        }
        Editor editor3 = editor2;
        if (editor3 == null) {
            UIUtil.a(2);
        }
        return editor3;
    }

    public static JComponent createOptionLine(JComponent ... options) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        for (int i10 = 0; i10 < options.length; ++i10) {
            if (i10 != 0) {
                jPanel.add(Box.createHorizontalStrut(10));
            }
            jPanel.add(options[i10]);
        }
        jPanel.add(Box.createHorizontalGlue());
        return jPanel;
    }

    public static void setContent(@NotNull Editor editor2, String text2) {
        long l2 = c ^ 0x16A243FDF248L;
        if (editor2 == null) {
            UIUtil.a(3);
        }
        String string = text2 != null ? text2 : "";
        Document document = editor2.getDocument();
        WriteCommandAction.runWriteCommandAction((Project)editor2.getProject(), (String)b, (String)a, () -> document.replaceString(0, document.getTextLength(), (CharSequence)string), (PsiFile[])new PsiFile[0]);
    }

    public static void setContent(@NotNull EditorTextField editor2, String text2) {
        long l2 = c ^ 0x72C60C9BC43FL;
        if (editor2 == null) {
            UIUtil.a(4);
        }
        String string = text2 != null ? text2 : "";
        Document document = editor2.getDocument();
        WriteCommandAction.runWriteCommandAction((Project)editor2.getProject(), (String)b, (String)a, () -> document.replaceString(0, document.getTextLength(), (CharSequence)string), (PsiFile[])new PsiFile[0]);
    }

    public static void invokeAction(Configuration config, SearchContext context) {
        if (config instanceof SearchConfiguration) {
            StructuralSearchAction.triggerAction(config, context);
        } else {
            StructuralReplaceAction.triggerAction(config, context);
        }
    }

    public static MatchVariableConstraint getOrAddVariableConstraint(String varName, Configuration configuration) {
        MatchVariableConstraint matchVariableConstraint = configuration.getMatchOptions().getVariableConstraint(varName);
        if (matchVariableConstraint == null) {
            matchVariableConstraint = new MatchVariableConstraint();
            matchVariableConstraint.setName(varName);
            configuration.getMatchOptions().addVariableConstraint(matchVariableConstraint);
        }
        return matchVariableConstraint;
    }

    public static boolean isTarget(String varName, MatchOptions matchOptions) {
        long l2 = c ^ 0x3FBF7A75E5C9L;
        if ("__context__".equals(varName)) {
            for (String string : matchOptions.getVariableConstraintNames()) {
                if (string.equals("__context__") || !matchOptions.getVariableConstraint(string).isPartOfSearchResults()) continue;
                return false;
            }
            return true;
        }
        MatchVariableConstraint matchVariableConstraint = matchOptions.getVariableConstraint(varName);
        if (matchVariableConstraint == null) {
            return false;
        }
        return matchVariableConstraint.isPartOfSearchResults();
    }

    @NotNull
    public static JComponent createCompleteMatchInfo(Supplier<? extends Configuration> configurationProducer) {
        JComponent jComponent = UIUtil.installCompleteMatchInfo(new JLabel(AllIcons.Actions.ListFiles), configurationProducer, null);
        if (jComponent == null) {
            UIUtil.a(5);
        }
        return jComponent;
    }

    @NotNull
    public static JComponent installCompleteMatchInfo(final JLabel completeMatchInfo, final Supplier<? extends Configuration> configurationProducer, final Consumer<? super String> linkConsumer) {
        completeMatchInfo.putClientProperty(IdeTooltip.TOOLTIP_DISMISS_DELAY_KEY, 20000);
        completeMatchInfo.addMouseListener(new MouseAdapter(){
            private static final long a = com.jetbrains.python.psi.c.a(-8225337337071096395L, -4079569972214047276L, MethodHandles.lookup().lookupClass()).a(245004986766105L);

            @Override
            public void mouseEntered(MouseEvent ignore) {
                long l2 = a ^ 0x51AE1EDFCE79L;
                if (Registry.is((String)"ssr.use.editor.inlays.instead.of.tool.tips") && Registry.is((String)"ssr.use.new.search.dialog")) {
                    return;
                }
                Configuration configuration = (Configuration)configurationProducer.get();
                if (configuration == null) {
                    return;
                }
                MatchOptions matchOptions = configuration.getMatchOptions();
                if (matchOptions.getSearchPattern().isEmpty()) {
                    return;
                }
                MatchVariableConstraint matchVariableConstraint = UIUtil.getOrAddVariableConstraint("__context__", configuration);
                if (UIUtil.isTarget("__context__", matchOptions)) {
                    matchVariableConstraint.setPartOfSearchResults(true);
                }
                String string = StringUtil.escapeXmlEntities((String)SSRBundle.message("complete.match.variable.tooltip.message", SubstitutionShortInfoHandler.getShortParamString(matchVariableConstraint, linkConsumer == null)));
                if (linkConsumer != null && !"__context__".equals(configuration.getCurrentVariableName())) {
                    string = SubstitutionShortInfoHandler.appendLinkText(string, "__context__");
                }
                HyperlinkListener hyperlinkListener = hyperlinkEvent -> {
                    long l2 = a ^ 0x4A534535B307L;
                    if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED && linkConsumer != null) {
                        linkConsumer.accept("__context__");
                        IdeTooltipManager.getInstance().hideCurrentNow(true);
                    }
                };
                TooltipWithClickableLinks tooltipWithClickableLinks = new TooltipWithClickableLinks((JComponent)completeMatchInfo, string, hyperlinkListener);
                Rectangle rectangle = completeMatchInfo.getBounds();
                tooltipWithClickableLinks.setHint(true).setExplicitClose(true).setPreferredPosition(Balloon.Position.below).setPoint(new Point(rectangle.x + rectangle.width / 2, rectangle.y + rectangle.height));
                IdeTooltipManager.getInstance().show((IdeTooltip)tooltipWithClickableLinks, true);
                if (linkConsumer == null) {
                    configuration.setCurrentVariableName("__context__");
                }
            }
        });
        JLabel jLabel = completeMatchInfo;
        if (jLabel == null) {
            UIUtil.a(6);
        }
        return jLabel;
    }

    public static EditorTextField createTextComponent(String text2, Project project) {
        long l2 = c ^ 0x419B70D15B0AL;
        return UIUtil.createEditorComponent(text2, "1.txt", project);
    }

    public static EditorTextField createRegexComponent(String text2, Project project) {
        long l2 = c ^ 0x65E8ADA15421L;
        return UIUtil.createEditorComponent(text2, "1.regexp", project);
    }

    public static EditorTextField createScriptComponent(String text2, Project project) {
        long l2 = c ^ 0x6AB302C08640L;
        return UIUtil.createEditorComponent(text2, "1.groovy", project);
    }

    @NotNull
    public static EditorTextField createEditorComponent(String text2, String fileName, Project project) {
        EditorTextField editorTextField = new EditorTextField(text2, project, UIUtil.a(fileName));
        if (editorTextField == null) {
            UIUtil.a(7);
        }
        return editorTextField;
    }

    private static FileType a(String string) {
        FileType fileType = FileTypeManager.getInstance().getFileTypeByFileName(string);
        if (fileType == FileTypes.UNKNOWN) {
            fileType = FileTypes.PLAIN_TEXT;
        }
        return fileType;
    }

    public static LanguageFileType detectFileType(@NotNull SearchContext searchContext) {
        Language language;
        StructuralSearchProfile structuralSearchProfile;
        if (searchContext == null) {
            UIUtil.a(8);
        }
        PsiFile psiFile = searchContext.getFile();
        PsiElement psiElement = null;
        Editor editor2 = searchContext.getEditor();
        if (editor2 != null && psiFile != null) {
            int n2 = editor2.getCaretModel().getOffset();
            psiElement = InjectedLanguageManager.getInstance((Project)searchContext.getProject()).findInjectedElementAt(psiFile, n2);
            if (psiElement == null) {
                psiElement = psiFile.findElementAt(n2);
            }
            if (psiElement != null) {
                psiElement = psiElement.getParent();
            }
            if (psiElement == null) {
                psiElement = psiFile;
            }
        }
        if (psiElement != null && (structuralSearchProfile = StructuralSearchUtil.getProfileByLanguage(language = psiElement.getLanguage())) != null) {
            LanguageFileType languageFileType = structuralSearchProfile.detectFileType(psiElement);
            return languageFileType != null ? languageFileType : language.getAssociatedFileType();
        }
        return StructuralSearchUtil.getDefaultFileType();
    }

    @NotNull
    public static Document createDocument(@NotNull Project project, @NotNull LanguageFileType fileType, Language dialect, PatternContext patternContext, @NotNull String text2, @NotNull StructuralSearchProfile profile) {
        String string;
        PsiCodeFragment psiCodeFragment;
        long l2 = c ^ 0x3EFC22FAEA8EL;
        if (project == null) {
            UIUtil.a(9);
        }
        if (fileType == null) {
            UIUtil.a(10);
        }
        if (text2 == null) {
            UIUtil.a(11);
        }
        if (profile == null) {
            UIUtil.a(12);
        }
        if ((psiCodeFragment = profile.createCodeFragment(project, text2, string = patternContext == null ? null : patternContext.getId())) == null) {
            psiCodeFragment = UIUtil.a(project, fileType, dialect, text2);
        }
        if (psiCodeFragment != null) {
            Document document = PsiDocumentManager.getInstance((Project)project).getDocument((PsiFile)psiCodeFragment);
            assert (document != null) : "code fragment element should be physical";
            Document document2 = document;
            if (document2 == null) {
                UIUtil.a(13);
            }
            return document2;
        }
        Document document = EditorFactory.getInstance().createDocument((CharSequence)text2);
        if (document == null) {
            UIUtil.a(14);
        }
        return document;
    }

    @NotNull
    public static Editor createEditor(@NotNull Project project, @NotNull LanguageFileType fileType, Language dialect, @NotNull String text2, @NotNull StructuralSearchProfile profile) {
        PsiCodeFragment psiCodeFragment;
        long l2 = c ^ 0x1E7D8B368441L;
        if (project == null) {
            UIUtil.a(15);
        }
        if (fileType == null) {
            UIUtil.a(16);
        }
        if (text2 == null) {
            UIUtil.a(17);
        }
        if (profile == null) {
            UIUtil.a(18);
        }
        if ((psiCodeFragment = profile.createCodeFragment(project, text2, null)) == null) {
            psiCodeFragment = UIUtil.a(project, fileType, dialect, text2);
        }
        if (psiCodeFragment != null) {
            Document document = PsiDocumentManager.getInstance((Project)project).getDocument((PsiFile)psiCodeFragment);
            assert (document != null) : "code fragment element should be physical";
            DaemonCodeAnalyzer.getInstance((Project)project).setHighlightingEnabled((PsiFile)psiCodeFragment, false);
            Editor editor2 = UIUtil.createEditor(document, project, true, true, UIUtil.getTemplateContextType(profile));
            if (editor2 == null) {
                UIUtil.a(19);
            }
            return editor2;
        }
        EditorFactory editorFactory = EditorFactory.getInstance();
        Document document = editorFactory.createDocument((CharSequence)text2);
        EditorEx editorEx = (EditorEx)editorFactory.createEditor(document, project);
        editorEx.getSettings().setFoldingOutlineShown(false);
        EditorEx editorEx2 = editorEx;
        if (editorEx2 == null) {
            UIUtil.a(20);
        }
        return editorEx2;
    }

    private static PsiFile a(@NotNull Project project, @NotNull LanguageFileType languageFileType, Language language, @NotNull String string) {
        long l2 = c ^ 0x490ADD091L;
        if (project == null) {
            UIUtil.a(21);
        }
        if (languageFileType == null) {
            UIUtil.a(22);
        }
        if (string == null) {
            UIUtil.a(23);
        }
        String string2 = "__dummy." + languageFileType.getDefaultExtension();
        PsiFileFactory psiFileFactory = PsiFileFactory.getInstance((Project)project);
        return language == null ? psiFileFactory.createFileFromText(string2, (FileType)languageFileType, (CharSequence)string, LocalTimeCounter.currentTime(), true, true) : psiFileFactory.createFileFromText(string2, language, (CharSequence)string, true, true);
    }

    public static TemplateContextType getTemplateContextType(StructuralSearchProfile profile) {
        Class<? extends TemplateContextType> clazz = profile.getTemplateContextTypeClass();
        return (TemplateContextType)ContainerUtil.findInstance((Object[])TemplateContextType.EP_NAME.getExtensions(), clazz);
    }

    static {
        c = com.jetbrains.python.psi.c.a(-5866857659388634568L, -1892444604332189091L, MethodHandles.lookup().lookupClass()).a(36731043607065L);
        long l2 = c ^ 0x65D828B78DF2L;
        b = SSRBundle.message("modify.editor.content.command.name", new Object[0]);
        SSR_NOTIFICATION_GROUP = new NotificationGroup(SSRBundle.message("structural.search.title", new Object[0]), NotificationDisplayType.STICKY_BALLOON, true, ToolWindowId.FIND);
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = c ^ 0x3C50EECD9D8EL;
        switch (n2) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 22: 
            case 23: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 2;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 22: 
            case 23: {
                n3 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/structuralsearch/plugin/ui/UIUtil";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "doc";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchContext";
                break;
            }
            case 9: 
            case 15: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 10: 
            case 16: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 11: 
            case 17: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 12: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profile";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/structuralsearch/plugin/ui/UIUtil";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createCompleteMatchInfo";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "installCompleteMatchInfo";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditorComponent";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createDocument";
                break;
            }
        }
        switch (n2) {
            default: {
                break;
            }
            case 1: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "createEditor";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setContent";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "detectFileType";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createDocument";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "createFileFragment";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 22: 
            case 23: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

