/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.plugin.ui;

import com.intellij.codeInsight.hint.TooltipController;
import com.intellij.codeInsight.hint.TooltipGroup;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.impl.TemplateImplUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.InlayModel;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseMotionListener;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.structuralsearch.MatchVariableConstraint;
import com.intellij.structuralsearch.NamedScriptableDefinition;
import com.intellij.structuralsearch.ReplacementVariableDefinition;
import com.intellij.structuralsearch.SSRBundle;
import com.intellij.structuralsearch.plugin.replace.ui.ReplaceConfiguration;
import com.intellij.structuralsearch.plugin.ui.Configuration;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.HintHint;
import com.intellij.util.SmartList;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.JBUI;
import com.jetbrains.python.psi.c;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.lang.invoke.MethodHandles;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SubstitutionShortInfoHandler
implements DocumentListener,
EditorMouseMotionListener,
CaretListener {
    private static final Key<SubstitutionShortInfoHandler> g;
    private static final TooltipGroup a;
    private long c;
    private final List<String> e;
    private final Editor d;
    @Nullable
    private final Consumer<? super String> b;
    public static final Key<Configuration> CURRENT_CONFIGURATION_KEY;
    private final Map<String, Inlay<FilterRenderer>> f;
    private static final long h;

    private SubstitutionShortInfoHandler(@NotNull Editor _editor, @Nullable Consumer<? super String> currentVariableCallback) {
        if (_editor == null) {
            SubstitutionShortInfoHandler.a(0);
        }
        this.e = new SmartList();
        this.f = new HashMap<String, Inlay<FilterRenderer>>();
        this.d = _editor;
        this.b = currentVariableCallback;
    }

    public void mouseMoved(@NotNull EditorMouseEvent e10) {
        if (e10 == null) {
            SubstitutionShortInfoHandler.a(1);
        }
        LogicalPosition logicalPosition = this.d.xyToLogicalPosition(e10.getMouseEvent().getPoint());
        this.a(logicalPosition, false);
    }

    private void a(LogicalPosition logicalPosition, boolean bl2) {
        String string;
        long l2 = h ^ 0x284004BC525CL;
        Configuration configuration = (Configuration)this.d.getUserData(CURRENT_CONFIGURATION_KEY);
        if (configuration == null) {
            return;
        }
        Document document = this.d.getDocument();
        int n2 = document.getLineCount();
        if (logicalPosition.line >= n2) {
            return;
        }
        int n3 = document.getLineStartOffset(logicalPosition.line);
        int n4 = document.getLineEndOffset(logicalPosition.line);
        CharSequence charSequence = document.getCharsSequence().subSequence(n3, n4);
        TextRange textRange = TemplateImplUtil.findVariableAtOffset((CharSequence)charSequence, (int)logicalPosition.column);
        if (textRange == null) {
            if (bl2) {
                if (this.b != null) {
                    this.b.accept("__context__");
                }
                configuration.setCurrentVariableName("__context__");
            }
            return;
        }
        String string2 = textRange.subSequence(charSequence).toString();
        NamedScriptableDefinition namedScriptableDefinition = configuration.findVariable(string2);
        boolean bl3 = Registry.is((String)"ssr.use.new.search.dialog");
        String string3 = StringUtil.escapeXmlEntities((String)SubstitutionShortInfoHandler.getShortParamString(namedScriptableDefinition, !bl3));
        if (!this.d.isViewer() && !string2.equals(configuration.getCurrentVariableName()) && bl3) {
            string3 = SubstitutionShortInfoHandler.appendLinkText(string3, string2);
        }
        boolean bl4 = namedScriptableDefinition instanceof ReplacementVariableDefinition || namedScriptableDefinition == null && configuration instanceof ReplaceConfiguration;
        String string4 = string = bl4 ? string2 + "$replacement" : string2;
        if (bl2) {
            if (this.b != null) {
                this.b.accept(string);
            }
            configuration.setCurrentVariableName(string);
        }
        if (!string3.isEmpty()) {
            LogicalPosition logicalPosition2 = new LogicalPosition(logicalPosition.line, textRange.getStartOffset() + (textRange.getEndOffset() - textRange.getStartOffset() >> 1));
            SubstitutionShortInfoHandler.a(this.d, logicalPosition2, string3);
        }
    }

    @NotNull
    static String appendLinkText(String text2, String variableName) {
        long l2 = h ^ 0x3E5D04054B29L;
        String string = ColorUtil.toHtmlColor((Color)JBUI.CurrentTheme.Link.linkColor());
        String string2 = text2 + "<br><a style=\"color:" + string + "\" href=\"#ssr_edit_filters/" + variableName + "\">Edit filters</a>";
        if (string2 == null) {
            SubstitutionShortInfoHandler.a(2);
        }
        return string2;
    }

    private void a() {
        Document document = this.d.getDocument();
        if (this.c != document.getModificationStamp()) {
            this.e.clear();
            this.e.addAll(TemplateImplUtil.parseVariableNames((CharSequence)document.getCharsSequence()));
            this.c = document.getModificationStamp();
            this.updateEditorInlays();
        }
    }

    public void caretPositionChanged(@NotNull CaretEvent e10) {
        if (e10 == null) {
            SubstitutionShortInfoHandler.a(3);
        }
        this.a(e10.getNewPosition(), true);
    }

    public void documentChanged(@NotNull DocumentEvent event) {
        if (event == null) {
            SubstitutionShortInfoHandler.a(4);
        }
        if (event.getOldLength() == event.getNewLength()) {
            return;
        }
        this.a(this.d.getCaretModel().getLogicalPosition(), true);
        this.updateEditorInlays();
    }

    public List<String> getVariables() {
        this.a();
        return this.e;
    }

    @NotNull
    static String getShortParamString(NamedScriptableDefinition namedScriptableDefinition, boolean verbose) {
        Object object;
        long l2 = h ^ 0x23C4D8AF7DC2L;
        if (namedScriptableDefinition == null) {
            String string = verbose ? SSRBundle.message("no.constraints.specified.tooltip.message", new Object[0]) : "";
            if (string == null) {
                SubstitutionShortInfoHandler.a(5);
            }
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (namedScriptableDefinition instanceof MatchVariableConstraint) {
            object = (MatchVariableConstraint)namedScriptableDefinition;
            String string = ((NamedScriptableDefinition)object).getName();
            if (!"__context__".equals(string)) {
                int n2 = ((MatchVariableConstraint)object).getMaxCount();
                int n3 = ((MatchVariableConstraint)object).getMinCount();
                if (verbose || n3 != 1 || n2 != 1) {
                    SubstitutionShortInfoHandler.a(stringBuilder, SSRBundle.message("min.occurs.tooltip.message", n3, n2 == Integer.MAX_VALUE ? "\u221e" : Integer.valueOf(n2)));
                }
            }
            if (((MatchVariableConstraint)object).isPartOfSearchResults() && verbose) {
                SubstitutionShortInfoHandler.a(stringBuilder, SSRBundle.message("target.tooltip.message", new Object[0]));
            }
            if (!((MatchVariableConstraint)object).getRegExp().isEmpty()) {
                SubstitutionShortInfoHandler.a(stringBuilder, SSRBundle.message("text.tooltip.message", ((MatchVariableConstraint)object).isInvertRegExp() ? 1 : 0, ((MatchVariableConstraint)object).getRegExp(), ((MatchVariableConstraint)object).isWholeWordsOnly() ? 1 : 0, ((MatchVariableConstraint)object).isWithinHierarchy() ? 1 : 0));
            } else if (((MatchVariableConstraint)object).isWithinHierarchy()) {
                SubstitutionShortInfoHandler.a(stringBuilder, SSRBundle.message("hierarchy.tooltip.message", new Object[0]));
            }
            if (!StringUtil.isEmpty((String)((MatchVariableConstraint)object).getReferenceConstraint())) {
                String string2 = StringUtil.unquoteString((String)((MatchVariableConstraint)object).getReferenceConstraint());
                SubstitutionShortInfoHandler.a(stringBuilder, SSRBundle.message("reference.target.tooltip.message", ((MatchVariableConstraint)object).isInvertReference() ? 1 : 0, string2));
            }
            if (!((MatchVariableConstraint)object).getNameOfExprType().isEmpty()) {
                SubstitutionShortInfoHandler.a(stringBuilder, SSRBundle.message("exprtype.tooltip.message", ((MatchVariableConstraint)object).isInvertExprType() ? 1 : 0, ((MatchVariableConstraint)object).getNameOfExprType(), ((MatchVariableConstraint)object).isExprTypeWithinHierarchy() ? 1 : 0));
            }
            ((MatchVariableConstraint)object).getNameOfFormalArgType();
            if (!((MatchVariableConstraint)object).getNameOfFormalArgType().isEmpty()) {
                SubstitutionShortInfoHandler.a(stringBuilder, SSRBundle.message("expected.type.tooltip.message", ((MatchVariableConstraint)object).isInvertFormalType() ? 1 : 0, ((MatchVariableConstraint)object).getNameOfFormalArgType(), ((MatchVariableConstraint)object).isFormalArgTypeWithinHierarchy() ? 1 : 0));
            }
            if (StringUtil.isNotEmpty((String)((MatchVariableConstraint)object).getWithinConstraint())) {
                String string3 = StringUtil.unquoteString((String)((MatchVariableConstraint)object).getWithinConstraint());
                SubstitutionShortInfoHandler.a(stringBuilder, SSRBundle.message("within.constraints.tooltip.message", ((MatchVariableConstraint)object).isInvertWithinConstraint() ? 1 : 0, string3));
            }
        }
        if ((object = namedScriptableDefinition.getScriptCodeConstraint()) != null && ((String)object).length() > 2) {
            SubstitutionShortInfoHandler.a(stringBuilder, SSRBundle.message("script.tooltip.message", new Object[0]));
        }
        if (stringBuilder.length() == 0 && verbose) {
            stringBuilder.append(SSRBundle.message("no.constraints.specified.tooltip.message", new Object[0]));
        }
        String string = stringBuilder.toString();
        if (string == null) {
            SubstitutionShortInfoHandler.a(6);
        }
        return string;
    }

    private static void a(StringBuilder stringBuilder, String string) {
        long l2 = h ^ 0x67EB73B93153L;
        if (stringBuilder.length() > 0) {
            stringBuilder.append(", ");
        }
        stringBuilder.append(string);
    }

    private static void a(@NotNull Editor editor2, LogicalPosition logicalPosition, @NotNull String string) {
        long l2 = h ^ 0x296826A78230L;
        if (editor2 == null) {
            SubstitutionShortInfoHandler.a(7);
        }
        if (string == null) {
            SubstitutionShortInfoHandler.a(8);
        }
        if (Registry.is((String)"ssr.use.editor.inlays.instead.of.tool.tips") && Registry.is((String)"ssr.use.new.search.dialog")) {
            return;
        }
        Rectangle rectangle = editor2.getScrollingModel().getVisibleArea();
        Point point = editor2.logicalPositionToXY(logicalPosition);
        point.y += editor2.getLineHeight();
        Point point2 = SwingUtilities.convertPoint(editor2.getContentComponent(), point, editor2.getComponent().getRootPane().getLayeredPane());
        HintHint hintHint = new HintHint(editor2, point).setAwtTooltip(true).setShowImmediately(true);
        TooltipController.getInstance().showTooltip(editor2, point2, string, rectangle.width, false, a, hintHint);
    }

    static SubstitutionShortInfoHandler retrieve(Editor editor2) {
        return editor2 == null ? null : (SubstitutionShortInfoHandler)editor2.getUserData(g);
    }

    static void install(Editor editor2, @Nullable Consumer<? super String> currentVariableCallback) {
        SubstitutionShortInfoHandler substitutionShortInfoHandler = new SubstitutionShortInfoHandler(editor2, currentVariableCallback);
        editor2.addEditorMouseMotionListener((EditorMouseMotionListener)substitutionShortInfoHandler);
        editor2.getDocument().addDocumentListener((DocumentListener)substitutionShortInfoHandler);
        editor2.getCaretModel().addCaretListener((CaretListener)substitutionShortInfoHandler);
        editor2.putUserData(g, (Object)substitutionShortInfoHandler);
    }

    void updateEditorInlays() {
        NamedScriptableDefinition namedScriptableDefinition;
        String string4;
        long l2 = h ^ 0x704B03AF910AL;
        if (!Registry.is((String)"ssr.use.editor.inlays.instead.of.tool.tips") || !Registry.is((String)"ssr.use.new.search.dialog")) {
            return;
        }
        String string2 = this.d.getDocument().getText();
        Template template = TemplateManager.getInstance((Project)this.d.getProject()).createTemplate("", "", string2);
        int n2 = template.getSegmentsCount();
        InlayModel inlayModel = this.d.getInlayModel();
        HashSet<String> hashSet = new HashSet<String>(this.f.keySet());
        Configuration configuration = (Configuration)this.d.getUserData(CURRENT_CONFIGURATION_KEY);
        if (configuration == null) {
            return;
        }
        int n3 = 0;
        for (int i10 = 0; i10 < n2; ++i10) {
            int n4 = template.getSegmentOffset(i10);
            string4 = template.getSegmentName(i10);
            n3 += string4.length() + 2;
            NamedScriptableDefinition namedScriptableDefinition2 = configuration.findVariable(string4);
            String string3 = SubstitutionShortInfoHandler.getShortParamString(namedScriptableDefinition2, false);
            if (string3.isEmpty()) continue;
            Inlay<FilterRenderer> inlay = this.f.get(string4);
            if (inlay == null) {
                this.f.put(string4, (Inlay<FilterRenderer>)inlayModel.addInlineElement(n4 + n3, (EditorCustomElementRenderer)new FilterRenderer(string3)));
                continue;
            }
            FilterRenderer filterRenderer = (FilterRenderer)inlay.getRenderer();
            filterRenderer.setText(string3);
            inlay.updateSize();
            hashSet.remove(string4);
        }
        Inlay<FilterRenderer> inlay = this.f.get("__context__");
        if (inlay == null && !(string4 = SubstitutionShortInfoHandler.getShortParamString(namedScriptableDefinition = configuration.findVariable("__context__"), false)).isEmpty()) {
            this.f.put("__context__", (Inlay<FilterRenderer>)inlayModel.addBlockElement(string2.length() + n3, true, false, 0, (EditorCustomElementRenderer)new FilterRenderer("complete pattern: " + string4)));
        }
        for (String string4 : hashSet) {
            Disposer.dispose((Disposable)((Disposable)this.f.remove(string4)));
        }
    }

    static {
        h = com.jetbrains.python.psi.c.a(2600851163322193728L, -1925590985432805191L, MethodHandles.lookup().lookupClass()).a(23361669894494L);
        long l2 = h ^ 0x2B3EDA5E3252L;
        g = Key.create((String)"sslistener.key");
        a = new TooltipGroup("SS_INFO_TOOLTIP_GROUP", 0);
        CURRENT_CONFIGURATION_KEY = Key.create((String)"SS.CurrentConfiguration");
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = h ^ 0x2E5CF443456EL;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 2: 
            case 5: 
            case 6: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "_editor";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/structuralsearch/plugin/ui/SubstitutionShortInfoHandler";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/structuralsearch/plugin/ui/SubstitutionShortInfoHandler";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "appendLinkText";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortParamString";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "mouseMoved";
                break;
            }
            case 2: 
            case 5: 
            case 6: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "caretPositionChanged";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "documentChanged";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "showTooltip";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class FilterRenderer
    implements EditorCustomElementRenderer {
        private String a;
        private static final long b = com.jetbrains.python.psi.c.a(-451183182436998533L, 3604127617520260396L, MethodHandles.lookup().lookupClass()).a(113356625477668L);

        FilterRenderer(String text2) {
            this.a = text2;
        }

        public void setText(String text2) {
            this.a = text2;
        }

        public int calcWidthInPixels(@NotNull Editor editor2) {
            if (editor2 == null) {
                FilterRenderer.a(0);
            }
            return FilterRenderer.a(editor2).stringWidth(this.a) + 12;
        }

        private static Font a() {
            long l2 = b ^ 0x5D064BD6A60CL;
            return UIManager.getFont("Label.font");
        }

        private static FontMetrics a(Editor editor2) {
            return editor2.getContentComponent().getFontMetrics(FilterRenderer.a());
        }

        public void paint(@NotNull Inlay inlay, @NotNull Graphics g10, @NotNull Rectangle r2, @NotNull TextAttributes textAttributes) {
            Object object;
            Editor editor2;
            TextAttributes textAttributes2;
            if (inlay == null) {
                FilterRenderer.a(1);
            }
            if (g10 == null) {
                FilterRenderer.a(2);
            }
            if (r2 == null) {
                FilterRenderer.a(3);
            }
            if (textAttributes == null) {
                FilterRenderer.a(4);
            }
            if ((textAttributes2 = (editor2 = inlay.getEditor()).getColorsScheme().getAttributes(DefaultLanguageHighlighterColors.INLINE_PARAMETER_HINT)) == null) {
                return;
            }
            FontMetrics fontMetrics = FilterRenderer.a(editor2);
            Color color = textAttributes2.getBackgroundColor();
            if (color != null) {
                object = GraphicsUtil.setupAAPainting((Graphics)g10);
                GraphicsUtil.paintWithAlpha((Graphics)g10, (float)0.55f);
                g10.setColor(color);
                g10.fillRoundRect(r2.x + 2, r2.y, r2.width - 4, r2.height, 8, 8);
                object.restore();
            }
            if ((object = textAttributes2.getForegroundColor()) != null) {
                g10.setColor((Color)object);
                g10.setFont(FilterRenderer.a());
                g10.drawString(this.a, r2.x + 6, r2.y + r2.height - fontMetrics.getDescent());
            }
        }

        private static /* synthetic */ void a(int n2) {
            Object[] objectArray;
            Object[] objectArray2;
            long l2 = b ^ 0x419E6A187F5AL;
            Object[] objectArray3 = new Object[3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "inlay";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "g";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "r";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "textAttributes";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/structuralsearch/plugin/ui/SubstitutionShortInfoHandler$FilterRenderer";
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "calcWidthInPixels";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "paint";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

