/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.plugin.ui;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.codeInsight.template.TemplateBuilder;
import com.intellij.codeInsight.template.TemplateContextType;
import com.intellij.codeInsight.template.impl.TemplateEditorUtil;
import com.intellij.find.FindBundle;
import com.intellij.find.FindInProjectSettings;
import com.intellij.find.FindManager;
import com.intellij.find.FindModel;
import com.intellij.find.FindSettings;
import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.lang.Language;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CompositeShortcutSet;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.impl.ActionToolbarImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.DumbAwareToggleAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.DimensionService;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.structuralsearch.MalformedPatternException;
import com.intellij.structuralsearch.MatchOptions;
import com.intellij.structuralsearch.MatchResult;
import com.intellij.structuralsearch.MatchVariableConstraint;
import com.intellij.structuralsearch.Matcher;
import com.intellij.structuralsearch.NoMatchFoundException;
import com.intellij.structuralsearch.PatternContext;
import com.intellij.structuralsearch.ReplacementVariableDefinition;
import com.intellij.structuralsearch.SSRBundle;
import com.intellij.structuralsearch.StructuralSearchProfile;
import com.intellij.structuralsearch.StructuralSearchTemplateBuilder;
import com.intellij.structuralsearch.StructuralSearchUtil;
import com.intellij.structuralsearch.UnsupportedPatternException;
import com.intellij.structuralsearch.impl.matcher.CompiledPattern;
import com.intellij.structuralsearch.impl.matcher.compiler.PatternCompiler;
import com.intellij.structuralsearch.plugin.StructuralSearchPlugin;
import com.intellij.structuralsearch.plugin.replace.ReplaceOptions;
import com.intellij.structuralsearch.plugin.replace.impl.Replacer;
import com.intellij.structuralsearch.plugin.replace.ui.ReplaceCommand;
import com.intellij.structuralsearch.plugin.replace.ui.ReplaceConfiguration;
import com.intellij.structuralsearch.plugin.ui.Configuration;
import com.intellij.structuralsearch.plugin.ui.ConfigurationManager;
import com.intellij.structuralsearch.plugin.ui.ConfigurationUtil;
import com.intellij.structuralsearch.plugin.ui.FileTypeInfo;
import com.intellij.structuralsearch.plugin.ui.FileTypeSelector;
import com.intellij.structuralsearch.plugin.ui.LinkComboBox;
import com.intellij.structuralsearch.plugin.ui.ScopePanel;
import com.intellij.structuralsearch.plugin.ui.SearchCommand;
import com.intellij.structuralsearch.plugin.ui.SearchConfiguration;
import com.intellij.structuralsearch.plugin.ui.SearchContext;
import com.intellij.structuralsearch.plugin.ui.SelectTemplateDialog;
import com.intellij.structuralsearch.plugin.ui.SubstitutionShortInfoHandler;
import com.intellij.structuralsearch.plugin.ui.UIUtil;
import com.intellij.structuralsearch.plugin.ui.filters.FilterPanel;
import com.intellij.structuralsearch.plugin.util.CollectingMatchResultSink;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.Alarm;
import com.intellij.util.NullableConsumer;
import com.intellij.util.SmartList;
import com.intellij.util.textCompletion.TextCompletionUtil;
import com.intellij.util.ui.TextTransferable;
import com.jetbrains.python.psi.c;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.LayoutStyle;
import javax.swing.ListCellRenderer;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StructuralSearchDialog
extends DialogWrapper {
    @NonNls
    private static final String k = "#com.intellij.structuralsearch.plugin.ui.StructuralSearchDialog";
    @NonNls
    private static final String n = "#com.intellij.structuralsearch.plugin.ui.StructuralReplaceDialog";
    @NonNls
    private static final String h = "structural.search.recursive";
    @NonNls
    private static final String o = "structural.search.match.case";
    @NonNls
    private static final String g = "structural.search.shorten.fqn";
    @NonNls
    private static final String a = "structural.search.reformat";
    @NonNls
    private static final String u = "structural.search.use.static.import";
    @NonNls
    private static final String r = "structural.search.filters.visible";
    public static final Key<StructuralSearchDialog> STRUCTURAL_SEARCH_DIALOG;
    public static final Key<String> STRUCTURAL_SEARCH_PATTERN_CONTEXT_ID;
    public static final String USER_DEFINED;
    private final SearchContext d;
    Editor myEditor;
    boolean myReplace;
    Configuration myConfiguration;
    @NonNls
    LanguageFileType myFileType;
    Language myDialect;
    PatternContext myPatternContext;
    final List<RangeHighlighter> myRangeHighlighters;
    private final Alarm b;
    private boolean p;
    private final boolean i;
    private boolean m;
    JCheckBox myRecursive;
    private JCheckBox j;
    private JCheckBox l;
    private JCheckBox c;
    private JCheckBox e;
    FileTypeSelector myFileTypesComboBox;
    ActionToolbarImpl myOptionsToolbar;
    EditorTextField mySearchCriteriaEdit;
    EditorTextField myReplaceCriteriaEdit;
    OnePixelSplitter mySearchEditorPanel;
    private OnePixelSplitter f;
    FilterPanel myFilterPanel;
    private LinkComboBox s;
    private ScopePanel q;
    private JCheckBox t;
    JComponent myReplacePanel;
    Balloon myBalloon;
    private static final long v;

    public StructuralSearchDialog(SearchContext searchContext, boolean replace) {
        this(searchContext, replace, false);
    }

    public StructuralSearchDialog(@NotNull SearchContext searchContext, boolean replace, boolean editConfigOnly) {
        long l2 = v ^ 0x5B80D595EA67L;
        if (searchContext == null) {
            StructuralSearchDialog.a(0);
        }
        super(searchContext.getProject(), true);
        this.myFileType = StructuralSearchUtil.getDefaultFileType();
        this.myDialect = null;
        this.myPatternContext = null;
        this.myRangeHighlighters = new SmartList();
        this.myBalloon = null;
        if (!editConfigOnly) {
            this.setModal(false);
            this.setOKButtonText(FindBundle.message((String)"find.dialog.find.button", (Object[])new Object[0]));
        }
        this.myReplace = replace;
        this.i = editConfigOnly;
        this.d = searchContext;
        this.myEditor = searchContext.getEditor();
        FileEditorManagerListener fileEditorManagerListener = new FileEditorManagerListener(){
            private static final long a = com.jetbrains.python.psi.c.a(-1914631457027457903L, -5624432120038123196L, MethodHandles.lookup().lookupClass()).a(115030042168560L);

            public void selectionChanged(@NotNull FileEditorManagerEvent event) {
                if (event == null) {
                    1.a(0);
                }
                if (StructuralSearchDialog.this.myRangeHighlighters.isEmpty()) {
                    return;
                }
                StructuralSearchDialog.this.removeMatchHighlights();
                StructuralSearchDialog.this.myEditor = event.getManager().getSelectedTextEditor();
                StructuralSearchDialog.this.addMatchHighlights();
            }

            private static /* synthetic */ void a(int n2) {
                long l2 = a ^ 0x25DC590FE195L;
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/structuralsearch/plugin/ui/StructuralSearchDialog$1", "selectionChanged"));
            }
        };
        searchContext.getProject().getMessageBus().connect(this.getDisposable()).subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)fileEditorManagerListener);
        this.myConfiguration = this.a((Configuration)null);
        this.setTitle(this.getDefaultTitle());
        this.init();
        this.b = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, this.myDisposable);
        ProjectManager.getInstance().addProjectManagerListener(searchContext.getProject(), new ProjectManagerListener(){
            private static final long a = com.jetbrains.python.psi.c.a(-9130532880034951104L, 9215891480345047633L, MethodHandles.lookup().lookupClass()).a(12876079301040L);

            public void projectClosing(@NotNull Project project) {
                if (project == null) {
                    2.a(0);
                }
                StructuralSearchDialog.this.close(1);
            }

            private static /* synthetic */ void a(int n2) {
                long l2 = a ^ 0x26C768F3E227L;
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/structuralsearch/plugin/ui/StructuralSearchDialog$2", "projectClosing"));
            }
        });
    }

    public void setUseLastConfiguration(boolean useLastConfiguration) {
        this.p = useLastConfiguration;
    }

    private EditorTextField i() {
        StructuralSearchProfile structuralSearchProfile = StructuralSearchUtil.getProfileByFileType(this.myFileType);
        assert (structuralSearchProfile != null);
        Document document = UIUtil.createDocument(this.getProject(), this.myFileType, this.myDialect, this.myPatternContext, "", structuralSearchProfile);
        document.putUserData(STRUCTURAL_SEARCH_PATTERN_CONTEXT_ID, (Object)(this.myPatternContext == null ? "" : this.myPatternContext.getId()));
        EditorTextField editorTextField = new EditorTextField(document, this.getProject(), (FileType)this.myFileType, false, false){
            private static final long a = com.jetbrains.python.psi.c.a(5123560871332475478L, 2845149145789497167L, MethodHandles.lookup().lookupClass()).a(75206512470224L);

            protected EditorEx createEditor() {
                EditorEx editorEx = super.createEditor();
                editorEx.setHorizontalScrollbarVisible(true);
                editorEx.setVerticalScrollbarVisible(true);
                StructuralSearchProfile structuralSearchProfile = StructuralSearchUtil.getProfileByFileType(StructuralSearchDialog.this.myFileType);
                assert (structuralSearchProfile != null);
                TemplateEditorUtil.setHighlighter((Editor)editorEx, (TemplateContextType)UIUtil.getTemplateContextType(structuralSearchProfile));
                SubstitutionShortInfoHandler.install((Editor)editorEx, string -> {
                    StructuralSearchDialog.this.myFilterPanel.initFilters(UIUtil.getOrAddVariableConstraint(string, StructuralSearchDialog.this.myConfiguration));
                    if (StructuralSearchDialog.this.isFilterPanelVisible()) {
                        StructuralSearchDialog.this.myConfiguration.setCurrentVariableName((String)string);
                    }
                });
                editorEx.putUserData(SubstitutionShortInfoHandler.CURRENT_CONFIGURATION_KEY, (Object)StructuralSearchDialog.this.myConfiguration);
                if (structuralSearchProfile.highlightProblemsInEditor()) {
                    structuralSearchProfile.setProblemCallback(() -> {
                        long l2 = a ^ 0xF52EA251A8CL;
                        StructuralSearchDialog.this.mySearchCriteriaEdit.putClientProperty((Object)"JComponent.outline", (Object)"error");
                        StructuralSearchDialog.this.mySearchCriteriaEdit.repaint();
                        StructuralSearchDialog.this.getOKAction().setEnabled(false);
                        StructuralSearchDialog.this.removeMatchHighlights();
                    });
                } else {
                    Project project = this.getProject();
                    PsiFile psiFile = PsiDocumentManager.getInstance((Project)project).getPsiFile(this.getDocument());
                    if (psiFile != null) {
                        DaemonCodeAnalyzer.getInstance((Project)project).setHighlightingEnabled(psiFile, false);
                    }
                }
                TextCompletionUtil.installCompletionHint((EditorEx)editorEx);
                editorEx.putUserData(STRUCTURAL_SEARCH_DIALOG, (Object)StructuralSearchDialog.this);
                editorEx.setEmbeddedIntoDialogWrapper(true);
                return editorEx;
            }

            protected void updateBorder(@NotNull EditorEx editor2) {
                if (editor2 == null) {
                    3.a(0);
                }
                this.setupBorder(editor2);
            }

            private static /* synthetic */ void a(int n2) {
                long l2 = a ^ 0x2752579F8CDFL;
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/structuralsearch/plugin/ui/StructuralSearchDialog$3", "updateBorder"));
            }
        };
        EditorColorsScheme editorColorsScheme = EditorColorsManager.getInstance().getGlobalScheme();
        editorTextField.setFont(editorColorsScheme.getFont(EditorFontType.PLAIN));
        editorTextField.setPreferredSize(new Dimension(550, 150));
        editorTextField.setMinimumSize(new Dimension(200, 50));
        editorTextField.addDocumentListener(new DocumentListener(){
            private static final long a = com.jetbrains.python.psi.c.a(1220308978462402592L, -3166848847071239137L, MethodHandles.lookup().lookupClass()).a(271379827366471L);

            public void documentChanged(@NotNull DocumentEvent event) {
                if (event == null) {
                    4.a(0);
                }
                StructuralSearchDialog.this.initiateValidation();
            }

            private static /* synthetic */ void a(int n2) {
                long l2 = a ^ 0x35D65DC60A1EL;
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/structuralsearch/plugin/ui/StructuralSearchDialog$4", "documentChanged"));
            }
        });
        return editorTextField;
    }

    void initiateValidation() {
        if (this.b.isDisposed()) {
            return;
        }
        this.b.cancelAllRequests();
        this.b.addRequest(() -> {
            boolean bl2 = ProgressIndicatorUtils.runInReadActionWithWriteActionPriority(() -> {
                try {
                    CompiledPattern compiledPattern = this.g();
                    JRootPane jRootPane = this.getRootPane();
                    if (jRootPane == null) {
                        return;
                    }
                    this.j();
                    if (compiledPattern != null) {
                        this.addMatchHighlights();
                    }
                    ApplicationManager.getApplication().invokeLater(() -> {
                        this.a(this.myConfiguration.getMatchOptions());
                        this.getOKAction().setEnabled(compiledPattern != null);
                    }, ModalityState.stateForComponent((Component)jRootPane));
                }
                catch (ProcessCanceledException processCanceledException) {
                    throw processCanceledException;
                }
                catch (RuntimeException runtimeException) {
                    Logger.getInstance(StructuralSearchDialog.class).error((Throwable)runtimeException);
                }
            });
            if (!bl2) {
                this.initiateValidation();
            }
        }, 100);
    }

    private void j() {
        MatchOptions matchOptions = this.getConfiguration().getMatchOptions();
        CompiledPattern compiledPattern = PatternCompiler.compilePattern(this.getProject(), matchOptions, false, false);
        ApplicationManager.getApplication().invokeLater(() -> {
            long l2 = v ^ 0x43241551D721L;
            if (compiledPattern != null) {
                SubstitutionShortInfoHandler substitutionShortInfoHandler = SubstitutionShortInfoHandler.retrieve(this.mySearchCriteriaEdit.getEditor());
                if (substitutionShortInfoHandler != null) {
                    substitutionShortInfoHandler.updateEditorInlays();
                }
                this.myFilterPanel.setCompiledPattern(compiledPattern);
            }
            if (!this.myFilterPanel.isInitialized()) {
                this.myFilterPanel.initFilters(UIUtil.getOrAddVariableConstraint("__context__", this.myConfiguration));
            }
            this.myFilterPanel.setValid(compiledPattern != null);
        }, ModalityState.stateForComponent((Component)this.myFilterPanel.getComponent()));
    }

    private Configuration a(Configuration configuration) {
        if (this.myReplace) {
            return configuration == null ? new ReplaceConfiguration(USER_DEFINED, USER_DEFINED) : new ReplaceConfiguration(configuration);
        }
        return configuration == null ? new SearchConfiguration(USER_DEFINED, USER_DEFINED) : new SearchConfiguration(configuration);
    }

    private void d() {
        Object object;
        String string;
        Editor editor2 = this.myEditor;
        if (editor2 != null && (string = (object = editor2.getSelectionModel()).getSelectedText()) != null) {
            if (this.loadConfiguration(string)) {
                return;
            }
            String string2 = string.trim();
            this.a(string2.trim(), this.mySearchCriteriaEdit);
            if (this.myReplace) {
                this.a(string2, this.myReplaceCriteriaEdit);
            }
            this.q.setScopesFromContext();
            ApplicationManager.getApplication().invokeLater(() -> this.e());
            return;
        }
        object = ConfigurationManager.getInstance(this.getProject()).getMostRecentConfiguration();
        if (object != null) {
            this.loadConfiguration((Configuration)object);
        }
    }

    private void a(String string, EditorTextField editorTextField) {
        long l2 = v ^ 0x6EA8167CFD8BL;
        editorTextField.setText(string);
        editorTextField.selectAll();
        Project project = this.getProject();
        Document document = editorTextField.getDocument();
        PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)project);
        psiDocumentManager.commitDocument(document);
        PsiFile psiFile = psiDocumentManager.getPsiFile(document);
        if (psiFile == null) {
            return;
        }
        WriteCommandAction.runWriteCommandAction((Project)project, (String)"Adjust line indent", (String)"Structural Search", () -> CodeStyleManager.getInstance((Project)project).adjustLineIndent(psiFile, new TextRange(0, document.getTextLength())), (PsiFile[])new PsiFile[]{psiFile});
    }

    private void f() {
        if (this.myReplace) {
            new ReplaceCommand(this.myConfiguration, this.d).startSearching();
        } else {
            new SearchCommand(this.myConfiguration, this.d).startSearching();
        }
    }

    @NotNull
    String getDefaultTitle() {
        long l2 = v ^ 0x2CBBA4CEFA9CL;
        String string = this.myReplace ? SSRBundle.message("structural.replace.title", new Object[0]) : SSRBundle.message("structural.search.title", new Object[0]);
        if (string == null) {
            StructuralSearchDialog.a(1);
        }
        return string;
    }

    protected JComponent createCenterPanel() {
        long l2 = v ^ 0x593D642F6576L;
        this.mySearchEditorPanel = new OnePixelSplitter(false, 1.0f);
        this.mySearchEditorPanel.setLackOfSpaceStrategy(Splitter.LackOfSpaceStrategy.HONOR_THE_SECOND_MIN_SIZE);
        this.mySearchEditorPanel.getDivider().setOpaque(false);
        this.mySearchCriteriaEdit = this.i();
        this.mySearchEditorPanel.setFirstComponent((JComponent)this.mySearchCriteriaEdit);
        this.mySearchEditorPanel.add("Center", (Component)this.mySearchCriteriaEdit);
        this.myReplacePanel = this.c();
        this.myReplacePanel.setVisible(this.myReplace);
        this.q = new ScopePanel(this.getProject(), this.myDisposable);
        if (!this.i) {
            this.q.setRecentDirectories(FindInProjectSettings.getInstance((Project)this.getProject()).getRecentDirectories());
            this.q.setScopeConsumer((NullableConsumer<? super SearchScope>)((NullableConsumer)searchScope -> this.initiateValidation()));
        } else {
            this.q.setVisible(false);
        }
        this.myFilterPanel = new FilterPanel(this.getProject(), StructuralSearchUtil.getProfileByFileType(this.myFileType), this.getDisposable());
        this.myFilterPanel.setConstraintChangedCallback(() -> this.initiateValidation());
        this.myFilterPanel.getComponent().setMinimumSize(new Dimension(300, 50));
        this.mySearchEditorPanel.setSecondComponent(this.myFilterPanel.getComponent());
        JLabel jLabel = new JLabel(SSRBundle.message("search.target.label", new Object[0]));
        this.s = new LinkComboBox(SSRBundle.message("complete.match.variable.name", new Object[0]));
        this.s.setItemConsumer((NullableConsumer<? super String>)((NullableConsumer)string -> {
            MatchOptions matchOptions = this.myConfiguration.getMatchOptions();
            for (String string2 : matchOptions.getVariableConstraintNames()) {
                matchOptions.getVariableConstraint(string2).setPartOfSearchResults(string2.equals(string));
            }
            this.initiateValidation();
        }));
        JPanel jPanel = new JPanel(null);
        GroupLayout groupLayout = new GroupLayout(jPanel);
        jPanel.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup().addComponent((Component)this.mySearchEditorPanel).addComponent(this.myReplacePanel).addComponent(this.q).addGroup(groupLayout.createSequentialGroup().addComponent(jLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 5, 5).addComponent((Component)((Object)this.s), -2, -1, -2)));
        groupLayout.setVerticalGroup(groupLayout.createSequentialGroup().addComponent((Component)this.mySearchEditorPanel).addGap(2).addComponent(this.myReplacePanel).addComponent(this.q, -2, -1, -2).addGap(16).addGroup(groupLayout.createParallelGroup().addComponent(jLabel).addComponent((Component)((Object)this.s), -2, -1, -2)));
        return jPanel;
    }

    private JComponent c() {
        long l2 = v ^ 0xFEE7E8F7CBCL;
        JLabel jLabel = new JLabel(SSRBundle.message("replacement.template.label", new Object[0]));
        this.l = new JCheckBox(SSRBundle.message("shorten.fully.qualified.names.checkbox", new Object[0]));
        this.c = new JCheckBox(SSRBundle.message("reformat.checkbox", new Object[0]));
        this.e = new JCheckBox(SSRBundle.message("use.static.import.checkbox", new Object[0]));
        this.myReplaceCriteriaEdit = this.i();
        this.f = new OnePixelSplitter(false, 1.0f);
        this.f.setFirstComponent((JComponent)this.myReplaceCriteriaEdit);
        JPanel jPanel = new JPanel(null);
        GroupLayout groupLayout = new GroupLayout(jPanel);
        jPanel.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup().addGroup(groupLayout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, 28, 28).addComponent(jLabel).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, 20, Integer.MAX_VALUE).addComponent(this.l).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, 15, 15).addComponent(this.c).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, 15, 15).addComponent(this.e)).addComponent((Component)this.f));
        groupLayout.setVerticalGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jLabel).addComponent(this.l).addComponent(this.c).addComponent(this.e)).addComponent((Component)this.f));
        return jPanel;
    }

    @Nullable
    protected JComponent createNorthPanel() {
        Object object;
        long l2 = v ^ 0x96712F0A61AL;
        DefaultActionGroup defaultActionGroup = new DefaultActionGroup(new AnAction[]{new DumbAwareAction("History", null, AllIcons.Actions.SearchWithHistory){
            private static final long a = com.jetbrains.python.psi.c.a(4722446849702767782L, 3604265719677483143L, MethodHandles.lookup().lookupClass()).a(231509194725581L);

            public void actionPerformed(@NotNull AnActionEvent e10) {
                Object object;
                if (e10 == null) {
                    5.a(0);
                }
                if (!((object = e10.getInputEvent().getSource()) instanceof Component)) {
                    return;
                }
                JBPopupFactory.getInstance().createPopupChooserBuilder(ConfigurationManager.getInstance(StructuralSearchDialog.this.getProject()).getHistoryConfigurations()).setRenderer((ListCellRenderer)SimpleListCellRenderer.create((jBLabel, configuration, n2) -> {
                    long l2 = a ^ 0x455C3600A8EL;
                    if (configuration instanceof ReplaceConfiguration) {
                        jBLabel.setIcon(AllIcons.Actions.Replace);
                        jBLabel.setText(StringUtil.shortenTextWithEllipsis((String)StringUtil.collapseWhiteSpace((CharSequence)configuration.getMatchOptions().getSearchPattern()), (int)49, (int)0, (boolean)true) + " \u21d2 " + StringUtil.shortenTextWithEllipsis((String)StringUtil.collapseWhiteSpace((CharSequence)configuration.getReplaceOptions().getReplacement()), (int)49, (int)0, (boolean)true));
                    } else {
                        jBLabel.setIcon(AllIcons.Actions.Find);
                        jBLabel.setText(StringUtil.shortenTextWithEllipsis((String)StringUtil.collapseWhiteSpace((CharSequence)configuration.getMatchOptions().getSearchPattern()), (int)100, (int)0, (boolean)true));
                    }
                })).setItemChosenCallback(configuration -> StructuralSearchDialog.this.loadConfiguration((Configuration)configuration)).setSelectionMode(0).createPopup().showUnderneathOf((Component)object);
            }

            private static /* synthetic */ void a(int n2) {
                long l2 = a ^ 0x585A55AF40A2L;
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/structuralsearch/plugin/ui/StructuralSearchDialog$5", "actionPerformed"));
            }
        }});
        ActionManager actionManager = ActionManager.getInstance();
        ActionToolbarImpl actionToolbarImpl = (ActionToolbarImpl)actionManager.createActionToolbar("EditorToolbar", (ActionGroup)defaultActionGroup, true);
        actionToolbarImpl.setLayoutPolicy(0);
        JLabel jLabel = new JLabel(SSRBundle.message("search.template", new Object[0]));
        UIUtil.installCompleteMatchInfo(jLabel, () -> this.myConfiguration, string -> this.showFilterPanel((String)string));
        this.myRecursive = new JCheckBox(SSRBundle.message("recursive.matching.checkbox", new Object[0]), true);
        this.myRecursive.setVisible(!this.myReplace);
        this.j = new JCheckBox(FindBundle.message((String)"find.popup.case.sensitive", (Object[])new Object[0]), true);
        this.myFileType = UIUtil.detectFileType(this.d);
        this.myDialect = this.myFileType.getLanguage();
        StructuralSearchProfile structuralSearchProfile = StructuralSearchUtil.getProfileByFileType(this.myFileType);
        if (structuralSearchProfile != null && !(object = structuralSearchProfile.getPatternContexts()).isEmpty()) {
            this.myPatternContext = object.get(0);
        }
        this.myFileTypesComboBox = new FileTypeSelector();
        this.myFileTypesComboBox.setMinimumAndPreferredWidth(200);
        this.myFileTypesComboBox.setSelectedItem(this.myFileType, this.myDialect, this.myPatternContext);
        this.myFileTypesComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e10) {
                if (e10.getStateChange() == 1) {
                    FileTypeInfo fileTypeInfo = StructuralSearchDialog.this.myFileTypesComboBox.getSelectedItem();
                    if (fileTypeInfo == null) {
                        return;
                    }
                    StructuralSearchDialog.this.myFileType = fileTypeInfo.getFileType();
                    StructuralSearchDialog.this.myDialect = fileTypeInfo.getDialect();
                    StructuralSearchDialog.this.myPatternContext = fileTypeInfo.getContext();
                    StructuralSearchProfile structuralSearchProfile = StructuralSearchUtil.getProfileByFileType(StructuralSearchDialog.this.myFileType);
                    assert (structuralSearchProfile != null);
                    Document document = UIUtil.createDocument(StructuralSearchDialog.this.getProject(), StructuralSearchDialog.this.myFileType, StructuralSearchDialog.this.myDialect, StructuralSearchDialog.this.myPatternContext, StructuralSearchDialog.this.mySearchCriteriaEdit.getText(), structuralSearchProfile);
                    StructuralSearchDialog.this.mySearchCriteriaEdit.setNewDocumentAndFileType((FileType)StructuralSearchDialog.this.myFileType, document);
                    String string = StructuralSearchDialog.this.myPatternContext == null ? "" : StructuralSearchDialog.this.myPatternContext.getId();
                    document.putUserData(STRUCTURAL_SEARCH_PATTERN_CONTEXT_ID, (Object)string);
                    Document document2 = UIUtil.createDocument(StructuralSearchDialog.this.getProject(), StructuralSearchDialog.this.myFileType, StructuralSearchDialog.this.myDialect, StructuralSearchDialog.this.myPatternContext, StructuralSearchDialog.this.myReplaceCriteriaEdit.getText(), structuralSearchProfile);
                    StructuralSearchDialog.this.myReplaceCriteriaEdit.setNewDocumentAndFileType((FileType)StructuralSearchDialog.this.myFileType, document2);
                    document2.putUserData(STRUCTURAL_SEARCH_PATTERN_CONTEXT_ID, (Object)string);
                    StructuralSearchDialog.this.myFilterPanel.setProfile(structuralSearchProfile);
                    StructuralSearchDialog.this.initiateValidation();
                }
            }
        });
        object = new JLabel(SSRBundle.message("search.dialog.file.type.label", new Object[0]));
        ((JLabel)object).setLabelFor((Component)((Object)this.myFileTypesComboBox));
        DefaultActionGroup defaultActionGroup2 = new DefaultActionGroup(new AnAction[]{new DumbAwareAction(SSRBundle.message("save.template.text.button", new Object[0])){
            private static final long a = com.jetbrains.python.psi.c.a(-2809835447798034660L, 9119777505858776031L, MethodHandles.lookup().lookupClass()).a(69301313505408L);

            public void actionPerformed(@NotNull AnActionEvent e10) {
                if (e10 == null) {
                    7.a(0);
                }
                ConfigurationManager.getInstance(StructuralSearchDialog.this.getProject()).showSaveTemplateAsDialog(StructuralSearchDialog.this.getConfiguration());
            }

            private static /* synthetic */ void a(int n2) {
                long l2 = a ^ 0x6A59F6D12D39L;
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/structuralsearch/plugin/ui/StructuralSearchDialog$7", "actionPerformed"));
            }
        }, new CopyConfigurationAction(this), new PasteConfigurationAction(this), new DumbAwareAction(SSRBundle.message("copy.existing.template.button", new Object[0])){
            private static final long a = com.jetbrains.python.psi.c.a(-7050928757141293744L, -6500041047145802212L, MethodHandles.lookup().lookupClass()).a(5417566718659L);

            public void actionPerformed(@NotNull AnActionEvent e10) {
                SelectTemplateDialog selectTemplateDialog;
                if (e10 == null) {
                    8.a(0);
                }
                if (!(selectTemplateDialog = new SelectTemplateDialog(StructuralSearchDialog.this.getProject(), false, StructuralSearchDialog.this.myReplace)).showAndGet()) {
                    return;
                }
                Configuration[] configurationArray = selectTemplateDialog.getSelectedConfigurations();
                if (configurationArray.length == 1) {
                    StructuralSearchDialog.this.loadConfiguration(configurationArray[0]);
                }
            }

            private static /* synthetic */ void a(int n2) {
                long l2 = a ^ 0x2257401C3C62L;
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/structuralsearch/plugin/ui/StructuralSearchDialog$8", "actionPerformed"));
            }
        }, Separator.getInstance(), new SwitchAction()});
        defaultActionGroup2.setPopup(true);
        defaultActionGroup2.getTemplatePresentation().setIcon(AllIcons.General.GearPlain);
        DumbAwareToggleAction dumbAwareToggleAction = new DumbAwareToggleAction(null, "View variable filters", AllIcons.General.Filter){
            private static final long a = com.jetbrains.python.psi.c.a(1881793641021347222L, 3539385416001950641L, MethodHandles.lookup().lookupClass()).a(197580916657303L);

            public boolean isSelected(@NotNull AnActionEvent e10) {
                if (e10 == null) {
                    9.a(0);
                }
                return StructuralSearchDialog.this.isFilterPanelVisible();
            }

            public void setSelected(@NotNull AnActionEvent e10, boolean state2) {
                if (e10 == null) {
                    9.a(1);
                }
                StructuralSearchDialog.this.setFilterPanelVisible(state2);
            }

            private static /* synthetic */ void a(int n2) {
                Object[] objectArray;
                long l2 = a ^ 0x6D95F8A13D08L;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/intellij/structuralsearch/plugin/ui/StructuralSearchDialog$9";
                switch (n2) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isSelected";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "setSelected";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        DefaultActionGroup defaultActionGroup3 = new DefaultActionGroup(new AnAction[]{dumbAwareToggleAction, defaultActionGroup2});
        this.myOptionsToolbar = (ActionToolbarImpl)actionManager.createActionToolbar("EditorToolbar", (ActionGroup)defaultActionGroup3, true);
        this.myOptionsToolbar.setLayoutPolicy(0);
        this.myOptionsToolbar.setForceMinimumSize(true);
        JPanel jPanel = new JPanel(null);
        GroupLayout groupLayout = new GroupLayout(jPanel);
        jPanel.setLayout(groupLayout);
        groupLayout.setHonorsVisibility(true);
        groupLayout.setHorizontalGroup(groupLayout.createSequentialGroup().addComponent((Component)actionToolbarImpl, -2, -1, -2).addComponent(jLabel).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, 20, Integer.MAX_VALUE).addComponent(this.myRecursive).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, 15, 15).addComponent(this.j).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, 15, 15).addComponent((Component)object).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 5, 5).addComponent((Component)((Object)this.myFileTypesComboBox), 125, -1, -2).addComponent((Component)this.myOptionsToolbar, -2, -1, -2));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent((Component)actionToolbarImpl).addComponent(jLabel).addComponent(this.myRecursive).addComponent(this.j).addComponent((Component)object).addComponent((Component)((Object)this.myFileTypesComboBox)).addComponent((Component)this.myOptionsToolbar));
        return jPanel;
    }

    @Nullable
    protected JPanel createSouthAdditionalPanel() {
        long l2 = v ^ 0x448C9FB64B84L;
        if (this.i) {
            return null;
        }
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(0, 6, 0, 0));
        this.t = new JCheckBox(SSRBundle.message("open.in.new.tab.checkbox", new Object[0]));
        this.t.setSelected(FindSettings.getInstance().isShowResultsInSeparateView());
        jPanel.add((Component)this.t, "East");
        return jPanel;
    }

    Project getProject() {
        return this.d.getProject();
    }

    @Nullable
    public Point getInitialLocation() {
        Cloneable cloneable;
        long l2 = v ^ 0x55C3F20124A2L;
        DimensionService dimensionService = DimensionService.getInstance();
        Dimension dimension = dimensionService.getSize(this.myReplace ? n : k, this.getProject());
        if (dimension != null) {
            this.setSize(dimension.width, this.i ? dimension.height - this.q.getPreferredSize().height : dimension.height);
        } else {
            this.pack();
            cloneable = dimensionService.getSize(this.myReplace ? k : n, this.getProject());
            if (cloneable != null) {
                this.setSize(cloneable.width, this.getSize().height);
            }
        }
        if (this.i) {
            return super.getInitialLocation();
        }
        cloneable = dimensionService.getLocation(k, this.getProject());
        return cloneable == null ? super.getInitialLocation() : cloneable;
    }

    public void show() {
        long l2 = v ^ 0x31BAC742DA7L;
        StructuralSearchPlugin.getInstance(this.getProject()).setDialogVisible(true);
        if (!this.p) {
            this.d();
        }
        PropertiesComponent propertiesComponent = PropertiesComponent.getInstance();
        this.setFilterPanelVisible(propertiesComponent.getBoolean(r, true));
        super.show();
    }

    private void e() {
        long l2 = v ^ 0x425134B5E057L;
        if (!Registry.is((String)"ssr.template.from.selection.builder")) {
            return;
        }
        Document document = this.mySearchCriteriaEdit.getDocument();
        PsiFile psiFile = PsiDocumentManager.getInstance((Project)this.getProject()).getPsiFile(document);
        assert (psiFile != null);
        TemplateBuilder templateBuilder = new StructuralSearchTemplateBuilder(psiFile).buildTemplate();
        WriteCommandAction.runWriteCommandAction((Project)this.getProject(), (String)"Live search template builder", (String)"Structural Search", () -> templateBuilder.run(Objects.requireNonNull(this.mySearchCriteriaEdit.getEditor()), true), (PsiFile[])new PsiFile[0]);
    }

    public JComponent getPreferredFocusedComponent() {
        return this.mySearchCriteriaEdit;
    }

    public void doCancelAction() {
        super.doCancelAction();
        this.removeMatchHighlights();
    }

    protected void doOKAction() {
        FindSettings findSettings;
        long l2 = v ^ 0x15094CA5BD12L;
        this.m = true;
        CompiledPattern compiledPattern = this.g();
        this.m = false;
        if (compiledPattern == null) {
            return;
        }
        this.b.cancelAllRequests();
        this.myConfiguration.removeUnusedVariables();
        super.doOKAction();
        if (this.i) {
            return;
        }
        SearchScope searchScope = this.q.getScope();
        if (searchScope instanceof GlobalSearchScopesCore.DirectoryScope) {
            findSettings = (GlobalSearchScopesCore.DirectoryScope)searchScope;
            FindInProjectSettings.getInstance((Project)this.getProject()).addDirectory(findSettings.getDirectory().getPresentableUrl());
        }
        findSettings = FindSettings.getInstance();
        findSettings.setShowResultsInSeparateView(this.t.isSelected());
        try {
            ConfigurationManager.getInstance(this.getProject()).addHistoryConfiguration(this.myConfiguration);
            this.f();
        }
        catch (MalformedPatternException malformedPatternException) {
            this.reportMessage(SSRBundle.message("this.pattern.is.malformed.message", malformedPatternException.getMessage()), true, (JComponent)this.mySearchCriteriaEdit);
        }
    }

    public Configuration getConfiguration() {
        this.l();
        return this.myConfiguration;
    }

    private CompiledPattern g() {
        long l2 = v ^ 0x7CB6BB17866EL;
        MatchOptions matchOptions = this.getConfiguration().getMatchOptions();
        Project project = this.getProject();
        try {
            CompiledPattern compiledPattern = PatternCompiler.compilePattern(project, matchOptions, true, !this.i);
            this.reportMessage(null, false, (JComponent)this.mySearchCriteriaEdit);
            if (this.myReplace) {
                try {
                    Replacer.checkReplacementPattern(project, this.myConfiguration.getReplaceOptions());
                }
                catch (UnsupportedPatternException unsupportedPatternException) {
                    this.reportMessage(SSRBundle.message("unsupported.replacement.pattern.message", unsupportedPatternException.getMessage()), true, (JComponent)this.myReplaceCriteriaEdit);
                    return null;
                }
                catch (MalformedPatternException malformedPatternException) {
                    if (!malformedPatternException.isErrorElement || !Registry.is((String)"ssr.in.editor.problem.highlighting")) {
                        this.reportMessage(SSRBundle.message("malformed.replacement.pattern.message", malformedPatternException.getMessage()), true, (JComponent)this.myReplaceCriteriaEdit);
                    }
                    return null;
                }
            }
            this.reportMessage(null, false, (JComponent)this.myReplaceCriteriaEdit);
            return compiledPattern;
        }
        catch (MalformedPatternException malformedPatternException) {
            String string;
            this.removeMatchHighlights();
            String string2 = StringUtil.isEmpty((String)matchOptions.getSearchPattern()) ? null : (string = SSRBundle.message("this.pattern.is.malformed.message", malformedPatternException.getMessage() != null ? malformedPatternException.getMessage() : ""));
            if (!malformedPatternException.isErrorElement || !Registry.is((String)"ssr.in.editor.problem.highlighting")) {
                this.reportMessage(string, true, (JComponent)this.mySearchCriteriaEdit);
            }
            return null;
        }
        catch (UnsupportedPatternException unsupportedPatternException) {
            this.removeMatchHighlights();
            this.reportMessage(SSRBundle.message("this.pattern.is.unsupported.message", unsupportedPatternException.getMessage()), true, (JComponent)this.mySearchCriteriaEdit);
            return null;
        }
        catch (NoMatchFoundException noMatchFoundException) {
            this.removeMatchHighlights();
            this.reportMessage(noMatchFoundException.getMessage(), false, this.q);
            return null;
        }
    }

    void removeMatchHighlights() {
        if (this.i) {
            return;
        }
        Editor editor2 = this.myEditor;
        if (editor2 == null) {
            return;
        }
        Project project = this.getProject();
        ApplicationManager.getApplication().invokeLater(() -> {
            HighlightManager highlightManager = HighlightManager.getInstance((Project)project);
            for (RangeHighlighter rangeHighlighter : this.myRangeHighlighters) {
                highlightManager.removeSegmentHighlighter(editor2, rangeHighlighter);
            }
            WindowManager.getInstance().getStatusBar(project).setInfo("");
            this.myRangeHighlighters.clear();
        });
    }

    void addMatchHighlights() {
        long l2 = v ^ 0x6DA3B9EDFCB6L;
        if (this.i) {
            return;
        }
        if (this.m) {
            this.removeMatchHighlights();
        } else {
            Project project = this.getProject();
            Editor editor2 = this.myEditor;
            if (editor2 == null) {
                return;
            }
            Document document = editor2.getDocument();
            PsiFile psiFile = PsiDocumentManager.getInstance((Project)project).getPsiFile(document);
            if (psiFile == null) {
                return;
            }
            MatchOptions matchOptions = this.getConfiguration().getMatchOptions();
            matchOptions.setScope((SearchScope)new LocalSearchScope((PsiElement)psiFile, IdeBundle.message((String)"scope.current.file", (Object[])new Object[0])));
            CollectingMatchResultSink collectingMatchResultSink = new CollectingMatchResultSink();
            new Matcher(project).findMatches(collectingMatchResultSink, matchOptions);
            List<MatchResult> list2 = collectingMatchResultSink.getMatches();
            this.removeMatchHighlights();
            this.a(list2, editor2, psiFile, list2.size() + " results found in current file");
        }
    }

    private void a(@NotNull List<MatchResult> list2, @NotNull Editor editor2, @NotNull PsiFile psiFile, @Nullable String string) {
        if (list2 == null) {
            StructuralSearchDialog.a(2);
        }
        if (editor2 == null) {
            StructuralSearchDialog.a(3);
        }
        if (psiFile == null) {
            StructuralSearchDialog.a(4);
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            long l2 = v ^ 0x2B86A15B6CAFL;
            Project project = this.getProject();
            if (project.isDisposed()) {
                return;
            }
            if (!list2.isEmpty()) {
                MatchResult matchResult2;
                EditorColorsScheme editorColorsScheme = EditorColorsManager.getInstance().getGlobalScheme();
                TextAttributes textAttributes = editorColorsScheme.getAttributes(EditorColors.SEARCH_RESULT_ATTRIBUTES);
                HighlightManager highlightManager = HighlightManager.getInstance((Project)project);
                for (MatchResult matchResult2 : list2) {
                    PsiElement psiElement = matchResult2.getMatch();
                    if (psiElement == null || psiElement.getContainingFile() != psiFile) continue;
                    int n2 = -1;
                    int n3 = -1;
                    if ("__multi_line__".equals(matchResult2.getName())) {
                        for (MatchResult matchResult3 : matchResult2.getChildren()) {
                            int n4;
                            TextRange textRange = matchResult3.getMatch().getTextRange();
                            int n5 = textRange.getStartOffset();
                            if (n2 == -1 || n2 > n5) {
                                n2 = n5;
                            }
                            if (n3 >= (n4 = textRange.getEndOffset())) continue;
                            n3 = n4;
                        }
                    } else {
                        TextRange textRange = psiElement.getTextRange();
                        n2 = textRange.getStartOffset();
                        n3 = textRange.getEndOffset();
                    }
                    highlightManager.addRangeHighlight(editor2, n2, n3, textAttributes, false, this.myRangeHighlighters);
                }
                FindManager findManager = FindManager.getInstance((Project)project);
                matchResult2 = findManager.getFindNextModel();
                if (matchResult2 == null) {
                    matchResult2 = findManager.getFindInFileModel();
                }
                matchResult2.setSearchHighlighters(true);
                findManager.setFindWasPerformed();
                findManager.setFindNextModel((FindModel)matchResult2);
            }
            WindowManager.getInstance().getStatusBar(project).setInfo(string);
        });
    }

    void reportMessage(String message, boolean error, JComponent component) {
        com.intellij.util.ui.UIUtil.invokeLaterIfNeeded(() -> {
            long l2 = v ^ 0xD424C9AD41BL;
            if (this.myBalloon != null) {
                this.myBalloon.hide();
            }
            component.putClientProperty("JComponent.outline", !error || message == null ? null : "error");
            component.repaint();
            if (message == null) {
                return;
            }
            this.myBalloon = JBPopupFactory.getInstance().createHtmlTextBalloonBuilder(message, error ? MessageType.ERROR : MessageType.WARNING, null).setHideOnFrameResize(false).createBalloon();
            if (component != this.q) {
                this.myBalloon.show(new RelativePoint((Component)component, new Point(component.getWidth() / 2, component.getHeight())), Balloon.Position.below);
            } else {
                this.myBalloon.show(new RelativePoint((Component)component, new Point(component.getWidth() / 2, 0)), Balloon.Position.above);
            }
            this.myBalloon.showInCenterOf(component);
            Disposer.register((Disposable)this.myDisposable, (Disposable)this.myBalloon);
        });
    }

    void securityCheck() {
        long l2 = v ^ 0x420C6020BD3DL;
        MatchOptions matchOptions = this.myConfiguration.getMatchOptions();
        int n2 = 0;
        for (String object : matchOptions.getVariableConstraintNames()) {
            MatchVariableConstraint matchVariableConstraint = matchOptions.getVariableConstraint(object);
            if (matchVariableConstraint.getScriptCodeConstraint().length() <= 2) continue;
            ++n2;
        }
        ReplaceOptions replaceOptions = this.myConfiguration.getReplaceOptions();
        if (replaceOptions != null) {
            for (ReplacementVariableDefinition replacementVariableDefinition : replaceOptions.getVariableDefinitions()) {
                if (replacementVariableDefinition.getScriptCodeConstraint().length() <= 2) continue;
                ++n2;
            }
        }
        if (n2 > 0) {
            UIUtil.SSR_NOTIFICATION_GROUP.createNotification(NotificationType.WARNING).setTitle(SSRBundle.message("import.template.script.warning.title", new Object[0])).setContent(SSRBundle.message("import.template.script.warning", ApplicationNamesInfo.getInstance().getFullProductName(), n2)).notify(this.d.getProject());
        }
    }

    public void showFilterPanel(String variableName) {
        this.myFilterPanel.initFilters(UIUtil.getOrAddVariableConstraint(variableName, this.myConfiguration));
        this.setFilterPanelVisible(true);
        this.myConfiguration.setCurrentVariableName(variableName);
    }

    void setFilterPanelVisible(boolean visible) {
        long l2 = v ^ 0x76722B716E19L;
        if (visible) {
            if (!this.myFilterPanel.isInitialized()) {
                this.myFilterPanel.initFilters(UIUtil.getOrAddVariableConstraint("__context__", this.myConfiguration));
            }
            if (!this.isFilterPanelVisible()) {
                this.mySearchEditorPanel.setSecondComponent(this.myFilterPanel.getComponent());
            }
        } else if (this.isFilterPanelVisible()) {
            this.mySearchEditorPanel.setSecondComponent(null);
            this.myConfiguration.setCurrentVariableName(null);
        }
    }

    boolean isFilterPanelVisible() {
        return this.mySearchEditorPanel.getSecondComponent() != null;
    }

    private void a(MatchOptions matchOptions) {
        long l2 = v ^ 0x27B1DEC32F4L;
        ArrayList<String> arrayList = new ArrayList<String>(matchOptions.getUsedVariableNames());
        Collections.sort(arrayList);
        arrayList.remove("__context__");
        arrayList.add(SSRBundle.message("complete.match.variable.name", new Object[0]));
        this.s.setItems(arrayList);
        if (arrayList.size() > 1) {
            this.s.setEnabled(true);
            for (String string : arrayList) {
                MatchVariableConstraint matchVariableConstraint = matchOptions.getVariableConstraint(string);
                if (matchVariableConstraint == null || !matchVariableConstraint.isPartOfSearchResults()) continue;
                this.s.setSelectedItem(string);
                return;
            }
            this.s.setSelectedItem(SSRBundle.message("complete.match.variable.name", new Object[0]));
        } else {
            this.s.setEnabled(false);
        }
    }

    boolean loadConfiguration(String text2) {
        if (text2 == null) {
            return false;
        }
        try {
            Configuration configuration = ConfigurationUtil.fromXml(text2);
            if (configuration == null) {
                return false;
            }
            this.loadConfiguration(configuration);
            this.securityCheck();
        }
        catch (JDOMException jDOMException) {
            ApplicationManager.getApplication().invokeLater(() -> this.reportMessage(jDOMException.getMessage(), false, (JComponent)this.myOptionsToolbar));
        }
        return true;
    }

    public void loadConfiguration(Configuration configuration) {
        SearchScope searchScope;
        long l2 = v ^ 0x2D6C242D365CL;
        this.myConfiguration = this.a(configuration);
        MatchOptions matchOptions = this.myConfiguration.getMatchOptions();
        this.a(matchOptions);
        if (!this.i) {
            this.q.setScopesFromContext();
            searchScope = matchOptions.getScope();
            if (searchScope != null) {
                this.q.setScope(searchScope);
            }
        }
        UIUtil.setContent(this.mySearchCriteriaEdit, matchOptions.getSearchPattern());
        this.j.setSelected(matchOptions.isCaseSensitiveMatch());
        this.myFileTypesComboBox.setSelectedItem(matchOptions.getFileType(), matchOptions.getDialect(), matchOptions.getPatternContext());
        searchScope = this.mySearchCriteriaEdit.getEditor();
        if (searchScope != null) {
            searchScope.putUserData(SubstitutionShortInfoHandler.CURRENT_CONFIGURATION_KEY, (Object)this.myConfiguration);
        }
        PropertiesComponent propertiesComponent = PropertiesComponent.getInstance();
        if (this.myReplace) {
            ReplaceOptions replaceOptions;
            if (configuration instanceof ReplaceConfiguration) {
                replaceOptions = configuration.getReplaceOptions();
                UIUtil.setContent(this.myReplaceCriteriaEdit, replaceOptions.getReplacement());
                this.l.setSelected(replaceOptions.isToShortenFQN());
                this.c.setSelected(replaceOptions.isToReformatAccordingToStyle());
                this.e.setSelected(replaceOptions.isToUseStaticImport());
            } else {
                UIUtil.setContent(this.myReplaceCriteriaEdit, matchOptions.getSearchPattern());
                this.l.setSelected(propertiesComponent.getBoolean(g));
                this.c.setSelected(propertiesComponent.getBoolean(a));
                this.e.setSelected(propertiesComponent.getBoolean(u));
            }
            replaceOptions = this.myReplaceCriteriaEdit.getEditor();
            if (replaceOptions != null) {
                replaceOptions.putUserData(SubstitutionShortInfoHandler.CURRENT_CONFIGURATION_KEY, this.myConfiguration);
            }
            this.myRecursive.setSelected(false);
        } else if (configuration instanceof ReplaceConfiguration) {
            this.myRecursive.setSelected(propertiesComponent.getBoolean(h));
        }
    }

    private void l() {
        Object object;
        long l2 = v ^ 0x2C700CB748E9L;
        MatchOptions matchOptions = this.myConfiguration.getMatchOptions();
        if (!this.i) {
            object = this.q.getScope();
            boolean bl2 = IdeBundle.message((String)"scope.class.hierarchy", (Object[])new Object[0]).equals(object.getDisplayName());
            matchOptions.setScope((SearchScope)(bl2 && !this.m ? GlobalSearchScope.projectScope((Project)this.getProject()) : object));
        }
        matchOptions.setFileType(this.myFileType);
        matchOptions.setDialect(this.myDialect);
        matchOptions.setPatternContext(this.myPatternContext);
        matchOptions.setSearchPattern(this.a(this.mySearchCriteriaEdit));
        matchOptions.setCaseSensitiveMatch(this.j.isSelected());
        if (this.myReplace) {
            object = this.myConfiguration.getReplaceOptions();
            ((ReplaceOptions)object).setReplacement(this.a(this.myReplaceCriteriaEdit));
            ((ReplaceOptions)object).setToShortenFQN(this.l.isSelected());
            ((ReplaceOptions)object).setToReformatAccordingToStyle(this.c.isSelected());
            ((ReplaceOptions)object).setToUseStaticImport(this.e.isSelected());
            matchOptions.setRecursiveSearch(false);
        } else {
            matchOptions.setRecursiveSearch(this.myRecursive.isSelected());
        }
        object = PropertiesComponent.getInstance();
        if (this.myReplace) {
            object.setValue(g, this.l.isSelected());
            object.setValue(a, this.c.isSelected());
            object.setValue(u, this.e.isSelected());
        } else {
            object.setValue(h, this.myRecursive.isSelected());
            object.setValue(o, this.j.isSelected());
        }
    }

    private String a(EditorTextField editorTextField) {
        StructuralSearchProfile structuralSearchProfile = StructuralSearchUtil.getProfileByFileType(this.myFileType);
        assert (structuralSearchProfile != null);
        Document document = editorTextField.getDocument();
        String string = (String)ReadAction.compute(() -> {
            PsiFile psiFile = PsiDocumentManager.getInstance((Project)this.getProject()).getPsiFile(document);
            assert (psiFile != null);
            return structuralSearchProfile.getCodeFragmentText(psiFile);
        });
        return string.isEmpty() ? editorTextField.getText() : string;
    }

    @Nullable
    protected final String getDimensionServiceKey() {
        return null;
    }

    public void dispose() {
        long l2 = v ^ 0x20C19A6FC6DDL;
        if (this.myReplace) {
            this.a(n, k);
        } else {
            this.a(k, n);
        }
        PropertiesComponent propertiesComponent = PropertiesComponent.getInstance();
        propertiesComponent.setValue(r, this.isFilterPanelVisible(), true);
        StructuralSearchPlugin.getInstance(this.getProject()).setDialogVisible(false);
        this.b.cancelAllRequests();
        this.mySearchCriteriaEdit.removeNotify();
        this.myReplaceCriteriaEdit.removeNotify();
        super.dispose();
    }

    private void a(String string, String string2) {
        long l2 = v ^ 0x78DA30D6CFC7L;
        if (this.i) {
            return;
        }
        Dimension dimension = this.getSize();
        DimensionService dimensionService = DimensionService.getInstance();
        Point point = this.getLocation();
        if (point.x < 0) {
            point.x = 0;
        }
        if (point.y < 0) {
            point.y = 0;
        }
        dimensionService.setLocation(k, point, this.getProject());
        dimensionService.setSize(string, dimension, this.getProject());
        Dimension dimension2 = dimensionService.getSize(string2);
        if (dimension2 != null && dimension2.width != dimension.width) {
            dimension2.width = dimension.width;
            dimensionService.setSize(string2, dimension2, this.getProject());
        }
    }

    protected String getHelpId() {
        long l2 = v ^ 0x5F829A3098BDL;
        return "find.structuredSearch";
    }

    static {
        v = com.jetbrains.python.psi.c.a(6801963590068911210L, 2513280725369605494L, MethodHandles.lookup().lookupClass()).a(157175466531088L);
        long l2 = v ^ 0x23A9AAD86ABDL;
        STRUCTURAL_SEARCH_DIALOG = Key.create((String)"STRUCTURAL_SEARCH_DIALOG");
        STRUCTURAL_SEARCH_PATTERN_CONTEXT_ID = Key.create((String)"STRUCTURAL_SEARCH_PATTERN_CONTEXT_ID");
        USER_DEFINED = SSRBundle.message("new.template.defaultname", new Object[0]);
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = v ^ 0x64852A6C7391L;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 1: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchContext";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/structuralsearch/plugin/ui/StructuralSearchDialog";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matchResults";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/structuralsearch/plugin/ui/StructuralSearchDialog";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultTitle";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addMatchHighlights";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class PasteConfigurationAction
    extends AnAction
    implements DumbAware {
        final /* synthetic */ StructuralSearchDialog this$0;
        private static final long a = com.jetbrains.python.psi.c.a(7016724540026773738L, -3722764771867440L, MethodHandles.lookup().lookupClass()).a(239070111598990L);

        PasteConfigurationAction(StructuralSearchDialog structuralSearchDialog) {
            long l2 = a ^ 0x443246059F27L;
            this.this$0 = structuralSearchDialog;
            super(SSRBundle.message("import.template.action", new Object[0]));
        }

        public void actionPerformed(@NotNull AnActionEvent e10) {
            String string;
            long l2 = a ^ 0x2B68083D34B3L;
            if (e10 == null) {
                PasteConfigurationAction.a(0);
            }
            if (!this.this$0.loadConfiguration(string = (String)CopyPasteManager.getInstance().getContents(DataFlavor.stringFlavor))) {
                this.this$0.reportMessage(SSRBundle.message("no.template.found.warning", new Object[0]), false, (JComponent)this.this$0.myOptionsToolbar);
            }
        }

        private static /* synthetic */ void a(int n2) {
            long l2 = a ^ 0x3093B0C0F073L;
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/structuralsearch/plugin/ui/StructuralSearchDialog$PasteConfigurationAction", "actionPerformed"));
        }
    }

    private class CopyConfigurationAction
    extends AnAction
    implements DumbAware {
        final /* synthetic */ StructuralSearchDialog this$0;
        private static final long a = com.jetbrains.python.psi.c.a(-4449012156660024168L, -6349168394839873586L, MethodHandles.lookup().lookupClass()).a(21948690126131L);

        CopyConfigurationAction(StructuralSearchDialog structuralSearchDialog) {
            long l2 = a ^ 0x5BD04EEBF8E0L;
            this.this$0 = structuralSearchDialog;
            super(SSRBundle.message("export.template.action", new Object[0]));
        }

        public void actionPerformed(@NotNull AnActionEvent e10) {
            if (e10 == null) {
                CopyConfigurationAction.a(0);
            }
            CopyPasteManager.getInstance().setContents((Transferable)new TextTransferable(ConfigurationUtil.toXml(this.this$0.myConfiguration)));
        }

        private static /* synthetic */ void a(int n2) {
            long l2 = a ^ 0x691FFC9363A0L;
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/structuralsearch/plugin/ui/StructuralSearchDialog$CopyConfigurationAction", "actionPerformed"));
        }
    }

    private class SwitchAction
    extends AnAction
    implements DumbAware {
        private static final long a = com.jetbrains.python.psi.c.a(5056671716222593464L, 5749621848164146709L, MethodHandles.lookup().lookupClass()).a(210203460885392L);

        SwitchAction() {
            this.a();
        }

        public void actionPerformed(@NotNull AnActionEvent e10) {
            long l2 = a ^ 0x6BBD6AFCE252L;
            if (e10 == null) {
                SwitchAction.a(0);
            }
            StructuralSearchDialog.this.myReplace = !StructuralSearchDialog.this.myReplace;
            StructuralSearchDialog.this.setTitle(StructuralSearchDialog.this.getDefaultTitle());
            StructuralSearchDialog.this.myReplacePanel.setVisible(StructuralSearchDialog.this.myReplace);
            StructuralSearchDialog.this.myRecursive.setVisible(!StructuralSearchDialog.this.myReplace);
            StructuralSearchDialog.this.loadConfiguration(StructuralSearchDialog.this.myConfiguration);
            Dimension dimension = DimensionService.getInstance().getSize(StructuralSearchDialog.this.myReplace ? StructuralSearchDialog.n : StructuralSearchDialog.k);
            if (dimension != null) {
                StructuralSearchDialog.this.setSize(StructuralSearchDialog.this.getSize().width, dimension.height);
            } else {
                StructuralSearchDialog.this.pack();
            }
            this.a();
        }

        private void a() {
            long l2 = a ^ 0x28B42FF6D00L;
            this.getTemplatePresentation().setText(SSRBundle.message(StructuralSearchDialog.this.myReplace ? "switch.to.search.action" : "switch.to.replace.action", new Object[0]));
            ActionManager actionManager = ActionManager.getInstance();
            ShortcutSet shortcutSet = actionManager.getAction("StructuralSearchPlugin.StructuralSearchAction").getShortcutSet();
            ShortcutSet shortcutSet2 = actionManager.getAction("StructuralSearchPlugin.StructuralReplaceAction").getShortcutSet();
            CompositeShortcutSet compositeShortcutSet = StructuralSearchDialog.this.myReplace ? new CompositeShortcutSet(new ShortcutSet[]{shortcutSet, shortcutSet2}) : new CompositeShortcutSet(new ShortcutSet[]{shortcutSet2, shortcutSet});
            this.registerCustomShortcutSet((ShortcutSet)compositeShortcutSet, StructuralSearchDialog.this.getRootPane());
        }

        private static /* synthetic */ void a(int n2) {
            long l2 = a ^ 0x12A12C27FBC7L;
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/structuralsearch/plugin/ui/StructuralSearchDialog$SwitchAction", "actionPerformed"));
        }
    }
}

