/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.plugin.ui;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.find.FindBundle;
import com.intellij.find.FindSettings;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.scopeChooser.ScopeChooserCombo;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.structuralsearch.MalformedPatternException;
import com.intellij.structuralsearch.MatchOptions;
import com.intellij.structuralsearch.Matcher;
import com.intellij.structuralsearch.NoMatchFoundException;
import com.intellij.structuralsearch.PatternContext;
import com.intellij.structuralsearch.SSRBundle;
import com.intellij.structuralsearch.StructuralSearchProfile;
import com.intellij.structuralsearch.StructuralSearchUtil;
import com.intellij.structuralsearch.UnsupportedPatternException;
import com.intellij.structuralsearch.impl.matcher.compiler.PatternCompiler;
import com.intellij.structuralsearch.plugin.StructuralSearchPlugin;
import com.intellij.structuralsearch.plugin.ui.Configuration;
import com.intellij.structuralsearch.plugin.ui.ConfigurationManager;
import com.intellij.structuralsearch.plugin.ui.EditVarConstraintsDialog;
import com.intellij.structuralsearch.plugin.ui.FileTypeInfo;
import com.intellij.structuralsearch.plugin.ui.FileTypeSelector;
import com.intellij.structuralsearch.plugin.ui.SearchCommand;
import com.intellij.structuralsearch.plugin.ui.SearchConfiguration;
import com.intellij.structuralsearch.plugin.ui.SearchContext;
import com.intellij.structuralsearch.plugin.ui.SelectTemplateDialog;
import com.intellij.structuralsearch.plugin.ui.SubstitutionShortInfoHandler;
import com.intellij.structuralsearch.plugin.ui.UIUtil;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.TitledSeparator;
import com.intellij.util.Alarm;
import com.intellij.util.ui.JBUI;
import com.jetbrains.python.psi.c;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class SearchDialog
extends DialogWrapper {
    protected SearchContext searchContext;
    protected Editor searchCriteriaEdit;
    private ScopeChooserCombo d;
    private JCheckBox r;
    private JCheckBox p;
    private FileTypeSelector b;
    private JLabel o;
    private JLabel s;
    protected Configuration myConfiguration;
    private JCheckBox a;
    private final Alarm c;
    public static final String USER_DEFINED;
    private boolean g;
    @NonNls
    private LanguageFileType f;
    private static Language k;
    private static PatternContext h;
    private final boolean e;
    private final boolean m;
    private boolean l;
    private String j;
    private JPanel i;
    private JComponent q;
    private JButton n;
    private static final long z;

    public SearchDialog(SearchContext searchContext) {
        this(searchContext, true, true);
    }

    public SearchDialog(SearchContext searchContext, boolean showScope, boolean runFindActionOnClose) {
        long l2 = z ^ 0x569A45DCEE44L;
        super(searchContext.getProject(), true);
        this.f = StructuralSearchUtil.getDefaultFileType();
        if (showScope) {
            this.setModal(false);
        }
        this.e = showScope;
        this.m = runFindActionOnClose;
        this.searchContext = searchContext;
        this.setTitle(this.getDefaultTitle());
        if (runFindActionOnClose) {
            this.setOKButtonText(FindBundle.message((String)"find.dialog.find.button", (Object[])new Object[0]));
        }
        this.myConfiguration = this.createConfiguration(null);
        this.init();
        this.c = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, this.myDisposable);
        ProjectManager.getInstance().addProjectManagerListener(searchContext.getProject(), new ProjectManagerListener(){
            private static final long a = com.jetbrains.python.psi.c.a(5195776431443013931L, 4797290080422402422L, MethodHandles.lookup().lookupClass()).a(44995849648687L);

            public void projectClosing(@NotNull Project project) {
                if (project == null) {
                    1.a(0);
                }
                SearchDialog.this.close(1);
            }

            private static /* synthetic */ void a(int n2) {
                long l2 = a ^ 0x6F3A65EE0DEFL;
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/structuralsearch/plugin/ui/SearchDialog$1", "projectClosing"));
            }
        });
    }

    public void setUseLastConfiguration(boolean useLastConfiguration) {
        this.g = useLastConfiguration;
    }

    void setSearchPattern(Configuration config) {
        this.setValuesFromConfig(config);
        this.initiateValidation();
    }

    protected Editor createEditor(SearchContext searchContext, String text2) {
        Document document;
        FileTypeInfo fileTypeInfo;
        Editor editor2 = null;
        if (this.b != null && (fileTypeInfo = this.b.getSelectedItem()) != null) {
            document = fileTypeInfo.getFileType();
            Language language = fileTypeInfo.getDialect();
            StructuralSearchProfile structuralSearchProfile = StructuralSearchUtil.getProfileByFileType((LanguageFileType)document);
            if (structuralSearchProfile != null) {
                editor2 = UIUtil.createEditor(searchContext.getProject(), (LanguageFileType)document, language, text2, structuralSearchProfile);
            }
        }
        if (editor2 == null) {
            fileTypeInfo = EditorFactory.getInstance();
            document = fileTypeInfo.createDocument("");
            editor2 = fileTypeInfo.createEditor(document, searchContext.getProject());
            editor2.getSettings().setFoldingOutlineShown(false);
        }
        editor2.getDocument().addDocumentListener(new DocumentListener(){
            private static final long a = com.jetbrains.python.psi.c.a(4651548296438398669L, -6879695987369213512L, MethodHandles.lookup().lookupClass()).a(156005534865018L);

            public void documentChanged(@NotNull DocumentEvent event) {
                if (event == null) {
                    2.a(0);
                }
                SearchDialog.this.initiateValidation();
            }

            private static /* synthetic */ void a(int n2) {
                long l2 = a ^ 0x552152A1D514L;
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/structuralsearch/plugin/ui/SearchDialog$2", "documentChanged"));
            }
        });
        return editor2;
    }

    void initiateValidation() {
        this.c.cancelAllRequests();
        this.c.addRequest(() -> {
            try {
                boolean bl2 = this.isValid();
                boolean bl3 = this.a();
                ApplicationManager.getApplication().invokeLater(() -> {
                    this.n.setEnabled(bl3);
                    this.getOKAction().setEnabled(bl2);
                }, ModalityState.stateForComponent((Component)this.getRootPane()));
            }
            catch (ProcessCanceledException processCanceledException) {
                throw processCanceledException;
            }
            catch (RuntimeException runtimeException) {
                Logger.getInstance(SearchDialog.class).error((Throwable)runtimeException);
            }
        }, 250);
    }

    private boolean a() {
        try {
            return PatternCompiler.compilePattern(this.getProject(), this.myConfiguration.getMatchOptions(), false, false) != null;
        }
        catch (MalformedPatternException malformedPatternException) {
            return false;
        }
    }

    protected void buildOptions(JPanel searchOptions) {
        long l2 = z ^ 0x35DBBFF9B4F6L;
        this.r = new JCheckBox(SSRBundle.message("recursive.matching.checkbox", new Object[0]), true);
        if (this.isRecursiveSearchEnabled()) {
            searchOptions.add(UIUtil.createOptionLine(this.r));
        }
        this.p = new JCheckBox(FindBundle.message((String)"find.options.case.sensitive", (Object[])new Object[0]), true);
        searchOptions.add(UIUtil.createOptionLine(this.p));
        this.b = new FileTypeSelector();
        JLabel jLabel = new JLabel(SSRBundle.message("search.dialog.file.type.label", new Object[0]));
        searchOptions.add(UIUtil.createOptionLine(new JComponent[]{jLabel, this.b}));
        jLabel.setLabelFor((Component)((Object)this.b));
        this.f = UIUtil.detectFileType(this.searchContext);
        this.b.setSelectedItem(this.f, k, h);
        this.b.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e10) {
                if (e10.getStateChange() == 1) {
                    SearchDialog.this.updateEditor();
                    SearchDialog.this.initiateValidation();
                }
            }
        });
    }

    void updateEditor() {
        long l2 = z ^ 0x592FBCE949A5L;
        if (this.i != null) {
            if (this.q != null) {
                this.i.remove(this.q);
            }
            this.disposeEditorContent();
            this.q = this.createEditorContent();
            this.i.add((Component)this.q, "Center");
            this.i.revalidate();
            this.searchCriteriaEdit.putUserData(SubstitutionShortInfoHandler.CURRENT_CONFIGURATION_KEY, (Object)this.myConfiguration);
        }
    }

    protected boolean isRecursiveSearchEnabled() {
        return this.e;
    }

    public void setValuesFromConfig(Configuration configuration) {
        this.myConfiguration = this.createConfiguration(configuration);
        this.setDialogTitle(this.myConfiguration);
        MatchOptions matchOptions = this.myConfiguration.getMatchOptions();
        UIUtil.setContent(this.searchCriteriaEdit, matchOptions.getSearchPattern());
        this.r.setSelected(this.isRecursiveSearchEnabled() && matchOptions.isRecursiveSearch());
        this.p.setSelected(matchOptions.isCaseSensitiveMatch());
        this.b.setSelectedItem(matchOptions.getFileType(), matchOptions.getDialect(), matchOptions.getPatternContext());
        this.searchCriteriaEdit.putUserData(SubstitutionShortInfoHandler.CURRENT_CONFIGURATION_KEY, (Object)this.myConfiguration);
    }

    void setDialogTitle(Configuration configuration) {
        long l2 = z ^ 0x5AF1FC903E19L;
        this.setTitle(this.getDefaultTitle() + " - " + configuration.getName());
    }

    public Configuration createConfiguration(Configuration template) {
        return template == null ? new SearchConfiguration(USER_DEFINED, USER_DEFINED) : new SearchConfiguration(template);
    }

    protected void setText(String text2) {
        this.setTextForEditor(text2, this.searchCriteriaEdit);
    }

    protected final void setTextForEditor(String selection, Editor editor2) {
        Project project = this.searchContext.getProject();
        UIUtil.setContent(editor2, selection);
        Document document = editor2.getDocument();
        editor2.getSelectionModel().setSelection(0, document.getTextLength());
        PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)project);
        psiDocumentManager.commitDocument(document);
        PsiFile psiFile = psiDocumentManager.getPsiFile(document);
        if (psiFile == null) {
            return;
        }
        WriteCommandAction.writeCommandAction((Project)project, (PsiFile[])new PsiFile[]{psiFile}).run(() -> CodeStyleManager.getInstance((Project)project).adjustLineIndent(psiFile, new TextRange(0, document.getTextLength())));
    }

    protected void startSearching() {
        new SearchCommand(this.myConfiguration, this.searchContext).startSearching();
    }

    protected String getDefaultTitle() {
        long l2 = z ^ 0x42FDB4548B12L;
        return SSRBundle.message("structural.search.title", new Object[0]);
    }

    protected JComponent createEditorContent() {
        long l2 = z ^ 0x69357FCB7F1BL;
        JPanel jPanel = new JPanel(new BorderLayout());
        this.searchCriteriaEdit = this.createEditor(this.searchContext, this.j != null ? this.j : "");
        jPanel.add("Center", this.searchCriteriaEdit.getComponent());
        jPanel.setMinimumSize(new Dimension(150, 100));
        JPanel jPanel2 = new JPanel(new FlowLayout(0, 2, 0));
        jPanel2.add(new JLabel(SSRBundle.message("search.template", new Object[0])));
        jPanel2.add(UIUtil.createCompleteMatchInfo(() -> this.myConfiguration));
        jPanel.add("North", jPanel2);
        return jPanel;
    }

    protected int getRowsCount() {
        return 4;
    }

    protected JComponent createCenterPanel() {
        TitledSeparator titledSeparator;
        JPanel jPanel;
        long l2 = z ^ 0xE7E97ED0509L;
        this.i = new JPanel(new BorderLayout());
        this.q = this.createEditorContent();
        this.i.add("Center", this.q);
        this.i.add("South", Box.createVerticalStrut(8));
        JPanel jPanel2 = new JPanel(new BorderLayout());
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.add("Center", this.i);
        jPanel3.add("South", this.d());
        jPanel2.add("Center", jPanel3);
        jPanel3 = new JPanel(new BorderLayout());
        jPanel2.add("South", jPanel3);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new GridLayout(this.getRowsCount(), 1, 0, 0));
        jPanel4.setBorder(IdeBorderFactory.createTitledBorder((String)SSRBundle.message("ssdialog.options.group.border", new Object[0])));
        JPanel jPanel5 = new JPanel(new BorderLayout());
        if (this.e) {
            this.d = new ScopeChooserCombo(this.searchContext.getProject(), true, false, FindSettings.getInstance().getDefaultScopeName());
            Disposer.register((Disposable)this.myDisposable, (Disposable)this.d);
            jPanel = new JPanel(new GridBagLayout());
            titledSeparator = new TitledSeparator(SSRBundle.message("search.dialog.scope.label", new Object[0]), (JComponent)this.d.getComboBox());
            jPanel.add((Component)titledSeparator, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 2, (Insets)JBUI.insetsTop((int)5), 0, 0));
            jPanel.add((Component)this.d, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 2, (Insets)JBUI.insetsLeft((int)10), 0, 0));
            jPanel5.add((Component)jPanel, "South");
            this.d.getComboBox().addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e10) {
                    SearchDialog.this.initiateValidation();
                }
            });
        } else {
            this.d = null;
        }
        this.buildOptions(jPanel4);
        jPanel5.add((Component)jPanel4, "Center");
        jPanel3.add((Component)jPanel5, "Center");
        if (this.m) {
            jPanel = new JPanel(new BorderLayout());
            jPanel.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 0));
            this.a = new JCheckBox(FindBundle.message((String)"find.open.in.new.tab.checkbox", (Object[])new Object[0]));
            this.a.setSelected(FindSettings.getInstance().isShowResultsInSeparateView());
            titledSeparator = ToolWindowManager.getInstance((Project)this.searchContext.getProject()).getToolWindow(ToolWindowId.FIND);
            this.a.setEnabled(titledSeparator != null && titledSeparator.isAvailable());
            jPanel.add((Component)this.a, "East");
            jPanel3.add("South", jPanel);
        }
        this.updateEditor();
        return jPanel2;
    }

    protected JComponent createSouthPanel() {
        long l2 = z ^ 0x7BB4DDF1F58L;
        JPanel jPanel = new JPanel(new BorderLayout(5, 0));
        jPanel.add((Component)super.createSouthPanel(), "North");
        this.s = new JLabel(SSRBundle.message("status.message", new Object[0]));
        jPanel.add((Component)this.s, "West");
        this.o = new JLabel();
        jPanel.add((Component)this.o, "Center");
        this.o.setMinimumSize(new Dimension(0, 0));
        return jPanel;
    }

    private JPanel d() {
        JPanel jPanel = new JPanel(null);
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.add(Box.createHorizontalGlue());
        jPanel.add(this.createJButtonForAction(new AbstractAction(this){
            final /* synthetic */ SearchDialog this$0;
            private static final long a = com.jetbrains.python.psi.c.a(-4149515827486568986L, 5012905075949568604L, MethodHandles.lookup().lookupClass()).a(145887864176145L);
            {
                long l2 = a ^ 0x40DC38FE894L;
                this.this$0 = this$0;
                this.putValue("Name", SSRBundle.message("save.template.text.button", new Object[0]));
            }

            @Override
            public void actionPerformed(ActionEvent e10) {
                Configuration configuration = this.this$0.getConfiguration();
                if (!ConfigurationManager.getInstance(this.this$0.getProject()).showSaveTemplateAsDialog(configuration)) {
                    return;
                }
                this.this$0.setDialogTitle(configuration);
            }
        }));
        jPanel.add(Box.createHorizontalStrut(8));
        this.n = this.createJButtonForAction(new AbstractAction(this){
            final /* synthetic */ SearchDialog this$0;
            private static final long a = com.jetbrains.python.psi.c.a(2634440226591771525L, 3056086944453767065L, MethodHandles.lookup().lookupClass()).a(227543908975006L);
            {
                long l2 = a ^ 0x4F5D70DCEB11L;
                this.this$0 = this$0;
                this.putValue("Name", SSRBundle.message("edit.variables.button", new Object[0]));
            }

            @Override
            public void actionPerformed(ActionEvent e10) {
                new EditVarConstraintsDialog(this.this$0.searchContext.getProject(), this.this$0.myConfiguration, this.this$0.getVariablesFromListeners(), this.this$0.b.getSelectedFileType()).show();
                this.this$0.initiateValidation();
            }
        });
        jPanel.add(this.n);
        jPanel.add(Box.createHorizontalStrut(8));
        jPanel.add(this.createJButtonForAction(new AbstractAction(this){
            final /* synthetic */ SearchDialog this$0;
            private static final long a = com.jetbrains.python.psi.c.a(5026516660693585491L, 6999553250192600559L, MethodHandles.lookup().lookupClass()).a(250979133923258L);
            {
                long l2 = a ^ 0x2954038EF72EL;
                this.this$0 = this$0;
                this.putValue("Name", SSRBundle.message("history.button", new Object[0]));
            }

            @Override
            public void actionPerformed(ActionEvent e10) {
                SelectTemplateDialog selectTemplateDialog = new SelectTemplateDialog(this.this$0.searchContext.getProject(), true, this.this$0.isReplaceDialog());
                if (!selectTemplateDialog.showAndGet()) {
                    return;
                }
                Configuration[] configurationArray = selectTemplateDialog.getSelectedConfigurations();
                if (configurationArray.length == 1) {
                    this.this$0.setSearchPattern(configurationArray[0]);
                    this.this$0.initiateValidation();
                }
            }
        }));
        jPanel.add(Box.createHorizontalStrut(8));
        jPanel.add(this.createJButtonForAction(new AbstractAction(this){
            final /* synthetic */ SearchDialog this$0;
            private static final long a = com.jetbrains.python.psi.c.a(-3544571545381062999L, 2020399396592565860L, MethodHandles.lookup().lookupClass()).a(164400260824833L);
            {
                long l2 = a ^ 0x5C6011399C27L;
                this.this$0 = this$0;
                this.putValue("Name", SSRBundle.message("copy.existing.template.button", new Object[0]));
            }

            @Override
            public void actionPerformed(ActionEvent e10) {
                SelectTemplateDialog selectTemplateDialog = new SelectTemplateDialog(this.this$0.searchContext.getProject(), false, this.this$0.isReplaceDialog());
                if (!selectTemplateDialog.showAndGet()) {
                    return;
                }
                Configuration[] configurationArray = selectTemplateDialog.getSelectedConfigurations();
                if (configurationArray.length == 1) {
                    this.this$0.setSearchPattern(configurationArray[0]);
                }
            }
        }));
        return jPanel;
    }

    protected List<String> getVariablesFromListeners() {
        return SearchDialog.getVarsFrom(this.searchCriteriaEdit);
    }

    protected static List<String> getVarsFrom(Editor searchCriteriaEdit) {
        SubstitutionShortInfoHandler substitutionShortInfoHandler = SubstitutionShortInfoHandler.retrieve(searchCriteriaEdit);
        return substitutionShortInfoHandler == null ? new ArrayList<String>() : new ArrayList<String>(substitutionShortInfoHandler.getVariables());
    }

    public final Project getProject() {
        return this.searchContext.getProject();
    }

    protected boolean isReplaceDialog() {
        return false;
    }

    public void show() {
        StructuralSearchPlugin.getInstance(this.getProject()).setDialogVisible(true);
        if (!this.g) {
            Object object;
            Editor editor2 = this.searchContext.getEditor();
            boolean bl2 = false;
            if (editor2 != null && (object = editor2.getSelectionModel()).hasSelection()) {
                this.setText(object.getSelectedText());
                bl2 = true;
            }
            if (!bl2 && (object = ConfigurationManager.getInstance(this.getProject()).getMostRecentConfiguration()) != null) {
                this.setValuesFromConfig((Configuration)object);
            }
        }
        this.initiateValidation();
        super.show();
    }

    public JComponent getPreferredFocusedComponent() {
        return this.searchCriteriaEdit.getContentComponent();
    }

    protected void doOKAction() {
        long l2 = z ^ 0x54E45AD93D99L;
        this.l = true;
        boolean bl2 = this.isValid();
        this.l = false;
        if (!bl2) {
            return;
        }
        this.c.cancelAllRequests();
        super.doOKAction();
        if (!this.m) {
            return;
        }
        SearchScope searchScope = this.d.getSelectedScope();
        if (searchScope == null) {
            return;
        }
        FindSettings findSettings = FindSettings.getInstance();
        findSettings.setDefaultScopeName(searchScope.getDisplayName());
        findSettings.setShowResultsInSeparateView(this.a.isSelected());
        try {
            this.myConfiguration.removeUnusedVariables();
            ConfigurationManager.getInstance(this.getProject()).addHistoryConfiguration(this.myConfiguration);
            this.startSearching();
        }
        catch (MalformedPatternException malformedPatternException) {
            this.reportMessage(SSRBundle.message("this.pattern.is.malformed.message", malformedPatternException.getMessage()), this.searchCriteriaEdit);
        }
    }

    public Configuration getConfiguration() {
        this.setValuesToConfig(this.myConfiguration);
        return this.myConfiguration;
    }

    protected boolean isValid() {
        long l2 = z ^ 0x69239BAC11A7L;
        try {
            Matcher.validate(this.searchContext.getProject(), this.getConfiguration().getMatchOptions());
        }
        catch (MalformedPatternException malformedPatternException) {
            this.reportMessage(SSRBundle.message("this.pattern.is.malformed.message", malformedPatternException.getMessage() != null ? malformedPatternException.getMessage() : ""), this.searchCriteriaEdit);
            return false;
        }
        catch (UnsupportedPatternException unsupportedPatternException) {
            this.reportMessage(SSRBundle.message("this.pattern.is.unsupported.message", unsupportedPatternException.getMessage()), this.searchCriteriaEdit);
            return false;
        }
        catch (NoMatchFoundException noMatchFoundException) {
            this.reportMessage(noMatchFoundException.getMessage(), this.searchCriteriaEdit);
            return false;
        }
        this.reportMessage("", null);
        return true;
    }

    protected void reportMessage(String message, Editor editor2) {
        com.intellij.util.ui.UIUtil.invokeLaterIfNeeded(() -> {
            this.o.setText(message);
            this.o.setToolTipText(message);
            this.o.revalidate();
            this.s.setLabelFor(editor2 != null ? editor2.getContentComponent() : null);
        });
    }

    protected void setValuesToConfig(Configuration config) {
        long l2 = z ^ 0x42F4B67921C1L;
        MatchOptions matchOptions = config.getMatchOptions();
        if (this.e) {
            boolean bl2 = IdeBundle.message((String)"scope.class.hierarchy", (Object[])new Object[0]).equals(this.d.getSelectedScopeName());
            matchOptions.setScope((SearchScope)(bl2 && !this.l ? GlobalSearchScope.projectScope((Project)this.getProject()) : this.d.getSelectedScope()));
        }
        matchOptions.setRecursiveSearch(this.isRecursiveSearchEnabled() && this.r.isSelected());
        FileTypeInfo fileTypeInfo = this.b.getSelectedItem();
        this.f = fileTypeInfo != null ? fileTypeInfo.getFileType() : null;
        k = fileTypeInfo != null ? fileTypeInfo.getDialect() : null;
        h = fileTypeInfo != null ? fileTypeInfo.getContext() : null;
        matchOptions.setFileType(this.f);
        matchOptions.setDialect(k);
        matchOptions.setPatternContext(h);
        matchOptions.setSearchPattern(this.searchCriteriaEdit.getDocument().getText());
        matchOptions.setCaseSensitiveMatch(this.p.isSelected());
    }

    protected String getDimensionServiceKey() {
        long l2 = z ^ 0x45D13EB5B284L;
        return "#com.intellij.structuralsearch.plugin.ui.SearchDialog";
    }

    public void dispose() {
        this.disposeEditorContent();
        this.c.cancelAllRequests();
        super.dispose();
        StructuralSearchPlugin.getInstance(this.getProject()).setDialogVisible(false);
    }

    protected void disposeEditorContent() {
        this.j = this.searchCriteriaEdit.getDocument().getText();
        PsiFile psiFile = PsiDocumentManager.getInstance((Project)this.searchContext.getProject()).getPsiFile(this.searchCriteriaEdit.getDocument());
        if (psiFile != null) {
            DaemonCodeAnalyzer.getInstance((Project)this.searchContext.getProject()).setHighlightingEnabled(psiFile, true);
        }
        EditorFactory.getInstance().releaseEditor(this.searchCriteriaEdit);
    }

    protected String getHelpId() {
        long l2 = z ^ 0x2370B97D7F6AL;
        return "find.structuredSearch";
    }

    static {
        z = com.jetbrains.python.psi.c.a(-9135701580415034689L, -7087213526200302245L, MethodHandles.lookup().lookupClass()).a(57393336451168L);
        long l2 = z ^ 0x23AB55BB7F43L;
        USER_DEFINED = SSRBundle.message("new.template.defaultname", new Object[0]);
        k = null;
        h = null;
    }
}

