/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.impl.matcher.compiler;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.structuralsearch.impl.matcher.CompiledPattern;
import com.intellij.structuralsearch.impl.matcher.compiler.CompileContext;
import com.intellij.structuralsearch.impl.matcher.compiler.GlobalCompilingVisitor;
import com.intellij.structuralsearch.impl.matcher.compiler.OptimizingSearchHelper;
import com.intellij.structuralsearch.impl.matcher.handlers.SubstitutionHandler;
import com.intellij.structuralsearch.impl.matcher.predicates.RegExpPredicate;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public interface WordOptimizer {
    default public boolean handleWord(@Nullable String text2, GlobalCompilingVisitor.OccurenceKind kind, CompileContext compileContext) {
        OptimizingSearchHelper optimizingSearchHelper = compileContext.getSearchHelper();
        if (!optimizingSearchHelper.doOptimizing()) {
            return false;
        }
        if (text2 == null) {
            return true;
        }
        for (String string : StringUtil.getWordsInStringLongestFirst((String)text2)) {
            CompiledPattern compiledPattern = compileContext.getPattern();
            if (compiledPattern.isTypedVar(string)) {
                SubstitutionHandler substitutionHandler = (SubstitutionHandler)compiledPattern.getHandler(string);
                if (substitutionHandler == null || substitutionHandler.getMinOccurs() == 0) {
                    return false;
                }
                RegExpPredicate regExpPredicate = substitutionHandler.findRegExpPredicate();
                if (regExpPredicate == null || !regExpPredicate.couldBeOptimized()) continue;
                if (substitutionHandler.isStrictSubtype() || substitutionHandler.isSubtype()) {
                    List<String> list2 = this.getDescendantsOf(regExpPredicate.getRegExp(), substitutionHandler.isSubtype(), compileContext.getProject());
                    for (String string2 : list2) {
                        optimizingSearchHelper.addWordToSearchInCode(string2);
                    }
                    optimizingSearchHelper.endTransaction();
                    continue;
                }
                GlobalCompilingVisitor.addFilesToSearchForGivenWord(regExpPredicate.getRegExp(), true, kind, compileContext);
                continue;
            }
            GlobalCompilingVisitor.addFilesToSearchForGivenWord(string, true, kind, compileContext);
        }
        return true;
    }

    default public List<String> getDescendantsOf(String className, boolean includeSelf, Project project) {
        return Collections.emptyList();
    }
}

