/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coverage;

import com.intellij.CommonBundle;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.coverage.BaseCoverageSuite;
import com.intellij.coverage.CoverageDataManager;
import com.intellij.coverage.CoverageEngine;
import com.intellij.coverage.CoverageFileProvider;
import com.intellij.coverage.CoverageOptionsProvider;
import com.intellij.coverage.CoverageRunner;
import com.intellij.coverage.CoverageRunnerData;
import com.intellij.coverage.CoverageSuite;
import com.intellij.coverage.CoverageSuiteListener;
import com.intellij.coverage.CoverageSuitesBundle;
import com.intellij.coverage.DefaultCoverageFileProvider;
import com.intellij.coverage.SrcFileAnnotator;
import com.intellij.coverage.view.CoverageViewManager;
import com.intellij.coverage.view.CoverageViewSuiteListener;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.configurations.coverage.CoverageEnabledConfiguration;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.ide.projectView.ProjectView;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.colors.EditorColorsListener;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.event.EditorFactoryEvent;
import com.intellij.openapi.editor.event.EditorFactoryListener;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileContentsChangedAdapter;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.rt.coverage.data.ClassData;
import com.intellij.rt.coverage.data.LineData;
import com.intellij.rt.coverage.data.ProjectData;
import com.intellij.util.Alarm;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.python.psi.c;
import java.io.File;
import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CoverageDataManagerImpl
extends CoverageDataManager {
    private static final String j = "&Replace active suites";
    private static final String h = "&Add to active suites";
    private static final String e = "Do not apply &collected coverage";
    private final List<CoverageSuiteListener> g;
    private static final Logger o;
    @NonNls
    private static final String n = "SUITE";
    private final Project a;
    private final Set<CoverageSuite> b;
    private boolean f;
    private final Object c;
    private boolean p;
    private final VirtualFileContentsChangedAdapter k;
    private Set<LocalFileSystem.WatchRequest> l;
    private List<String> i;
    private CoverageSuitesBundle m;
    private final Object d;
    private final Map<Editor, SrcFileAnnotator> q;
    private static final long s;

    @Override
    public CoverageSuitesBundle getCurrentSuitesBundle() {
        return this.m;
    }

    public CoverageDataManagerImpl(@NotNull Project project) {
        if (project == null) {
            CoverageDataManagerImpl.b(0);
        }
        this.g = ContainerUtil.createLockFreeCopyOnWriteList();
        this.b = new HashSet<CoverageSuite>();
        this.f = false;
        this.c = new Object();
        this.k = new VirtualFileContentsChangedAdapter(){
            private static final long a = com.jetbrains.python.psi.c.a(1410713598579707864L, 242146796464385752L, MethodHandles.lookup().lookupClass()).a(148115729855186L);

            protected void onFileChange(@NotNull VirtualFile fileOrDirectory) {
                if (fileOrDirectory == null) {
                    1.a(0);
                }
                if (CoverageDataManagerImpl.this.i != null && VfsUtilCore.isUnder((String)fileOrDirectory.getPath(), (Collection)CoverageDataManagerImpl.this.i)) {
                    CoverageDataManagerImpl.this.m.restoreCoverageData();
                    CoverageDataManagerImpl.this.a(CoverageDataManagerImpl.this.m);
                }
            }

            protected void onBeforeFileChange(@NotNull VirtualFile fileOrDirectory) {
                if (fileOrDirectory == null) {
                    1.a(1);
                }
            }

            private static /* synthetic */ void a(int n2) {
                Object[] objectArray;
                long l2 = a ^ 0x596DB90E85DL;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "fileOrDirectory";
                objectArray2[1] = "com/intellij/coverage/CoverageDataManagerImpl$1";
                switch (n2) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onFileChange";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onBeforeFileChange";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        this.d = new Object();
        this.q = new HashMap<Editor, SrcFileAnnotator>();
        this.a = project;
        MessageBusConnection messageBusConnection = project.getMessageBus().connect();
        messageBusConnection.subscribe(EditorColorsManager.TOPIC, (Object)new EditorColorsListener(){

            public void globalSchemeChange(EditorColorsScheme scheme) {
                CoverageDataManagerImpl.this.chooseSuitesBundle(CoverageDataManagerImpl.this.m);
            }
        });
        messageBusConnection.subscribe(ProjectManager.TOPIC, (Object)new ProjectManagerListener(){
            private static final long a = com.jetbrains.python.psi.c.a(-5448759186346632553L, 4906698843575339067L, MethodHandles.lookup().lookupClass()).a(89396131772273L);

            public void projectOpened(@NotNull Project project) {
                if (project == null) {
                    3.a(0);
                }
                if (project == CoverageDataManagerImpl.this.a) {
                    EditorFactory.getInstance().addEditorFactoryListener((EditorFactoryListener)new CoverageEditorFactoryListener(), (Disposable)CoverageDataManagerImpl.this.a);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void projectClosing(@NotNull Project project) {
                if (project == null) {
                    3.a(1);
                }
                if (project != CoverageDataManagerImpl.this.a) {
                    return;
                }
                Object object = CoverageDataManagerImpl.this.c;
                synchronized (object) {
                    CoverageDataManagerImpl.this.f = true;
                }
            }

            private static /* synthetic */ void a(int n2) {
                Object[] objectArray;
                long l2 = a ^ 0x3A5D72C7E268L;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "project";
                objectArray2[1] = "com/intellij/coverage/CoverageDataManagerImpl$3";
                switch (n2) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "projectOpened";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "projectClosing";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        CoverageViewSuiteListener coverageViewSuiteListener = this.createCoverageViewListener();
        if (coverageViewSuiteListener != null) {
            this.addSuiteListener(coverageViewSuiteListener, (Disposable)this.a);
        }
    }

    @Nullable
    protected CoverageViewSuiteListener createCoverageViewListener() {
        return new CoverageViewSuiteListener(this, this.a);
    }

    public void readExternal(Element element) throws InvalidDataException {
        long l2 = s ^ 0x4902F7F10630L;
        for (Element element2 : element.getChildren(n)) {
            Object object;
            CoverageRunner coverageRunner = BaseCoverageSuite.readRunnerAttribute(element2);
            if (coverageRunner == null) {
                object = BaseCoverageSuite.readDataFileProviderAttribute(element2);
                if (!object.isValid()) continue;
                continue;
            }
            object = null;
            for (CoverageEngine coverageEngine : (CoverageEngine[])CoverageEngine.EP_NAME.getExtensions()) {
                if (!coverageRunner.acceptsCoverageEngine(coverageEngine) || (object = coverageEngine.createEmptyCoverageSuite(coverageRunner)) == null) continue;
                if (!(object instanceof BaseCoverageSuite)) break;
                ((BaseCoverageSuite)object).setProject(this.a);
                break;
            }
            if (object == null) continue;
            try {
                object.readExternal(element2);
                this.b.add((CoverageSuite)object);
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }

    public void writeExternal(Element element) throws WriteExternalException {
        long l2 = s ^ 0x1E9DCEB7E083L;
        for (CoverageSuite coverageSuite : this.b) {
            Element element2 = new Element(n);
            element.addContent(element2);
            coverageSuite.writeExternal(element2);
        }
    }

    @Override
    public CoverageSuite addCoverageSuite(String name, CoverageFileProvider fileProvider, String[] filters, long lastCoverageTimeStamp, @Nullable String suiteToMergeWith, CoverageRunner coverageRunner, boolean collectLineInfo, boolean tracingEnabled) {
        CoverageSuite coverageSuite = this.a(coverageRunner, name, fileProvider, filters, lastCoverageTimeStamp, suiteToMergeWith, collectLineInfo, tracingEnabled);
        if (suiteToMergeWith == null || !name.equals(suiteToMergeWith)) {
            this.removeCoverageSuite(coverageSuite);
        }
        this.b.remove(coverageSuite);
        this.b.add(coverageSuite);
        return coverageSuite;
    }

    @Override
    public CoverageSuite addExternalCoverageSuite(String selectedFileName, long timeStamp, CoverageRunner coverageRunner, CoverageFileProvider fileProvider) {
        CoverageSuite coverageSuite = this.a(coverageRunner, selectedFileName, fileProvider, ArrayUtilRt.EMPTY_STRING_ARRAY, timeStamp, null, false, false);
        this.b.add(coverageSuite);
        return coverageSuite;
    }

    @Override
    public CoverageSuite addCoverageSuite(CoverageEnabledConfiguration config) {
        long l2 = s ^ 0x2B295DC2A397L;
        String string = config.getName() + " Coverage Results";
        String string2 = config.getCoverageFilePath();
        assert (string2 != null);
        CoverageRunner coverageRunner = config.getCoverageRunner();
        o.assertTrue(coverageRunner != null, (Object)("Coverage runner id = " + config.getRunnerId()));
        DefaultCoverageFileProvider defaultCoverageFileProvider = new DefaultCoverageFileProvider(new File(string2));
        CoverageSuite coverageSuite = CoverageDataManagerImpl.a(config, string, coverageRunner, defaultCoverageFileProvider);
        this.removeCoverageSuite(coverageSuite);
        this.b.add(coverageSuite);
        return coverageSuite;
    }

    @Override
    public void removeCoverageSuite(CoverageSuite suite) {
        suite.deleteCachedCoverageData();
        this.b.remove(suite);
        if (this.m != null && this.m.contains(suite)) {
            Object[] objectArray = this.m.getSuites();
            this.chooseSuitesBundle((objectArray = (CoverageSuite[])ArrayUtil.remove((Object[])objectArray, (Object)suite)).length > 0 ? new CoverageSuitesBundle((CoverageSuite[])objectArray) : null);
        }
    }

    @Override
    @NotNull
    public CoverageSuite[] getSuites() {
        CoverageSuite[] coverageSuiteArray = this.b.toArray(new CoverageSuite[0]);
        if (coverageSuiteArray == null) {
            CoverageDataManagerImpl.b(1);
        }
        return coverageSuiteArray;
    }

    @Override
    public void chooseSuitesBundle(CoverageSuitesBundle suite) {
        if (this.m == suite && suite == null) {
            return;
        }
        if (this.l != null) {
            LocalFileSystem.getInstance().removeWatchedRoots(this.l);
            VirtualFileManager.getInstance().removeVirtualFileListener((VirtualFileListener)this.k);
            this.l = null;
            this.i = null;
        }
        this.a(suite);
    }

    private void a(CoverageSuitesBundle coverageSuitesBundle) {
        o.assertTrue(!this.a.isDefault());
        this.fireBeforeSuiteChosen();
        this.p = false;
        if (this.m != null) {
            this.m.getCoverageEngine().getCoverageAnnotator(this.a).onSuiteChosen(coverageSuitesBundle);
        }
        this.m = coverageSuitesBundle;
        this.disposeAnnotators();
        if (coverageSuitesBundle == null) {
            this.triggerPresentationUpdate();
            return;
        }
        for (CoverageSuite coverageSuite : this.m.getSuites()) {
            boolean bl2 = coverageSuite.getCoverageDataFileProvider().ensureFileExists();
            if (bl2) continue;
            this.chooseSuitesBundle(null);
            return;
        }
        this.renewCoverageData(coverageSuitesBundle);
        this.fireAfterSuiteChosen();
    }

    @Override
    public void coverageGathered(@NotNull CoverageSuite suite) {
        if (suite == null) {
            CoverageDataManagerImpl.b(2);
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            long l2 = s ^ 0x4AB640AEF548L;
            if (this.a.isDisposed()) {
                return;
            }
            if (this.m != null) {
                int n2;
                String[] stringArray;
                String string = CodeInsightBundle.message((String)"display.coverage.prompt", (Object[])new Object[]{suite.getPresentableName()});
                final CoverageOptionsProvider coverageOptionsProvider = CoverageOptionsProvider.getInstance(this.a);
                DialogWrapper.DoNotAskOption doNotAskOption = new DialogWrapper.DoNotAskOption(){
                    private static final long a = com.jetbrains.python.psi.c.a(-3633536100208263994L, -4672239075121325727L, MethodHandles.lookup().lookupClass()).a(279478016382879L);

                    public boolean isToBeShown() {
                        return coverageOptionsProvider.getOptionToReplace() == 3;
                    }

                    public void setToBeShown(boolean value, int exitCode) {
                        coverageOptionsProvider.setOptionsToReplace(value ? 3 : exitCode);
                    }

                    public boolean canBeHidden() {
                        return true;
                    }

                    public boolean shouldSaveOptionsOnCancel() {
                        return true;
                    }

                    @NotNull
                    public String getDoNotShowMessage() {
                        long l2 = a ^ 0x3B28BCC61A80L;
                        String string = CommonBundle.message((String)"dialog.options.do.not.show", (Object[])new Object[0]);
                        if (string == null) {
                            4.a(0);
                        }
                        return string;
                    }

                    private static /* synthetic */ void a(int n2) {
                        long l2 = a ^ 0x10BB2F9CA20DL;
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/coverage/CoverageDataManagerImpl$4", "getDoNotShowMessage"));
                    }
                };
                if (this.m.getCoverageEngine() == suite.getCoverageEngine()) {
                    String[] stringArray2 = new String[3];
                    stringArray2[0] = j;
                    stringArray2[1] = h;
                    stringArray = stringArray2;
                    stringArray2[2] = e;
                } else {
                    String[] stringArray3 = new String[2];
                    stringArray3[0] = j;
                    stringArray = stringArray3;
                    stringArray3[1] = e;
                }
                String[] stringArray4 = stringArray;
                int n3 = n2 = doNotAskOption.isToBeShown() ? Messages.showDialog((String)string, (String)CodeInsightBundle.message((String)"code.coverage", (Object[])new Object[0]), (String[])stringArray4, (int)1, (Icon)Messages.getQuestionIcon(), (DialogWrapper.DoNotAskOption)doNotAskOption) : coverageOptionsProvider.getOptionToReplace();
                if (n2 == 0) {
                    this.chooseSuitesBundle(new CoverageSuitesBundle(suite));
                } else if (n2 == 1) {
                    this.chooseSuitesBundle(new CoverageSuitesBundle((CoverageSuite[])ArrayUtil.append((Object[])this.m.getSuites(), (Object)suite)));
                }
            } else {
                this.chooseSuitesBundle(new CoverageSuitesBundle(suite));
            }
        });
    }

    @Override
    public void triggerPresentationUpdate() {
        this.b();
        UIUtil.invokeLaterIfNeeded(() -> {
            if (this.a.isDisposed()) {
                return;
            }
            ProjectView.getInstance((Project)this.a).refresh();
            CoverageViewManager.getInstance(this.a).setReady(true);
        });
    }

    @Override
    public void attachToProcess(@NotNull ProcessHandler handler, final @NotNull RunConfigurationBase configuration, final RunnerSettings runnerSettings) {
        if (handler == null) {
            CoverageDataManagerImpl.b(3);
        }
        if (configuration == null) {
            CoverageDataManagerImpl.b(4);
        }
        handler.addProcessListener((ProcessListener)new ProcessAdapter(){
            private static final long a = com.jetbrains.python.psi.c.a(-6705314404941705717L, 3937467356996631203L, MethodHandles.lookup().lookupClass()).a(177588846157565L);

            public void processTerminated(@NotNull ProcessEvent event) {
                if (event == null) {
                    5.a(0);
                }
                CoverageDataManagerImpl.this.processGatheredCoverage(configuration, runnerSettings);
            }

            private static /* synthetic */ void a(int n2) {
                long l2 = a ^ 0x4D1A3E6FA60AL;
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/coverage/CoverageDataManagerImpl$5", "processTerminated"));
            }
        });
    }

    @Override
    public void processGatheredCoverage(@NotNull RunConfigurationBase configuration, RunnerSettings runnerSettings) {
        if (configuration == null) {
            CoverageDataManagerImpl.b(5);
        }
        if (runnerSettings instanceof CoverageRunnerData) {
            CoverageDataManagerImpl.processGatheredCoverage(configuration);
        }
    }

    public void addRootsToWatch(List<? extends CoverageSuite> suites) {
        this.i = ContainerUtil.map(suites, coverageSuite -> coverageSuite.getCoverageDataFileName());
        LocalFileSystem localFileSystem = LocalFileSystem.getInstance();
        this.i.forEach(string -> localFileSystem.refreshAndFindFileByPath(string));
        this.l = localFileSystem.addRootsToWatch(this.i, true);
        VirtualFileManager.getInstance().addVirtualFileListener((VirtualFileListener)this.k);
    }

    public static void processGatheredCoverage(RunConfigurationBase configuration) {
        Project project = configuration.getProject();
        if (project.isDisposed()) {
            return;
        }
        CoverageDataManager coverageDataManager = CoverageDataManager.getInstance(project);
        CoverageEnabledConfiguration coverageEnabledConfiguration = CoverageEnabledConfiguration.getOrCreate(configuration);
        CoverageSuite coverageSuite = coverageEnabledConfiguration.getCurrentCoverageSuite();
        if (coverageSuite != null) {
            ((BaseCoverageSuite)coverageSuite).setConfiguration(configuration);
            coverageDataManager.coverageGathered(coverageSuite);
        }
    }

    protected void renewCoverageData(@NotNull CoverageSuitesBundle suite) {
        if (suite == null) {
            CoverageDataManagerImpl.b(6);
        }
        if (this.m != null) {
            this.m.getCoverageEngine().getCoverageAnnotator(this.a).renewCoverageData(suite, this);
        }
    }

    private void b() {
        VirtualFile[] virtualFileArray;
        FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)this.a);
        for (VirtualFile virtualFile : virtualFileArray = fileEditorManager.getOpenFiles()) {
            FileEditor[] fileEditorArray = fileEditorManager.getAllEditors(virtualFile);
            this.a(fileEditorArray, virtualFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(FileEditor[] fileEditorArray, VirtualFile virtualFile) {
        PsiFile psiFile = (PsiFile)this.doInReadActionIfProjectOpen(() -> PsiManager.getInstance((Project)this.a).findFile(virtualFile));
        if (psiFile != null && this.m != null && psiFile.isPhysical()) {
            SrcFileAnnotator srcFileAnnotator;
            Object object;
            Editor editor2;
            CoverageEngine coverageEngine = this.m.getCoverageEngine();
            if (!coverageEngine.coverageEditorHighlightingApplicableTo(psiFile)) {
                return;
            }
            for (FileEditor fileEditor : fileEditorArray) {
                if (!(fileEditor instanceof TextEditor)) continue;
                editor2 = ((TextEditor)fileEditor).getEditor();
                object = this.d;
                synchronized (object) {
                    srcFileAnnotator = this.q.remove(editor2);
                }
                if (srcFileAnnotator == null) break;
                Disposer.dispose((Disposable)srcFileAnnotator);
                break;
            }
            for (FileEditor fileEditor : fileEditorArray) {
                if (!(fileEditor instanceof TextEditor)) continue;
                editor2 = ((TextEditor)fileEditor).getEditor();
                srcFileAnnotator = this.getAnnotator(editor2);
                if (srcFileAnnotator == null) {
                    srcFileAnnotator = new SrcFileAnnotator(psiFile, editor2);
                    object = this.d;
                    synchronized (object) {
                        this.q.put(editor2, srcFileAnnotator);
                    }
                }
                if (this.m == null || !coverageEngine.acceptedByFilters(psiFile, this.m)) continue;
                srcFileAnnotator.showCoverageInformation(this.m);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T doInReadActionIfProjectOpen(Computable<T> computation) {
        Object object = this.c;
        synchronized (object) {
            if (this.f) {
                return null;
            }
        }
        return (T)ApplicationManager.getApplication().runReadAction(computation);
    }

    @Override
    public void selectSubCoverage(@NotNull CoverageSuitesBundle suite, List<String> testNames) {
        long l2 = s ^ 0x296C69368535L;
        if (suite == null) {
            CoverageDataManagerImpl.b(7);
        }
        suite.restoreCoverageData();
        ProjectData projectData = suite.getCoverageData();
        if (projectData == null) {
            return;
        }
        this.p = true;
        HashMap<String, Set<Integer>> hashMap = new HashMap<String, Set<Integer>>();
        for (CoverageSuite coverageSuite : suite.getSuites()) {
            suite.getCoverageEngine().collectTestLines(testNames, coverageSuite, hashMap);
        }
        ProjectData projectData2 = new ProjectData();
        for (String string : hashMap.keySet()) {
            Object object2;
            CoverageSuite coverageSuite;
            coverageSuite = projectData2.getClassData(string);
            if (coverageSuite == null) {
                coverageSuite = projectData2.getOrCreateClassData(string);
            }
            Set set = (Set)hashMap.get(string);
            ClassData classData = projectData.getClassData(string);
            o.assertTrue(classData != null, (Object)("missed className: \"" + string + "\""));
            Object[] objectArray = classData.getLines();
            o.assertTrue(objectArray != null);
            int n2 = objectArray.length;
            for (Object object2 : set) {
                if ((Integer)object2 < n2) continue;
                n2 = (Integer)object2 + 1;
            }
            LineData[] lineDataArray = new LineData[n2];
            object2 = set.iterator();
            while (object2.hasNext()) {
                LineData lineData;
                Integer n3 = (Integer)object2.next();
                int n4 = n3 - 1;
                String string2 = null;
                if (n4 < classData.getLines().length && (lineData = classData.getLineData(n4)) != null) {
                    string2 = lineData.getMethodSignature();
                }
                lineData = new LineData(n4, string2);
                if (string2 != null) {
                    coverageSuite.registerMethodSignature(lineData);
                }
                lineData.setStatus((byte)2);
                lineDataArray[n4] = lineData;
            }
            coverageSuite.setLines(lineDataArray);
        }
        suite.setCoverageData(projectData2);
        this.renewCoverageData(suite);
    }

    @Override
    public void restoreMergedCoverage(@NotNull CoverageSuitesBundle suite) {
        if (suite == null) {
            CoverageDataManagerImpl.b(8);
        }
        this.p = false;
        suite.restoreCoverageData();
        this.renewCoverageData(suite);
    }

    @Override
    public void addSuiteListener(final CoverageSuiteListener listener2, Disposable parentDisposable) {
        this.g.add(listener2);
        Disposer.register((Disposable)parentDisposable, (Disposable)new Disposable(){

            public void dispose() {
                CoverageDataManagerImpl.this.g.remove(listener2);
            }
        });
    }

    public void fireBeforeSuiteChosen() {
        for (CoverageSuiteListener coverageSuiteListener : this.g) {
            coverageSuiteListener.beforeSuiteChosen();
        }
    }

    public void fireAfterSuiteChosen() {
        for (CoverageSuiteListener coverageSuiteListener : this.g) {
            coverageSuiteListener.afterSuiteChosen();
        }
    }

    @Override
    public boolean isSubCoverageActive() {
        return this.p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public SrcFileAnnotator getAnnotator(Editor editor2) {
        Object object = this.d;
        synchronized (object) {
            return this.q.get(editor2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disposeAnnotators() {
        Object object = this.d;
        synchronized (object) {
            for (SrcFileAnnotator srcFileAnnotator : this.q.values()) {
                if (srcFileAnnotator == null) continue;
                Disposer.dispose((Disposable)srcFileAnnotator);
            }
            this.q.clear();
        }
    }

    @NotNull
    private static CoverageSuite a(CoverageEnabledConfiguration coverageEnabledConfiguration, String string, CoverageRunner coverageRunner, DefaultCoverageFileProvider defaultCoverageFileProvider) {
        CoverageEngine coverageEngine;
        long l2 = s ^ 0x1B2ABE6E08D8L;
        CoverageSuite coverageSuite = null;
        CoverageEngine[] coverageEngineArray = (CoverageEngine[])CoverageEngine.EP_NAME.getExtensions();
        int n2 = coverageEngineArray.length;
        for (int i10 = 0; !(i10 >= n2 || coverageRunner.acceptsCoverageEngine(coverageEngine = coverageEngineArray[i10]) && coverageEngine.isApplicableTo(coverageEnabledConfiguration.getConfiguration()) && (coverageSuite = coverageEngine.createCoverageSuite(coverageRunner, string, defaultCoverageFileProvider, coverageEnabledConfiguration)) != null); ++i10) {
        }
        o.assertTrue(coverageSuite != null, (Object)("Cannot create coverage suite for runner: " + coverageRunner.getPresentableName()));
        CoverageSuite coverageSuite2 = coverageSuite;
        if (coverageSuite2 == null) {
            CoverageDataManagerImpl.b(9);
        }
        return coverageSuite2;
    }

    @NotNull
    private CoverageSuite a(CoverageRunner coverageRunner, String string, CoverageFileProvider coverageFileProvider, String[] stringArray, long l2, String string2, boolean bl2, boolean bl3) {
        CoverageEngine coverageEngine;
        long l3 = s ^ 0xD09D8C679E3L;
        CoverageSuite coverageSuite = null;
        CoverageEngine[] coverageEngineArray = (CoverageEngine[])CoverageEngine.EP_NAME.getExtensions();
        int n2 = coverageEngineArray.length;
        for (int i10 = 0; !(i10 >= n2 || coverageRunner.acceptsCoverageEngine(coverageEngine = coverageEngineArray[i10]) && (coverageSuite = coverageEngine.createCoverageSuite(coverageRunner, string, coverageFileProvider, stringArray, l2, string2, bl2, bl3, false, this.a)) != null); ++i10) {
        }
        o.assertTrue(coverageSuite != null, (Object)("Cannot create coverage suite for runner: " + coverageRunner.getPresentableName()));
        CoverageSuite coverageSuite2 = coverageSuite;
        if (coverageSuite2 == null) {
            CoverageDataManagerImpl.b(10);
        }
        return coverageSuite2;
    }

    static {
        s = com.jetbrains.python.psi.c.a(5274503394621758101L, -1309648770480402523L, MethodHandles.lookup().lookupClass()).a(163331435756576L);
        o = Logger.getInstance(CoverageDataManagerImpl.class);
    }

    private static /* synthetic */ void b(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = s ^ 0x44C38E56685FL;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 1: 
            case 9: 
            case 10: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/coverage/CoverageDataManagerImpl";
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suite";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/coverage/CoverageDataManagerImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuites";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createCoverageSuite";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 9: 
            case 10: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "coverageGathered";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "attachToProcess";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "processGatheredCoverage";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "renewCoverageData";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "selectSubCoverage";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "restoreMergedCoverage";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class CoverageEditorFactoryListener
    implements EditorFactoryListener {
        private final Alarm a;
        private final Map<Editor, Runnable> b;
        private static final long c = com.jetbrains.python.psi.c.a(808874289671049094L, -6358078504626628733L, MethodHandles.lookup().lookupClass()).a(102948393437688L);

        private CoverageEditorFactoryListener() {
            this.a = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)CoverageDataManagerImpl.this.a);
            this.b = new HashMap<Editor, Runnable>();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void editorCreated(@NotNull EditorFactoryEvent event) {
            if (event == null) {
                CoverageEditorFactoryListener.a(0);
            }
            Object object = CoverageDataManagerImpl.this.c;
            synchronized (object) {
                if (CoverageDataManagerImpl.this.f) {
                    return;
                }
            }
            object = event.getEditor();
            if (object.getProject() != CoverageDataManagerImpl.this.a) {
                return;
            }
            PsiFile psiFile = (PsiFile)ReadAction.compute(() -> this.a((Editor)object));
            if (psiFile != null && CoverageDataManagerImpl.this.m != null && psiFile.isPhysical()) {
                CoverageEngine coverageEngine = CoverageDataManagerImpl.this.m.getCoverageEngine();
                if (!coverageEngine.coverageEditorHighlightingApplicableTo(psiFile)) {
                    return;
                }
                SrcFileAnnotator srcFileAnnotator = CoverageDataManagerImpl.this.getAnnotator((Editor)object);
                if (srcFileAnnotator == null) {
                    srcFileAnnotator = new SrcFileAnnotator(psiFile, (Editor)object);
                }
                SrcFileAnnotator srcFileAnnotator2 = srcFileAnnotator;
                Object object2 = CoverageDataManagerImpl.this.d;
                synchronized (object2) {
                    CoverageDataManagerImpl.this.q.put(object, srcFileAnnotator2);
                }
                object2 = () -> {
                    if (CoverageDataManagerImpl.this.a.isDisposed()) {
                        return;
                    }
                    if (CoverageDataManagerImpl.this.m != null && coverageEngine.acceptedByFilters(psiFile, CoverageDataManagerImpl.this.m)) {
                        srcFileAnnotator2.showCoverageInformation(CoverageDataManagerImpl.this.m);
                    }
                };
                this.b.put((Editor)object, (Runnable)object2);
                this.a.addRequest((Runnable)object2, 100);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void editorReleased(@NotNull EditorFactoryEvent event) {
            Object object;
            Editor editor2;
            if (event == null) {
                CoverageEditorFactoryListener.a(1);
            }
            if ((editor2 = event.getEditor()).getProject() != CoverageDataManagerImpl.this.a) {
                return;
            }
            try {
                Object object2 = CoverageDataManagerImpl.this.d;
                synchronized (object2) {
                    object = (SrcFileAnnotator)CoverageDataManagerImpl.this.q.remove(editor2);
                }
                if (object != null) {
                    Disposer.dispose((Disposable)object);
                }
            }
            finally {
                object = this.b.remove(editor2);
                if (object != null) {
                    this.a.cancelRequest((Runnable)object);
                }
            }
        }

        private /* synthetic */ PsiFile a(Editor editor2) throws RuntimeException {
            if (CoverageDataManagerImpl.this.a.isDisposed()) {
                return null;
            }
            PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)CoverageDataManagerImpl.this.a);
            Document document = editor2.getDocument();
            return psiDocumentManager.getPsiFile(document);
        }

        private static /* synthetic */ void a(int n2) {
            Object[] objectArray;
            long l2 = c ^ 0x4CF3DBCF1AB3L;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "event";
            objectArray2[1] = "com/intellij/coverage/CoverageDataManagerImpl$CoverageEditorFactoryListener";
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "editorCreated";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "editorReleased";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

