/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.codeInsight.daemon.ImplicitUsageProvider;
import com.intellij.codeInsight.daemon.impl.analysis.XmlHighlightVisitor;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.XmlInspectionGroupNames;
import com.intellij.codeInspection.XmlSuppressableInspectionTool;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.XmlElementVisitor;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.URLReference;
import com.intellij.psi.impl.source.xml.SchemaPrefix;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import com.intellij.xml.DefaultXmlExtension;
import com.intellij.xml.XmlBundle;
import com.intellij.xml.util.XmlRefCountHolder;
import com.intellij.xml.util.XmlUtil;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlUnusedNamespaceInspection
extends XmlSuppressableInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            XmlUnusedNamespaceInspection.$$$reportNull$$$0(0);
        }
        XmlElementVisitor xmlElementVisitor = new XmlElementVisitor(){

            public void visitXmlAttribute(XmlAttribute attribute) {
                PsiFile file = holder.getFile();
                if (!(file instanceof XmlFile)) {
                    return;
                }
                XmlRefCountHolder refCountHolder = XmlRefCountHolder.getRefCountHolder((XmlFile)file);
                if (refCountHolder == null) {
                    return;
                }
                if (!attribute.isNamespaceDeclaration()) {
                    XmlUnusedNamespaceInspection.checkUnusedLocations(attribute, holder, refCountHolder);
                    return;
                }
                String namespace = attribute.getValue();
                String declaredPrefix = XmlUnusedNamespaceInspection.getDeclaredPrefix(attribute);
                if (namespace != null && !refCountHolder.isInUse(declaredPrefix)) {
                    for (ImplicitUsageProvider provider : ImplicitUsageProvider.EP_NAME.getExtensionList()) {
                        if (!provider.isImplicitUsage((PsiElement)attribute)) continue;
                        return;
                    }
                    XmlAttributeValue value = attribute.getValueElement();
                    assert (value != null);
                    holder.registerProblem((PsiElement)attribute, XmlBundle.message((String)"xml.inspections.unused.schema.declaration", (Object[])new Object[0]), ProblemHighlightType.LIKE_UNUSED_SYMBOL, new LocalQuickFix[]{new RemoveNamespaceDeclarationFix(declaredPrefix, false, !refCountHolder.isUsedNamespace(namespace))});
                    XmlTag parent = attribute.getParent();
                    if (declaredPrefix.isEmpty()) {
                        XmlAttribute location = XmlUnusedNamespaceInspection.getDefaultLocation(parent);
                        if (location != null) {
                            holder.registerProblem((PsiElement)location, XmlBundle.message((String)"xml.inspections.unused.schema.location", (Object[])new Object[0]), ProblemHighlightType.LIKE_UNUSED_SYMBOL, new LocalQuickFix[]{new RemoveNamespaceDeclarationFix(declaredPrefix, true, true)});
                        }
                    } else if (!refCountHolder.isUsedNamespace(namespace)) {
                        for (PsiReference reference : XmlUnusedNamespaceInspection.getLocationReferences(namespace, parent)) {
                            if (XmlHighlightVisitor.hasBadResolve(reference, false)) continue;
                            holder.registerProblemForReference(reference, ProblemHighlightType.LIKE_UNUSED_SYMBOL, XmlBundle.message((String)"xml.inspections.unused.schema.location", (Object[])new Object[0]), new LocalQuickFix[]{new RemoveNamespaceDeclarationFix(declaredPrefix, true, true)});
                        }
                    }
                }
            }
        };
        if (xmlElementVisitor == null) {
            XmlUnusedNamespaceInspection.$$$reportNull$$$0(1);
        }
        return xmlElementVisitor;
    }

    private static void removeReferencesOrAttribute(PsiReference[] references) {
        if (references.length == 0) {
            return;
        }
        XmlAttributeValue element = (XmlAttributeValue)references[0].getElement();
        XmlAttribute attribute = (XmlAttribute)element.getParent();
        if (element.getReferences().length == references.length) {
            attribute.delete();
            return;
        }
        PsiFile file = element.getContainingFile();
        Project project = file.getProject();
        SmartPsiElementPointer pointer = SmartPointerManager.getInstance((Project)project).createSmartPsiElementPointer((PsiElement)attribute);
        for (PsiReference reference : references) {
            RemoveNamespaceDeclarationFix.removeReferenceText(reference);
        }
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project);
        Document document = documentManager.getDocument(file);
        assert (document != null);
        documentManager.commitDocument(document);
        String trimmed = element.getValue().trim();
        XmlAttribute pointerElement = (XmlAttribute)pointer.getElement();
        assert (pointerElement != null);
        pointerElement.setValue(trimmed);
    }

    private static void checkUnusedLocations(XmlAttribute attribute, ProblemsHolder holder, @NotNull XmlRefCountHolder refCountHolder) {
        if (refCountHolder == null) {
            XmlUnusedNamespaceInspection.$$$reportNull$$$0(2);
        }
        if ("http://www.w3.org/2001/XMLSchema-instance".equals(attribute.getNamespace())) {
            if ("noNamespaceSchemaLocation".equals(attribute.getLocalName())) {
                if (refCountHolder.isInUse("")) {
                    return;
                }
                holder.registerProblem((PsiElement)attribute, XmlBundle.message((String)"xml.inspections.unused.schema.location", (Object[])new Object[0]), ProblemHighlightType.LIKE_UNUSED_SYMBOL, new LocalQuickFix[]{new RemoveNamespaceLocationFix("")});
            } else if ("schemaLocation".equals(attribute.getLocalName())) {
                XmlAttributeValue value = attribute.getValueElement();
                if (value == null) {
                    return;
                }
                PsiReference[] references = value.getReferences();
                int referencesLength = references.length;
                for (int i = 0; i < referencesLength; ++i) {
                    PsiReference nextRef;
                    PsiReference reference = references[i];
                    if (!(reference instanceof URLReference)) continue;
                    String ns = XmlUnusedNamespaceInspection.getNamespaceFromReference(reference);
                    if (ArrayUtil.indexOf((Object[])attribute.getParent().knownNamespaces(), (Object)ns) != -1 || refCountHolder.isUsedNamespace(ns)) continue;
                    if (!XmlHighlightVisitor.hasBadResolve(reference, false)) {
                        holder.registerProblemForReference(reference, ProblemHighlightType.LIKE_UNUSED_SYMBOL, XmlBundle.message((String)"xml.inspections.unused.schema.location", (Object[])new Object[0]), new LocalQuickFix[]{new RemoveNamespaceLocationFix(ns)});
                    }
                    for (int j = i + 1; j < referencesLength && !((nextRef = references[j]) instanceof URLReference); ++j) {
                        if (XmlHighlightVisitor.hasBadResolve(nextRef, false)) continue;
                        holder.registerProblemForReference(nextRef, ProblemHighlightType.LIKE_UNUSED_SYMBOL, XmlBundle.message((String)"xml.inspections.unused.schema.location", (Object[])new Object[0]), new LocalQuickFix[]{new RemoveNamespaceLocationFix(ns)});
                    }
                }
            }
        }
    }

    private static String getDeclaredPrefix(XmlAttribute attribute) {
        return attribute.getName().contains(":") ? attribute.getLocalName() : "";
    }

    @Nullable
    private static XmlAttribute getDefaultLocation(XmlTag parent) {
        return parent.getAttribute("noNamespaceSchemaLocation", "http://www.w3.org/2001/XMLSchema-instance");
    }

    private static PsiReference[] getLocationReferences(String namespace, XmlTag tag) {
        XmlAttribute locationAttr = tag.getAttribute("schemaLocation", "http://www.w3.org/2001/XMLSchema-instance");
        if (locationAttr == null) {
            return PsiReference.EMPTY_ARRAY;
        }
        XmlAttributeValue value = locationAttr.getValueElement();
        return value == null ? PsiReference.EMPTY_ARRAY : XmlUnusedNamespaceInspection.getLocationReferences(namespace, value);
    }

    private static PsiReference[] getLocationReferences(String namespace, XmlAttributeValue value) {
        PsiReference[] references = value.getReferences();
        int referencesLength = references.length;
        for (int i = 0; i < referencesLength; i += 2) {
            PsiReference reference = references[i];
            if (!namespace.equals(XmlUnusedNamespaceInspection.getNamespaceFromReference(reference))) continue;
            if (i + 1 < referencesLength) {
                return new PsiReference[]{references[i + 1], reference};
            }
            return new PsiReference[]{reference};
        }
        return PsiReference.EMPTY_ARRAY;
    }

    private static String getNamespaceFromReference(PsiReference reference) {
        return reference.getRangeInElement().substring(reference.getElement().getText());
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Nls
    @NotNull
    public String getGroupDisplayName() {
        String string = XmlInspectionGroupNames.XML_INSPECTIONS;
        if (string == null) {
            XmlUnusedNamespaceInspection.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = XmlBundle.message((String)"xml.inspections.unused.schema", (Object[])new Object[0]);
        if (string == null) {
            XmlUnusedNamespaceInspection.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        if ("XmlUnusedNamespaceDeclaration" == null) {
            XmlUnusedNamespaceInspection.$$$reportNull$$$0(5);
        }
        return "XmlUnusedNamespaceDeclaration";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/analysis/XmlUnusedNamespaceInspection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refCountHolder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/analysis/XmlUnusedNamespaceInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "checkUnusedLocations";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class RemoveNamespaceLocationFix
    extends RemoveNamespaceDeclarationFix {
        public static final String NAME = "Remove unused namespace location";

        private RemoveNamespaceLocationFix(String namespace) {
            super(namespace, true, true);
        }

        @Override
        @NotNull
        public String getName() {
            if (NAME == null) {
                RemoveNamespaceLocationFix.$$$reportNull$$$0(0);
            }
            return NAME;
        }

        @Override
        protected void doRemove(Project project, XmlAttribute attribute, XmlTag parent) {
            if (StringUtil.isEmpty((String)this.myPrefix)) {
                attribute.delete();
            } else {
                XmlAttributeValue value = attribute.getValueElement();
                if (value == null) {
                    return;
                }
                PsiReference[] references = XmlUnusedNamespaceInspection.getLocationReferences(this.myPrefix, value);
                XmlUnusedNamespaceInspection.removeReferencesOrAttribute(references);
            }
        }

        @Override
        public boolean equals(Object obj) {
            return this == obj;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/analysis/XmlUnusedNamespaceInspection$RemoveNamespaceLocationFix", "getName"));
        }
    }

    public static class RemoveNamespaceDeclarationFix
    implements LocalQuickFix {
        protected final String myPrefix;
        private final boolean myLocationFix;
        private final boolean myRemoveLocation;

        private RemoveNamespaceDeclarationFix(@Nullable String prefix, boolean locationFix, boolean removeLocation) {
            this.myPrefix = prefix;
            this.myLocationFix = locationFix;
            this.myRemoveLocation = removeLocation;
        }

        @NotNull
        public String getName() {
            String string = XmlBundle.message((String)"xml.inspections.unused.schema.remove", (Object[])new Object[0]);
            if (string == null) {
                RemoveNamespaceDeclarationFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = XmlInspectionGroupNames.XML_INSPECTIONS;
            if (string == null) {
                RemoveNamespaceDeclarationFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                RemoveNamespaceDeclarationFix.$$$reportNull$$$0(2);
            }
            if (descriptor == null) {
                RemoveNamespaceDeclarationFix.$$$reportNull$$$0(3);
            }
            this.doFix(project, descriptor, true);
        }

        @Nullable
        public SmartPsiElementPointer<XmlTag> doFix(Project project, ProblemDescriptor descriptor, boolean reformat) {
            PsiElement element = descriptor.getPsiElement();
            if (element instanceof XmlAttributeValue) {
                element = element.getParent();
            } else if (!(element instanceof XmlAttribute)) {
                return null;
            }
            XmlAttribute attribute = (XmlAttribute)element;
            XmlTag parent = attribute.getParent();
            SmartPsiElementPointer pointer = SmartPointerManager.getInstance((Project)project).createSmartPsiElementPointer((PsiElement)parent);
            this.doRemove(project, attribute, parent);
            if (reformat) {
                RemoveNamespaceDeclarationFix.reformatStartTag(project, (SmartPsiElementPointer<? extends XmlTag>)pointer);
            }
            return pointer;
        }

        public static void reformatStartTag(Project project, SmartPsiElementPointer<? extends XmlTag> pointer) {
            PsiDocumentManager manager = PsiDocumentManager.getInstance((Project)project);
            PsiFile file = pointer.getContainingFile();
            assert (file != null);
            Document document = manager.getDocument(file);
            assert (document != null);
            manager.commitDocument(document);
            XmlTag tag = (XmlTag)pointer.getElement();
            assert (tag != null);
            XmlUtil.reformatTagStart(tag);
        }

        protected void doRemove(Project project, XmlAttribute attribute, XmlTag parent) {
            if (!attribute.isNamespaceDeclaration()) {
                SchemaPrefix schemaPrefix = DefaultXmlExtension.DEFAULT_EXTENSION.getPrefixDeclaration(parent, this.myPrefix);
                if (schemaPrefix != null) {
                    attribute = schemaPrefix.getDeclaration();
                } else {
                    return;
                }
            }
            String namespace = attribute.getValue();
            String prefix = XmlUnusedNamespaceInspection.getDeclaredPrefix(attribute);
            PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project);
            Document document = documentManager.getDocument(parent.getContainingFile());
            assert (document != null);
            attribute.delete();
            if (this.myRemoveLocation) {
                if (prefix.isEmpty()) {
                    XmlAttribute locationAttr = XmlUnusedNamespaceInspection.getDefaultLocation(parent);
                    if (locationAttr != null) {
                        locationAttr.delete();
                    }
                } else {
                    documentManager.doPostponedOperationsAndUnblockDocument(document);
                    PsiReference[] references = XmlUnusedNamespaceInspection.getLocationReferences(namespace, parent);
                    XmlUnusedNamespaceInspection.removeReferencesOrAttribute(references);
                    documentManager.commitDocument(document);
                }
            }
        }

        public static void removeReferenceText(PsiReference ref) {
            PsiElement element = ref.getElement();
            PsiFile file = element.getContainingFile();
            TextRange range = ref.getRangeInElement().shiftRight(element.getTextRange().getStartOffset());
            PsiDocumentManager manager = PsiDocumentManager.getInstance((Project)file.getProject());
            Document document = manager.getDocument(file);
            assert (document != null);
            manager.doPostponedOperationsAndUnblockDocument(document);
            document.deleteString(range.getStartOffset(), range.getEndOffset());
        }

        public boolean equals(Object obj) {
            return obj instanceof RemoveNamespaceDeclarationFix && Comparing.equal((String)this.myPrefix, (String)((RemoveNamespaceDeclarationFix)obj).myPrefix) && (this.myLocationFix || ((RemoveNamespaceDeclarationFix)obj).myLocationFix);
        }

        public int hashCode() {
            return this.myPrefix == null ? 0 : this.myPrefix.hashCode();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/daemon/impl/analysis/XmlUnusedNamespaceInspection$RemoveNamespaceDeclarationFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/daemon/impl/analysis/XmlUnusedNamespaceInspection$RemoveNamespaceDeclarationFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

